#!/usr/bin/python
#
# Semesterarbeit "Ant Based Routing"
# Thomas Heuscher, Thomas Hug
# 4.7.2003


import time, threading, whrandom
from Tkinter import *
from tkSimpleDialog import * 
from ScrolledText import *
import tkMessageBox
import tkFileDialog

# the neighbor objects are in the node classes
# each node has a list neighbors with its neighbors as objects neighbor
class neighbor:
    node = 0
    pheromone =0

class varclass:
    pstart = 0.5      # initial p (exploration)  
    alpha = 0.9       # initial alpha (evaporation)
    speed = 0.9       # initial programm speed

    def __init__(self):
        self.time_start = 0
        self.time_stop = 0
        self.diff = -1

        self.time_tic_lock = 0
        self.time_toc_lock = 0

        self.lock = threading.Lock()

    def tic(self):
        self.lock.acquire()
        if self.time_tic_lock==0:
            self.time_start = time.time()
            self.diff = -1 
            self.time_tic_lock=1
            #print "tic"
        self.lock.release()

    def toc(self):
        self.lock.acquire()
        if self.time_toc_lock==0:
            self.time_stop = time.time()
            self.diff = self.time_stop - self.time_start
            self.time_toc_lock=1
            #print "toc"
        self.lock.release()

    def time_reset(self):
        self.lock.acquire()
        self.time_tic_lock=0
        self.time_toc_lock=0
        self.lock.release()
        self.tic()

# the targetnode has a hitlist, this is of course a list :)
# this following objects are rankings in the hitlist
# we want to know:
# - how long was the ants way (how many hops)
# - how was the way-history
# the ant saved his way already in a list. we therefore only have to point
# this list.
class hit:
    def __init__(self):
        self.hops = 0     # hops
        self.path = 0     # the path list of nodeadresses
        self.timer = 0    # it counts the ants that did not come on this way
        self.counter = 1  # count all ants of this way

class testant(threading.Thread):
    def run(self):
        while guir.on==1:
            time.sleep(0.5)
            if guir.freeze==1:
                continue

            newant(1)

class gui_refresh(threading.Thread):

    def __init__(self):
        threading.Thread.__init__(self)
        self.on=1
        self.freeze=0
        self.killer=0  # if this variable is set to 1, all ants will die
        self.nodelistlock = threading.Lock()
        self.bestlist = []

    def run(self):
        while self.on==1:
            if self.freeze==1:
                continue

            self.nodelistlock.acquire() 
            if len(nodelist)>=2:
                if nodelist[1].getName()=="food":
                    control.displayhit(nodelist[1].hitlist)
                    control.displaybest()
            self.nodelistlock.release()

            control.displaythread()
            control.antstats()
            control.displaypstart()
            control.displaynet(nodelist) # refreshes visualisation of the network in the GUI
            control.watch()
            time.sleep(0.4)

    def stop(self):
        self.on=0

    def freezer(self):
        self.freeze=1

    def go(self):
        self.freeze=0

    def kill(self):
        self.killer=1
        time.sleep(1)
        self.killer=0       

class control(threading.Thread):

    def __init__(self):
        threading.Thread.__init__(self)

        # statistic variables
        self.antalive = 0 # to count the number of ants in the network
        self.antcount = 0 # to count the number of ants ever created
        self.antkills = 0 # to count the number ot ants which are killed
        self.killlock = threading.Lock()
        self.alivelock = threading.Lock()
        self.countlock = threading.Lock()
        

        width=65
        bg='white'
        fg='black'

        ########################################################################
        ### windowparts
        self.threadcount = Text(width=width,height=1,background=bg,foreground=fg)
        self.threadcount.pack()
 
        self.kills = Text(width=width,height=1,background=bg,foreground=fg)
        self.kills.pack()

        self.antnumber = Text(width=width,height=1,background=bg,foreground=fg)
        self.antnumber.pack()

        self.bestlist = Text(width=width,height=2,background=bg,foreground=fg)
        self.bestlist.pack()

        self.hitlist = Text(width=width,height=16,background=bg,foreground=fg)
        self.hitlist.pack()

        self.variablen = Text(width=width,height=5,background=bg,foreground=fg)
        self.variablen.pack()

        self.stopframe = Frame(width=width)
        self.stopwatch = Text(self.stopframe,width=width-8,height=2,background=bg,foreground=fg)
        self.stopwatch.pack(side=LEFT)

        self.stopbutton = Button(self.stopframe, text="Stop", command=self.toc)
        self.stopbutton.pack()

        self.stopframe.pack()
        

        self.network =  Text(width=width,height=18,background=bg,foreground=fg)
        self.network.pack()
        
        ### buttons
        self.button = Button(text="Send Ant", command=self.startnew)
        self.button.pack(side=LEFT)

        self.sendants = Text(width=3,height=1,background=bg,foreground=fg)
        self.sendants.pack(side=LEFT)
        self.sendants.insert(END,1)

        self.button = Button(text="Reset", command=self.reset)
        self.button.pack(side=LEFT)

        self.button = Button(text="Light Reset", command=self.reset_light)
        self.button.pack(side=LEFT)
        
        self.button = Button(text="Freeze", command=self.freeze)
        self.button.pack(side=LEFT)

        self.button = Button(text="Kill", command=self.kill)
        self.button.pack(side=LEFT)

        self.button = Button(text="Exit", command=self.close)
        self.button.pack(side=RIGHT)

        ##########################################################################
        # menu
        self.menubar = Menu(root)

        self.filemenu = Menu(self.menubar)        # pulldown
        self.filemenu.add_command(label='Exit', command=self.close)
        self.menubar.add_cascade(label='File', menu=self.filemenu)


        self.netmenu = Menu(self.menubar)
        self.netmenu.add_command(label='Edit',command=self.networke)
        self.netmenu.add_command(label='Open',command=self.networkopen)
        self.netmenu.add_command(label='Save',command=self.networksave)
        self.menubar.add_cascade(label='Network',menu=self.netmenu)


        self.varmenu = Menu(self.menubar) #Menu to change variables
        self.menubar.add_command(label='Variables',command=self.varchange)

        root.config(menu=self.menubar)

        #####################################################################

    def varchange(self):
        tmp = varcontrol()

    def networkopen(self):
        fn = tkFileDialog.askopenfilename()

        if fn=="":
            return 0

        guir.freezer()

        # remove ants
        self.killer=1
        time.sleep(1)
        self.killer=0

          
        guir.nodelistlock.acquire()
        # remove nodes
        for x in nodelist:
            x.stop()

        for i in range(0,len(nodelist)):
            nodelist.pop()
        load(fn)

        guir.nodelistlock.release()

        guir.go()   # release


    def networksave(self):
        fn = tkFileDialog.asksaveasfilename()

        if fn=="":
            return 0

        save(fn)
    
    def networke(self):
        tmp = networkcontrol()


    # visualisation of the network with the pheromon
    def displaynet(self, nodelist):
        
        self.network.delete(1.0,END)
        self.network.insert(1.0, "Network:\n")
        for node in nodelist:

            printname=str(node.getName())[0:4]
            while len(printname)<4:
                printname=printname + ' '

            self.network.insert(END,printname)
            for neighbor in node.neighbors:
                name=neighbor.node.getName()
                if name=="nest":
                    name="n"
                if name=="food":
                    name="f"

                if neighbor.pheromone>=1000:
                    out='999'
                else:
                    out = str(neighbor.pheromone)

                tmp = name + '(' + out[0:3] + ')'

                while len(tmp)<10:
                    tmp=' ' + tmp

                self.network.insert(END, tmp)
            self.network.insert(END,"\n")
           

    def displaythread(self):
        self.threadcount.delete(1.0,END)
        string='Active Threads: ' + str(threading.activeCount())
        self.threadcount.insert(1.0, string)

    # show the best path and send stats ants
    def displaybest(self):
        self.bestlist.delete(1.0,END)
        self.bestlist.insert(1.0,"Strongest Path:\n")
        mypath=''
        for pathx in guir.bestlist:
            if pathx.getName()=="nest":
                mypath='n'
            else:
                if pathx.getName()=="food":
                    mypath=mypath+'f'
                    break
                else:
                    mypath=mypath + pathx.getName()
            mypath=mypath+ '-'
   
        self.bestlist.insert(END,mypath)


    # Visualisation of the hitlist
    def displayhit(self, list):   
        self.hitlist.delete(1.0,END)
        self.hitlist.insert(1.0,"Hitlist (" + str(len(list)) + "):\n")
        i=0
        for entry in list:
            i+=1
            if i<=15:
                output=str(i) +'. '
                if i<10:
                    output=output+' '
                output=output + 'h: '
                if entry.hops<10:
                    output=output+' '
                output=output + str(entry.hops) + '  w: '

                for pathx in entry.path:
                    if pathx.getName()=="nest":
                        mypath='n'
                    else:
                        if pathx.getName()=="food":
                            mypath=mypath+'f'
                            break
                        else:
                            mypath=mypath + pathx.getName()
                    mypath=mypath+ '-'
                
                mypath=mypath[0:15]
                if len(mypath)<15:
                    for x in range(0,15-len(mypath)):
                        mypath=mypath+' '

                output=output + mypath
                output=output + '  t: '

                for x in range(0,4-len(str(entry.timer))):
                    output=output + ' '

                output=output + str(entry.timer)
                output=output + '  c: '
            
                for x in range(0,5-len(str(entry.counter))):
                    output=output + ' '            

                output=output+ str(entry.counter)

                if control.antcount==0:
                    percent=0
                else:
                    percent=float(entry.counter)/float(self.antcount)*100

                origpercent=percent

                if percent<100.0:
                    if percent>=10:
                        percent=str(percent)
                        percent=percent[0:2]
                        percent=' ' + percent

                    percent=str(percent)
                    output=output + '  p: ' + percent[0:3] + '%'
                else:
                    output=output + '  p: 100%'

                #if origpercent>=(vars.level):
                #    self.hitlist.tag_config("b", foreground='red')
                #    self.hitlist.insert(END,output,"b")

                #else:
                self.hitlist.tag_config("n", foreground='black')
                self.hitlist.insert(END,output,"n")

                self.hitlist.insert(END,"\n")
        

    def displaypstart(self):   # display of variables p,q
        p = 'Exploration p:     ' + str(vars.pstart)
        q = 'Exploitation q:    ' + str(1 - vars.pstart)
        self.variablen.delete(1.0,END)
        self.variablen.insert(1.0,"Variables:\n")
        self.variablen.insert(END, p)
        self.variablen.insert(END,"\n")
        self.variablen.insert(END, q)
        self.variablen.insert(END,"\n")
        self.variablen.insert(END,"Evaporation alpha: ")
        self.variablen.insert(END, vars.alpha)
        self.variablen.insert(END,"\n")
        self.variablen.insert(END,"Program Speed:     ")
        self.variablen.insert(END, vars.speed)


    def watch(self):
        self.stopwatch.delete(1.0,END)
        self.stopwatch.insert(END,'Stopwatch: ')

        diff = time.time() - vars.time_start

        if vars.diff >= 0:
            self.stopwatch.insert(END,str(vars.diff)[0:4] + 's')
        else:
            self.stopwatch.insert(END,str(diff)[0:4] + 's')


    def antstats(self):
        # show the number of killed ants
        self.kills.delete(1.0,END)
        self.kills.insert(1.0,"Kills: ")
        self.kills.insert(END,self.antkills)

        # show ants alive counter
        self.antnumber.delete(1.0,END)
        self.antnumber.insert(1.0,"Ants alive: ")
        self.antnumber.insert(END,self.antalive)

    def killincrease(self):
        self.killlock.acquire() 
        self.antkills+=1
        self.killlock.release()

    def antincrease(self):
        self.alivelock.acquire() 
        self.antalive+=1
        self.alivelock.release()       
    
    def antdecrease(self):
        self.alivelock.acquire() 
        self.antalive-=1
        self.alivelock.release()

    def totalantincrease(self):
        self.countlock.acquire() 
        self.antcount+=1
        self.countlock.release() 
    
    def startnew(self):  # button to start new ant(s)
        sendvalue=int(self.sendants.get(1.0,END))
        self.antincrease()
        vars.time_reset()

        # unlock the freezer if it is freezed
        guir.go()
        
        for i in range(0,sendvalue):
            newant(0)

    def freeze(self):
        if guir.freeze==0:
            guir.freezer()
        else:
            guir.go()

    def toc(self):
        if vars.time_toc_lock==0:
            vars.toc()
        else:
            vars.time_reset()
        

    def kill(self):
        guir.kill()
        
    def reset(self):     # button to reset the hitlist

        # unlock the freezer if it is freezed
        guir.go()

        self.countlock.acquire() 
        self.antcount=0
        self.countlock.release()

        self.killlock.acquire() 
        self.antkills=0
        self.killlock.release()

        if len(nodelist)>=2:
            nodelist[1].hitlist = []

            for node in nodelist:
                for neighbor in node.neighbors:
                    neighbor.pheromone=0.0

        vars.time_reset()

    
    def reset_light(self):     # reset without resetting pheromone
        self.countlock.acquire() 
        self.antcount=0
        self.countlock.release()
        
        self.killlock.acquire() 
        self.antkills=0
        self.killlock.release()

        if len(nodelist)>=2:
            nodelist[1].hitlist = []

        vars.time_reset()

        
    def close(self):     # button to close GUI
        self.freeze()
        guir.killer=1
        time.sleep(0.2)
        guir.stop()
        root.destroy()

#######################################################################
# variables control the variables alpha and p
class varcontrol:
    def __init__(self):
        self.varedit = Toplevel()
        self.varedit.title('Variables Editor')
        self.l =StringVar()  # to save the value for the stop-watch-level
        self.s = StringVar() # to save the value for the speed
        self.v = StringVar() # to save the value for alpha
        self.w = StringVar() # to save the value for p

        myframe = Frame(self.varedit)
        myframe.pack()
        disp = Text(myframe, width=7, height=1, relief='flat')
        disp.pack(side=LEFT)
        disp.insert(END,'alpha=')
        disp.config(state=DISABLED)

        ### alph and p can be one of the following constants
        MODES = [("0.1", "0.1"),("0.2", "0.2"),("0.3", "0.3"),("0.4", "0.4"),("0.5", "0.5"),("0.6", "0.6"),("0.7", "0.7"),("0.8", "0.8"),("0.9", "0.9")]
        ### generates the radiobuttons for alpha
        for text, mode in MODES:
            Radiobutton(myframe, text=text,variable=self.v, value=mode, indicatoron=0, command=self.submitalpha).pack(side=LEFT)

        myframe = Frame(self.varedit)
        myframe.pack()
        disp = Text(myframe, width=7, height=1, relief='flat')
        disp.pack(side=LEFT)
        disp.insert(END,'p=')
        disp.config(state=DISABLED)

        ### generates the radiobuttons for p
        for text, mode in MODES:
            Radiobutton(myframe, text=text,variable=self.w, value=mode, indicatoron=0, command=self.submitp).pack(side=LEFT)

        SPEEDS = [("0.2", "0.2"),("0.5", "0.5"),("0.7", "0.7"),("0.9", "0.9"),("1.0", "1.0")]

        myframe = Frame(self.varedit)
        myframe.pack()
        disp = Text(myframe, width=7, height=1, relief='flat')
        disp.pack(side=LEFT)
        disp.insert(END,'speed=')
        disp.config(state=DISABLED)

        ### generates the radiobuttons for the speeds
        for text, mode in SPEEDS:
            Radiobutton(myframe, text=text,variable=self.s, value=mode, indicatoron=0, command=self.submitspeed).pack(side=LEFT)


        myframe = Frame(self.varedit)
        myframe.pack()
        #disp = Text(myframe, width=11, height=1, relief='flat')
        #disp.pack(side=LEFT)
        #disp.insert(END,'color-level=')
        #disp.config(state=DISABLED)

        LEVELS = [("5%", "5"),("8%", "8"),("10%", "10"),("15%", "15"),("20%", "20"),("25%", "25"),("30%", "30"),("40%", "40"),("50%", "50")]

        ### generates the buttons for the stop-watch-levels
        #for text, mode in LEVELS:
            #Radiobutton(myframe, text=text,variable=self.l, value=mode, indicatoron=0, command=self.submitlevel).pack(side=LEFT)

        myframe = Frame(self.varedit)
        myframe.pack()
        button = Button(myframe, text="Exit", command=self.exit)
        button.pack(side=RIGHT) 


    def submitalpha(self): # submit new choosen value for alpha
        vars.alpha = float(self.v.get())
    def submitp(self): # submit new choosen value for p
        vars.pstart = float(self.w.get())
    def submitspeed(self): # submit new choosen value for the speed
        vars.speed = float(self.s.get())
    def submitlevel(self): # submit new choosen vlaue for the stop-watch-level
        vars.level = float(self.l.get())
    def exit(self):
        self.varedit.destroy()
        
#######################################################################
# network control 
class networkcontrol:

    def __init__(self):
        self.netedit = Toplevel()
        self.netedit.title('Network Editor')
        
        test = Text(self.netedit, width=20, height=2, relief='flat')
        test.pack()
        test.insert(END,'Network:\nChoose for removal')
        test.config(state=DISABLED)

        self.v = StringVar()

        
        for node in nodelist:

            myframe = Frame(self.netedit)
            myframe.pack()

            disp = Text(myframe, width=4, height=1, relief='flat')
            disp.pack(side=LEFT)

            disp.insert(END,node.getName())
            disp.config(state=DISABLED)


            for neighbor in node.neighbors:
                name=neighbor.node.getName()
                if name=="nest":
                    name="n"
                if name=="food":
                    name="f"
                Radiobutton(myframe, text=name, variable=self.v, value=neighbor, indicatoron=0).pack(side=LEFT)


        test = Text(self.netedit, width=20, height=2, relief='flat')
        test.pack()
        test.insert(END,'\nChoose for adding')
        test.config(state=DISABLED)

        myframe = Frame(self.netedit)
        myframe.pack(side=BOTTOM)
        
        button = Button(myframe, text="Add", command=self.addconnection)
        button.pack(side=LEFT)

        button = Button(myframe, text="Remove", command=self.removeconnection)
        button.pack(side=LEFT)

        button = Button(myframe, text="New Node", command=self.gennewnode)
        button.pack(side=LEFT)

        button = Button(myframe, text="Exit", command=self.exit)
        button.pack(side=RIGHT) 

        myframe = Frame(self.netedit)
        myframe.pack(side=BOTTOM)

        scrollbar = Scrollbar(myframe, orient=VERTICAL)
        self.listbox = Listbox(myframe, yscrollcommand=scrollbar.set)
             
        scrollbar.config(command=self.listbox.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
                
        self.listbox.pack(side=LEFT, fill=BOTH, expand=1)

        for node1 in nodelist:
            for node2 in nodelist:
                if str(node1)==str(node2):
                    continue

                cont=0
                for test in node1.neighbors:
                    if str(test.node)==str(node2):
                        cont=1
                        break
                if cont==1:
                    continue
                
                self.listbox.insert(END, node1.getName() + '-' + node2.getName())


    def exit(self):
        self.netedit.destroy()

    def addconnection(self):

        # if no selection is made, do nothing
        if str(self.listbox.curselection())=="()":
            return 0

        myi=self.listbox.index(self.listbox.curselection())

        i=0
        for node1 in nodelist:
            for node2 in nodelist:
                if str(node1)==str(node2):
                    continue

                cont=0
                for test in node1.neighbors:
                    if str(test.node)==str(node2):
                        cont=1
                        break
                if cont==1:
                    continue

                if i==myi:
                    n = neighbor()                  # create instance    
                    n.node = node1            # who is the neighbour
                    node2.neighbors.append(n) # attach the neighbour to
                    
                    n = neighbor()
                    n.node = node2
                    node1.neighbors.append(n)

                    new = networkcontrol()
                    self.netedit.destroy()
                    control.reset_light()
                i=i+1
         
                                


    def removeconnection(self):
        for node in nodelist:
            for neighbor in node.neighbors:
                if str(neighbor)==str(self.v.get()):

                    # remove the other side of the connection
                    mynode=node
                    othernode=neighbor.node
                    for searchnodes in nodelist:
                        if str(searchnodes)==str(othernode):
                            for searchneighbors in searchnodes.neighbors:
                                if str(searchneighbors.node)==str(mynode):
                                    searchnodes.neighbors.remove(searchneighbors)
                                    
                    # remove the chosen one
                    node.neighbors.remove(neighbor)



        new = networkcontrol()
        self.netedit.destroy()
        control.reset_light()


    def gennewnode(self):

        i=0
        for nodes in nodelist:
            if nodes.getName()=="food":
                continue
            if nodes.getName()=="nest":
                continue
            if nodes.getName()>i:
                i=int(nodes.getName())

        i=int(i)+1


        newnode = node()
        newnode.start()
        newnode.setName(i)
        nodelist.append(newnode)

        if len(nodelist)==1:
            newnode.setName("nest")
        if len(nodelist)==2:
            newnode.setName("food")
            newnode.hitlist = []

        new = networkcontrol()
        self.netedit.destroy()
            
        
#######################################################################
# ants 
class ant(threading.Thread):

    def __init__(self,startnode,p,spezi):
        threading.Thread.__init__(self)
        self.path = []          # the ants "wayhistory"
        self.pathavoid = []     # this were dead ends
        self.node = startnode
        self.startnode = startnode  # she wants to know when back home
        self.lifetime = 10
        self.p=p                # 0-p: explorer, p-1: exploiter
        self.pheromon = 0       # pheromonvalue for the way back home

        if spezi==1:           
            self.spezi=1        # this is just a stats ant.
        else:
            self.spezi=0

    def pheromoncalc(self, rang, hops):
        ph = float(1) / rang**3
        return ph

    
    # each ant gets a random lifetime
    def run(self):

        # add the startnode to the list
        self.path.append(self.node)
        # loop until food is found
        while self.node.getName() != "food":
            #print self.getName(), "pos", self.node.getName()
            #print self.getName(), "is looking out ... paths:"
            # determine wsk (probability) of neighbors of a node
            self.wsk = []   # array of wsks representing paths

            pq=whrandom.random() # choose a random value between 0 and 1
                                 # if < p behave like an explorer
                                 # else behave like an exploiter
            
            if pq < self.p:
                #print self.getName(),"is an explorer!", pq,"<",self.p
                for paths in self.node.neighbors:
                    ##### wsk-function
                    wsk=whrandom.randint(0,10)  # RANDOM! todo
                    self.wsk.append(wsk)
                
                    #print "  ",self.getName(), "path",paths.node.getName(),"wsk",wsk
            else:
                #print self.getName(),"is an exploiter!", pq,">",self.p
                for paths in self.node.neighbors:
                    ### choose pheromone value
                    self.wsk.append(paths.pheromone)
                    #print "  ",self.getName(), "path",paths.node.getName(),"ph",paths.pheromone

            # choose a path
            # while no way is found estimate the highest number of the
            # wsks and try to walk there. if it fails (node already visited),
            # set the wsk at this point to -1. if no node is found, put the
            # node on a avoid list and go back to the last node
            while (1):
                biggest=-1
                biggestposition=-1
                i=0
                for search in self.wsk:
                    if biggest<=search:
                        biggest=search
                        biggestposition=i
                    i=i+1

                # if biggest still -1, no more ways 
                if biggest==-1:
                    #print self.getName(),"no more ways. go back"
                    # add this to the avoid list, because this is a
                    # dead end
                    self.pathavoid.append(self.node)
                    break
                    
                # biggestposition is now the best way to go

                # check if the ant was already on the chosen node
                found=0
                for nodes in self.path:
                    if self.node.neighbors[biggestposition].node==nodes:
                       found="already visited"
                       break
                # check if this node is to avoid
                if found==0:
                    for nodes in self.pathavoid:
                        if self.node.neighbors[biggestposition].node==nodes:
                            found="avoid list"
                            break
                   
                if found!=0:
                    # the chosen node has already been visited. give him
                    # a poor wsk so that he is disabled to choose again
                    self.wsk[biggestposition]=-1
                    #print "ant was already on node",self.node.neighbors[biggestposition].node.getName(),"error",found
                    continue    
                else:
                    break  # go out of the path-search while(1)

            # the while1 is finished at this point. there are three cases:
            # 1. we found a way
            # 2. there is no way -> go back
            # 3. back does not work because we are on startnode

            if biggest==-1:
                # 2.+3. no node was found. try to go back
                #print "vorher",self.node.getName()
                # throw the last away, take the last as active. remember
                # that the node on which the ant is, is also in the path
                if len(self.path)<=1:
                    # oops
                    print self.getName(),"is not able to leave",self.node.getName()
                    if self.spezi==0:     # dont generate automatically
                        newant(0)         # stats ants
                    return 0
                else:   
                    self.path.pop()
                    self.node=self.path[len(self.path)-1]
                
                    if self.node==self.startnode:
                        # 3. the ant is back home...
                        # there is no way to the target
                        print self.getName(),"returned to nest node. walked in a dead way!"
                        if self.spezi==0:  # dont generate automatically
                            newant(0)       # stats ants
                        return 0
            else:
                # 1. we found a way. go there
                self.path.append(self.node.neighbors[biggestposition].node)

                #print self.getName(),"'s decision is -----> ",self.node.neighbors[biggestposition].node.getName()

                # the chosen node is now the new node
                self.node=self.node.neighbors[biggestposition].node
                #time.sleep(1)
                
        # end of loop -> ant reached the foodnode


        # the statsants do not enter the hitlist. stats ants are only
        # used to determine the path with the most pheromone
        if self.spezi==1:
            guir.bestlist=self.path
            return 0


        # the ant is now on the target node
        #print self.getName(),"reached",self.node.getName()

        # we want to know where the ant was...
        output=self.getName() + ' history: '

        if len(self.path)>0:
            for nodes in self.path:
                output=output + nodes.getName()
                if nodes.getName()=="food":
                    break
                output=output + '-'

            output=output + ' hops: '
            output=output + str(len(self.path))

           #print output        # print the ants path
       
        # entering hitlist
        self.myhit = hit()
        self.myhit.hops = len(self.path)
        self.myhit.path = self.path
        takeit=0   # is set to 1 when the hit is "taken" or if
                   # if the same hit is already in the list
        pos=0
        found=0    # found is set to 1 if the path is already in the hitlist
        
        for hits in self.node.hitlist:
            # do count pos for ranking only when path not yet found.
            # we walk through the whole list to increase the timers.
            if found!=1:
                pos+=1
            hits.timer+=1
            if self.myhit.hops==hits.hops and found==0:
                # the hopnumbers are equal, check if the way is the same
                checkpos=-1
                for check in self.path:
                    checkpos+=1
                    if check!=hits.path[checkpos]:
                        break
                    if check.getName()=="food":
                        found=1
                        hits.timer=0
                        hits.counter+=1
                        break
                # if we found a equal way, we don't need to search further
                if found==1:
                    #print "this path is already in the hitlist",pos
                    takeit=1


        if found!=1:  # we only need to check further if the possibility
                      # to add the hit is given
           pos=-1     # the computer starts counting from 0 :)
           for hits in self.node.hitlist:
            pos+=1
            if self.myhit.hops <= hits.hops:
                # check ways
                takeit=1
                #print "insert new hit at position " + str(pos+1)
                self.node.hitlist.insert(pos,self.myhit)
                # our rank starts at 1, so add 1 to pos
                pos+=1
                break
                
        # our hit was bad, so put it at the end of the list
        if takeit==0:
            #print "add hit at the end of the list"
            self.node.hitlist.append(self.myhit)
            pos=len(self.node.hitlist)

        # print stats
        #print self.getName() + ' hops: ' + str(self.myhit.hops) + ' rank:  ' + str(pos) + ' pheromon: ' + str(self.pheromoncalc(pos, self.myhit.hops))
  
        i=0
        #print 'hitlist:'
        for hits in self.node.hitlist:
            i+=1
            output='    ' + str(i) + '.\t'
            for pathx in hits.path:
                output=output + pathx.getName()
                if pathx.getName()=="food":
                    break
                output=output+ '-'
            output=output + '  h: '
            output=output + str(hits.hops)
            output=output + '   timer: ' + str(hits.timer)
            output=output + '   counter: ' + str(hits.counter)

            #print output

        # determine exploit/explore value
        self.p = 0.5     # use this variable to store the p that is given to the new ant 
                         # we dont care at the moment, so no glaring function :)

        # determine pheromone value
        self.pheromon = self.pheromoncalc(pos, self.myhit.hops)

        # go back home
        # the ant is walking on his way back, putting pheromone on the nodes
        # if the way back is not possible, self destroy the ant.
        
        pathcopy = []                # pop the real path does not work because the path is
        for mypath in self.path:     # needed in the hitlist -> same instance
            pathcopy.append(mypath)

        pathcopy.pop()   # remove nest
        
        while self.node.getName()!="nest":
            next=pathcopy.pop()
            #print self.getName(),"walking back, now on",self.node.getName()
            search=0
            pos=-1
            for neighbor in next.neighbors:
                pos+=1
                if neighbor.node==self.node:
                    search=1
                    self.node=next
                    self.node.addpheromone(pos, self.pheromon)
                    break
            if search==0:
                #print self.getName(), "Path not found!"
                break
            
        #todo

        #print self.getName(), "is DEAD, position", self.node.getName()
        control.antdecrease() # decrease the antcounter
        control.killincrease()# increase the kill counter

        
        time.sleep((1-vars.speed)) # slow down
        # the other one is dead... but we make a NEW one!!
        newant(0)   # function see below

######## end ant class #########
        
# generate a ant
def newant(spezi):

    # start only if the nest node exist
    if len(nodelist)==0:
        print "No valid nest node"
        return 0
    
    if guir.on==1 and guir.killer==0 and nodelist[0].getName()=="nest":
        guir.nodelistlock.acquire()
        if len(nodelist)>=2:
            if nodelist[0].getName()=="nest":

                if spezi==0:
                    myant = ant(nodelist[0],vars.pstart,spezi)  # startnode, p
                                          # p greater -> more explorer
                else:
                    myant = ant(nodelist[0],0,spezi)

                # give it a cool name
                name=myant.getName()[7:]

                if spezi==0:
                    myant.setName('ant'+name)
                else:
                    myant.setName('spezi-ant'+name)

                # let it goooo!
                myant.start()

                if spezi==0:
                    control.antincrease() # new ant -> increase alivecounter
                    control.totalantincrease()  # the total counter


        guir.nodelistlock.release()

    
#######################################################################
# nodes
class node(threading.Thread):

    def __init__(self):
        threading.Thread.__init__(self)
        self.neighbors = []
        self.lock = threading.Lock()
        self.act = 1
        
    def addpheromone(self, neighbor, value):
        self.lock.acquire() 
        self.neighbors[neighbor].pheromone+=value
        self.lock.release()        

    def stop(self):
        self.act = 0

    # this is a node
    def run(self):
        #for neighbor in self.neighbors:
            #print "     ", self.getName(), "detected", neighbor.node.getName(), "as neighbor"
        
        while guir.on==1 and self.act==1:
            # every second the pheromon value is decreased
            for neighbor in self.neighbors:
                self.lock.acquire() 
                neighbor.pheromone=neighbor.pheromone*vars.alpha
                self.lock.release()
            time.sleep(1)

        #print 'node ' + self.getName() + ' stopped'

#######################################################################
# network
def load(filename):
    input = open(filename, 'r' )

    nodes=1
    nest=0
    food=0

    for x in input.readlines():
        if x=="--\n":
            nodes=0
            continue

        if nodes==1:
            newnode = node()
            newnode.start()
            nodelist.append(newnode)
            
            if nest==0:
                newnode.setName("nest")
                nest=1
                continue
            if food==0:
                newnode.setName("food")
                newnode.hitlist = []
                food=1
                continue

            # the file maybe not a network. [0:4] is to take only a few chars
            if len(x)>4:
                x=x[0:4]
            else:
                x=x[0:len(x)-1]
            newnode.setName(x)

        else:
            index=0
            while index<len(x):
                if x[index]==" ":
                    break
                index=index+1
                
            nodename1=x[0:index]

            index2=index
            index=index+1
            while index<=len(x):
                if x[index]==" " or x[index]=="\n":
                    break
                index=index+1

            nodename2=x[index2+1:index]

            node1=0
            node2=0
                        
            for nodes in nodelist:
                if nodes.getName()==nodename1:
                    node1=nodes
                if nodes.getName()==nodename2:
                    node2=nodes

            if node1==0 or node2==0:
                print "Error finding nodes of connection!"
                continue

            n = neighbor()             # create instance    
            n.node = node1             # who is the neighbour
            node2.neighbors.append(n)  # attach the neighbour to


def save(filename):
    file = open(filename,'w+')
    for node in nodelist:
        file.write(node.getName() + '\n')

    file.write('--\n')
    
    for node in nodelist:
        for neighbors in node.neighbors:
            file.write(node.getName() + ' ' + neighbors.node.getName() + '\n')
    file.close()

            
#######################################################################
# main 
if __name__ == '__main__':
    nodelist = []
    
    root = Tk()
    root.title('Ant Control')
        
    control = control()      # start gui
    guir = gui_refresh()     # load gui

    vars = varclass()
    vars.time_reset()

    # load the defaultnetwork (or the one saved in default.net)
    load("default.net")
 
    guir.start()        # run gui refresher

    testant = testant()
    testant.start()

    # has to be executed at the end. it is really a loop :)
    root.mainloop()



























