/* IskraTel */

#include "kincludes.h"
#include "proto_checks.h"

int
check_packet_TCP(struct sk_buff *skb)
{
	struct iphdr *iph;
	struct tcphdr *tcph;
	unsigned int csum,tmp;
	iph=skb->nh.iph;

        /* Check tcp header size */
	if(skb->len - sizeof(struct iphdr) < sizeof(struct tcphdr)) {
		if (ntohs(iph->frag_off)&IP_MF)
			return 2; // not enough space for header, make Nist keep it's greedy fingers away.
		printk("nistnet: TCP bad hdr size\n");
		return 1; // A full TCP frame with not enough space to hold a header... I don't think so.. Bye bye..
	}
	tcph=(struct tcphdr *)(skb->h.raw + iph->ihl*4);
	tmp=tcph->check;
	tcph->check=0; // has to be 0 for checksum calc

	csum=csum_partial((char *)tcph, ntohs(iph->tot_len) - iph->ihl*4, 0); // TCP checksum
	csum=csum_tcpudp_magic(iph->saddr, // TCP pseudo header checksum
			       iph->daddr,
			       ntohs(iph->tot_len) - iph->ihl*4,
			       IPPROTO_TCP,
			       csum
			      );
	if(tmp!=csum) { // checksum correct ?
		tcph->check=tmp; // it will get dropped, but do it anyway.
		printk("nistnet: TCP csum failed\n");
		return 1;
	}
	tcph->check=tmp; //restore checksum
	return 0;
}
int
check_packet_UDP(struct sk_buff *skb)
{
	struct iphdr *iph;
	struct udphdr *udph;
	unsigned int tmp,csum;
	iph=skb->nh.iph;

        /* Check udp header size */
	if(skb->len - sizeof(struct iphdr) < sizeof(struct udphdr)) {
		if (iph->frag_off&IP_MF) // not enough space for header, make Nist keep it's gready fingers away.
			return 2;
                printk("nistnet: UDP bad hdr size\n");
		return 1;
	}
	udph=(struct udphdr *)(skb->h.raw + iph->ihl*4);

        /* Check udp packet size */
        if(skb->len - sizeof(struct iphdr) < ntohs(udph->len)) {
                printk("nistnet: UDP packet size error\n");
                return 1;
        }

	if (udph->check) { //calculate checksum
		tmp=udph->check;
		udph->check=0; // has to be 0 for checksum calc
		csum=csum_partial((char *)udph, ntohs(udph->len), 0); // UDP checksum
		csum=csum_tcpudp_magic(iph->saddr, // UDP pseudo header checksum
				       iph->daddr,
				       ntohs(udph->len),
				       IPPROTO_UDP,
				       csum
				      );
		if(tmp!=csum) { // checksum correct ?
			udph->check=csum; // it will get dropped, but do it anyway.
			printk("nistnet: UDP csum failed\n");
			return 1;
		}
                udph->check=csum; //restore checksum
	}
	return 0;
}
int
check_packet_IP(struct sk_buff *skb)
{
	__u32 len;
	struct iphdr *iph;
	iph=skb->nh.iph;

        /* This IP Check is stolen from "official" IP handler */
	if (skb->len < sizeof(struct iphdr)) return 1;
	if (skb->len < (iph->ihl << 2)) return 1;
	if (iph->ihl < 5 || iph->version != 4 || ip_fast_csum((u8 *)iph, iph->ihl) != 0) return 1;
	len  = ntohs(iph->tot_len);
	if (skb->len < len) return 1;
	if (len <  (iph->ihl << 2)) return 1;

	return 0;
}
int
check_packet(struct sk_buff *skb)
{
        struct iphdr *iph;
	iph=skb->nh.iph;

	if (ntohs(iph->frag_off)&IP_OFFSET) {
		// Multifragment and it is not the first one...
		// We need to keep Nist away from it until it
                // learns to deal with it.
                return 2;
        }

        /* I don't have time to wrap up the other protocols... you do it! */
	switch (iph->protocol) {
	case IPPROTO_UDP:	/* udp: source/dest ports */
                {
                        return(check_packet_UDP(skb));
			break;
		}

	case IPPROTO_TCP:	/* tcp: source/dest ports */
		{
                        return(check_packet_TCP(skb));
			break;
		}
	}

        return 0;
}
