#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

void Convert(int, char*);   

int main (int argc, char *argv[]) {   

    int variout=0, head, delay;
    char string[33];    // assuming 32bit integers
    
    //int mask_head = -536870912; // 11100000000000000000000000000000
    //int mask_delay = 536870911; // 00011111111111111111111111111111

    if (argc < 3) {
      printf("Usage: headgen head delay\n");
      return 0;
    }

    head = atoi(argv[1]);
    head = head << 29;
    delay = atoi(argv[2]);
    
    variout = head | delay;

    Convert(variout, string);
    printf("%s   head: %2d  delay: %8d value: %10d\n", 
	   				string, atoi(argv[1]), delay, variout);

    return 0;
}


void Convert(int bin, char *str)
{
    unsigned int mask;      // used to check each individual bit, unsigned 
                            //    to alleviate sign extension problems

    mask = 0x80000000;      // Set only the high-end bit
    while (mask)            // Loop until MASK is empty
    {
        if (bin & mask)     // test the masked bit
              *str = '1';   // if true, value is 1
          else
              *str = '0';   // if false, value is 0
        str++;              // next character
        mask >>= 1;         // shift the mask 1 bit
    }
    *str = 0;               // add the trailing null 
}

