#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>

void Convert(int, char*);   

int main (int argc, char *argv[]) {
    
    char *out[4];
    int fd, variout=0;
    char string[33];    // assuming 32bit integers

    if (argc < 2) {
      printf("Give input filename as first argument!\n");
      return 0;
    }

    if ((fd = open(argv[1], O_RDONLY,0)) < 0) {
        fprintf(stderr, "Cannot open input file\n");
	return 0;
    }

    while (read(fd, &out, 4)) {

       variout = (int)* out;
       
       Convert(variout, string);   
       printf("%s    %10d  %15Xh \n", string, variout, variout);
    }

    close(fd);
    
    return 0;
}

void Convert(int bin, char *str)
{
    unsigned int mask;      // used to check each individual bit, unsigned 
                            //    to alleviate sign extension problems

    mask = 0x80000000;      // Set only the high-end bit
    while (mask)            // Loop until MASK is empty
    {
        if (bin & mask)     // test the masked bit
              *str = '1';   // if true, value is 1
          else 
              *str = '0';   // if false, value is 0
        str++;              // next character
        mask >>= 1;         // shift the mask 1 bit
    }
    *str = 0;               // add the trailing null 
}

