#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>

void Convert(int, char*);   

int main (int argc, char *argv[]) {   

    char *out[4]; 
    int fd, variout=0, head, delay;
    char string[33];    // assuming 32bit integers
    
    int mask_head = -536870912; // 11100000000000000000000000000000
    int mask_delay = 536870911; // 00011111111111111111111111111111

    if (argc < 2) {
      printf("Give input filename as first argument!\n");
      return 0;
    }

    if ((fd = open(argv[1], O_RDONLY,0)) < 0) {
        fprintf(stderr, "Cannot open input file\n");
	return 0;
    }

    while (read(fd, &out, 4)) {
 
       variout = (int)* out;

       delay = variout & mask_delay;
       head =  (variout & mask_head) >> 29 ;

       Convert(variout, string);
       printf("%s   head: %2d  delay: %8d value: %10d\n", 
	   				string, head, delay, variout);


    }

    close(fd);

    return 0;
}


void Convert(int bin, char *str)
{
    unsigned int mask;      // used to check each individual bit, unsigned 
                            //    to alleviate sign extension problems

    mask = 0x80000000;      // Set only the high-end bit
    while (mask)            // Loop until MASK is empty
    {
        if (bin & mask)     // test the masked bit
              *str = '1';   // if true, value is 1
          else
              *str = '0';   // if false, value is 0
        str++;              // next character
        mask >>= 1;         // shift the mask 1 bit
    }
    *str = 0;               // add the trailing null 
}

