/* This is the mu "correction" table, indexed by rho from -1.0 to 0.990
 * by 0.010, and sigma from 0 to 0.990 (fraction of mu) by 0.010
 * (Far more precision than really required...)  This is the table
 * for the pareto distribution.  You could actually just
 * use this one for all of them (they're all quite close),
 * but I guess I'll make separate tables for each.
 */
/* To determine correction:
 *	index = rint((rho+1)*100)
 * We use linear interpolation between entries...
 */
#define MU_RHO_STEP 100
#define MU_RHO_DOMAIN 200
#define MU_SIGMA_STEP 100
#define MU_SIGMA_DOMAIN 99

double rhomucorrect[MU_RHO_DOMAIN][MU_SIGMA_DOMAIN+1] = {
{ 1.000000,  1.004191,  1.008756,  1.013078,  1.017204,  1.021347,  1.025524,  1.030641,  1.034395,  1.038010,  1.042240,  1.047367,  1.052343,  1.053927,  1.060320,  1.065217,  1.068982,  1.071448,  1.078190,  1.081480,  1.086304,  1.087800,  1.095936,  1.100139,  1.101258,  1.105772,  1.112376,  1.117314,  1.116825,  1.124811,  1.130185,  1.133972,  1.134864,  1.142636,  1.146937,  1.150108,  1.148611,  1.162236,  1.164463,  1.165984,  1.167783,  1.177907,  1.183338,  1.178037,  1.190954,  1.194207,  1.198148,  1.198570,  1.209724,  1.210307,  1.214849,  1.212129,  1.225578,  1.229345,  1.230142,  1.232143,  1.244675,  1.245588,  1.242182,  1.254525,  1.259419,  1.262984,  1.260844,  1.274100,  1.276525,  1.276235,  1.276886,  1.290322,  1.295380,  1.289638,  1.299188,  1.310076,  1.310472,  1.303611,  1.320777,  1.324092,  1.327529,  1.321813,  1.340664,  1.341392,  1.339677,  1.339443,  1.354640,  1.362719,  1.350259,  1.365168,  1.374792,  1.375568,  1.369307,  1.386494,  1.385131,  1.394933,  1.383587,  1.404504,  1.408795,  1.402867,  1.405423,  1.421107,  1.424472,  1.413822, },
{ 1.000000,  1.004135,  1.009083,  1.012989,  1.016614,  1.021311,  1.026120,  1.029986,  1.032807,  1.039574,  1.043368,  1.046697,  1.050553,  1.056412,  1.061242,  1.061376,  1.069646,  1.073303,  1.077266,  1.080479,  1.087204,  1.089864,  1.094307,  1.095532,  1.104288,  1.107995,  1.111010,  1.113725,  1.121846,  1.124783,  1.125010,  1.133264,  1.137959,  1.142537,  1.143014,  1.152095,  1.155761,  1.157900,  1.158962,  1.168584,  1.173953,  1.172058,  1.177968,  1.187993,  1.189877,  1.186989,  1.199288,  1.202052,  1.206832,  1.204126,  1.219002,  1.220740,  1.220343,  1.220871,  1.233401,  1.240280,  1.232921,  1.244145,  1.251912,  1.255021,  1.250237,  1.265070,  1.264993,  1.272504,  1.267484,  1.281819,  1.287722,  1.282361,  1.286184,  1.300094,  1.301823,  1.296510,  1.308748,  1.316203,  1.321470,  1.313657,  1.328059,  1.331776,  1.336338,  1.326783,  1.348365,  1.350170,  1.349915,  1.347890,  1.362963,  1.370712,  1.355885,  1.376019,  1.379418,  1.383491,  1.378057,  1.395021,  1.395593,  1.399207,  1.389366,  1.413184,  1.415053,  1.414026,  1.411164,  1.432069, },
{ 1.000000,  1.004155,  1.008661,  1.012839,  1.017114,  1.021189,  1.025247,  1.030255,  1.033978,  1.037704,  1.041681,  1.046934,  1.051545,  1.053679,  1.059044,  1.064902,  1.068077,  1.070156,  1.077742,  1.080282,  1.085469,  1.086691,  1.095298,  1.098695,  1.100176,  1.103743,  1.111204,  1.116722,  1.115785,  1.123046,  1.129110,  1.131856,  1.132563,  1.141511,  1.144606,  1.149247,  1.149074,  1.158411,  1.164462,  1.161988,  1.166500,  1.176475,  1.179742,  1.177197,  1.186785,  1.194018,  1.197542,  1.193651,  1.205602,  1.208475,  1.212769,  1.210513,  1.223689,  1.227765,  1.227932,  1.228586,  1.238939,  1.245876,  1.238491,  1.252099,  1.256867,  1.259440,  1.258275,  1.271235,  1.271313,  1.275711,  1.271503,  1.288736,  1.290871,  1.291747,  1.290061,  1.305727,  1.310180,  1.298124,  1.316034,  1.322609,  1.324009,  1.319654,  1.336753,  1.337606,  1.337191,  1.335350,  1.350499,  1.356647,  1.350494,  1.355530,  1.372786,  1.371714,  1.362522,  1.382234,  1.381917,  1.387817,  1.380665,  1.402150,  1.402904,  1.399262,  1.397566,  1.414446,  1.423900,  1.408625, },
{ 1.000000,  1.004079,  1.009038,  1.012741,  1.017103,  1.021864,  1.026593,  1.030681,  1.033441,  1.039607,  1.044100,  1.047253,  1.051044,  1.056591,  1.061631,  1.062857,  1.069782,  1.074979,  1.079445,  1.080018,  1.087256,  1.091637,  1.095830,  1.097310,  1.105891,  1.109594,  1.112087,  1.114887,  1.122313,  1.127444,  1.126574,  1.135499,  1.139859,  1.144583,  1.143795,  1.154080,  1.156421,  1.160593,  1.159767,  1.171115,  1.175910,  1.177563,  1.177657,  1.189882,  1.193071,  1.188040,  1.200265,  1.206266,  1.209684,  1.207760,  1.220510,  1.221769,  1.225193,  1.223639,  1.236217,  1.241967,  1.238531,  1.243636,  1.256941,  1.258074,  1.253170,  1.266237,  1.270303,  1.273322,  1.272265,  1.286275,  1.290189,  1.288702,  1.287404,  1.301088,  1.309072,  1.300622,  1.311133,  1.321074,  1.322058,  1.316330,  1.333808,  1.336202,  1.339514,  1.333541,  1.351857,  1.356663,  1.350630,  1.352875,  1.367322,  1.375137,  1.362860,  1.377349,  1.388108,  1.389904,  1.379896,  1.398135,  1.399784,  1.406357,  1.395797,  1.418267,  1.422290,  1.416174,  1.417845,  1.431521, },
{ 1.000000,  1.004132,  1.008593,  1.012752,  1.016867,  1.021663,  1.025039,  1.029687,  1.033561,  1.038358,  1.040950,  1.046759,  1.051514,  1.054987,  1.057475,  1.064538,  1.068865,  1.069084,  1.077065,  1.081261,  1.084868,  1.087199,  1.094998,  1.097157,  1.101244,  1.102979,  1.110570,  1.115916,  1.116901,  1.120699,  1.128785,  1.132271,  1.131912,  1.140116,  1.145030,  1.148539,  1.149536,  1.159118,  1.162879,  1.163701,  1.164816,  1.174770,  1.180513,  1.177295,  1.185910,  1.192908,  1.195004,  1.193803,  1.204923,  1.209136,  1.212835,  1.209917,  1.223697,  1.226189,  1.226845,  1.227450,  1.238717,  1.244768,  1.238404,  1.249863,  1.257410,  1.260261,  1.255072,  1.270014,  1.271710,  1.276457,  1.272093,  1.287145,  1.291202,  1.288602,  1.291322,  1.302225,  1.308934,  1.299195,  1.314073,  1.320329,  1.324043,  1.319480,  1.332419,  1.337142,  1.340184,  1.329125,  1.351669,  1.354831,  1.354011,  1.350530,  1.367893,  1.375033,  1.357394,  1.381205,  1.382791,  1.386578,  1.381606,  1.401036,  1.397239,  1.403681,  1.394752,  1.413420,  1.419656,  1.413822, },
{ 1.000000,  1.003981,  1.008933,  1.012706,  1.016198,  1.021494,  1.025624,  1.029343,  1.033381,  1.038656,  1.042543,  1.046406,  1.049422,  1.054901,  1.060433,  1.062170,  1.067158,  1.072049,  1.076606,  1.077695,  1.084847,  1.089029,  1.093085,  1.094582,  1.103412,  1.106001,  1.108268,  1.111585,  1.118333,  1.124489,  1.123317,  1.130747,  1.136701,  1.140508,  1.139876,  1.149075,  1.152129,  1.157637,  1.155719,  1.166908,  1.171911,  1.170471,  1.174946,  1.181997,  1.188413,  1.184706,  1.194767,  1.199879,  1.203979,  1.203021,  1.212377,  1.215933,  1.219840,  1.214954,  1.232191,  1.234752,  1.234791,  1.234702,  1.246877,  1.253733,  1.243531,  1.260654,  1.262635,  1.266652,  1.266022,  1.279318,  1.277969,  1.283955,  1.277584,  1.293629,  1.298757,  1.297161,  1.298470,  1.313156,  1.314099,  1.307785,  1.322357,  1.327340,  1.330249,  1.326723,  1.342216,  1.344446,  1.342134,  1.342586,  1.356547,  1.363615,  1.355212,  1.365212,  1.376690,  1.377752,  1.368336,  1.387561,  1.390377,  1.394617,  1.386400,  1.407914,  1.408312,  1.404651,  1.404440,  1.419776, },
{ 1.000000,  1.004103,  1.008508,  1.012552,  1.016814,  1.021379,  1.024764,  1.029495,  1.033692,  1.038266,  1.040746,  1.047196,  1.051145,  1.053648,  1.057551,  1.063745,  1.067640,  1.069153,  1.075821,  1.080386,  1.084176,  1.086300,  1.093178,  1.096548,  1.101248,  1.101199,  1.110708,  1.114591,  1.117049,  1.118667,  1.126952,  1.132838,  1.128945,  1.140832,  1.143281,  1.147004,  1.148243,  1.158168,  1.158875,  1.163768,  1.162201,  1.174297,  1.177760,  1.179327,  1.181179,  1.191240,  1.194704,  1.191595,  1.201686,  1.207227,  1.210861,  1.209937,  1.221668,  1.223765,  1.224949,  1.225927,  1.236742,  1.242088,  1.238883,  1.245235,  1.255402,  1.256871,  1.252908,  1.267901,  1.268069,  1.273924,  1.270345,  1.286616,  1.288445,  1.285686,  1.286418,  1.299427,  1.308220,  1.297234,  1.310178,  1.318712,  1.320862,  1.314592,  1.331865,  1.329978,  1.339046,  1.332063,  1.347164,  1.355159,  1.345839,  1.350481,  1.364790,  1.367671,  1.359683,  1.373709,  1.381689,  1.385822,  1.376192,  1.394085,  1.395276,  1.399821,  1.389570,  1.413420,  1.414525,  1.413555, },
{ 1.000000,  1.003922,  1.008756,  1.012697,  1.015910,  1.020688,  1.025314,  1.029081,  1.032323,  1.038125,  1.041762,  1.045504,  1.047773,  1.054862,  1.058742,  1.061674,  1.065175,  1.071687,  1.075442,  1.075956,  1.083350,  1.088011,  1.091654,  1.093722,  1.101479,  1.103940,  1.106860,  1.109520,  1.116683,  1.121930,  1.122115,  1.127499,  1.135144,  1.137291,  1.136878,  1.147585,  1.148415,  1.154995,  1.153471,  1.164804,  1.167853,  1.167711,  1.170385,  1.179136,  1.186791,  1.181517,  1.190559,  1.197209,  1.199959,  1.198214,  1.209404,  1.212125,  1.217136,  1.214656,  1.225408,  1.233159,  1.227749,  1.231761,  1.243877,  1.246909,  1.241124,  1.252842,  1.261443,  1.264308,  1.257121,  1.273018,  1.274337,  1.278509,  1.274124,  1.290352,  1.294394,  1.291706,  1.293110,  1.304164,  1.312107,  1.300692,  1.317772,  1.322255,  1.323990,  1.321832,  1.336848,  1.335481,  1.339757,  1.333823,  1.353645,  1.355792,  1.355514,  1.352455,  1.369374,  1.375029,  1.359672,  1.379898,  1.386041,  1.387805,  1.382024,  1.401090,  1.400315,  1.399136,  1.396916,  1.412857, },
{ 1.000000,  1.004036,  1.008516,  1.012232,  1.016726,  1.020535,  1.024333,  1.029172,  1.032757,  1.037556,  1.040521,  1.046079,  1.049771,  1.053181,  1.056515,  1.061942,  1.067637,  1.068267,  1.074122,  1.079186,  1.082658,  1.084554,  1.091627,  1.095817,  1.099362,  1.100532,  1.108205,  1.114086,  1.113248,  1.117110,  1.125362,  1.129830,  1.127653,  1.136159,  1.142915,  1.145897,  1.143913,  1.154448,  1.157428,  1.161415,  1.160025,  1.172380,  1.175846,  1.175525,  1.178113,  1.186258,  1.192441,  1.187788,  1.199909,  1.203923,  1.207624,  1.205144,  1.217631,  1.218790,  1.222821,  1.220022,  1.234223,  1.238156,  1.238165,  1.237247,  1.251548,  1.254724,  1.246519,  1.261081,  1.266637,  1.269132,  1.267002,  1.281112,  1.281197,  1.284111,  1.280740,  1.294781,  1.300939,  1.296056,  1.300510,  1.315600,  1.315883,  1.309390,  1.323993,  1.326701,  1.329650,  1.328205,  1.343275,  1.347262,  1.343421,  1.342221,  1.355831,  1.365666,  1.353874,  1.365757,  1.376962,  1.376023,  1.369410,  1.388162,  1.390546,  1.391939,  1.385850,  1.406527,  1.410989,  1.401455, },
{ 1.000000,  1.003883,  1.008679,  1.012543,  1.015847,  1.020978,  1.025349,  1.028877,  1.032364,  1.037600,  1.041325,  1.046142,  1.048203,  1.054323,  1.059139,  1.061281,  1.064902,  1.070849,  1.075740,  1.076163,  1.083694,  1.087717,  1.091497,  1.093495,  1.100425,  1.103568,  1.108105,  1.108168,  1.117455,  1.122083,  1.123942,  1.124753,  1.134280,  1.139352,  1.135286,  1.146032,  1.150660,  1.153940,  1.154201,  1.164501,  1.165305,  1.170360,  1.169147,  1.179016,  1.185554,  1.183172,  1.187279,  1.198311,  1.199978,  1.197288,  1.208419,  1.212705,  1.215234,  1.215965,  1.226646,  1.230794,  1.230196,  1.230298,  1.241461,  1.248733,  1.242412,  1.251511,  1.260393,  1.261701,  1.257859,  1.271849,  1.276041,  1.277868,  1.274321,  1.290798,  1.293252,  1.290714,  1.291939,  1.304803,  1.311118,  1.301258,  1.315128,  1.323871,  1.325260,  1.317917,  1.335435,  1.336835,  1.340796,  1.335102,  1.352274,  1.356768,  1.351734,  1.354471,  1.366185,  1.374523,  1.360617,  1.377694,  1.385745,  1.387444,  1.381379,  1.396569,  1.401060,  1.402653,  1.390070,  1.416469, },
{ 1.000000,  1.003987,  1.008526,  1.011975,  1.016384,  1.020565,  1.023758,  1.028800,  1.032650,  1.036517,  1.040150,  1.045516,  1.048647,  1.052802,  1.055530,  1.061463,  1.065763,  1.067869,  1.072085,  1.078344,  1.081827,  1.082634,  1.089908,  1.094080,  1.097533,  1.099356,  1.107469,  1.110930,  1.112338,  1.114506,  1.122620,  1.127945,  1.126889,  1.133200,  1.139802,  1.142957,  1.141381,  1.151301,  1.155318,  1.158792,  1.158394,  1.169025,  1.172315,  1.172297,  1.174306,  1.182541,  1.190888,  1.185159,  1.194255,  1.201794,  1.204206,  1.201577,  1.212968,  1.214913,  1.221160,  1.217025,  1.230095,  1.235609,  1.231664,  1.235544,  1.243995,  1.251276,  1.244130,  1.255704,  1.262447,  1.265809,  1.262776,  1.273138,  1.277556,  1.279849,  1.272896,  1.294140,  1.295477,  1.293429,  1.293285,  1.306762,  1.314393,  1.299934,  1.320044,  1.322307,  1.325555,  1.322572,  1.338656,  1.336697,  1.341857,  1.332487,  1.353024,  1.357038,  1.353155,  1.354029,  1.371187,  1.371634,  1.362505,  1.377958,  1.384533,  1.386660,  1.381660,  1.398052,  1.401535,  1.397214, },
{ 1.000000,  1.003835,  1.008582,  1.012393,  1.015754,  1.020613,  1.025052,  1.028498,  1.031250,  1.037188,  1.041002,  1.044732,  1.047812,  1.053830,  1.057507,  1.060739,  1.063724,  1.069390,  1.074526,  1.075219,  1.081340,  1.086713,  1.090135,  1.091678,  1.098586,  1.101753,  1.107116,  1.106919,  1.115942,  1.120145,  1.120077,  1.124056,  1.131732,  1.135876,  1.134417,  1.142785,  1.148238,  1.151663,  1.151575,  1.160309,  1.163491,  1.166931,  1.165074,  1.178185,  1.180975,  1.182383,  1.182987,  1.192470,  1.200308,  1.191459,  1.206042,  1.209192,  1.212558,  1.212095,  1.223008,  1.223880,  1.229082,  1.223618,  1.239744,  1.243307,  1.242246,  1.243936,  1.256270,  1.258732,  1.252719,  1.265252,  1.270836,  1.273955,  1.272160,  1.284972,  1.287030,  1.287763,  1.286263,  1.299458,  1.305931,  1.299284,  1.305896,  1.318221,  1.320011,  1.312535,  1.329391,  1.330207,  1.335721,  1.330047,  1.349214,  1.350111,  1.345721,  1.345629,  1.359920,  1.370319,  1.355183,  1.369867,  1.380313,  1.380814,  1.372489,  1.391864,  1.389954,  1.399073,  1.389979,  1.407134, },
{ 1.000000,  1.003981,  1.008300,  1.011937,  1.016215,  1.020112,  1.023843,  1.028190,  1.032463,  1.036368,  1.039554,  1.044586,  1.048246,  1.052246,  1.054709,  1.061236,  1.064833,  1.067560,  1.071218,  1.076532,  1.081857,  1.080998,  1.089542,  1.092797,  1.096767,  1.098171,  1.105829,  1.108580,  1.112673,  1.112208,  1.122329,  1.125822,  1.127738,  1.129228,  1.138739,  1.142291,  1.139582,  1.148636,  1.154411,  1.157580,  1.156883,  1.167183,  1.169364,  1.171703,  1.172038,  1.181169,  1.187952,  1.184319,  1.190453,  1.200164,  1.202370,  1.198299,  1.211481,  1.211401,  1.219012,  1.214877,  1.228472,  1.231754,  1.230026,  1.231695,  1.241509,  1.250203,  1.241720,  1.252405,  1.260036,  1.261236,  1.258829,  1.271178,  1.272915,  1.278288,  1.275139,  1.286943,  1.295196,  1.286454,  1.291824,  1.304185,  1.307948,  1.298413,  1.313248,  1.322375,  1.324489,  1.314684,  1.332541,  1.333485,  1.337896,  1.331458,  1.349928,  1.354504,  1.349143,  1.349863,  1.362196,  1.372446,  1.355994,  1.375255,  1.381057,  1.382372,  1.377650,  1.394014,  1.392717,  1.397901, },
{ 1.000000,  1.003762,  1.008554,  1.012221,  1.015877,  1.019999,  1.024655,  1.028598,  1.031260,  1.036678,  1.040821,  1.045174,  1.047507,  1.054004,  1.057257,  1.060517,  1.063823,  1.069372,  1.073995,  1.075999,  1.080147,  1.086617,  1.090407,  1.090711,  1.098298,  1.101633,  1.105885,  1.107019,  1.115893,  1.119171,  1.120093,  1.123139,  1.130297,  1.136862,  1.134156,  1.141602,  1.148041,  1.150473,  1.150689,  1.160121,  1.163186,  1.167017,  1.166998,  1.176355,  1.182330,  1.179430,  1.183246,  1.192139,  1.198464,  1.192163,  1.203119,  1.210945,  1.213396,  1.208693,  1.221251,  1.223726,  1.228358,  1.225285,  1.239332,  1.243122,  1.241143,  1.243739,  1.252297,  1.260584,  1.251120,  1.266128,  1.270586,  1.274392,  1.269876,  1.283465,  1.284112,  1.289998,  1.282972,  1.299775,  1.305428,  1.303710,  1.300002,  1.317456,  1.322001,  1.307948,  1.326407,  1.331993,  1.334994,  1.330619,  1.346520,  1.345321,  1.349267,  1.343183,  1.359685,  1.367388,  1.358430,  1.363795,  1.381076,  1.381005,  1.371795,  1.388322,  1.390577,  1.394013,  1.391477,  1.407122, },
{ 1.000000,  1.003908,  1.008337,  1.011723,  1.015879,  1.020848,  1.023598,  1.027745,  1.032826,  1.036390,  1.039057,  1.045049,  1.048521,  1.052240,  1.055316,  1.061292,  1.065242,  1.067520,  1.071169,  1.076616,  1.082469,  1.081944,  1.088390,  1.094420,  1.097750,  1.097521,  1.105705,  1.108759,  1.113589,  1.113872,  1.122253,  1.126821,  1.127196,  1.131009,  1.136722,  1.144169,  1.140240,  1.149733,  1.154711,  1.158572,  1.157504,  1.166743,  1.169518,  1.173836,  1.171647,  1.183613,  1.188073,  1.189210,  1.188190,  1.198929,  1.206497,  1.197271,  1.210397,  1.215557,  1.219554,  1.216341,  1.229931,  1.228975,  1.234740,  1.231176,  1.243091,  1.250385,  1.245401,  1.249471,  1.261569,  1.264935,  1.258157,  1.270925,  1.275523,  1.279023,  1.276892,  1.289659,  1.293919,  1.292056,  1.291398,  1.302762,  1.311884,  1.302587,  1.313086,  1.321791,  1.324455,  1.317546,  1.332266,  1.337718,  1.339926,  1.333404,  1.351760,  1.355533,  1.349960,  1.351453,  1.364619,  1.372984,  1.359099,  1.375089,  1.383629,  1.386315,  1.376302,  1.394378,  1.396047,  1.401554, },
{ 1.000000,  1.003751,  1.008428,  1.012140,  1.016228,  1.019965,  1.024163,  1.029255,  1.031060,  1.036808,  1.040981,  1.044840,  1.047953,  1.052822,  1.057392,  1.061210,  1.062835,  1.070173,  1.073891,  1.076780,  1.079207,  1.086341,  1.091775,  1.088858,  1.098685,  1.101872,  1.106750,  1.107383,  1.115378,  1.117643,  1.122690,  1.122464,  1.130963,  1.135991,  1.136138,  1.139308,  1.148470,  1.152464,  1.149202,  1.158826,  1.163315,  1.167685,  1.167421,  1.177660,  1.180839,  1.181148,  1.182493,  1.191309,  1.199410,  1.194574,  1.202071,  1.209154,  1.213520,  1.208791,  1.221022,  1.224008,  1.229159,  1.226499,  1.239522,  1.242101,  1.240689,  1.242550,  1.251128,  1.262743,  1.251991,  1.263172,  1.272295,  1.274241,  1.269210,  1.282637,  1.284472,  1.291606,  1.284890,  1.300255,  1.306987,  1.299773,  1.304277,  1.312462,  1.323945,  1.310234,  1.325347,  1.332359,  1.337180,  1.330741,  1.342405,  1.347011,  1.350664,  1.339300,  1.364879,  1.366632,  1.362594,  1.360951,  1.375527,  1.387941,  1.365385,  1.390379,  1.391376,  1.397466,  1.391117,  1.408632, },
{ 1.000000,  1.003809,  1.008369,  1.011463,  1.015835,  1.019823,  1.023733,  1.027043,  1.031794,  1.035661,  1.038435,  1.043378,  1.047368,  1.051261,  1.054296,  1.059639,  1.063322,  1.066089,  1.069434,  1.074937,  1.079986,  1.080957,  1.086223,  1.091582,  1.095204,  1.095500,  1.103159,  1.106449,  1.110914,  1.111541,  1.119761,  1.123178,  1.124166,  1.127178,  1.133859,  1.140898,  1.137233,  1.145688,  1.151896,  1.154190,  1.154079,  1.163009,  1.164481,  1.171184,  1.168932,  1.178932,  1.184151,  1.181511,  1.186172,  1.193688,  1.199970,  1.194255,  1.204574,  1.210143,  1.214970,  1.211933,  1.222028,  1.224563,  1.229188,  1.224494,  1.239774,  1.243250,  1.241941,  1.242487,  1.252509,  1.263160,  1.247644,  1.267381,  1.268210,  1.273342,  1.270768,  1.283780,  1.282232,  1.289616,  1.281000,  1.298392,  1.303833,  1.300037,  1.300908,  1.314449,  1.319182,  1.308085,  1.323190,  1.328348,  1.333245,  1.328048,  1.342913,  1.344733,  1.344701,  1.341909,  1.355952,  1.364429,  1.353591,  1.361729,  1.374768,  1.378133,  1.366121,  1.385614,  1.384991,  1.392721, },
{ 1.000000,  1.003705,  1.008377,  1.011957,  1.015430,  1.019594,  1.023787,  1.028180,  1.030164,  1.035529,  1.039937,  1.043459,  1.046102,  1.051768,  1.054784,  1.060254,  1.061754,  1.067245,  1.072996,  1.073467,  1.077333,  1.083671,  1.088242,  1.087899,  1.094251,  1.099637,  1.104108,  1.103535,  1.111441,  1.114449,  1.118971,  1.118622,  1.127964,  1.131872,  1.133242,  1.135400,  1.141659,  1.150641,  1.143769,  1.155239,  1.157860,  1.163763,  1.162112,  1.170908,  1.173776,  1.178926,  1.175053,  1.187342,  1.192588,  1.192082,  1.192952,  1.203415,  1.209034,  1.201671,  1.213721,  1.218596,  1.223094,  1.220015,  1.232459,  1.233144,  1.236413,  1.234433,  1.244599,  1.254375,  1.246217,  1.253362,  1.264980,  1.267941,  1.259368,  1.275819,  1.274481,  1.283801,  1.276415,  1.292284,  1.296633,  1.292354,  1.293645,  1.303588,  1.316555,  1.302063,  1.315081,  1.322842,  1.326125,  1.319446,  1.333579,  1.334661,  1.342518,  1.336383,  1.347867,  1.360491,  1.347674,  1.352229,  1.365369,  1.373211,  1.357102,  1.374861,  1.384499,  1.388887,  1.374676,  1.393784, },
{ 1.000000,  1.003769,  1.008245,  1.011435,  1.015642,  1.020353,  1.023400,  1.026703,  1.031551,  1.036475,  1.037610,  1.043914,  1.047486,  1.051384,  1.054272,  1.059785,  1.062373,  1.067481,  1.068771,  1.076027,  1.080468,  1.082163,  1.084806,  1.091452,  1.097057,  1.094567,  1.103157,  1.107321,  1.111812,  1.112106,  1.119866,  1.123012,  1.125882,  1.126858,  1.134437,  1.140757,  1.138622,  1.143918,  1.152296,  1.155748,  1.153050,  1.163002,  1.164708,  1.170969,  1.169732,  1.179737,  1.183907,  1.183431,  1.184549,  1.193091,  1.202744,  1.194200,  1.204705,  1.211539,  1.213488,  1.211698,  1.222162,  1.225754,  1.230314,  1.227719,  1.237903,  1.246748,  1.239501,  1.243941,  1.253024,  1.261745,  1.250727,  1.264725,  1.271908,  1.276205,  1.268090,  1.281334,  1.284163,  1.290103,  1.283922,  1.299772,  1.305378,  1.299377,  1.302926,  1.309984,  1.323144,  1.307400,  1.325606,  1.328810,  1.336092,  1.326948,  1.342074,  1.342318,  1.349460,  1.339791,  1.357709,  1.366134,  1.360726,  1.356793,  1.374611,  1.383324,  1.362118,  1.384022,  1.389699,  1.394546, },
{ 1.000000,  1.003672,  1.008248,  1.011662,  1.016082,  1.019252,  1.023536,  1.028559,  1.030758,  1.035242,  1.040191,  1.043989,  1.046319,  1.051543,  1.055644,  1.059538,  1.062161,  1.068203,  1.071973,  1.075021,  1.077319,  1.083269,  1.089689,  1.088103,  1.094792,  1.100091,  1.104025,  1.104206,  1.111421,  1.115393,  1.119309,  1.120647,  1.127880,  1.132985,  1.132573,  1.136042,  1.142675,  1.150250,  1.145097,  1.154791,  1.160566,  1.164861,  1.161852,  1.170746,  1.174075,  1.179964,  1.177936,  1.187669,  1.193622,  1.191073,  1.195020,  1.201436,  1.211694,  1.201705,  1.215372,  1.219023,  1.224987,  1.221356,  1.231512,  1.233516,  1.239116,  1.234742,  1.247687,  1.255187,  1.252353,  1.250509,  1.263141,  1.273171,  1.257688,  1.275207,  1.278787,  1.285023,  1.278963,  1.294140,  1.292155,  1.298916,  1.293244,  1.305222,  1.317323,  1.306339,  1.311196,  1.324930,  1.329668,  1.318928,  1.334069,  1.337404,  1.342880,  1.339096,  1.352396,  1.357245,  1.354463,  1.352358,  1.363539,  1.377610,  1.361881,  1.375216,  1.384436,  1.387610,  1.377857,  1.393911, },
{ 1.000000,  1.004389,  1.008138,  1.012168,  1.016076,  1.020640,  1.024364,  1.027826,  1.032743,  1.037976,  1.039332,  1.045312,  1.049228,  1.053672,  1.055903,  1.061468,  1.065504,  1.069873,  1.072021,  1.078409,  1.082921,  1.084562,  1.088746,  1.093538,  1.100956,  1.097752,  1.106567,  1.111539,  1.115569,  1.116373,  1.122494,  1.127245,  1.131830,  1.129954,  1.140352,  1.146041,  1.145582,  1.147678,  1.155672,  1.164198,  1.155394,  1.169479,  1.172092,  1.177083,  1.175988,  1.186654,  1.187246,  1.193715,  1.191033,  1.200593,  1.209062,  1.204291,  1.208332,  1.218946,  1.224486,  1.217049,  1.229033,  1.233975,  1.239113,  1.236513,  1.247921,  1.252434,  1.251431,  1.251422,  1.260782,  1.272114,  1.263130,  1.272497,  1.279748,  1.285379,  1.276499,  1.292028,  1.294524,  1.301039,  1.296961,  1.309467,  1.314167,  1.310814,  1.312140,  1.320604,  1.336591,  1.319628,  1.334282,  1.343506,  1.346859,  1.338198,  1.353030,  1.354714,  1.364137,  1.355744,  1.369697,  1.380609,  1.369329,  1.374507,  1.381969,  1.398312,  1.377692,  1.396959,  1.403198,  1.410745, },
{ 1.000000,  1.003618,  1.008003,  1.011495,  1.015213,  1.018178,  1.023502,  1.027080,  1.029983,  1.033225,  1.038350,  1.043107,  1.043249,  1.049772,  1.053478,  1.057531,  1.059631,  1.065128,  1.068328,  1.072792,  1.073345,  1.079722,  1.085435,  1.085983,  1.089251,  1.095513,  1.100578,  1.098723,  1.106383,  1.110262,  1.115148,  1.115503,  1.122231,  1.125955,  1.128283,  1.129911,  1.136108,  1.143328,  1.140369,  1.147103,  1.153109,  1.157394,  1.154303,  1.163865,  1.166944,  1.172286,  1.170760,  1.179871,  1.184212,  1.183253,  1.186078,  1.192385,  1.202716,  1.193139,  1.205280,  1.211385,  1.213937,  1.210858,  1.221876,  1.222041,  1.230836,  1.225856,  1.236689,  1.243185,  1.238357,  1.242856,  1.250332,  1.259336,  1.248662,  1.262249,  1.267053,  1.272987,  1.267126,  1.277990,  1.280793,  1.285708,  1.279247,  1.295213,  1.300633,  1.296777,  1.296426,  1.307074,  1.321638,  1.298591,  1.322971,  1.322556,  1.329362,  1.324329,  1.337106,  1.335940,  1.345134,  1.333617,  1.350290,  1.359941,  1.352401,  1.352974,  1.366490,  1.374785,  1.358155,  1.375723, },
{ 1.000000,  1.003664,  1.008038,  1.011206,  1.015173,  1.019461,  1.022911,  1.025848,  1.030655,  1.035140,  1.037002,  1.041019,  1.046167,  1.050184,  1.051437,  1.057774,  1.060568,  1.065160,  1.067176,  1.073306,  1.076811,  1.079149,  1.082052,  1.086873,  1.094512,  1.091657,  1.098673,  1.104196,  1.108055,  1.106989,  1.114867,  1.117371,  1.123418,  1.123023,  1.129882,  1.136378,  1.133774,  1.138984,  1.144896,  1.150982,  1.147070,  1.156450,  1.160708,  1.166781,  1.163493,  1.171563,  1.175460,  1.180174,  1.177576,  1.187765,  1.193589,  1.192158,  1.194022,  1.200569,  1.212414,  1.199400,  1.215694,  1.216768,  1.223481,  1.220702,  1.229479,  1.231520,  1.238255,  1.232778,  1.244471,  1.252433,  1.249209,  1.249210,  1.260406,  1.268793,  1.255291,  1.270796,  1.275940,  1.281300,  1.275744,  1.289047,  1.290326,  1.292199,  1.290017,  1.299385,  1.312061,  1.299790,  1.309123,  1.320042,  1.325115,  1.313021,  1.330422,  1.327758,  1.340225,  1.330816,  1.345878,  1.352185,  1.345940,  1.347005,  1.356630,  1.372960,  1.352210,  1.369484,  1.376847,  1.379865, },
{ 1.000000,  1.003536,  1.007928,  1.011270,  1.015054,  1.018237,  1.022789,  1.026926,  1.029194,  1.032933,  1.037780,  1.042007,  1.042869,  1.049101,  1.053345,  1.057141,  1.057833,  1.064198,  1.067527,  1.071275,  1.073486,  1.079409,  1.084320,  1.084720,  1.088552,  1.093099,  1.100706,  1.096262,  1.105867,  1.109250,  1.113659,  1.114464,  1.120939,  1.122935,  1.128050,  1.128067,  1.135837,  1.141246,  1.141823,  1.142846,  1.150558,  1.158185,  1.149919,  1.162514,  1.166099,  1.170350,  1.169310,  1.178455,  1.180662,  1.183430,  1.183598,  1.190510,  1.199124,  1.193698,  1.199707,  1.208963,  1.213349,  1.207064,  1.218776,  1.219748,  1.227170,  1.224161,  1.235179,  1.239231,  1.237544,  1.238567,  1.246242,  1.259524,  1.245723,  1.258076,  1.265497,  1.268206,  1.263002,  1.274807,  1.277509,  1.283416,  1.279742,  1.288986,  1.300208,  1.290405,  1.294750,  1.302938,  1.315253,  1.297793,  1.316006,  1.323376,  1.327918,  1.316852,  1.330585,  1.333968,  1.339916,  1.332807,  1.348310,  1.355634,  1.347347,  1.350946,  1.357051,  1.374648,  1.351744,  1.373668, },
{ 1.000000,  1.004232,  1.007958,  1.011759,  1.015517,  1.019600,  1.023414,  1.026692,  1.031204,  1.036065,  1.039230,  1.041712,  1.047550,  1.052107,  1.052206,  1.058865,  1.063129,  1.066974,  1.069003,  1.075414,  1.078400,  1.082429,  1.083848,  1.089956,  1.095994,  1.095235,  1.099786,  1.107105,  1.111305,  1.109813,  1.118326,  1.121018,  1.125771,  1.126891,  1.134208,  1.138821,  1.140028,  1.141018,  1.147633,  1.157416,  1.151061,  1.159847,  1.166018,  1.170012,  1.166595,  1.177089,  1.180272,  1.184607,  1.184322,  1.192724,  1.200240,  1.195745,  1.200033,  1.205994,  1.217095,  1.206637,  1.219568,  1.226299,  1.230340,  1.224289,  1.234942,  1.238501,  1.244629,  1.240354,  1.251838,  1.259343,  1.253344,  1.258449,  1.264015,  1.278216,  1.262740,  1.279072,  1.283101,  1.289839,  1.283643,  1.293837,  1.297094,  1.303484,  1.296466,  1.311036,  1.319548,  1.314710,  1.312256,  1.325953,  1.338855,  1.315543,  1.339235,  1.341782,  1.349425,  1.340227,  1.356896,  1.355037,  1.361900,  1.354259,  1.367042,  1.382601,  1.365850,  1.373354,  1.387102,  1.394479, },
{ 1.000000,  1.003449,  1.007786,  1.011135,  1.014764,  1.018544,  1.022602,  1.026180,  1.029778,  1.032759,  1.036909,  1.041555,  1.043172,  1.048005,  1.052294,  1.056680,  1.057419,  1.063093,  1.067594,  1.071080,  1.072274,  1.078763,  1.083309,  1.084134,  1.087773,  1.092640,  1.098939,  1.096471,  1.104499,  1.108635,  1.112698,  1.112050,  1.119311,  1.122314,  1.127367,  1.127153,  1.134452,  1.140412,  1.138714,  1.142418,  1.147874,  1.157124,  1.148733,  1.160101,  1.164570,  1.169589,  1.167025,  1.174643,  1.179283,  1.182638,  1.179619,  1.190767,  1.196510,  1.194713,  1.195795,  1.204598,  1.215142,  1.199864,  1.218116,  1.219694,  1.225358,  1.221446,  1.233534,  1.233897,  1.239085,  1.234534,  1.245305,  1.255096,  1.246393,  1.251418,  1.262200,  1.269328,  1.256958,  1.271728,  1.275711,  1.280982,  1.276895,  1.288658,  1.293904,  1.290918,  1.289984,  1.299990,  1.312874,  1.298673,  1.310841,  1.317763,  1.324666,  1.311108,  1.328687,  1.331293,  1.336559,  1.331233,  1.344794,  1.350195,  1.345094,  1.345502,  1.352796,  1.372432,  1.349835,  1.367113, },
{ 1.000000,  1.003588,  1.007801,  1.010702,  1.014597,  1.018075,  1.022488,  1.024965,  1.029319,  1.033502,  1.036035,  1.039571,  1.043306,  1.049325,  1.049246,  1.054644,  1.058664,  1.063592,  1.064565,  1.069066,  1.073126,  1.077137,  1.077595,  1.084995,  1.089660,  1.090266,  1.092716,  1.098436,  1.106230,  1.100348,  1.110972,  1.112995,  1.118604,  1.118394,  1.125621,  1.128063,  1.132806,  1.130669,  1.139084,  1.146336,  1.143439,  1.146719,  1.154750,  1.160843,  1.154045,  1.164815,  1.169296,  1.173691,  1.171883,  1.180189,  1.185200,  1.184759,  1.185713,  1.192674,  1.203046,  1.194395,  1.203236,  1.210682,  1.216080,  1.207718,  1.219972,  1.223998,  1.229029,  1.224465,  1.235387,  1.241860,  1.237655,  1.239686,  1.247524,  1.260524,  1.245033,  1.259581,  1.267255,  1.269882,  1.263025,  1.276009,  1.276739,  1.285135,  1.278047,  1.291005,  1.298601,  1.290175,  1.295119,  1.303067,  1.314893,  1.298441,  1.314165,  1.319765,  1.327520,  1.317477,  1.329867,  1.333661,  1.337433,  1.329067,  1.346901,  1.353721,  1.346863,  1.345756,  1.357952,  1.375757, },
{ 1.000000,  1.003317,  1.007728,  1.010905,  1.014636,  1.017577,  1.022256,  1.025298,  1.029144,  1.031217,  1.036592,  1.040780,  1.042581,  1.046324,  1.051253,  1.055590,  1.055163,  1.061897,  1.065530,  1.069394,  1.071368,  1.076871,  1.080642,  1.082580,  1.085046,  1.090350,  1.096782,  1.094342,  1.100278,  1.105983,  1.110990,  1.108671,  1.116651,  1.119492,  1.124347,  1.123701,  1.131896,  1.136351,  1.136086,  1.138306,  1.143775,  1.153441,  1.146041,  1.155662,  1.160940,  1.165558,  1.161139,  1.171825,  1.173334,  1.179770,  1.177510,  1.185512,  1.193375,  1.187254,  1.192085,  1.199507,  1.208197,  1.198309,  1.210237,  1.215123,  1.222567,  1.214782,  1.224834,  1.228893,  1.233437,  1.228354,  1.240913,  1.248035,  1.243536,  1.244606,  1.251643,  1.268000,  1.247497,  1.266904,  1.268119,  1.276699,  1.269280,  1.279857,  1.283273,  1.288526,  1.280381,  1.294310,  1.304460,  1.296986,  1.296609,  1.310806,  1.321092,  1.299935,  1.319594,  1.325196,  1.330457,  1.321854,  1.337423,  1.339965,  1.339316,  1.334946,  1.345967,  1.362505,  1.342989,  1.354323, },
{ 1.000000,  1.003525,  1.007741,  1.010393,  1.015037,  1.018262,  1.022812,  1.025207,  1.029443,  1.034040,  1.036234,  1.039941,  1.044050,  1.050227,  1.049508,  1.055639,  1.059819,  1.063666,  1.064637,  1.070316,  1.074310,  1.078129,  1.080004,  1.085017,  1.091251,  1.090200,  1.094101,  1.100012,  1.106300,  1.102590,  1.110839,  1.115748,  1.121350,  1.117590,  1.126268,  1.129704,  1.133723,  1.133074,  1.141689,  1.148330,  1.145094,  1.148459,  1.153771,  1.165880,  1.154485,  1.167743,  1.170839,  1.176396,  1.173751,  1.182257,  1.184800,  1.189546,  1.186906,  1.197031,  1.204321,  1.201462,  1.201127,  1.211763,  1.222505,  1.206312,  1.223507,  1.227991,  1.232265,  1.227428,  1.239449,  1.242754,  1.243489,  1.241758,  1.250213,  1.262610,  1.250918,  1.258433,  1.269438,  1.277125,  1.263480,  1.279089,  1.280317,  1.287051,  1.281563,  1.294938,  1.301745,  1.295697,  1.296376,  1.305325,  1.322739,  1.301214,  1.316626,  1.326092,  1.329321,  1.319016,  1.333921,  1.338773,  1.342458,  1.335991,  1.348117,  1.362301,  1.347086,  1.351416,  1.361819,  1.377341, },
{ 1.000000,  1.003289,  1.007500,  1.010859,  1.015103,  1.017597,  1.022252,  1.025827,  1.029117,  1.031980,  1.036780,  1.041468,  1.043109,  1.047087,  1.050618,  1.056731,  1.055830,  1.062398,  1.066363,  1.070984,  1.071442,  1.077166,  1.080419,  1.084980,  1.084849,  1.091931,  1.097585,  1.098034,  1.099459,  1.106724,  1.113598,  1.107065,  1.117966,  1.121572,  1.126652,  1.125215,  1.132696,  1.136590,  1.138864,  1.139037,  1.145527,  1.155004,  1.149017,  1.154300,  1.163207,  1.168879,  1.162134,  1.172705,  1.176243,  1.180432,  1.179037,  1.187873,  1.194151,  1.192740,  1.192402,  1.200323,  1.212358,  1.200332,  1.211013,  1.217940,  1.223668,  1.215354,  1.228052,  1.232422,  1.234987,  1.232436,  1.242181,  1.252654,  1.243616,  1.247772,  1.254668,  1.268154,  1.251923,  1.267578,  1.274348,  1.280515,  1.269475,  1.281552,  1.286130,  1.291871,  1.283899,  1.298888,  1.307684,  1.297767,  1.302335,  1.307837,  1.326854,  1.303850,  1.323426,  1.327242,  1.336730,  1.325459,  1.336473,  1.341660,  1.345975,  1.337291,  1.353106,  1.365194,  1.354789,  1.351757, },
{ 1.000000,  1.004025,  1.007708,  1.010782,  1.014747,  1.018739,  1.023023,  1.025373,  1.030394,  1.033597,  1.037646,  1.039513,  1.044560,  1.050405,  1.050499,  1.055019,  1.060097,  1.065287,  1.064819,  1.071025,  1.075048,  1.078764,  1.080529,  1.086028,  1.091547,  1.092877,  1.094275,  1.100092,  1.107740,  1.104351,  1.111599,  1.116607,  1.122092,  1.118442,  1.127041,  1.131735,  1.135285,  1.134631,  1.142430,  1.149559,  1.146343,  1.149591,  1.156449,  1.165444,  1.156813,  1.168332,  1.173351,  1.178585,  1.173372,  1.183193,  1.187472,  1.191712,  1.189028,  1.199122,  1.206909,  1.200804,  1.205423,  1.210830,  1.224674,  1.209088,  1.223739,  1.229327,  1.235769,  1.229813,  1.237999,  1.245345,  1.247536,  1.240869,  1.255455,  1.263536,  1.257095,  1.258160,  1.269469,  1.283569,  1.259077,  1.283748,  1.284034,  1.291366,  1.284119,  1.297849,  1.299658,  1.303820,  1.297068,  1.309696,  1.322879,  1.308774,  1.313787,  1.327271,  1.337878,  1.316957,  1.336981,  1.341560,  1.346477,  1.339012,  1.353534,  1.361802,  1.354578,  1.352642,  1.363372,  1.381474, },
{ 1.000000,  1.003821,  1.007321,  1.011356,  1.014869,  1.017701,  1.021917,  1.025942,  1.029450,  1.032359,  1.036603,  1.041180,  1.042995,  1.046529,  1.051085,  1.057137,  1.056329,  1.062142,  1.066934,  1.070808,  1.071146,  1.076820,  1.081008,  1.084757,  1.085568,  1.092497,  1.098223,  1.096787,  1.101089,  1.105502,  1.113924,  1.108496,  1.116975,  1.121964,  1.127430,  1.125482,  1.131008,  1.136845,  1.139803,  1.137495,  1.148756,  1.153760,  1.151588,  1.153313,  1.161390,  1.171812,  1.158679,  1.174352,  1.176076,  1.182239,  1.179453,  1.189154,  1.190876,  1.196110,  1.190836,  1.202299,  1.210811,  1.204324,  1.207750,  1.218232,  1.226156,  1.213014,  1.228651,  1.232207,  1.237568,  1.233024,  1.243647,  1.249653,  1.246643,  1.246598,  1.255456,  1.268347,  1.254205,  1.265680,  1.273374,  1.282677,  1.267044,  1.283463,  1.287350,  1.293091,  1.285089,  1.299010,  1.307169,  1.298778,  1.300689,  1.309713,  1.326871,  1.304097,  1.323336,  1.330373,  1.336101,  1.323352,  1.339402,  1.340511,  1.349086,  1.338587,  1.354055,  1.364179,  1.351014,  1.357681, },
{ 1.000000,  1.003910,  1.007501,  1.010706,  1.015156,  1.019172,  1.022715,  1.025459,  1.030086,  1.034242,  1.037437,  1.039885,  1.045603,  1.050277,  1.051692,  1.054995,  1.060252,  1.067287,  1.063181,  1.072431,  1.075228,  1.080565,  1.080829,  1.087313,  1.090526,  1.095221,  1.094145,  1.102040,  1.108504,  1.107445,  1.110062,  1.117287,  1.124458,  1.118245,  1.128256,  1.132402,  1.137183,  1.136810,  1.144114,  1.149063,  1.149618,  1.150751,  1.157387,  1.166607,  1.160044,  1.167630,  1.174183,  1.182024,  1.173738,  1.185860,  1.188540,  1.194170,  1.190391,  1.201941,  1.207613,  1.203497,  1.205893,  1.212816,  1.226332,  1.211972,  1.225952,  1.231725,  1.238616,  1.228452,  1.242887,  1.244877,  1.250602,  1.246494,  1.257266,  1.267703,  1.255591,  1.262303,  1.271457,  1.282392,  1.266219,  1.282979,  1.288554,  1.296827,  1.284555,  1.297468,  1.303299,  1.305990,  1.298871,  1.315147,  1.323836,  1.314741,  1.316821,  1.325238,  1.347053,  1.315722,  1.342361,  1.342274,  1.353544,  1.341522,  1.355122,  1.359217,  1.363917,  1.352586,  1.370670,  1.382700, },
{ 1.000000,  1.003817,  1.007018,  1.011169,  1.014750,  1.017088,  1.021503,  1.025549,  1.028961,  1.031711,  1.036834,  1.039972,  1.043108,  1.045441,  1.050323,  1.055709,  1.055681,  1.061107,  1.065513,  1.070756,  1.068923,  1.076742,  1.078861,  1.084313,  1.083733,  1.090959,  1.096459,  1.095554,  1.099037,  1.104027,  1.112681,  1.106571,  1.115538,  1.119955,  1.124994,  1.122167,  1.130295,  1.134446,  1.137460,  1.137808,  1.144069,  1.153039,  1.147414,  1.152343,  1.158907,  1.166957,  1.157657,  1.169825,  1.175455,  1.181286,  1.173699,  1.184763,  1.188694,  1.191457,  1.189326,  1.199997,  1.207697,  1.201435,  1.204592,  1.210773,  1.226791,  1.207643,  1.225424,  1.228382,  1.234992,  1.228795,  1.239917,  1.241261,  1.246046,  1.241887,  1.254258,  1.262656,  1.256140,  1.256238,  1.267639,  1.282346,  1.257568,  1.280497,  1.284607,  1.288111,  1.281778,  1.295661,  1.299622,  1.297137,  1.295851,  1.305528,  1.319333,  1.303711,  1.312661,  1.324584,  1.334702,  1.315028,  1.333742,  1.334937,  1.341867,  1.334195,  1.350192,  1.357537,  1.347782,  1.348369, },
{ 1.000000,  1.003834,  1.007414,  1.010500,  1.014075,  1.018153,  1.022132,  1.024229,  1.029017,  1.032493,  1.036182,  1.039032,  1.043178,  1.048441,  1.048721,  1.052976,  1.057732,  1.063156,  1.061634,  1.068529,  1.072874,  1.077574,  1.076354,  1.082935,  1.086848,  1.090379,  1.091188,  1.098304,  1.103317,  1.101826,  1.106351,  1.110543,  1.120057,  1.112647,  1.123121,  1.126449,  1.132668,  1.129363,  1.137817,  1.140499,  1.144645,  1.143464,  1.151869,  1.158780,  1.155902,  1.157532,  1.167210,  1.175503,  1.162686,  1.177676,  1.181423,  1.185997,  1.182867,  1.193223,  1.195992,  1.197083,  1.196517,  1.204463,  1.215354,  1.204965,  1.212860,  1.221994,  1.230077,  1.217703,  1.231752,  1.234487,  1.238399,  1.236366,  1.247014,  1.254395,  1.249045,  1.249444,  1.257800,  1.272501,  1.255798,  1.269236,  1.276233,  1.282491,  1.270727,  1.286106,  1.290853,  1.291856,  1.288207,  1.300831,  1.312071,  1.297981,  1.304563,  1.311462,  1.327861,  1.305162,  1.326412,  1.331671,  1.338682,  1.323650,  1.338627,  1.343813,  1.347775,  1.338845,  1.356568,  1.365628, },
{ 1.000000,  1.003705,  1.006977,  1.010780,  1.015320,  1.017585,  1.021765,  1.025552,  1.029795,  1.032254,  1.036420,  1.040260,  1.044001,  1.046353,  1.051396,  1.056220,  1.057701,  1.060904,  1.065806,  1.072319,  1.068612,  1.077915,  1.080748,  1.085169,  1.085552,  1.093026,  1.095326,  1.098765,  1.099575,  1.106499,  1.113194,  1.109471,  1.115206,  1.121803,  1.128035,  1.122333,  1.132766,  1.136327,  1.139342,  1.139865,  1.147878,  1.153717,  1.151425,  1.153159,  1.160427,  1.170403,  1.161792,  1.171634,  1.176790,  1.183571,  1.175853,  1.187331,  1.192920,  1.194887,  1.192148,  1.203187,  1.210268,  1.203985,  1.207832,  1.215422,  1.226855,  1.212652,  1.228725,  1.232579,  1.239223,  1.230458,  1.241865,  1.246940,  1.249482,  1.246884,  1.258840,  1.265852,  1.256848,  1.263675,  1.268751,  1.285957,  1.263185,  1.283195,  1.287205,  1.294540,  1.286066,  1.297142,  1.303246,  1.303717,  1.296690,  1.314362,  1.321965,  1.312132,  1.314714,  1.327311,  1.343460,  1.310897,  1.342701,  1.341421,  1.347725,  1.339024,  1.356834,  1.355986,  1.359109,  1.352066, },
{ 1.000000,  1.003779,  1.007791,  1.010469,  1.014337,  1.018447,  1.022879,  1.023893,  1.029170,  1.032998,  1.036677,  1.038871,  1.044085,  1.048286,  1.050260,  1.052899,  1.058030,  1.063871,  1.063261,  1.068788,  1.072513,  1.078389,  1.076601,  1.083678,  1.087697,  1.091242,  1.092431,  1.099042,  1.103811,  1.103201,  1.106939,  1.111203,  1.120508,  1.114173,  1.124175,  1.128366,  1.133062,  1.129993,  1.138399,  1.141914,  1.145873,  1.145071,  1.154468,  1.160342,  1.154749,  1.161454,  1.165298,  1.177293,  1.165149,  1.178556,  1.182805,  1.188990,  1.184234,  1.192325,  1.198142,  1.198699,  1.195680,  1.210361,  1.214969,  1.209302,  1.212391,  1.221698,  1.235565,  1.213757,  1.236128,  1.236020,  1.243132,  1.237834,  1.250193,  1.250848,  1.255067,  1.248366,  1.262688,  1.272028,  1.261910,  1.267042,  1.277540,  1.288552,  1.268508,  1.288712,  1.291892,  1.296252,  1.291403,  1.303886,  1.310170,  1.303178,  1.304880,  1.315201,  1.329131,  1.310540,  1.325959,  1.331466,  1.343237,  1.322707,  1.343220,  1.346718,  1.350471,  1.342614,  1.359606,  1.367013, },
{ 1.000000,  1.003637,  1.007348,  1.010645,  1.014962,  1.017297,  1.022057,  1.025238,  1.029195,  1.031380,  1.036479,  1.039353,  1.043396,  1.045654,  1.051191,  1.055035,  1.055875,  1.060576,  1.064829,  1.070281,  1.068205,  1.075998,  1.079575,  1.084254,  1.083921,  1.090305,  1.094292,  1.096603,  1.097458,  1.105698,  1.110386,  1.108983,  1.112264,  1.118556,  1.128305,  1.117106,  1.131826,  1.132807,  1.138771,  1.137156,  1.145601,  1.147653,  1.151629,  1.148854,  1.159232,  1.165900,  1.161927,  1.165514,  1.173068,  1.182334,  1.170290,  1.184468,  1.187789,  1.191948,  1.190723,  1.200442,  1.204278,  1.202065,  1.203432,  1.212537,  1.221446,  1.211571,  1.221191,  1.227835,  1.236924,  1.224045,  1.239342,  1.241916,  1.245644,  1.240944,  1.255533,  1.260935,  1.252718,  1.257044,  1.264683,  1.279526,  1.260007,  1.277729,  1.283035,  1.290700,  1.276206,  1.293782,  1.295538,  1.299608,  1.295322,  1.308519,  1.318465,  1.301905,  1.311215,  1.320317,  1.333128,  1.311454,  1.332386,  1.336249,  1.346088,  1.330994,  1.346101,  1.350606,  1.351942,  1.345617, },
{ 1.000000,  1.003743,  1.007557,  1.010354,  1.014022,  1.017860,  1.022714,  1.023100,  1.028781,  1.031982,  1.036354,  1.038545,  1.042953,  1.046477,  1.049967,  1.052033,  1.058004,  1.061996,  1.063046,  1.066571,  1.072140,  1.077605,  1.073645,  1.082686,  1.086594,  1.090178,  1.090448,  1.097874,  1.101311,  1.102396,  1.104070,  1.110460,  1.117872,  1.113448,  1.120881,  1.125807,  1.132407,  1.126095,  1.137631,  1.138396,  1.143920,  1.142192,  1.152283,  1.157653,  1.153061,  1.157739,  1.164108,  1.174320,  1.163705,  1.175418,  1.180142,  1.185577,  1.179193,  1.190223,  1.193681,  1.196021,  1.196278,  1.205027,  1.213790,  1.203307,  1.211196,  1.218175,  1.227495,  1.212718,  1.229890,  1.234948,  1.242009,  1.229795,  1.244107,  1.248183,  1.248634,  1.246862,  1.260164,  1.267729,  1.257588,  1.263396,  1.268683,  1.287939,  1.261861,  1.285007,  1.287304,  1.293128,  1.286230,  1.299770,  1.299995,  1.302333,  1.298627,  1.314428,  1.321267,  1.313009,  1.313252,  1.325918,  1.343443,  1.310323,  1.339667,  1.342571,  1.345383,  1.338515,  1.355851,  1.358135, },
{ 1.000000,  1.003596,  1.007165,  1.010456,  1.014481,  1.017171,  1.021203,  1.024573,  1.028931,  1.030361,  1.035686,  1.038448,  1.042133,  1.044798,  1.050275,  1.053672,  1.054820,  1.058727,  1.063633,  1.068921,  1.066939,  1.073938,  1.078379,  1.081742,  1.081423,  1.088483,  1.092298,  1.094315,  1.096443,  1.103026,  1.109028,  1.104768,  1.110656,  1.115933,  1.123297,  1.116145,  1.127585,  1.131690,  1.136628,  1.132171,  1.140937,  1.145241,  1.147263,  1.146801,  1.157269,  1.161562,  1.157311,  1.163088,  1.166569,  1.179476,  1.166035,  1.181133,  1.183295,  1.189757,  1.185035,  1.194813,  1.196864,  1.199470,  1.198459,  1.209166,  1.215262,  1.210531,  1.212729,  1.223051,  1.233246,  1.214241,  1.234840,  1.236831,  1.240484,  1.237429,  1.249789,  1.251459,  1.249843,  1.250121,  1.260540,  1.270689,  1.257412,  1.267487,  1.276484,  1.285842,  1.269037,  1.287082,  1.288923,  1.290032,  1.289924,  1.302622,  1.308916,  1.299645,  1.302005,  1.312326,  1.327352,  1.306214,  1.322655,  1.329101,  1.336257,  1.321156,  1.339709,  1.343919,  1.341962,  1.340305, },
{ 1.000000,  1.003658,  1.007458,  1.009988,  1.013804,  1.017540,  1.021895,  1.023605,  1.028023,  1.031696,  1.035721,  1.037341,  1.042341,  1.045559,  1.048846,  1.051158,  1.057113,  1.061156,  1.060926,  1.066054,  1.069518,  1.076767,  1.073359,  1.081169,  1.084370,  1.088984,  1.089232,  1.095470,  1.098157,  1.101086,  1.102508,  1.109875,  1.114921,  1.113227,  1.116631,  1.123382,  1.131790,  1.121092,  1.134751,  1.137321,  1.141450,  1.140441,  1.149241,  1.151057,  1.153311,  1.153466,  1.162066,  1.169593,  1.162390,  1.169521,  1.176398,  1.184491,  1.173808,  1.187225,  1.190085,  1.192110,  1.193228,  1.201879,  1.207498,  1.202792,  1.205463,  1.213763,  1.223961,  1.212800,  1.224224,  1.228967,  1.236496,  1.225707,  1.239614,  1.244630,  1.244551,  1.243192,  1.255632,  1.261978,  1.251673,  1.258988,  1.266539,  1.277721,  1.260065,  1.279718,  1.282688,  1.289463,  1.278123,  1.292036,  1.296149,  1.296933,  1.295451,  1.309344,  1.314842,  1.302236,  1.312498,  1.317329,  1.335387,  1.307665,  1.331325,  1.335209,  1.342083,  1.332500,  1.344758,  1.349891, },
{ 1.000000,  1.003553,  1.006946,  1.010375,  1.014092,  1.017008,  1.020587,  1.024697,  1.028647,  1.028943,  1.035278,  1.038331,  1.041554,  1.043873,  1.049328,  1.052123,  1.055409,  1.057165,  1.062628,  1.067549,  1.067396,  1.071992,  1.076215,  1.082017,  1.078956,  1.087452,  1.090963,  1.093104,  1.095161,  1.102035,  1.105997,  1.104844,  1.108113,  1.114423,  1.121390,  1.117269,  1.124556,  1.127816,  1.135041,  1.129483,  1.139514,  1.142476,  1.145175,  1.145957,  1.154889,  1.159221,  1.155021,  1.159893,  1.165365,  1.175926,  1.164958,  1.177251,  1.182128,  1.186616,  1.181480,  1.190859,  1.194112,  1.197425,  1.196095,  1.207731,  1.213357,  1.204017,  1.213178,  1.216288,  1.229866,  1.213247,  1.229533,  1.232968,  1.240197,  1.233714,  1.242641,  1.247798,  1.247332,  1.244804,  1.261016,  1.263961,  1.257080,  1.261142,  1.271075,  1.285630,  1.259177,  1.285191,  1.283695,  1.290062,  1.285616,  1.299283,  1.297901,  1.301313,  1.294546,  1.310926,  1.318736,  1.307377,  1.313730,  1.323680,  1.335404,  1.311875,  1.335838,  1.337763,  1.340010,  1.336942, },
{ 1.000000,  1.003583,  1.007207,  1.009887,  1.013381,  1.017251,  1.021338,  1.022741,  1.027105,  1.030812,  1.035167,  1.035696,  1.041092,  1.044634,  1.047906,  1.049735,  1.055272,  1.059223,  1.059717,  1.063365,  1.067895,  1.073885,  1.071476,  1.078513,  1.082582,  1.086510,  1.086111,  1.092754,  1.094997,  1.099052,  1.099900,  1.106918,  1.111001,  1.108670,  1.114971,  1.118685,  1.126055,  1.119760,  1.130456,  1.132890,  1.138748,  1.136411,  1.144139,  1.146610,  1.148366,  1.148850,  1.159101,  1.162353,  1.159685,  1.163668,  1.170431,  1.181460,  1.165056,  1.184072,  1.183461,  1.188907,  1.187153,  1.196962,  1.197249,  1.199997,  1.197359,  1.210025,  1.215570,  1.209943,  1.213942,  1.222028,  1.232323,  1.215650,  1.233401,  1.235726,  1.238574,  1.237964,  1.248408,  1.251725,  1.247410,  1.249459,  1.259401,  1.268134,  1.257051,  1.266419,  1.273203,  1.283371,  1.268186,  1.284609,  1.286426,  1.289354,  1.285236,  1.301451,  1.305167,  1.294329,  1.301479,  1.308618,  1.322923,  1.301992,  1.320853,  1.325828,  1.333124,  1.318045,  1.337145,  1.336875, },
{ 1.000000,  1.003488,  1.006879,  1.010140,  1.013868,  1.016346,  1.020328,  1.023393,  1.027510,  1.028866,  1.034105,  1.036978,  1.041210,  1.042648,  1.047711,  1.050423,  1.053470,  1.055937,  1.061906,  1.065351,  1.065704,  1.069684,  1.073730,  1.081182,  1.075792,  1.085597,  1.087301,  1.092355,  1.092478,  1.098688,  1.101197,  1.104245,  1.105149,  1.112426,  1.116540,  1.115980,  1.119266,  1.125159,  1.132849,  1.123810,  1.136355,  1.138954,  1.141926,  1.142314,  1.151192,  1.152852,  1.152272,  1.154825,  1.161742,  1.169745,  1.162593,  1.170717,  1.176705,  1.184098,  1.174108,  1.188227,  1.187715,  1.193240,  1.190303,  1.202179,  1.206719,  1.199608,  1.206089,  1.212170,  1.223081,  1.209787,  1.223492,  1.227702,  1.233023,  1.225226,  1.238171,  1.239600,  1.241043,  1.242272,  1.251673,  1.260258,  1.246274,  1.256983,  1.263296,  1.273412,  1.255739,  1.275049,  1.279251,  1.286962,  1.272912,  1.288760,  1.291009,  1.290471,  1.290033,  1.304585,  1.310131,  1.298713,  1.305577,  1.310725,  1.331201,  1.302044,  1.327732,  1.327313,  1.333933,  1.327973, },
{ 1.000000,  1.003500,  1.006872,  1.010318,  1.013013,  1.017036,  1.020526,  1.023394,  1.026568,  1.030686,  1.034851,  1.034455,  1.040942,  1.044080,  1.047348,  1.049852,  1.054608,  1.057587,  1.059599,  1.062890,  1.067511,  1.072362,  1.072295,  1.076486,  1.081323,  1.086837,  1.084256,  1.092257,  1.094208,  1.097103,  1.098984,  1.106345,  1.109591,  1.108125,  1.112888,  1.117753,  1.125053,  1.119499,  1.128099,  1.132786,  1.136607,  1.134166,  1.142512,  1.145301,  1.147273,  1.149111,  1.157170,  1.162894,  1.155523,  1.163065,  1.168372,  1.176364,  1.166369,  1.180626,  1.183296,  1.189094,  1.182731,  1.193159,  1.195840,  1.197947,  1.196930,  1.209700,  1.212180,  1.206894,  1.213884,  1.216467,  1.231467,  1.213155,  1.232211,  1.232099,  1.239947,  1.233962,  1.245918,  1.244684,  1.247739,  1.246588,  1.259426,  1.263424,  1.259328,  1.259912,  1.271433,  1.282693,  1.259302,  1.283709,  1.284461,  1.287843,  1.284998,  1.297944,  1.297666,  1.296008,  1.296832,  1.307320,  1.316562,  1.303806,  1.313044,  1.321939,  1.333158,  1.314033,  1.333778,  1.332994, },
{ 1.000000,  1.003375,  1.006733,  1.009899,  1.013340,  1.016237,  1.019601,  1.023341,  1.027615,  1.028525,  1.032891,  1.036496,  1.040411,  1.041750,  1.046573,  1.049644,  1.052409,  1.055323,  1.060694,  1.064600,  1.063832,  1.068873,  1.072690,  1.078403,  1.076034,  1.084186,  1.086390,  1.091062,  1.089849,  1.096743,  1.099175,  1.102119,  1.103288,  1.111426,  1.114342,  1.112838,  1.118885,  1.121113,  1.130528,  1.122609,  1.134477,  1.135909,  1.140932,  1.139622,  1.147215,  1.148026,  1.151665,  1.152392,  1.160719,  1.164447,  1.162944,  1.165948,  1.172991,  1.182522,  1.167504,  1.185349,  1.185672,  1.190200,  1.188720,  1.199027,  1.197700,  1.200736,  1.200508,  1.209984,  1.217171,  1.209263,  1.215910,  1.222528,  1.231999,  1.218848,  1.234843,  1.234847,  1.236840,  1.239094,  1.249134,  1.252288,  1.246764,  1.249753,  1.257944,  1.268871,  1.257392,  1.268102,  1.271720,  1.280307,  1.268668,  1.284308,  1.286797,  1.286360,  1.285564,  1.300220,  1.303627,  1.293081,  1.300525,  1.307574,  1.319115,  1.300726,  1.321967,  1.322517,  1.330084,  1.318420, },
{ 1.000000,  1.003390,  1.006701,  1.009569,  1.012760,  1.016656,  1.019965,  1.022465,  1.026274,  1.028948,  1.033787,  1.033888,  1.039638,  1.042555,  1.046733,  1.048008,  1.052714,  1.055509,  1.058569,  1.060559,  1.066287,  1.069418,  1.070524,  1.074125,  1.078852,  1.085512,  1.078979,  1.090189,  1.091246,  1.095245,  1.096360,  1.104059,  1.103698,  1.107373,  1.108872,  1.115406,  1.120124,  1.117808,  1.122824,  1.127536,  1.134956,  1.127634,  1.139714,  1.140462,  1.143050,  1.145036,  1.153458,  1.155372,  1.153896,  1.156918,  1.163480,  1.170936,  1.165231,  1.174249,  1.175268,  1.184449,  1.175958,  1.188470,  1.189404,  1.192625,  1.192694,  1.203294,  1.205277,  1.200777,  1.206411,  1.211408,  1.222488,  1.209950,  1.224116,  1.227284,  1.232821,  1.225479,  1.237453,  1.236791,  1.242012,  1.240391,  1.253427,  1.256724,  1.246837,  1.257198,  1.258791,  1.274771,  1.254616,  1.273694,  1.273700,  1.283581,  1.276446,  1.286585,  1.287477,  1.288277,  1.285791,  1.304454,  1.303565,  1.298282,  1.301668,  1.310519,  1.327723,  1.296936,  1.327476,  1.321553, },
{ 1.000000,  1.003336,  1.006553,  1.009712,  1.012681,  1.016112,  1.018901,  1.022388,  1.025821,  1.028145,  1.031724,  1.034991,  1.039433,  1.039344,  1.045674,  1.047654,  1.051058,  1.053695,  1.058732,  1.060784,  1.062237,  1.065965,  1.070469,  1.074866,  1.074087,  1.079929,  1.082975,  1.088293,  1.085617,  1.093745,  1.095894,  1.098424,  1.099862,  1.107360,  1.110025,  1.108061,  1.113262,  1.117911,  1.125074,  1.119171,  1.128637,  1.131655,  1.136406,  1.133618,  1.142682,  1.141611,  1.147104,  1.147043,  1.156003,  1.158278,  1.154828,  1.162255,  1.165124,  1.174025,  1.163824,  1.177686,  1.177726,  1.185592,  1.181161,  1.190714,  1.190275,  1.193109,  1.193058,  1.204938,  1.205695,  1.203493,  1.207637,  1.213562,  1.226762,  1.204961,  1.229086,  1.224380,  1.232419,  1.229199,  1.241347,  1.236968,  1.242142,  1.238476,  1.252283,  1.255636,  1.251441,  1.254912,  1.261339,  1.273871,  1.253688,  1.275086,  1.273859,  1.277525,  1.278286,  1.289472,  1.288493,  1.285036,  1.288886,  1.297427,  1.305057,  1.295031,  1.304945,  1.308923,  1.321530,  1.303848, },
{ 1.000000,  1.003318,  1.006532,  1.009831,  1.012366,  1.016353,  1.019424,  1.021849,  1.025488,  1.029009,  1.033279,  1.034129,  1.038495,  1.041684,  1.045699,  1.046475,  1.052347,  1.054196,  1.057771,  1.060283,  1.065308,  1.068633,  1.067926,  1.073299,  1.077297,  1.082561,  1.079616,  1.087922,  1.089704,  1.095356,  1.093867,  1.101007,  1.102145,  1.105599,  1.107137,  1.115245,  1.116249,  1.116428,  1.120538,  1.124388,  1.134407,  1.123563,  1.138052,  1.136979,  1.142978,  1.142180,  1.150221,  1.149719,  1.153658,  1.153717,  1.163402,  1.165476,  1.164499,  1.167748,  1.173898,  1.183861,  1.168987,  1.186096,  1.187025,  1.189622,  1.189380,  1.200664,  1.199418,  1.198997,  1.201996,  1.208917,  1.216918,  1.208717,  1.217390,  1.222400,  1.231878,  1.218393,  1.236376,  1.231723,  1.238810,  1.235341,  1.250032,  1.251050,  1.242989,  1.251785,  1.257325,  1.268964,  1.253088,  1.268029,  1.270913,  1.277790,  1.267618,  1.283783,  1.281484,  1.284176,  1.285260,  1.296534,  1.302497,  1.287725,  1.299964,  1.305260,  1.315978,  1.296458,  1.317868,  1.319212, },
{ 1.000000,  1.003316,  1.006274,  1.009872,  1.012879,  1.015564,  1.018646,  1.022702,  1.025748,  1.028052,  1.031565,  1.034847,  1.040153,  1.039240,  1.045637,  1.047196,  1.051359,  1.053246,  1.058456,  1.059575,  1.063220,  1.065737,  1.071496,  1.073965,  1.075335,  1.077925,  1.082650,  1.089887,  1.083113,  1.094219,  1.095946,  1.099033,  1.100769,  1.107916,  1.108140,  1.109475,  1.113271,  1.117988,  1.122989,  1.121269,  1.126449,  1.131161,  1.138400,  1.131142,  1.142438,  1.141609,  1.145745,  1.147295,  1.156885,  1.157608,  1.154601,  1.160651,  1.166018,  1.173922,  1.164990,  1.175611,  1.179328,  1.183836,  1.179443,  1.190604,  1.190674,  1.192700,  1.194528,  1.204404,  1.207831,  1.199551,  1.208484,  1.213639,  1.222215,  1.209084,  1.226172,  1.227278,  1.234446,  1.225634,  1.238051,  1.237274,  1.240747,  1.239722,  1.255195,  1.253789,  1.249274,  1.256103,  1.257224,  1.275064,  1.252562,  1.275514,  1.272236,  1.282493,  1.274959,  1.289163,  1.283718,  1.287605,  1.287518,  1.300917,  1.302032,  1.298995,  1.299967,  1.310913,  1.324217,  1.295375, },
{ 1.000000,  1.003237,  1.006387,  1.009134,  1.012174,  1.015864,  1.018612,  1.021584,  1.024100,  1.027711,  1.031368,  1.033158,  1.036871,  1.039998,  1.044469,  1.044525,  1.050419,  1.052298,  1.054928,  1.058129,  1.063267,  1.065622,  1.066691,  1.070445,  1.073859,  1.079481,  1.077803,  1.083538,  1.086785,  1.090942,  1.089805,  1.097351,  1.098851,  1.100900,  1.103521,  1.110591,  1.113330,  1.110584,  1.116950,  1.120097,  1.126774,  1.121030,  1.131755,  1.133329,  1.138770,  1.135096,  1.143887,  1.143984,  1.147820,  1.148234,  1.158484,  1.159138,  1.156643,  1.163720,  1.164790,  1.176404,  1.164088,  1.179039,  1.178647,  1.185440,  1.182719,  1.191530,  1.189353,  1.193371,  1.194708,  1.204093,  1.205893,  1.204019,  1.207290,  1.214099,  1.225292,  1.205400,  1.227244,  1.225376,  1.230121,  1.228045,  1.240750,  1.235736,  1.239191,  1.240140,  1.249061,  1.255433,  1.247594,  1.254005,  1.259953,  1.270582,  1.254156,  1.274063,  1.270682,  1.272624,  1.276025,  1.287260,  1.286538,  1.281561,  1.286445,  1.293793,  1.304687,  1.291867,  1.303642,  1.305396, },
{ 1.000000,  1.003201,  1.006098,  1.009116,  1.012132,  1.015117,  1.018145,  1.021464,  1.024385,  1.026391,  1.030081,  1.033502,  1.037116,  1.037750,  1.043057,  1.045575,  1.049737,  1.050223,  1.055450,  1.057256,  1.060510,  1.062622,  1.068192,  1.070288,  1.070988,  1.075606,  1.078221,  1.085021,  1.080356,  1.089012,  1.090552,  1.095370,  1.095996,  1.101524,  1.102934,  1.105014,  1.106414,  1.114586,  1.116351,  1.116294,  1.119377,  1.124695,  1.132996,  1.121811,  1.136745,  1.136042,  1.139828,  1.140700,  1.150073,  1.146784,  1.150552,  1.152341,  1.159482,  1.163461,  1.160101,  1.165136,  1.169841,  1.178537,  1.167335,  1.182485,  1.181865,  1.183899,  1.186830,  1.195735,  1.195223,  1.192430,  1.197220,  1.203442,  1.211073,  1.204048,  1.213546,  1.213574,  1.223998,  1.213499,  1.228205,  1.226640,  1.229255,  1.230763,  1.242498,  1.241963,  1.236224,  1.242626,  1.247265,  1.259860,  1.245349,  1.260014,  1.261916,  1.268424,  1.260703,  1.273889,  1.269265,  1.275234,  1.274452,  1.288852,  1.290188,  1.278964,  1.290344,  1.291371,  1.308540,  1.285545, },
{ 1.000000,  1.003110,  1.006164,  1.009002,  1.011810,  1.015201,  1.018075,  1.020996,  1.023755,  1.027554,  1.030046,  1.032403,  1.035492,  1.039246,  1.044289,  1.042159,  1.049172,  1.050742,  1.054519,  1.056940,  1.061599,  1.062320,  1.066033,  1.067626,  1.073467,  1.076406,  1.076531,  1.080262,  1.084181,  1.090070,  1.085845,  1.095356,  1.095914,  1.098890,  1.101775,  1.107598,  1.108943,  1.108259,  1.113162,  1.117768,  1.123113,  1.120356,  1.126789,  1.128519,  1.135745,  1.130460,  1.140546,  1.141297,  1.143263,  1.145270,  1.153924,  1.155146,  1.151626,  1.158133,  1.162134,  1.170467,  1.161988,  1.172756,  1.175286,  1.180841,  1.176279,  1.187411,  1.183309,  1.189575,  1.189681,  1.200022,  1.200166,  1.195916,  1.203956,  1.206965,  1.216982,  1.203628,  1.218638,  1.218706,  1.227086,  1.222681,  1.232554,  1.229578,  1.232506,  1.233095,  1.246081,  1.244896,  1.242582,  1.246021,  1.252146,  1.268007,  1.241969,  1.269129,  1.261774,  1.269945,  1.268730,  1.280605,  1.273296,  1.278892,  1.275824,  1.290321,  1.291485,  1.288214,  1.291354,  1.296930, },
{ 1.000000,  1.003156,  1.005796,  1.008840,  1.011741,  1.014741,  1.017824,  1.020749,  1.023402,  1.025785,  1.029114,  1.032182,  1.035662,  1.037406,  1.040905,  1.043572,  1.048161,  1.048335,  1.053779,  1.055120,  1.058017,  1.060537,  1.066374,  1.068263,  1.068064,  1.072596,  1.076120,  1.081697,  1.079097,  1.085209,  1.088052,  1.092949,  1.091033,  1.098433,  1.098545,  1.102024,  1.104246,  1.110796,  1.113303,  1.110513,  1.116110,  1.120209,  1.126466,  1.120758,  1.130101,  1.131411,  1.137820,  1.135207,  1.142891,  1.142000,  1.145508,  1.147026,  1.156329,  1.155810,  1.155939,  1.159083,  1.162972,  1.174616,  1.160007,  1.176188,  1.174296,  1.179995,  1.180448,  1.187751,  1.185677,  1.189776,  1.189379,  1.199680,  1.201221,  1.200213,  1.201752,  1.207916,  1.219925,  1.201696,  1.219749,  1.220404,  1.222179,  1.223853,  1.234003,  1.231723,  1.229967,  1.234447,  1.239875,  1.248206,  1.240569,  1.247416,  1.252405,  1.262831,  1.248436,  1.266750,  1.260274,  1.265820,  1.265261,  1.279600,  1.279496,  1.269177,  1.279678,  1.284171,  1.296958,  1.280199, },
{ 1.000000,  1.002993,  1.006013,  1.009177,  1.011717,  1.015278,  1.017931,  1.020792,  1.023890,  1.027507,  1.030716,  1.031897,  1.035790,  1.039472,  1.043528,  1.043617,  1.048745,  1.051708,  1.055957,  1.056022,  1.061445,  1.063159,  1.065716,  1.068649,  1.074358,  1.076386,  1.077170,  1.080359,  1.083667,  1.091788,  1.085778,  1.094782,  1.096237,  1.100387,  1.102025,  1.107777,  1.107049,  1.110733,  1.112903,  1.120476,  1.122216,  1.123281,  1.124514,  1.129931,  1.140040,  1.127448,  1.141641,  1.143288,  1.144785,  1.147392,  1.154642,  1.154402,  1.154324,  1.159019,  1.163529,  1.168946,  1.166263,  1.170116,  1.175358,  1.184523,  1.175016,  1.187665,  1.185483,  1.188804,  1.192054,  1.202010,  1.202035,  1.196605,  1.203535,  1.208952,  1.219133,  1.207440,  1.217621,  1.221634,  1.226757,  1.221763,  1.233013,  1.232411,  1.232763,  1.236655,  1.247010,  1.249734,  1.239481,  1.248551,  1.253943,  1.263729,  1.248712,  1.265094,  1.266629,  1.275908,  1.266313,  1.278179,  1.276863,  1.279385,  1.278702,  1.295950,  1.292551,  1.288130,  1.293680,  1.294459, },
{ 1.000000,  1.003081,  1.005605,  1.008980,  1.011803,  1.015025,  1.017523,  1.021064,  1.023869,  1.026848,  1.029534,  1.033504,  1.036289,  1.038537,  1.040863,  1.045010,  1.049821,  1.047586,  1.054442,  1.056946,  1.059500,  1.062254,  1.066847,  1.068938,  1.070981,  1.074023,  1.078183,  1.082425,  1.082151,  1.085459,  1.089788,  1.095987,  1.092219,  1.100179,  1.101000,  1.103220,  1.107105,  1.112993,  1.115145,  1.114112,  1.118126,  1.122545,  1.129833,  1.125323,  1.130839,  1.134417,  1.140228,  1.136640,  1.145439,  1.146435,  1.146841,  1.150826,  1.159199,  1.161891,  1.156516,  1.162828,  1.167228,  1.175297,  1.166799,  1.177907,  1.179549,  1.186900,  1.180693,  1.190255,  1.189835,  1.192750,  1.193360,  1.206385,  1.205651,  1.202008,  1.208355,  1.209784,  1.224736,  1.207963,  1.223807,  1.223971,  1.230381,  1.228552,  1.236213,  1.233842,  1.237267,  1.238037,  1.249445,  1.251301,  1.248241,  1.249606,  1.257658,  1.272588,  1.246984,  1.270772,  1.269682,  1.272764,  1.272321,  1.284063,  1.279044,  1.281603,  1.282039,  1.292697,  1.299941,  1.290656, },
{ 1.000000,  1.002841,  1.005785,  1.009032,  1.011144,  1.014767,  1.017374,  1.020495,  1.023624,  1.027127,  1.029749,  1.031718,  1.034721,  1.038168,  1.042277,  1.043155,  1.046639,  1.049473,  1.054127,  1.053939,  1.059380,  1.062242,  1.064077,  1.066866,  1.072574,  1.074684,  1.074325,  1.078450,  1.082204,  1.087641,  1.085069,  1.091675,  1.093718,  1.099219,  1.097452,  1.104542,  1.105340,  1.108005,  1.110462,  1.117694,  1.118693,  1.117878,  1.122167,  1.125439,  1.134753,  1.125323,  1.135613,  1.137826,  1.143472,  1.143184,  1.148400,  1.149827,  1.151730,  1.151866,  1.161982,  1.163446,  1.161907,  1.164068,  1.170719,  1.181781,  1.164344,  1.182889,  1.182658,  1.185458,  1.186174,  1.196172,  1.192534,  1.195926,  1.196930,  1.204799,  1.209354,  1.205195,  1.208131,  1.214024,  1.225432,  1.210184,  1.227471,  1.226920,  1.227201,  1.231066,  1.241180,  1.239974,  1.235299,  1.239726,  1.247329,  1.255968,  1.247914,  1.255692,  1.254993,  1.270295,  1.255535,  1.271696,  1.269776,  1.270837,  1.273804,  1.286118,  1.285419,  1.277922,  1.283753,  1.288849, },
{ 1.000000,  1.002946,  1.005926,  1.008984,  1.011832,  1.015014,  1.017707,  1.021207,  1.023517,  1.026556,  1.029412,  1.033613,  1.036259,  1.037443,  1.041381,  1.044062,  1.049399,  1.047939,  1.053857,  1.056364,  1.060695,  1.061696,  1.066051,  1.068263,  1.070539,  1.072550,  1.079474,  1.080627,  1.081861,  1.084502,  1.089225,  1.096861,  1.089265,  1.100128,  1.100512,  1.104487,  1.106276,  1.112656,  1.111707,  1.115841,  1.115457,  1.123923,  1.126467,  1.126141,  1.128654,  1.133549,  1.141893,  1.132628,  1.144936,  1.145757,  1.148025,  1.150765,  1.157995,  1.158385,  1.156602,  1.161333,  1.167286,  1.173287,  1.168985,  1.174645,  1.176871,  1.187401,  1.177503,  1.189762,  1.190139,  1.191822,  1.193682,  1.203621,  1.204709,  1.199330,  1.205076,  1.210527,  1.221194,  1.209612,  1.220159,  1.223504,  1.231264,  1.223887,  1.236802,  1.231167,  1.237904,  1.236727,  1.249769,  1.249556,  1.243812,  1.250138,  1.254378,  1.267330,  1.250309,  1.265491,  1.266665,  1.276700,  1.269670,  1.280425,  1.277401,  1.280090,  1.279787,  1.294732,  1.292522,  1.290952, },
{ 1.000000,  1.002727,  1.005982,  1.009255,  1.010823,  1.014708,  1.017573,  1.020729,  1.023201,  1.027104,  1.028954,  1.032114,  1.034326,  1.038791,  1.041246,  1.043499,  1.046199,  1.049585,  1.054870,  1.053010,  1.059453,  1.061492,  1.064519,  1.067259,  1.071881,  1.073186,  1.074737,  1.078074,  1.082431,  1.086367,  1.086903,  1.089800,  1.093143,  1.100142,  1.096294,  1.103866,  1.105208,  1.107845,  1.109454,  1.117868,  1.118516,  1.116879,  1.121623,  1.125987,  1.133036,  1.127607,  1.134856,  1.137611,  1.144380,  1.139821,  1.149491,  1.147724,  1.151314,  1.153624,  1.161838,  1.163921,  1.159767,  1.164892,  1.170136,  1.178494,  1.168529,  1.179047,  1.181395,  1.189727,  1.183784,  1.193136,  1.191802,  1.195502,  1.195538,  1.207740,  1.205930,  1.206403,  1.206544,  1.212433,  1.228043,  1.206736,  1.226556,  1.224058,  1.230775,  1.230645,  1.238210,  1.234951,  1.239910,  1.237415,  1.250748,  1.250932,  1.250881,  1.250201,  1.257392,  1.273826,  1.248365,  1.269838,  1.270897,  1.272456,  1.272676,  1.285225,  1.282068,  1.279600,  1.282754,  1.290070, },
{ 1.000000,  1.002789,  1.005813,  1.008529,  1.011324,  1.014683,  1.016743,  1.020573,  1.022573,  1.025646,  1.028263,  1.032364,  1.034745,  1.035997,  1.039736,  1.042878,  1.047301,  1.047044,  1.051558,  1.054337,  1.058628,  1.058733,  1.064191,  1.065292,  1.067984,  1.071086,  1.075672,  1.078820,  1.077673,  1.082104,  1.085893,  1.091132,  1.087719,  1.094645,  1.097503,  1.103364,  1.099904,  1.107588,  1.107970,  1.110359,  1.112989,  1.120545,  1.121310,  1.121823,  1.123391,  1.127432,  1.138642,  1.127018,  1.138821,  1.139696,  1.144508,  1.144936,  1.151975,  1.149348,  1.154266,  1.154119,  1.163549,  1.164136,  1.165862,  1.164315,  1.170790,  1.184565,  1.165363,  1.182953,  1.184924,  1.186001,  1.187315,  1.196274,  1.194393,  1.194677,  1.197996,  1.203852,  1.208553,  1.206851,  1.208124,  1.213954,  1.226992,  1.211978,  1.226789,  1.223468,  1.228116,  1.229092,  1.241237,  1.240114,  1.234179,  1.239082,  1.246317,  1.258208,  1.244490,  1.253578,  1.257922,  1.265375,  1.257151,  1.269725,  1.268071,  1.269458,  1.271347,  1.283129,  1.285853,  1.275684, },
{ 1.000000,  1.002645,  1.005789,  1.008725,  1.010698,  1.013918,  1.017086,  1.020454,  1.021949,  1.025836,  1.028044,  1.030929,  1.032816,  1.037939,  1.039624,  1.041844,  1.044586,  1.047184,  1.053348,  1.050989,  1.057131,  1.058958,  1.063285,  1.064189,  1.068891,  1.069459,  1.073675,  1.074727,  1.080323,  1.082420,  1.084693,  1.085150,  1.090232,  1.097945,  1.089872,  1.099817,  1.101819,  1.104934,  1.106781,  1.112139,  1.112671,  1.115043,  1.116315,  1.121715,  1.126463,  1.125416,  1.127204,  1.132258,  1.141323,  1.132909,  1.143560,  1.142554,  1.145833,  1.148567,  1.156036,  1.156674,  1.155243,  1.158116,  1.163407,  1.172337,  1.165827,  1.170839,  1.173787,  1.182350,  1.175866,  1.186199,  1.185430,  1.186556,  1.189959,  1.198975,  1.201297,  1.195871,  1.199647,  1.205303,  1.215460,  1.203952,  1.215945,  1.216226,  1.227753,  1.217272,  1.228363,  1.226341,  1.231262,  1.228787,  1.244225,  1.241827,  1.239706,  1.242662,  1.244918,  1.263822,  1.241307,  1.259064,  1.258692,  1.267405,  1.263458,  1.271608,  1.267400,  1.273846,  1.270318,  1.284292, },
{ 1.000000,  1.002671,  1.005665,  1.008141,  1.010925,  1.014978,  1.015736,  1.019730,  1.022470,  1.025385,  1.027521,  1.031051,  1.033189,  1.036218,  1.037831,  1.042312,  1.045646,  1.046810,  1.049241,  1.052430,  1.058088,  1.056127,  1.062369,  1.063404,  1.066715,  1.069511,  1.073901,  1.075936,  1.077227,  1.078984,  1.083601,  1.089101,  1.087917,  1.091026,  1.093567,  1.100964,  1.097147,  1.104880,  1.105760,  1.108031,  1.109598,  1.117147,  1.118443,  1.117573,  1.120358,  1.124938,  1.132762,  1.126618,  1.134571,  1.135390,  1.143872,  1.138724,  1.147422,  1.146235,  1.150337,  1.150733,  1.160430,  1.159877,  1.159661,  1.161786,  1.165448,  1.178161,  1.163822,  1.176389,  1.177224,  1.185317,  1.182940,  1.188058,  1.188883,  1.192712,  1.188740,  1.202366,  1.202830,  1.201871,  1.201424,  1.208472,  1.223961,  1.199484,  1.221902,  1.219407,  1.223972,  1.223483,  1.234299,  1.228739,  1.235079,  1.231733,  1.241887,  1.246763,  1.243165,  1.243208,  1.248924,  1.265189,  1.243696,  1.264114,  1.261192,  1.263925,  1.265462,  1.277545,  1.274425,  1.271648, },
{ 1.000000,  1.002531,  1.005577,  1.008382,  1.010681,  1.013371,  1.016115,  1.019921,  1.020959,  1.024691,  1.027039,  1.029876,  1.032137,  1.036275,  1.038471,  1.040053,  1.042301,  1.045909,  1.051082,  1.050047,  1.054212,  1.056818,  1.061694,  1.061086,  1.066198,  1.066869,  1.070951,  1.071664,  1.078232,  1.080234,  1.080198,  1.083160,  1.085634,  1.094129,  1.087897,  1.095341,  1.096988,  1.103425,  1.102302,  1.106831,  1.108320,  1.111430,  1.110883,  1.120145,  1.120255,  1.121482,  1.121646,  1.127128,  1.138300,  1.124613,  1.138342,  1.137051,  1.142707,  1.144011,  1.150047,  1.147404,  1.153814,  1.149662,  1.159893,  1.162247,  1.162045,  1.162929,  1.166893,  1.179202,  1.165154,  1.179763,  1.178377,  1.182571,  1.184305,  1.191156,  1.190498,  1.190416,  1.192185,  1.198728,  1.205524,  1.201729,  1.205540,  1.205707,  1.220876,  1.206956,  1.220475,  1.218289,  1.223519,  1.222750,  1.232928,  1.233642,  1.229389,  1.231640,  1.238130,  1.251375,  1.237113,  1.247392,  1.248263,  1.260915,  1.250082,  1.264141,  1.255179,  1.266313,  1.261032,  1.275139, },
{ 1.000000,  1.002567,  1.005419,  1.007868,  1.010480,  1.013701,  1.015496,  1.018733,  1.021094,  1.024991,  1.026426,  1.029675,  1.031529,  1.034852,  1.036469,  1.040664,  1.043183,  1.045544,  1.046604,  1.050226,  1.056992,  1.052358,  1.059844,  1.060534,  1.065157,  1.066524,  1.070585,  1.071108,  1.075641,  1.074620,  1.081456,  1.083589,  1.085746,  1.085922,  1.089573,  1.098432,  1.090926,  1.100132,  1.101039,  1.104710,  1.106659,  1.111915,  1.112073,  1.113326,  1.115436,  1.120365,  1.124501,  1.124877,  1.126505,  1.128638,  1.139412,  1.131937,  1.140765,  1.139885,  1.144555,  1.144462,  1.153300,  1.153449,  1.152366,  1.154475,  1.159367,  1.169140,  1.161224,  1.167629,  1.168984,  1.179972,  1.171560,  1.182197,  1.178040,  1.185245,  1.184414,  1.193039,  1.195770,  1.191873,  1.193406,  1.199134,  1.211122,  1.197275,  1.207681,  1.209671,  1.221050,  1.212620,  1.221526,  1.218721,  1.225267,  1.221943,  1.234965,  1.232745,  1.235834,  1.230654,  1.237503,  1.258418,  1.230428,  1.251879,  1.247481,  1.257659,  1.255770,  1.262474,  1.257670,  1.267304, },
{ 1.000000,  1.002403,  1.005442,  1.007925,  1.010408,  1.012483,  1.015673,  1.019502,  1.019525,  1.023458,  1.026182,  1.028918,  1.030905,  1.034739,  1.036504,  1.038849,  1.040552,  1.044278,  1.048037,  1.049271,  1.051461,  1.054317,  1.060380,  1.057387,  1.063754,  1.063969,  1.068293,  1.068864,  1.074786,  1.076797,  1.076792,  1.079529,  1.083013,  1.089908,  1.086532,  1.090658,  1.093007,  1.099706,  1.096292,  1.103426,  1.103105,  1.107078,  1.108475,  1.113361,  1.117219,  1.115287,  1.117346,  1.121666,  1.129770,  1.122733,  1.129794,  1.132480,  1.141434,  1.134471,  1.142666,  1.142085,  1.145769,  1.145988,  1.154439,  1.154965,  1.157515,  1.154156,  1.159171,  1.175083,  1.157600,  1.170295,  1.170452,  1.177682,  1.176922,  1.182885,  1.178651,  1.187536,  1.182841,  1.193232,  1.194719,  1.197611,  1.191712,  1.197989,  1.217956,  1.191469,  1.210180,  1.212288,  1.215504,  1.215418,  1.223078,  1.220821,  1.223670,  1.223141,  1.229104,  1.235239,  1.234736,  1.231546,  1.237316,  1.256034,  1.235662,  1.250773,  1.246082,  1.254458,  1.252730,  1.263848, },
{ 1.000000,  1.002452,  1.005169,  1.007476,  1.010543,  1.013678,  1.015155,  1.018114,  1.020605,  1.024239,  1.025388,  1.029240,  1.031079,  1.033949,  1.036017,  1.039609,  1.042683,  1.043702,  1.045446,  1.049409,  1.054215,  1.052890,  1.057255,  1.059719,  1.065283,  1.063456,  1.068455,  1.069735,  1.073714,  1.073465,  1.080325,  1.081259,  1.083941,  1.083937,  1.086707,  1.097286,  1.088944,  1.096842,  1.098310,  1.104661,  1.103422,  1.108396,  1.107623,  1.113435,  1.111707,  1.118887,  1.121388,  1.124090,  1.120798,  1.127148,  1.138821,  1.124078,  1.136532,  1.138567,  1.141979,  1.143339,  1.148144,  1.148198,  1.151940,  1.150250,  1.156757,  1.162221,  1.161380,  1.159879,  1.165529,  1.178810,  1.165253,  1.176735,  1.174999,  1.180240,  1.181878,  1.188738,  1.189857,  1.188956,  1.187920,  1.194082,  1.206943,  1.198426,  1.200016,  1.203664,  1.216033,  1.205683,  1.216188,  1.214846,  1.218488,  1.218776,  1.227941,  1.231775,  1.227068,  1.225721,  1.232573,  1.247761,  1.232275,  1.242767,  1.242589,  1.258472,  1.243895,  1.255233,  1.252502,  1.259751, },
{ 1.000000,  1.002304,  1.005263,  1.007568,  1.010397,  1.012464,  1.014856,  1.018980,  1.019251,  1.022695,  1.025103,  1.028530,  1.030471,  1.033277,  1.034751,  1.038594,  1.039382,  1.043731,  1.046263,  1.048426,  1.049197,  1.052842,  1.059500,  1.054552,  1.061162,  1.063238,  1.066994,  1.067770,  1.072222,  1.072678,  1.077301,  1.076136,  1.081534,  1.086047,  1.086156,  1.085640,  1.090038,  1.099192,  1.092315,  1.100157,  1.100269,  1.103933,  1.106118,  1.111147,  1.112341,  1.113961,  1.113178,  1.118472,  1.126089,  1.123533,  1.124522,  1.127295,  1.137996,  1.129955,  1.138632,  1.139027,  1.142385,  1.141838,  1.150031,  1.151904,  1.150783,  1.149870,  1.156147,  1.166797,  1.157863,  1.164461,  1.164638,  1.177278,  1.168345,  1.177095,  1.175555,  1.180846,  1.179226,  1.189398,  1.188756,  1.190455,  1.187471,  1.192365,  1.209964,  1.189821,  1.202403,  1.202961,  1.214526,  1.209850,  1.213734,  1.214157,  1.220479,  1.212205,  1.226978,  1.228259,  1.229630,  1.223002,  1.231745,  1.252428,  1.221155,  1.244547,  1.241879,  1.248788,  1.246522,  1.256313, },
{ 1.000000,  1.002277,  1.005081,  1.007098,  1.009717,  1.012212,  1.014804,  1.016491,  1.019150,  1.023408,  1.023145,  1.027036,  1.029167,  1.031864,  1.033825,  1.037184,  1.039276,  1.041451,  1.042231,  1.046390,  1.050285,  1.051012,  1.052817,  1.054617,  1.061563,  1.058593,  1.064246,  1.065148,  1.068532,  1.069690,  1.074529,  1.076313,  1.077368,  1.077766,  1.081763,  1.089615,  1.085864,  1.089402,  1.091682,  1.098902,  1.095451,  1.100657,  1.100495,  1.106226,  1.104499,  1.112019,  1.113939,  1.114276,  1.113748,  1.116861,  1.129690,  1.118718,  1.125735,  1.127420,  1.136730,  1.133188,  1.136377,  1.138246,  1.142617,  1.138528,  1.149703,  1.150226,  1.151896,  1.146875,  1.155304,  1.169887,  1.150384,  1.165119,  1.163167,  1.170972,  1.170909,  1.176108,  1.172401,  1.181761,  1.172650,  1.185441,  1.187920,  1.188702,  1.184119,  1.190189,  1.206384,  1.186934,  1.202130,  1.200556,  1.206612,  1.206675,  1.212628,  1.211662,  1.213890,  1.210542,  1.219230,  1.228038,  1.223338,  1.222760,  1.224889,  1.243974,  1.224962,  1.238238,  1.236665,  1.243123, },
{ 1.000000,  1.002568,  1.004948,  1.007683,  1.009781,  1.012018,  1.014637,  1.018201,  1.019137,  1.022056,  1.024329,  1.028344,  1.028723,  1.032593,  1.033480,  1.037736,  1.038236,  1.042691,  1.044717,  1.046813,  1.047337,  1.051210,  1.057024,  1.054351,  1.058393,  1.060666,  1.066856,  1.065632,  1.069721,  1.070429,  1.074620,  1.073886,  1.080249,  1.082054,  1.084906,  1.081932,  1.088245,  1.097907,  1.087212,  1.097492,  1.096408,  1.103238,  1.103237,  1.107357,  1.106235,  1.113064,  1.108193,  1.117254,  1.119585,  1.122073,  1.118198,  1.123925,  1.136399,  1.123392,  1.133649,  1.134577,  1.139453,  1.140389,  1.145213,  1.145028,  1.147468,  1.145783,  1.152840,  1.158096,  1.158212,  1.155367,  1.159457,  1.174256,  1.161723,  1.171271,  1.169993,  1.176453,  1.173356,  1.183815,  1.183785,  1.183143,  1.180692,  1.188533,  1.201406,  1.190215,  1.194510,  1.196779,  1.211209,  1.198088,  1.209976,  1.204993,  1.214260,  1.209960,  1.220096,  1.222781,  1.221249,  1.215843,  1.225193,  1.240139,  1.223073,  1.231105,  1.233621,  1.248811,  1.237230,  1.245709, },
{ 1.000000,  1.002492,  1.004800,  1.007176,  1.009796,  1.012192,  1.014955,  1.016075,  1.019323,  1.023383,  1.022661,  1.027064,  1.028331,  1.032477,  1.033801,  1.036751,  1.037796,  1.042143,  1.042022,  1.046740,  1.048992,  1.051539,  1.050905,  1.055365,  1.062495,  1.056647,  1.063115,  1.065059,  1.068978,  1.069711,  1.074118,  1.074677,  1.077876,  1.077799,  1.081946,  1.086925,  1.087368,  1.086977,  1.090820,  1.100497,  1.092937,  1.100612,  1.099516,  1.105372,  1.104250,  1.111469,  1.112956,  1.112885,  1.112761,  1.118097,  1.127532,  1.121362,  1.123850,  1.126875,  1.136227,  1.129757,  1.137465,  1.136100,  1.141456,  1.140767,  1.146568,  1.150762,  1.149751,  1.147037,  1.154129,  1.164224,  1.154634,  1.160601,  1.162959,  1.176083,  1.164649,  1.174029,  1.172277,  1.177401,  1.175158,  1.185530,  1.185769,  1.189689,  1.180330,  1.188850,  1.208625,  1.184618,  1.198988,  1.197483,  1.208568,  1.205675,  1.211696,  1.204908,  1.217628,  1.208716,  1.221182,  1.223130,  1.227306,  1.214092,  1.224959,  1.249691,  1.215079,  1.236065,  1.237746,  1.242867, },
{ 1.000000,  1.002466,  1.004683,  1.007139,  1.009708,  1.011539,  1.014253,  1.017112,  1.019497,  1.020612,  1.023593,  1.028276,  1.027484,  1.031402,  1.032869,  1.036100,  1.037716,  1.041641,  1.043406,  1.045081,  1.046122,  1.050069,  1.055337,  1.054042,  1.056573,  1.059229,  1.064413,  1.063125,  1.067385,  1.068486,  1.072626,  1.072718,  1.077620,  1.080429,  1.081344,  1.080183,  1.085815,  1.092700,  1.087948,  1.092732,  1.094402,  1.103023,  1.098115,  1.103490,  1.103887,  1.108804,  1.106294,  1.116086,  1.115249,  1.119225,  1.115204,  1.119142,  1.133500,  1.119670,  1.129544,  1.129195,  1.139277,  1.135105,  1.140146,  1.137967,  1.146463,  1.141251,  1.149976,  1.152960,  1.156243,  1.147473,  1.157237,  1.172495,  1.151144,  1.165763,  1.166943,  1.172327,  1.172402,  1.176711,  1.175555,  1.181626,  1.176479,  1.184432,  1.190864,  1.190126,  1.184152,  1.191449,  1.209118,  1.190380,  1.202995,  1.199917,  1.206908,  1.206663,  1.214035,  1.215094,  1.215669,  1.209484,  1.218529,  1.233227,  1.223533,  1.221282,  1.226647,  1.241920,  1.227736,  1.239218, },
{ 1.000000,  1.002376,  1.004909,  1.006848,  1.009529,  1.012014,  1.014298,  1.015630,  1.018678,  1.022192,  1.023063,  1.025567,  1.027611,  1.032244,  1.032157,  1.035390,  1.036887,  1.040230,  1.040928,  1.045930,  1.047350,  1.049828,  1.050107,  1.053260,  1.060297,  1.055661,  1.061250,  1.062384,  1.068105,  1.067747,  1.070996,  1.071376,  1.076485,  1.074795,  1.080752,  1.083790,  1.085950,  1.082846,  1.088586,  1.099023,  1.087384,  1.096728,  1.097661,  1.103492,  1.102805,  1.106873,  1.106762,  1.112744,  1.108585,  1.115866,  1.121076,  1.120786,  1.116719,  1.122147,  1.135741,  1.123164,  1.133459,  1.131766,  1.136962,  1.137688,  1.143402,  1.144210,  1.146781,  1.141798,  1.149700,  1.159328,  1.154911,  1.153595,  1.156795,  1.171237,  1.158497,  1.168725,  1.168402,  1.172663,  1.169359,  1.180337,  1.181056,  1.181230,  1.174855,  1.184717,  1.197436,  1.186162,  1.190821,  1.191257,  1.207568,  1.195039,  1.203687,  1.202058,  1.208006,  1.204034,  1.217076,  1.215866,  1.218332,  1.209979,  1.217631,  1.238626,  1.214029,  1.227168,  1.226143,  1.241856, },
{ 1.000000,  1.002326,  1.004750,  1.006730,  1.009243,  1.010916,  1.014102,  1.016441,  1.018782,  1.019528,  1.022816,  1.027392,  1.025474,  1.030439,  1.031611,  1.035081,  1.036371,  1.039787,  1.040937,  1.044671,  1.044169,  1.048712,  1.051763,  1.053327,  1.052852,  1.056466,  1.063929,  1.058555,  1.065231,  1.066026,  1.069734,  1.070452,  1.075044,  1.076507,  1.078573,  1.076848,  1.082781,  1.087964,  1.087461,  1.088086,  1.089400,  1.100101,  1.092621,  1.099929,  1.099816,  1.104332,  1.104065,  1.110084,  1.111723,  1.112391,  1.109665,  1.116157,  1.126305,  1.119325,  1.122124,  1.124839,  1.135440,  1.127858,  1.133914,  1.133406,  1.139793,  1.135766,  1.146136,  1.147621,  1.147371,  1.143541,  1.148800,  1.164808,  1.149666,  1.156621,  1.157518,  1.171144,  1.164808,  1.167229,  1.169163,  1.174114,  1.167192,  1.181479,  1.181786,  1.183881,  1.173816,  1.185366,  1.204184,  1.178103,  1.195006,  1.190536,  1.202186,  1.200276,  1.205205,  1.201324,  1.212592,  1.198779,  1.215119,  1.217407,  1.218278,  1.209605,  1.217246,  1.238372,  1.212231,  1.230276, },
{ 1.000000,  1.002228,  1.004694,  1.006540,  1.008931,  1.011134,  1.013480,  1.015058,  1.017694,  1.020572,  1.022297,  1.023915,  1.025882,  1.030632,  1.029858,  1.033607,  1.035224,  1.038108,  1.039118,  1.042800,  1.045265,  1.046524,  1.046517,  1.050959,  1.056258,  1.054635,  1.056524,  1.059013,  1.065449,  1.062643,  1.067756,  1.066996,  1.072447,  1.070890,  1.077243,  1.079114,  1.080138,  1.078452,  1.083624,  1.091951,  1.085641,  1.089666,  1.091420,  1.100503,  1.096623,  1.100316,  1.100925,  1.105363,  1.102868,  1.110861,  1.112528,  1.115134,  1.108884,  1.117088,  1.130344,  1.113120,  1.126129,  1.122950,  1.133199,  1.130566,  1.134945,  1.133044,  1.140923,  1.133089,  1.144772,  1.146302,  1.149206,  1.141862,  1.148539,  1.164936,  1.146078,  1.158505,  1.158028,  1.165423,  1.163804,  1.168958,  1.169415,  1.171533,  1.166441,  1.176110,  1.181393,  1.181519,  1.175685,  1.180277,  1.199004,  1.181929,  1.192262,  1.190829,  1.198168,  1.192310,  1.204257,  1.205593,  1.202429,  1.197725,  1.208667,  1.222003,  1.209660,  1.210977,  1.213923,  1.232414, },
{ 1.000000,  1.002115,  1.004519,  1.006229,  1.008669,  1.010459,  1.013252,  1.015522,  1.017136,  1.018368,  1.021488,  1.025032,  1.024833,  1.027278,  1.029534,  1.034098,  1.033966,  1.036499,  1.038024,  1.041354,  1.041601,  1.046326,  1.047640,  1.050427,  1.048804,  1.053185,  1.060671,  1.053875,  1.060510,  1.060484,  1.067034,  1.066318,  1.069108,  1.069771,  1.074967,  1.071810,  1.078899,  1.080382,  1.083214,  1.079409,  1.084733,  1.095687,  1.083827,  1.092546,  1.093677,  1.098727,  1.097960,  1.102386,  1.103365,  1.105907,  1.103533,  1.109166,  1.114781,  1.114501,  1.111835,  1.116300,  1.129598,  1.116694,  1.126191,  1.123415,  1.131368,  1.127474,  1.135796,  1.138648,  1.135637,  1.134487,  1.141777,  1.152191,  1.144293,  1.144353,  1.148266,  1.160474,  1.150200,  1.158304,  1.156539,  1.163070,  1.159987,  1.166906,  1.171866,  1.169291,  1.163949,  1.174009,  1.184625,  1.173179,  1.176764,  1.179597,  1.197269,  1.181143,  1.190376,  1.189153,  1.193896,  1.189878,  1.202558,  1.202150,  1.205544,  1.193785,  1.202906,  1.226383,  1.197379,  1.212270, },
{ 1.000000,  1.002052,  1.004492,  1.006420,  1.008605,  1.010103,  1.012853,  1.014139,  1.017066,  1.019280,  1.021609,  1.021810,  1.024992,  1.030276,  1.027200,  1.031484,  1.033512,  1.036537,  1.037879,  1.040451,  1.042013,  1.044647,  1.045299,  1.048728,  1.051346,  1.053129,  1.052277,  1.055785,  1.063744,  1.058634,  1.063524,  1.063714,  1.069050,  1.068600,  1.072865,  1.075059,  1.075112,  1.074417,  1.079901,  1.086980,  1.083085,  1.084269,  1.087727,  1.094899,  1.090477,  1.094885,  1.095455,  1.100700,  1.098761,  1.104795,  1.107902,  1.107438,  1.103917,  1.111934,  1.119160,  1.112775,  1.116279,  1.117651,  1.130390,  1.121748,  1.126198,  1.127098,  1.132444,  1.127560,  1.139451,  1.137710,  1.141755,  1.135050,  1.140030,  1.157416,  1.139244,  1.149285,  1.147503,  1.162320,  1.154520,  1.158404,  1.156775,  1.165676,  1.158907,  1.168731,  1.171464,  1.175050,  1.162281,  1.173745,  1.192258,  1.165573,  1.181088,  1.181286,  1.190381,  1.188695,  1.190473,  1.191080,  1.196206,  1.189707,  1.198835,  1.205438,  1.203318,  1.194903,  1.203255,  1.225357, },
{ 1.000000,  1.001943,  1.004175,  1.006040,  1.008362,  1.010536,  1.012751,  1.015050,  1.016808,  1.017926,  1.020830,  1.024212,  1.024962,  1.026189,  1.028671,  1.033253,  1.032666,  1.035753,  1.037214,  1.040218,  1.040979,  1.044394,  1.047130,  1.048188,  1.047548,  1.052209,  1.057485,  1.055474,  1.057645,  1.059150,  1.067045,  1.063332,  1.066745,  1.068083,  1.072028,  1.070481,  1.077933,  1.078480,  1.080455,  1.078500,  1.081894,  1.092657,  1.083474,  1.089413,  1.089497,  1.099131,  1.096477,  1.097702,  1.098573,  1.104889,  1.100702,  1.107561,  1.111172,  1.113594,  1.107090,  1.113823,  1.127970,  1.110799,  1.121237,  1.120886,  1.130032,  1.127904,  1.130254,  1.130408,  1.137448,  1.130467,  1.139143,  1.145134,  1.143753,  1.136434,  1.143037,  1.161221,  1.143479,  1.154117,  1.151600,  1.159946,  1.158151,  1.162492,  1.165635,  1.166817,  1.159290,  1.168436,  1.180137,  1.174050,  1.170479,  1.173790,  1.191898,  1.175487,  1.185226,  1.184621,  1.191511,  1.185622,  1.196404,  1.198292,  1.197545,  1.187630,  1.200006,  1.214617,  1.201807,  1.203090, },
{ 1.000000,  1.001901,  1.004268,  1.006107,  1.008220,  1.010115,  1.012290,  1.013825,  1.016580,  1.018730,  1.020666,  1.021378,  1.023841,  1.028530,  1.026930,  1.030316,  1.031571,  1.036643,  1.036729,  1.038083,  1.040322,  1.043739,  1.042686,  1.047600,  1.049576,  1.051646,  1.050072,  1.054472,  1.062420,  1.054100,  1.061792,  1.061199,  1.067287,  1.067236,  1.069874,  1.070089,  1.074972,  1.072473,  1.077977,  1.081504,  1.082339,  1.079141,  1.083485,  1.094669,  1.084483,  1.092487,  1.091613,  1.097906,  1.096896,  1.100867,  1.103053,  1.104950,  1.099996,  1.107685,  1.114391,  1.112050,  1.111764,  1.111793,  1.126863,  1.115689,  1.122875,  1.121291,  1.128797,  1.126205,  1.132125,  1.134106,  1.134436,  1.128956,  1.136557,  1.149753,  1.140333,  1.141077,  1.143478,  1.157941,  1.147512,  1.152185,  1.151984,  1.159493,  1.153217,  1.164706,  1.166575,  1.165517,  1.159685,  1.164098,  1.184379,  1.165989,  1.171716,  1.171176,  1.190373,  1.181408,  1.180477,  1.184724,  1.190208,  1.180373,  1.196275,  1.195981,  1.197983,  1.185802,  1.197519,  1.220551, },
{ 1.000000,  1.001746,  1.003880,  1.005714,  1.008223,  1.009891,  1.011810,  1.013363,  1.016356,  1.016792,  1.019912,  1.021904,  1.023830,  1.024402,  1.026877,  1.031853,  1.029470,  1.033771,  1.034467,  1.038460,  1.039276,  1.041309,  1.043431,  1.045729,  1.044880,  1.048793,  1.052945,  1.053311,  1.053493,  1.055122,  1.063130,  1.058673,  1.063173,  1.063317,  1.068577,  1.067389,  1.071110,  1.074139,  1.074591,  1.072473,  1.077904,  1.085839,  1.081604,  1.082374,  1.084301,  1.094048,  1.088311,  1.093281,  1.091241,  1.099017,  1.094741,  1.102462,  1.104080,  1.104857,  1.100903,  1.105747,  1.117841,  1.107991,  1.111749,  1.112017,  1.125592,  1.119222,  1.121421,  1.122051,  1.127921,  1.122439,  1.131745,  1.133853,  1.136328,  1.127338,  1.135811,  1.153156,  1.130844,  1.144926,  1.138850,  1.154193,  1.150364,  1.152787,  1.149362,  1.160078,  1.149011,  1.161782,  1.163598,  1.166785,  1.156352,  1.162469,  1.183488,  1.160600,  1.173211,  1.170173,  1.182640,  1.179725,  1.182251,  1.182698,  1.186930,  1.178363,  1.188241,  1.195371,  1.194962,  1.186653, },
{ 1.000000,  1.001742,  1.004211,  1.005550,  1.007623,  1.009119,  1.011919,  1.012963,  1.015360,  1.017343,  1.018968,  1.019918,  1.022560,  1.026038,  1.026395,  1.027660,  1.029484,  1.034423,  1.033281,  1.036254,  1.036642,  1.040840,  1.040566,  1.044346,  1.046605,  1.047670,  1.046930,  1.050324,  1.056400,  1.053510,  1.055706,  1.056742,  1.064955,  1.062131,  1.064163,  1.065061,  1.069955,  1.067392,  1.073567,  1.074908,  1.077764,  1.073614,  1.077696,  1.089767,  1.077480,  1.085695,  1.083086,  1.093741,  1.091303,  1.093264,  1.092681,  1.100448,  1.093637,  1.102267,  1.103775,  1.106821,  1.100064,  1.105988,  1.120551,  1.103632,  1.113816,  1.112905,  1.121500,  1.119344,  1.122693,  1.123015,  1.127293,  1.121800,  1.127434,  1.135262,  1.133993,  1.129023,  1.133261,  1.150407,  1.134301,  1.143394,  1.138279,  1.151408,  1.143619,  1.151848,  1.155786,  1.152399,  1.149076,  1.156052,  1.169800,  1.160028,  1.158006,  1.161328,  1.177081,  1.164741,  1.171246,  1.168721,  1.178816,  1.172395,  1.178792,  1.185664,  1.182804,  1.174834,  1.183785,  1.197997, },
{ 1.000000,  1.001679,  1.003637,  1.005283,  1.007909,  1.008948,  1.010969,  1.012554,  1.015048,  1.015784,  1.018658,  1.020630,  1.022475,  1.022525,  1.024787,  1.030329,  1.027422,  1.030670,  1.031591,  1.036587,  1.036654,  1.038522,  1.039128,  1.043579,  1.042030,  1.046304,  1.048405,  1.050815,  1.047930,  1.051594,  1.061048,  1.051751,  1.058298,  1.059453,  1.064210,  1.064249,  1.066235,  1.067287,  1.070882,  1.069016,  1.072734,  1.076675,  1.078370,  1.074596,  1.077823,  1.089845,  1.081150,  1.085675,  1.084247,  1.093312,  1.089483,  1.094566,  1.097371,  1.096619,  1.093200,  1.099659,  1.109366,  1.103049,  1.102942,  1.105770,  1.115254,  1.109970,  1.112536,  1.112493,  1.120848,  1.115235,  1.121928,  1.126453,  1.124830,  1.118652,  1.126686,  1.137392,  1.128576,  1.131452,  1.130459,  1.148600,  1.136255,  1.139089,  1.140053,  1.148737,  1.138341,  1.153289,  1.151716,  1.155507,  1.146968,  1.148921,  1.172269,  1.150042,  1.159665,  1.155836,  1.176207,  1.165230,  1.167245,  1.165824,  1.178084,  1.166309,  1.177273,  1.181030,  1.184565,  1.169536, },
{ 1.000000,  1.001617,  1.003908,  1.004767,  1.006888,  1.008566,  1.010917,  1.012277,  1.014016,  1.015637,  1.017783,  1.018517,  1.020794,  1.023461,  1.024750,  1.024696,  1.027097,  1.032419,  1.030166,  1.033009,  1.033793,  1.037810,  1.037819,  1.040528,  1.042938,  1.044011,  1.042897,  1.046444,  1.051726,  1.050982,  1.050166,  1.052635,  1.059214,  1.056402,  1.059093,  1.059886,  1.064387,  1.062720,  1.066948,  1.070289,  1.070430,  1.066999,  1.072251,  1.079612,  1.075767,  1.077155,  1.077041,  1.088782,  1.082114,  1.084539,  1.085433,  1.091309,  1.085552,  1.096041,  1.096157,  1.097331,  1.094203,  1.095579,  1.110592,  1.097862,  1.103805,  1.101518,  1.115379,  1.110566,  1.109571,  1.111226,  1.119583,  1.110979,  1.119808,  1.123239,  1.125582,  1.117204,  1.123189,  1.140263,  1.119136,  1.130299,  1.128245,  1.140877,  1.136719,  1.137775,  1.137761,  1.146535,  1.136292,  1.145089,  1.152722,  1.151026,  1.140811,  1.146584,  1.167929,  1.148321,  1.157585,  1.153900,  1.165934,  1.160154,  1.165580,  1.168890,  1.170975,  1.158888,  1.168327,  1.182554, },
{ 1.000000,  1.001847,  1.003263,  1.005044,  1.007471,  1.008341,  1.010395,  1.011967,  1.014179,  1.014933,  1.017906,  1.019410,  1.020992,  1.021097,  1.023799,  1.027713,  1.027413,  1.028701,  1.029929,  1.035590,  1.033957,  1.035990,  1.037695,  1.040607,  1.039791,  1.044757,  1.045944,  1.047520,  1.046375,  1.048192,  1.056767,  1.050758,  1.054941,  1.054430,  1.063205,  1.060768,  1.061148,  1.063748,  1.068183,  1.063179,  1.070931,  1.072347,  1.074087,  1.070668,  1.074663,  1.086227,  1.072351,  1.082590,  1.079705,  1.088318,  1.086544,  1.089401,  1.088400,  1.094608,  1.089548,  1.095784,  1.100075,  1.100316,  1.094668,  1.099057,  1.113255,  1.099378,  1.108176,  1.105821,  1.115187,  1.110483,  1.116317,  1.117509,  1.120087,  1.111503,  1.119721,  1.129333,  1.125612,  1.123567,  1.121990,  1.140454,  1.127195,  1.134114,  1.130630,  1.141240,  1.134668,  1.143507,  1.144195,  1.144684,  1.136244,  1.143688,  1.159823,  1.149123,  1.148567,  1.149471,  1.167094,  1.154055,  1.157616,  1.157901,  1.167743,  1.156516,  1.171258,  1.172810,  1.171181,  1.163702, },
{ 1.000000,  1.001663,  1.003505,  1.004701,  1.006500,  1.007721,  1.010598,  1.011548,  1.012731,  1.014665,  1.016994,  1.016739,  1.020442,  1.021680,  1.023206,  1.022980,  1.025853,  1.030761,  1.027061,  1.031589,  1.031108,  1.035965,  1.036189,  1.038343,  1.038382,  1.042855,  1.039945,  1.045250,  1.047006,  1.048327,  1.046625,  1.049468,  1.057142,  1.050367,  1.056374,  1.055533,  1.061223,  1.060178,  1.063400,  1.063910,  1.066623,  1.063331,  1.068009,  1.074039,  1.072355,  1.071471,  1.072639,  1.082961,  1.075955,  1.080648,  1.079725,  1.086420,  1.082568,  1.088869,  1.090360,  1.090080,  1.086278,  1.092117,  1.101933,  1.095541,  1.096204,  1.096913,  1.109180,  1.100396,  1.105786,  1.102680,  1.112339,  1.104493,  1.115382,  1.115875,  1.115779,  1.110365,  1.114904,  1.129029,  1.115727,  1.121300,  1.119002,  1.135700,  1.127168,  1.128669,  1.129470,  1.136558,  1.127100,  1.139480,  1.140525,  1.142402,  1.131963,  1.140761,  1.159826,  1.133143,  1.149777,  1.140800,  1.159084,  1.153059,  1.156128,  1.150826,  1.164469,  1.148974,  1.164674,  1.165491, },
{ 1.000000,  1.001671,  1.003018,  1.004703,  1.007061,  1.007265,  1.009578,  1.010630,  1.013257,  1.014268,  1.016257,  1.017489,  1.019478,  1.019597,  1.022213,  1.024610,  1.025654,  1.025745,  1.027594,  1.032658,  1.030787,  1.033670,  1.033728,  1.038214,  1.036458,  1.041101,  1.042066,  1.042578,  1.042141,  1.045605,  1.051135,  1.048642,  1.049424,  1.050866,  1.057901,  1.053869,  1.057550,  1.056677,  1.062307,  1.059354,  1.065713,  1.067153,  1.067260,  1.064786,  1.068291,  1.076659,  1.070064,  1.073519,  1.072896,  1.083982,  1.078666,  1.080695,  1.080870,  1.086839,  1.080863,  1.090651,  1.090234,  1.093012,  1.086997,  1.091223,  1.106388,  1.088373,  1.099294,  1.094172,  1.107518,  1.103579,  1.105703,  1.103318,  1.113358,  1.102984,  1.114786,  1.114577,  1.116618,  1.108831,  1.115674,  1.131641,  1.109597,  1.123405,  1.119897,  1.130597,  1.126150,  1.131893,  1.129516,  1.134209,  1.126728,  1.133300,  1.142779,  1.138957,  1.133490,  1.138108,  1.155951,  1.137421,  1.148575,  1.140184,  1.156118,  1.144318,  1.157793,  1.158510,  1.153848,  1.150312, },
{ 1.000000,  1.001514,  1.003241,  1.004470,  1.005613,  1.007143,  1.009472,  1.010115,  1.011910,  1.013047,  1.015318,  1.015795,  1.018020,  1.019896,  1.020787,  1.021068,  1.023303,  1.026935,  1.025725,  1.027567,  1.028219,  1.034231,  1.031455,  1.034131,  1.035039,  1.037979,  1.036269,  1.041637,  1.042295,  1.044112,  1.042110,  1.043905,  1.053317,  1.044969,  1.050325,  1.048842,  1.056832,  1.054769,  1.056973,  1.055578,  1.062083,  1.057321,  1.063804,  1.065259,  1.066884,  1.062030,  1.066454,  1.078796,  1.062845,  1.073261,  1.071815,  1.078721,  1.077186,  1.079864,  1.079387,  1.083420,  1.079351,  1.084038,  1.088546,  1.088750,  1.084011,  1.087177,  1.101249,  1.089001,  1.095576,  1.091033,  1.102958,  1.096130,  1.104177,  1.104879,  1.103160,  1.098239,  1.105168,  1.117126,  1.107649,  1.107242,  1.110410,  1.120313,  1.113786,  1.116467,  1.115242,  1.124499,  1.116187,  1.126236,  1.129179,  1.125673,  1.119348,  1.126658,  1.139633,  1.126688,  1.132865,  1.128032,  1.149456,  1.134167,  1.137721,  1.137517,  1.147273,  1.133605,  1.153303,  1.148608, },
{ 1.000000,  1.001473,  1.002650,  1.003974,  1.006321,  1.006432,  1.008396,  1.009231,  1.012237,  1.012502,  1.013924,  1.014996,  1.017622,  1.017193,  1.020069,  1.021676,  1.023185,  1.021932,  1.024979,  1.029860,  1.024839,  1.029538,  1.029372,  1.033996,  1.033805,  1.034914,  1.036222,  1.038839,  1.037043,  1.040282,  1.044186,  1.043442,  1.041584,  1.044809,  1.052583,  1.046296,  1.050760,  1.049144,  1.055692,  1.053278,  1.057061,  1.059205,  1.059533,  1.055920,  1.060174,  1.068099,  1.064169,  1.062514,  1.065159,  1.073326,  1.068201,  1.071451,  1.070570,  1.076879,  1.072688,  1.078631,  1.082070,  1.080210,  1.075135,  1.080777,  1.090805,  1.083149,  1.085681,  1.083422,  1.098460,  1.088661,  1.091135,  1.091604,  1.097999,  1.089390,  1.103621,  1.101903,  1.102125,  1.097848,  1.098142,  1.117350,  1.098782,  1.107514,  1.101547,  1.119957,  1.112741,  1.110646,  1.112273,  1.121715,  1.109636,  1.121577,  1.123996,  1.125366,  1.115173,  1.121723,  1.141656,  1.113898,  1.128899,  1.123280,  1.140594,  1.132948,  1.134244,  1.134231,  1.142899,  1.129925, },
{ 1.000000,  1.001328,  1.002761,  1.004093,  1.004873,  1.006424,  1.008889,  1.008781,  1.010788,  1.011436,  1.014052,  1.014293,  1.016420,  1.017906,  1.019174,  1.018305,  1.020875,  1.024679,  1.023996,  1.024175,  1.025613,  1.030618,  1.028260,  1.030761,  1.031305,  1.035057,  1.032662,  1.037550,  1.039028,  1.039015,  1.036761,  1.040329,  1.047029,  1.043191,  1.043987,  1.044141,  1.053206,  1.048553,  1.049571,  1.052059,  1.054795,  1.051491,  1.058987,  1.059765,  1.059777,  1.056825,  1.058068,  1.070895,  1.059454,  1.064705,  1.062260,  1.074888,  1.070121,  1.068358,  1.072571,  1.077116,  1.068094,  1.079242,  1.079927,  1.080584,  1.074548,  1.079699,  1.094797,  1.074037,  1.086983,  1.081996,  1.093743,  1.089000,  1.091945,  1.091014,  1.097335,  1.088665,  1.097435,  1.103023,  1.100418,  1.091855,  1.098703,  1.114899,  1.096074,  1.106538,  1.102459,  1.115257,  1.105625,  1.114263,  1.114890,  1.116728,  1.104617,  1.113889,  1.127400,  1.119262,  1.116155,  1.114249,  1.135910,  1.119522,  1.126343,  1.121445,  1.135150,  1.124715,  1.135245,  1.136614, },
{ 1.000000,  1.001218,  1.002332,  1.003559,  1.005471,  1.006014,  1.007157,  1.008244,  1.010858,  1.010840,  1.011968,  1.013477,  1.015482,  1.014833,  1.018140,  1.019495,  1.019878,  1.019636,  1.020813,  1.026791,  1.023018,  1.025096,  1.025172,  1.031740,  1.029541,  1.029566,  1.032584,  1.034829,  1.031099,  1.037688,  1.038262,  1.039186,  1.035703,  1.039917,  1.048477,  1.038395,  1.044621,  1.042673,  1.050435,  1.047757,  1.049727,  1.049941,  1.055103,  1.047720,  1.055976,  1.058286,  1.057786,  1.053264,  1.057711,  1.067548,  1.056229,  1.063149,  1.061351,  1.069875,  1.065021,  1.069483,  1.070366,  1.072213,  1.065093,  1.071328,  1.080313,  1.075436,  1.072553,  1.073910,  1.087295,  1.076858,  1.080812,  1.080236,  1.088876,  1.081122,  1.088410,  1.091799,  1.088499,  1.082681,  1.088729,  1.103390,  1.092111,  1.091109,  1.091735,  1.108045,  1.095062,  1.099255,  1.098465,  1.107418,  1.096522,  1.109609,  1.111541,  1.107779,  1.100914,  1.105027,  1.124497,  1.105190,  1.110253,  1.107879,  1.128349,  1.115964,  1.115815,  1.120334,  1.125635,  1.112373, },
{ 1.000000,  1.001148,  1.002415,  1.003450,  1.004121,  1.005533,  1.007913,  1.006906,  1.009008,  1.009401,  1.012373,  1.012304,  1.013709,  1.014243,  1.016883,  1.015102,  1.018717,  1.020286,  1.020919,  1.019384,  1.021859,  1.026855,  1.022225,  1.025783,  1.025970,  1.030496,  1.028634,  1.031167,  1.032286,  1.033749,  1.030720,  1.034493,  1.038799,  1.038015,  1.035162,  1.037694,  1.045463,  1.039857,  1.042494,  1.042456,  1.048350,  1.043103,  1.049433,  1.050764,  1.049255,  1.046602,  1.050702,  1.059420,  1.053315,  1.051985,  1.054145,  1.064033,  1.056201,  1.058904,  1.059692,  1.064820,  1.058830,  1.067085,  1.069619,  1.066660,  1.062574,  1.066166,  1.078434,  1.066983,  1.069455,  1.068895,  1.083308,  1.073920,  1.074970,  1.077757,  1.082575,  1.072712,  1.085718,  1.085299,  1.086671,  1.077222,  1.082128,  1.102031,  1.077398,  1.088411,  1.083752,  1.100387,  1.091727,  1.093276,  1.092633,  1.103086,  1.087063,  1.102502,  1.103807,  1.103442,  1.091235,  1.100794,  1.119845,  1.091287,  1.105145,  1.103548,  1.115949,  1.106577,  1.113701,  1.113275, },
{ 1.000000,  1.001113,  1.001870,  1.003079,  1.004640,  1.005228,  1.005691,  1.007093,  1.009468,  1.008777,  1.010510,  1.010821,  1.013539,  1.012644,  1.015421,  1.016649,  1.016539,  1.016506,  1.018287,  1.022649,  1.020700,  1.020260,  1.022318,  1.026641,  1.024253,  1.025544,  1.027094,  1.029469,  1.027640,  1.031133,  1.033823,  1.032176,  1.030731,  1.033573,  1.039653,  1.034456,  1.036065,  1.036625,  1.045571,  1.038546,  1.041243,  1.043418,  1.045171,  1.040756,  1.049236,  1.049460,  1.049880,  1.045034,  1.046948,  1.061054,  1.046054,  1.052348,  1.050988,  1.061224,  1.056014,  1.057262,  1.057043,  1.063750,  1.054741,  1.064403,  1.066634,  1.066264,  1.057227,  1.063945,  1.079983,  1.056370,  1.068560,  1.068935,  1.075662,  1.071520,  1.074424,  1.075302,  1.078212,  1.070055,  1.076766,  1.084225,  1.081209,  1.072842,  1.078257,  1.094820,  1.078429,  1.083627,  1.081595,  1.093785,  1.082863,  1.093166,  1.095097,  1.091115,  1.082130,  1.090762,  1.107761,  1.092794,  1.088761,  1.095766,  1.106550,  1.097046,  1.097647,  1.100654,  1.108233,  1.096385, },
{ 1.000000,  1.000979,  1.002103,  1.002756,  1.003315,  1.004593,  1.006402,  1.005993,  1.007353,  1.007820,  1.010765,  1.009856,  1.010744,  1.012296,  1.013583,  1.012356,  1.016513,  1.016543,  1.017466,  1.016286,  1.017374,  1.023260,  1.017938,  1.021126,  1.020999,  1.026446,  1.023856,  1.024481,  1.025992,  1.028706,  1.025329,  1.030288,  1.031936,  1.032300,  1.027736,  1.032386,  1.039555,  1.028327,  1.035344,  1.035499,  1.040238,  1.038481,  1.039083,  1.040993,  1.042863,  1.038178,  1.042738,  1.048525,  1.044984,  1.040530,  1.045207,  1.055102,  1.044607,  1.049202,  1.048806,  1.054343,  1.050297,  1.055078,  1.057846,  1.056159,  1.049658,  1.055579,  1.066074,  1.058127,  1.054408,  1.059148,  1.067575,  1.060229,  1.062698,  1.063810,  1.068289,  1.062259,  1.069563,  1.075055,  1.069143,  1.061398,  1.069403,  1.081334,  1.069420,  1.071822,  1.070007,  1.086432,  1.073755,  1.074824,  1.079196,  1.081877,  1.071089,  1.089374,  1.087327,  1.084336,  1.077496,  1.079668,  1.101724,  1.077331,  1.086706,  1.081584,  1.100631,  1.091359,  1.087038,  1.092517, },
{ 1.000000,  1.000852,  1.001457,  1.002618,  1.003657,  1.004416,  1.004423,  1.005750,  1.008038,  1.006065,  1.008457,  1.008903,  1.011077,  1.010922,  1.011736,  1.012747,  1.014140,  1.012786,  1.015363,  1.017998,  1.017009,  1.015084,  1.017812,  1.022893,  1.017865,  1.021300,  1.021200,  1.024077,  1.022618,  1.025623,  1.026864,  1.026901,  1.023099,  1.027160,  1.032798,  1.029079,  1.027867,  1.029845,  1.035994,  1.030703,  1.033232,  1.034719,  1.037003,  1.033203,  1.039386,  1.041472,  1.038490,  1.034114,  1.039486,  1.047745,  1.040038,  1.041037,  1.040808,  1.051173,  1.044222,  1.043929,  1.049127,  1.048114,  1.044317,  1.054287,  1.054911,  1.051799,  1.046880,  1.049926,  1.064222,  1.047499,  1.054986,  1.051766,  1.064948,  1.058974,  1.054834,  1.062533,  1.063454,  1.052615,  1.067642,  1.067243,  1.065629,  1.057181,  1.064410,  1.080917,  1.053038,  1.070834,  1.065070,  1.075191,  1.070206,  1.072907,  1.072474,  1.076246,  1.066514,  1.077372,  1.083146,  1.077749,  1.067164,  1.076357,  1.092506,  1.068852,  1.081892,  1.079986,  1.088410,  1.078762, },
{ 1.000000,  1.000733,  1.001562,  1.002176,  1.002375,  1.003509,  1.005048,  1.004935,  1.005376,  1.005927,  1.008348,  1.007194,  1.008615,  1.009118,  1.010499,  1.010210,  1.012151,  1.013309,  1.012626,  1.011483,  1.013816,  1.017784,  1.015000,  1.015482,  1.016442,  1.020551,  1.017896,  1.017977,  1.020971,  1.021138,  1.018973,  1.024448,  1.025782,  1.023259,  1.021365,  1.023340,  1.031313,  1.022932,  1.026493,  1.025158,  1.033233,  1.029761,  1.027611,  1.032802,  1.032271,  1.027132,  1.037031,  1.035765,  1.035539,  1.029398,  1.035350,  1.045230,  1.029209,  1.039429,  1.035602,  1.042900,  1.040288,  1.041271,  1.041690,  1.044781,  1.036122,  1.046798,  1.048503,  1.045903,  1.039460,  1.045945,  1.055175,  1.039510,  1.050286,  1.048048,  1.053393,  1.049583,  1.054454,  1.055166,  1.053213,  1.045557,  1.053591,  1.063515,  1.054877,  1.052165,  1.054246,  1.066391,  1.053834,  1.058758,  1.060284,  1.063796,  1.058017,  1.065151,  1.069753,  1.061960,  1.054744,  1.063934,  1.078644,  1.063124,  1.062862,  1.064244,  1.079587,  1.065583,  1.068662,  1.070968, },
{ 1.000000,  1.000630,  1.001044,  1.001991,  1.002712,  1.002885,  1.003041,  1.003953,  1.005858,  1.004550,  1.005847,  1.005975,  1.008260,  1.007850,  1.007780,  1.009653,  1.009572,  1.008771,  1.011841,  1.012523,  1.012320,  1.010305,  1.013021,  1.017696,  1.010428,  1.015579,  1.014061,  1.018003,  1.017358,  1.016975,  1.017951,  1.019727,  1.015751,  1.021516,  1.022551,  1.021743,  1.017676,  1.021676,  1.027228,  1.018206,  1.024505,  1.023975,  1.026773,  1.025968,  1.027389,  1.028912,  1.027406,  1.023709,  1.028381,  1.033798,  1.030463,  1.025979,  1.029665,  1.037090,  1.029262,  1.032673,  1.033189,  1.035933,  1.032060,  1.038199,  1.040339,  1.034342,  1.031417,  1.037065,  1.046457,  1.036920,  1.035551,  1.038593,  1.047232,  1.038568,  1.040589,  1.042971,  1.043725,  1.039795,  1.047990,  1.051933,  1.043704,  1.039582,  1.045038,  1.056408,  1.041360,  1.046902,  1.044635,  1.057664,  1.050301,  1.047469,  1.054202,  1.052770,  1.044932,  1.060151,  1.058216,  1.057179,  1.046420,  1.052545,  1.072448,  1.042287,  1.059343,  1.051728,  1.065858,  1.061512, },
{ 1.000000,  1.000435,  1.000975,  1.001485,  1.001453,  1.002607,  1.003124,  1.003345,  1.002763,  1.004252,  1.005917,  1.003321,  1.005604,  1.006079,  1.006608,  1.007157,  1.007753,  1.008541,  1.008077,  1.007129,  1.008804,  1.011959,  1.010111,  1.008521,  1.010807,  1.014109,  1.010129,  1.012671,  1.012254,  1.014054,  1.012683,  1.015495,  1.017647,  1.013670,  1.013132,  1.015654,  1.021400,  1.015983,  1.014645,  1.017692,  1.021167,  1.017890,  1.018076,  1.021036,  1.020044,  1.019676,  1.021926,  1.026957,  1.020103,  1.018542,  1.022401,  1.028568,  1.019902,  1.023251,  1.023103,  1.030912,  1.024287,  1.024173,  1.029694,  1.025725,  1.023133,  1.032790,  1.032727,  1.029906,  1.024303,  1.027010,  1.041181,  1.021702,  1.031491,  1.028641,  1.036681,  1.034730,  1.030877,  1.034605,  1.035062,  1.028135,  1.039503,  1.041085,  1.037812,  1.026658,  1.036492,  1.050475,  1.022353,  1.038802,  1.040001,  1.039886,  1.042036,  1.040864,  1.044095,  1.040194,  1.034612,  1.041598,  1.050313,  1.043476,  1.033963,  1.042395,  1.054507,  1.038107,  1.044938,  1.044034, },
{ 1.000000,  1.000322,  1.000622,  1.001074,  1.001654,  1.001382,  1.001309,  1.002171,  1.003687,  1.002518,  1.002419,  1.003661,  1.004233,  1.004066,  1.004023,  1.005191,  1.005003,  1.005036,  1.006079,  1.008524,  1.005290,  1.004844,  1.006790,  1.009630,  1.005769,  1.008135,  1.007246,  1.011002,  1.008653,  1.007749,  1.010925,  1.009393,  1.007493,  1.013818,  1.012690,  1.011506,  1.008949,  1.010199,  1.017296,  1.007510,  1.012995,  1.011577,  1.016216,  1.015098,  1.011934,  1.015558,  1.014476,  1.011784,  1.017615,  1.019519,  1.017296,  1.010117,  1.017809,  1.023164,  1.007823,  1.018041,  1.018261,  1.018902,  1.021578,  1.017831,  1.021673,  1.018744,  1.015393,  1.020079,  1.027107,  1.019838,  1.014071,  1.021464,  1.028274,  1.017171,  1.022411,  1.022959,  1.022332,  1.024528,  1.024543,  1.030623,  1.021891,  1.017567,  1.023789,  1.035263,  1.023810,  1.019333,  1.026181,  1.029838,  1.025325,  1.026032,  1.028890,  1.026642,  1.026735,  1.029971,  1.040160,  1.024798,  1.020515,  1.028640,  1.039197,  1.025635,  1.029276,  1.027560,  1.038978,  1.031380, },
{ 1.000000,  1.000122,  1.000393,  1.000446,  1.000323,  1.001315,  1.001439,  1.001041,  1.000755,  1.001221,  1.002925,  1.000581,  1.002122,  1.001360,  1.003031,  1.003299,  1.001604,  1.003332,  1.002847,  1.001570,  1.004361,  1.005218,  1.004044,  1.001371,  1.004254,  1.007165,  1.000063,  1.004434,  1.004462,  1.005406,  1.006335,  1.004561,  1.006185,  1.005371,  1.002846,  1.006301,  1.009927,  1.005793,  1.001645,  1.006161,  1.010634,  1.003244,  1.007554,  1.006909,  1.007106,  1.008158,  1.008345,  1.011199,  1.007222,  1.002935,  1.007362,  1.014639,  1.007505,  1.005039,  1.008035,  1.012056,  1.007432,  1.008657,  1.010782,  1.009430,  1.008063,  1.012370,  1.016684,  1.007666,  1.004414,  1.009522,  1.018138,  1.008244,  1.008935,  1.008872,  1.016194,  1.011802,  1.008092,  1.015955,  1.009785,  1.008462,  1.017777,  1.019535,  1.011461,  1.006775,  1.010909,  1.023164,  1.004215,  1.014312,  1.009296,  1.018628,  1.018781,  1.008132,  1.019436,  1.014118,  1.005475,  1.021984,  1.021825,  1.015269,  1.006194,  1.016643,  1.028929,  0.998744,  1.019991,  1.013825, },
{ 1.000000,  0.999999,  1.000074,  0.999984,  1.000041,  0.999925,  0.999460,  1.000159,  1.000701,  0.999826,  0.998814,  0.999975,  1.001038,  0.998440,  1.000286,  0.999888,  0.999786,  1.000132,  1.000430,  1.001083,  0.999418,  0.997486,  0.999693,  1.002539,  0.999266,  0.998674,  0.998603,  1.001855,  0.998317,  0.999914,  0.999751,  0.999672,  0.999985,  1.000833,  1.002598,  0.997982,  0.996208,  0.998880,  1.004195,  0.998201,  0.998287,  0.998912,  1.002362,  0.999261,  0.997206,  1.001789,  0.999262,  0.996567,  1.002910,  1.004945,  0.997649,  0.995371,  0.998101,  1.006122,  0.994030,  0.999503,  0.996253,  1.002756,  1.002518,  0.995738,  1.003193,  0.998257,  0.992972,  1.005420,  1.003781,  0.999127,  0.992072,  1.000879,  1.008557,  0.988259,  1.002222,  0.996767,  1.000391,  1.002579,  0.999413,  1.000756,  0.999742,  0.991218,  1.003510,  1.005888,  0.998878,  0.991071,  1.000909,  1.005729,  0.989025,  1.002189,  0.998905,  0.998773,  1.002521,  1.001477,  1.004320,  0.996902,  0.989959,  0.998223,  1.009755,  0.997522,  0.993849,  0.996898,  1.005386,  0.994470, },
{ 1.000000,  0.999784,  0.999642,  0.999385,  0.999212,  0.999123,  0.999334,  0.998237,  0.997606,  0.998176,  0.999278,  0.997226,  0.997160,  0.997073,  0.998179,  0.996552,  0.996656,  0.996715,  0.996271,  0.995441,  0.997019,  0.997863,  0.994785,  0.993317,  0.995004,  0.997827,  0.992068,  0.994729,  0.993038,  0.995529,  0.995042,  0.992630,  0.995180,  0.992490,  0.990513,  0.995343,  0.995501,  0.992373,  0.988517,  0.992872,  0.997765,  0.984630,  0.993053,  0.989630,  0.992259,  0.993345,  0.990229,  0.991048,  0.990786,  0.984992,  0.993452,  0.993702,  0.989554,  0.983442,  0.990261,  0.993784,  0.981264,  0.990064,  0.988115,  0.987973,  0.990926,  0.988707,  0.990728,  0.986035,  0.980937,  0.987450,  0.992634,  0.986640,  0.980530,  0.985243,  0.991152,  0.981676,  0.986049,  0.985456,  0.985472,  0.983886,  0.987854,  0.991039,  0.979902,  0.977602,  0.983536,  0.993776,  0.980364,  0.979059,  0.982179,  0.988431,  0.979830,  0.981828,  0.983146,  0.980813,  0.979555,  0.985332,  0.991376,  0.977632,  0.973463,  0.980404,  0.990547,  0.971688,  0.979887,  0.975718, },
{ 1.000000,  0.999640,  0.999240,  0.998650,  0.998540,  0.997847,  0.997036,  0.997786,  0.997211,  0.996367,  0.995026,  0.995421,  0.996964,  0.992279,  0.994810,  0.993126,  0.994013,  0.993832,  0.992190,  0.992681,  0.991883,  0.989278,  0.993002,  0.992230,  0.989784,  0.986777,  0.990400,  0.992503,  0.983362,  0.988651,  0.988214,  0.986731,  0.988212,  0.987500,  0.987546,  0.984806,  0.981852,  0.984896,  0.988672,  0.983172,  0.980204,  0.983443,  0.986923,  0.978536,  0.982939,  0.980411,  0.981692,  0.979774,  0.982290,  0.984582,  0.976468,  0.975139,  0.978631,  0.985734,  0.975285,  0.973910,  0.976994,  0.979871,  0.974181,  0.974904,  0.977030,  0.973793,  0.974335,  0.975276,  0.981487,  0.969811,  0.967020,  0.973008,  0.979405,  0.964630,  0.970673,  0.969283,  0.976091,  0.968597,  0.967545,  0.973539,  0.965605,  0.962214,  0.975987,  0.973839,  0.966332,  0.960028,  0.964855,  0.979203,  0.951576,  0.966623,  0.961663,  0.967441,  0.968276,  0.961336,  0.965257,  0.961558,  0.953730,  0.970074,  0.969429,  0.960665,  0.948113,  0.962956,  0.976125,  0.937854, },
{ 1.000000,  0.999354,  0.998728,  0.997951,  0.997535,  0.996739,  0.996297,  0.995151,  0.993952,  0.994190,  0.994392,  0.992476,  0.990875,  0.991437,  0.992196,  0.988653,  0.989609,  0.988464,  0.988240,  0.987356,  0.987555,  0.988072,  0.984159,  0.982243,  0.984196,  0.987475,  0.980719,  0.980348,  0.981727,  0.982033,  0.979078,  0.979058,  0.979491,  0.977681,  0.976994,  0.977810,  0.980665,  0.973237,  0.970759,  0.974403,  0.978665,  0.967717,  0.973127,  0.969656,  0.974541,  0.969147,  0.967655,  0.971457,  0.966642,  0.962830,  0.973099,  0.969274,  0.965089,  0.960444,  0.962744,  0.972288,  0.952833,  0.963447,  0.959942,  0.964291,  0.962070,  0.957137,  0.961114,  0.956692,  0.952500,  0.961618,  0.962638,  0.955582,  0.945475,  0.957771,  0.963304,  0.936665,  0.953818,  0.952893,  0.951442,  0.954245,  0.948854,  0.952679,  0.946468,  0.940505,  0.948814,  0.956491,  0.941196,  0.936315,  0.945383,  0.952365,  0.934367,  0.943799,  0.941657,  0.939589,  0.941976,  0.941692,  0.947676,  0.934145,  0.928280,  0.936969,  0.950649,  0.930392,  0.927744,  0.934291, },
{ 1.000000,  0.999103,  0.997986,  0.997251,  0.996326,  0.995234,  0.994327,  0.993635,  0.993449,  0.991103,  0.989491,  0.989790,  0.990325,  0.986398,  0.987035,  0.985397,  0.986428,  0.983436,  0.982503,  0.983108,  0.980686,  0.978368,  0.982073,  0.980109,  0.976896,  0.974383,  0.975356,  0.979020,  0.969119,  0.973769,  0.970124,  0.972665,  0.971137,  0.967548,  0.969533,  0.966379,  0.962912,  0.968290,  0.967900,  0.963408,  0.957513,  0.963050,  0.966995,  0.950118,  0.959104,  0.958423,  0.958070,  0.957817,  0.954749,  0.955660,  0.952499,  0.947257,  0.953530,  0.957284,  0.946766,  0.941858,  0.947569,  0.952866,  0.938862,  0.946587,  0.943396,  0.942498,  0.942613,  0.943163,  0.944851,  0.937425,  0.930427,  0.937074,  0.946047,  0.931600,  0.930232,  0.932136,  0.937757,  0.926400,  0.931196,  0.931405,  0.928092,  0.925770,  0.931429,  0.933252,  0.921114,  0.914681,  0.923165,  0.934606,  0.912929,  0.919628,  0.915868,  0.925896,  0.914349,  0.913520,  0.921216,  0.911164,  0.908347,  0.920965,  0.919912,  0.908773,  0.900680,  0.908238,  0.923010,  0.890642, },
{ 1.000000,  0.998792,  0.997447,  0.996569,  0.995267,  0.993697,  0.993138,  0.991385,  0.989375,  0.990090,  0.988717,  0.986399,  0.984022,  0.984819,  0.985417,  0.978139,  0.981451,  0.979346,  0.978553,  0.977513,  0.976000,  0.975357,  0.972902,  0.970027,  0.972251,  0.972799,  0.967170,  0.964111,  0.966536,  0.968398,  0.959077,  0.963674,  0.961547,  0.959905,  0.958983,  0.959562,  0.958874,  0.953818,  0.949467,  0.953219,  0.957342,  0.947936,  0.947378,  0.946208,  0.951036,  0.941311,  0.945383,  0.943508,  0.941698,  0.940619,  0.942417,  0.942201,  0.934188,  0.929669,  0.934238,  0.942423,  0.926762,  0.929975,  0.928803,  0.933954,  0.924128,  0.923870,  0.928946,  0.922621,  0.918170,  0.926809,  0.927057,  0.915890,  0.911127,  0.915558,  0.926751,  0.902420,  0.913988,  0.907917,  0.915615,  0.910777,  0.904576,  0.912599,  0.902711,  0.895093,  0.913009,  0.907824,  0.898961,  0.888535,  0.901928,  0.911542,  0.877176,  0.898469,  0.891577,  0.894677,  0.893589,  0.890566,  0.891765,  0.886427,  0.875292,  0.892811,  0.893813,  0.878245,  0.870099,  0.882530, },
{ 1.000000,  0.998702,  0.996739,  0.995811,  0.994318,  0.992728,  0.991477,  0.990267,  0.988969,  0.986612,  0.984532,  0.984253,  0.984328,  0.980570,  0.979014,  0.978197,  0.978334,  0.973890,  0.974268,  0.973117,  0.971186,  0.969534,  0.969356,  0.968753,  0.964023,  0.961020,  0.962984,  0.965421,  0.956735,  0.957489,  0.956287,  0.958231,  0.951484,  0.952675,  0.951936,  0.948938,  0.946553,  0.949265,  0.948751,  0.942143,  0.938193,  0.941301,  0.945741,  0.930952,  0.937589,  0.933252,  0.936980,  0.932092,  0.930227,  0.932334,  0.925903,  0.921907,  0.930003,  0.927498,  0.921319,  0.914008,  0.921258,  0.928178,  0.902854,  0.917607,  0.911960,  0.914274,  0.912619,  0.909278,  0.909425,  0.905593,  0.897562,  0.910200,  0.908114,  0.898334,  0.890503,  0.899216,  0.905092,  0.881842,  0.896006,  0.892893,  0.890766,  0.891304,  0.890244,  0.891064,  0.881692,  0.874704,  0.884341,  0.889301,  0.875977,  0.869919,  0.875927,  0.882300,  0.865293,  0.873034,  0.871452,  0.870006,  0.864769,  0.871750,  0.872204,  0.856996,  0.852089,  0.861237,  0.874242,  0.848487, },
{ 1.000000,  0.998289,  0.996655,  0.995249,  0.992971,  0.991686,  0.990162,  0.988103,  0.986391,  0.985450,  0.984331,  0.981073,  0.978681,  0.978583,  0.978557,  0.972555,  0.973458,  0.971046,  0.971359,  0.967861,  0.966525,  0.966035,  0.962732,  0.959388,  0.962893,  0.959834,  0.956497,  0.952123,  0.953586,  0.956896,  0.943017,  0.949761,  0.945583,  0.946443,  0.943935,  0.941371,  0.941340,  0.937713,  0.932652,  0.939532,  0.936228,  0.930063,  0.924460,  0.930160,  0.933210,  0.914937,  0.924609,  0.923132,  0.919403,  0.919010,  0.918812,  0.917740,  0.911270,  0.906296,  0.911061,  0.914883,  0.903956,  0.899895,  0.904358,  0.908206,  0.892544,  0.900739,  0.895050,  0.896238,  0.890798,  0.895531,  0.895964,  0.883578,  0.880345,  0.885920,  0.894286,  0.875606,  0.875613,  0.879025,  0.882016,  0.868967,  0.873356,  0.874337,  0.868306,  0.867125,  0.869137,  0.874254,  0.858058,  0.852589,  0.862351,  0.869311,  0.843305,  0.855564,  0.851470,  0.861872,  0.843128,  0.848221,  0.852251,  0.840063,  0.834371,  0.853763,  0.847052,  0.836363,  0.826452,  0.834837, },
{ 1.000000,  0.998254,  0.995800,  0.994402,  0.992321,  0.990656,  0.988750,  0.986620,  0.984977,  0.982689,  0.980004,  0.980353,  0.978128,  0.975098,  0.971193,  0.972047,  0.972615,  0.963084,  0.966254,  0.964650,  0.961777,  0.960563,  0.958701,  0.957521,  0.953429,  0.949918,  0.951620,  0.951407,  0.945583,  0.941636,  0.943561,  0.944531,  0.935084,  0.938203,  0.934918,  0.933949,  0.930723,  0.931734,  0.931400,  0.922933,  0.919249,  0.923176,  0.927268,  0.913579,  0.913473,  0.915978,  0.914706,  0.907150,  0.908880,  0.908251,  0.904137,  0.901548,  0.903445,  0.905775,  0.893560,  0.888411,  0.895345,  0.899943,  0.879639,  0.889844,  0.884190,  0.890825,  0.877661,  0.879089,  0.882312,  0.873589,  0.867005,  0.882292,  0.874736,  0.867139,  0.860205,  0.864504,  0.875514,  0.844749,  0.861738,  0.856940,  0.860350,  0.853101,  0.850281,  0.852874,  0.844907,  0.838469,  0.852693,  0.849917,  0.838950,  0.824822,  0.842836,  0.847256,  0.808854,  0.833753,  0.831836,  0.828326,  0.827784,  0.822834,  0.826622,  0.815981,  0.807826,  0.820056,  0.826299,  0.803900, },
{ 1.000000,  0.997804,  0.995803,  0.993958,  0.991021,  0.989661,  0.987300,  0.985100,  0.983072,  0.981443,  0.979805,  0.976036,  0.973411,  0.972924,  0.972567,  0.967067,  0.964981,  0.964634,  0.962906,  0.958137,  0.958402,  0.956205,  0.952973,  0.950983,  0.950441,  0.950274,  0.943284,  0.939473,  0.941972,  0.942877,  0.931982,  0.935228,  0.932005,  0.933548,  0.925567,  0.925497,  0.926256,  0.920405,  0.915623,  0.922996,  0.918690,  0.911690,  0.907148,  0.910086,  0.914589,  0.895414,  0.905023,  0.899124,  0.901163,  0.896917,  0.892928,  0.894952,  0.888106,  0.882492,  0.892049,  0.889033,  0.880635,  0.871173,  0.881684,  0.884775,  0.857585,  0.872295,  0.871183,  0.868616,  0.866294,  0.862973,  0.863535,  0.856837,  0.849189,  0.859303,  0.861637,  0.844519,  0.838679,  0.847947,  0.851687,  0.830821,  0.842691,  0.837977,  0.834665,  0.832710,  0.835031,  0.835757,  0.823563,  0.814352,  0.824538,  0.832894,  0.811588,  0.810827,  0.815026,  0.818435,  0.800598,  0.810147,  0.808991,  0.802201,  0.797550,  0.806805,  0.806016,  0.789359,  0.780134,  0.793653, },
{ 1.000000,  0.997816,  0.995018,  0.993105,  0.990702,  0.988899,  0.985576,  0.983636,  0.982128,  0.978702,  0.976048,  0.975641,  0.973266,  0.969439,  0.966028,  0.965610,  0.965461,  0.956808,  0.959150,  0.955561,  0.954756,  0.951369,  0.948133,  0.948694,  0.943433,  0.938741,  0.943084,  0.939740,  0.934095,  0.928772,  0.932659,  0.933412,  0.916958,  0.925409,  0.921650,  0.919498,  0.917033,  0.914808,  0.913846,  0.908247,  0.903369,  0.908085,  0.907952,  0.897052,  0.892547,  0.897591,  0.898704,  0.882718,  0.891032,  0.887607,  0.883699,  0.881153,  0.883098,  0.881134,  0.872056,  0.865605,  0.872011,  0.876085,  0.860888,  0.860741,  0.859888,  0.864097,  0.848973,  0.856457,  0.852900,  0.848704,  0.845902,  0.849963,  0.847754,  0.835486,  0.828867,  0.836483,  0.845381,  0.821193,  0.827584,  0.826662,  0.830831,  0.815096,  0.817431,  0.823079,  0.812524,  0.805706,  0.817720,  0.817000,  0.800452,  0.794075,  0.801594,  0.813129,  0.777940,  0.796540,  0.788901,  0.794945,  0.786616,  0.781587,  0.790451,  0.774896,  0.765036,  0.789313,  0.780143,  0.766898, },
{ 1.000000,  0.997376,  0.995075,  0.992951,  0.988963,  0.987620,  0.984860,  0.982549,  0.980049,  0.977452,  0.975340,  0.972080,  0.968291,  0.968668,  0.966354,  0.961090,  0.957696,  0.958123,  0.956863,  0.948382,  0.950680,  0.947794,  0.944372,  0.942274,  0.941010,  0.938969,  0.933031,  0.929055,  0.930463,  0.930901,  0.922274,  0.920289,  0.919660,  0.919594,  0.910596,  0.912666,  0.910673,  0.906902,  0.903556,  0.904226,  0.902854,  0.894120,  0.888832,  0.893484,  0.896553,  0.880597,  0.883453,  0.882034,  0.883337,  0.871898,  0.875075,  0.873858,  0.867815,  0.863727,  0.868466,  0.867099,  0.856064,  0.850197,  0.855937,  0.860567,  0.836795,  0.848983,  0.842265,  0.845941,  0.837358,  0.836570,  0.838535,  0.827893,  0.821833,  0.834144,  0.829295,  0.819362,  0.809083,  0.820592,  0.827516,  0.791302,  0.813065,  0.805252,  0.805904,  0.802797,  0.799485,  0.799309,  0.791598,  0.781693,  0.798518,  0.794287,  0.779067,  0.769688,  0.782056,  0.787160,  0.755200,  0.775294,  0.771042,  0.766027,  0.764735,  0.765282,  0.765223,  0.751225,  0.742427,  0.755677, },
{ 1.000000,  0.997365,  0.994399,  0.991488,  0.989139,  0.986681,  0.983027,  0.981125,  0.978441,  0.975546,  0.972270,  0.970864,  0.968299,  0.963503,  0.960257,  0.959490,  0.958916,  0.951629,  0.950308,  0.948669,  0.947143,  0.940431,  0.940413,  0.938309,  0.933610,  0.930787,  0.930655,  0.929380,  0.921946,  0.917685,  0.919631,  0.919876,  0.906526,  0.910880,  0.906641,  0.907083,  0.899975,  0.899283,  0.898532,  0.892073,  0.886439,  0.893770,  0.888351,  0.881822,  0.875018,  0.878633,  0.882924,  0.859435,  0.871768,  0.865387,  0.865480,  0.861189,  0.858270,  0.858273,  0.851076,  0.844217,  0.854480,  0.849209,  0.838453,  0.831008,  0.840115,  0.842475,  0.815752,  0.830700,  0.828545,  0.821829,  0.819888,  0.820932,  0.819177,  0.808168,  0.801674,  0.808763,  0.812217,  0.796091,  0.791536,  0.798413,  0.800765,  0.778892,  0.791324,  0.782989,  0.783279,  0.774533,  0.782368,  0.781662,  0.764141,  0.759935,  0.768085,  0.776558,  0.750425,  0.752315,  0.757359,  0.757962,  0.739517,  0.747335,  0.748116,  0.738316,  0.735720,  0.739553,  0.744822,  0.722690, },
{ 1.000000,  0.996871,  0.994241,  0.991533,  0.987470,  0.985375,  0.982216,  0.980214,  0.975525,  0.973501,  0.971250,  0.966759,  0.963316,  0.963546,  0.959798,  0.955203,  0.950941,  0.950302,  0.950280,  0.939005,  0.941863,  0.938033,  0.935768,  0.932342,  0.929102,  0.927262,  0.922217,  0.917585,  0.920967,  0.917034,  0.910653,  0.903408,  0.907473,  0.909062,  0.889514,  0.897960,  0.895877,  0.890239,  0.888230,  0.886233,  0.884730,  0.876913,  0.871645,  0.875662,  0.874641,  0.864500,  0.859167,  0.863345,  0.863335,  0.848279,  0.854546,  0.849219,  0.847116,  0.841622,  0.844501,  0.843539,  0.829605,  0.825194,  0.831337,  0.836100,  0.815036,  0.816401,  0.820545,  0.816578,  0.805115,  0.809314,  0.807796,  0.800912,  0.796639,  0.800155,  0.802809,  0.784728,  0.778041,  0.788421,  0.792906,  0.763101,  0.779258,  0.771883,  0.778731,  0.759465,  0.763453,  0.767093,  0.753530,  0.744695,  0.765212,  0.755216,  0.742917,  0.734691,  0.741437,  0.753047,  0.711440,  0.735740,  0.729576,  0.731086,  0.720466,  0.718932,  0.721645,  0.708854,  0.701571,  0.719430, },
{ 1.000000,  0.996978,  0.993680,  0.990117,  0.987894,  0.985088,  0.979432,  0.978446,  0.975543,  0.972110,  0.969042,  0.965791,  0.963512,  0.958856,  0.954975,  0.954234,  0.952249,  0.945243,  0.941804,  0.941857,  0.939527,  0.931361,  0.932385,  0.928526,  0.924804,  0.921673,  0.920425,  0.918770,  0.910536,  0.906601,  0.907662,  0.908168,  0.896986,  0.894627,  0.895605,  0.892458,  0.883661,  0.886216,  0.882693,  0.877153,  0.874199,  0.874520,  0.874702,  0.862490,  0.856989,  0.862270,  0.863406,  0.844738,  0.852005,  0.847291,  0.848999,  0.835965,  0.837413,  0.838612,  0.829071,  0.822102,  0.833504,  0.827275,  0.816073,  0.810100,  0.815383,  0.820297,  0.791677,  0.807503,  0.799162,  0.800410,  0.793843,  0.789684,  0.792240,  0.781253,  0.774247,  0.787368,  0.783028,  0.770046,  0.757773,  0.773317,  0.774969,  0.737855,  0.758977,  0.757552,  0.752268,  0.748586,  0.745080,  0.745732,  0.734993,  0.725928,  0.739360,  0.740848,  0.716907,  0.711316,  0.723809,  0.725143,  0.698764,  0.714766,  0.708584,  0.702579,  0.699034,  0.703228,  0.703737,  0.686126, },
{ 1.000000,  0.996480,  0.993440,  0.990405,  0.986312,  0.983037,  0.980276,  0.977124,  0.972404,  0.970408,  0.967292,  0.963150,  0.959510,  0.957990,  0.954879,  0.949015,  0.944723,  0.944282,  0.943164,  0.933530,  0.933939,  0.930238,  0.929111,  0.921184,  0.920235,  0.919157,  0.912122,  0.907913,  0.910162,  0.906616,  0.898973,  0.893452,  0.895154,  0.895746,  0.878617,  0.885821,  0.880221,  0.878892,  0.873278,  0.869253,  0.870993,  0.861649,  0.854662,  0.863063,  0.858090,  0.848198,  0.840390,  0.848352,  0.848630,  0.822501,  0.837137,  0.831869,  0.827952,  0.824269,  0.821463,  0.820755,  0.811312,  0.805080,  0.812477,  0.811719,  0.794638,  0.789775,  0.797788,  0.797706,  0.774752,  0.787680,  0.782998,  0.776580,  0.772548,  0.776206,  0.773304,  0.759587,  0.751723,  0.760932,  0.764841,  0.743421,  0.744534,  0.744021,  0.747466,  0.726369,  0.738285,  0.733178,  0.726403,  0.721818,  0.728663,  0.724698,  0.707578,  0.699598,  0.710209,  0.719780,  0.686751,  0.697388,  0.696494,  0.699389,  0.677850,  0.683060,  0.689871,  0.674609,  0.665884,  0.680836, },
{ 1.000000,  0.996614,  0.992828,  0.989131,  0.986073,  0.983299,  0.977639,  0.975943,  0.971993,  0.969067,  0.964860,  0.961298,  0.959256,  0.953645,  0.949114,  0.949831,  0.945310,  0.939727,  0.934304,  0.935479,  0.933485,  0.920823,  0.924497,  0.919724,  0.916394,  0.912709,  0.909550,  0.907134,  0.901064,  0.895072,  0.898622,  0.895343,  0.885096,  0.880328,  0.883444,  0.881515,  0.866216,  0.872618,  0.868523,  0.863057,  0.860038,  0.859355,  0.856803,  0.846586,  0.841181,  0.844558,  0.845304,  0.831283,  0.829458,  0.829659,  0.828921,  0.814951,  0.819851,  0.816976,  0.810889,  0.805812,  0.808230,  0.805908,  0.792582,  0.785707,  0.793255,  0.796948,  0.773287,  0.779191,  0.777607,  0.777976,  0.761481,  0.767436,  0.765793,  0.756388,  0.750582,  0.757922,  0.756153,  0.739988,  0.732712,  0.741523,  0.746011,  0.712648,  0.731518,  0.722372,  0.725574,  0.713333,  0.714264,  0.716172,  0.700868,  0.693390,  0.709933,  0.703120,  0.688584,  0.676207,  0.692021,  0.698562,  0.651323,  0.681095,  0.670849,  0.669822,  0.665515,  0.662295,  0.661977,  0.650067, },
{ 1.000000,  0.996096,  0.992858,  0.989126,  0.984710,  0.980548,  0.977961,  0.974677,  0.968175,  0.966921,  0.963043,  0.958766,  0.955198,  0.952173,  0.948782,  0.942888,  0.938382,  0.937517,  0.934704,  0.927537,  0.923373,  0.922343,  0.919368,  0.911100,  0.911079,  0.907355,  0.903007,  0.897489,  0.897857,  0.894402,  0.885162,  0.880611,  0.881813,  0.882272,  0.867912,  0.868041,  0.866948,  0.864610,  0.852963,  0.855387,  0.852785,  0.844796,  0.841066,  0.842367,  0.841015,  0.828309,  0.822666,  0.827423,  0.827477,  0.805874,  0.815163,  0.809051,  0.809366,  0.798383,  0.799138,  0.798064,  0.788070,  0.779942,  0.791747,  0.784110,  0.773614,  0.764795,  0.771320,  0.776192,  0.742166,  0.761447,  0.752873,  0.751745,  0.745448,  0.742728,  0.742885,  0.731411,  0.723216,  0.737244,  0.730229,  0.713879,  0.705423,  0.718516,  0.719493,  0.683725,  0.704790,  0.702182,  0.691868,  0.688684,  0.691419,  0.688979,  0.673087,  0.665434,  0.675127,  0.678397,  0.656068,  0.651680,  0.661294,  0.661607,  0.633591,  0.650691,  0.639919,  0.639006,  0.626945,  0.638646, },
{ 1.000000,  0.996208,  0.992018,  0.988014,  0.984606,  0.981168,  0.975641,  0.972217,  0.969082,  0.965328,  0.959607,  0.957219,  0.953794,  0.948579,  0.944580,  0.942013,  0.939462,  0.931925,  0.927325,  0.927057,  0.924545,  0.912924,  0.914578,  0.910080,  0.908772,  0.899009,  0.898916,  0.896500,  0.888262,  0.883076,  0.887233,  0.881394,  0.873006,  0.866919,  0.868327,  0.869572,  0.848950,  0.857173,  0.851680,  0.848315,  0.843336,  0.839699,  0.837539,  0.829398,  0.823422,  0.829938,  0.824528,  0.813904,  0.803767,  0.812020,  0.813791,  0.784042,  0.798699,  0.796321,  0.787652,  0.784434,  0.782989,  0.781366,  0.769225,  0.762657,  0.769344,  0.767499,  0.752702,  0.746201,  0.753383,  0.751734,  0.730955,  0.741062,  0.733839,  0.730353,  0.722669,  0.727838,  0.726318,  0.706459,  0.701632,  0.710667,  0.715681,  0.686792,  0.690577,  0.696726,  0.689300,  0.673648,  0.681257,  0.678861,  0.668897,  0.663061,  0.669002,  0.671805,  0.647198,  0.639272,  0.653914,  0.657982,  0.618037,  0.641208,  0.632248,  0.638792,  0.613696,  0.620497,  0.624471,  0.606020, },
{ 1.000000,  0.995876,  0.992160,  0.988071,  0.983631,  0.979174,  0.975867,  0.972894,  0.965227,  0.964047,  0.959815,  0.955880,  0.950922,  0.947408,  0.944017,  0.938212,  0.933669,  0.933149,  0.929089,  0.922092,  0.915384,  0.917400,  0.913935,  0.899259,  0.903978,  0.900318,  0.894655,  0.890718,  0.886811,  0.884739,  0.876512,  0.871198,  0.872698,  0.870635,  0.858070,  0.854002,  0.856833,  0.853216,  0.839758,  0.843912,  0.838743,  0.832647,  0.828508,  0.828309,  0.826613,  0.813297,  0.808557,  0.811838,  0.812835,  0.795327,  0.793571,  0.796603,  0.790979,  0.778078,  0.784143,  0.778920,  0.770785,  0.766717,  0.768507,  0.768963,  0.750975,  0.744170,  0.753103,  0.753955,  0.726725,  0.739218,  0.733513,  0.734490,  0.716358,  0.720321,  0.721700,  0.708094,  0.699263,  0.714884,  0.706823,  0.690726,  0.683681,  0.692231,  0.697047,  0.658188,  0.681453,  0.671080,  0.670552,  0.661999,  0.658359,  0.661267,  0.645607,  0.637770,  0.654582,  0.648969,  0.630726,  0.616004,  0.637551,  0.637099,  0.589455,  0.617908,  0.616828,  0.608039,  0.603171,  0.600151, },
{ 1.000000,  0.995795,  0.991350,  0.986638,  0.983134,  0.979155,  0.973395,  0.968986,  0.966181,  0.961914,  0.955119,  0.953239,  0.948679,  0.943763,  0.939340,  0.936351,  0.932742,  0.925561,  0.920189,  0.919193,  0.916701,  0.906896,  0.903949,  0.902107,  0.897935,  0.888621,  0.889304,  0.885112,  0.878508,  0.873171,  0.874044,  0.869675,  0.859216,  0.853131,  0.855666,  0.855024,  0.837695,  0.841453,  0.836870,  0.835635,  0.822732,  0.823690,  0.823213,  0.811617,  0.806119,  0.811492,  0.806876,  0.794711,  0.787492,  0.791889,  0.792745,  0.765882,  0.779755,  0.772122,  0.769391,  0.761762,  0.757427,  0.760637,  0.746253,  0.737455,  0.750269,  0.743705,  0.728637,  0.718867,  0.731785,  0.730959,  0.693920,  0.716240,  0.709629,  0.703298,  0.698306,  0.695646,  0.694883,  0.681084,  0.673696,  0.684686,  0.682863,  0.658654,  0.654022,  0.666040,  0.663577,  0.633605,  0.651486,  0.646242,  0.636262,  0.631034,  0.637125,  0.633164,  0.613687,  0.604952,  0.617648,  0.621173,  0.592589,  0.595871,  0.596408,  0.597894,  0.570900,  0.588328,  0.581194,  0.571177, },
{ 1.000000,  0.995394,  0.991288,  0.986776,  0.981754,  0.976903,  0.973287,  0.969880,  0.962565,  0.959767,  0.955577,  0.951492,  0.944686,  0.941637,  0.938689,  0.932089,  0.926607,  0.925599,  0.921616,  0.912988,  0.908007,  0.906755,  0.905189,  0.890439,  0.893762,  0.887962,  0.884557,  0.878122,  0.873998,  0.873049,  0.863022,  0.856450,  0.861870,  0.854934,  0.845008,  0.837231,  0.842791,  0.840315,  0.818048,  0.827851,  0.821336,  0.816292,  0.811665,  0.808244,  0.805509,  0.795782,  0.787707,  0.795263,  0.790791,  0.774368,  0.769028,  0.775704,  0.772434,  0.749555,  0.760902,  0.756137,  0.747367,  0.743444,  0.744227,  0.740843,  0.725754,  0.719225,  0.725222,  0.725942,  0.705753,  0.704938,  0.706449,  0.703774,  0.684668,  0.693346,  0.689386,  0.680577,  0.673759,  0.678790,  0.675215,  0.656643,  0.648275,  0.659603,  0.663425,  0.630791,  0.640984,  0.639707,  0.638079,  0.616444,  0.626150,  0.623891,  0.610536,  0.603036,  0.614027,  0.611101,  0.589092,  0.580692,  0.593460,  0.597377,  0.553203,  0.580181,  0.568784,  0.570680,  0.554995,  0.558286, },
{ 1.000000,  0.995431,  0.990524,  0.985464,  0.981733,  0.976984,  0.971493,  0.965946,  0.963121,  0.959372,  0.949745,  0.949089,  0.943636,  0.938990,  0.934269,  0.929716,  0.925588,  0.919105,  0.913278,  0.913233,  0.908116,  0.899178,  0.893501,  0.893476,  0.889924,  0.876103,  0.879339,  0.874352,  0.867870,  0.863232,  0.860894,  0.856746,  0.846985,  0.840785,  0.842659,  0.839287,  0.827036,  0.822474,  0.823559,  0.818709,  0.806004,  0.808882,  0.804087,  0.797558,  0.789849,  0.792973,  0.788216,  0.773831,  0.768494,  0.772088,  0.773432,  0.751258,  0.753951,  0.753689,  0.749816,  0.732930,  0.738552,  0.735415,  0.723883,  0.718945,  0.722439,  0.721066,  0.702700,  0.695662,  0.704187,  0.703586,  0.672711,  0.688140,  0.680429,  0.679742,  0.664930,  0.667955,  0.666375,  0.652250,  0.642066,  0.659016,  0.648719,  0.633709,  0.623487,  0.633296,  0.638186,  0.593168,  0.620664,  0.609648,  0.606688,  0.598846,  0.596731,  0.596779,  0.580626,  0.571719,  0.589708,  0.580801,  0.558192,  0.549153,  0.567113,  0.565752,  0.520648,  0.548638,  0.546181,  0.531515, },
{ 1.000000,  0.995028,  0.990454,  0.985620,  0.980094,  0.974900,  0.971079,  0.966645,  0.959970,  0.955073,  0.951890,  0.947147,  0.939100,  0.937178,  0.931457,  0.926740,  0.920317,  0.918619,  0.913962,  0.904911,  0.899920,  0.898506,  0.895935,  0.883807,  0.881381,  0.879438,  0.874177,  0.863898,  0.863952,  0.859998,  0.851964,  0.846754,  0.845490,  0.843156,  0.830095,  0.824129,  0.827179,  0.824207,  0.804305,  0.810913,  0.805082,  0.803969,  0.788515,  0.791310,  0.788494,  0.775793,  0.768937,  0.778160,  0.769844,  0.756868,  0.749129,  0.753573,  0.755375,  0.724203,  0.739290,  0.732361,  0.727040,  0.720544,  0.717016,  0.714443,  0.702394,  0.695280,  0.705620,  0.698426,  0.683151,  0.670147,  0.683615,  0.684843,  0.643879,  0.665746,  0.663413,  0.650825,  0.646707,  0.646411,  0.644431,  0.627260,  0.619504,  0.629662,  0.626490,  0.606142,  0.599591,  0.610268,  0.605967,  0.579180,  0.593795,  0.584782,  0.579254,  0.569141,  0.577476,  0.575549,  0.548610,  0.543788,  0.556398,  0.561425,  0.523502,  0.530617,  0.539264,  0.527643,  0.507672,  0.519598, },
{ 1.000000,  0.995015,  0.989652,  0.984504,  0.979962,  0.975173,  0.968700,  0.963110,  0.959820,  0.955508,  0.946086,  0.944523,  0.938960,  0.934911,  0.926655,  0.923436,  0.919634,  0.911816,  0.905306,  0.906283,  0.899589,  0.891064,  0.885255,  0.883408,  0.881576,  0.864310,  0.868862,  0.863131,  0.858072,  0.850363,  0.847009,  0.843466,  0.833796,  0.828029,  0.830736,  0.825445,  0.813648,  0.803953,  0.811139,  0.806152,  0.781315,  0.792843,  0.788521,  0.780130,  0.775030,  0.770570,  0.769009,  0.756195,  0.749381,  0.753979,  0.751293,  0.731852,  0.727997,  0.734053,  0.728138,  0.709082,  0.716861,  0.710297,  0.701419,  0.696071,  0.697748,  0.695745,  0.676047,  0.671104,  0.676899,  0.678138,  0.653268,  0.652499,  0.658140,  0.649131,  0.631470,  0.642065,  0.634723,  0.623463,  0.618253,  0.622234,  0.622865,  0.597421,  0.589852,  0.603288,  0.603304,  0.565967,  0.585193,  0.578169,  0.578178,  0.553901,  0.561077,  0.562862,  0.544154,  0.533200,  0.554485,  0.543996,  0.521682,  0.513868,  0.526544,  0.530966,  0.479752,  0.512376,  0.499575,  0.496753, },
{ 1.000000,  0.994640,  0.989534,  0.984450,  0.978547,  0.973174,  0.969267,  0.963946,  0.957218,  0.951051,  0.948694,  0.943647,  0.932675,  0.932017,  0.927295,  0.921180,  0.915677,  0.910778,  0.906322,  0.898710,  0.892332,  0.891737,  0.887366,  0.875284,  0.870388,  0.870551,  0.864976,  0.852595,  0.854207,  0.848339,  0.841027,  0.835384,  0.833834,  0.829926,  0.817898,  0.811071,  0.812572,  0.810492,  0.794480,  0.792425,  0.791891,  0.785690,  0.771732,  0.776159,  0.770634,  0.761215,  0.754136,  0.757813,  0.752235,  0.736715,  0.729146,  0.735037,  0.734725,  0.708605,  0.717164,  0.711868,  0.709944,  0.691585,  0.695315,  0.695129,  0.678919,  0.672230,  0.681124,  0.675264,  0.657929,  0.649308,  0.657332,  0.657884,  0.620653,  0.642152,  0.632441,  0.628118,  0.618356,  0.613992,  0.618616,  0.598760,  0.588203,  0.606126,  0.598037,  0.577105,  0.565463,  0.584142,  0.581536,  0.533314,  0.564181,  0.556200,  0.546888,  0.540650,  0.538751,  0.537914,  0.519109,  0.511084,  0.525762,  0.522780,  0.491005,  0.487297,  0.503492,  0.497991,  0.460872,  0.484490, },
{ 1.000000,  0.994634,  0.988889,  0.983402,  0.978503,  0.973177,  0.966472,  0.960707,  0.956802,  0.951923,  0.943725,  0.939358,  0.934722,  0.929562,  0.920718,  0.919031,  0.913050,  0.906296,  0.900447,  0.898272,  0.892248,  0.882585,  0.876391,  0.875388,  0.872816,  0.857638,  0.857926,  0.853517,  0.848752,  0.836962,  0.835940,  0.833409,  0.823043,  0.815821,  0.817445,  0.813156,  0.799057,  0.792944,  0.794115,  0.793222,  0.768597,  0.778555,  0.770471,  0.766108,  0.757241,  0.753070,  0.753418,  0.738110,  0.729910,  0.740230,  0.730953,  0.716282,  0.706017,  0.716936,  0.713276,  0.680692,  0.697795,  0.689300,  0.682191,  0.676347,  0.673111,  0.670336,  0.656281,  0.646435,  0.658238,  0.652700,  0.629339,  0.623628,  0.634663,  0.629231,  0.598277,  0.615454,  0.609990,  0.597787,  0.593004,  0.595421,  0.591421,  0.570393,  0.563282,  0.572412,  0.572855,  0.545694,  0.546436,  0.549705,  0.544837,  0.519965,  0.533344,  0.527932,  0.516081,  0.507745,  0.515626,  0.510955,  0.486042,  0.476654,  0.492422,  0.496067,  0.453739,  0.469009,  0.468328,  0.464117, },
{ 1.000000,  0.994126,  0.988655,  0.983063,  0.976917,  0.971192,  0.966580,  0.961077,  0.953703,  0.947610,  0.943921,  0.939091,  0.927984,  0.926980,  0.920267,  0.915486,  0.907868,  0.903861,  0.899185,  0.890030,  0.883492,  0.883543,  0.876854,  0.867236,  0.859435,  0.860533,  0.856899,  0.836671,  0.843169,  0.835384,  0.829179,  0.823401,  0.818656,  0.814030,  0.803980,  0.796605,  0.800580,  0.793723,  0.779201,  0.772384,  0.775895,  0.771299,  0.749343,  0.757918,  0.752173,  0.743009,  0.737214,  0.735871,  0.731128,  0.716651,  0.709043,  0.713959,  0.710012,  0.691842,  0.687378,  0.691100,  0.683982,  0.666439,  0.672781,  0.666560,  0.657917,  0.647739,  0.654022,  0.647887,  0.627760,  0.622013,  0.628456,  0.630433,  0.599653,  0.605662,  0.606455,  0.600249,  0.577992,  0.587495,  0.583639,  0.568124,  0.562421,  0.568366,  0.566848,  0.541778,  0.534051,  0.546798,  0.545025,  0.503805,  0.526917,  0.517488,  0.515346,  0.496350,  0.502414,  0.500038,  0.481300,  0.468935,  0.491849,  0.478689,  0.458342,  0.446996,  0.461051,  0.465550,  0.408253,  0.445100, },
{ 1.000000,  0.994215,  0.988415,  0.982298,  0.976654,  0.971159,  0.964503,  0.958187,  0.954373,  0.948301,  0.940352,  0.933909,  0.931129,  0.925577,  0.913748,  0.912942,  0.907659,  0.899910,  0.894043,  0.890197,  0.884708,  0.875106,  0.868692,  0.866812,  0.862474,  0.850512,  0.845533,  0.844240,  0.838222,  0.824625,  0.826571,  0.818299,  0.812705,  0.803677,  0.804719,  0.799041,  0.784661,  0.779214,  0.780031,  0.777938,  0.758575,  0.758222,  0.757523,  0.750346,  0.735158,  0.738199,  0.733770,  0.722635,  0.716142,  0.716426,  0.714507,  0.695445,  0.688394,  0.695165,  0.691563,  0.662500,  0.675201,  0.667798,  0.666613,  0.645419,  0.651339,  0.648106,  0.630786,  0.622560,  0.636736,  0.626050,  0.608026,  0.599179,  0.606736,  0.608960,  0.566659,  0.589488,  0.580829,  0.573282,  0.565520,  0.562173,  0.559142,  0.542920,  0.535250,  0.549351,  0.540418,  0.519868,  0.504480,  0.523517,  0.523920,  0.471155,  0.500721,  0.498767,  0.482121,  0.476867,  0.477750,  0.475673,  0.453155,  0.444494,  0.458180,  0.453783,  0.427503,  0.420852,  0.435518,  0.428164, },
{ 1.000000,  0.993701,  0.987919,  0.981951,  0.975779,  0.969350,  0.964199,  0.958426,  0.950487,  0.944384,  0.940224,  0.935285,  0.924774,  0.920732,  0.916750,  0.909308,  0.900620,  0.897737,  0.891945,  0.884117,  0.877420,  0.874464,  0.870099,  0.857783,  0.850957,  0.851058,  0.846645,  0.828240,  0.832294,  0.825137,  0.821328,  0.807685,  0.806666,  0.802950,  0.791001,  0.782579,  0.788530,  0.779148,  0.766227,  0.759466,  0.759957,  0.758844,  0.730995,  0.742770,  0.735728,  0.728749,  0.718722,  0.715902,  0.712350,  0.698475,  0.691844,  0.698154,  0.691709,  0.674406,  0.662450,  0.675301,  0.668288,  0.633117,  0.651998,  0.647758,  0.636019,  0.629694,  0.625399,  0.624115,  0.606446,  0.598894,  0.606596,  0.603448,  0.576621,  0.573613,  0.583476,  0.574597,  0.549876,  0.561882,  0.554187,  0.542438,  0.535857,  0.539426,  0.537582,  0.510986,  0.506212,  0.515082,  0.516278,  0.483518,  0.484742,  0.493244,  0.480502,  0.458071,  0.473666,  0.464130,  0.449840,  0.443508,  0.450065,  0.450783,  0.417893,  0.409982,  0.428039,  0.427223,  0.379382,  0.405874, },
{ 1.000000,  0.993845,  0.987568,  0.980761,  0.974875,  0.969079,  0.961749,  0.955046,  0.950973,  0.944411,  0.936193,  0.929512,  0.925753,  0.920543,  0.907306,  0.907112,  0.899729,  0.893614,  0.886178,  0.880669,  0.875964,  0.866023,  0.859026,  0.858960,  0.852217,  0.840813,  0.831886,  0.834507,  0.828359,  0.806814,  0.812822,  0.807927,  0.799008,  0.792194,  0.787232,  0.782751,  0.770886,  0.763194,  0.766005,  0.760851,  0.741462,  0.737004,  0.740478,  0.732610,  0.714664,  0.719940,  0.713039,  0.702853,  0.696148,  0.695887,  0.692013,  0.674503,  0.666172,  0.670779,  0.668758,  0.645509,  0.645066,  0.646432,  0.637501,  0.618302,  0.627500,  0.620337,  0.607564,  0.598664,  0.605967,  0.598659,  0.577279,  0.568758,  0.578590,  0.578226,  0.542240,  0.556794,  0.550305,  0.547520,  0.523262,  0.530300,  0.530508,  0.509007,  0.500999,  0.513917,  0.507009,  0.483748,  0.473759,  0.485848,  0.486078,  0.436989,  0.467640,  0.455820,  0.448814,  0.437161,  0.433011,  0.439456,  0.412897,  0.401050,  0.424659,  0.414671,  0.387232,  0.373913,  0.398912,  0.394281, },
{ 1.000000,  0.993118,  0.987200,  0.980698,  0.974005,  0.967455,  0.961236,  0.955150,  0.947347,  0.940599,  0.936345,  0.930180,  0.920014,  0.913916,  0.910739,  0.903930,  0.892071,  0.890766,  0.884324,  0.875934,  0.869170,  0.865850,  0.859490,  0.848036,  0.840865,  0.839754,  0.835111,  0.820266,  0.817304,  0.812997,  0.807007,  0.792502,  0.795064,  0.787060,  0.777981,  0.770630,  0.771048,  0.763491,  0.748474,  0.741061,  0.742945,  0.741429,  0.717177,  0.721661,  0.717347,  0.711141,  0.694000,  0.695508,  0.693724,  0.678972,  0.669831,  0.674888,  0.670157,  0.649583,  0.642648,  0.647042,  0.646498,  0.610715,  0.628513,  0.618371,  0.612302,  0.600991,  0.597326,  0.598835,  0.577647,  0.567759,  0.583890,  0.571969,  0.551651,  0.539562,  0.556319,  0.550851,  0.506750,  0.532582,  0.521938,  0.512143,  0.505570,  0.502552,  0.499498,  0.480612,  0.469465,  0.485846,  0.479056,  0.447605,  0.442516,  0.458234,  0.450070,  0.410674,  0.434260,  0.428107,  0.411887,  0.406480,  0.410850,  0.406016,  0.378850,  0.371249,  0.383607,  0.383682,  0.349029,  0.352053, },
{ 1.000000,  0.993267,  0.986739,  0.979262,  0.973280,  0.966493,  0.959479,  0.952420,  0.946918,  0.940260,  0.931426,  0.924133,  0.920171,  0.914648,  0.902332,  0.899104,  0.893186,  0.886312,  0.875661,  0.872941,  0.866586,  0.857043,  0.849680,  0.847727,  0.841390,  0.828538,  0.821284,  0.820682,  0.815734,  0.794744,  0.800698,  0.791392,  0.785727,  0.774802,  0.772318,  0.767373,  0.753398,  0.745293,  0.749954,  0.741165,  0.726666,  0.716645,  0.722123,  0.718255,  0.686317,  0.701150,  0.691039,  0.682750,  0.676042,  0.671152,  0.666194,  0.652000,  0.642976,  0.651165,  0.642680,  0.621632,  0.614231,  0.621635,  0.615707,  0.584879,  0.599682,  0.593230,  0.580518,  0.573502,  0.573498,  0.568160,  0.548376,  0.539597,  0.547921,  0.543359,  0.518370,  0.514727,  0.521003,  0.510954,  0.488275,  0.498859,  0.490928,  0.479964,  0.467198,  0.477206,  0.469618,  0.442951,  0.436638,  0.446361,  0.449026,  0.408469,  0.418891,  0.420833,  0.411713,  0.383733,  0.397851,  0.393114,  0.372824,  0.366446,  0.375191,  0.373617,  0.340946,  0.332892,  0.350438,  0.347244, },
{ 1.000000,  0.992807,  0.986389,  0.979433,  0.972682,  0.965048,  0.959011,  0.952389,  0.944300,  0.936722,  0.933004,  0.925354,  0.916414,  0.908817,  0.904981,  0.899552,  0.883909,  0.884743,  0.876481,  0.869376,  0.861804,  0.856054,  0.850450,  0.839679,  0.832202,  0.832011,  0.824065,  0.810505,  0.803141,  0.804316,  0.797329,  0.776361,  0.781763,  0.776081,  0.764700,  0.757658,  0.755416,  0.749042,  0.734524,  0.726928,  0.727823,  0.723241,  0.704975,  0.700362,  0.701785,  0.693620,  0.673991,  0.680232,  0.669734,  0.662838,  0.650766,  0.654932,  0.648427,  0.627726,  0.621875,  0.625381,  0.623837,  0.596154,  0.598526,  0.599287,  0.589417,  0.569183,  0.575939,  0.570702,  0.555926,  0.548302,  0.550561,  0.548969,  0.522840,  0.515213,  0.526352,  0.521663,  0.482091,  0.502422,  0.493213,  0.491517,  0.463937,  0.474083,  0.470055,  0.447473,  0.437699,  0.457941,  0.444534,  0.420440,  0.410522,  0.422280,  0.424560,  0.369636,  0.401548,  0.391201,  0.380825,  0.371629,  0.368678,  0.365408,  0.344281,  0.336104,  0.354338,  0.343899,  0.317156,  0.299210, },
{ 1.000000,  0.992941,  0.986231,  0.977468,  0.971682,  0.965028,  0.957094,  0.950141,  0.943629,  0.936874,  0.927957,  0.920479,  0.915853,  0.909089,  0.898668,  0.891554,  0.888124,  0.880333,  0.868188,  0.866255,  0.858112,  0.850606,  0.841900,  0.838893,  0.832904,  0.818343,  0.811774,  0.810609,  0.806202,  0.787242,  0.785601,  0.783449,  0.772833,  0.760040,  0.760262,  0.753222,  0.742411,  0.734096,  0.733459,  0.729354,  0.709871,  0.702126,  0.706234,  0.701716,  0.672943,  0.683925,  0.674861,  0.670723,  0.651272,  0.653142,  0.649360,  0.632361,  0.622087,  0.633679,  0.621472,  0.603418,  0.595605,  0.598907,  0.598378,  0.558717,  0.579126,  0.570196,  0.560760,  0.548442,  0.546542,  0.542675,  0.523797,  0.516646,  0.526899,  0.519369,  0.495715,  0.481250,  0.500543,  0.491171,  0.444463,  0.471902,  0.467249,  0.451927,  0.444293,  0.440438,  0.439524,  0.415850,  0.407918,  0.419067,  0.415311,  0.380237,  0.378307,  0.392227,  0.380031,  0.349240,  0.366007,  0.356839,  0.341615,  0.334119,  0.339917,  0.338220,  0.303939,  0.299307,  0.311420,  0.312946, },
{ 1.000000,  0.992542,  0.985091,  0.978292,  0.970505,  0.962232,  0.956232,  0.948694,  0.940405,  0.933065,  0.927291,  0.920686,  0.909762,  0.902006,  0.898453,  0.891735,  0.877121,  0.875988,  0.868221,  0.861514,  0.849141,  0.845681,  0.839787,  0.828432,  0.819371,  0.820097,  0.811411,  0.797590,  0.790068,  0.789164,  0.784264,  0.759826,  0.767548,  0.757347,  0.749694,  0.740462,  0.734622,  0.730599,  0.715458,  0.707586,  0.711330,  0.703452,  0.686301,  0.674519,  0.683215,  0.675093,  0.642228,  0.655626,  0.650940,  0.638488,  0.630529,  0.625596,  0.620689,  0.604446,  0.595218,  0.602077,  0.595820,  0.568254,  0.564517,  0.571823,  0.561227,  0.536896,  0.546949,  0.538563,  0.525344,  0.517137,  0.518884,  0.515057,  0.490688,  0.481663,  0.489299,  0.487625,  0.455887,  0.458137,  0.461150,  0.449114,  0.424303,  0.438722,  0.429877,  0.413138,  0.402659,  0.413623,  0.404994,  0.376470,  0.367052,  0.381638,  0.380936,  0.334067,  0.355478,  0.348191,  0.343701,  0.313303,  0.324309,  0.324433,  0.297326,  0.287831,  0.305436,  0.297158,  0.267385,  0.255973, },
{ 1.000000,  0.992518,  0.985169,  0.976118,  0.970339,  0.962509,  0.954808,  0.946809,  0.939482,  0.933172,  0.923272,  0.915015,  0.911513,  0.903620,  0.892657,  0.884032,  0.881802,  0.874445,  0.856536,  0.858416,  0.850305,  0.841178,  0.833369,  0.827066,  0.820824,  0.808577,  0.800633,  0.799786,  0.792819,  0.775325,  0.769478,  0.769847,  0.760888,  0.741705,  0.745693,  0.738254,  0.726551,  0.718517,  0.717096,  0.709733,  0.692569,  0.684359,  0.686632,  0.681934,  0.659575,  0.658742,  0.654982,  0.647443,  0.626823,  0.634805,  0.624461,  0.612574,  0.603660,  0.607140,  0.597819,  0.576654,  0.568328,  0.573779,  0.573062,  0.538669,  0.548418,  0.543996,  0.535932,  0.513078,  0.517943,  0.516620,  0.497111,  0.486064,  0.494645,  0.489643,  0.461758,  0.454270,  0.462403,  0.462125,  0.413922,  0.440937,  0.428310,  0.420137,  0.406364,  0.403414,  0.406199,  0.378583,  0.367129,  0.389343,  0.374750,  0.348023,  0.334110,  0.357597,  0.350558,  0.293764,  0.329288,  0.316347,  0.303527,  0.296104,  0.293575,  0.290328,  0.266124,  0.253696,  0.274960,  0.266981, },
{ 1.000000,  0.991908,  0.984135,  0.976958,  0.969019,  0.959453,  0.953505,  0.945714,  0.937122,  0.929298,  0.922687,  0.915305,  0.904570,  0.896554,  0.891720,  0.884864,  0.872028,  0.866063,  0.860612,  0.852135,  0.839275,  0.837237,  0.829065,  0.819121,  0.810629,  0.807250,  0.799531,  0.785011,  0.776254,  0.775865,  0.770994,  0.749188,  0.750183,  0.744433,  0.735765,  0.719553,  0.720526,  0.713315,  0.699935,  0.690923,  0.692123,  0.684945,  0.666087,  0.657532,  0.660545,  0.655442,  0.623473,  0.637279,  0.625359,  0.618649,  0.604294,  0.603380,  0.598256,  0.578957,  0.569415,  0.579002,  0.568053,  0.547947,  0.536111,  0.546338,  0.542013,  0.497464,  0.521965,  0.508823,  0.498286,  0.490749,  0.485875,  0.480392,  0.461543,  0.451365,  0.464321,  0.453711,  0.425304,  0.418062,  0.429837,  0.421695,  0.381479,  0.403384,  0.395797,  0.379615,  0.371334,  0.372938,  0.366801,  0.341098,  0.331454,  0.343534,  0.338104,  0.305388,  0.303323,  0.312869,  0.298818,  0.270745,  0.286492,  0.276616,  0.262638,  0.247450,  0.261632,  0.252624,  0.218396,  0.212018, },
{ 1.000000,  0.992094,  0.984426,  0.975322,  0.967806,  0.960360,  0.952197,  0.942495,  0.936385,  0.928643,  0.918879,  0.910888,  0.904995,  0.897841,  0.885838,  0.877704,  0.873659,  0.866217,  0.849433,  0.849371,  0.840329,  0.832709,  0.821065,  0.816830,  0.809522,  0.797271,  0.787446,  0.788824,  0.778460,  0.764505,  0.755203,  0.754732,  0.749523,  0.722122,  0.731404,  0.720149,  0.711279,  0.702068,  0.696528,  0.690826,  0.675274,  0.666770,  0.670313,  0.660522,  0.640358,  0.632319,  0.638103,  0.629155,  0.597849,  0.610350,  0.604365,  0.588820,  0.580576,  0.580147,  0.572609,  0.552439,  0.543938,  0.547827,  0.542989,  0.517414,  0.513939,  0.517934,  0.507029,  0.480929,  0.492284,  0.479121,  0.470700,  0.455124,  0.463556,  0.455962,  0.428008,  0.422103,  0.428747,  0.427348,  0.390110,  0.396306,  0.398627,  0.385592,  0.359561,  0.370881,  0.364446,  0.345643,  0.336704,  0.341348,  0.340164,  0.305994,  0.297611,  0.313852,  0.307878,  0.256378,  0.285714,  0.274350,  0.271778,  0.237170,  0.252163,  0.247164,  0.218750,  0.207519,  0.234346,  0.217859, },
{ 1.000000,  0.991583,  0.983369,  0.975648,  0.967856,  0.957014,  0.951285,  0.942761,  0.934310,  0.925782,  0.918009,  0.910392,  0.900108,  0.891697,  0.887366,  0.878681,  0.866838,  0.856633,  0.854757,  0.847408,  0.827061,  0.828648,  0.821652,  0.809886,  0.801901,  0.796034,  0.788954,  0.774977,  0.766297,  0.764732,  0.756916,  0.740624,  0.733206,  0.732998,  0.722779,  0.704412,  0.706836,  0.696618,  0.687040,  0.676141,  0.675746,  0.669175,  0.647548,  0.640876,  0.642692,  0.638756,  0.610525,  0.612052,  0.611855,  0.597238,  0.580031,  0.584158,  0.575538,  0.561532,  0.551560,  0.553438,  0.549681,  0.522288,  0.513744,  0.522512,  0.517196,  0.477080,  0.496323,  0.484938,  0.480481,  0.454758,  0.459685,  0.455931,  0.433683,  0.421131,  0.439204,  0.424068,  0.399623,  0.391279,  0.397651,  0.397647,  0.344822,  0.375130,  0.364294,  0.351987,  0.337123,  0.336437,  0.332204,  0.307762,  0.300403,  0.314464,  0.306193,  0.275389,  0.258224,  0.284985,  0.273001,  0.213053,  0.250430,  0.245712,  0.225912,  0.217153,  0.213510,  0.213011,  0.183168,  0.174705, },
{ 1.000000,  0.991744,  0.983316,  0.973999,  0.965770,  0.958573,  0.949601,  0.939350,  0.933074,  0.924288,  0.914951,  0.906484,  0.899876,  0.892175,  0.879505,  0.871592,  0.866256,  0.859372,  0.844326,  0.838410,  0.833543,  0.822748,  0.809819,  0.808074,  0.798293,  0.787237,  0.778793,  0.774612,  0.768456,  0.750293,  0.741650,  0.742182,  0.735152,  0.710238,  0.715643,  0.706582,  0.698863,  0.680843,  0.680154,  0.674488,  0.658324,  0.647414,  0.653075,  0.642253,  0.622324,  0.614064,  0.616949,  0.611696,  0.575439,  0.592136,  0.579372,  0.569546,  0.558255,  0.552857,  0.549024,  0.528597,  0.519972,  0.528169,  0.518778,  0.495209,  0.481240,  0.496102,  0.486128,  0.440808,  0.463025,  0.458184,  0.442279,  0.432864,  0.427945,  0.423070,  0.401723,  0.391768,  0.402393,  0.395478,  0.358721,  0.356591,  0.367968,  0.353858,  0.323471,  0.338276,  0.328799,  0.312016,  0.302592,  0.306302,  0.302707,  0.271236,  0.261479,  0.272715,  0.271125,  0.230451,  0.235911,  0.241027,  0.225203,  0.194286,  0.215157,  0.204013,  0.183378,  0.171096,  0.186446,  0.176047, },
{ 1.000000,  0.991145,  0.982274,  0.974475,  0.966202,  0.955236,  0.948456,  0.939771,  0.931562,  0.920529,  0.913885,  0.906077,  0.895063,  0.886012,  0.880998,  0.872361,  0.859738,  0.850694,  0.846542,  0.839097,  0.818996,  0.820943,  0.810911,  0.801382,  0.791244,  0.783633,  0.778785,  0.763310,  0.753288,  0.754456,  0.744890,  0.728124,  0.717558,  0.720729,  0.712033,  0.682049,  0.692635,  0.682813,  0.670901,  0.661795,  0.655662,  0.649507,  0.632268,  0.623451,  0.625835,  0.618044,  0.592522,  0.587614,  0.591892,  0.580210,  0.553511,  0.563042,  0.554583,  0.539197,  0.529876,  0.530934,  0.522607,  0.498971,  0.490168,  0.495584,  0.491037,  0.460311,  0.462472,  0.459254,  0.449752,  0.422842,  0.436664,  0.423629,  0.408716,  0.398425,  0.405444,  0.394284,  0.366262,  0.357342,  0.366462,  0.366517,  0.320940,  0.337135,  0.332406,  0.322414,  0.293504,  0.301890,  0.300875,  0.276268,  0.263651,  0.276059,  0.270806,  0.234829,  0.227434,  0.239213,  0.239096,  0.177316,  0.215015,  0.199710,  0.189113,  0.172842,  0.170443,  0.174482,  0.140164,  0.127351, },
{ 1.000000,  0.991187,  0.982441,  0.972793,  0.963376,  0.956076,  0.947454,  0.934432,  0.929245,  0.919743,  0.910308,  0.901323,  0.892991,  0.884618,  0.873224,  0.863506,  0.859303,  0.850384,  0.835161,  0.827030,  0.823881,  0.813851,  0.795906,  0.795772,  0.787003,  0.774886,  0.766213,  0.761003,  0.752603,  0.736247,  0.727421,  0.725112,  0.718212,  0.698305,  0.694107,  0.689582,  0.678917,  0.660499,  0.662809,  0.652937,  0.640025,  0.629880,  0.629046,  0.620241,  0.599030,  0.589272,  0.592964,  0.588229,  0.556359,  0.562713,  0.556537,  0.545692,  0.524041,  0.528908,  0.520662,  0.503134,  0.492491,  0.497285,  0.489245,  0.463117,  0.454076,  0.461176,  0.455305,  0.411143,  0.434792,  0.419312,  0.411320,  0.393341,  0.394977,  0.389017,  0.363926,  0.353372,  0.368074,  0.354887,  0.328543,  0.314831,  0.330554,  0.325641,  0.266769,  0.302704,  0.286333,  0.272747,  0.264514,  0.260070,  0.253752,  0.229815,  0.218771,  0.236483,  0.223970,  0.187426,  0.180354,  0.197153,  0.186707,  0.135779,  0.166028,  0.157397,  0.137005,  0.127422,  0.131139,  0.123952, },
{ 1.000000,  0.990771,  0.981282,  0.972797,  0.963905,  0.953095,  0.944399,  0.936654,  0.926692,  0.915531,  0.909085,  0.899456,  0.889548,  0.879360,  0.873416,  0.864266,  0.850491,  0.841452,  0.836327,  0.829462,  0.811141,  0.807242,  0.800509,  0.790132,  0.774446,  0.772209,  0.763584,  0.749680,  0.740717,  0.737111,  0.729636,  0.710658,  0.701716,  0.701697,  0.693299,  0.665773,  0.673236,  0.661794,  0.653027,  0.636838,  0.635511,  0.627299,  0.610251,  0.598193,  0.605242,  0.591768,  0.572598,  0.561873,  0.565020,  0.559837,  0.519486,  0.538394,  0.524261,  0.513280,  0.502216,  0.497130,  0.491314,  0.470200,  0.461025,  0.468971,  0.457379,  0.429526,  0.421259,  0.432168,  0.420599,  0.378541,  0.399203,  0.392612,  0.372511,  0.363066,  0.364503,  0.356238,  0.329873,  0.320491,  0.327601,  0.322565,  0.288540,  0.286969,  0.294182,  0.279797,  0.246852,  0.264037,  0.247694,  0.237646,  0.218869,  0.231578,  0.222902,  0.186878,  0.181012,  0.191054,  0.190368,  0.142332,  0.153374,  0.157139,  0.140435,  0.108146,  0.124746,  0.117063,  0.094080,  0.083767, },
{ 1.000000,  0.990665,  0.981500,  0.971232,  0.961691,  0.953604,  0.944423,  0.931699,  0.925642,  0.915883,  0.907046,  0.894391,  0.888045,  0.878989,  0.866476,  0.856492,  0.852944,  0.842232,  0.828272,  0.818450,  0.814068,  0.806974,  0.783844,  0.786333,  0.775748,  0.764716,  0.754653,  0.746897,  0.738539,  0.723799,  0.714552,  0.713804,  0.703406,  0.685834,  0.672865,  0.676672,  0.668575,  0.635527,  0.645087,  0.638093,  0.622017,  0.612702,  0.607791,  0.600430,  0.580465,  0.570904,  0.572751,  0.563578,  0.540528,  0.533737,  0.536874,  0.523581,  0.498579,  0.505945,  0.493412,  0.481793,  0.468046,  0.470762,  0.463938,  0.433791,  0.427435,  0.432860,  0.429446,  0.390531,  0.396541,  0.398383,  0.378981,  0.356955,  0.365846,  0.355069,  0.337643,  0.325969,  0.330551,  0.327249,  0.290967,  0.281693,  0.295996,  0.289965,  0.236699,  0.265707,  0.251888,  0.246464,  0.213969,  0.222886,  0.218472,  0.190497,  0.176023,  0.200706,  0.182516,  0.151104,  0.142882,  0.152405,  0.152992,  0.085638,  0.127115,  0.114019,  0.098479,  0.080780,  0.081651,  0.076954, },
{ 1.000000,  0.990113,  0.980535,  0.971491,  0.962160,  0.951132,  0.940959,  0.933906,  0.923942,  0.909127,  0.904300,  0.895348,  0.884042,  0.874407,  0.865469,  0.857233,  0.843654,  0.833995,  0.828772,  0.819882,  0.802690,  0.795004,  0.791354,  0.779459,  0.762897,  0.760986,  0.750536,  0.738112,  0.728207,  0.723379,  0.715760,  0.695524,  0.687606,  0.685064,  0.678517,  0.654598,  0.650875,  0.648324,  0.633511,  0.615480,  0.618983,  0.606525,  0.591986,  0.582477,  0.580548,  0.574647,  0.548010,  0.538878,  0.544053,  0.536103,  0.500101,  0.513208,  0.502355,  0.493089,  0.468959,  0.471769,  0.465670,  0.444771,  0.431577,  0.442704,  0.429438,  0.402575,  0.393955,  0.400646,  0.395411,  0.345322,  0.372758,  0.356522,  0.344467,  0.331019,  0.325915,  0.322782,  0.295896,  0.286828,  0.299446,  0.289077,  0.257951,  0.241430,  0.263750,  0.251267,  0.191930,  0.223984,  0.219449,  0.199233,  0.188013,  0.183899,  0.178530,  0.151465,  0.140633,  0.155862,  0.147848,  0.100334,  0.100960,  0.116595,  0.098421,  0.060901,  0.081939,  0.070628,  0.049706,  0.039336, },
{ 1.000000,  0.990276,  0.980669,  0.970088,  0.960131,  0.951089,  0.941815,  0.929399,  0.920850,  0.912376,  0.901652,  0.889068,  0.883175,  0.872910,  0.860989,  0.850492,  0.844737,  0.834713,  0.819565,  0.809538,  0.805354,  0.797155,  0.775946,  0.775019,  0.765020,  0.755600,  0.738553,  0.735158,  0.727420,  0.710787,  0.700447,  0.699364,  0.689218,  0.670442,  0.659807,  0.659571,  0.651887,  0.619404,  0.630900,  0.617779,  0.606091,  0.593463,  0.585876,  0.582611,  0.560327,  0.548794,  0.555385,  0.544188,  0.520247,  0.507980,  0.517230,  0.506740,  0.463292,  0.483748,  0.472054,  0.457001,  0.446627,  0.440853,  0.434354,  0.411519,  0.401936,  0.408029,  0.399493,  0.364298,  0.361081,  0.369746,  0.354779,  0.319400,  0.335762,  0.325858,  0.306384,  0.295825,  0.299189,  0.289974,  0.258953,  0.250023,  0.259185,  0.254319,  0.213822,  0.220010,  0.217382,  0.205575,  0.171189,  0.192265,  0.176058,  0.157894,  0.145717,  0.156600,  0.143496,  0.107638,  0.098555,  0.111524,  0.112532,  0.054200,  0.078436,  0.073097,  0.060233,  0.024640,  0.037578,  0.036756, },
{ 1.000000,  0.989756,  0.979429,  0.969933,  0.960076,  0.948369,  0.938212,  0.929671,  0.920359,  0.904663,  0.899758,  0.888777,  0.878265,  0.867058,  0.857922,  0.849790,  0.835184,  0.824285,  0.821121,  0.809458,  0.793926,  0.782449,  0.780955,  0.770727,  0.745515,  0.749262,  0.737298,  0.724995,  0.715067,  0.706745,  0.698058,  0.681514,  0.670272,  0.670540,  0.660482,  0.636662,  0.628936,  0.630323,  0.617757,  0.590406,  0.597077,  0.587237,  0.570968,  0.561498,  0.557983,  0.548795,  0.525616,  0.516351,  0.517309,  0.510389,  0.481981,  0.480453,  0.477120,  0.463878,  0.438851,  0.446744,  0.434797,  0.418668,  0.406631,  0.408820,  0.398900,  0.370429,  0.359445,  0.367655,  0.363371,  0.319671,  0.332659,  0.326158,  0.312761,  0.284707,  0.294503,  0.285032,  0.262994,  0.250470,  0.259325,  0.250478,  0.216461,  0.206799,  0.218444,  0.211920,  0.154275,  0.188832,  0.169540,  0.160043,  0.138315,  0.142437,  0.135740,  0.104394,  0.092423,  0.113028,  0.097546,  0.064214,  0.048608,  0.070328,  0.064820, -0.009581,  0.038951,  0.018858,  0.002154, -0.006693, },
{ 1.000000,  0.989558,  0.979428,  0.968444,  0.958057,  0.949013,  0.938463,  0.925996,  0.915665,  0.907711,  0.897331,  0.881665,  0.876534,  0.866151,  0.853907,  0.843556,  0.835253,  0.825159,  0.810501,  0.799873,  0.794679,  0.784785,  0.766858,  0.759221,  0.753710,  0.740686,  0.724178,  0.721842,  0.710532,  0.697869,  0.684813,  0.682732,  0.671924,  0.650884,  0.641778,  0.639563,  0.633589,  0.604594,  0.605464,  0.599394,  0.586178,  0.564534,  0.566666,  0.556755,  0.538627,  0.528478,  0.527287,  0.520044,  0.492966,  0.483599,  0.488117,  0.478304,  0.438810,  0.455576,  0.441002,  0.430948,  0.410108,  0.412076,  0.402514,  0.380476,  0.366323,  0.379253,  0.362771,  0.337470,  0.325353,  0.333093,  0.327603,  0.272685,  0.303315,  0.285340,  0.271746,  0.259338,  0.254705,  0.248732,  0.221763,  0.212028,  0.224343,  0.210723,  0.174843,  0.166554,  0.182776,  0.168811,  0.114422,  0.144142,  0.137399,  0.112139,  0.101492,  0.105329,  0.095840,  0.062631,  0.052978,  0.063253,  0.058124,  0.014853,  0.016093,  0.026077,  0.008039, -0.032190, -0.008594, -0.028254, },
{ 1.000000,  0.989168,  0.978352,  0.968243,  0.957592,  0.945193,  0.934774,  0.925443,  0.915472,  0.900608,  0.892402,  0.883107,  0.871300,  0.857326,  0.850508,  0.839896,  0.826699,  0.815847,  0.808192,  0.799121,  0.781128,  0.770863,  0.766948,  0.756480,  0.732108,  0.734068,  0.721790,  0.712424,  0.692959,  0.690555,  0.680324,  0.662089,  0.650573,  0.652738,  0.638978,  0.618326,  0.607464,  0.606763,  0.599626,  0.562753,  0.574975,  0.561713,  0.547697,  0.536061,  0.528355,  0.519217,  0.499158,  0.489451,  0.492619,  0.480286,  0.455859,  0.440247,  0.450129,  0.440751,  0.393417,  0.412439,  0.405255,  0.384087,  0.373601,  0.369774,  0.361955,  0.335188,  0.325042,  0.330491,  0.319968,  0.289061,  0.282908,  0.289822,  0.272641,  0.240316,  0.253725,  0.238215,  0.224106,  0.207564,  0.213757,  0.206577,  0.166914,  0.161114,  0.170424,  0.167415,  0.115947,  0.127554,  0.131299,  0.106484,  0.079069,  0.093586,  0.080257,  0.058845,  0.045399,  0.053293,  0.050366,  0.003850, -0.005766,  0.014111,  0.007083, -0.061018, -0.020438, -0.037467, -0.043841, -0.084005, },
{ 1.000000,  0.989157,  0.978150,  0.966645,  0.955145,  0.946161,  0.934587,  0.921881,  0.910755,  0.901765,  0.891815,  0.873649,  0.869306,  0.857882,  0.845713,  0.833519,  0.824448,  0.814102,  0.799022,  0.788432,  0.783125,  0.772236,  0.754572,  0.741234,  0.740763,  0.728355,  0.700665,  0.704698,  0.695144,  0.679689,  0.668427,  0.659399,  0.651232,  0.631615,  0.621136,  0.619063,  0.609497,  0.583002,  0.576635,  0.576728,  0.561072,  0.537899,  0.540705,  0.528414,  0.511997,  0.500939,  0.497808,  0.490503,  0.461831,  0.453772,  0.454510,  0.447836,  0.413969,  0.413014,  0.412997,  0.393552,  0.369565,  0.379263,  0.363351,  0.345044,  0.334220,  0.334803,  0.329065,  0.292664,  0.283472,  0.293813,  0.284804,  0.235455,  0.258149,  0.244829,  0.233893,  0.202926,  0.209567,  0.203179,  0.176233,  0.161042,  0.177832,  0.162332,  0.127179,  0.118354,  0.129765,  0.123859,  0.058056,  0.097887,  0.077893,  0.063130,  0.047063,  0.042621,  0.039794,  0.005538, -0.003870,  0.013750,  0.002072, -0.037771, -0.056536, -0.026382, -0.041349, -0.117161, -0.073272, -0.077959, },
{ 1.000000,  0.988758,  0.977484,  0.966435,  0.955202,  0.942933,  0.931570,  0.922270,  0.911350,  0.896165,  0.886074,  0.877651,  0.865199,  0.849992,  0.843418,  0.831950,  0.818727,  0.807332,  0.798793,  0.788989,  0.771238,  0.760212,  0.754298,  0.744997,  0.723676,  0.717378,  0.710211,  0.695975,  0.677159,  0.676813,  0.664080,  0.648383,  0.635515,  0.633357,  0.621579,  0.598892,  0.587776,  0.587864,  0.579430,  0.545952,  0.552735,  0.540836,  0.530014,  0.505974,  0.506465,  0.498412,  0.475331,  0.463471,  0.466694,  0.455321,  0.429142,  0.417220,  0.421263,  0.412825,  0.365833,  0.388696,  0.371937,  0.357539,  0.342525,  0.335038,  0.333060,  0.302983,  0.289931,  0.302382,  0.289364,  0.257135,  0.243094,  0.258870,  0.246744,  0.187466,  0.219768,  0.205689,  0.186877,  0.174894,  0.169307,  0.162443,  0.132975,  0.123212,  0.133335,  0.123885,  0.077423,  0.076305,  0.089713,  0.070661,  0.025401,  0.049865,  0.038571,  0.014302,  0.001921,  0.008122, -0.002157, -0.042042, -0.050844, -0.037673, -0.042709, -0.094543, -0.083294, -0.085571, -0.100230, -0.143336, },
{ 1.000000,  0.988571,  0.976955,  0.965115,  0.953644,  0.943314,  0.931682,  0.917952,  0.906379,  0.897080,  0.887101,  0.869421,  0.862539,  0.851560,  0.839551,  0.823735,  0.816451,  0.806419,  0.791002,  0.778483,  0.772388,  0.761925,  0.742537,  0.731676,  0.726368,  0.717241,  0.688099,  0.692907,  0.678925,  0.666218,  0.652103,  0.643180,  0.636053,  0.614508,  0.601780,  0.604885,  0.590216,  0.567692,  0.554160,  0.558982,  0.546962,  0.507923,  0.522100,  0.507040,  0.491523,  0.480468,  0.472126,  0.463095,  0.440790,  0.428037,  0.433006,  0.421581,  0.387944,  0.381335,  0.387630,  0.371766,  0.333965,  0.348469,  0.337138,  0.316527,  0.306080,  0.304430,  0.294226,  0.263264,  0.253766,  0.257601,  0.250733,  0.212571,  0.214595,  0.212218,  0.195731,  0.163271,  0.178179,  0.163410,  0.143412,  0.129527,  0.135101,  0.123786,  0.086996,  0.075053,  0.088226,  0.084292,  0.027032,  0.048088,  0.041001,  0.024547, -0.010668,  0.004872, -0.006336, -0.033634, -0.047733, -0.034372, -0.044281, -0.087612, -0.097465, -0.080838, -0.088043, -0.161424, -0.113662, -0.137809, },
{ 1.000000,  0.988120,  0.976208,  0.964757,  0.953043,  0.939929,  0.928053,  0.918556,  0.906341,  0.891997,  0.879708,  0.871650,  0.860459,  0.839191,  0.836601,  0.823050,  0.809884,  0.798256,  0.787804,  0.776519,  0.760481,  0.748665,  0.743913,  0.731195,  0.710525,  0.700210,  0.696412,  0.683555,  0.657329,  0.659669,  0.647758,  0.631524,  0.619360,  0.612652,  0.601442,  0.580040,  0.568657,  0.566643,  0.555760,  0.529235,  0.523373,  0.520378,  0.503433,  0.480446,  0.483630,  0.469427,  0.453721,  0.437619,  0.439655,  0.427127,  0.397723,  0.388086,  0.389604,  0.384219,  0.342806,  0.350036,  0.344001,  0.327554,  0.298342,  0.306296,  0.294845,  0.271171,  0.259931,  0.261985,  0.254305,  0.217855,  0.208022,  0.217858,  0.206418,  0.152509,  0.180823,  0.162464,  0.150504,  0.124152,  0.130078,  0.118906,  0.090941,  0.074178,  0.094234,  0.074209,  0.041279,  0.028066,  0.040645,  0.034857, -0.036942,  0.007265, -0.015095, -0.031658, -0.046171, -0.049695, -0.056335, -0.090344, -0.100225, -0.083121, -0.098878, -0.144922, -0.152681, -0.129913, -0.147494, -0.216206, },
{ 1.000000,  0.987836,  0.976025,  0.963326,  0.951256,  0.939856,  0.928049,  0.913914,  0.901679,  0.891760,  0.880186,  0.864022,  0.853430,  0.844325,  0.830823,  0.813668,  0.807633,  0.793676,  0.781339,  0.766619,  0.760615,  0.748593,  0.728327,  0.717675,  0.711122,  0.701669,  0.676516,  0.672257,  0.663898,  0.648823,  0.628411,  0.626154,  0.614318,  0.596811,  0.584313,  0.578747,  0.569863,  0.543491,  0.532316,  0.533425,  0.521486,  0.484641,  0.495703,  0.480324,  0.470716,  0.443298,  0.445937,  0.434206,  0.410115,  0.396620,  0.405095,  0.388382,  0.360225,  0.348413,  0.351897,  0.345205,  0.292503,  0.316206,  0.300035,  0.282742,  0.269217,  0.261907,  0.252086,  0.226239,  0.215885,  0.223493,  0.209206,  0.177401,  0.158858,  0.175988,  0.165106,  0.101528,  0.131687,  0.124202,  0.097842,  0.085571,  0.083455,  0.075128,  0.040921,  0.030325,  0.039544,  0.028038, -0.012329, -0.016393, -0.005512, -0.027166, -0.067607, -0.047040, -0.065768, -0.082491, -0.102304, -0.092124, -0.099627, -0.149998, -0.154788, -0.141015, -0.143539, -0.208802, -0.190265, -0.184902, },
{ 1.000000,  0.987375,  0.974604,  0.962797,  0.950125,  0.937211,  0.924330,  0.913255,  0.901513,  0.885460,  0.872952,  0.864097,  0.852359,  0.831354,  0.826730,  0.813344,  0.801513,  0.783497,  0.775678,  0.764312,  0.746776,  0.732942,  0.730184,  0.715290,  0.695501,  0.683955,  0.677480,  0.668044,  0.635486,  0.641632,  0.627314,  0.612034,  0.596813,  0.588554,  0.577423,  0.556227,  0.545273,  0.543575,  0.531735,  0.505897,  0.489839,  0.496504,  0.481443,  0.438960,  0.453460,  0.443296,  0.423189,  0.409917,  0.401423,  0.393120,  0.366081,  0.355507,  0.356606,  0.346448,  0.309066,  0.305287,  0.309205,  0.289186,  0.258481,  0.267376,  0.252332,  0.232108,  0.219353,  0.218648,  0.211608,  0.172763,  0.165312,  0.169206,  0.163067,  0.117200,  0.120602,  0.122878,  0.098292,  0.067377,  0.084914,  0.064653,  0.042271,  0.029906,  0.033826,  0.028065, -0.019421, -0.028403, -0.012471, -0.022638, -0.087112, -0.052804, -0.069454, -0.081902, -0.120993, -0.109253, -0.116706, -0.149679, -0.167423, -0.143988, -0.162112, -0.206615, -0.215410, -0.198966, -0.205309, -0.289424, },
{ 1.000000,  0.987237,  0.974478,  0.961427,  0.948214,  0.935949,  0.923590,  0.909016,  0.896158,  0.886110,  0.873547,  0.857010,  0.843000,  0.836216,  0.822777,  0.799290,  0.795843,  0.784045,  0.768733,  0.755326,  0.744058,  0.732566,  0.714288,  0.701491,  0.696046,  0.683804,  0.658311,  0.649655,  0.645214,  0.628812,  0.606119,  0.604797,  0.591290,  0.573809,  0.560633,  0.554234,  0.544184,  0.518092,  0.506242,  0.503279,  0.494065,  0.462180,  0.459637,  0.453809,  0.435232,  0.409476,  0.415834,  0.399792,  0.379634,  0.364605,  0.366439,  0.352885,  0.321215,  0.309167,  0.314200,  0.305273,  0.258268,  0.274191,  0.259591,  0.247267,  0.215128,  0.220280,  0.211697,  0.181775,  0.168238,  0.176458,  0.163292,  0.128595,  0.115485,  0.124215,  0.115563,  0.051641,  0.088106,  0.066928,  0.049288,  0.031419,  0.024167,  0.023918, -0.015029, -0.029586, -0.010776, -0.025554, -0.067584, -0.083324, -0.059620, -0.073992, -0.151368, -0.105244, -0.122400, -0.145341, -0.159271, -0.163998, -0.171267, -0.208437, -0.218547, -0.203957, -0.214385, -0.273797, -0.271539, -0.253096, },
{ 1.000000,  0.987068,  0.973252,  0.961282,  0.948328,  0.934312,  0.921187,  0.909573,  0.896805,  0.880774,  0.868040,  0.857913,  0.845832,  0.826908,  0.817236,  0.805584,  0.791908,  0.772989,  0.767991,  0.753062,  0.737801,  0.724088,  0.717237,  0.703404,  0.681748,  0.669390,  0.663635,  0.654121,  0.623892,  0.624129,  0.612102,  0.597823,  0.575051,  0.571152,  0.561052,  0.539912,  0.525202,  0.523055,  0.512025,  0.483289,  0.472222,  0.470650,  0.461425,  0.416928,  0.433568,  0.415425,  0.400223,  0.383005,  0.374668,  0.368605,  0.339346,  0.324661,  0.334220,  0.316409,  0.285868,  0.270593,  0.282514,  0.268590,  0.213208,  0.239818,  0.220851,  0.201819,  0.189643,  0.181552,  0.171559,  0.142817,  0.128832,  0.138984,  0.126226,  0.081446,  0.075848,  0.087611,  0.068013,  0.018507,  0.042420,  0.029194,  0.003308, -0.008098, -0.007420, -0.018987, -0.058690, -0.068030, -0.060680, -0.067933, -0.117223, -0.110384, -0.111919, -0.131995, -0.173222, -0.150213, -0.168476, -0.192660, -0.208451, -0.198762, -0.211605, -0.258356, -0.270924, -0.252470, -0.255872, -0.328556, },
{ 1.000000,  0.986701,  0.973510,  0.959781,  0.945255,  0.933405,  0.920086,  0.905201,  0.891504,  0.880698,  0.867669,  0.850327,  0.836924,  0.827557,  0.814908,  0.791240,  0.788034,  0.772275,  0.758898,  0.742621,  0.733316,  0.720395,  0.700916,  0.687194,  0.683100,  0.667999,  0.646675,  0.631997,  0.629394,  0.617508,  0.580359,  0.589628,  0.572005,  0.555735,  0.542782,  0.532054,  0.519773,  0.498070,  0.484939,  0.484593,  0.469654,  0.439924,  0.429742,  0.430436,  0.414987,  0.376815,  0.387964,  0.374248,  0.353311,  0.339541,  0.334378,  0.321997,  0.292987,  0.280683,  0.282535,  0.270712,  0.233944,  0.230779,  0.230460,  0.209057,  0.179067,  0.188354,  0.170922,  0.151924,  0.132616,  0.139071,  0.124696,  0.085730,  0.076262,  0.081518,  0.076995,  0.021237,  0.036081,  0.030077,  0.009829, -0.027642, -0.013088, -0.026443, -0.055823, -0.068435, -0.062981, -0.070811, -0.117948, -0.127634, -0.112394, -0.125576, -0.195626, -0.153965, -0.177204, -0.190742, -0.223359, -0.212709, -0.226123, -0.260560, -0.279620, -0.252129, -0.275981, -0.317543, -0.331432, -0.313652, },
{ 1.000000,  0.986525,  0.971473,  0.959445,  0.945341,  0.931338,  0.917429,  0.904423,  0.891197,  0.875205,  0.861722,  0.851477,  0.837460,  0.818731,  0.805706,  0.797516,  0.782872,  0.758680,  0.755124,  0.742185,  0.724499,  0.710653,  0.701210,  0.687772,  0.666759,  0.653749,  0.646553,  0.634628,  0.608985,  0.600495,  0.593720,  0.576604,  0.552052,  0.552018,  0.534360,  0.519844,  0.501186,  0.499607,  0.486125,  0.456865,  0.446155,  0.442806,  0.433495,  0.396498,  0.397352,  0.389800,  0.371177,  0.343176,  0.346722,  0.332753,  0.310549,  0.296077,  0.293165,  0.284557,  0.248037,  0.236727,  0.243074,  0.229451,  0.177764,  0.200398,  0.181202,  0.170903,  0.134792,  0.143102,  0.129555,  0.098375,  0.083346,  0.099010,  0.078572,  0.041783,  0.029254,  0.037502,  0.030819, -0.039630, -0.002073, -0.022408, -0.043287, -0.059105, -0.065577, -0.076715, -0.109053, -0.119409, -0.107301, -0.123642, -0.164484, -0.185427, -0.160590, -0.173197, -0.254880, -0.212065, -0.219927, -0.252643, -0.266574, -0.266883, -0.275729, -0.318389, -0.329012, -0.315497, -0.328474, -0.379572, },
{ 1.000000,  0.985845,  0.972242,  0.957700,  0.942273,  0.930039,  0.915530,  0.901107,  0.885968,  0.874255,  0.860891,  0.841989,  0.828913,  0.818207,  0.805754,  0.782810,  0.774326,  0.763032,  0.745488,  0.726929,  0.720107,  0.704951,  0.687653,  0.672727,  0.664547,  0.652949,  0.626813,  0.613468,  0.609842,  0.596840,  0.561647,  0.567587,  0.550292,  0.537806,  0.512012,  0.508460,  0.495884,  0.471744,  0.455716,  0.459692,  0.441295,  0.413711,  0.401370,  0.398043,  0.389307,  0.340166,  0.358678,  0.341126,  0.322399,  0.303735,  0.297000,  0.284650,  0.256369,  0.245497,  0.248051,  0.234815,  0.199769,  0.181197,  0.195513,  0.177708,  0.118854,  0.145354,  0.134189,  0.108936,  0.093785,  0.085751,  0.077214,  0.042203,  0.031419,  0.036348,  0.025658, -0.023941, -0.024663, -0.016294, -0.041284, -0.080812, -0.064515, -0.082573, -0.107515, -0.121655, -0.119614, -0.126580, -0.176548, -0.182824, -0.175128, -0.181454, -0.240593, -0.231377, -0.227149, -0.257378, -0.295969, -0.269649, -0.294788, -0.321425, -0.335055, -0.327971, -0.333540, -0.393378, -0.401860, -0.379389, },
{ 1.000000,  0.985807,  0.970239,  0.956948,  0.942418,  0.928061,  0.911785,  0.899016,  0.885078,  0.868556,  0.853472,  0.843192,  0.828192,  0.809100,  0.795329,  0.785250,  0.772017,  0.744353,  0.743018,  0.725774,  0.710274,  0.694387,  0.682257,  0.669719,  0.647979,  0.634481,  0.629060,  0.614442,  0.589772,  0.573171,  0.573417,  0.557195,  0.517730,  0.525323,  0.513036,  0.492666,  0.477284,  0.466466,  0.454094,  0.429092,  0.415509,  0.414036,  0.400737,  0.362960,  0.357020,  0.357026,  0.335766,  0.304884,  0.310307,  0.294062,  0.272167,  0.257263,  0.252946,  0.243048,  0.207169,  0.195110,  0.195637,  0.186353,  0.142788,  0.145058,  0.140231,  0.117092,  0.083251,  0.097921,  0.078158,  0.052867,  0.035704,  0.042193,  0.026456, -0.014971, -0.027235, -0.017199, -0.026355, -0.089184, -0.061863, -0.079780, -0.093968, -0.134719, -0.123520, -0.133576, -0.170930, -0.185702, -0.172127, -0.187205, -0.231745, -0.245203, -0.231040, -0.240712, -0.323217, -0.270575, -0.297298, -0.318304, -0.339547, -0.345835, -0.344375, -0.393699, -0.409024, -0.382991, -0.399838, -0.452712, },
{ 1.000000,  0.985020,  0.970965,  0.956116,  0.938275,  0.926694,  0.911720,  0.896168,  0.881284,  0.867129,  0.852999,  0.835206,  0.820850,  0.809888,  0.795700,  0.772866,  0.760867,  0.751668,  0.734717,  0.711219,  0.706364,  0.691068,  0.672473,  0.657444,  0.648095,  0.633805,  0.609220,  0.595763,  0.588926,  0.576349,  0.546403,  0.541210,  0.529378,  0.512588,  0.484916,  0.487757,  0.468584,  0.449321,  0.433224,  0.430186,  0.413701,  0.383187,  0.370227,  0.368392,  0.359519,  0.314136,  0.323333,  0.309531,  0.292530,  0.261545,  0.262794,  0.251890,  0.224038,  0.206915,  0.209266,  0.197388,  0.157933,  0.146607,  0.149254,  0.140303,  0.077716,  0.108690,  0.085551,  0.067117,  0.046142,  0.038608,  0.033480, -0.004783, -0.020924, -0.004164, -0.025618, -0.065696, -0.082595, -0.062724, -0.078955, -0.153686, -0.112062, -0.135433, -0.158621, -0.172140, -0.179829, -0.191186, -0.227535, -0.242685, -0.226781, -0.241154, -0.299133, -0.302515, -0.284694, -0.308872, -0.372082, -0.336843, -0.352665, -0.384714, -0.397266, -0.393825, -0.406548, -0.456688, -0.465487, -0.454557, },
{ 1.000000,  0.985076,  0.968909,  0.954338,  0.939755,  0.924003,  0.906786,  0.894358,  0.878735,  0.862443,  0.846688,  0.834487,  0.819509,  0.799099,  0.784038,  0.774047,  0.760459,  0.734147,  0.727530,  0.713131,  0.696618,  0.674430,  0.667622,  0.652265,  0.632019,  0.616047,  0.609231,  0.594415,  0.567852,  0.553750,  0.548666,  0.534914,  0.495384,  0.504612,  0.483765,  0.468232,  0.447147,  0.440515,  0.426119,  0.399250,  0.383574,  0.385472,  0.367551,  0.337620,  0.320853,  0.324290,  0.311076,  0.255986,  0.279764,  0.256692,  0.236674,  0.222457,  0.211881,  0.198121,  0.169511,  0.155315,  0.160371,  0.142506,  0.102058,  0.092772,  0.098741,  0.079966,  0.027588,  0.049595,  0.033357,  0.007185, -0.008483, -0.011496, -0.025730, -0.063110, -0.075883, -0.070130, -0.083147, -0.131842, -0.130859, -0.128574, -0.155599, -0.193939, -0.176164, -0.198160, -0.221091, -0.244053, -0.231776, -0.248564, -0.299063, -0.308126, -0.298428, -0.301822, -0.374510, -0.349853, -0.356666, -0.380752, -0.427989, -0.405456, -0.421451, -0.457735, -0.471316, -0.461597, -0.470246, -0.529920, },
{ 1.000000,  0.984366,  0.969181,  0.953897,  0.935409,  0.923006,  0.906630,  0.891180,  0.873569,  0.860632,  0.844919,  0.826804,  0.810222,  0.800594,  0.783404,  0.763232,  0.747471,  0.737635,  0.723374,  0.692022,  0.692099,  0.673193,  0.655907,  0.639735,  0.626819,  0.612745,  0.589572,  0.575290,  0.569064,  0.552494,  0.523832,  0.510711,  0.507737,  0.489763,  0.451021,  0.457935,  0.443327,  0.419765,  0.403861,  0.396790,  0.381265,  0.352075,  0.338075,  0.334202,  0.321494,  0.284686,  0.279016,  0.274913,  0.252871,  0.219112,  0.226539,  0.204209,  0.187017,  0.163740,  0.167529,  0.152151,  0.111787,  0.101576,  0.101556,  0.092592,  0.041055,  0.048909,  0.041577,  0.018755, -0.018378, -0.007565, -0.024451, -0.052199, -0.069011, -0.068680, -0.077468, -0.125814, -0.137204, -0.124484, -0.140595, -0.209662, -0.173109, -0.197360, -0.208466, -0.254853, -0.239548, -0.255633, -0.295048, -0.311822, -0.288146, -0.312763, -0.360246, -0.372871, -0.359463, -0.365910, -0.458042, -0.403419, -0.429119, -0.454280, -0.472899, -0.478125, -0.491090, -0.531101, -0.541540, -0.524018, },
{ 1.000000,  0.984084,  0.967703,  0.951187,  0.936795,  0.920913,  0.900197,  0.888519,  0.873000,  0.855253,  0.839020,  0.824672,  0.809273,  0.789164,  0.773504,  0.761782,  0.745982,  0.722950,  0.709577,  0.699180,  0.680492,  0.656361,  0.650370,  0.631812,  0.614508,  0.595765,  0.587366,  0.573198,  0.543278,  0.530423,  0.523447,  0.511182,  0.474111,  0.471533,  0.461834,  0.438227,  0.412708,  0.411835,  0.393336,  0.371596,  0.353924,  0.348917,  0.337199,  0.299127,  0.285529,  0.287832,  0.273115,  0.220828,  0.239355,  0.217964,  0.204389,  0.168995,  0.170828,  0.156401,  0.124833,  0.106077,  0.118087,  0.095280,  0.057985,  0.045725,  0.045946,  0.037584, -0.031222,  0.002933, -0.019200, -0.042357, -0.065075, -0.069719, -0.083598, -0.120222, -0.130764, -0.123746, -0.138697, -0.184408, -0.205502, -0.182542, -0.203874, -0.282164, -0.240865, -0.253487, -0.285147, -0.302743, -0.309797, -0.318653, -0.363448, -0.373916, -0.365014, -0.376713, -0.440288, -0.436769, -0.423798, -0.455153, -0.504265, -0.479070, -0.501422, -0.531611, -0.547825, -0.541939, -0.549050, -0.612293, },
{ 1.000000,  0.983388,  0.967342,  0.951294,  0.932703,  0.917809,  0.902596,  0.884879,  0.865994,  0.853755,  0.836006,  0.817975,  0.801477,  0.788513,  0.773451,  0.749310,  0.733878,  0.724040,  0.708094,  0.677707,  0.674705,  0.656862,  0.640392,  0.615824,  0.607445,  0.592082,  0.568909,  0.550877,  0.546619,  0.528584,  0.500050,  0.485813,  0.479971,  0.465828,  0.420196,  0.432394,  0.410094,  0.391477,  0.372307,  0.360655,  0.347805,  0.317653,  0.303388,  0.302850,  0.286379,  0.251700,  0.232496,  0.240705,  0.221455,  0.163099,  0.183706,  0.170186,  0.144547,  0.126330,  0.116275,  0.102662,  0.070004,  0.055446,  0.058313,  0.043372, -0.008334, -0.010830, -0.005934, -0.033178, -0.073271, -0.059847, -0.079755, -0.107169, -0.123840, -0.125536, -0.135727, -0.182971, -0.194574, -0.190505, -0.199987, -0.257802, -0.248863, -0.253027, -0.281906, -0.325114, -0.299798, -0.324798, -0.356093, -0.376064, -0.363754, -0.382150, -0.435534, -0.447727, -0.431310, -0.441229, -0.522931, -0.481829, -0.503875, -0.520031, -0.571542, -0.552794, -0.564455, -0.610746, -0.627243, -0.607277, },
{ 1.000000,  0.983353,  0.965930,  0.948964,  0.933406,  0.917051,  0.895317,  0.883854,  0.865922,  0.848477,  0.830505,  0.814771,  0.800042,  0.778135,  0.761148,  0.750896,  0.733881,  0.709914,  0.692723,  0.685053,  0.668014,  0.632579,  0.633344,  0.614960,  0.595013,  0.577748,  0.564003,  0.548707,  0.523327,  0.507711,  0.500382,  0.484762,  0.449442,  0.439694,  0.434803,  0.412812,  0.378118,  0.381997,  0.364142,  0.339867,  0.322604,  0.315929,  0.299818,  0.264972,  0.251752,  0.248535,  0.235269,  0.192090,  0.192233,  0.179881,  0.159930,  0.121786,  0.134328,  0.109777,  0.085834,  0.066863,  0.069024,  0.049340,  0.007994, -0.005342, -0.002708, -0.010929, -0.073807, -0.053356, -0.069808, -0.089929, -0.130747, -0.123312, -0.135252, -0.170964, -0.190883, -0.183151, -0.196269, -0.248413, -0.259001, -0.251619, -0.260616, -0.344719, -0.296318, -0.325721, -0.347350, -0.372823, -0.379174, -0.383465, -0.432245, -0.450303, -0.424690, -0.450617, -0.502119, -0.520391, -0.491509, -0.510465, -0.607555, -0.547888, -0.577095, -0.605039, -0.620281, -0.627219, -0.639936, -0.685153, },
{ 1.000000,  0.982342,  0.965777,  0.948526,  0.929018,  0.912355,  0.897115,  0.878967,  0.857116,  0.844815,  0.827199,  0.807888,  0.790653,  0.775935,  0.759153,  0.735653,  0.719280,  0.706825,  0.690821,  0.663323,  0.652480,  0.637796,  0.618102,  0.591868,  0.586841,  0.566944,  0.545625,  0.527581,  0.518539,  0.501027,  0.470862,  0.454120,  0.448681,  0.435277,  0.392849,  0.395158,  0.378912,  0.358480,  0.327449,  0.326992,  0.308588,  0.282040,  0.263466,  0.261156,  0.244424,  0.206770,  0.192385,  0.191827,  0.176643,  0.118467,  0.142455,  0.115200,  0.097391,  0.070280,  0.066993,  0.050655,  0.014744, -0.002462,  0.006249, -0.015699, -0.055435, -0.074471, -0.064378, -0.078645, -0.155812, -0.114395, -0.143843, -0.168577, -0.184340, -0.194390, -0.210486, -0.246973, -0.262410, -0.251493, -0.272597, -0.326137, -0.333910, -0.321744, -0.345030, -0.413780, -0.378574, -0.398509, -0.430578, -0.448858, -0.449284, -0.465297, -0.513403, -0.526580, -0.515806, -0.530542, -0.593749, -0.586942, -0.582284, -0.615666, -0.664276, -0.636280, -0.663872, -0.691496, -0.718967, -0.699479, },
{ 1.000000,  0.982350,  0.963758,  0.946222,  0.929447,  0.912481,  0.890480,  0.876186,  0.859115,  0.840414,  0.818708,  0.805998,  0.787973,  0.767111,  0.749396,  0.735793,  0.719448,  0.693264,  0.676853,  0.666341,  0.648777,  0.614296,  0.613646,  0.592219,  0.574755,  0.550370,  0.541170,  0.522924,  0.497913,  0.478350,  0.475265,  0.453559,  0.424489,  0.407568,  0.402044,  0.387000,  0.336003,  0.351655,  0.326316,  0.305432,  0.286285,  0.274458,  0.258694,  0.227384,  0.212186,  0.210777,  0.191134,  0.150996,  0.137931,  0.141167,  0.119056,  0.063500,  0.082977,  0.066255,  0.035845,  0.017859,  0.013515, -0.004471, -0.043610, -0.057804, -0.058246, -0.071614, -0.122180, -0.123132, -0.124803, -0.152602, -0.197164, -0.179865, -0.208338, -0.228332, -0.257370, -0.246313, -0.264553, -0.317696, -0.327274, -0.323306, -0.331939, -0.400528, -0.383982, -0.391266, -0.418852, -0.466736, -0.447121, -0.467539, -0.501728, -0.521047, -0.516903, -0.526003, -0.588502, -0.598869, -0.579248, -0.598176, -0.688099, -0.633843, -0.664948, -0.676573, -0.735480, -0.710852, -0.730759, -0.779321, },
{ 1.000000,  0.981594,  0.963910,  0.945626,  0.925938,  0.907490,  0.891295,  0.873997,  0.848174,  0.837281,  0.817892,  0.798493,  0.779524,  0.762980,  0.745138,  0.722488,  0.705279,  0.693101,  0.674095,  0.648353,  0.628718,  0.621070,  0.602967,  0.563648,  0.563629,  0.546930,  0.522358,  0.503543,  0.490628,  0.473959,  0.444695,  0.427858,  0.419824,  0.402147,  0.367332,  0.356115,  0.349454,  0.324627,  0.290621,  0.292922,  0.269132,  0.248143,  0.225058,  0.220896,  0.205256,  0.162525,  0.150445,  0.147688,  0.135125,  0.081270,  0.086763,  0.077778,  0.047426,  0.013524,  0.020548, -0.002680, -0.029882, -0.050431, -0.051170, -0.063925, -0.115903, -0.129284, -0.120585, -0.137361, -0.209603, -0.175495, -0.202998, -0.217337, -0.264230, -0.255780, -0.272605, -0.312916, -0.334500, -0.313451, -0.341244, -0.390112, -0.401787, -0.397827, -0.405830, -0.497744, -0.444956, -0.473090, -0.501139, -0.528352, -0.530772, -0.546903, -0.592973, -0.603387, -0.590882, -0.607749, -0.666209, -0.690240, -0.657134, -0.682300, -0.784261, -0.724895, -0.739394, -0.778548, -0.799459, -0.804546, },
{ 1.000000,  0.981587,  0.962422,  0.943880,  0.926709,  0.908563,  0.886596,  0.869553,  0.853619,  0.833527,  0.811037,  0.798009,  0.778484,  0.757850,  0.739163,  0.724374,  0.707455,  0.680055,  0.663970,  0.650918,  0.634556,  0.602653,  0.592078,  0.578415,  0.554737,  0.528283,  0.523967,  0.500910,  0.478069,  0.459613,  0.449316,  0.433666,  0.397337,  0.381811,  0.377618,  0.359890,  0.312299,  0.321861,  0.299296,  0.281093,  0.247099,  0.244244,  0.227043,  0.196509,  0.175614,  0.178374,  0.156395,  0.117147,  0.103209,  0.101889,  0.086867,  0.020603,  0.049554,  0.021232, -0.000858, -0.024337, -0.034702, -0.048377, -0.087951, -0.102216, -0.097100, -0.115841, -0.161746, -0.183812, -0.166516, -0.189495, -0.268995, -0.232696, -0.247777, -0.279415, -0.300747, -0.309864, -0.325017, -0.366227, -0.381295, -0.373487, -0.390198, -0.457987, -0.455626, -0.445805, -0.479625, -0.530228, -0.506902, -0.531269, -0.564707, -0.583440, -0.581647, -0.591907, -0.652613, -0.663160, -0.655090, -0.664715, -0.738774, -0.721470, -0.724816, -0.760057, -0.814512, -0.776468, -0.807813, -0.845633, },
{ 1.000000,  0.980313,  0.961688,  0.942288,  0.921305,  0.901828,  0.884888,  0.866052,  0.840509,  0.827108,  0.807183,  0.787785,  0.763600,  0.749379,  0.730757,  0.706242,  0.686932,  0.674255,  0.654938,  0.627026,  0.608599,  0.597115,  0.579416,  0.538228,  0.541486,  0.517239,  0.495946,  0.473763,  0.458146,  0.443772,  0.411286,  0.392082,  0.388095,  0.368090,  0.332452,  0.313253,  0.312760,  0.292716,  0.235706,  0.251847,  0.228857,  0.203756,  0.183357,  0.170240,  0.152919,  0.118506,  0.102143,  0.099099,  0.081357,  0.030550,  0.024044,  0.024108, -0.004609, -0.052498, -0.037692, -0.059430, -0.090734, -0.110629, -0.114090, -0.132491, -0.180056, -0.192917, -0.191961, -0.206481, -0.265776, -0.257986, -0.271175, -0.295675, -0.346633, -0.321772, -0.353301, -0.383067, -0.405454, -0.397226, -0.421049, -0.475779, -0.489019, -0.481147, -0.488801, -0.573775, -0.538538, -0.559056, -0.582739, -0.635942, -0.620237, -0.633910, -0.679120, -0.702381, -0.687733, -0.703113, -0.770600, -0.780222, -0.767348, -0.776618, -0.887353, -0.816780, -0.854487, -0.880147, -0.911503, -0.915820, },
{ 1.000000,  0.980299,  0.959438,  0.939298,  0.921354,  0.900901,  0.878478,  0.858362,  0.842731,  0.822542,  0.792985,  0.782887,  0.760933,  0.739423,  0.719714,  0.701373,  0.682080,  0.656789,  0.637109,  0.624922,  0.605213,  0.572412,  0.556365,  0.546340,  0.523079,  0.486620,  0.484677,  0.463720,  0.437765,  0.418290,  0.405722,  0.386417,  0.351807,  0.335052,  0.325626,  0.308250,  0.266989,  0.261282,  0.246382,  0.221678,  0.184023,  0.188912,  0.163348,  0.136452,  0.115146,  0.110385,  0.089910,  0.047404,  0.029458,  0.029477,  0.015582, -0.046051, -0.032473, -0.051629, -0.076229, -0.118370, -0.110873, -0.132956, -0.166867, -0.189020, -0.185306, -0.204644, -0.256126, -0.270332, -0.265177, -0.282777, -0.363459, -0.320665, -0.356300, -0.376990, -0.411034, -0.410216, -0.429438, -0.475610, -0.495089, -0.478066, -0.504606, -0.556827, -0.577656, -0.559569, -0.575940, -0.679282, -0.615894, -0.654127, -0.683932, -0.701950, -0.711135, -0.730067, -0.775743, -0.792455, -0.774765, -0.799844, -0.869090, -0.874827, -0.855132, -0.884093, -0.973106, -0.920876, -0.945476, -0.985402, },
{ 1.000000,  0.979370,  0.959487,  0.939097,  0.917082,  0.896637,  0.878304,  0.858121,  0.833114,  0.815180,  0.797390,  0.774890,  0.749711,  0.736155,  0.714124,  0.691814,  0.669422,  0.655968,  0.635176,  0.604957,  0.586286,  0.572851,  0.556227,  0.516952,  0.510554,  0.492073,  0.468829,  0.436485,  0.430542,  0.408965,  0.380944,  0.360872,  0.350641,  0.332366,  0.293258,  0.276639,  0.271351,  0.250355,  0.196402,  0.210869,  0.182609,  0.162287,  0.129687,  0.125570,  0.103790,  0.069893,  0.047050,  0.051920,  0.024446, -0.015125, -0.033786, -0.034072, -0.050458, -0.124935, -0.090485, -0.124020, -0.149454, -0.171832, -0.182694, -0.200833, -0.242111, -0.257739, -0.253556, -0.277643, -0.331904, -0.343986, -0.333631, -0.361540, -0.437754, -0.401821, -0.421949, -0.461001, -0.481669, -0.481905, -0.503409, -0.554572, -0.569548, -0.565345, -0.579829, -0.647286, -0.642544, -0.641180, -0.676557, -0.734053, -0.704876, -0.740781, -0.764423, -0.800316, -0.780700, -0.802366, -0.871475, -0.879792, -0.871141, -0.879687, -0.969612, -0.941501, -0.949016, -0.982823, -1.044316, -1.013044, },
{ 1.000000,  0.978873,  0.957589,  0.936191,  0.916023,  0.895455,  0.871291,  0.850536,  0.832864,  0.811648,  0.782014,  0.770115,  0.746935,  0.726715,  0.699127,  0.685225,  0.663492,  0.636474,  0.615284,  0.604597,  0.580815,  0.549963,  0.530570,  0.518281,  0.499915,  0.452437,  0.456983,  0.431270,  0.406525,  0.383990,  0.367803,  0.347035,  0.315955,  0.297791,  0.289966,  0.267104,  0.229573,  0.206758,  0.207311,  0.185499,  0.123493,  0.138869,  0.119687,  0.086731,  0.064793,  0.053980,  0.034872, -0.005751, -0.023443, -0.027346, -0.047816, -0.097014, -0.105049, -0.107648, -0.139796, -0.186369, -0.173612, -0.203965, -0.229488, -0.258506, -0.256759, -0.274516, -0.333525, -0.343949, -0.341813, -0.355192, -0.429550, -0.413771, -0.422193, -0.461200, -0.505534, -0.488559, -0.517950, -0.551555, -0.576036, -0.571586, -0.585468, -0.655060, -0.667907, -0.650898, -0.670728, -0.768188, -0.713914, -0.749628, -0.764928, -0.826158, -0.808827, -0.829669, -0.880915, -0.905470, -0.873252, -0.908016, -0.970794, -0.981674, -0.973186, -0.980475, -1.101558, -1.025027, -1.061046, -1.095342, },
{ 1.000000,  0.977969,  0.956691,  0.934908,  0.911947,  0.890375,  0.870999,  0.849374,  0.823931,  0.801397,  0.785683,  0.763107,  0.729329,  0.719317,  0.697929,  0.672893,  0.650350,  0.631580,  0.611166,  0.581666,  0.561598,  0.546830,  0.526459,  0.489183,  0.475063,  0.462389,  0.435097,  0.401252,  0.395791,  0.370541,  0.343580,  0.321425,  0.309149,  0.290835,  0.248684,  0.232529,  0.222439,  0.205057,  0.155356,  0.151241,  0.138262,  0.106632,  0.069109,  0.074761,  0.043987,  0.014596, -0.006758, -0.013591, -0.030845, -0.084109, -0.099611, -0.097187, -0.118033, -0.188551, -0.162643, -0.191903, -0.213422, -0.260120, -0.255803, -0.276301, -0.316895, -0.341794, -0.330957, -0.358705, -0.412199, -0.425813, -0.421787, -0.438822, -0.532469, -0.482214, -0.519209, -0.546213, -0.575421, -0.584064, -0.600202, -0.652282, -0.667478, -0.655049, -0.677784, -0.738852, -0.764340, -0.735415, -0.764115, -0.872838, -0.815450, -0.833830, -0.873522, -0.899775, -0.906857, -0.925110, -0.978577, -0.994660, -0.980474, -1.000616, -1.090397, -1.081143, -1.064987, -1.108901, -1.174154, -1.136897, },
{ 1.000000,  0.978116,  0.955838,  0.933745,  0.912791,  0.891431,  0.866444,  0.845036,  0.825233,  0.804355,  0.775716,  0.758512,  0.738524,  0.714067,  0.686115,  0.674098,  0.649588,  0.623989,  0.601169,  0.587110,  0.564514,  0.531536,  0.511236,  0.499170,  0.479058,  0.434782,  0.433892,  0.409104,  0.387437,  0.352149,  0.344420,  0.323236,  0.289659,  0.267814,  0.261154,  0.238342,  0.198701,  0.179298,  0.173116,  0.153462,  0.090032,  0.111299,  0.079864,  0.054295,  0.027361,  0.012485, -0.001427, -0.046161, -0.066805, -0.062886, -0.086539, -0.135059, -0.155994, -0.147800, -0.171772, -0.253195, -0.218719, -0.246831, -0.277566, -0.301089, -0.312943, -0.332529, -0.377160, -0.393880, -0.391989, -0.411739, -0.480416, -0.481991, -0.476468, -0.513073, -0.575725, -0.547031, -0.573961, -0.612559, -0.635493, -0.634353, -0.655724, -0.717147, -0.728471, -0.722921, -0.738558, -0.816391, -0.798788, -0.813198, -0.842783, -0.908493, -0.868263, -0.908303, -0.944046, -0.970285, -0.954365, -0.983321, -1.052469, -1.065268, -1.050736, -1.058168, -1.167778, -1.114970, -1.140158, -1.167993, },
{ 1.000000,  0.976673,  0.954326,  0.931665,  0.907212,  0.883871,  0.863396,  0.840895,  0.813351,  0.791369,  0.772185,  0.750331,  0.714399,  0.705027,  0.679091,  0.655087,  0.629867,  0.609938,  0.589583,  0.557865,  0.534804,  0.524223,  0.498668,  0.464349,  0.441817,  0.433627,  0.409904,  0.357345,  0.363632,  0.335262,  0.308217,  0.285354,  0.267253,  0.245054,  0.210093,  0.188234,  0.182081,  0.158933,  0.109526,  0.095783,  0.091610,  0.061524,  0.008596,  0.019631, -0.006187, -0.040130, -0.061875, -0.071708, -0.094176, -0.141764, -0.158637, -0.164321, -0.183419, -0.241757, -0.240083, -0.255932, -0.286293, -0.337830, -0.320119, -0.353062, -0.386808, -0.411840, -0.410402, -0.435149, -0.492339, -0.511345, -0.504725, -0.519333, -0.604526, -0.575983, -0.599018, -0.628659, -0.683914, -0.666418, -0.693443, -0.736347, -0.761857, -0.750860, -0.773971, -0.841309, -0.855041, -0.843472, -0.863386, -0.971448, -0.905562, -0.951393, -0.975050, -1.018018, -1.011832, -1.034321, -1.092930, -1.114745, -1.087143, -1.120052, -1.187194, -1.209636, -1.181638, -1.200805, -1.335603, -1.244878, },
{ 1.000000,  0.976430,  0.952281,  0.928664,  0.905295,  0.881749,  0.855939,  0.832471,  0.812136,  0.788101,  0.758293,  0.736426,  0.718026,  0.693070,  0.657861,  0.646716,  0.621700,  0.594380,  0.570134,  0.551636,  0.527822,  0.494840,  0.472688,  0.457683,  0.434641,  0.394742,  0.380864,  0.364335,  0.334415,  0.298055,  0.293531,  0.264589,  0.236394,  0.208810,  0.201387,  0.175702,  0.131171,  0.112078,  0.102677,  0.085793,  0.024885,  0.029807,  0.008992, -0.020232, -0.065873, -0.062189, -0.088775, -0.125846, -0.148858, -0.154231, -0.175231, -0.230627, -0.246842, -0.245722, -0.270984, -0.349340, -0.315521, -0.352580, -0.375966, -0.419166, -0.416593, -0.442870, -0.487310, -0.514347, -0.499759, -0.534521, -0.587734, -0.607365, -0.601293, -0.619533, -0.723542, -0.664580, -0.708883, -0.739677, -0.766646, -0.774975, -0.796910, -0.850013, -0.866639, -0.855251, -0.884995, -0.956262, -0.967271, -0.948167, -0.983460, -1.084563, -1.028233, -1.053203, -1.102403, -1.125953, -1.121264, -1.147651, -1.213497, -1.228451, -1.219129, -1.235299, -1.323645, -1.310291, -1.306426, -1.351429, },
{ 1.000000,  0.974895,  0.951536,  0.926453,  0.901963,  0.876323,  0.855018,  0.830408,  0.801393,  0.777940,  0.756733,  0.734067,  0.699478,  0.682714,  0.660003,  0.633548,  0.601208,  0.587118,  0.561289,  0.532372,  0.507213,  0.489703,  0.467652,  0.428423,  0.407217,  0.395335,  0.370233,  0.318952,  0.322905,  0.292063,  0.269857,  0.229038,  0.222734,  0.196527,  0.159102,  0.134650,  0.132389,  0.102007,  0.057879,  0.037199,  0.030156,  0.010383, -0.063305, -0.039448, -0.073040, -0.103860, -0.130705, -0.146143, -0.170790, -0.211654, -0.231143, -0.233082, -0.261171, -0.312704, -0.338889, -0.328355, -0.355166, -0.443591, -0.409603, -0.432331, -0.474729, -0.500621, -0.508309, -0.530787, -0.584381, -0.603057, -0.602040, -0.625956, -0.692826, -0.695537, -0.694006, -0.735228, -0.796637, -0.769864, -0.809565, -0.839914, -0.876040, -0.866561, -0.887875, -0.965916, -0.973854, -0.966266, -0.980636, -1.079594, -1.050165, -1.058862, -1.107564, -1.164823, -1.134989, -1.172461, -1.213782, -1.242358, -1.231026, -1.247720, -1.337867, -1.349039, -1.321959, -1.346698, -1.473686, -1.394649, },
{ 1.000000,  0.974773,  0.949706,  0.922909,  0.899390,  0.874141,  0.846627,  0.820841,  0.800704,  0.774098,  0.743784,  0.719790,  0.698352,  0.675186,  0.633519,  0.625157,  0.596996,  0.569152,  0.541336,  0.521205,  0.495745,  0.462146,  0.439651,  0.424307,  0.399021,  0.359627,  0.333335,  0.326126,  0.298139,  0.240554,  0.246770,  0.222052,  0.188268,  0.161239,  0.142895,  0.120061,  0.077892,  0.056882,  0.046078,  0.022538, -0.032800, -0.042401, -0.050665, -0.087208, -0.134354, -0.129350, -0.161705, -0.196180, -0.222144, -0.230003, -0.250585, -0.310127, -0.325662, -0.331529, -0.350468, -0.421531, -0.417025, -0.428962, -0.470421, -0.520431, -0.501561, -0.542178, -0.578813, -0.603682, -0.605327, -0.625304, -0.697838, -0.712839, -0.701838, -0.727006, -0.824635, -0.777682, -0.815684, -0.840089, -0.902241, -0.887965, -0.913110, -0.965232, -0.995103, -0.973408, -1.008097, -1.078584, -1.090582, -1.080505, -1.099799, -1.226117, -1.149061, -1.196736, -1.229149, -1.265408, -1.270556, -1.290127, -1.356918, -1.371913, -1.350742, -1.378456, -1.457402, -1.485761, -1.443411, -1.478905, },
{ 1.000000,  0.972764,  0.948096,  0.922077,  0.895038,  0.868376,  0.843586,  0.817603,  0.788208,  0.762438,  0.740690,  0.714691,  0.678732,  0.657160,  0.637275,  0.607060,  0.572696,  0.558378,  0.529744,  0.499271,  0.472718,  0.453699,  0.429504,  0.388977,  0.366153,  0.349351,  0.326009,  0.278361,  0.267515,  0.246531,  0.213122,  0.171564,  0.171220,  0.137794,  0.103181,  0.075316,  0.066901,  0.038535, -0.010843, -0.032937, -0.038289, -0.061726, -0.131561, -0.116266, -0.148495, -0.174053, -0.224905, -0.224125, -0.250259, -0.296753, -0.322614, -0.321712, -0.350609, -0.406992, -0.427688, -0.427705, -0.450321, -0.544618, -0.499193, -0.541398, -0.573399, -0.608008, -0.621638, -0.636740, -0.698527, -0.721705, -0.707677, -0.737501, -0.804310, -0.827775, -0.808580, -0.838370, -0.953946, -0.894726, -0.930914, -0.969703, -0.998777, -1.008673, -1.032896, -1.091816, -1.109976, -1.101406, -1.125649, -1.219292, -1.214504, -1.201715, -1.250262, -1.333399, -1.285638, -1.321012, -1.370462, -1.398352, -1.391220, -1.417470, -1.499035, -1.508824, -1.496922, -1.515599, -1.619864, -1.588914, },
{ 1.000000,  0.973181,  0.945814,  0.917052,  0.892755,  0.864704,  0.836382,  0.808857,  0.785444,  0.757774,  0.724669,  0.698776,  0.676800,  0.652095,  0.609922,  0.596501,  0.568349,  0.540433,  0.503557,  0.487349,  0.460996,  0.425988,  0.397557,  0.382332,  0.355495,  0.311662,  0.288726,  0.273649,  0.249708,  0.186522,  0.196684,  0.161245,  0.131418,  0.098857,  0.079267,  0.057859,  0.011668, -0.014921, -0.016697, -0.049521, -0.099451, -0.124403, -0.123174, -0.152323, -0.234824, -0.207245, -0.245077, -0.279015, -0.305949, -0.323519, -0.350756, -0.398003, -0.422697, -0.421585, -0.450191, -0.520285, -0.531273, -0.528195, -0.568301, -0.642405, -0.614069, -0.647226, -0.690952, -0.716377, -0.722502, -0.749658, -0.814765, -0.831597, -0.832573, -0.854296, -0.935251, -0.923187, -0.940949, -0.979421, -1.049434, -1.014175, -1.057470, -1.100286, -1.130362, -1.120849, -1.152152, -1.228596, -1.248580, -1.233326, -1.249582, -1.365970, -1.317441, -1.346461, -1.382654, -1.455901, -1.424040, -1.458447, -1.513099, -1.543735, -1.522557, -1.552125, -1.640172, -1.652579, -1.632631, -1.656855, },
{ 1.000000,  0.971120,  0.944460,  0.915846,  0.887557,  0.858243,  0.832108,  0.804205,  0.772398,  0.744302,  0.722250,  0.693089,  0.658340,  0.630477,  0.610555,  0.583221,  0.533924,  0.528310,  0.494419,  0.463747,  0.435813,  0.412000,  0.383192,  0.346864,  0.320023,  0.305172,  0.274594,  0.228057,  0.205983,  0.193605,  0.160756,  0.104273,  0.108316,  0.076411,  0.039945,  0.010951, -0.005281, -0.034059, -0.081526, -0.105457, -0.116348, -0.143530, -0.203157, -0.210592, -0.226212, -0.265799, -0.317492, -0.309195, -0.347896, -0.383678, -0.418137, -0.417240, -0.450167, -0.512841, -0.532683, -0.536848, -0.554563, -0.643652, -0.623482, -0.647909, -0.684855, -0.747843, -0.731374, -0.764808, -0.813579, -0.840233, -0.839475, -0.864771, -0.941109, -0.956005, -0.947428, -0.978376, -1.088714, -1.028798, -1.078377, -1.105498, -1.162685, -1.150730, -1.183883, -1.241575, -1.274191, -1.246514, -1.292140, -1.362260, -1.383564, -1.368577, -1.390548, -1.531962, -1.441314, -1.499795, -1.538067, -1.570661, -1.575201, -1.603026, -1.671239, -1.688828, -1.668154, -1.706122, -1.799483, -1.808362, },
{ 1.000000,  0.971059,  0.941744,  0.909116,  0.883483,  0.854169,  0.823055,  0.793670,  0.767400,  0.737483,  0.703013,  0.674769,  0.650308,  0.622193,  0.581649,  0.559225,  0.534951,  0.501191,  0.461433,  0.447631,  0.412582,  0.382268,  0.347973,  0.333233,  0.302447,  0.255372,  0.230901,  0.212625,  0.187564,  0.129589,  0.122188,  0.096858,  0.062047,  0.014073,  0.009632, -0.023238, -0.062903, -0.093312, -0.107004, -0.132830, -0.191565, -0.213623, -0.218492, -0.250260, -0.330024, -0.305080, -0.346886, -0.372614, -0.431070, -0.426997, -0.460658, -0.511753, -0.540892, -0.532498, -0.573377, -0.635073, -0.656752, -0.657558, -0.680362, -0.789964, -0.739073, -0.784924, -0.823988, -0.857626, -0.871185, -0.902007, -0.956423, -0.977286, -0.972029, -1.008428, -1.079947, -1.109281, -1.086356, -1.121371, -1.245275, -1.185253, -1.213995, -1.269698, -1.301293, -1.304190, -1.332595, -1.404380, -1.424208, -1.416950, -1.445965, -1.537265, -1.532839, -1.525661, -1.580513, -1.662267, -1.616134, -1.669465, -1.706752, -1.752948, -1.732020, -1.759975, -1.863689, -1.869019, -1.853689, -1.870729, },
{ 1.000000,  0.968994,  0.939282,  0.909658,  0.877998,  0.845383,  0.819178,  0.787424,  0.755448,  0.724524,  0.698533,  0.669129,  0.628984,  0.600745,  0.579202,  0.548418,  0.498503,  0.489057,  0.453670,  0.425134,  0.381921,  0.364968,  0.333774,  0.293012,  0.261758,  0.250843,  0.214525,  0.168271,  0.142409,  0.124220,  0.098820,  0.025840,  0.039322,  0.000860, -0.035857, -0.071835, -0.090043, -0.121895, -0.169161, -0.193511, -0.203394, -0.235397, -0.293284, -0.324198, -0.320932, -0.357219, -0.446336, -0.418162, -0.448753, -0.494489, -0.528406, -0.544363, -0.572217, -0.631071, -0.653738, -0.659829, -0.688722, -0.768392, -0.771176, -0.774221, -0.824174, -0.889508, -0.869424, -0.913433, -0.957305, -0.989703, -0.990881, -1.015832, -1.099201, -1.113838, -1.114447, -1.136265, -1.236576, -1.219050, -1.230479, -1.285326, -1.352648, -1.315917, -1.371098, -1.417362, -1.447120, -1.442007, -1.466979, -1.565308, -1.579544, -1.557030, -1.589364, -1.723976, -1.648357, -1.699217, -1.727715, -1.810907, -1.782794, -1.815151, -1.883525, -1.919531, -1.882676, -1.928787, -2.021722, -2.031520, },
{ 1.000000,  0.968674,  0.937448,  0.901930,  0.874751,  0.841879,  0.809714,  0.777017,  0.747624,  0.716360,  0.679629,  0.648963,  0.624309,  0.592182,  0.551587,  0.519444,  0.500548,  0.466813,  0.410065,  0.402571,  0.371219,  0.334003,  0.300388,  0.275137,  0.243744,  0.200328,  0.171205,  0.153157,  0.121126,  0.062209,  0.044816,  0.028896, -0.013690, -0.064550, -0.067493, -0.105837, -0.146395, -0.178844, -0.194635, -0.223542, -0.284265, -0.308085, -0.321398, -0.348310, -0.420758, -0.421957, -0.445189, -0.490445, -0.549497, -0.533833, -0.579828, -0.625748, -0.659589, -0.660828, -0.697412, -0.767818, -0.791503, -0.788201, -0.816835, -0.919949, -0.882501, -0.925373, -0.955631, -1.026497, -1.014082, -1.047458, -1.110331, -1.141540, -1.130118, -1.168232, -1.245928, -1.267234, -1.259486, -1.287006, -1.421281, -1.343416, -1.400283, -1.440498, -1.484984, -1.495489, -1.514287, -1.597675, -1.623454, -1.596171, -1.635097, -1.724788, -1.750745, -1.717642, -1.756488, -1.916016, -1.823710, -1.871243, -1.920045, -1.956388, -1.962279, -1.994215, -2.071351, -2.091169, -2.073682, -2.105068, },
{ 1.000000,  0.966069,  0.933410,  0.901608,  0.867302,  0.830547,  0.802868,  0.768684,  0.733450,  0.699746,  0.671209,  0.637898,  0.596344,  0.565991,  0.539185,  0.507193,  0.459128,  0.437632,  0.406486,  0.370742,  0.323190,  0.311740,  0.271431,  0.233428,  0.198329,  0.180276,  0.143429,  0.091476,  0.062745,  0.045541,  0.017627, -0.055168, -0.052399, -0.088435, -0.124048, -0.179474, -0.187013, -0.219411, -0.270039, -0.305152, -0.313112, -0.347434, -0.413310, -0.437208, -0.447322, -0.475077, -0.575933, -0.538650, -0.587782, -0.625672, -0.668954, -0.687354, -0.712488, -0.778053, -0.809547, -0.799317, -0.843347, -0.914067, -0.942666, -0.928611, -0.966984, -1.090344, -1.034157, -1.084877, -1.128702, -1.161807, -1.178491, -1.213708, -1.278037, -1.306241, -1.295344, -1.332704, -1.432129, -1.438591, -1.426028, -1.481639, -1.583855, -1.530769, -1.575971, -1.633066, -1.664822, -1.665228, -1.699788, -1.788806, -1.806020, -1.799773, -1.827220, -1.939338, -1.912736, -1.932840, -1.983852, -2.080027, -2.019450, -2.078752, -2.134012, -2.172138, -2.150124, -2.192325, -2.294806, -2.316573, },
{ 1.000000,  0.965363,  0.931294,  0.892869,  0.861883,  0.826956,  0.791767,  0.752424,  0.723894,  0.688160,  0.649993,  0.614344,  0.587339,  0.551774,  0.506756,  0.474545,  0.449107,  0.414703,  0.354557,  0.347819,  0.305559,  0.270282,  0.228543,  0.204496,  0.169451,  0.121132,  0.086953,  0.072963,  0.033542, -0.020228, -0.053534, -0.065736, -0.100025, -0.186750, -0.166543, -0.215301, -0.255736, -0.290301, -0.314708, -0.352014, -0.403402, -0.435027, -0.443099, -0.483793, -0.554530, -0.576707, -0.581189, -0.626672, -0.712877, -0.687358, -0.730430, -0.780343, -0.816625, -0.829530, -0.866077, -0.934656, -0.961129, -0.966885, -1.000729, -1.089042, -1.086318, -1.101786, -1.155808, -1.230429, -1.202553, -1.257033, -1.303590, -1.348390, -1.334770, -1.380361, -1.468183, -1.489897, -1.486118, -1.507067, -1.636392, -1.594344, -1.624495, -1.673267, -1.760822, -1.726399, -1.770993, -1.836159, -1.869374, -1.858618, -1.892682, -1.997837, -2.011546, -1.992097, -2.033032, -2.188799, -2.091942, -2.159348, -2.193233, -2.269885, -2.245515, -2.288291, -2.365847, -2.406373, -2.360052, -2.422514, },
{ 1.000000,  0.962995,  0.926223,  0.891606,  0.855563,  0.811323,  0.783772,  0.744579,  0.707223,  0.669948,  0.636829,  0.599978,  0.557720,  0.522600,  0.494759,  0.456217,  0.406804,  0.374414,  0.350608,  0.309390,  0.248007,  0.239799,  0.201419,  0.156011,  0.119285,  0.095147,  0.056488,  0.002974, -0.029685, -0.051521, -0.085907, -0.151570, -0.168862, -0.193532, -0.241931, -0.303156, -0.302098, -0.351875, -0.390650, -0.437653, -0.442339, -0.483780, -0.555150, -0.582054, -0.596441, -0.625622, -0.717593, -0.710798, -0.740307, -0.787278, -0.857588, -0.847997, -0.892070, -0.946217, -0.985253, -0.992610, -1.025789, -1.111922, -1.135010, -1.129718, -1.171879, -1.292365, -1.237219, -1.295315, -1.326960, -1.409257, -1.391143, -1.435921, -1.506571, -1.542367, -1.518422, -1.576171, -1.662363, -1.686485, -1.677205, -1.705857, -1.866006, -1.776751, -1.840294, -1.891980, -1.935651, -1.945065, -1.986438, -2.059035, -2.083034, -2.066905, -2.116554, -2.216816, -2.250090, -2.209403, -2.259665, -2.431544, -2.333203, -2.372480, -2.447444, -2.487909, -2.482600, -2.520377, -2.617667, -2.640164, },
{ 1.000000,  0.962048,  0.924047,  0.883310,  0.846277,  0.810490,  0.770265,  0.726885,  0.696737,  0.655566,  0.616341,  0.575412,  0.545113,  0.506586,  0.455447,  0.421389,  0.392105,  0.356096,  0.295174,  0.275076,  0.241063,  0.194867,  0.144302,  0.127168,  0.082999,  0.038370, -0.001811, -0.024098, -0.061696, -0.127638, -0.158883, -0.172873, -0.213205, -0.300654, -0.286297, -0.337440, -0.372252, -0.438534, -0.445972, -0.487345, -0.546658, -0.586428, -0.584965, -0.636705, -0.705557, -0.734291, -0.748141, -0.778730, -0.896185, -0.851326, -0.906749, -0.956343, -1.004701, -1.018891, -1.062086, -1.128659, -1.155957, -1.158002, -1.201820, -1.286910, -1.324350, -1.306010, -1.356898, -1.490263, -1.429138, -1.471086, -1.533831, -1.579254, -1.590828, -1.627319, -1.710524, -1.736677, -1.735419, -1.774343, -1.888233, -1.881113, -1.877168, -1.947470, -2.040116, -1.997091, -2.059979, -2.116926, -2.159839, -2.149898, -2.183968, -2.301150, -2.315776, -2.308057, -2.335734, -2.479404, -2.442288, -2.453844, -2.528636, -2.620686, -2.558678, -2.635509, -2.696300, -2.734371, -2.718158, -2.753666, },
{ 1.000000,  0.958810,  0.918493,  0.880019,  0.839925,  0.792120,  0.759847,  0.717756,  0.677499,  0.630446,  0.598185,  0.557183,  0.510999,  0.469040,  0.441093,  0.397441,  0.344578,  0.308496,  0.279098,  0.239670,  0.165110,  0.161198,  0.112052,  0.068923,  0.023783, -0.006363, -0.047182, -0.104343, -0.139749, -0.158602, -0.202281, -0.267373, -0.308137, -0.315668, -0.363320, -0.462121, -0.444109, -0.485556, -0.538568, -0.584374, -0.608983, -0.650144, -0.714119, -0.749288, -0.762268, -0.805669, -0.898138, -0.909726, -0.919921, -0.981806, -1.058253, -1.042894, -1.098381, -1.153821, -1.197304, -1.206639, -1.244121, -1.335671, -1.362266, -1.369520, -1.403491, -1.514176, -1.500840, -1.527025, -1.590950, -1.676809, -1.637331, -1.703861, -1.766803, -1.810801, -1.800054, -1.851179, -1.952974, -1.980273, -1.962491, -2.001422, -2.156297, -2.084379, -2.143965, -2.182174, -2.283450, -2.252765, -2.298752, -2.386831, -2.427487, -2.398166, -2.453400, -2.562758, -2.586048, -2.565769, -2.602652, -2.797307, -2.670568, -2.749393, -2.803623, -2.864202, -2.868396, -2.895841, -3.011215, -3.040933, },
{ 1.000000,  0.957358,  0.914348,  0.868946,  0.826008,  0.787275,  0.743627,  0.688021,  0.657990,  0.612963,  0.567486,  0.523281,  0.485185,  0.441541,  0.390174,  0.348903,  0.316109,  0.272321,  0.208205,  0.176062,  0.146618,  0.093643,  0.030192,  0.017495, -0.032100, -0.084039, -0.128649, -0.155490, -0.200242, -0.268644, -0.303415, -0.327843, -0.368874, -0.451457, -0.463403, -0.500977, -0.552176, -0.627715, -0.620007, -0.681395, -0.734500, -0.781345, -0.792651, -0.844926, -0.925460, -0.959780, -0.968651, -1.004454, -1.124807, -1.096789, -1.146915, -1.194781, -1.278737, -1.272886, -1.316986, -1.391703, -1.439262, -1.433859, -1.483634, -1.582784, -1.608748, -1.610491, -1.647190, -1.805221, -1.726721, -1.797741, -1.849317, -1.910464, -1.925506, -1.959616, -2.055744, -2.093614, -2.065031, -2.129206, -2.231163, -2.265602, -2.232343, -2.287710, -2.473548, -2.374943, -2.445216, -2.504636, -2.549852, -2.563157, -2.613117, -2.704027, -2.738599, -2.712531, -2.766673, -2.910518, -2.911313, -2.882877, -2.966551, -3.110569, -3.017354, -3.084268, -3.162633, -3.206483, -3.196596, -3.244632, },
{ 1.000000,  0.953558,  0.907332,  0.863072,  0.817727,  0.766202,  0.724803,  0.680518,  0.632501,  0.578188,  0.545467,  0.495358,  0.445756,  0.398460,  0.363535,  0.315494,  0.254992,  0.211386,  0.180498,  0.136614,  0.057990,  0.041972, -0.005875, -0.055167, -0.120063, -0.139916, -0.190135, -0.248534, -0.296730, -0.317711, -0.368251, -0.442599, -0.480666, -0.501539, -0.547787, -0.656762, -0.633235, -0.697366, -0.744657, -0.806710, -0.827837, -0.876201, -0.950499, -0.994625, -0.996188, -1.053617, -1.136845, -1.179668, -1.179326, -1.228105, -1.372486, -1.314154, -1.386290, -1.442383, -1.488879, -1.513789, -1.566360, -1.641150, -1.681123, -1.679597, -1.738274, -1.847396, -1.870326, -1.862298, -1.931259, -2.061996, -2.001613, -2.065966, -2.136189, -2.187300, -2.193236, -2.243613, -2.345437, -2.378000, -2.375028, -2.421320, -2.555160, -2.536737, -2.551206, -2.630925, -2.741556, -2.682678, -2.763518, -2.828259, -2.889570, -2.855381, -2.923693, -3.051223, -3.076496, -3.059556, -3.088323, -3.283175, -3.204591, -3.246226, -3.313708, -3.439883, -3.377194, -3.441022, -3.532261, -3.578600, },
{ 1.000000,  0.951004,  0.901511,  0.849224,  0.800410,  0.754609,  0.704776,  0.642463,  0.607703,  0.554458,  0.504496,  0.448721,  0.408892,  0.357818,  0.300106,  0.248885,  0.217275,  0.161259,  0.097270,  0.049706,  0.017943, -0.031430, -0.125976, -0.126200, -0.188713, -0.242861, -0.295596, -0.331069, -0.382928, -0.451316, -0.496245, -0.519784, -0.576775, -0.660895, -0.699279, -0.715630, -0.780291, -0.887076, -0.866823, -0.924134, -0.993978, -1.044565, -1.064486, -1.120488, -1.206340, -1.247755, -1.265341, -1.312024, -1.421481, -1.429806, -1.456101, -1.531386, -1.629385, -1.603194, -1.679958, -1.733828, -1.802645, -1.789823, -1.852872, -1.964957, -1.998220, -2.005017, -2.044788, -2.195549, -2.163860, -2.202350, -2.270483, -2.378485, -2.346085, -2.409642, -2.490028, -2.546130, -2.541364, -2.590948, -2.721479, -2.747868, -2.726085, -2.788395, -2.978655, -2.872483, -2.957413, -3.005064, -3.124088, -3.084422, -3.148390, -3.252629, -3.301281, -3.252015, -3.340341, -3.467399, -3.498736, -3.469696, -3.513378, -3.758287, -3.606286, -3.699431, -3.773999, -3.835753, -3.837074, -3.897404, },
{ 1.000000,  0.945467,  0.891328,  0.839689,  0.785134,  0.726062,  0.671681,  0.625691,  0.569193,  0.497942,  0.463724,  0.408383,  0.347714,  0.292368,  0.247744,  0.193041,  0.125275,  0.073980,  0.033261, -0.021622, -0.100347, -0.138722, -0.177850, -0.244671, -0.322894, -0.339000, -0.406330, -0.463952, -0.527095, -0.551744, -0.610262, -0.702561, -0.744539, -0.772091, -0.822235, -0.937240, -0.941075, -0.985363, -1.058261, -1.141555, -1.144866, -1.213711, -1.282494, -1.342293, -1.357230, -1.414614, -1.525940, -1.563818, -1.565667, -1.627107, -1.782580, -1.726945, -1.807490, -1.859086, -1.965005, -1.957134, -2.018565, -2.112657, -2.169427, -2.146932, -2.230158, -2.339221, -2.377444, -2.381278, -2.426140, -2.624533, -2.525205, -2.611751, -2.687665, -2.759985, -2.766549, -2.832196, -2.933686, -2.969976, -2.958202, -3.026968, -3.164788, -3.213218, -3.168932, -3.254153, -3.461566, -3.340735, -3.407633, -3.503961, -3.573628, -3.574762, -3.629184, -3.758950, -3.794427, -3.780250, -3.839424, -4.016894, -3.990597, -3.974947, -4.086836, -4.231581, -4.144785, -4.244482, -4.325770, -4.391246, },
{ 1.000000,  0.940556,  0.881022,  0.817172,  0.757792,  0.701552,  0.642690,  0.570538,  0.519837,  0.463378,  0.398221,  0.329015,  0.287104,  0.219240,  0.154532,  0.093442,  0.047668, -0.013376, -0.097428, -0.150925, -0.187658, -0.250758, -0.357947, -0.368061, -0.439136, -0.499657, -0.584642, -0.611719, -0.675083, -0.755895, -0.820075, -0.838745, -0.912242, -1.006970, -1.055942, -1.082267, -1.142907, -1.291961, -1.257085, -1.339394, -1.408295, -1.478636, -1.511207, -1.575304, -1.671514, -1.720425, -1.729972, -1.802250, -1.917202, -1.974463, -1.964451, -2.046462, -2.222218, -2.156623, -2.223602, -2.311220, -2.384431, -2.405811, -2.469957, -2.576477, -2.627817, -2.633248, -2.703120, -2.861494, -2.861538, -2.864260, -2.967816, -3.096887, -3.045670, -3.139419, -3.224086, -3.294715, -3.289427, -3.351158, -3.504607, -3.541194, -3.536535, -3.587643, -3.779027, -3.735552, -3.771532, -3.872709, -4.010829, -3.928847, -4.038987, -4.137610, -4.205907, -4.171907, -4.257257, -4.420922, -4.456824, -4.410611, -4.474854, -4.735986, -4.598247, -4.693399, -4.752132, -4.910505, -4.844912, -4.919917, },
{ 1.000000,  0.931449,  0.863160,  0.798735,  0.730263,  0.656710,  0.589667,  0.529665,  0.461865,  0.370809,  0.329803,  0.255707,  0.184767,  0.112424,  0.054185, -0.011875, -0.097965, -0.162823, -0.205605, -0.279245, -0.372290, -0.436447, -0.472740, -0.549899, -0.678793, -0.679497, -0.757883, -0.836480, -0.909704, -0.956539, -1.026319, -1.121924, -1.184699, -1.219709, -1.292527, -1.419494, -1.453669, -1.483011, -1.580234, -1.700740, -1.684802, -1.773850, -1.861259, -1.937299, -1.960166, -2.034890, -2.162635, -2.212475, -2.233241, -2.297670, -2.458271, -2.452621, -2.507585, -2.593314, -2.728539, -2.687047, -2.795739, -2.884231, -2.963682, -2.962943, -3.052264, -3.195042, -3.244432, -3.234937, -3.293433, -3.522844, -3.442646, -3.526960, -3.606075, -3.749196, -3.716759, -3.790824, -3.921157, -4.003020, -3.967064, -4.057348, -4.228228, -4.264223, -4.247270, -4.309430, -4.593197, -4.431634, -4.549753, -4.636573, -4.739228, -4.744584, -4.805673, -4.968570, -5.023317, -4.957407, -5.069846, -5.243772, -5.291809, -5.219614, -5.323960, -5.639623, -5.452624, -5.568340, -5.666691, -5.746196, },
{ 1.000000,  0.920127,  0.839639,  0.756562,  0.676171,  0.602190,  0.520410,  0.427005,  0.353154,  0.284261,  0.195341,  0.096056,  0.045941, -0.041801, -0.129894, -0.212917, -0.276793, -0.358846, -0.464775, -0.538986, -0.597049, -0.675877, -0.801865, -0.846140, -0.917117, -1.010397, -1.126960, -1.147033, -1.247597, -1.342255, -1.430065, -1.468247, -1.558577, -1.687109, -1.757885, -1.784415, -1.863334, -2.048664, -2.034010, -2.122510, -2.214617, -2.342359, -2.348922, -2.442619, -2.559495, -2.648554, -2.655967, -2.756874, -2.905496, -2.966389, -2.979299, -3.067473, -3.299713, -3.210785, -3.333237, -3.421631, -3.537669, -3.554972, -3.648567, -3.791889, -3.863901, -3.843213, -3.952820, -4.117060, -4.187420, -4.160958, -4.264027, -4.547734, -4.404700, -4.540158, -4.644337, -4.732159, -4.757934, -4.851825, -4.994410, -5.064273, -5.045563, -5.158170, -5.373748, -5.395430, -5.361341, -5.505270, -5.745528, -5.597130, -5.727836, -5.856888, -5.959024, -5.946130, -6.036674, -6.233750, -6.289877, -6.264656, -6.348249, -6.615973, -6.553001, -6.568574, -6.720821, -6.924884, -6.795048, -6.949816, },
{ 1.000000,  0.900446,  0.799909,  0.705895,  0.605343,  0.498118,  0.400709,  0.311969,  0.214944,  0.085571,  0.013327, -0.086494, -0.190425, -0.308245, -0.376550, -0.481542, -0.595825, -0.698321, -0.767541, -0.872662, -1.007934, -1.095770, -1.158832, -1.266328, -1.444885, -1.454570, -1.574519, -1.677704, -1.804616, -1.856340, -1.964470, -2.096554, -2.197978, -2.229371, -2.355085, -2.508590, -2.597193, -2.632351, -2.743058, -2.977994, -2.922060, -3.060985, -3.175261, -3.290913, -3.336897, -3.442044, -3.596098, -3.685496, -3.713898, -3.835100, -4.037533, -4.090744, -4.101584, -4.255080, -4.488551, -4.394435, -4.528085, -4.678565, -4.793126, -4.802930, -4.917768, -5.113553, -5.194590, -5.207853, -5.299659, -5.562966, -5.539815, -5.586707, -5.748589, -5.963711, -5.874506, -6.041656, -6.155509, -6.304045, -6.245323, -6.384305, -6.626183, -6.689500, -6.673942, -6.761818, -7.119715, -7.003521, -7.095423, -7.234223, -7.450608, -7.356882, -7.493069, -7.665359, -7.795407, -7.750561, -7.868194, -8.139236, -8.185545, -8.120833, -8.257266, -8.672244, -8.419606, -8.593665, -8.709521, -8.943172, },
{ 1.000000,  0.844376,  0.687721,  0.526130,  0.369474,  0.226285,  0.063891, -0.112534, -0.261255, -0.398150, -0.560121, -0.769335, -0.859922, -1.032786, -1.203281, -1.368738, -1.496528, -1.654503, -1.842409, -1.989944, -2.106447, -2.275402, -2.508491, -2.634248, -2.725894, -2.922240, -3.176860, -3.185253, -3.360615, -3.568904, -3.738302, -3.829940, -3.988854, -4.230851, -4.366011, -4.451266, -4.612257, -4.913722, -4.956705, -5.061286, -5.281950, -5.524906, -5.515982, -5.724178, -5.915007, -6.105360, -6.137248, -6.319448, -6.633370, -6.727023, -6.772645, -6.933032, -7.347832, -7.272684, -7.421957, -7.652492, -7.879591, -7.846056, -8.052289, -8.288357, -8.471452, -8.471918, -8.660557, -9.024405, -9.091188, -9.075615, -9.276513, -9.768373, -9.542015, -9.790433, -9.989677, -10.278806, -10.212551, -10.394259, -10.694992, -10.835283, -10.764975, -11.016451, -11.390694, -11.448213, -11.440959, -11.629447, -12.176720, -11.848177, -12.122438, -12.376518, -12.603054, -12.568277, -12.740337, -13.066301, -13.163563, -13.131554, -13.336156, -13.840040, -13.861391, -13.750139, -14.077009, -14.581624, -14.172281, -14.415430, },
};
