/* This is the mu "correction" table, indexed by rho from -1.0 to 0.990
 * by 0.010, and sigma from 0 to 0.990 (fraction of mu) by 0.010
 * (Far more precision than really required...)  This is the table
 * for the normal distribution.  You could actually just
 * use this one for all of them (they're all quite close),
 * but I guess I'll make separate tables for each.
 */
/* To determine correction:
 *	index = rint((rho+1)*100)
 * We use linear interpolation between entries...
 */
#define MU_RHO_STEP 100
#define MU_RHO_DOMAIN 200
#define MU_SIGMA_STEP 100
#define MU_SIGMA_DOMAIN 99

double rhomucorrect[MU_RHO_DOMAIN][MU_SIGMA_DOMAIN+1] = {
{ 1.000000,  0.999479,  0.998748,  0.998876,  0.998113,  0.997611,  0.996877,  0.997195,  0.996398,  0.995259,  0.994824,  0.994966,  0.995179,  0.992364,  0.993895,  0.993219,  0.992676,  0.990622,  0.992056,  0.991189,  0.990213,  0.988797,  0.990515,  0.990172,  0.987096,  0.987612,  0.988273,  0.988667,  0.982969,  0.988076,  0.985570,  0.985943,  0.984066,  0.984743,  0.984721,  0.981806,  0.980619,  0.985481,  0.983169,  0.979079,  0.979369,  0.982279,  0.982265,  0.973633,  0.981755,  0.978627,  0.978539,  0.977560,  0.978051,  0.977267,  0.974119,  0.974164,  0.978164,  0.976727,  0.970289,  0.972146,  0.976775,  0.973787,  0.965912,  0.975141,  0.971345,  0.972058,  0.969744,  0.972260,  0.970688,  0.965645,  0.967126,  0.970236,  0.970285,  0.961881,  0.966457,  0.969732,  0.965458,  0.958370,  0.969300,  0.964250,  0.964377,  0.960555,  0.966474,  0.963756,  0.958106,  0.957726,  0.963738,  0.965550,  0.950194,  0.962953,  0.962353,  0.959998,  0.952313,  0.961205,  0.957415,  0.955867,  0.951229,  0.960564,  0.958608,  0.949851,  0.952499,  0.957294,  0.957567,  0.940045, },
{ 1.000000,  0.999558,  0.998934,  0.998761,  0.998020,  0.997807,  0.997224,  0.996587,  0.995899,  0.996344,  0.995575,  0.994236,  0.994158,  0.994463,  0.994340,  0.990627,  0.993662,  0.991930,  0.991714,  0.991050,  0.990961,  0.990071,  0.988603,  0.988462,  0.990190,  0.989057,  0.986130,  0.986326,  0.987859,  0.987102,  0.982193,  0.987216,  0.984493,  0.985361,  0.983421,  0.984697,  0.983648,  0.981104,  0.981432,  0.982887,  0.982696,  0.977587,  0.979824,  0.981990,  0.979070,  0.974834,  0.981118,  0.977621,  0.978059,  0.974619,  0.979373,  0.977083,  0.972610,  0.973509,  0.975661,  0.977737,  0.967096,  0.974706,  0.974302,  0.973357,  0.967198,  0.973958,  0.971288,  0.969320,  0.967941,  0.972116,  0.971251,  0.964376,  0.967098,  0.970482,  0.969535,  0.957477,  0.971603,  0.964908,  0.967576,  0.961243,  0.966245,  0.964753,  0.960930,  0.958332,  0.968155,  0.963557,  0.957417,  0.959158,  0.962711,  0.964589,  0.947101,  0.965294,  0.958812,  0.959025,  0.955839,  0.958317,  0.957829,  0.951687,  0.953570,  0.960584,  0.957161,  0.949479,  0.951270,  0.958030, },
{ 1.000000,  0.999511,  0.998712,  0.998881,  0.998194,  0.997756,  0.996989,  0.997157,  0.996501,  0.995449,  0.995184,  0.995091,  0.994993,  0.993088,  0.993402,  0.993751,  0.992510,  0.990434,  0.993003,  0.990525,  0.991316,  0.989013,  0.990825,  0.989653,  0.987756,  0.987721,  0.988404,  0.988798,  0.983961,  0.987336,  0.986856,  0.985862,  0.982672,  0.986096,  0.984291,  0.983421,  0.982075,  0.984201,  0.983778,  0.979518,  0.980684,  0.982349,  0.982036,  0.974434,  0.982627,  0.978680,  0.980516,  0.975289,  0.979236,  0.977625,  0.975181,  0.974030,  0.978981,  0.976944,  0.972118,  0.973402,  0.975136,  0.976261,  0.965107,  0.976298,  0.972426,  0.972015,  0.970192,  0.971600,  0.969768,  0.966811,  0.968034,  0.971901,  0.970073,  0.965392,  0.964334,  0.969621,  0.969845,  0.955593,  0.969736,  0.965766,  0.966294,  0.962915,  0.966122,  0.964121,  0.959081,  0.960710,  0.964565,  0.963680,  0.955573,  0.958940,  0.964468,  0.958964,  0.951633,  0.964271,  0.955333,  0.959130,  0.953967,  0.960788,  0.959026,  0.950211,  0.952917,  0.957939,  0.959471,  0.943798, },
{ 1.000000,  0.999514,  0.999057,  0.998703,  0.997940,  0.997977,  0.997141,  0.996585,  0.996153,  0.996270,  0.995794,  0.994212,  0.994439,  0.994490,  0.994290,  0.991085,  0.993855,  0.991919,  0.992562,  0.990098,  0.991433,  0.990329,  0.989104,  0.988382,  0.990556,  0.989186,  0.986588,  0.987357,  0.987409,  0.987699,  0.982150,  0.987945,  0.985251,  0.985187,  0.983263,  0.984714,  0.983450,  0.981251,  0.981828,  0.983805,  0.983003,  0.979184,  0.979021,  0.981847,  0.980928,  0.972509,  0.981908,  0.978250,  0.978896,  0.976695,  0.977779,  0.977044,  0.973460,  0.974461,  0.976969,  0.976773,  0.969323,  0.973010,  0.976233,  0.972067,  0.967559,  0.975829,  0.970092,  0.970489,  0.969343,  0.972165,  0.972073,  0.965388,  0.967609,  0.969482,  0.971062,  0.960966,  0.967893,  0.968810,  0.964676,  0.959646,  0.970444,  0.963302,  0.962806,  0.961539,  0.966021,  0.965208,  0.957193,  0.960497,  0.964003,  0.964248,  0.949460,  0.965954,  0.959449,  0.961685,  0.952731,  0.960167,  0.957152,  0.955343,  0.952635,  0.961603,  0.958052,  0.949532,  0.953709,  0.957074, },
{ 1.000000,  0.999537,  0.998711,  0.998973,  0.998169,  0.997747,  0.997117,  0.996816,  0.996582,  0.995515,  0.995145,  0.995621,  0.994826,  0.993643,  0.993093,  0.993852,  0.993337,  0.989664,  0.993000,  0.991570,  0.991248,  0.990118,  0.990421,  0.989510,  0.988127,  0.988132,  0.989326,  0.988827,  0.984461,  0.986421,  0.987755,  0.985497,  0.982727,  0.986768,  0.983952,  0.984007,  0.983142,  0.984342,  0.983648,  0.979900,  0.980899,  0.982275,  0.982740,  0.976400,  0.980684,  0.980773,  0.978399,  0.974645,  0.981290,  0.977612,  0.976445,  0.974632,  0.979291,  0.976680,  0.972288,  0.973528,  0.976023,  0.976503,  0.966423,  0.976657,  0.972575,  0.973772,  0.967715,  0.973262,  0.971192,  0.968572,  0.967427,  0.972585,  0.970998,  0.964566,  0.967005,  0.969809,  0.970040,  0.956702,  0.971653,  0.965321,  0.965869,  0.963599,  0.964872,  0.965816,  0.960277,  0.958766,  0.967536,  0.964861,  0.956752,  0.958683,  0.964140,  0.963812,  0.946153,  0.965777,  0.958782,  0.959238,  0.956712,  0.958931,  0.957811,  0.953002,  0.954598,  0.959119,  0.959179,  0.946207, },
{ 1.000000,  0.999483,  0.999093,  0.998754,  0.997869,  0.998035,  0.997200,  0.996974,  0.996354,  0.996429,  0.995690,  0.994285,  0.994561,  0.994536,  0.994351,  0.991930,  0.993033,  0.992571,  0.992016,  0.989712,  0.992522,  0.990331,  0.989795,  0.988845,  0.990618,  0.989100,  0.986795,  0.986963,  0.987716,  0.988705,  0.983008,  0.987451,  0.986025,  0.985441,  0.982510,  0.985505,  0.984011,  0.982514,  0.981266,  0.984507,  0.983845,  0.978647,  0.980727,  0.981635,  0.982291,  0.973807,  0.982613,  0.978432,  0.978914,  0.976821,  0.978294,  0.978146,  0.973944,  0.973197,  0.980141,  0.976959,  0.971146,  0.972603,  0.976069,  0.976083,  0.964896,  0.976860,  0.971688,  0.971717,  0.970865,  0.972031,  0.970933,  0.966794,  0.967498,  0.972890,  0.970959,  0.962425,  0.965850,  0.970922,  0.967282,  0.958297,  0.970062,  0.964572,  0.965231,  0.963968,  0.967005,  0.964894,  0.958292,  0.961752,  0.964593,  0.964865,  0.954585,  0.961403,  0.963824,  0.959035,  0.951115,  0.965039,  0.958509,  0.957628,  0.954779,  0.961775,  0.958317,  0.951133,  0.952378,  0.957948, },
{ 1.000000,  0.999554,  0.998752,  0.998899,  0.998356,  0.997776,  0.996855,  0.997298,  0.996506,  0.995809,  0.995039,  0.995586,  0.995159,  0.993461,  0.993694,  0.993604,  0.993372,  0.990071,  0.993465,  0.991140,  0.991253,  0.989743,  0.990793,  0.989857,  0.988146,  0.987463,  0.989832,  0.988523,  0.985950,  0.986436,  0.987411,  0.987722,  0.981004,  0.987947,  0.984664,  0.984069,  0.983916,  0.984195,  0.982872,  0.980726,  0.981138,  0.983964,  0.982622,  0.977880,  0.979145,  0.981334,  0.979929,  0.973526,  0.981373,  0.977329,  0.978004,  0.976313,  0.978301,  0.977126,  0.973132,  0.974433,  0.976420,  0.976576,  0.969487,  0.973004,  0.975389,  0.971995,  0.967019,  0.975689,  0.970635,  0.970731,  0.967724,  0.974021,  0.970922,  0.964871,  0.967006,  0.969203,  0.972479,  0.958558,  0.969267,  0.968108,  0.966185,  0.959791,  0.968679,  0.965214,  0.961694,  0.961278,  0.966927,  0.965746,  0.956649,  0.961340,  0.964222,  0.963703,  0.949364,  0.967022,  0.957986,  0.961160,  0.954389,  0.961182,  0.958556,  0.953796,  0.951830,  0.963721,  0.958122,  0.949928, },
{ 1.000000,  0.999497,  0.999058,  0.998900,  0.997717,  0.998181,  0.997287,  0.996796,  0.996121,  0.996228,  0.995674,  0.994528,  0.994318,  0.994866,  0.994217,  0.992483,  0.992529,  0.993099,  0.992230,  0.989009,  0.992441,  0.990768,  0.990204,  0.989009,  0.990242,  0.989339,  0.987139,  0.987572,  0.988329,  0.988074,  0.983938,  0.986050,  0.987299,  0.985011,  0.981586,  0.986886,  0.982818,  0.984175,  0.980903,  0.984879,  0.983031,  0.979247,  0.980482,  0.981859,  0.982855,  0.974839,  0.980801,  0.980424,  0.978693,  0.974278,  0.979997,  0.977290,  0.975630,  0.974859,  0.978122,  0.977620,  0.970846,  0.973775,  0.976229,  0.975567,  0.964819,  0.977374,  0.971821,  0.973884,  0.966987,  0.973507,  0.971082,  0.967265,  0.966479,  0.973925,  0.971047,  0.963760,  0.966945,  0.968926,  0.970345,  0.955699,  0.971656,  0.966139,  0.964898,  0.962962,  0.965737,  0.963142,  0.959408,  0.961301,  0.966954,  0.964328,  0.957300,  0.957806,  0.964025,  0.963408,  0.946641,  0.964751,  0.959636,  0.959207,  0.955776,  0.960976,  0.957980,  0.951592,  0.954141,  0.959582, },
{ 1.000000,  0.999538,  0.998852,  0.998743,  0.998501,  0.997751,  0.996769,  0.997531,  0.996359,  0.996116,  0.995255,  0.995692,  0.995255,  0.993482,  0.993630,  0.993961,  0.993755,  0.990472,  0.992622,  0.992457,  0.990993,  0.989081,  0.991547,  0.989647,  0.989010,  0.988072,  0.989717,  0.989235,  0.985509,  0.986578,  0.987825,  0.987720,  0.981193,  0.988078,  0.984995,  0.985754,  0.981497,  0.985009,  0.983421,  0.981399,  0.980684,  0.984893,  0.982763,  0.978338,  0.980579,  0.981027,  0.981610,  0.972441,  0.982716,  0.978865,  0.978502,  0.975637,  0.978473,  0.977036,  0.973661,  0.974745,  0.978495,  0.977429,  0.970781,  0.972140,  0.976315,  0.974677,  0.963246,  0.976591,  0.971975,  0.972491,  0.969455,  0.972299,  0.970814,  0.965891,  0.967745,  0.971937,  0.970979,  0.960421,  0.966495,  0.971223,  0.965453,  0.959463,  0.970659,  0.963791,  0.963561,  0.962616,  0.966989,  0.966665,  0.957808,  0.961584,  0.964309,  0.965783,  0.952345,  0.962422,  0.964033,  0.958110,  0.951669,  0.965966,  0.957681,  0.956089,  0.954984,  0.961687,  0.960531,  0.949152, },
{ 1.000000,  0.999490,  0.999097,  0.998897,  0.997739,  0.998168,  0.997321,  0.997224,  0.995958,  0.996379,  0.995603,  0.994794,  0.994270,  0.995240,  0.994274,  0.992306,  0.992774,  0.992904,  0.993006,  0.988863,  0.992900,  0.990375,  0.990309,  0.989227,  0.989953,  0.989344,  0.987144,  0.987249,  0.989547,  0.988308,  0.984951,  0.985412,  0.987432,  0.986836,  0.979738,  0.986770,  0.984665,  0.984395,  0.982258,  0.984035,  0.982459,  0.980059,  0.980684,  0.983271,  0.982717,  0.975077,  0.979506,  0.981525,  0.978384,  0.973914,  0.981074,  0.976997,  0.976879,  0.975656,  0.978457,  0.977395,  0.971956,  0.974305,  0.975955,  0.977025,  0.967553,  0.974736,  0.974845,  0.971706,  0.965674,  0.976420,  0.971199,  0.969529,  0.967173,  0.973893,  0.970623,  0.964065,  0.966968,  0.969978,  0.970738,  0.957126,  0.971653,  0.966335,  0.967444,  0.959394,  0.968010,  0.965369,  0.961305,  0.960309,  0.967825,  0.965469,  0.956173,  0.960932,  0.963786,  0.964644,  0.947077,  0.967344,  0.959184,  0.959431,  0.956006,  0.959570,  0.960154,  0.953048,  0.951496,  0.962937, },
{ 1.000000,  0.999557,  0.998873,  0.998717,  0.998472,  0.998038,  0.996317,  0.997377,  0.996386,  0.996233,  0.995370,  0.995396,  0.994732,  0.993706,  0.993453,  0.994058,  0.993777,  0.990653,  0.991811,  0.992369,  0.991209,  0.988494,  0.991585,  0.989606,  0.989289,  0.988225,  0.989967,  0.988607,  0.985749,  0.986792,  0.987285,  0.987686,  0.982701,  0.986171,  0.985509,  0.984786,  0.980104,  0.986479,  0.983021,  0.982525,  0.980997,  0.984145,  0.982196,  0.978076,  0.979561,  0.980703,  0.982690,  0.972840,  0.981164,  0.978921,  0.978839,  0.973407,  0.978992,  0.977002,  0.974850,  0.973135,  0.978368,  0.977722,  0.969516,  0.973591,  0.974427,  0.976429,  0.963288,  0.977091,  0.970846,  0.972064,  0.968202,  0.971734,  0.971445,  0.965816,  0.964756,  0.974465,  0.970688,  0.961762,  0.965594,  0.969734,  0.969959,  0.954194,  0.971495,  0.964738,  0.965391,  0.962745,  0.965562,  0.963802,  0.959434,  0.960196,  0.966761,  0.965264,  0.952491,  0.958700,  0.964705,  0.960952,  0.948167,  0.964373,  0.957588,  0.958171,  0.955986,  0.961143,  0.958170,  0.950092, },
{ 1.000000,  0.999510,  0.999102,  0.998927,  0.997959,  0.997906,  0.997583,  0.997107,  0.995828,  0.996796,  0.995687,  0.995191,  0.994564,  0.995167,  0.994308,  0.992687,  0.992675,  0.992992,  0.993469,  0.989385,  0.992480,  0.991517,  0.990644,  0.988478,  0.990830,  0.989306,  0.988214,  0.987307,  0.989714,  0.988616,  0.985051,  0.986784,  0.987190,  0.987381,  0.980580,  0.987884,  0.984184,  0.984841,  0.982010,  0.984860,  0.983465,  0.980374,  0.979882,  0.984423,  0.982528,  0.977520,  0.979547,  0.981475,  0.982281,  0.971093,  0.982823,  0.977989,  0.977868,  0.976594,  0.978093,  0.975982,  0.973729,  0.974520,  0.978646,  0.977106,  0.969559,  0.972645,  0.975828,  0.974090,  0.964325,  0.976493,  0.971063,  0.972094,  0.969553,  0.973026,  0.970849,  0.966256,  0.968182,  0.971020,  0.971459,  0.960855,  0.967138,  0.970124,  0.966091,  0.958697,  0.971102,  0.964334,  0.964963,  0.960686,  0.969489,  0.965427,  0.957824,  0.961454,  0.963363,  0.968263,  0.949789,  0.964589,  0.963043,  0.961000,  0.951883,  0.964257,  0.959570,  0.955621,  0.955247,  0.962510, },
{ 1.000000,  0.999569,  0.998900,  0.998570,  0.998462,  0.998080,  0.996525,  0.997500,  0.996328,  0.996235,  0.995142,  0.995647,  0.994884,  0.993823,  0.993107,  0.994529,  0.993582,  0.991469,  0.992049,  0.992025,  0.992392,  0.987440,  0.992294,  0.989975,  0.989812,  0.988291,  0.989114,  0.988282,  0.986447,  0.986892,  0.988566,  0.987638,  0.983808,  0.984833,  0.986524,  0.985799,  0.979346,  0.986317,  0.983609,  0.983273,  0.981166,  0.983915,  0.982230,  0.979287,  0.980249,  0.981560,  0.982271,  0.975201,  0.978876,  0.980955,  0.978403,  0.972607,  0.981423,  0.975110,  0.977682,  0.972939,  0.978893,  0.976499,  0.971697,  0.973624,  0.975010,  0.977502,  0.965520,  0.974581,  0.973937,  0.972584,  0.965503,  0.974096,  0.970291,  0.969031,  0.967706,  0.971964,  0.971828,  0.962848,  0.967096,  0.969768,  0.970239,  0.954921,  0.971885,  0.965282,  0.968695,  0.958385,  0.967821,  0.964608,  0.960281,  0.959272,  0.968664,  0.965592,  0.955550,  0.960564,  0.962597,  0.965813,  0.945719,  0.966683,  0.959858,  0.959612,  0.955501,  0.959895,  0.956453,  0.952801, },
{ 1.000000,  0.999522,  0.999173,  0.998725,  0.997907,  0.997469,  0.997664,  0.997305,  0.995154,  0.996613,  0.995674,  0.995263,  0.994310,  0.994680,  0.993757,  0.992588,  0.992509,  0.992848,  0.992544,  0.989667,  0.990620,  0.991531,  0.990154,  0.987433,  0.990888,  0.988048,  0.988458,  0.986947,  0.988815,  0.987879,  0.984420,  0.985510,  0.986489,  0.987452,  0.980476,  0.985314,  0.985234,  0.983348,  0.979561,  0.984909,  0.981563,  0.981000,  0.979596,  0.982404,  0.982543,  0.976614,  0.978551,  0.980064,  0.981079,  0.969858,  0.981716,  0.977109,  0.978868,  0.971755,  0.977857,  0.975417,  0.972862,  0.971817,  0.977968,  0.975540,  0.968457,  0.972633,  0.973012,  0.975232,  0.960841,  0.976029,  0.970990,  0.971077,  0.966444,  0.971023,  0.968304,  0.964937,  0.966477,  0.971032,  0.971298,  0.961284,  0.963133,  0.968953,  0.967810,  0.951000,  0.969859,  0.964003,  0.965093,  0.960489,  0.964690,  0.962255,  0.957328,  0.959117,  0.963973,  0.964636,  0.949513,  0.958003,  0.963589,  0.957724,  0.948665,  0.963805,  0.955205,  0.954906,  0.953942,  0.959222, },
{ 1.000000,  0.999576,  0.998960,  0.998821,  0.998436,  0.998212,  0.996825,  0.997339,  0.997033,  0.996209,  0.994910,  0.996205,  0.994926,  0.994498,  0.993895,  0.994361,  0.993887,  0.991681,  0.992424,  0.992657,  0.992717,  0.988298,  0.992224,  0.990464,  0.990808,  0.987613,  0.989948,  0.988637,  0.987618,  0.986538,  0.989300,  0.988126,  0.984323,  0.985917,  0.986627,  0.987432,  0.979457,  0.987553,  0.983616,  0.984256,  0.982026,  0.983698,  0.982777,  0.980344,  0.980467,  0.983777,  0.982966,  0.977424,  0.978392,  0.981663,  0.981584,  0.970516,  0.981334,  0.978600,  0.978846,  0.975496,  0.978367,  0.976047,  0.973698,  0.974519,  0.977503,  0.978243,  0.966855,  0.973320,  0.975990,  0.972614,  0.966084,  0.976129,  0.970784,  0.970681,  0.969682,  0.972926,  0.971777,  0.965561,  0.968355,  0.969980,  0.972584,  0.959688,  0.969147,  0.969253,  0.966632,  0.958204,  0.971746,  0.965319,  0.964111,  0.961544,  0.968878,  0.965801,  0.957829,  0.961583,  0.964250,  0.967070,  0.949028,  0.966624,  0.961385,  0.963389,  0.952211,  0.963035,  0.960022,  0.955989, },
{ 1.000000,  0.999515,  0.999179,  0.998978,  0.998133,  0.997914,  0.997598,  0.997646,  0.995563,  0.997028,  0.995870,  0.995549,  0.994832,  0.994887,  0.994572,  0.993274,  0.992665,  0.993795,  0.993561,  0.990819,  0.991370,  0.992046,  0.992009,  0.986497,  0.991907,  0.989706,  0.989707,  0.988212,  0.989139,  0.988167,  0.986765,  0.986908,  0.987933,  0.988561,  0.982409,  0.985231,  0.986756,  0.985498,  0.980193,  0.986325,  0.983221,  0.983013,  0.982145,  0.984292,  0.982739,  0.978917,  0.980596,  0.981286,  0.983210,  0.975002,  0.980467,  0.979577,  0.979331,  0.972580,  0.982044,  0.976815,  0.976787,  0.975255,  0.978977,  0.977062,  0.971917,  0.973946,  0.974631,  0.978850,  0.965270,  0.976642,  0.973965,  0.974162,  0.966713,  0.974023,  0.971745,  0.969940,  0.967792,  0.973069,  0.973795,  0.963316,  0.968834,  0.969004,  0.972928,  0.955735,  0.973113,  0.965731,  0.967859,  0.963041,  0.966759,  0.966527,  0.960854,  0.959987,  0.970256,  0.967389,  0.956098,  0.960918,  0.965044,  0.967218,  0.947121,  0.968091,  0.960056,  0.961639,  0.958466,  0.961439, },
{ 1.000000,  0.999560,  0.999039,  0.998839,  0.998614,  0.998287,  0.996981,  0.996966,  0.997038,  0.996633,  0.994770,  0.996234,  0.995090,  0.994685,  0.994411,  0.994488,  0.993830,  0.992241,  0.992515,  0.992586,  0.993095,  0.989682,  0.991352,  0.991336,  0.990360,  0.987313,  0.991351,  0.989046,  0.988711,  0.987481,  0.988922,  0.988406,  0.985415,  0.985893,  0.986665,  0.988318,  0.980876,  0.987041,  0.985727,  0.984791,  0.980716,  0.985108,  0.983247,  0.981962,  0.980655,  0.983810,  0.983437,  0.977746,  0.980675,  0.981012,  0.982576,  0.971982,  0.983169,  0.977988,  0.979391,  0.975475,  0.979339,  0.977733,  0.973957,  0.973689,  0.979083,  0.977847,  0.970785,  0.973621,  0.975886,  0.978456,  0.962331,  0.978559,  0.972525,  0.972453,  0.971267,  0.972671,  0.970223,  0.967940,  0.969278,  0.973099,  0.973475,  0.962711,  0.966588,  0.970626,  0.969640,  0.956661,  0.972126,  0.965681,  0.967031,  0.964837,  0.967681,  0.966304,  0.960871,  0.962821,  0.965567,  0.968304,  0.954340,  0.961821,  0.965293,  0.961878,  0.951732,  0.967062,  0.958947,  0.960410, },
{ 1.000000,  0.999535,  0.999224,  0.998759,  0.998236,  0.997965,  0.997589,  0.997722,  0.995624,  0.996605,  0.996281,  0.995767,  0.994121,  0.995413,  0.994328,  0.993445,  0.993412,  0.993791,  0.993618,  0.990900,  0.991848,  0.992005,  0.992261,  0.987469,  0.992255,  0.989546,  0.990168,  0.987615,  0.989646,  0.988466,  0.986811,  0.986286,  0.989263,  0.987710,  0.983864,  0.985735,  0.985808,  0.987574,  0.978505,  0.987392,  0.983631,  0.983889,  0.982100,  0.983231,  0.982198,  0.979870,  0.981279,  0.983089,  0.982886,  0.976868,  0.978766,  0.981226,  0.980819,  0.971061,  0.981755,  0.978233,  0.977497,  0.976048,  0.978726,  0.976828,  0.973194,  0.974870,  0.976099,  0.978030,  0.968201,  0.973655,  0.976057,  0.973590,  0.965495,  0.977700,  0.969435,  0.972701,  0.967967,  0.974083,  0.972101,  0.966147,  0.968602,  0.970248,  0.974316,  0.958561,  0.970474,  0.969238,  0.968068,  0.959192,  0.970378,  0.965444,  0.963834,  0.963838,  0.966852,  0.968855,  0.957081,  0.962648,  0.965402,  0.967273,  0.947794,  0.968594,  0.960940,  0.965015,  0.953562,  0.963799, },
{ 1.000000,  0.999563,  0.999039,  0.998805,  0.998695,  0.998212,  0.997163,  0.997062,  0.996988,  0.997098,  0.994392,  0.996452,  0.995391,  0.995037,  0.994193,  0.994240,  0.993301,  0.992503,  0.992868,  0.993201,  0.992975,  0.990492,  0.990399,  0.991377,  0.991783,  0.985994,  0.991168,  0.989451,  0.989004,  0.987896,  0.988980,  0.987724,  0.985953,  0.986445,  0.987111,  0.987669,  0.982515,  0.984862,  0.986316,  0.984481,  0.979870,  0.986363,  0.981949,  0.982910,  0.981390,  0.983684,  0.983113,  0.978241,  0.980164,  0.981527,  0.983487,  0.973303,  0.980765,  0.980523,  0.978249,  0.973288,  0.981077,  0.976414,  0.976136,  0.974989,  0.978014,  0.978743,  0.970895,  0.974007,  0.975780,  0.978098,  0.963254,  0.978549,  0.972673,  0.975122,  0.967142,  0.973926,  0.971226,  0.968441,  0.967994,  0.974396,  0.972319,  0.963985,  0.968777,  0.968719,  0.973049,  0.954672,  0.973772,  0.967247,  0.967809,  0.963111,  0.967265,  0.964525,  0.961543,  0.963730,  0.967465,  0.969229,  0.957193,  0.959860,  0.965746,  0.965861,  0.945837,  0.967755,  0.961374,  0.962313, },
{ 1.000000,  0.999550,  0.999156,  0.998682,  0.998267,  0.997966,  0.997743,  0.997474,  0.995765,  0.996176,  0.996423,  0.995548,  0.993965,  0.995572,  0.993968,  0.993483,  0.993503,  0.993570,  0.993314,  0.991123,  0.991729,  0.991634,  0.992231,  0.988174,  0.990805,  0.990585,  0.989045,  0.986234,  0.990723,  0.987574,  0.987202,  0.987021,  0.988012,  0.987728,  0.983633,  0.985555,  0.986250,  0.986888,  0.978967,  0.986813,  0.983821,  0.984496,  0.979979,  0.983520,  0.981751,  0.980581,  0.980019,  0.983412,  0.982007,  0.976637,  0.979373,  0.979963,  0.982087,  0.970034,  0.982801,  0.977000,  0.977562,  0.975444,  0.977065,  0.976296,  0.972937,  0.974101,  0.977796,  0.977192,  0.970108,  0.971488,  0.975616,  0.976108,  0.960965,  0.976370,  0.972374,  0.972387,  0.969618,  0.971892,  0.969527,  0.966795,  0.968585,  0.971628,  0.973182,  0.958279,  0.967283,  0.970259,  0.966442,  0.957888,  0.971350,  0.964211,  0.963961,  0.964544,  0.966686,  0.966018,  0.958260,  0.962595,  0.963887,  0.967653,  0.951320,  0.964267,  0.963555,  0.960418,  0.949695,  0.967616, },
{ 1.000000,  0.999555,  0.999063,  0.998812,  0.998631,  0.998107,  0.997152,  0.997021,  0.996765,  0.996929,  0.994541,  0.996220,  0.995108,  0.995026,  0.993138,  0.994434,  0.993559,  0.992580,  0.992262,  0.992996,  0.992419,  0.990027,  0.991034,  0.990938,  0.991562,  0.985560,  0.991436,  0.988914,  0.988829,  0.987495,  0.987802,  0.987754,  0.985484,  0.985554,  0.987882,  0.987124,  0.982470,  0.984242,  0.985545,  0.986210,  0.976525,  0.986389,  0.982852,  0.982796,  0.981407,  0.982285,  0.981167,  0.979141,  0.980297,  0.981413,  0.982423,  0.973379,  0.978571,  0.980006,  0.978850,  0.970718,  0.980607,  0.976181,  0.975947,  0.975458,  0.977713,  0.975902,  0.970552,  0.974074,  0.974658,  0.977104,  0.965650,  0.974699,  0.972561,  0.973044,  0.963258,  0.976932,  0.969641,  0.969082,  0.968426,  0.972923,  0.970446,  0.963806,  0.967018,  0.967572,  0.972950,  0.955523,  0.970890,  0.967077,  0.967332,  0.958714,  0.967387,  0.964519,  0.962338,  0.961132,  0.966777,  0.967341,  0.955023,  0.962855,  0.961764,  0.967281,  0.945345,  0.968175,  0.958674,  0.961194, },
{ 1.000000,  0.999521,  0.999132,  0.998694,  0.997971,  0.997797,  0.997979,  0.997326,  0.995972,  0.996084,  0.995996,  0.995982,  0.993045,  0.995659,  0.994126,  0.993833,  0.993219,  0.993134,  0.992556,  0.991409,  0.991573,  0.992180,  0.991980,  0.988128,  0.989877,  0.990587,  0.989888,  0.985034,  0.990336,  0.987889,  0.987551,  0.987267,  0.987828,  0.986642,  0.983890,  0.985366,  0.985648,  0.986688,  0.980346,  0.984833,  0.984134,  0.983400,  0.977532,  0.985342,  0.981356,  0.980686,  0.980110,  0.982268,  0.981062,  0.976579,  0.978384,  0.979260,  0.982220,  0.970292,  0.980812,  0.978303,  0.977376,  0.971818,  0.978861,  0.975326,  0.973581,  0.972956,  0.977177,  0.976264,  0.968941,  0.973630,  0.973377,  0.975924,  0.960934,  0.977632,  0.969806,  0.972028,  0.967270,  0.972414,  0.969766,  0.964918,  0.965911,  0.972238,  0.970130,  0.961698,  0.966380,  0.967881,  0.972036,  0.950480,  0.972724,  0.964318,  0.964657,  0.963550,  0.965041,  0.961485,  0.958969,  0.962243,  0.966377,  0.965931,  0.952547,  0.959087,  0.962266,  0.962837,  0.945125,  0.966203, },
{ 1.000000,  0.999535,  0.999106,  0.998867,  0.998561,  0.998040,  0.997226,  0.997264,  0.997034,  0.996890,  0.994889,  0.995582,  0.995583,  0.994915,  0.992929,  0.995067,  0.993315,  0.992859,  0.992315,  0.993408,  0.992395,  0.990058,  0.990944,  0.990595,  0.992155,  0.986340,  0.990757,  0.989555,  0.988920,  0.985470,  0.989615,  0.987536,  0.985756,  0.986295,  0.987691,  0.987426,  0.982459,  0.985227,  0.985422,  0.986071,  0.977748,  0.987035,  0.982291,  0.983754,  0.980004,  0.983367,  0.981472,  0.978671,  0.979358,  0.983849,  0.981094,  0.975611,  0.979080,  0.978905,  0.981929,  0.968501,  0.982341,  0.976628,  0.976782,  0.974840,  0.976801,  0.975202,  0.971809,  0.974431,  0.976948,  0.976265,  0.968293,  0.972135,  0.974437,  0.974367,  0.960968,  0.976663,  0.971223,  0.970021,  0.969174,  0.972510,  0.969853,  0.964863,  0.968113,  0.969679,  0.971875,  0.958613,  0.967514,  0.969316,  0.966981,  0.956554,  0.972493,  0.961848,  0.964873,  0.960926,  0.968299,  0.965390,  0.957396,  0.961903,  0.963623,  0.968132,  0.948604,  0.965212,  0.961931,  0.960924, },
{ 1.000000,  0.999445,  0.999232,  0.998881,  0.998337,  0.997911,  0.997760,  0.997647,  0.996260,  0.996356,  0.996243,  0.996061,  0.993348,  0.995913,  0.994387,  0.994569,  0.992258,  0.993844,  0.992935,  0.991524,  0.991342,  0.992976,  0.991864,  0.989168,  0.990289,  0.990244,  0.991355,  0.984392,  0.991279,  0.988522,  0.988172,  0.986636,  0.988055,  0.986335,  0.984774,  0.985835,  0.987410,  0.986798,  0.982545,  0.983382,  0.985101,  0.985801,  0.975960,  0.985968,  0.982875,  0.982064,  0.980571,  0.983169,  0.981063,  0.978026,  0.979624,  0.981242,  0.981245,  0.973485,  0.978454,  0.980147,  0.977840,  0.971010,  0.981289,  0.974898,  0.975364,  0.974311,  0.978300,  0.976914,  0.969721,  0.973401,  0.975674,  0.977611,  0.963544,  0.975131,  0.974264,  0.971411,  0.964091,  0.976026,  0.969672,  0.968090,  0.967573,  0.972579,  0.972442,  0.962419,  0.966863,  0.969432,  0.972052,  0.952846,  0.973581,  0.966016,  0.968746,  0.958271,  0.968451,  0.964532,  0.960304,  0.960504,  0.969612,  0.965445,  0.955402,  0.962377,  0.962188,  0.967492,  0.944253,  0.968816, },
{ 1.000000,  0.999569,  0.999159,  0.998544,  0.998393,  0.997809,  0.997074,  0.996855,  0.996925,  0.996647,  0.994840,  0.995112,  0.995471,  0.995169,  0.991388,  0.994978,  0.993340,  0.993063,  0.991878,  0.992644,  0.991683,  0.989902,  0.990330,  0.991139,  0.991186,  0.985919,  0.988941,  0.989596,  0.988201,  0.984082,  0.989671,  0.986223,  0.985413,  0.985413,  0.987083,  0.986659,  0.982242,  0.983943,  0.984585,  0.986171,  0.977700,  0.983960,  0.983346,  0.981403,  0.975843,  0.985272,  0.979666,  0.978452,  0.978479,  0.981548,  0.980965,  0.974100,  0.977009,  0.978807,  0.980550,  0.967254,  0.981102,  0.976190,  0.977172,  0.969298,  0.976982,  0.974096,  0.971707,  0.970468,  0.977245,  0.974714,  0.966448,  0.970983,  0.972220,  0.975451,  0.957299,  0.976885,  0.968757,  0.969516,  0.965470,  0.969831,  0.968660,  0.963076,  0.964771,  0.971294,  0.970299,  0.959337,  0.962531,  0.968259,  0.969289,  0.947234,  0.970040,  0.964041,  0.963945,  0.959263,  0.965095,  0.961301,  0.956537,  0.958717,  0.964586,  0.966291,  0.945060,  0.959227,  0.962138,  0.958436, },
{ 1.000000,  0.999448,  0.999279,  0.998885,  0.998411,  0.997959,  0.997838,  0.997383,  0.996473,  0.996408,  0.996270,  0.996364,  0.993721,  0.995447,  0.994883,  0.994200,  0.991751,  0.994669,  0.993184,  0.992119,  0.991473,  0.993009,  0.991933,  0.989397,  0.990100,  0.990683,  0.991384,  0.985231,  0.990806,  0.988513,  0.989182,  0.985136,  0.988681,  0.987364,  0.985313,  0.985246,  0.987650,  0.986947,  0.982215,  0.984154,  0.984810,  0.986475,  0.976215,  0.986727,  0.982472,  0.982633,  0.980118,  0.982134,  0.982253,  0.978578,  0.978009,  0.982666,  0.982200,  0.974789,  0.977474,  0.980237,  0.981251,  0.966901,  0.981961,  0.976999,  0.976758,  0.974734,  0.977146,  0.975536,  0.972417,  0.973415,  0.976511,  0.978183,  0.964988,  0.972324,  0.974778,  0.973816,  0.962227,  0.976471,  0.970532,  0.969706,  0.968659,  0.973502,  0.971008,  0.963666,  0.967348,  0.969352,  0.973121,  0.957273,  0.969953,  0.967224,  0.967778,  0.954517,  0.973420,  0.964683,  0.962894,  0.961682,  0.968884,  0.966000,  0.957433,  0.960237,  0.962407,  0.969188,  0.946645,  0.966648, },
{ 1.000000,  0.999579,  0.999186,  0.998660,  0.998629,  0.998113,  0.997461,  0.996898,  0.997323,  0.997031,  0.995316,  0.995614,  0.995272,  0.995748,  0.992258,  0.995362,  0.993543,  0.993609,  0.992114,  0.992938,  0.992590,  0.990629,  0.990270,  0.992554,  0.991692,  0.988195,  0.989111,  0.990197,  0.990808,  0.983581,  0.990636,  0.987773,  0.987749,  0.986498,  0.987285,  0.986538,  0.984614,  0.984635,  0.986756,  0.986962,  0.979788,  0.983158,  0.985131,  0.984562,  0.976238,  0.985392,  0.981571,  0.981490,  0.980543,  0.982484,  0.981130,  0.976920,  0.978560,  0.980140,  0.982020,  0.972221,  0.979008,  0.978530,  0.978249,  0.969228,  0.980938,  0.975950,  0.974769,  0.973142,  0.977469,  0.976276,  0.970149,  0.971429,  0.973881,  0.978003,  0.962088,  0.976029,  0.973044,  0.972405,  0.963791,  0.974165,  0.970682,  0.967476,  0.966031,  0.972745,  0.971807,  0.962389,  0.967076,  0.968339,  0.971853,  0.952597,  0.973793,  0.964461,  0.967200,  0.960244,  0.967918,  0.965450,  0.959193,  0.959163,  0.967929,  0.966169,  0.955591,  0.959654,  0.963746,  0.968828, },
{ 1.000000,  0.999370,  0.999323,  0.998716,  0.998524,  0.997977,  0.997770,  0.997144,  0.996481,  0.996148,  0.996455,  0.996089,  0.994170,  0.994488,  0.994827,  0.994567,  0.991024,  0.994390,  0.992777,  0.992554,  0.991674,  0.992352,  0.991561,  0.989889,  0.989945,  0.990697,  0.991340,  0.986202,  0.988796,  0.989421,  0.988579,  0.984072,  0.989641,  0.986702,  0.986233,  0.984591,  0.988049,  0.986402,  0.982633,  0.983587,  0.984193,  0.987087,  0.977085,  0.984932,  0.983536,  0.983169,  0.976720,  0.983928,  0.981489,  0.978895,  0.978902,  0.982082,  0.981912,  0.974779,  0.977813,  0.979515,  0.980585,  0.968173,  0.981878,  0.975956,  0.977891,  0.971517,  0.977501,  0.975585,  0.971956,  0.971076,  0.978808,  0.975395,  0.968330,  0.971425,  0.973098,  0.977322,  0.958425,  0.977236,  0.970443,  0.971325,  0.966903,  0.970967,  0.969278,  0.965206,  0.966708,  0.972058,  0.971194,  0.960420,  0.964726,  0.969347,  0.969687,  0.950917,  0.971561,  0.965848,  0.964075,  0.961346,  0.967145,  0.964277,  0.958518,  0.960287,  0.963913,  0.967513,  0.949900,  0.960859, },
{ 1.000000,  0.999612,  0.999197,  0.998345,  0.998648,  0.997946,  0.997710,  0.996886,  0.997244,  0.996660,  0.995471,  0.995269,  0.995502,  0.995932,  0.992564,  0.994645,  0.993875,  0.993620,  0.991054,  0.993589,  0.992188,  0.991249,  0.990754,  0.991875,  0.991960,  0.988397,  0.989181,  0.989951,  0.990695,  0.983738,  0.990552,  0.987821,  0.989054,  0.984031,  0.987994,  0.986524,  0.984280,  0.983930,  0.987773,  0.986274,  0.981576,  0.982865,  0.983905,  0.986642,  0.974552,  0.986098,  0.982183,  0.982217,  0.979335,  0.981713,  0.979597,  0.977713,  0.978682,  0.981610,  0.981512,  0.975044,  0.975747,  0.979366,  0.981258,  0.965900,  0.980739,  0.976878,  0.975872,  0.973746,  0.977380,  0.975034,  0.971282,  0.972343,  0.975221,  0.976835,  0.965331,  0.971742,  0.974530,  0.972688,  0.962035,  0.976002,  0.968481,  0.969100,  0.967127,  0.972701,  0.971662,  0.962898,  0.965578,  0.969429,  0.973513,  0.954513,  0.969123,  0.968380,  0.966109,  0.955454,  0.970513,  0.963703,  0.962181,  0.960430,  0.967135,  0.967757,  0.955407,  0.959222,  0.963448,  0.968506, },
{ 1.000000,  0.999395,  0.999329,  0.998735,  0.998485,  0.997634,  0.997915,  0.997274,  0.996540,  0.995958,  0.996712,  0.995900,  0.994499,  0.994698,  0.994556,  0.995252,  0.990741,  0.994663,  0.993156,  0.992977,  0.991107,  0.992395,  0.991241,  0.989922,  0.989884,  0.991408,  0.991500,  0.987462,  0.987922,  0.989750,  0.989665,  0.981801,  0.989837,  0.987189,  0.987088,  0.985261,  0.986992,  0.985684,  0.983164,  0.983613,  0.985790,  0.986503,  0.978045,  0.982889,  0.984246,  0.983089,  0.976464,  0.985140,  0.980597,  0.979511,  0.979198,  0.981890,  0.981554,  0.975871,  0.977628,  0.979380,  0.982074,  0.970411,  0.978721,  0.978015,  0.976477,  0.968503,  0.980917,  0.974296,  0.973197,  0.972594,  0.977006,  0.976665,  0.968426,  0.971118,  0.974181,  0.976926,  0.959452,  0.976977,  0.971347,  0.973199,  0.963088,  0.972310,  0.969330,  0.967147,  0.964662,  0.973322,  0.970179,  0.961676,  0.965076,  0.968109,  0.972573,  0.950168,  0.973364,  0.964702,  0.965378,  0.960359,  0.965683,  0.964371,  0.958598,  0.959015,  0.967540,  0.967159,  0.954858,  0.956693, },
{ 1.000000,  0.999635,  0.999307,  0.998390,  0.998828,  0.998234,  0.997777,  0.997258,  0.997376,  0.996688,  0.995847,  0.995489,  0.996237,  0.996164,  0.992899,  0.994320,  0.994545,  0.993872,  0.991062,  0.994323,  0.992444,  0.991700,  0.991145,  0.992390,  0.991853,  0.989072,  0.989560,  0.990677,  0.991589,  0.985559,  0.989761,  0.989266,  0.988497,  0.983462,  0.990202,  0.987248,  0.985847,  0.984737,  0.988323,  0.986723,  0.982515,  0.983129,  0.985398,  0.986983,  0.976644,  0.986187,  0.982977,  0.984095,  0.977466,  0.983695,  0.982103,  0.979098,  0.978794,  0.983105,  0.981948,  0.975611,  0.977797,  0.980171,  0.982609,  0.966971,  0.982892,  0.977817,  0.977490,  0.973626,  0.977127,  0.977611,  0.972753,  0.971441,  0.978345,  0.978000,  0.968177,  0.971183,  0.976263,  0.977593,  0.957535,  0.978126,  0.972621,  0.971504,  0.968682,  0.972677,  0.970539,  0.966795,  0.967092,  0.972522,  0.974464,  0.958022,  0.967021,  0.970797,  0.969822,  0.954105,  0.973320,  0.966237,  0.964604,  0.962664,  0.969832,  0.966962,  0.957742,  0.961107,  0.965620,  0.970073, },
{ 1.000000,  0.999453,  0.999254,  0.998776,  0.998654,  0.997444,  0.998309,  0.997277,  0.996758,  0.996156,  0.996746,  0.996172,  0.994730,  0.994554,  0.994744,  0.995473,  0.991262,  0.994425,  0.993503,  0.993215,  0.990367,  0.992873,  0.991764,  0.990712,  0.989783,  0.991859,  0.991461,  0.987608,  0.988854,  0.989320,  0.991099,  0.982355,  0.990782,  0.987382,  0.987481,  0.984930,  0.987352,  0.986734,  0.983469,  0.982977,  0.987858,  0.986137,  0.980455,  0.982292,  0.985042,  0.986207,  0.973846,  0.986305,  0.982052,  0.981581,  0.979900,  0.982255,  0.980320,  0.977972,  0.977639,  0.982181,  0.982130,  0.971786,  0.976660,  0.980069,  0.979677,  0.966831,  0.981671,  0.976007,  0.975125,  0.973892,  0.977923,  0.975726,  0.970102,  0.971905,  0.975411,  0.977500,  0.963900,  0.973976,  0.973266,  0.972979,  0.960386,  0.977365,  0.970146,  0.968717,  0.966626,  0.973403,  0.971100,  0.963316,  0.964418,  0.969281,  0.974319,  0.953472,  0.971986,  0.968167,  0.967211,  0.955675,  0.970607,  0.965248,  0.961603,  0.959336,  0.969162,  0.966877,  0.955916,  0.960748, },
{ 1.000000,  0.999616,  0.999325,  0.998210,  0.998771,  0.997923,  0.997857,  0.996860,  0.997367,  0.996639,  0.995581,  0.995085,  0.996182,  0.995306,  0.993453,  0.993601,  0.994239,  0.994821,  0.988923,  0.994416,  0.992128,  0.991630,  0.990852,  0.991790,  0.990331,  0.989181,  0.988956,  0.991165,  0.990487,  0.985613,  0.987378,  0.988706,  0.988862,  0.981056,  0.989835,  0.986010,  0.985574,  0.984315,  0.986665,  0.985209,  0.982225,  0.982431,  0.985019,  0.985822,  0.977116,  0.982590,  0.983073,  0.982211,  0.974483,  0.984852,  0.980059,  0.979323,  0.976699,  0.983256,  0.980053,  0.974681,  0.976160,  0.978084,  0.982282,  0.966969,  0.979634,  0.977278,  0.976914,  0.967068,  0.979273,  0.974964,  0.971316,  0.971516,  0.977329,  0.975790,  0.966707,  0.970696,  0.973847,  0.975741,  0.957038,  0.977730,  0.969486,  0.971850,  0.962715,  0.972946,  0.968864,  0.964187,  0.963355,  0.974966,  0.968731,  0.960164,  0.964046,  0.967251,  0.973073,  0.946180,  0.973528,  0.964187,  0.964395,  0.958869,  0.965853,  0.962563,  0.957777,  0.958791,  0.967630,  0.965320, },
{ 1.000000,  0.999512,  0.999148,  0.998927,  0.998622,  0.996967,  0.998150,  0.997314,  0.996688,  0.996061,  0.996509,  0.995700,  0.994565,  0.994345,  0.994924,  0.994929,  0.991504,  0.993536,  0.993461,  0.992788,  0.989046,  0.993704,  0.990763,  0.990834,  0.989148,  0.991806,  0.990212,  0.987769,  0.988026,  0.989374,  0.990599,  0.982993,  0.988988,  0.987689,  0.987273,  0.981703,  0.988272,  0.985463,  0.983688,  0.983389,  0.986319,  0.985778,  0.979886,  0.981642,  0.983897,  0.985068,  0.972861,  0.985500,  0.981198,  0.982718,  0.974597,  0.982642,  0.979949,  0.976049,  0.975862,  0.983064,  0.979393,  0.973099,  0.975049,  0.978123,  0.981813,  0.962676,  0.981579,  0.975677,  0.975098,  0.971104,  0.976211,  0.972479,  0.969583,  0.970778,  0.976856,  0.975069,  0.966455,  0.968253,  0.973587,  0.975948,  0.953420,  0.976467,  0.970664,  0.968301,  0.965410,  0.972158,  0.967863,  0.962991,  0.964194,  0.970424,  0.970244,  0.955087,  0.965217,  0.968433,  0.966227,  0.950915,  0.971856,  0.961392,  0.960689,  0.958786,  0.968212,  0.964934,  0.953666,  0.957311, },
{ 1.000000,  0.999638,  0.999347,  0.998290,  0.998565,  0.998162,  0.997605,  0.996280,  0.997434,  0.996297,  0.995643,  0.995162,  0.995911,  0.995364,  0.993211,  0.993378,  0.994020,  0.994476,  0.989144,  0.994195,  0.992047,  0.992411,  0.988657,  0.991935,  0.990555,  0.988675,  0.988152,  0.991466,  0.989406,  0.985967,  0.987255,  0.987845,  0.989871,  0.979694,  0.989752,  0.986352,  0.985975,  0.982751,  0.986259,  0.984051,  0.981737,  0.982390,  0.985522,  0.985404,  0.978449,  0.980192,  0.983765,  0.983662,  0.970338,  0.985017,  0.980467,  0.979780,  0.977133,  0.981023,  0.978766,  0.974720,  0.975793,  0.979929,  0.980068,  0.967873,  0.975987,  0.977896,  0.976409,  0.965785,  0.980030,  0.973439,  0.971097,  0.971122,  0.976135,  0.975101,  0.966991,  0.969655,  0.973467,  0.975674,  0.960017,  0.972517,  0.971651,  0.969074,  0.957513,  0.976357,  0.967105,  0.964201,  0.964721,  0.971843,  0.969744,  0.958813,  0.962886,  0.967960,  0.971071,  0.947498,  0.972022,  0.964492,  0.965995,  0.952353,  0.966531,  0.962218,  0.958066,  0.956278,  0.968653,  0.962803, },
{ 1.000000,  0.999520,  0.999154,  0.998878,  0.998708,  0.997028,  0.998400,  0.997423,  0.996990,  0.995937,  0.996312,  0.995867,  0.994729,  0.994517,  0.995482,  0.994906,  0.992548,  0.992631,  0.993926,  0.993844,  0.988049,  0.993387,  0.992022,  0.991363,  0.989875,  0.991303,  0.989963,  0.988139,  0.988195,  0.990560,  0.990407,  0.983423,  0.987531,  0.988416,  0.987464,  0.981573,  0.988848,  0.985485,  0.984079,  0.984020,  0.986366,  0.985470,  0.980693,  0.982116,  0.984527,  0.985571,  0.976011,  0.983512,  0.982480,  0.981358,  0.973620,  0.984781,  0.980239,  0.977487,  0.976825,  0.982906,  0.979929,  0.973853,  0.975345,  0.978682,  0.981031,  0.966067,  0.980573,  0.975879,  0.977128,  0.967732,  0.977412,  0.975090,  0.970375,  0.970839,  0.977267,  0.974884,  0.966445,  0.969910,  0.973450,  0.976598,  0.955083,  0.977487,  0.970531,  0.969662,  0.964945,  0.970379,  0.969633,  0.963547,  0.962833,  0.972265,  0.970943,  0.958434,  0.962936,  0.969898,  0.971472,  0.944846,  0.972610,  0.965074,  0.963602,  0.960281,  0.965599,  0.962645,  0.957708,  0.958555, },
{ 1.000000,  0.999646,  0.999316,  0.998331,  0.998352,  0.998193,  0.997731,  0.996028,  0.997403,  0.996382,  0.995665,  0.995197,  0.995832,  0.995029,  0.993164,  0.993388,  0.994124,  0.994244,  0.990184,  0.993005,  0.992080,  0.991912,  0.987734,  0.992946,  0.990162,  0.989010,  0.988440,  0.990999,  0.989492,  0.985993,  0.986537,  0.987847,  0.989678,  0.980923,  0.988233,  0.986637,  0.986021,  0.980881,  0.986359,  0.984740,  0.982015,  0.981363,  0.985726,  0.984871,  0.978008,  0.980894,  0.982094,  0.984641,  0.970776,  0.984890,  0.979969,  0.979621,  0.975692,  0.980362,  0.979243,  0.973820,  0.974211,  0.981785,  0.978445,  0.970336,  0.973386,  0.978306,  0.979460,  0.961330,  0.979784,  0.974109,  0.972910,  0.971140,  0.974657,  0.972537,  0.968483,  0.968478,  0.975406,  0.974605,  0.960326,  0.967937,  0.973434,  0.971610,  0.954291,  0.974802,  0.967855,  0.965725,  0.964765,  0.970376,  0.967565,  0.959415,  0.962387,  0.968492,  0.969615,  0.951953,  0.965842,  0.965375,  0.964283,  0.948551,  0.970193,  0.961888,  0.958442,  0.957058,  0.965982,  0.962823, },
{ 1.000000,  0.999521,  0.999089,  0.998878,  0.998696,  0.996921,  0.997980,  0.997387,  0.996631,  0.995086,  0.996465,  0.995472,  0.994413,  0.993927,  0.995189,  0.994381,  0.991890,  0.992625,  0.993080,  0.993126,  0.987453,  0.993577,  0.990783,  0.990510,  0.988055,  0.990983,  0.989463,  0.986802,  0.986888,  0.990138,  0.988121,  0.984614,  0.985600,  0.987665,  0.988586,  0.977211,  0.988810,  0.984794,  0.983851,  0.982571,  0.984693,  0.982477,  0.980149,  0.980941,  0.984655,  0.983375,  0.975520,  0.979078,  0.981805,  0.981512,  0.969159,  0.983470,  0.978281,  0.977292,  0.975971,  0.979500,  0.977559,  0.972600,  0.973457,  0.978003,  0.978455,  0.965977,  0.974698,  0.975709,  0.973831,  0.963530,  0.978203,  0.971881,  0.969892,  0.967083,  0.976483,  0.972418,  0.963728,  0.967036,  0.970287,  0.975242,  0.954823,  0.972144,  0.969611,  0.968169,  0.955674,  0.972188,  0.967008,  0.960514,  0.962429,  0.970115,  0.968021,  0.954994,  0.961385,  0.966391,  0.967079,  0.943974,  0.970681,  0.961348,  0.962446,  0.951494,  0.964877,  0.959969,  0.952796,  0.953620, },
{ 1.000000,  0.999697,  0.999232,  0.998573,  0.998103,  0.997979,  0.998093,  0.995430,  0.997497,  0.996297,  0.995801,  0.994883,  0.995432,  0.994693,  0.993387,  0.993249,  0.994612,  0.993733,  0.990677,  0.991594,  0.992750,  0.992263,  0.986197,  0.992581,  0.990627,  0.989186,  0.988214,  0.990382,  0.988782,  0.986065,  0.986423,  0.988532,  0.988634,  0.981764,  0.986235,  0.987014,  0.985653,  0.979139,  0.988149,  0.982810,  0.982698,  0.980243,  0.985898,  0.983400,  0.978577,  0.979783,  0.982603,  0.984365,  0.972401,  0.982015,  0.980499,  0.979679,  0.971531,  0.981689,  0.977862,  0.974639,  0.975089,  0.979920,  0.979046,  0.970118,  0.972939,  0.977316,  0.977877,  0.961041,  0.979152,  0.973751,  0.974985,  0.964576,  0.975748,  0.972677,  0.966143,  0.967123,  0.977162,  0.971534,  0.963533,  0.966177,  0.970971,  0.974493,  0.950290,  0.975416,  0.968147,  0.966200,  0.961906,  0.968625,  0.964053,  0.959454,  0.962382,  0.970024,  0.967019,  0.956127,  0.958906,  0.966808,  0.968324,  0.940387,  0.969205,  0.963018,  0.959225,  0.955974,  0.964444,  0.960041, },
{ 1.000000,  0.999558,  0.999151,  0.999006,  0.998622,  0.997464,  0.997711,  0.997594,  0.997068,  0.995235,  0.996860,  0.995548,  0.995059,  0.994203,  0.995422,  0.994545,  0.992443,  0.992633,  0.993708,  0.993784,  0.988874,  0.992652,  0.992070,  0.990907,  0.987379,  0.992281,  0.989491,  0.988435,  0.987693,  0.990733,  0.989578,  0.985135,  0.986160,  0.988393,  0.988932,  0.978953,  0.989436,  0.985737,  0.986342,  0.980173,  0.986384,  0.984236,  0.981130,  0.980467,  0.986911,  0.983028,  0.978248,  0.980300,  0.981938,  0.984412,  0.969529,  0.985389,  0.980138,  0.979617,  0.975105,  0.981033,  0.977470,  0.974271,  0.975571,  0.980837,  0.979160,  0.970984,  0.973011,  0.978896,  0.977788,  0.959829,  0.980106,  0.974414,  0.973502,  0.969825,  0.975449,  0.972651,  0.967273,  0.968815,  0.975069,  0.974298,  0.959028,  0.969784,  0.972602,  0.970284,  0.957331,  0.975191,  0.966908,  0.964052,  0.963982,  0.971533,  0.969335,  0.959021,  0.962842,  0.968454,  0.970131,  0.951516,  0.966929,  0.965839,  0.962459,  0.948959,  0.972371,  0.960636,  0.957204,  0.957080, },
{ 1.000000,  0.999694,  0.999324,  0.998582,  0.998142,  0.998186,  0.997878,  0.995802,  0.997566,  0.996508,  0.996261,  0.994349,  0.995901,  0.994705,  0.993718,  0.992999,  0.995214,  0.993415,  0.991355,  0.991738,  0.992869,  0.993089,  0.986321,  0.993450,  0.990354,  0.989757,  0.988027,  0.990428,  0.988879,  0.986340,  0.986667,  0.990134,  0.988111,  0.984304,  0.984487,  0.988311,  0.987686,  0.976863,  0.988059,  0.984958,  0.984021,  0.981558,  0.985146,  0.982619,  0.979729,  0.979952,  0.985369,  0.983564,  0.973429,  0.980155,  0.982105,  0.980129,  0.971391,  0.983524,  0.978050,  0.975970,  0.975484,  0.980591,  0.978372,  0.971340,  0.973574,  0.978825,  0.978659,  0.965844,  0.977011,  0.975482,  0.973512,  0.962973,  0.979710,  0.972559,  0.968969,  0.967685,  0.978116,  0.972402,  0.964249,  0.966301,  0.972910,  0.973722,  0.954180,  0.975027,  0.968480,  0.969202,  0.957276,  0.971657,  0.967356,  0.961217,  0.961289,  0.972659,  0.966658,  0.956868,  0.960435,  0.967505,  0.969091,  0.942087,  0.972630,  0.962478,  0.960743,  0.955319,  0.964012,  0.961781, },
{ 1.000000,  0.999572,  0.999137,  0.999119,  0.998611,  0.997753,  0.997528,  0.997816,  0.997437,  0.994665,  0.997115,  0.996034,  0.995363,  0.994748,  0.995217,  0.994207,  0.993180,  0.993191,  0.994308,  0.993549,  0.989886,  0.992039,  0.992570,  0.991543,  0.987116,  0.992793,  0.990172,  0.988857,  0.988525,  0.991002,  0.989104,  0.985672,  0.986802,  0.989149,  0.988779,  0.982438,  0.987988,  0.986182,  0.986026,  0.979674,  0.989203,  0.984010,  0.982630,  0.981935,  0.987163,  0.983884,  0.979042,  0.980242,  0.983029,  0.984370,  0.972967,  0.984232,  0.981237,  0.980080,  0.973824,  0.982399,  0.979058,  0.975863,  0.975093,  0.982191,  0.979885,  0.971685,  0.975101,  0.977821,  0.979516,  0.962385,  0.982223,  0.974689,  0.973969,  0.969887,  0.976635,  0.974104,  0.967353,  0.968636,  0.979288,  0.972097,  0.964998,  0.967799,  0.974734,  0.974753,  0.953364,  0.977162,  0.969333,  0.967283,  0.966126,  0.971795,  0.967311,  0.962623,  0.963412,  0.972869,  0.969117,  0.955389,  0.963008,  0.969852,  0.966433,  0.947453,  0.972813,  0.963075,  0.960067,  0.960165, },
{ 1.000000,  0.999686,  0.999262,  0.998644,  0.998374,  0.998239,  0.997964,  0.996601,  0.997266,  0.996624,  0.996082,  0.994374,  0.996526,  0.994910,  0.994103,  0.993596,  0.995009,  0.993781,  0.991759,  0.991813,  0.993238,  0.993015,  0.988184,  0.992892,  0.991458,  0.990089,  0.987281,  0.991826,  0.989296,  0.987357,  0.987096,  0.990851,  0.988386,  0.984766,  0.986089,  0.988050,  0.987438,  0.978838,  0.989622,  0.985049,  0.984542,  0.981470,  0.986820,  0.983784,  0.980051,  0.980537,  0.986267,  0.981835,  0.978786,  0.979469,  0.983432,  0.983571,  0.968725,  0.985900,  0.979432,  0.977875,  0.977242,  0.980905,  0.976697,  0.973861,  0.975368,  0.981863,  0.977457,  0.970371,  0.973818,  0.977793,  0.976035,  0.962111,  0.981006,  0.973348,  0.971524,  0.971201,  0.976576,  0.972407,  0.966764,  0.968510,  0.975361,  0.972916,  0.961347,  0.970872,  0.971671,  0.968528,  0.958119,  0.976000,  0.967272,  0.964667,  0.962000,  0.975020,  0.967440,  0.958881,  0.962687,  0.967982,  0.970083,  0.950221,  0.969461,  0.966134,  0.963304,  0.951014,  0.970163,  0.962638, },
{ 1.000000,  0.999580,  0.999203,  0.999128,  0.998599,  0.997751,  0.997616,  0.997810,  0.997233,  0.995078,  0.997110,  0.995905,  0.995632,  0.994204,  0.995450,  0.994092,  0.993171,  0.992894,  0.995155,  0.992407,  0.991260,  0.991531,  0.992591,  0.992523,  0.986013,  0.993355,  0.990108,  0.989489,  0.988308,  0.990254,  0.988280,  0.986642,  0.987028,  0.990376,  0.987312,  0.984300,  0.985628,  0.988134,  0.986804,  0.977729,  0.988778,  0.985039,  0.983006,  0.982369,  0.986244,  0.982861,  0.980035,  0.980648,  0.984752,  0.982732,  0.975680,  0.981267,  0.982469,  0.980146,  0.972473,  0.984809,  0.977094,  0.977412,  0.974616,  0.982968,  0.977834,  0.972952,  0.974815,  0.979242,  0.979013,  0.966720,  0.978439,  0.976176,  0.974504,  0.966403,  0.978513,  0.972639,  0.969740,  0.970690,  0.977534,  0.973820,  0.965336,  0.967933,  0.974972,  0.972365,  0.955717,  0.976793,  0.969170,  0.970990,  0.960021,  0.973183,  0.967617,  0.961831,  0.962818,  0.975725,  0.965123,  0.960846,  0.961678,  0.968975,  0.969986,  0.945173,  0.974171,  0.963993,  0.962083,  0.958741, },
{ 1.000000,  0.999670,  0.999196,  0.998723,  0.998412,  0.998550,  0.997764,  0.997042,  0.996700,  0.996974,  0.996595,  0.993601,  0.996628,  0.995224,  0.994322,  0.993790,  0.994818,  0.993415,  0.992117,  0.992111,  0.993722,  0.992236,  0.989487,  0.991335,  0.991864,  0.990684,  0.986750,  0.992250,  0.988798,  0.987915,  0.987473,  0.990750,  0.988528,  0.984636,  0.985860,  0.988741,  0.987765,  0.980792,  0.987147,  0.986450,  0.984128,  0.979893,  0.987396,  0.982911,  0.981444,  0.981295,  0.986223,  0.983352,  0.978024,  0.979287,  0.983936,  0.982470,  0.970929,  0.985349,  0.979454,  0.980314,  0.973428,  0.981633,  0.977816,  0.974501,  0.973774,  0.983274,  0.975674,  0.972269,  0.973770,  0.977324,  0.978477,  0.961231,  0.981492,  0.974450,  0.973348,  0.969317,  0.976556,  0.970923,  0.967744,  0.969460,  0.976994,  0.971817,  0.965860,  0.966467,  0.975046,  0.971346,  0.951653,  0.976225,  0.969159,  0.966962,  0.964594,  0.971092,  0.966477,  0.960987,  0.962925,  0.971606,  0.966767,  0.953779,  0.964258,  0.967811,  0.963791,  0.950990,  0.971464,  0.961374, },
{ 1.000000,  0.999579,  0.999217,  0.999124,  0.998614,  0.997762,  0.997654,  0.997838,  0.997312,  0.995450,  0.996531,  0.996268,  0.995117,  0.993449,  0.996204,  0.994057,  0.993034,  0.993130,  0.994750,  0.993203,  0.990672,  0.991421,  0.993221,  0.992042,  0.986924,  0.993136,  0.990569,  0.990151,  0.986792,  0.990878,  0.988328,  0.986999,  0.986554,  0.991120,  0.986873,  0.984310,  0.985317,  0.988100,  0.987383,  0.977722,  0.989678,  0.984718,  0.983264,  0.981964,  0.985758,  0.982771,  0.979669,  0.980702,  0.986281,  0.981903,  0.977983,  0.978456,  0.984544,  0.981802,  0.968441,  0.984353,  0.979956,  0.977765,  0.976248,  0.981015,  0.976761,  0.973312,  0.974664,  0.981967,  0.977502,  0.967352,  0.975451,  0.977684,  0.974340,  0.965000,  0.980289,  0.973135,  0.969145,  0.971178,  0.977094,  0.972533,  0.965248,  0.968598,  0.975712,  0.972689,  0.960452,  0.973628,  0.970925,  0.967528,  0.957697,  0.976746,  0.967707,  0.962542,  0.963593,  0.975872,  0.966620,  0.958449,  0.961895,  0.970477,  0.967668,  0.949011,  0.972389,  0.964053,  0.963742,  0.952785, },
{ 1.000000,  0.999711,  0.999279,  0.998723,  0.998451,  0.998670,  0.997825,  0.996909,  0.996895,  0.997132,  0.996613,  0.993817,  0.997068,  0.995251,  0.994411,  0.993798,  0.994776,  0.993838,  0.992049,  0.992100,  0.994458,  0.992318,  0.990171,  0.990809,  0.993037,  0.991623,  0.984699,  0.993156,  0.990076,  0.988461,  0.988190,  0.990374,  0.988057,  0.985458,  0.986756,  0.989970,  0.987273,  0.981826,  0.986085,  0.987440,  0.985280,  0.978601,  0.988816,  0.984253,  0.981514,  0.982586,  0.986784,  0.982722,  0.977903,  0.980650,  0.984935,  0.982278,  0.974898,  0.983398,  0.980161,  0.979408,  0.971813,  0.985624,  0.977938,  0.974880,  0.976071,  0.983607,  0.977243,  0.971489,  0.974416,  0.978864,  0.978127,  0.965124,  0.980316,  0.975947,  0.973508,  0.966955,  0.978635,  0.972743,  0.968679,  0.969406,  0.978863,  0.973322,  0.964074,  0.969439,  0.974103,  0.973354,  0.953610,  0.979136,  0.969225,  0.967012,  0.963927,  0.972764,  0.968243,  0.959816,  0.963025,  0.976617,  0.964662,  0.958051,  0.962463,  0.971757,  0.968423,  0.944705,  0.974562,  0.964018, },
{ 1.000000,  0.999623,  0.999277,  0.999115,  0.998584,  0.997945,  0.997746,  0.998189,  0.997294,  0.995745,  0.996216,  0.996823,  0.995904,  0.993132,  0.996421,  0.994618,  0.993556,  0.993710,  0.994783,  0.993199,  0.991085,  0.992127,  0.993709,  0.992150,  0.988956,  0.992160,  0.991185,  0.990179,  0.986566,  0.992708,  0.989243,  0.987620,  0.987620,  0.991063,  0.988122,  0.984505,  0.985890,  0.989035,  0.987666,  0.980383,  0.988857,  0.986366,  0.984318,  0.980578,  0.987860,  0.983579,  0.980990,  0.981602,  0.987471,  0.983019,  0.978230,  0.980949,  0.984555,  0.982458,  0.970868,  0.986877,  0.980042,  0.979066,  0.976058,  0.983089,  0.978643,  0.973462,  0.975730,  0.983671,  0.975801,  0.972931,  0.974495,  0.980756,  0.979132,  0.960876,  0.983939,  0.974726,  0.972236,  0.972962,  0.977583,  0.971861,  0.967476,  0.970951,  0.979869,  0.972008,  0.964592,  0.969531,  0.974722,  0.971671,  0.955186,  0.978881,  0.969320,  0.966175,  0.967508,  0.974073,  0.967929,  0.960272,  0.965169,  0.973586,  0.967672,  0.956275,  0.968161,  0.968157,  0.963715,  0.953164, },
{ 1.000000,  0.999757,  0.999303,  0.998863,  0.998465,  0.998794,  0.997997,  0.997001,  0.997204,  0.997355,  0.996812,  0.994780,  0.996726,  0.995948,  0.994913,  0.993254,  0.995903,  0.994191,  0.992537,  0.993048,  0.994843,  0.993150,  0.990524,  0.991662,  0.993424,  0.991604,  0.986619,  0.993615,  0.990332,  0.989908,  0.987826,  0.991349,  0.988586,  0.986363,  0.987121,  0.992231,  0.986681,  0.985074,  0.985939,  0.988867,  0.987924,  0.977627,  0.990849,  0.985128,  0.983857,  0.983395,  0.986192,  0.983229,  0.980228,  0.982444,  0.987317,  0.981880,  0.978656,  0.981002,  0.984884,  0.981863,  0.970256,  0.986332,  0.980949,  0.977422,  0.977994,  0.983189,  0.978583,  0.973371,  0.976806,  0.982133,  0.977788,  0.970379,  0.978244,  0.979171,  0.975256,  0.967266,  0.983089,  0.972557,  0.972397,  0.970714,  0.980727,  0.973973,  0.966600,  0.972052,  0.977067,  0.974742,  0.961456,  0.976457,  0.972889,  0.969832,  0.962136,  0.976778,  0.968611,  0.964939,  0.967603,  0.976098,  0.970002,  0.960279,  0.965146,  0.973801,  0.967832,  0.950554,  0.976225,  0.965991, },
{ 1.000000,  0.999675,  0.999155,  0.999195,  0.998637,  0.997739,  0.997775,  0.998312,  0.996932,  0.996313,  0.996111,  0.996734,  0.996227,  0.992929,  0.996797,  0.994806,  0.993891,  0.993770,  0.994672,  0.992571,  0.991443,  0.992416,  0.994220,  0.991515,  0.990431,  0.990392,  0.992506,  0.991333,  0.984615,  0.992777,  0.989900,  0.988045,  0.988437,  0.990473,  0.987714,  0.984814,  0.986886,  0.989787,  0.986170,  0.982944,  0.986577,  0.987437,  0.984624,  0.980098,  0.989033,  0.983004,  0.981612,  0.982751,  0.986859,  0.983778,  0.977188,  0.981430,  0.985348,  0.982443,  0.974254,  0.983616,  0.982203,  0.977954,  0.974326,  0.984533,  0.977510,  0.975056,  0.976916,  0.983412,  0.978311,  0.971717,  0.974965,  0.981112,  0.977126,  0.964031,  0.983365,  0.975011,  0.975115,  0.968800,  0.978682,  0.973280,  0.968009,  0.969661,  0.981953,  0.970256,  0.966884,  0.969941,  0.974567,  0.973482,  0.954486,  0.980337,  0.970566,  0.967419,  0.966243,  0.974175,  0.966285,  0.961031,  0.967050,  0.975357,  0.966825,  0.961614,  0.962815,  0.973512,  0.966137,  0.945636, },
{ 1.000000,  0.999756,  0.999367,  0.998894,  0.998624,  0.998432,  0.997960,  0.997050,  0.997087,  0.997513,  0.996400,  0.995008,  0.995927,  0.996043,  0.994731,  0.993310,  0.996041,  0.993968,  0.992412,  0.993415,  0.994265,  0.993183,  0.990286,  0.991878,  0.993124,  0.991406,  0.988423,  0.991822,  0.990892,  0.988448,  0.986726,  0.992637,  0.988287,  0.986177,  0.987926,  0.990796,  0.987914,  0.983889,  0.985897,  0.989224,  0.986094,  0.979644,  0.989889,  0.985351,  0.984122,  0.981181,  0.986661,  0.983211,  0.980357,  0.981329,  0.988311,  0.981405,  0.978545,  0.980243,  0.984392,  0.981997,  0.970737,  0.987240,  0.979992,  0.976757,  0.978240,  0.981939,  0.977747,  0.972948,  0.976676,  0.983278,  0.976134,  0.973386,  0.973775,  0.981597,  0.976191,  0.962275,  0.981996,  0.975875,  0.971860,  0.973165,  0.977594,  0.972196,  0.966880,  0.971676,  0.979835,  0.971991,  0.962584,  0.971988,  0.974456,  0.967972,  0.960979,  0.978446,  0.969011,  0.962650,  0.968904,  0.974052,  0.968916,  0.958768,  0.966276,  0.973666,  0.966798,  0.957017,  0.971658,  0.967324, },
{ 1.000000,  0.999623,  0.999110,  0.999305,  0.998652,  0.997763,  0.997830,  0.998234,  0.997136,  0.996047,  0.996217,  0.996813,  0.995864,  0.993630,  0.996448,  0.994827,  0.994175,  0.992796,  0.994971,  0.993294,  0.991420,  0.992027,  0.994491,  0.991765,  0.989884,  0.990417,  0.992636,  0.991042,  0.985132,  0.993280,  0.989712,  0.987727,  0.988299,  0.989705,  0.988395,  0.984881,  0.986026,  0.990579,  0.986381,  0.983874,  0.984532,  0.989158,  0.985901,  0.976420,  0.989685,  0.984687,  0.981721,  0.983211,  0.985677,  0.982422,  0.978698,  0.981629,  0.986484,  0.981466,  0.975751,  0.980546,  0.983403,  0.978895,  0.972085,  0.985505,  0.979073,  0.974631,  0.978036,  0.982640,  0.977768,  0.970878,  0.975550,  0.981397,  0.976323,  0.969219,  0.979466,  0.975509,  0.972719,  0.966333,  0.982710,  0.973076,  0.968085,  0.971454,  0.980504,  0.972711,  0.965247,  0.969556,  0.975105,  0.972263,  0.959456,  0.977014,  0.971199,  0.967276,  0.962714,  0.974800,  0.968181,  0.962259,  0.964419,  0.976611,  0.968790,  0.958913,  0.964084,  0.970978,  0.967520,  0.947795, },
{ 1.000000,  0.999770,  0.999358,  0.998892,  0.998559,  0.998451,  0.998097,  0.997070,  0.996851,  0.997928,  0.996301,  0.995478,  0.995360,  0.996706,  0.995511,  0.992188,  0.996308,  0.994471,  0.992961,  0.993432,  0.994155,  0.992752,  0.990920,  0.991426,  0.994090,  0.991293,  0.988849,  0.990144,  0.992394,  0.989685,  0.985110,  0.992710,  0.989489,  0.986499,  0.988244,  0.990300,  0.987698,  0.983854,  0.986279,  0.989786,  0.986122,  0.982419,  0.987268,  0.986378,  0.983639,  0.979581,  0.989248,  0.983985,  0.980369,  0.981771,  0.986906,  0.983319,  0.977792,  0.979970,  0.984978,  0.981950,  0.973573,  0.984906,  0.981777,  0.977756,  0.974502,  0.984384,  0.978411,  0.973893,  0.975758,  0.984314,  0.978032,  0.972266,  0.974766,  0.981225,  0.976235,  0.963694,  0.983404,  0.975766,  0.972158,  0.970901,  0.979438,  0.974039,  0.966369,  0.969983,  0.981159,  0.969970,  0.967770,  0.968161,  0.977795,  0.973055,  0.953559,  0.981317,  0.970501,  0.964807,  0.969220,  0.973372,  0.966498,  0.961375,  0.965856,  0.977510,  0.965559,  0.960257,  0.963572,  0.972110, },
{ 1.000000,  0.999658,  0.999001,  0.999333,  0.998707,  0.998072,  0.997988,  0.998108,  0.997354,  0.996255,  0.996321,  0.997208,  0.995895,  0.994652,  0.995436,  0.995371,  0.994126,  0.992650,  0.995644,  0.993508,  0.991969,  0.991975,  0.994705,  0.992406,  0.989669,  0.991185,  0.992548,  0.991401,  0.987087,  0.991964,  0.990714,  0.988737,  0.986288,  0.991645,  0.988590,  0.985347,  0.987304,  0.990907,  0.987631,  0.984027,  0.985466,  0.989354,  0.985601,  0.978778,  0.989474,  0.985115,  0.983426,  0.981672,  0.986880,  0.983006,  0.979120,  0.980972,  0.988790,  0.980289,  0.979068,  0.979255,  0.984898,  0.982062,  0.969400,  0.987262,  0.980259,  0.976366,  0.978348,  0.981438,  0.978020,  0.973099,  0.976855,  0.983536,  0.975710,  0.972892,  0.974580,  0.981117,  0.975501,  0.962622,  0.982597,  0.976796,  0.969447,  0.972640,  0.979052,  0.973512,  0.966223,  0.971210,  0.978292,  0.971100,  0.964732,  0.972543,  0.975053,  0.968270,  0.960880,  0.979499,  0.967702,  0.964500,  0.964882,  0.977016,  0.969387,  0.959590,  0.966254,  0.973452,  0.968464,  0.955500, },
{ 1.000000,  0.999720,  0.999366,  0.998952,  0.998334,  0.998597,  0.997956,  0.997287,  0.997271,  0.997564,  0.996701,  0.995575,  0.995458,  0.996455,  0.995182,  0.992580,  0.996094,  0.994279,  0.993988,  0.992133,  0.994542,  0.992975,  0.990736,  0.991598,  0.994583,  0.990900,  0.990139,  0.989731,  0.992067,  0.991071,  0.984298,  0.993053,  0.989487,  0.987253,  0.988056,  0.989794,  0.986906,  0.984754,  0.986955,  0.990035,  0.985929,  0.984714,  0.984065,  0.988268,  0.986010,  0.976216,  0.988701,  0.985622,  0.981291,  0.982780,  0.986054,  0.982530,  0.978112,  0.981770,  0.985613,  0.980371,  0.977068,  0.981067,  0.982858,  0.978969,  0.973407,  0.985166,  0.978060,  0.975038,  0.977414,  0.982490,  0.979513,  0.970611,  0.975913,  0.981246,  0.977154,  0.967824,  0.979396,  0.977501,  0.972248,  0.968089,  0.981117,  0.972578,  0.969065,  0.971693,  0.979316,  0.973703,  0.966350,  0.968837,  0.977309,  0.971854,  0.957437,  0.979852,  0.970406,  0.969929,  0.963327,  0.974808,  0.969114,  0.961541,  0.964518,  0.978617,  0.965275,  0.962397,  0.963866,  0.970599, },
{ 1.000000,  0.999692,  0.998979,  0.999353,  0.998755,  0.998010,  0.997901,  0.998051,  0.997103,  0.996200,  0.996535,  0.997039,  0.995925,  0.995078,  0.994597,  0.996127,  0.994572,  0.991122,  0.995642,  0.993937,  0.992375,  0.992753,  0.993570,  0.992199,  0.989909,  0.991412,  0.992988,  0.990623,  0.988174,  0.990143,  0.990992,  0.988644,  0.986161,  0.991777,  0.988182,  0.985438,  0.987672,  0.989347,  0.988092,  0.983239,  0.986233,  0.988573,  0.985804,  0.981778,  0.986719,  0.985553,  0.982477,  0.979522,  0.988752,  0.982345,  0.979546,  0.982222,  0.986179,  0.982773,  0.977493,  0.979722,  0.984844,  0.980517,  0.972152,  0.985949,  0.979873,  0.978499,  0.974581,  0.981973,  0.977722,  0.974074,  0.975335,  0.984071,  0.976061,  0.973077,  0.973620,  0.979962,  0.977169,  0.962792,  0.983501,  0.974877,  0.970293,  0.973149,  0.976626,  0.972782,  0.966494,  0.971186,  0.978591,  0.971322,  0.968183,  0.966920,  0.977789,  0.971277,  0.954126,  0.977765,  0.971414,  0.965925,  0.967690,  0.972608,  0.967190,  0.960736,  0.966474,  0.975534,  0.966904,  0.957180, },
{ 1.000000,  0.999662,  0.999422,  0.998919,  0.998295,  0.998807,  0.998010,  0.997192,  0.997380,  0.997456,  0.996746,  0.995456,  0.995861,  0.996558,  0.995141,  0.993718,  0.995548,  0.994500,  0.993328,  0.991715,  0.995221,  0.992939,  0.991155,  0.991743,  0.994128,  0.991732,  0.989424,  0.990190,  0.992267,  0.990347,  0.986179,  0.992491,  0.989330,  0.988393,  0.986241,  0.990481,  0.987874,  0.985148,  0.986502,  0.990292,  0.986411,  0.983951,  0.984443,  0.988326,  0.985881,  0.977294,  0.989597,  0.984913,  0.981542,  0.983034,  0.984612,  0.983717,  0.978845,  0.980224,  0.986337,  0.981284,  0.978590,  0.978635,  0.985172,  0.981049,  0.968466,  0.986099,  0.980279,  0.975841,  0.978282,  0.981125,  0.977408,  0.973077,  0.976736,  0.982310,  0.976326,  0.970586,  0.975269,  0.979232,  0.973621,  0.965852,  0.981853,  0.974299,  0.969261,  0.973161,  0.978093,  0.973551,  0.965543,  0.970650,  0.977105,  0.970755,  0.964885,  0.975569,  0.970452,  0.968218,  0.960492,  0.979162,  0.968514,  0.963061,  0.966767,  0.976236,  0.968865,  0.960473,  0.964198,  0.971381, },
{ 1.000000,  0.999683,  0.999098,  0.999245,  0.998734,  0.998248,  0.997654,  0.998096,  0.997371,  0.996408,  0.996253,  0.997294,  0.996318,  0.994803,  0.994842,  0.995641,  0.994913,  0.991537,  0.995875,  0.993781,  0.992442,  0.992612,  0.993445,  0.992676,  0.990249,  0.990629,  0.993959,  0.990462,  0.989367,  0.989118,  0.992114,  0.990387,  0.984037,  0.992162,  0.988950,  0.986432,  0.988239,  0.989091,  0.986971,  0.984989,  0.985566,  0.989623,  0.985610,  0.982920,  0.984236,  0.987605,  0.984020,  0.978041,  0.988572,  0.983993,  0.980387,  0.982976,  0.985490,  0.982546,  0.977770,  0.980550,  0.984911,  0.980223,  0.976775,  0.982533,  0.980662,  0.978059,  0.973395,  0.984817,  0.978353,  0.974721,  0.976465,  0.982019,  0.978561,  0.972132,  0.974045,  0.980169,  0.976720,  0.967455,  0.981057,  0.976089,  0.972081,  0.969271,  0.979462,  0.972842,  0.968500,  0.970481,  0.979471,  0.973046,  0.967356,  0.968876,  0.976509,  0.971474,  0.956801,  0.979645,  0.970706,  0.966546,  0.966109,  0.974559,  0.969049,  0.961095,  0.964387,  0.976058,  0.964847,  0.963775, },
{ 1.000000,  0.999616,  0.999509,  0.998989,  0.997830,  0.998918,  0.997940,  0.997270,  0.997398,  0.997242,  0.996459,  0.995604,  0.995632,  0.996841,  0.995007,  0.994261,  0.993958,  0.995057,  0.993764,  0.990721,  0.995354,  0.992913,  0.991412,  0.992166,  0.993115,  0.991532,  0.989270,  0.990344,  0.992447,  0.989596,  0.987818,  0.990038,  0.989875,  0.987594,  0.985309,  0.991319,  0.987317,  0.985480,  0.985738,  0.990290,  0.986929,  0.982594,  0.984946,  0.987458,  0.985995,  0.979541,  0.987315,  0.984752,  0.982413,  0.979552,  0.986775,  0.982249,  0.978496,  0.981362,  0.986007,  0.981731,  0.977592,  0.978776,  0.984515,  0.979907,  0.970163,  0.985604,  0.979009,  0.977046,  0.975427,  0.981681,  0.976566,  0.972685,  0.974240,  0.984602,  0.973836,  0.973511,  0.972227,  0.979803,  0.976938,  0.960228,  0.983562,  0.973676,  0.969538,  0.972845,  0.975814,  0.971637,  0.966844,  0.970381,  0.978808,  0.969343,  0.967169,  0.967823,  0.975745,  0.970004,  0.954275,  0.978117,  0.970634,  0.962991,  0.966840,  0.973356,  0.967543,  0.959906,  0.964954,  0.973082, },
{ 1.000000,  0.999679,  0.999293,  0.999030,  0.998818,  0.998277,  0.997533,  0.998332,  0.997093,  0.996716,  0.996392,  0.997345,  0.996240,  0.994727,  0.995201,  0.996007,  0.995020,  0.992805,  0.995211,  0.993986,  0.993117,  0.991545,  0.994332,  0.992064,  0.991125,  0.991647,  0.993243,  0.991636,  0.989108,  0.989116,  0.992311,  0.989834,  0.984691,  0.992459,  0.988638,  0.988766,  0.985940,  0.990004,  0.987494,  0.984357,  0.985908,  0.990884,  0.985359,  0.984761,  0.983144,  0.988019,  0.986614,  0.976030,  0.989822,  0.984301,  0.981210,  0.983060,  0.985360,  0.981055,  0.979364,  0.981303,  0.986094,  0.980540,  0.980139,  0.977734,  0.983996,  0.981590,  0.968567,  0.984886,  0.981040,  0.975550,  0.978139,  0.981783,  0.977476,  0.972617,  0.976536,  0.982070,  0.974664,  0.972353,  0.975935,  0.978116,  0.973789,  0.967656,  0.981301,  0.972251,  0.969895,  0.972638,  0.978265,  0.975818,  0.964864,  0.970243,  0.977433,  0.972510,  0.962498,  0.975891,  0.972676,  0.966485,  0.963224,  0.976824,  0.966998,  0.964464,  0.967209,  0.975354,  0.969626,  0.961471, },
{ 1.000000,  0.999667,  0.999572,  0.999080,  0.998172,  0.999042,  0.998153,  0.997960,  0.997052,  0.997706,  0.996980,  0.995958,  0.995973,  0.997350,  0.995522,  0.994902,  0.994549,  0.995545,  0.995154,  0.990897,  0.996170,  0.993890,  0.992669,  0.992522,  0.993822,  0.992001,  0.990518,  0.991585,  0.993317,  0.991447,  0.990138,  0.989066,  0.992718,  0.990198,  0.983425,  0.992386,  0.990032,  0.987664,  0.988195,  0.989816,  0.988171,  0.984865,  0.986820,  0.989824,  0.986338,  0.983162,  0.985880,  0.987522,  0.984583,  0.980816,  0.988920,  0.984077,  0.981162,  0.983939,  0.985884,  0.985365,  0.978570,  0.981971,  0.985776,  0.982413,  0.977262,  0.984103,  0.982024,  0.978580,  0.975003,  0.986624,  0.978343,  0.975879,  0.979365,  0.983412,  0.980238,  0.973459,  0.975186,  0.982773,  0.978060,  0.967064,  0.985095,  0.976227,  0.975994,  0.970928,  0.979772,  0.974683,  0.971090,  0.972130,  0.982277,  0.973768,  0.970164,  0.970142,  0.978182,  0.975709,  0.957694,  0.983100,  0.972277,  0.967558,  0.970918,  0.974895,  0.970040,  0.964457,  0.967951,  0.977360, },
{ 1.000000,  0.999739,  0.999279,  0.998791,  0.999043,  0.998575,  0.996841,  0.998278,  0.997611,  0.996834,  0.996748,  0.996945,  0.996031,  0.994954,  0.995252,  0.996531,  0.994995,  0.992979,  0.994101,  0.994535,  0.993146,  0.990906,  0.994987,  0.992414,  0.990555,  0.992170,  0.992754,  0.992100,  0.988448,  0.990005,  0.992313,  0.990138,  0.986851,  0.991502,  0.989115,  0.987698,  0.984681,  0.991940,  0.987392,  0.984831,  0.986414,  0.990606,  0.986853,  0.982709,  0.984009,  0.988290,  0.985812,  0.978107,  0.990041,  0.983246,  0.983058,  0.979948,  0.986708,  0.982854,  0.978692,  0.981315,  0.986606,  0.981802,  0.977709,  0.978394,  0.984393,  0.982181,  0.967971,  0.987636,  0.979627,  0.975396,  0.978671,  0.980137,  0.979171,  0.972701,  0.974051,  0.983169,  0.977387,  0.972845,  0.972699,  0.981598,  0.978243,  0.958004,  0.983762,  0.975522,  0.970047,  0.974348,  0.976931,  0.972892,  0.967184,  0.971734,  0.978843,  0.972689,  0.964374,  0.970459,  0.974644,  0.969893,  0.958114,  0.979551,  0.969000,  0.964148,  0.969327,  0.974647,  0.969906,  0.959047, },
{ 1.000000,  0.999718,  0.999467,  0.999099,  0.998569,  0.998929,  0.998050,  0.997882,  0.996922,  0.998230,  0.996823,  0.996256,  0.996479,  0.997095,  0.996075,  0.994614,  0.994850,  0.995597,  0.995279,  0.992277,  0.996011,  0.993599,  0.993281,  0.992064,  0.994245,  0.992460,  0.991284,  0.991586,  0.993900,  0.992237,  0.989459,  0.990203,  0.991789,  0.991615,  0.984348,  0.993915,  0.989077,  0.987986,  0.988793,  0.989975,  0.988697,  0.985472,  0.986075,  0.991546,  0.986692,  0.984975,  0.984562,  0.989263,  0.988088,  0.977303,  0.990392,  0.984861,  0.982537,  0.985969,  0.986025,  0.983404,  0.981389,  0.981992,  0.986977,  0.983113,  0.979026,  0.981147,  0.984178,  0.982109,  0.972656,  0.987385,  0.980108,  0.977606,  0.981343,  0.983074,  0.979711,  0.974410,  0.977847,  0.982689,  0.978268,  0.973402,  0.981663,  0.976862,  0.976557,  0.969856,  0.984204,  0.974695,  0.972649,  0.975059,  0.980304,  0.977004,  0.968913,  0.971220,  0.978523,  0.976406,  0.963731,  0.981590,  0.972677,  0.970877,  0.967268,  0.978738,  0.970097,  0.967060,  0.969943,  0.978533, },
{ 1.000000,  0.999746,  0.999230,  0.999011,  0.999023,  0.998725,  0.997185,  0.998711,  0.997529,  0.997073,  0.996734,  0.997440,  0.996402,  0.995273,  0.995371,  0.996651,  0.995128,  0.994485,  0.993903,  0.995436,  0.995157,  0.989728,  0.996373,  0.992773,  0.991964,  0.993147,  0.993139,  0.991286,  0.990611,  0.990840,  0.993376,  0.990576,  0.989285,  0.989385,  0.990804,  0.990250,  0.983924,  0.993000,  0.988230,  0.987163,  0.988638,  0.989630,  0.987711,  0.984435,  0.986283,  0.989182,  0.986189,  0.983308,  0.987044,  0.985520,  0.984477,  0.980645,  0.989428,  0.983058,  0.982023,  0.982312,  0.987724,  0.984046,  0.978114,  0.981679,  0.984164,  0.984412,  0.974815,  0.986213,  0.980467,  0.980148,  0.975805,  0.984947,  0.978613,  0.975657,  0.979459,  0.983685,  0.979342,  0.974313,  0.976148,  0.982235,  0.978751,  0.965522,  0.985404,  0.975139,  0.975349,  0.973350,  0.980310,  0.973656,  0.970596,  0.972065,  0.982838,  0.972531,  0.971624,  0.970237,  0.977842,  0.977235,  0.955170,  0.984449,  0.970481,  0.968368,  0.972278,  0.974111,  0.969687,  0.965809, },
{ 1.000000,  0.999729,  0.999491,  0.999081,  0.998689,  0.998465,  0.998424,  0.998124,  0.996312,  0.998226,  0.997070,  0.996283,  0.996526,  0.996795,  0.995855,  0.994599,  0.995231,  0.995800,  0.994656,  0.993250,  0.994743,  0.994087,  0.993464,  0.990907,  0.995446,  0.991529,  0.991476,  0.991328,  0.993913,  0.991956,  0.988672,  0.990586,  0.991855,  0.991520,  0.986677,  0.992048,  0.988922,  0.988868,  0.986047,  0.991366,  0.987019,  0.986289,  0.988087,  0.989800,  0.987604,  0.984107,  0.984804,  0.988773,  0.986874,  0.978199,  0.990664,  0.983480,  0.985657,  0.981340,  0.987473,  0.983312,  0.979494,  0.982473,  0.988337,  0.981931,  0.980584,  0.979306,  0.984600,  0.985039,  0.968935,  0.988796,  0.979695,  0.977804,  0.980122,  0.982971,  0.976928,  0.975503,  0.978595,  0.983242,  0.978107,  0.976587,  0.974696,  0.980440,  0.980597,  0.962102,  0.983891,  0.977596,  0.972211,  0.976232,  0.979495,  0.974280,  0.968947,  0.974522,  0.979318,  0.972794,  0.968809,  0.973909,  0.974597,  0.972762,  0.963058,  0.981115,  0.968122,  0.967229,  0.971403,  0.976823, },
{ 1.000000,  0.999771,  0.999157,  0.999067,  0.999006,  0.998745,  0.997586,  0.998381,  0.997661,  0.997118,  0.996314,  0.997625,  0.996105,  0.995665,  0.995925,  0.996502,  0.995530,  0.993952,  0.994085,  0.995455,  0.994862,  0.990643,  0.996169,  0.992299,  0.993555,  0.991305,  0.993859,  0.991724,  0.990126,  0.990820,  0.994038,  0.990507,  0.989575,  0.989460,  0.990824,  0.991737,  0.982779,  0.993563,  0.988434,  0.987855,  0.987830,  0.989942,  0.986622,  0.984976,  0.987227,  0.989287,  0.987187,  0.985310,  0.983885,  0.988084,  0.986869,  0.975543,  0.989489,  0.984950,  0.982986,  0.984432,  0.985709,  0.983113,  0.979681,  0.982740,  0.985612,  0.982340,  0.977696,  0.981441,  0.982236,  0.981171,  0.974795,  0.986354,  0.978296,  0.976034,  0.980610,  0.981897,  0.981214,  0.972867,  0.978203,  0.981086,  0.979431,  0.971581,  0.980805,  0.976129,  0.975339,  0.969024,  0.984059,  0.972573,  0.971186,  0.976516,  0.979491,  0.975494,  0.968470,  0.971013,  0.978304,  0.975702,  0.960550,  0.983223,  0.969137,  0.973507,  0.966146,  0.976776,  0.969076,  0.966170, },
{ 1.000000,  0.999714,  0.999513,  0.999096,  0.998666,  0.998446,  0.998396,  0.998284,  0.996282,  0.998416,  0.996733,  0.996406,  0.996567,  0.996570,  0.995546,  0.994739,  0.995215,  0.995817,  0.994899,  0.994013,  0.993338,  0.994758,  0.994421,  0.989157,  0.994985,  0.992547,  0.991885,  0.992434,  0.992552,  0.990916,  0.989760,  0.990936,  0.992381,  0.990986,  0.987533,  0.989499,  0.989645,  0.989346,  0.985283,  0.992277,  0.986941,  0.985875,  0.988536,  0.988659,  0.987847,  0.983601,  0.986054,  0.987764,  0.986631,  0.981924,  0.988235,  0.983922,  0.984339,  0.979601,  0.989157,  0.982551,  0.980751,  0.983311,  0.987078,  0.982805,  0.978632,  0.980517,  0.983979,  0.983487,  0.973321,  0.987827,  0.977451,  0.981066,  0.975832,  0.983634,  0.978453,  0.974920,  0.978931,  0.983018,  0.978532,  0.974353,  0.975478,  0.980094,  0.980596,  0.963072,  0.986234,  0.974123,  0.973364,  0.975903,  0.977213,  0.975033,  0.969741,  0.972049,  0.979344,  0.974687,  0.970593,  0.970079,  0.977375,  0.977149,  0.953991,  0.982252,  0.970439,  0.968565,  0.972820,  0.973476, },
{ 1.000000,  0.999730,  0.999273,  0.999166,  0.999008,  0.998746,  0.997829,  0.997940,  0.997709,  0.997517,  0.995936,  0.998019,  0.996082,  0.995720,  0.996329,  0.996231,  0.995489,  0.993743,  0.994678,  0.994986,  0.994499,  0.992359,  0.995185,  0.992475,  0.993020,  0.990398,  0.995280,  0.991088,  0.990536,  0.991940,  0.992982,  0.991332,  0.988443,  0.989816,  0.990691,  0.991323,  0.985272,  0.992845,  0.987694,  0.988851,  0.986024,  0.990233,  0.986977,  0.985390,  0.987194,  0.989171,  0.987931,  0.983462,  0.985283,  0.986717,  0.987923,  0.976569,  0.991150,  0.982895,  0.983011,  0.984313,  0.985396,  0.983491,  0.979218,  0.981699,  0.986595,  0.982308,  0.979275,  0.979621,  0.984088,  0.984648,  0.969464,  0.987639,  0.978509,  0.977258,  0.982469,  0.981009,  0.977951,  0.975756,  0.978461,  0.981422,  0.979198,  0.973076,  0.976155,  0.978227,  0.978369,  0.965323,  0.985027,  0.973656,  0.971795,  0.978147,  0.977936,  0.974372,  0.968511,  0.974309,  0.976438,  0.974401,  0.967170,  0.977803,  0.970469,  0.972465,  0.963590,  0.981411,  0.967900,  0.967202, },
{ 1.000000,  0.999766,  0.999461,  0.999073,  0.998471,  0.998432,  0.998297,  0.998068,  0.996629,  0.998289,  0.996524,  0.996552,  0.995615,  0.997043,  0.995122,  0.994613,  0.995260,  0.995792,  0.994726,  0.993156,  0.993580,  0.994221,  0.994085,  0.989065,  0.995768,  0.991157,  0.991817,  0.991461,  0.993080,  0.990532,  0.988689,  0.990484,  0.991847,  0.989805,  0.988564,  0.988280,  0.990105,  0.991056,  0.980692,  0.993685,  0.985942,  0.986106,  0.988943,  0.987757,  0.985095,  0.984051,  0.986600,  0.987776,  0.985563,  0.983124,  0.983794,  0.984442,  0.985914,  0.975686,  0.989719,  0.981158,  0.981229,  0.984844,  0.983833,  0.981852,  0.977843,  0.981976,  0.982663,  0.981053,  0.976318,  0.982488,  0.978563,  0.979244,  0.973609,  0.985940,  0.975415,  0.975826,  0.977703,  0.982045,  0.978493,  0.970486,  0.977264,  0.977077,  0.979998,  0.966581,  0.983099,  0.972107,  0.975490,  0.968827,  0.980460,  0.970927,  0.968703,  0.976035,  0.977051,  0.973759,  0.967342,  0.971074,  0.975957,  0.973877,  0.956302,  0.982577,  0.965820,  0.970458,  0.968138,  0.974946, },
{ 1.000000,  0.999723,  0.999289,  0.999153,  0.999177,  0.998645,  0.998127,  0.997924,  0.998003,  0.997982,  0.995348,  0.998352,  0.996131,  0.996174,  0.996450,  0.996108,  0.995246,  0.994501,  0.995362,  0.995419,  0.994579,  0.993461,  0.993527,  0.993804,  0.994506,  0.989114,  0.995223,  0.992208,  0.991483,  0.992643,  0.992486,  0.991418,  0.989355,  0.991261,  0.991183,  0.990731,  0.987766,  0.990936,  0.989073,  0.989985,  0.985407,  0.992421,  0.986059,  0.987245,  0.987531,  0.989602,  0.988448,  0.983328,  0.987245,  0.987027,  0.988278,  0.981176,  0.989408,  0.983389,  0.985849,  0.981237,  0.987968,  0.981855,  0.982218,  0.985343,  0.985145,  0.984262,  0.979506,  0.981325,  0.984669,  0.983632,  0.972371,  0.988409,  0.977522,  0.983683,  0.977430,  0.983583,  0.978866,  0.974973,  0.979916,  0.984065,  0.978950,  0.976476,  0.976266,  0.980021,  0.983022,  0.962727,  0.986601,  0.974470,  0.975410,  0.978253,  0.978519,  0.972724,  0.972133,  0.977138,  0.977843,  0.975656,  0.973117,  0.971675,  0.974946,  0.979778,  0.956482,  0.981181,  0.973072,  0.969787, },
{ 1.000000,  0.999792,  0.999452,  0.999133,  0.998604,  0.998656,  0.998542,  0.998095,  0.997287,  0.997652,  0.997149,  0.997163,  0.995572,  0.997448,  0.995337,  0.995460,  0.995786,  0.995854,  0.995752,  0.993057,  0.994451,  0.994675,  0.994642,  0.991165,  0.995156,  0.992402,  0.992681,  0.990647,  0.994260,  0.990483,  0.991086,  0.991719,  0.992305,  0.991493,  0.988377,  0.989463,  0.991559,  0.990958,  0.983794,  0.993698,  0.986577,  0.990228,  0.986447,  0.989800,  0.986924,  0.984951,  0.986719,  0.990302,  0.986527,  0.984550,  0.985559,  0.986259,  0.988636,  0.975542,  0.991195,  0.983188,  0.984293,  0.984250,  0.985483,  0.981683,  0.980449,  0.984373,  0.984564,  0.984008,  0.980819,  0.979958,  0.983203,  0.984265,  0.968701,  0.986517,  0.980088,  0.979629,  0.982084,  0.980712,  0.979147,  0.975349,  0.979971,  0.981112,  0.979421,  0.972253,  0.978459,  0.976992,  0.978483,  0.969860,  0.983821,  0.973073,  0.972575,  0.978226,  0.977118,  0.978543,  0.968479,  0.975359,  0.976030,  0.976737,  0.966143,  0.979570,  0.970236,  0.973063,  0.964304,  0.981887, },
{ 1.000000,  0.999713,  0.999361,  0.999171,  0.998984,  0.998739,  0.997893,  0.997897,  0.998082,  0.997696,  0.995805,  0.998217,  0.995845,  0.996848,  0.995292,  0.996387,  0.994839,  0.994511,  0.994769,  0.995826,  0.994441,  0.993146,  0.993410,  0.994140,  0.994342,  0.988448,  0.995904,  0.991162,  0.991698,  0.992342,  0.992152,  0.990269,  0.989279,  0.990918,  0.991603,  0.990749,  0.989044,  0.988314,  0.990252,  0.990948,  0.981467,  0.991674,  0.987291,  0.987637,  0.989100,  0.987637,  0.985607,  0.984816,  0.987242,  0.988106,  0.987139,  0.981670,  0.985634,  0.984131,  0.985625,  0.979251,  0.989550,  0.980932,  0.981656,  0.985275,  0.983710,  0.984207,  0.978507,  0.982168,  0.983036,  0.982847,  0.975771,  0.986325,  0.977772,  0.981207,  0.973541,  0.986392,  0.976807,  0.976942,  0.979913,  0.982631,  0.979618,  0.973365,  0.976152,  0.980155,  0.979781,  0.967215,  0.985987,  0.970906,  0.978971,  0.971239,  0.979668,  0.973183,  0.970573,  0.976193,  0.978647,  0.975535,  0.969244,  0.971838,  0.976109,  0.977406,  0.955646,  0.984338,  0.968438,  0.970941, },
{ 1.000000,  0.999809,  0.999458,  0.999197,  0.998697,  0.998642,  0.998614,  0.998199,  0.997579,  0.997426,  0.997598,  0.997654,  0.994405,  0.997840,  0.995779,  0.995724,  0.996456,  0.995486,  0.994690,  0.994118,  0.995125,  0.994811,  0.994488,  0.992440,  0.993686,  0.993003,  0.993644,  0.989758,  0.995167,  0.990738,  0.991237,  0.992855,  0.992055,  0.991422,  0.988858,  0.990496,  0.990901,  0.990361,  0.987211,  0.993007,  0.986505,  0.989825,  0.985126,  0.992798,  0.985659,  0.986852,  0.988648,  0.989186,  0.987775,  0.983709,  0.985631,  0.986929,  0.987889,  0.980181,  0.990859,  0.982013,  0.986365,  0.981839,  0.986701,  0.982201,  0.981921,  0.984065,  0.985925,  0.984612,  0.979039,  0.982222,  0.983118,  0.984881,  0.970835,  0.989292,  0.977352,  0.980902,  0.982034,  0.981262,  0.979365,  0.975773,  0.978790,  0.983842,  0.978566,  0.975737,  0.976992,  0.979747,  0.982664,  0.964198,  0.985804,  0.973086,  0.975461,  0.981620,  0.976895,  0.973712,  0.973082,  0.976350,  0.978484,  0.975504,  0.969705,  0.974564,  0.973380,  0.976503,  0.961104,  0.983277, },
{ 1.000000,  0.999747,  0.999410,  0.999294,  0.998951,  0.998710,  0.998050,  0.998189,  0.997989,  0.997723,  0.996604,  0.997894,  0.996110,  0.996720,  0.995115,  0.997351,  0.994888,  0.995213,  0.995589,  0.995234,  0.995103,  0.992899,  0.993626,  0.994377,  0.994346,  0.990746,  0.995670,  0.991468,  0.992866,  0.990699,  0.993764,  0.990363,  0.990292,  0.991488,  0.992466,  0.991143,  0.988163,  0.989794,  0.990970,  0.990753,  0.983001,  0.993650,  0.986497,  0.988884,  0.988110,  0.989707,  0.986781,  0.984619,  0.987123,  0.988857,  0.986571,  0.984776,  0.985305,  0.986932,  0.988947,  0.974764,  0.992083,  0.981692,  0.983734,  0.987338,  0.984158,  0.981414,  0.981067,  0.984380,  0.985356,  0.982680,  0.979746,  0.981735,  0.980895,  0.984132,  0.971217,  0.987932,  0.977763,  0.979520,  0.983816,  0.980413,  0.979505,  0.975491,  0.979620,  0.980322,  0.979241,  0.973045,  0.981917,  0.974941,  0.977981,  0.971164,  0.984460,  0.972377,  0.975096,  0.976473,  0.979191,  0.977716,  0.967649,  0.975768,  0.975451,  0.978817,  0.964260,  0.982529,  0.969053,  0.975900, },
{ 1.000000,  0.999730,  0.999575,  0.999036,  0.998778,  0.998847,  0.998609,  0.998246,  0.997429,  0.997452,  0.997754,  0.997308,  0.994978,  0.997812,  0.995524,  0.996192,  0.995605,  0.995920,  0.994671,  0.993996,  0.994557,  0.995675,  0.994152,  0.993067,  0.993177,  0.993818,  0.994621,  0.987635,  0.995808,  0.990724,  0.991714,  0.993028,  0.991344,  0.990437,  0.989434,  0.991466,  0.991380,  0.990338,  0.988404,  0.989324,  0.989408,  0.991106,  0.981897,  0.992030,  0.987429,  0.986877,  0.989493,  0.987992,  0.987047,  0.984362,  0.987075,  0.986828,  0.987095,  0.982214,  0.987914,  0.983834,  0.986249,  0.979999,  0.989284,  0.980385,  0.983370,  0.983604,  0.985014,  0.985527,  0.977549,  0.983193,  0.982848,  0.985178,  0.975633,  0.986582,  0.977888,  0.982393,  0.976710,  0.984097,  0.976527,  0.978724,  0.981839,  0.980716,  0.981341,  0.974309,  0.976622,  0.981594,  0.980024,  0.966007,  0.985675,  0.971841,  0.981059,  0.973735,  0.979309,  0.974388,  0.970109,  0.976139,  0.981111,  0.975504,  0.971841,  0.972425,  0.976210,  0.980424,  0.955411,  0.984108, },
{ 1.000000,  0.999747,  0.999467,  0.999317,  0.998992,  0.998447,  0.998235,  0.998311,  0.998014,  0.997784,  0.997244,  0.996907,  0.996759,  0.997548,  0.993932,  0.997215,  0.995552,  0.995249,  0.996220,  0.995145,  0.994486,  0.993558,  0.994659,  0.994384,  0.993985,  0.992167,  0.993929,  0.991948,  0.993526,  0.990140,  0.994408,  0.989583,  0.991444,  0.992236,  0.991668,  0.992563,  0.987433,  0.990493,  0.990401,  0.991609,  0.985576,  0.992502,  0.987345,  0.988786,  0.986174,  0.991058,  0.985039,  0.987585,  0.988079,  0.988403,  0.988389,  0.983609,  0.985230,  0.987747,  0.988127,  0.977900,  0.991840,  0.980799,  0.987591,  0.982816,  0.986099,  0.982542,  0.980602,  0.983210,  0.987181,  0.983335,  0.980441,  0.982345,  0.981689,  0.986496,  0.969213,  0.989392,  0.977924,  0.981296,  0.982551,  0.981200,  0.977455,  0.976421,  0.981583,  0.980940,  0.981509,  0.977210,  0.976885,  0.979176,  0.982240,  0.962348,  0.984188,  0.975128,  0.977115,  0.981446,  0.976129,  0.975603,  0.971679,  0.977182,  0.976746,  0.977887,  0.967828,  0.976494,  0.971949,  0.976486, },
{ 1.000000,  0.999735,  0.999669,  0.999014,  0.998936,  0.998868,  0.998526,  0.998523,  0.997374,  0.997798,  0.997469,  0.997749,  0.996068,  0.997622,  0.995623,  0.996277,  0.994993,  0.997248,  0.994160,  0.995009,  0.995401,  0.995202,  0.995164,  0.992712,  0.993468,  0.994309,  0.994505,  0.990005,  0.996217,  0.990284,  0.993667,  0.991294,  0.992727,  0.990511,  0.990311,  0.991003,  0.992688,  0.991238,  0.988917,  0.990035,  0.990003,  0.992278,  0.982688,  0.994099,  0.986095,  0.988413,  0.990303,  0.988147,  0.986789,  0.985458,  0.987691,  0.988399,  0.988417,  0.985599,  0.985404,  0.986570,  0.989285,  0.975950,  0.989931,  0.982663,  0.985222,  0.988027,  0.984243,  0.982375,  0.981962,  0.984519,  0.984227,  0.986424,  0.978234,  0.983599,  0.979765,  0.984038,  0.976333,  0.987760,  0.976252,  0.980114,  0.983635,  0.980758,  0.982724,  0.975500,  0.980071,  0.978926,  0.982758,  0.972906,  0.985975,  0.972968,  0.979641,  0.971672,  0.985375,  0.972650,  0.976127,  0.977948,  0.980544,  0.978854,  0.971012,  0.974084,  0.976638,  0.980221,  0.965008,  0.985960, },
{ 1.000000,  0.999729,  0.999605,  0.999142,  0.999198,  0.998681,  0.998357,  0.998365,  0.998327,  0.998059,  0.997214,  0.997228,  0.997104,  0.997688,  0.994341,  0.998138,  0.995236,  0.995963,  0.996235,  0.995365,  0.995251,  0.994211,  0.994220,  0.995340,  0.995015,  0.993248,  0.993560,  0.993664,  0.995319,  0.987590,  0.995963,  0.991060,  0.992102,  0.993878,  0.991954,  0.990913,  0.990313,  0.991707,  0.991098,  0.992453,  0.987835,  0.990832,  0.988739,  0.991211,  0.985031,  0.993185,  0.986139,  0.988643,  0.989870,  0.989042,  0.989099,  0.985150,  0.987238,  0.986867,  0.989094,  0.982963,  0.992182,  0.981371,  0.987896,  0.981239,  0.991711,  0.981337,  0.984773,  0.985595,  0.986734,  0.986361,  0.980275,  0.982366,  0.983272,  0.987265,  0.976498,  0.990441,  0.977450,  0.984681,  0.979475,  0.984738,  0.979332,  0.979967,  0.981064,  0.983977,  0.983999,  0.975921,  0.979987,  0.979691,  0.985145,  0.966694,  0.988988,  0.973242,  0.979756,  0.981153,  0.978455,  0.978343,  0.974227,  0.975373,  0.982338,  0.978797,  0.973255,  0.975539,  0.976741,  0.983388, },
{ 1.000000,  0.999674,  0.999754,  0.999110,  0.998948,  0.999092,  0.998574,  0.998288,  0.997939,  0.997836,  0.997857,  0.997732,  0.996481,  0.997147,  0.996453,  0.997003,  0.994220,  0.997621,  0.994857,  0.995370,  0.996064,  0.995354,  0.995206,  0.993301,  0.994123,  0.994219,  0.994795,  0.991778,  0.995695,  0.991200,  0.993627,  0.990322,  0.995499,  0.990352,  0.992072,  0.991827,  0.992285,  0.992954,  0.988534,  0.989636,  0.990951,  0.992288,  0.986230,  0.994446,  0.986901,  0.990390,  0.987093,  0.991535,  0.986612,  0.987560,  0.987852,  0.990395,  0.989612,  0.984359,  0.986532,  0.988054,  0.989327,  0.978002,  0.993053,  0.982481,  0.986765,  0.985650,  0.987617,  0.984793,  0.982245,  0.983157,  0.987226,  0.986013,  0.981704,  0.982756,  0.984172,  0.988613,  0.970042,  0.991938,  0.978059,  0.981865,  0.986174,  0.982210,  0.979610,  0.979780,  0.981317,  0.983102,  0.982969,  0.976816,  0.980775,  0.977708,  0.983953,  0.967696,  0.987842,  0.974551,  0.978909,  0.982233,  0.979561,  0.979365,  0.973733,  0.976769,  0.977818,  0.980351,  0.970953,  0.981895, },
{ 1.000000,  0.999690,  0.999591,  0.999108,  0.999404,  0.998609,  0.998602,  0.998167,  0.998507,  0.998425,  0.996734,  0.997293,  0.997163,  0.997813,  0.995280,  0.997782,  0.995440,  0.996317,  0.994762,  0.996635,  0.994575,  0.994443,  0.994909,  0.995505,  0.995453,  0.992679,  0.993371,  0.994519,  0.994424,  0.989110,  0.996114,  0.991016,  0.992888,  0.992055,  0.992953,  0.991272,  0.990132,  0.990207,  0.993591,  0.991964,  0.988910,  0.989674,  0.990610,  0.992696,  0.981498,  0.994837,  0.986770,  0.988677,  0.990137,  0.988689,  0.988068,  0.986490,  0.987777,  0.989139,  0.988906,  0.984509,  0.986726,  0.986592,  0.989335,  0.976324,  0.991357,  0.984517,  0.984193,  0.986834,  0.986319,  0.985916,  0.981202,  0.983376,  0.984109,  0.986621,  0.978659,  0.986879,  0.980912,  0.984379,  0.976741,  0.989529,  0.977170,  0.982072,  0.979565,  0.984297,  0.986395,  0.973833,  0.980956,  0.980359,  0.985199,  0.972547,  0.986548,  0.974932,  0.980875,  0.974576,  0.983651,  0.974555,  0.977834,  0.978526,  0.980224,  0.982690,  0.971719,  0.974215,  0.979920,  0.980008, },
{ 1.000000,  0.999603,  0.999779,  0.999112,  0.999249,  0.998696,  0.998914,  0.998275,  0.997837,  0.997777,  0.998462,  0.997777,  0.996803,  0.996769,  0.996914,  0.997585,  0.993452,  0.998068,  0.994968,  0.995498,  0.995922,  0.995677,  0.994177,  0.994018,  0.994431,  0.995099,  0.995035,  0.992798,  0.993098,  0.993300,  0.995124,  0.987169,  0.995494,  0.991918,  0.991586,  0.993224,  0.992476,  0.991648,  0.989619,  0.990674,  0.991708,  0.991686,  0.987759,  0.991474,  0.988566,  0.990778,  0.985614,  0.993611,  0.985453,  0.988740,  0.988322,  0.989991,  0.991901,  0.982822,  0.986827,  0.987928,  0.990386,  0.980841,  0.991495,  0.984220,  0.985792,  0.982687,  0.990599,  0.981646,  0.985568,  0.984021,  0.987866,  0.988028,  0.979581,  0.981926,  0.986044,  0.986768,  0.973353,  0.992213,  0.977590,  0.986183,  0.979535,  0.985423,  0.980602,  0.978587,  0.979176,  0.987463,  0.983480,  0.976993,  0.980274,  0.979652,  0.985995,  0.964537,  0.990046,  0.975761,  0.979771,  0.979807,  0.981421,  0.976073,  0.974966,  0.977928,  0.981189,  0.982917,  0.973642,  0.975426, },
{ 1.000000,  0.999773,  0.999589,  0.998792,  0.999466,  0.998724,  0.998627,  0.998673,  0.998349,  0.997984,  0.997243,  0.997364,  0.997544,  0.997636,  0.995576,  0.996833,  0.996115,  0.996445,  0.994475,  0.997567,  0.994281,  0.994864,  0.995106,  0.995375,  0.996025,  0.992431,  0.993958,  0.993997,  0.995044,  0.990827,  0.995463,  0.991634,  0.992419,  0.990318,  0.995991,  0.989745,  0.991453,  0.991665,  0.993019,  0.993185,  0.987787,  0.989397,  0.991844,  0.991698,  0.984516,  0.995484,  0.986325,  0.990711,  0.987184,  0.991113,  0.987077,  0.986751,  0.987077,  0.991528,  0.989684,  0.984142,  0.986690,  0.987679,  0.990297,  0.976698,  0.993888,  0.982645,  0.985356,  0.987290,  0.986878,  0.984084,  0.982183,  0.983513,  0.987936,  0.988013,  0.980466,  0.982522,  0.985290,  0.987411,  0.969752,  0.989782,  0.979992,  0.982963,  0.985340,  0.983610,  0.980313,  0.979203,  0.980759,  0.983608,  0.985712,  0.973434,  0.981495,  0.978607,  0.981432,  0.971971,  0.989322,  0.973689,  0.978008,  0.979954,  0.980955,  0.982917,  0.971923,  0.977107,  0.977694,  0.982332, },
{ 1.000000,  0.999657,  0.999740,  0.999224,  0.999173,  0.998469,  0.999394,  0.998195,  0.998191,  0.997874,  0.998578,  0.998089,  0.996496,  0.996883,  0.997167,  0.997631,  0.994608,  0.998489,  0.994743,  0.996503,  0.994785,  0.996749,  0.994904,  0.994008,  0.994864,  0.996308,  0.995368,  0.992372,  0.993784,  0.993955,  0.995660,  0.987828,  0.997368,  0.991245,  0.992633,  0.992960,  0.993296,  0.992159,  0.990337,  0.990205,  0.993986,  0.993311,  0.988095,  0.990762,  0.991339,  0.993794,  0.980787,  0.995847,  0.987664,  0.989053,  0.990979,  0.990945,  0.987714,  0.986864,  0.988545,  0.989499,  0.991464,  0.982551,  0.988808,  0.986814,  0.988890,  0.979656,  0.994170,  0.982776,  0.986164,  0.986450,  0.989124,  0.987348,  0.981249,  0.984692,  0.984464,  0.988719,  0.977395,  0.992721,  0.978306,  0.985584,  0.976719,  0.993716,  0.978213,  0.982508,  0.982097,  0.987873,  0.985877,  0.975508,  0.979765,  0.981882,  0.987029,  0.971368,  0.991679,  0.975153,  0.983042,  0.975718,  0.985902,  0.977530,  0.977206,  0.978310,  0.985761,  0.984305,  0.971151,  0.978404, },
{ 1.000000,  0.999757,  0.999703,  0.998793,  0.999702,  0.998644,  0.998714,  0.998583,  0.998582,  0.998148,  0.997411,  0.997284,  0.998404,  0.997704,  0.996083,  0.996771,  0.996690,  0.997746,  0.992971,  0.998430,  0.994677,  0.995180,  0.996285,  0.995931,  0.994527,  0.994031,  0.994258,  0.995146,  0.995503,  0.991551,  0.994396,  0.992997,  0.994260,  0.988548,  0.997057,  0.990842,  0.991812,  0.993364,  0.993495,  0.992424,  0.989129,  0.991132,  0.990720,  0.993212,  0.986585,  0.995317,  0.986973,  0.990861,  0.985644,  0.995981,  0.986302,  0.988857,  0.989105,  0.991180,  0.991256,  0.983852,  0.986742,  0.987875,  0.991781,  0.980771,  0.994784,  0.983287,  0.987710,  0.983383,  0.991659,  0.983529,  0.983728,  0.985713,  0.990088,  0.988292,  0.979888,  0.984800,  0.985138,  0.989024,  0.971814,  0.994540,  0.979056,  0.984208,  0.982811,  0.988368,  0.982347,  0.978875,  0.981103,  0.987142,  0.985032,  0.977255,  0.981625,  0.982251,  0.988774,  0.963625,  0.994041,  0.974958,  0.979537,  0.984689,  0.983196,  0.976183,  0.977266,  0.979780,  0.982754,  0.983392, },
{ 1.000000,  0.999717,  0.999609,  0.999313,  0.999356,  0.998128,  0.999488,  0.998194,  0.998268,  0.998427,  0.998347,  0.997899,  0.996798,  0.997302,  0.996997,  0.997709,  0.995256,  0.997628,  0.995439,  0.996250,  0.994199,  0.998214,  0.994185,  0.994887,  0.994475,  0.996630,  0.996008,  0.991457,  0.994276,  0.993531,  0.996293,  0.989917,  0.996715,  0.991296,  0.993562,  0.990399,  0.995587,  0.991088,  0.990148,  0.992401,  0.993968,  0.993512,  0.987861,  0.991173,  0.991467,  0.993060,  0.983124,  0.996233,  0.987132,  0.990336,  0.988346,  0.992467,  0.988522,  0.986075,  0.987867,  0.992895,  0.990016,  0.984629,  0.987966,  0.988128,  0.992274,  0.974980,  0.996108,  0.983163,  0.986386,  0.987615,  0.988475,  0.985261,  0.982605,  0.986584,  0.987727,  0.988431,  0.980015,  0.985683,  0.984632,  0.989090,  0.969897,  0.993073,  0.982166,  0.981425,  0.985089,  0.987337,  0.983665,  0.977811,  0.982584,  0.981551,  0.987346,  0.973837,  0.987937,  0.978583,  0.983337,  0.972409,  0.992885,  0.973925,  0.979631,  0.977207,  0.986250,  0.985678,  0.969613,  0.981089, },
{ 1.000000,  0.999785,  0.999750,  0.999085,  0.999537,  0.998727,  0.998910,  0.998072,  0.998980,  0.997946,  0.997688,  0.997817,  0.998119,  0.998132,  0.996024,  0.996720,  0.996986,  0.997588,  0.993494,  0.998311,  0.994783,  0.996879,  0.994150,  0.996770,  0.995262,  0.993191,  0.994185,  0.996744,  0.995476,  0.992481,  0.993644,  0.993627,  0.996546,  0.986836,  0.997180,  0.991635,  0.992879,  0.992592,  0.993727,  0.991408,  0.990036,  0.991739,  0.993031,  0.993904,  0.988756,  0.990101,  0.990963,  0.994708,  0.980563,  0.994720,  0.990054,  0.988568,  0.990659,  0.991167,  0.989731,  0.985759,  0.988248,  0.988975,  0.991545,  0.983264,  0.990015,  0.986240,  0.989596,  0.981077,  0.993677,  0.983117,  0.986074,  0.985473,  0.989449,  0.991708,  0.978001,  0.985005,  0.985427,  0.991512,  0.976052,  0.990975,  0.982332,  0.984639,  0.978482,  0.991173,  0.981017,  0.981715,  0.982137,  0.988196,  0.988519,  0.975217,  0.980882,  0.983823,  0.988411,  0.967597,  0.993621,  0.975683,  0.986213,  0.975401,  0.986166,  0.980764,  0.974402,  0.977797,  0.988856,  0.983478, },
{ 1.000000,  0.999738,  0.999634,  0.999351,  0.999601,  0.998059,  0.999552,  0.998448,  0.998543,  0.998146,  0.998485,  0.997880,  0.996943,  0.997513,  0.997860,  0.998248,  0.996007,  0.996374,  0.997052,  0.997532,  0.992132,  0.997938,  0.995653,  0.995689,  0.995909,  0.995948,  0.995611,  0.993240,  0.994322,  0.994818,  0.996410,  0.990978,  0.994502,  0.993495,  0.994496,  0.990031,  0.996876,  0.991568,  0.991632,  0.992446,  0.993710,  0.995073,  0.988317,  0.991767,  0.991297,  0.994616,  0.986428,  0.994516,  0.989095,  0.990626,  0.985916,  0.996345,  0.988116,  0.987964,  0.989599,  0.992764,  0.992850,  0.983491,  0.987872,  0.989758,  0.992139,  0.979676,  0.996094,  0.984035,  0.990458,  0.983413,  0.991036,  0.987194,  0.982942,  0.985296,  0.992418,  0.989447,  0.980583,  0.986514,  0.985361,  0.992099,  0.971459,  0.994834,  0.981585,  0.984936,  0.985100,  0.986909,  0.985053,  0.978923,  0.982258,  0.988717,  0.989437,  0.977777,  0.981439,  0.985145,  0.989381,  0.964555,  0.990678,  0.980631,  0.982853,  0.983802,  0.984290,  0.981692,  0.976742,  0.979979, },
{ 1.000000,  0.999852,  0.999811,  0.999027,  0.999262,  0.999043,  0.999054,  0.997732,  0.999482,  0.997968,  0.997821,  0.997686,  0.998310,  0.998493,  0.996056,  0.996811,  0.996886,  0.998193,  0.994112,  0.998188,  0.995501,  0.996172,  0.992898,  0.998678,  0.995055,  0.994266,  0.993953,  0.997313,  0.996475,  0.991303,  0.993426,  0.994415,  0.996653,  0.988420,  0.997683,  0.991087,  0.994604,  0.989791,  0.995145,  0.993646,  0.988990,  0.991362,  0.995661,  0.994122,  0.987328,  0.991104,  0.991317,  0.995493,  0.980358,  0.997046,  0.989086,  0.990070,  0.988955,  0.991345,  0.992389,  0.985126,  0.986055,  0.993724,  0.993365,  0.982997,  0.987670,  0.990262,  0.994106,  0.972633,  0.995793,  0.986562,  0.986165,  0.987544,  0.990078,  0.987575,  0.982344,  0.985275,  0.988407,  0.992366,  0.976929,  0.986745,  0.986333,  0.988299,  0.972555,  0.994746,  0.982443,  0.983421,  0.982468,  0.989513,  0.988528,  0.976445,  0.981772,  0.982748,  0.990609,  0.971478,  0.992495,  0.976712,  0.985025,  0.970062,  0.995434,  0.978870,  0.978371,  0.978724,  0.989379,  0.987323, },
{ 1.000000,  0.999736,  0.999631,  0.999490,  0.999725,  0.998426,  0.999703,  0.998569,  0.998923,  0.997741,  0.998906,  0.998552,  0.997085,  0.997443,  0.998846,  0.998579,  0.995534,  0.997275,  0.996766,  0.998654,  0.992480,  0.999202,  0.995746,  0.996146,  0.995355,  0.996753,  0.997073,  0.993110,  0.993905,  0.997933,  0.996563,  0.991936,  0.994520,  0.995006,  0.997605,  0.986812,  0.998507,  0.993041,  0.992607,  0.993907,  0.995122,  0.993813,  0.990592,  0.991777,  0.994401,  0.995792,  0.987244,  0.993353,  0.992306,  0.993745,  0.983295,  0.997589,  0.990659,  0.989365,  0.991112,  0.993728,  0.993333,  0.985715,  0.989558,  0.989780,  0.994781,  0.982132,  0.995933,  0.986712,  0.990292,  0.981055,  0.997521,  0.987821,  0.985976,  0.986972,  0.993004,  0.992789,  0.980519,  0.985777,  0.987679,  0.994843,  0.976418,  0.995827,  0.983915,  0.988515,  0.979409,  0.993063,  0.987208,  0.980026,  0.983906,  0.993101,  0.990872,  0.976159,  0.985493,  0.985572,  0.992562,  0.966543,  0.996750,  0.981628,  0.984825,  0.979251,  0.990436,  0.987944,  0.974748,  0.979819, },
{ 1.000000,  0.999923,  0.999794,  0.999187,  0.999310,  0.999257,  0.999590,  0.997084,  0.999965,  0.998235,  0.998010,  0.998239,  0.998613,  0.997868,  0.996604,  0.997358,  0.998168,  0.998288,  0.995023,  0.997322,  0.996662,  0.997430,  0.992062,  0.999294,  0.995678,  0.994886,  0.995599,  0.997057,  0.996526,  0.992606,  0.994594,  0.994776,  0.997369,  0.990217,  0.996803,  0.993421,  0.994121,  0.989312,  0.998727,  0.992967,  0.991384,  0.991255,  0.996822,  0.995988,  0.986658,  0.992438,  0.991928,  0.996970,  0.984715,  0.997306,  0.989569,  0.992544,  0.985949,  0.996145,  0.991621,  0.985867,  0.989937,  0.995274,  0.994419,  0.983142,  0.990308,  0.990955,  0.993416,  0.977123,  0.998237,  0.986709,  0.989303,  0.984975,  0.993445,  0.990405,  0.981478,  0.985452,  0.995537,  0.991284,  0.980308,  0.988032,  0.988182,  0.994035,  0.968090,  0.999299,  0.983897,  0.985097,  0.985163,  0.989937,  0.987927,  0.978836,  0.985123,  0.990066,  0.991189,  0.975131,  0.986958,  0.986234,  0.990317,  0.963766,  0.996017,  0.985519,  0.978834,  0.982608,  0.990638,  0.987390, },
{ 1.000000,  0.999754,  0.999617,  0.999536,  0.999742,  0.998493,  0.999474,  0.998902,  0.998899,  0.997220,  0.999910,  0.998061,  0.997532,  0.997138,  0.999092,  0.999039,  0.995225,  0.997360,  0.997239,  0.998876,  0.993826,  0.998714,  0.995954,  0.996747,  0.993548,  0.998348,  0.996336,  0.993741,  0.995067,  0.997613,  0.997821,  0.991133,  0.994651,  0.995850,  0.996840,  0.987294,  0.999297,  0.992753,  0.995478,  0.990224,  0.996717,  0.995443,  0.988284,  0.991636,  0.997975,  0.995756,  0.987916,  0.992713,  0.992849,  0.997129,  0.979736,  0.999532,  0.991194,  0.990849,  0.989985,  0.994221,  0.992345,  0.985723,  0.990087,  0.994558,  0.995370,  0.983844,  0.990387,  0.991634,  0.995215,  0.973184,  0.997388,  0.992085,  0.985474,  0.988482,  0.993767,  0.991675,  0.981735,  0.987187,  0.990051,  0.994246,  0.977709,  0.991922,  0.988014,  0.989423,  0.975496,  0.998164,  0.985760,  0.983046,  0.983204,  0.993334,  0.995398,  0.974047,  0.984342,  0.987411,  0.995022,  0.970140,  0.994604,  0.984627,  0.984296,  0.973912,  0.995765,  0.985609,  0.978032,  0.980612, },
{ 1.000000,  0.999960,  0.999894,  0.999158,  0.999363,  0.999444,  0.999618,  0.997599,  1.000116,  0.998349,  0.999076,  0.997416,  0.999187,  0.998735,  0.996518,  0.997193,  0.999663,  0.998577,  0.995516,  0.997594,  0.997035,  0.999149,  0.991623,  1.000122,  0.996503,  0.996548,  0.995162,  0.997800,  0.996967,  0.992898,  0.995444,  0.997747,  0.998428,  0.992052,  0.994940,  0.996468,  0.997339,  0.985383,  0.999325,  0.995333,  0.993566,  0.993797,  0.996508,  0.996177,  0.989652,  0.992700,  0.994932,  0.997875,  0.986167,  0.994836,  0.993531,  0.994418,  0.985047,  0.999613,  0.992562,  0.988814,  0.990562,  0.995672,  0.997509,  0.984799,  0.990925,  0.992124,  0.997019,  0.981812,  0.996913,  0.989512,  0.990526,  0.981610,  1.000234,  0.990313,  0.985225,  0.988051,  0.996392,  0.996481,  0.979654,  0.987936,  0.991689,  0.994606,  0.974540,  1.000500,  0.985810,  0.991366,  0.980428,  0.994230,  0.991816,  0.979907,  0.984248,  0.997337,  0.993849,  0.976773,  0.987971,  0.988078,  0.995613,  0.965860,  1.000940,  0.984093,  0.985709,  0.984012,  0.990773,  0.990275, },
{ 1.000000,  0.999766,  0.999671,  0.999887,  0.999822,  0.998794,  0.999160,  0.999427,  0.999470,  0.996498,  0.999969,  0.998768,  0.998096,  0.998154,  0.999117,  0.998554,  0.996287,  0.997537,  0.998540,  0.999458,  0.994204,  0.997959,  0.997482,  0.997390,  0.992874,  1.000574,  0.996542,  0.994720,  0.995651,  0.998525,  0.998830,  0.992003,  0.995577,  0.996144,  0.998608,  0.989429,  0.999706,  0.994319,  0.994748,  0.988879,  1.001080,  0.995336,  0.991106,  0.992377,  0.999518,  0.997768,  0.987659,  0.993279,  0.994777,  0.997181,  0.984295,  1.000666,  0.991109,  0.994017,  0.987541,  0.997340,  0.996076,  0.985508,  0.990995,  0.998878,  0.996529,  0.984175,  0.992208,  0.992680,  0.997012,  0.975888,  1.002040,  0.990450,  0.989426,  0.988803,  0.993797,  0.996180,  0.981520,  0.986623,  0.998576,  0.996228,  0.980508,  0.990182,  0.993295,  0.996373,  0.967702,  1.002471,  0.989661,  0.985392,  0.988254,  0.994622,  0.992022,  0.979385,  0.987909,  0.992967,  0.996553,  0.974151,  0.991211,  0.989721,  0.990210,  0.969606,  1.002432,  0.987107,  0.981950,  0.983887, },
{ 1.000000,  0.999989,  0.999922,  0.999221,  0.999480,  0.999503,  0.999767,  0.998005,  1.000110,  0.998504,  0.998765,  0.996980,  1.000500,  0.998626,  0.997110,  0.997680,  0.999958,  0.999269,  0.995199,  0.997438,  0.997977,  0.999058,  0.993470,  1.000253,  0.996804,  0.997120,  0.994047,  0.998848,  0.998540,  0.993327,  0.994915,  0.999976,  0.998939,  0.991113,  0.996366,  0.996209,  0.998433,  0.986916,  1.001322,  0.995245,  0.993611,  0.993669,  0.997106,  0.998423,  0.988535,  0.991828,  1.000656,  0.996948,  0.988199,  0.993965,  0.996491,  0.997785,  0.980873,  1.002164,  0.994082,  0.989516,  0.993162,  0.997338,  0.995649,  0.986272,  0.991130,  0.997135,  0.997152,  0.983539,  0.994295,  0.994531,  0.993032,  0.978409,  1.002164,  0.992800,  0.986137,  0.990964,  0.997654,  0.996368,  0.981598,  0.990018,  0.992297,  0.996673,  0.978125,  1.000069,  0.988458,  0.989364,  0.977888,  1.002574,  0.991402,  0.982968,  0.986500,  0.998597,  0.996338,  0.976952,  0.986584,  0.991884,  0.996727,  0.972383,  1.000825,  0.987300,  0.988025,  0.977485,  0.998269,  0.992613, },
{ 1.000000,  0.999772,  0.999690,  1.000030,  0.999849,  0.998751,  0.999369,  0.999552,  0.999544,  0.996976,  1.000428,  0.998775,  0.998362,  0.997860,  0.999550,  0.999366,  0.996109,  0.997208,  1.000059,  0.998953,  0.995374,  0.997578,  0.998955,  0.999215,  0.990797,  1.001521,  0.997300,  0.995398,  0.996773,  0.998894,  0.997487,  0.993183,  0.995789,  0.999300,  0.998314,  0.991686,  0.996526,  0.997760,  0.996514,  0.987283,  1.001294,  0.996276,  0.992647,  0.994830,  0.998768,  0.997686,  0.989654,  0.993736,  0.996297,  0.998300,  0.986832,  0.997951,  0.995441,  0.992944,  0.986324,  1.001634,  0.994927,  0.989800,  0.989768,  1.000760,  0.998019,  0.984205,  0.992690,  0.994657,  0.998534,  0.981601,  0.999654,  0.992856,  0.991935,  0.983988,  0.999643,  0.994818,  0.984381,  0.989343,  1.000035,  0.997675,  0.980855,  0.991925,  0.995528,  0.994474,  0.974020,  1.002581,  0.990501,  0.989139,  0.985325,  0.997209,  0.994400,  0.980428,  0.984892,  1.002598,  0.994202,  0.979214,  0.990215,  0.994367,  0.995777,  0.964359,  1.005663,  0.989370,  0.984417,  0.987003, },
{ 1.000000,  0.999945,  0.999880,  0.999425,  0.999491,  0.999918,  0.999844,  0.998450,  0.999188,  0.999752,  0.999478,  0.996196,  1.000224,  0.999349,  0.997700,  0.998227,  0.999797,  0.999301,  0.996461,  0.997539,  0.998431,  0.999875,  0.994574,  0.998904,  0.998565,  0.997689,  0.993336,  1.000883,  0.997140,  0.996024,  0.994714,  1.000027,  0.999762,  0.992553,  0.996397,  0.997287,  0.999780,  0.990566,  0.999090,  0.996718,  0.996036,  0.990810,  0.999471,  0.997240,  0.992709,  0.993969,  0.999326,  0.999602,  0.989199,  0.994468,  0.997670,  0.997714,  0.983822,  1.001352,  0.994496,  0.996155,  0.988725,  0.998466,  0.997630,  0.987556,  0.990451,  1.002023,  0.997732,  0.986812,  0.993373,  0.996197,  0.999106,  0.976205,  1.002825,  0.994365,  0.990673,  0.991407,  0.996629,  0.995377,  0.985388,  0.990356,  0.999188,  0.998506,  0.983863,  0.990295,  0.997588,  0.997600,  0.970197,  1.000320,  0.997035,  0.986319,  0.990544,  0.997685,  0.996192,  0.982235,  0.988802,  0.994341,  0.998182,  0.978027,  0.993095,  0.995179,  0.991194,  0.975367,  1.002137,  0.990987, },
{ 1.000000,  0.999856,  0.999724,  1.000021,  1.000024,  0.998913,  0.999360,  0.999629,  0.999975,  0.997633,  0.999998,  0.999317,  0.998572,  0.997245,  1.000429,  0.998759,  0.997633,  0.997784,  1.000263,  1.000030,  0.995509,  0.997619,  0.999368,  0.999314,  0.992729,  1.001677,  0.997383,  0.998222,  0.994573,  0.999779,  0.998576,  0.994005,  0.995189,  1.001834,  0.998577,  0.993032,  0.996982,  0.997945,  0.999421,  0.986638,  1.002488,  0.996938,  0.995475,  0.994449,  0.999254,  0.997353,  0.990880,  0.994743,  1.000005,  0.999875,  0.990358,  0.993911,  1.000170,  0.997482,  0.980480,  1.001601,  0.997419,  0.993052,  0.994148,  0.999227,  0.997605,  0.988476,  0.992997,  0.997189,  0.999611,  0.984332,  0.995314,  0.998196,  0.993917,  0.983524,  1.003028,  0.994241,  0.988696,  0.991425,  0.999071,  1.000412,  0.984727,  0.992080,  0.995493,  0.999152,  0.980505,  0.999530,  0.994177,  0.990037,  0.980699,  1.004950,  0.992335,  0.986197,  0.989685,  1.001113,  0.999770,  0.979687,  0.989533,  0.997374,  0.995957,  0.973566,  1.005536,  0.991038,  0.992136,  0.980866, },
{ 1.000000,  1.000000,  0.999966,  0.999495,  0.999507,  1.000259,  1.000030,  0.998591,  0.999363,  0.999879,  0.999982,  0.996535,  1.000975,  0.999092,  0.998527,  0.998594,  0.999794,  0.999711,  0.996564,  0.997765,  1.000589,  1.000450,  0.996022,  0.997503,  1.000570,  0.999666,  0.991114,  1.000811,  0.999318,  0.997022,  0.997541,  1.000090,  0.998852,  0.994513,  0.996976,  0.999250,  1.000943,  0.991597,  0.997434,  0.999827,  0.997114,  0.990431,  1.002742,  0.997162,  0.994128,  0.996014,  1.000231,  1.001081,  0.991089,  0.995610,  0.997518,  1.000725,  0.987668,  1.001130,  0.997225,  0.995085,  0.987077,  1.003984,  0.997269,  0.991550,  0.993366,  1.002383,  1.000880,  0.987307,  0.993503,  0.998218,  1.000100,  0.982458,  1.003780,  0.994860,  0.995420,  0.987297,  1.000371,  0.999519,  0.986711,  0.992254,  1.002638,  1.000756,  0.984800,  0.993068,  0.998413,  1.000005,  0.973923,  1.006398,  0.994709,  0.991281,  0.991086,  0.997608,  1.001475,  0.982745,  0.987941,  1.003428,  1.001900,  0.981541,  0.991249,  1.002022,  0.999655,  0.965320,  1.007088,  0.995897, },
{ 1.000000,  0.999903,  0.999885,  1.000010,  0.999961,  0.999224,  0.999616,  0.999923,  1.000351,  0.998096,  0.999390,  1.000131,  0.999661,  0.996693,  1.001123,  0.999193,  0.998274,  0.998780,  1.000556,  1.000615,  0.996447,  0.998380,  0.999161,  1.000855,  0.994775,  1.001080,  0.998110,  0.998971,  0.993627,  1.002679,  0.998452,  0.996273,  0.997515,  1.001818,  1.000771,  0.993516,  0.996662,  0.998735,  1.001788,  0.990311,  1.002202,  0.997934,  0.998478,  0.992621,  1.000418,  1.000169,  0.993379,  0.995588,  1.001889,  1.002453,  0.990253,  0.996445,  0.998701,  1.002030,  0.983540,  1.004610,  0.996608,  0.996001,  0.994751,  0.999414,  1.001795,  0.988637,  0.992787,  1.003893,  1.001498,  0.988238,  0.994195,  1.001447,  1.002502,  0.977358,  1.006079,  0.996837,  0.992693,  0.996396,  1.000538,  0.999230,  0.987994,  0.993950,  1.000429,  1.002695,  0.984364,  0.994507,  1.000878,  0.998480,  0.977244,  1.006253,  0.996273,  0.990188,  0.995341,  1.001889,  1.002220,  0.984313,  0.993159,  0.996308,  1.003123,  0.980131,  1.002554,  0.995166,  0.995217,  0.978257, },
{ 1.000000,  1.000087,  0.999941,  0.999772,  0.999746,  1.000223,  1.000283,  0.998933,  0.999302,  0.999921,  1.000862,  0.997433,  1.000770,  0.999639,  0.999905,  0.997467,  1.000776,  0.999945,  0.998057,  0.998664,  1.001091,  1.001014,  0.996577,  0.998590,  1.000275,  1.001319,  0.992639,  1.002689,  0.998672,  0.999277,  0.997109,  1.001021,  1.000839,  0.995126,  0.997243,  1.001576,  1.001658,  0.994699,  0.997425,  1.000921,  1.003241,  0.986456,  1.004693,  0.998266,  0.997583,  0.998629,  1.000628,  0.999524,  0.993917,  0.997285,  1.001938,  1.002223,  0.991791,  0.996672,  1.001081,  1.001679,  0.984825,  1.004766,  0.998249,  0.996560,  0.997833,  1.001340,  1.001894,  0.991645,  0.995535,  0.999503,  1.003766,  0.987774,  0.999415,  1.000123,  0.998811,  0.985952,  1.006145,  0.997495,  0.995023,  0.993158,  1.004924,  1.003973,  0.987013,  0.995065,  0.998288,  1.007261,  0.981649,  1.003999,  0.998157,  0.999666,  0.984481,  1.004685,  0.999160,  0.990180,  0.994818,  1.003638,  1.005704,  0.985143,  0.994389,  1.002173,  1.003841,  0.973941,  1.008623,  0.995494, },
{ 1.000000,  1.000019,  0.999827,  1.000178,  1.000085,  0.999598,  0.999535,  1.000840,  1.000440,  0.999024,  0.999610,  1.000625,  1.001177,  0.996204,  1.001893,  0.999873,  0.999861,  0.999551,  1.000718,  1.000651,  0.998068,  0.999198,  1.001945,  1.001443,  0.997035,  0.998748,  1.002155,  1.001892,  0.992473,  1.002821,  1.001002,  0.998857,  0.999035,  1.002458,  1.001787,  0.996408,  0.998204,  1.001202,  1.003233,  0.993961,  1.000503,  1.002247,  1.001069,  0.992172,  1.005499,  0.998482,  0.999292,  0.996217,  1.004631,  1.004057,  0.993323,  0.998083,  1.001634,  1.005451,  0.990311,  1.003052,  1.001443,  1.000895,  0.991220,  1.004555,  1.000626,  0.997004,  0.998267,  1.003963,  1.005707,  0.991407,  0.996554,  1.004927,  1.004523,  0.983276,  1.007607,  0.999752,  1.003828,  0.991122,  1.004731,  1.002498,  0.992370,  0.994803,  1.009551,  1.005184,  0.990750,  0.996818,  1.003947,  1.008910,  0.975927,  1.010246,  1.000560,  0.999193,  0.997842,  1.003537,  1.001649,  0.990999,  0.996492,  1.008397,  1.006541,  0.990729,  0.992766,  1.007810,  1.009475,  0.970938, },
{ 1.000000,  1.000076,  1.000097,  0.999880,  0.999887,  1.000296,  1.000244,  0.999244,  0.999559,  1.000506,  1.000572,  0.998394,  0.999760,  1.000866,  1.000155,  0.997249,  1.001763,  0.999617,  0.999437,  0.998798,  1.001688,  1.001851,  0.996749,  0.998662,  1.001208,  1.002330,  0.994823,  1.001183,  1.001458,  0.999245,  0.995499,  1.002888,  0.999834,  0.998399,  0.998233,  1.002804,  1.003177,  0.994636,  0.997185,  1.003003,  1.002876,  0.989401,  1.005206,  0.999836,  1.002032,  0.994295,  1.002385,  1.001427,  0.995321,  0.995832,  1.006567,  1.002188,  0.993741,  0.998170,  1.002182,  1.004761,  0.983695,  1.006881,  1.001101,  0.999893,  0.996472,  1.002742,  1.001127,  0.992935,  0.997214,  1.005743,  1.004819,  0.993150,  0.993846,  1.007401,  1.003816,  0.978185,  1.006464,  1.002991,  0.998834,  0.997895,  1.003438,  1.003515,  0.991639,  0.995703,  1.004619,  1.005962,  0.986060,  0.997472,  1.006552,  1.000338,  0.984894,  1.009129,  0.999803,  0.994700,  0.996099,  1.005894,  1.007878,  0.987766,  0.995402,  1.004168,  1.007773,  0.983060,  1.003117,  1.004345, },
{ 1.000000,  0.999969,  0.999659,  1.000381,  0.999954,  0.999699,  0.999768,  1.000563,  1.000655,  0.998673,  0.999235,  1.000937,  1.000769,  0.996854,  1.001640,  1.000144,  1.000479,  0.997763,  1.000826,  1.000569,  0.998365,  0.998334,  1.002602,  1.001251,  0.996857,  0.998752,  1.001947,  1.002185,  0.991990,  1.003835,  0.999971,  0.999552,  0.998579,  1.001172,  1.001096,  0.996017,  0.997598,  1.003987,  1.002498,  0.995914,  0.996392,  1.004628,  1.002870,  0.986693,  1.003622,  1.001761,  0.999637,  0.998553,  1.002414,  1.000996,  0.995215,  0.997324,  1.004051,  1.004347,  0.990450,  0.997975,  1.004315,  1.000080,  0.989185,  1.006463,  0.999671,  0.997220,  0.997510,  1.004387,  1.004836,  0.992033,  0.996119,  1.003077,  1.005162,  0.987468,  1.003438,  1.002605,  0.999176,  0.986072,  1.009352,  1.000472,  0.995832,  0.995102,  1.008425,  1.004611,  0.989341,  0.993712,  1.005201,  1.006616,  0.980912,  1.008748,  1.000126,  1.002528,  0.987931,  1.004917,  1.003923,  0.991319,  0.994601,  1.009428,  1.005725,  0.988231,  0.994452,  1.006889,  1.007526,  0.971414, },
{ 1.000000,  1.000125,  1.000030,  0.999967,  0.999802,  1.000094,  1.000411,  0.999232,  0.999268,  1.000992,  1.000656,  0.998631,  0.999183,  1.001413,  1.001115,  0.995261,  1.001856,  1.000354,  0.999612,  0.999510,  1.000998,  1.000511,  0.997876,  0.998925,  1.001863,  1.001827,  0.995690,  0.998807,  1.002452,  1.000524,  0.993458,  1.003433,  1.000126,  0.998817,  0.998493,  1.003051,  1.002162,  0.995314,  0.997734,  1.001970,  1.002895,  0.992877,  1.002484,  1.000233,  1.000561,  0.991203,  1.006235,  0.999448,  0.997908,  0.997664,  1.005310,  1.002537,  0.993062,  0.995999,  1.002422,  1.005080,  0.987940,  1.004797,  1.001293,  1.001578,  0.991602,  1.002875,  1.002533,  0.995847,  0.995414,  1.006171,  1.005288,  0.990601,  0.996582,  1.003948,  1.005867,  0.980038,  1.008835,  1.000224,  0.999879,  0.995798,  1.002084,  1.004682,  0.991291,  0.992357,  1.010430,  1.003864,  0.989657,  0.993646,  1.008842,  1.006837,  0.975274,  1.010218,  1.000730,  0.997333,  0.998524,  1.004770,  1.002098,  0.991444,  0.993426,  1.009010,  1.006293,  0.985489,  0.994803,  1.008915, },
{ 1.000000,  1.000024,  0.999527,  1.000320,  1.000054,  0.999795,  0.999848,  1.000534,  1.000425,  0.998900,  0.999428,  1.000570,  1.000805,  0.997846,  1.000539,  1.000447,  1.000082,  0.996780,  1.002167,  0.999947,  0.999259,  0.998909,  1.001986,  1.001312,  0.996883,  0.997773,  1.001648,  1.002514,  0.993972,  1.002370,  1.000851,  1.000461,  0.995135,  1.002505,  1.000650,  0.997613,  0.997633,  1.003776,  1.002418,  0.994837,  0.997603,  1.003342,  1.002685,  0.988274,  1.005614,  0.999686,  1.000616,  0.996151,  1.003126,  1.001917,  0.994537,  0.995665,  1.005731,  1.002531,  0.993883,  0.996186,  1.005144,  1.005195,  0.981767,  1.008266,  1.000002,  0.998365,  0.999065,  1.003262,  1.000209,  0.993950,  0.996270,  1.007392,  1.003127,  0.991044,  0.995458,  1.005982,  1.002915,  0.981538,  1.008209,  1.000614,  0.998141,  0.997885,  1.005404,  1.003252,  0.991394,  0.994999,  1.004938,  1.005185,  0.986651,  0.999661,  1.005348,  0.999535,  0.984461,  1.010470,  0.999076,  0.997530,  0.992255,  1.010557,  1.005705,  0.986278,  0.994101,  1.004761,  1.009622,  0.979803, },
{ 1.000000,  1.000056,  1.000077,  1.000063,  0.999330,  1.000408,  1.000093,  0.999485,  0.999622,  1.000760,  1.000753,  0.998460,  0.999265,  1.001292,  1.000708,  0.996088,  1.001850,  0.999972,  1.000430,  0.998060,  1.001291,  1.000338,  0.998164,  0.997821,  1.003296,  1.000961,  0.997044,  0.998530,  1.002225,  1.002466,  0.990736,  1.004229,  0.999935,  0.999620,  0.998608,  1.001599,  1.000899,  0.996321,  0.998039,  1.004308,  1.001752,  0.994740,  0.997077,  1.004586,  1.002355,  0.987334,  1.004427,  1.001887,  0.998150,  0.997658,  1.004200,  1.002212,  0.994263,  0.996817,  1.002857,  1.003714,  0.990842,  0.999878,  1.004494,  1.000649,  0.988318,  1.007837,  0.997581,  0.999192,  0.993732,  1.007099,  1.004682,  0.990475,  0.996368,  1.003793,  1.006089,  0.986429,  1.003331,  1.003292,  1.000545,  0.987357,  1.006110,  1.000630,  0.996105,  0.996759,  1.005610,  1.006446,  0.988397,  0.994242,  1.008439,  1.004499,  0.977534,  1.009529,  1.000378,  1.005086,  0.987322,  1.006227,  1.002488,  0.990264,  0.992051,  1.013285,  1.004786,  0.988252,  0.994595,  1.006986, },
{ 1.000000,  1.000102,  0.999390,  1.000370,  1.000058,  0.999940,  0.999767,  1.000328,  1.000048,  0.999088,  0.999501,  1.001256,  1.000603,  0.998713,  0.998570,  1.001640,  1.001352,  0.994618,  1.001515,  1.001081,  0.999292,  0.999197,  1.001498,  1.000976,  0.997348,  0.998440,  1.001921,  1.001456,  0.995715,  0.999152,  1.002615,  1.000297,  0.993713,  1.003894,  0.999269,  0.999143,  0.997377,  1.003629,  1.003355,  0.993906,  0.997353,  1.002851,  1.003957,  0.990889,  1.001785,  1.003246,  0.998760,  0.992343,  1.004858,  0.999768,  0.997819,  0.996969,  1.004720,  1.004810,  0.991763,  0.995263,  1.005527,  1.004279,  0.983828,  1.007567,  1.000449,  1.003502,  0.991307,  1.003621,  1.001987,  0.993720,  0.993657,  1.009757,  1.002891,  0.991326,  0.997043,  1.004153,  1.006368,  0.977413,  1.009434,  1.002153,  1.000291,  0.994763,  1.004081,  1.001312,  0.990902,  0.995937,  1.008629,  1.005916,  0.991193,  0.990994,  1.011230,  1.004758,  0.971316,  1.008514,  1.004422,  0.999131,  0.996727,  1.004810,  1.004385,  0.989476,  0.994211,  1.007309,  1.007133,  0.982232, },
{ 1.000000,  0.999957,  1.000207,  0.999999,  0.999259,  1.000551,  1.000007,  0.999620,  0.999592,  1.000707,  1.000858,  0.998474,  0.999327,  1.000837,  1.001131,  0.997249,  1.000409,  1.001115,  0.999515,  0.996512,  1.002695,  0.999737,  0.998771,  0.998991,  1.002127,  1.002067,  0.996053,  0.997709,  1.002782,  1.001933,  0.992348,  1.003682,  1.000604,  1.001215,  0.995184,  1.001698,  1.001081,  0.997088,  0.996708,  1.004915,  1.002157,  0.994506,  0.997594,  1.003892,  1.003659,  0.986506,  1.006282,  1.000297,  0.999516,  0.997472,  1.001973,  1.001624,  0.994080,  0.996244,  1.006412,  1.003525,  0.994061,  0.994187,  1.007545,  1.004082,  0.980665,  1.005178,  1.002851,  0.999844,  0.997657,  1.003599,  1.001352,  0.993519,  0.996064,  1.006341,  1.005675,  0.986921,  0.996834,  1.006731,  0.999905,  0.985552,  1.008385,  0.999916,  0.996724,  0.996335,  1.006276,  1.006155,  0.989683,  0.994600,  1.005016,  1.006358,  0.983925,  1.003805,  1.004513,  0.999018,  0.981880,  1.012018,  1.000680,  0.995254,  0.993401,  1.011155,  1.005347,  0.986767,  0.991529,  1.007669, },
{ 1.000000,  1.000083,  0.999515,  1.000319,  1.000056,  1.000185,  0.999096,  1.000418,  1.000352,  0.999154,  0.999323,  1.001232,  1.000747,  0.998342,  0.999052,  1.001349,  1.001257,  0.994754,  1.002418,  1.000304,  0.999864,  0.998785,  1.000483,  1.001607,  0.997291,  0.997513,  1.003175,  1.001837,  0.996303,  0.997686,  1.003817,  1.002543,  0.989255,  1.004001,  1.000924,  0.999370,  0.998812,  1.002064,  1.000947,  0.996072,  0.997850,  1.003768,  1.003119,  0.992327,  0.997681,  1.004689,  1.000733,  0.989005,  1.005536,  1.000449,  0.998186,  0.997414,  1.005081,  1.003286,  0.992683,  0.996334,  1.003655,  1.004206,  0.989214,  1.003300,  1.001070,  1.000788,  0.986850,  1.009116,  0.999227,  0.997295,  0.996399,  1.007895,  1.003309,  0.990264,  0.994075,  1.004035,  1.007082,  0.983016,  1.006403,  1.002543,  1.002325,  0.988184,  1.004049,  1.003422,  0.994805,  0.993511,  1.008458,  1.006933,  0.987576,  0.995074,  1.006166,  1.007648,  0.973293,  1.011621,  1.000876,  1.000224,  0.994134,  1.002840,  1.005985,  0.989059,  0.989846,  1.013923,  1.004690,  0.986765, },
{ 1.000000,  0.999915,  1.000249,  1.000258,  0.998760,  1.000623,  1.000082,  0.999804,  0.999813,  1.000536,  1.000234,  0.998942,  0.999034,  1.001454,  1.000961,  0.997555,  0.998978,  1.001871,  1.000460,  0.995115,  1.002268,  1.000327,  0.999112,  0.999237,  1.002059,  1.001393,  0.996667,  0.998281,  1.001783,  1.001959,  0.994725,  1.001105,  1.001375,  1.000184,  0.993045,  1.004467,  0.999918,  0.998667,  0.997833,  1.003921,  1.002312,  0.994395,  0.995862,  1.003263,  1.004341,  0.989581,  1.003823,  1.001819,  1.000805,  0.991882,  1.004055,  1.001056,  0.996496,  0.996148,  1.005994,  1.003617,  0.992188,  0.996153,  1.005570,  1.003929,  0.982429,  1.008291,  0.999817,  1.001192,  0.994191,  1.004605,  1.002623,  0.992442,  0.993638,  1.008410,  1.003376,  0.991522,  0.994386,  1.007717,  1.007032,  0.974925,  1.011215,  1.000304,  0.998001,  0.998394,  1.004621,  1.000253,  0.992012,  0.994790,  1.010418,  1.003990,  0.988073,  0.993567,  1.008710,  1.003733,  0.975777,  1.010542,  1.001234,  0.997879,  0.996833,  1.007395,  1.004002,  0.988992,  0.993388,  1.007180, },
{ 1.000000,  1.000054,  0.999646,  0.999976,  1.000309,  0.999966,  0.998867,  1.000865,  0.999919,  0.999787,  0.999065,  1.001381,  1.000736,  0.998027,  0.999022,  1.000926,  1.001643,  0.996250,  1.001132,  1.000924,  1.000431,  0.996176,  1.001892,  1.000400,  0.998225,  0.998700,  1.002370,  1.002094,  0.995879,  0.998003,  1.003385,  1.001617,  0.991123,  1.004004,  1.000079,  1.001008,  0.995965,  1.002575,  1.000615,  0.996708,  0.995895,  1.006007,  1.001634,  0.994858,  0.997371,  1.004066,  1.004044,  0.984751,  1.006795,  1.000089,  0.999494,  0.997625,  1.002646,  1.001367,  0.994423,  0.996902,  1.006773,  1.002531,  0.992146,  0.995406,  1.007167,  1.003254,  0.981707,  1.006234,  1.002922,  0.997570,  0.996355,  1.006116,  1.003050,  0.992011,  0.995475,  1.004368,  1.004914,  0.987427,  0.999497,  1.006732,  1.000785,  0.984157,  1.010423,  0.996824,  0.999235,  0.991380,  1.009737,  1.005950,  0.987500,  0.994918,  1.005548,  1.007773,  0.982145,  1.004049,  1.005037,  1.000748,  0.983325,  1.007935,  1.000876,  0.995327,  0.995537,  1.007357,  1.007978,  0.985265, },
{ 1.000000,  0.999920,  1.000238,  1.000168,  0.998855,  1.000589,  1.000064,  1.000452,  0.998743,  1.000675,  1.000270,  0.998802,  0.998848,  1.001999,  1.000724,  0.998035,  0.999002,  1.001435,  1.001815,  0.993789,  1.002586,  1.000436,  0.999739,  0.998974,  1.001211,  1.000131,  0.997208,  0.998535,  1.003454,  1.001460,  0.996860,  0.996558,  1.003895,  1.002887,  0.988698,  1.003022,  1.002239,  0.998735,  0.998276,  1.002884,  1.001761,  0.995274,  0.997182,  1.003559,  1.002405,  0.992751,  0.998426,  1.004645,  1.000400,  0.989847,  1.006127,  0.998922,  0.998806,  0.995754,  1.005755,  1.004957,  0.990798,  0.995975,  1.004603,  1.005748,  0.986569,  1.002410,  1.005186,  0.998185,  0.988904,  1.006960,  0.999664,  0.997120,  0.995588,  1.006742,  1.006553,  0.988620,  0.993248,  1.008020,  1.005833,  0.977864,  1.010058,  1.001041,  1.004877,  0.988086,  1.004883,  1.002575,  0.991896,  0.991432,  1.012959,  1.003713,  0.988633,  0.995972,  1.005961,  1.008097,  0.970677,  1.012100,  1.003136,  1.000489,  0.992985,  1.005439,  1.001565,  0.988506,  0.994659,  1.011266, },
{ 1.000000,  1.000065,  0.999769,  0.999655,  1.000573,  1.000270,  0.997941,  1.000699,  1.000427,  0.999928,  0.999578,  1.000632,  1.000581,  0.998483,  0.999109,  1.001275,  1.001195,  0.996770,  0.999188,  1.002120,  0.999970,  0.995877,  1.002518,  1.000046,  0.998662,  0.998560,  1.002252,  1.002381,  0.995862,  0.998254,  1.002175,  1.002605,  0.993768,  1.000768,  1.002599,  0.998985,  0.992928,  1.005301,  0.999478,  0.997797,  0.998048,  1.003942,  1.003596,  0.993082,  0.995975,  1.004966,  1.003246,  0.987203,  1.005929,  1.001235,  1.002030,  0.992187,  1.002706,  1.001641,  0.995623,  0.994877,  1.007517,  1.003189,  0.991758,  0.996277,  1.006118,  1.005302,  0.980202,  1.009066,  1.000674,  0.999412,  0.996161,  1.002886,  1.002247,  0.991751,  0.994725,  1.009047,  1.004795,  0.991799,  0.991784,  1.010772,  1.005424,  0.973741,  1.006957,  1.004065,  0.999905,  0.996582,  1.004973,  1.001775,  0.991461,  0.994665,  1.008727,  1.007267,  0.982712,  0.995638,  1.009381,  0.999630,  0.981320,  1.010587,  1.000113,  0.995912,  0.994988,  1.008322,  1.007704,  0.986815, },
{ 1.000000,  0.999912,  1.000141,  1.000221,  0.999214,  1.000215,  1.000384,  0.999918,  0.998283,  1.001263,  1.000084,  0.999438,  0.999070,  1.001644,  1.000777,  0.997828,  0.998502,  1.001488,  1.001553,  0.995152,  1.002152,  1.000399,  1.000871,  0.996288,  1.001519,  1.001151,  0.997523,  0.998022,  1.003273,  1.001833,  0.996048,  0.997785,  1.003141,  1.002649,  0.989063,  1.004866,  1.000728,  0.999815,  0.997648,  1.000895,  1.002855,  0.995230,  0.995662,  1.005516,  1.003065,  0.993818,  0.996085,  1.006445,  1.004034,  0.982981,  1.006221,  1.001554,  0.999132,  0.998018,  1.003222,  1.001397,  0.994186,  0.996752,  1.005777,  1.004438,  0.988795,  0.996549,  1.007065,  1.000914,  0.984484,  1.007640,  1.000850,  0.997515,  0.996268,  1.007165,  1.004411,  0.989954,  0.994913,  1.005352,  1.005514,  0.985502,  1.004104,  1.001994,  1.000934,  0.982419,  1.011979,  0.999002,  0.996632,  0.995075,  1.010508,  1.004084,  0.987435,  0.992266,  1.005568,  1.009062,  0.978055,  1.008005,  1.003783,  1.003021,  0.984758,  1.005232,  1.004322,  0.993699,  0.991683,  1.010679, },
{ 1.000000,  1.000078,  0.999701,  0.999807,  1.000334,  1.000454,  0.998051,  1.000978,  1.000099,  1.000041,  0.999303,  1.000366,  1.000804,  0.998434,  0.998428,  1.002294,  1.000785,  0.997599,  0.998296,  1.002596,  1.001723,  0.993174,  1.002851,  1.000366,  0.999360,  0.999314,  1.001668,  1.000640,  0.997193,  0.997512,  1.003614,  1.002219,  0.994500,  0.997710,  1.004076,  1.000882,  0.990326,  1.004288,  1.000708,  0.998388,  0.998499,  1.003792,  1.002408,  0.994222,  0.997062,  1.003208,  1.003162,  0.991349,  1.001631,  1.002485,  1.000241,  0.989011,  1.006909,  0.999859,  0.998041,  0.996619,  1.006036,  1.003305,  0.991705,  0.993850,  1.004985,  1.006242,  0.984879,  1.005328,  1.002939,  1.001119,  0.988408,  1.005739,  1.001448,  0.995271,  0.994552,  1.008340,  1.004825,  0.989380,  0.994679,  1.007865,  1.005207,  0.976286,  1.011078,  0.999904,  1.001710,  0.992132,  1.006121,  1.003315,  0.990222,  0.991571,  1.011118,  1.004269,  0.988952,  0.992558,  1.010248,  1.008853,  0.967818,  1.014256,  1.000573,  0.997522,  0.997656,  1.006022,  1.000281,  0.989948, },
{ 1.000000,  0.999935,  1.000277,  1.000138,  0.999415,  0.999604,  1.000656,  1.000293,  0.997741,  1.001071,  1.000170,  0.999758,  0.999533,  1.001095,  1.000598,  0.998224,  0.998853,  1.001375,  1.001167,  0.996587,  0.999737,  1.001834,  0.999792,  0.995399,  1.003138,  0.999749,  0.999379,  0.997316,  1.003753,  1.001821,  0.995202,  0.997685,  1.002201,  1.003553,  0.992078,  1.002249,  1.002050,  1.000831,  0.992619,  1.003527,  1.000728,  0.996892,  0.997636,  1.004179,  1.003519,  0.993032,  0.996627,  1.005785,  1.002615,  0.985606,  1.006388,  1.000257,  1.001661,  0.993586,  1.004037,  1.000895,  0.995121,  0.993816,  1.008998,  1.002367,  0.992423,  0.996129,  1.006107,  1.005770,  0.978184,  1.009658,  1.000289,  0.999312,  0.996499,  1.003837,  1.001867,  0.992279,  0.995727,  1.009442,  1.003456,  0.989223,  0.993628,  1.010032,  1.004167,  0.975620,  1.008209,  1.004062,  0.996877,  0.994970,  1.008222,  1.003961,  0.989540,  0.994082,  1.005994,  1.006246,  0.983638,  0.999199,  1.009125,  1.000878,  0.979660,  1.013215,  0.996031,  0.999191,  0.988871,  1.012626, },
{ 1.000000,  1.000070,  0.999684,  0.999800,  1.000294,  1.000471,  0.998685,  1.000323,  1.000535,  1.000085,  0.998037,  1.001012,  1.000129,  0.999341,  0.999265,  1.001251,  1.001365,  0.997271,  0.998509,  1.002418,  1.001197,  0.993701,  1.002722,  1.000317,  1.001648,  0.995825,  1.002098,  1.000745,  0.996837,  0.997079,  1.004882,  1.001670,  0.995562,  0.997810,  1.003114,  1.003667,  0.987693,  1.004997,  1.000900,  0.999540,  0.998064,  1.002243,  1.000216,  0.995210,  0.997492,  1.005888,  1.002409,  0.994835,  0.994287,  1.006450,  1.004464,  0.982297,  1.004667,  1.003492,  0.998131,  0.997208,  1.004422,  1.002611,  0.992998,  0.995837,  1.005344,  1.003416,  0.989488,  0.997641,  1.006926,  1.000441,  0.985648,  1.008547,  0.998570,  0.998440,  0.993988,  1.008066,  1.006657,  0.987405,  0.994505,  1.006461,  1.007715,  0.981853,  1.003112,  1.007300,  0.997528,  0.985222,  1.009239,  0.999553,  0.996324,  0.994092,  1.008916,  1.008439,  0.985196,  0.991124,  1.010689,  1.007528,  0.971431,  1.012723,  1.001674,  1.006323,  0.984646,  1.006287,  1.003158,  0.989873, },
{ 1.000000,  0.999887,  1.000333,  1.000138,  0.999445,  0.999752,  1.000457,  1.000670,  0.997252,  1.001258,  1.000381,  1.000059,  0.999027,  1.000803,  1.000225,  0.998130,  0.999074,  1.002059,  1.001374,  0.997762,  0.997525,  1.003274,  1.001265,  0.991723,  1.002503,  1.001475,  0.999792,  0.998733,  1.001728,  1.001437,  0.996324,  0.997930,  1.002935,  1.002553,  0.993183,  0.998329,  1.004374,  0.999856,  0.992169,  1.004677,  1.000069,  0.997607,  0.997385,  1.004038,  1.004027,  0.992964,  0.997084,  1.003766,  1.004211,  0.989911,  1.001163,  1.004346,  0.998394,  0.988989,  1.008172,  0.999201,  0.996730,  0.996989,  1.005977,  1.005234,  0.989790,  0.994121,  1.007408,  1.004748,  0.981517,  1.008390,  1.001973,  1.002914,  0.988898,  1.003868,  1.002248,  0.994023,  0.992907,  1.010345,  1.004311,  0.988716,  0.994911,  1.008548,  1.007092,  0.973307,  1.012125,  1.001112,  0.999285,  0.994695,  1.003916,  1.002921,  0.989199,  0.993155,  1.011871,  1.006241,  0.989280,  0.989258,  1.014242,  1.006841,  0.966197,  1.008944,  1.005388,  0.999901,  0.995452,  1.006530, },
{ 1.000000,  1.000020,  0.999779,  0.999792,  1.000446,  1.000431,  0.998732,  0.999625,  1.000926,  0.999936,  0.997850,  1.001309,  1.000041,  0.999414,  0.999176,  1.001410,  1.001328,  0.997599,  0.998652,  1.001442,  1.001599,  0.995599,  1.000950,  1.001638,  0.999666,  0.994322,  1.003878,  1.000243,  0.998473,  0.997592,  1.004107,  1.001776,  0.995080,  0.996696,  1.003275,  1.003220,  0.990151,  1.004220,  1.000905,  1.001668,  0.993054,  1.002815,  1.002010,  0.995672,  0.996491,  1.005658,  1.003040,  0.993422,  0.996329,  1.005299,  1.004268,  0.982498,  1.007728,  1.001253,  0.999729,  0.996293,  1.001439,  1.004315,  0.992840,  0.993536,  1.008233,  1.004497,  0.990905,  0.994258,  1.009502,  1.005728,  0.975698,  1.008847,  1.002292,  0.998857,  0.997054,  1.004649,  1.001937,  0.991950,  0.995492,  1.008117,  1.006042,  0.984612,  0.995280,  1.009894,  1.001086,  0.979090,  1.010136,  1.001362,  0.996676,  0.994914,  1.009634,  1.005755,  0.986654,  0.993297,  1.007358,  1.007136,  0.980995,  1.005114,  1.003073,  1.001098,  0.977192,  1.015434,  0.998735,  0.995786, },
{ 1.000000,  0.999930,  1.000278,  1.000156,  0.999364,  0.999522,  1.000422,  1.000767,  0.997873,  1.000851,  1.000482,  1.000390,  0.997863,  1.000795,  1.000674,  0.998969,  0.998510,  1.001999,  1.001619,  0.996860,  0.998626,  1.001898,  1.002127,  0.992054,  1.003543,  1.000430,  1.000129,  0.997934,  1.001011,  1.002006,  0.996196,  0.996310,  1.005225,  1.001732,  0.994871,  0.996454,  1.005345,  1.003336,  0.986867,  1.005376,  1.000708,  0.998857,  0.998665,  1.002992,  1.001082,  0.995213,  0.995771,  1.006114,  1.003672,  0.990954,  0.996269,  1.006698,  1.001321,  0.984877,  1.006589,  1.001180,  0.997547,  0.997602,  1.005831,  1.003571,  0.991418,  0.995695,  1.004881,  1.004531,  0.987449,  1.002262,  1.003836,  1.000284,  0.984388,  1.009726,  0.999807,  0.997282,  0.995216,  1.008527,  1.004455,  0.988567,  0.991563,  1.007018,  1.008470,  0.979393,  1.007116,  1.004277,  1.001464,  0.984325,  1.007763,  1.001865,  0.993869,  0.992696,  1.011136,  1.006244,  0.986102,  0.992983,  1.010543,  1.006774,  0.969133,  1.014389,  1.000014,  1.002283,  0.989728,  1.007946, },
{ 1.000000,  1.000035,  0.999753,  0.999689,  1.000563,  1.000259,  0.999187,  0.999373,  1.000999,  1.000932,  0.996258,  1.001810,  1.000094,  0.999641,  0.999605,  1.001028,  1.000046,  0.998156,  0.998724,  1.002736,  1.001036,  0.996656,  0.998129,  1.002767,  1.001052,  0.992493,  1.003286,  1.000558,  0.999300,  0.998747,  1.002752,  1.001337,  0.995934,  0.997501,  1.003007,  1.002373,  0.993092,  0.999491,  1.003673,  0.999565,  0.991527,  1.005684,  0.999538,  0.998940,  0.995321,  1.006493,  1.003007,  0.992042,  0.996159,  1.003704,  1.005693,  0.987302,  1.003525,  1.003424,  1.001243,  0.988548,  1.005410,  1.001094,  0.995389,  0.996410,  1.006268,  1.005133,  0.989794,  0.995082,  1.008546,  1.003771,  0.979327,  1.009159,  1.000480,  1.002362,  0.990892,  1.005762,  1.001195,  0.993324,  0.991479,  1.012390,  1.003183,  0.989659,  0.994754,  1.008415,  1.007695,  0.970717,  1.012959,  1.000503,  0.999071,  0.995241,  1.005239,  1.002431,  0.989857,  0.994413,  1.012459,  1.004573,  0.985813,  0.991710,  1.013262,  1.005183,  0.968680,  1.010513,  1.005365,  0.996033, },
{ 1.000000,  0.999938,  1.000212,  1.000145,  0.999470,  0.999645,  1.000452,  1.000528,  0.998431,  0.999916,  1.001098,  1.000087,  0.997227,  1.001922,  0.999397,  0.999887,  0.998024,  1.002366,  1.001383,  0.996822,  0.998610,  1.001669,  1.002168,  0.994657,  1.001165,  1.001845,  1.000230,  0.994383,  1.002735,  1.000311,  0.998413,  0.998228,  1.002841,  1.002908,  0.994261,  0.996938,  1.004914,  1.002347,  0.987970,  1.005089,  1.000675,  1.002961,  0.992587,  1.003702,  1.001208,  0.994721,  0.995123,  1.008096,  1.002694,  0.992830,  0.996509,  1.005040,  1.005698,  0.980976,  1.007682,  1.001449,  0.999309,  0.997022,  1.003394,  1.000259,  0.992974,  0.996378,  1.008584,  1.003479,  0.992569,  0.991850,  1.009325,  1.006148,  0.975255,  1.006488,  1.004878,  0.997455,  0.995995,  1.006169,  1.003551,  0.990489,  0.994379,  1.007315,  1.004547,  0.985872,  0.996841,  1.009474,  1.000452,  0.981071,  1.011246,  0.998175,  0.998042,  0.992017,  1.010662,  1.008505,  0.983627,  0.992969,  1.008516,  1.009903,  0.976656,  1.003954,  1.009630,  0.996774,  0.981178,  1.011807, },
{ 1.000000,  1.000001,  0.999913,  0.999770,  1.000449,  1.000515,  0.998934,  0.999264,  1.001028,  1.000784,  0.996717,  1.001572,  1.000268,  1.000906,  0.997619,  1.001048,  1.000521,  0.998175,  0.997915,  1.003254,  1.000947,  0.996910,  0.998871,  1.001856,  1.002348,  0.991016,  1.003814,  1.001119,  1.000149,  0.997525,  1.002000,  1.000498,  0.995836,  0.997995,  1.004325,  1.002822,  0.995530,  0.995186,  1.006267,  1.002311,  0.984999,  1.004478,  1.002644,  0.999654,  0.997754,  1.002965,  1.002360,  0.993963,  0.996685,  1.004767,  1.004027,  0.989256,  0.997413,  1.006847,  0.999695,  0.988169,  1.006956,  1.000144,  0.996470,  0.996094,  1.006009,  1.005777,  0.989816,  0.995839,  1.005482,  1.005962,  0.985753,  1.001576,  1.006272,  0.997740,  0.984748,  1.011248,  0.998878,  0.995616,  0.995817,  1.008200,  1.006975,  0.986240,  0.992148,  1.009993,  1.006348,  0.975415,  1.011013,  1.002792,  1.003827,  0.985371,  1.005127,  1.002869,  0.992308,  0.990810,  1.013365,  1.005474,  0.985449,  0.993455,  1.011105,  1.009009,  0.965977,  1.015368,  1.001587,  0.999135, },
{ 1.000000,  0.999933,  1.000099,  1.000114,  0.999458,  0.999579,  1.000866,  1.000528,  0.998959,  0.998850,  1.001675,  1.000849,  0.995361,  1.001318,  1.000876,  0.999994,  0.999165,  1.001233,  1.000425,  0.997821,  0.998575,  1.002512,  1.002021,  0.994800,  0.998648,  1.003149,  0.999773,  0.993819,  1.003527,  1.000140,  0.998557,  0.998069,  1.003235,  1.002876,  0.994826,  0.997230,  1.002986,  1.003174,  0.991468,  1.001729,  1.003166,  0.999343,  0.989815,  1.006855,  1.000382,  0.997410,  0.995857,  1.006895,  1.002851,  0.991917,  0.994699,  1.005319,  1.005115,  0.984487,  1.006557,  1.001548,  1.002549,  0.989350,  1.004313,  1.002947,  0.993607,  0.994756,  1.008345,  1.004392,  0.990462,  0.994684,  1.007731,  1.006021,  0.975095,  1.010952,  1.001844,  0.999632,  0.994762,  1.002052,  1.005910,  0.990110,  0.991189,  1.011284,  1.006132,  0.987569,  0.992244,  1.012967,  1.007629,  0.967496,  1.011816,  1.003108,  0.998491,  0.995945,  1.006312,  1.002510,  0.989447,  0.994139,  1.010796,  1.007832,  0.979818,  0.993895,  1.013061,  1.001249,  0.973075,  1.012953, },
{ 1.000000,  1.000021,  0.999916,  0.999798,  1.000486,  1.000355,  0.999028,  0.999448,  1.000719,  1.000742,  0.997798,  1.000629,  1.000479,  1.000141,  0.996454,  1.002547,  0.999767,  0.999234,  0.998733,  1.002789,  1.001027,  0.996502,  0.997795,  1.001760,  1.002786,  0.992990,  1.002565,  1.001487,  1.001017,  0.994569,  1.001969,  1.001558,  0.997699,  0.996782,  1.004222,  1.003280,  0.993733,  0.997324,  1.003685,  1.003957,  0.985451,  1.006402,  1.000828,  1.000228,  0.996454,  1.001734,  1.003308,  0.993779,  0.994038,  1.008412,  1.002755,  0.991886,  0.994473,  1.008371,  1.005074,  0.979992,  1.008126,  1.001109,  0.998307,  0.997950,  1.004444,  1.001511,  0.993080,  0.993919,  1.008784,  1.005263,  0.987077,  0.994747,  1.009514,  1.001754,  0.979041,  1.009028,  1.001731,  0.996652,  0.996667,  1.008041,  1.004793,  0.988409,  0.994230,  1.006672,  1.005992,  0.983267,  1.002968,  1.005312,  1.000281,  0.979502,  1.012725,  0.999730,  0.996469,  0.993764,  1.011204,  1.005659,  0.985240,  0.989186,  1.009141,  1.010879,  0.973585,  1.009009,  1.005703,  1.001815, },
{ 1.000000,  0.999809,  1.000207,  1.000069,  0.999718,  0.999566,  1.000820,  1.000522,  0.998720,  0.999294,  1.001235,  1.000858,  0.995884,  1.002091,  1.000044,  1.000400,  0.998261,  1.001482,  1.000786,  0.997609,  0.997826,  1.003129,  1.001220,  0.996788,  0.997783,  1.003300,  1.002807,  0.989525,  1.004846,  1.000339,  0.999182,  0.999078,  1.002382,  1.000163,  0.996229,  0.997484,  1.005476,  1.002091,  0.993694,  0.996672,  1.005199,  1.001923,  0.986972,  1.005725,  1.001120,  0.998891,  0.997964,  1.004656,  1.002219,  0.993613,  0.996141,  1.004906,  1.003756,  0.989439,  0.999328,  1.005804,  0.999377,  0.987585,  1.008471,  0.999423,  0.998577,  0.993367,  1.009498,  1.004363,  0.988850,  0.994693,  1.005423,  1.008109,  0.982423,  1.004972,  1.005068,  1.001809,  0.984441,  1.007493,  1.001595,  0.993999,  0.995298,  1.008622,  1.006941,  0.986558,  0.993647,  1.011558,  1.005147,  0.972976,  1.012177,  1.000931,  1.003259,  0.988283,  1.007717,  1.001681,  0.991654,  0.989306,  1.016046,  1.004202,  0.986964,  0.993524,  1.010958,  1.009875,  0.963300,  1.016565, },
{ 1.000000,  1.000007,  0.999983,  0.999811,  1.000272,  1.000139,  0.999267,  0.999540,  1.001181,  1.000493,  0.998341,  0.998963,  1.001834,  1.000732,  0.995115,  1.001725,  1.000964,  0.999260,  0.998721,  1.002168,  1.001032,  0.997097,  0.998328,  1.001857,  1.001878,  0.994807,  0.999729,  1.003178,  1.000206,  0.992941,  1.004649,  0.998589,  0.999724,  0.995729,  1.005054,  1.002828,  0.993620,  0.997277,  1.003227,  1.004058,  0.990139,  1.002098,  1.003376,  1.000394,  0.990283,  1.004658,  1.000507,  0.997396,  0.997062,  1.004670,  1.004589,  0.990863,  0.995219,  1.007711,  1.003646,  0.981588,  1.007774,  1.001096,  1.004388,  0.988953,  1.005525,  1.001682,  0.992365,  0.992953,  1.011690,  1.003814,  0.989722,  0.995066,  1.007196,  1.007952,  0.973506,  1.010717,  1.002085,  0.999023,  0.995861,  1.004710,  1.000322,  0.990470,  0.995162,  1.011571,  1.004724,  0.989982,  0.989158,  1.012531,  1.008024,  0.967433,  1.008528,  1.006400,  0.996672,  0.994653,  1.008111,  1.004590,  0.987660,  0.992804,  1.009503,  1.005858,  0.981782,  0.996002,  1.012340,  1.000432, },
{ 1.000000,  0.999763,  1.000289,  0.999940,  0.999903,  0.999507,  1.000782,  1.000697,  0.998453,  0.999264,  1.000997,  1.001259,  0.996830,  1.000578,  1.001534,  0.999457,  0.996757,  1.002160,  0.999887,  0.999114,  0.998414,  1.002480,  1.002342,  0.995657,  0.997342,  1.003415,  1.002417,  0.990630,  1.004216,  1.000742,  1.002194,  0.994431,  1.002378,  1.001104,  0.996168,  0.995737,  1.006536,  1.001852,  0.994055,  0.997897,  1.003444,  1.004239,  0.984091,  1.006703,  1.001976,  1.000223,  0.995856,  1.003359,  1.000789,  0.993270,  0.996817,  1.006814,  1.004449,  0.992982,  0.992611,  1.009617,  1.003506,  0.977487,  1.006685,  1.003979,  0.999445,  0.996664,  1.004364,  1.003375,  0.991294,  0.995341,  1.006835,  1.005686,  0.984859,  0.996441,  1.009646,  0.999513,  0.983705,  1.009539,  1.000179,  0.995187,  0.994678,  1.008261,  1.007754,  0.986259,  0.994485,  1.007439,  1.007968,  0.981012,  1.002084,  1.008483,  0.997005,  0.980023,  1.014750,  0.998471,  0.994354,  0.994531,  1.010742,  1.008959,  0.982187,  0.989969,  1.012951,  1.008216,  0.968518,  1.014000, },
{ 1.000000,  1.000036,  1.000099,  0.999448,  1.000266,  1.000171,  0.999446,  0.999225,  1.001267,  1.000564,  0.998315,  0.999189,  1.001522,  1.001312,  0.994715,  1.002527,  1.000303,  0.999843,  0.998682,  1.001020,  1.000729,  0.997062,  0.998126,  1.003425,  1.001911,  0.996641,  0.996596,  1.004721,  1.002240,  0.988414,  1.003156,  1.002003,  0.999943,  0.998217,  1.002605,  1.000851,  0.995766,  0.997295,  1.004712,  1.003693,  0.990612,  0.997614,  1.005534,  0.999563,  0.989683,  1.005805,  1.000259,  0.997622,  0.996886,  1.005138,  1.004491,  0.991947,  0.995801,  1.004606,  1.004744,  0.987289,  1.002551,  1.004795,  0.998985,  0.985267,  1.009883,  1.000512,  0.996306,  0.994102,  1.009718,  1.003891,  0.988727,  0.992675,  1.007408,  1.007024,  0.978736,  1.008908,  1.002237,  1.003422,  0.985639,  1.005848,  1.003831,  0.991556,  0.993024,  1.011033,  1.005704,  0.987524,  0.993095,  1.010145,  1.007760,  0.967817,  1.014177,  1.002417,  0.999528,  0.993286,  1.002661,  1.007431,  0.987454,  0.988948,  1.014249,  1.007726,  0.984353,  0.990342,  1.016280,  1.009478, },
{ 1.000000,  0.999592,  1.000304,  1.000120,  0.999931,  0.999750,  1.000462,  1.000215,  0.999014,  0.999403,  1.001256,  1.000977,  0.997271,  0.999146,  1.002031,  1.000173,  0.995399,  1.002327,  1.000403,  0.999136,  0.998650,  1.002668,  1.001604,  0.996041,  0.998013,  1.002377,  1.002256,  0.993704,  1.001657,  1.001274,  1.000310,  0.991739,  1.005685,  0.999499,  0.998412,  0.997383,  1.005594,  1.001982,  0.993335,  0.995937,  1.003267,  1.005010,  0.987591,  1.004485,  1.002640,  1.001719,  0.990928,  1.003316,  1.002509,  0.996303,  0.994890,  1.006656,  1.005071,  0.990310,  0.995906,  1.005703,  1.005962,  0.978208,  1.009556,  1.001286,  1.000310,  0.994793,  1.002520,  1.004688,  0.991129,  0.991575,  1.011906,  1.003862,  0.988609,  0.992328,  1.011694,  1.007012,  0.972476,  1.011195,  1.001547,  0.997704,  0.997126,  1.006037,  1.001953,  0.990759,  0.991897,  1.011748,  1.007041,  0.982818,  0.993124,  1.012620,  1.002254,  0.972713,  1.011692,  1.002334,  0.995604,  0.995628,  1.010462,  1.006132,  0.985119,  0.992697,  1.008638,  1.007600,  0.978694,  1.003803, },
{ 1.000000,  1.000058,  1.000002,  0.999228,  1.000629,  0.999979,  0.999734,  0.999478,  1.001082,  1.000583,  0.998278,  0.998641,  1.001255,  1.001601,  0.995869,  1.001483,  1.001039,  1.000318,  0.996146,  1.002009,  1.000452,  0.998356,  0.997913,  1.003314,  1.001838,  0.995655,  0.997769,  1.003558,  1.002306,  0.989249,  1.005150,  1.000065,  1.000821,  0.996087,  1.003106,  1.001529,  0.995075,  0.995645,  1.006008,  1.002228,  0.993904,  0.995842,  1.005862,  1.004848,  0.981613,  1.008274,  1.000505,  0.998498,  0.998323,  1.003842,  1.000145,  0.993835,  0.995929,  1.008522,  1.003184,  0.990014,  0.994830,  1.007924,  1.002775,  0.980314,  1.008406,  1.001631,  0.998183,  0.996833,  1.006713,  1.003008,  0.990625,  0.994379,  1.006949,  1.005194,  0.984818,  0.998966,  1.008123,  0.998909,  0.982599,  1.011564,  0.999032,  0.997892,  0.990788,  1.012870,  1.005708,  0.984704,  0.992654,  1.007214,  1.010718,  0.976134,  1.006462,  1.006746,  1.002141,  0.979125,  1.009705,  1.001825,  0.991971,  0.993599,  1.011173,  1.008780,  0.982244,  0.991620,  1.014855,  1.006528, },
{ 1.000000,  0.999640,  1.000321,  1.000036,  1.000155,  0.999258,  1.000566,  1.000123,  0.999195,  0.998842,  1.001863,  1.000506,  0.998187,  0.999018,  1.001711,  1.001607,  0.993511,  1.003043,  1.000169,  0.999724,  0.998717,  1.001493,  1.000665,  0.997014,  0.998350,  1.003889,  1.001526,  0.995229,  0.997228,  1.004691,  1.001715,  0.988710,  1.003881,  1.002089,  0.998447,  0.997386,  1.004325,  1.001992,  0.994488,  0.996897,  1.003420,  1.003371,  0.990820,  0.999536,  1.005490,  1.000273,  0.988253,  1.007595,  0.997737,  0.999553,  0.993176,  1.007976,  1.004385,  0.990082,  0.995804,  1.004933,  1.006105,  0.985142,  1.003101,  1.005068,  1.000556,  0.985850,  1.006759,  1.000710,  0.996279,  0.995738,  1.006663,  1.006391,  0.987158,  0.993325,  1.010782,  1.005090,  0.974599,  1.010715,  1.001557,  1.005901,  0.984995,  1.007500,  1.002186,  0.989817,  0.990577,  1.015574,  1.005019,  0.986347,  0.993511,  1.009542,  1.010414,  0.965398,  1.013992,  1.002754,  0.998694,  0.994600,  1.006117,  1.000336,  0.987784,  0.993865,  1.014728,  1.006112,  0.987142,  0.986250, },
{ 1.000000,  1.000175,  1.000193,  0.998782,  1.000423,  1.000389,  0.999755,  0.999538,  1.000760,  1.000477,  0.998582,  0.999106,  1.001280,  1.000860,  0.997164,  0.999366,  1.002155,  1.000056,  0.995425,  1.002843,  0.999539,  0.999498,  0.997719,  1.003152,  1.002512,  0.994889,  0.997788,  1.002845,  1.003374,  0.991886,  1.001425,  1.003618,  0.998760,  0.992964,  1.004573,  0.999748,  0.998215,  0.996934,  1.004784,  1.004355,  0.992006,  0.995189,  1.006091,  1.004225,  0.983858,  1.007105,  1.001278,  1.003602,  0.990881,  1.003873,  1.001694,  0.993941,  0.993315,  1.010175,  1.002847,  0.990906,  0.996806,  1.005219,  1.006320,  0.976425,  1.009909,  1.002919,  1.000231,  0.994026,  1.004865,  1.001067,  0.990404,  0.995515,  1.009546,  1.006275,  0.990136,  0.989769,  1.013271,  1.004815,  0.969197,  1.009120,  1.005433,  0.999195,  0.995431,  1.005918,  1.004453,  0.988332,  0.993908,  1.009082,  1.007545,  0.979933,  0.995410,  1.012720,  0.999265,  0.978812,  1.012370,  1.000217,  0.993780,  0.993135,  1.010713,  1.009921,  0.982319,  0.993001,  1.009562,  1.010213, },
{ 1.000000,  0.999757,  1.000052,  1.000332,  0.999830,  0.998773,  1.001085,  0.999864,  0.999464,  0.999408,  1.001267,  1.001122,  0.997546,  0.998545,  1.002039,  1.001372,  0.994455,  1.002569,  1.000723,  1.000955,  0.996058,  1.001467,  1.000778,  0.997741,  0.997198,  1.004203,  1.001739,  0.995115,  0.997767,  1.003930,  1.003229,  0.987465,  1.005741,  1.000670,  0.999655,  0.997252,  1.002037,  1.001421,  0.994351,  0.996477,  1.006328,  1.003539,  0.993924,  0.994018,  1.008229,  1.003820,  0.980386,  1.005313,  1.003325,  0.999873,  0.997072,  1.004174,  1.001303,  0.993339,  0.995797,  1.007319,  1.005649,  0.985625,  0.996411,  1.008356,  0.999291,  0.984767,  1.008459,  1.000407,  0.996486,  0.995469,  1.007352,  1.006399,  0.988486,  0.994102,  1.006473,  1.006673,  0.982221,  1.003523,  1.006760,  0.998504,  0.979813,  1.013511,  1.000649,  0.994942,  0.991966,  1.013138,  1.005138,  0.984792,  0.990204,  1.009919,  1.009372,  0.971685,  1.011758,  1.003064,  1.004447,  0.981089,  1.007715,  1.004905,  0.988980,  0.990865,  1.014325,  1.007329,  0.983863,  0.991094, },
{ 1.000000,  1.000127,  1.000201,  0.998788,  1.000710,  1.000150,  0.999969,  0.999435,  1.000259,  1.000777,  0.998536,  0.998613,  1.001936,  1.001130,  0.997547,  0.998408,  1.002833,  1.001755,  0.992275,  1.002955,  1.000818,  0.999589,  0.998817,  1.001869,  1.000714,  0.996767,  0.998183,  1.003530,  1.002627,  0.993036,  0.997920,  1.004734,  1.000365,  0.990039,  1.004855,  1.000879,  0.998245,  0.997376,  1.005034,  1.002964,  0.992714,  0.996429,  1.004233,  1.003942,  0.989170,  1.002743,  1.002220,  1.000459,  0.986569,  1.009099,  0.999182,  0.997488,  0.995852,  1.008679,  1.002999,  0.989852,  0.993904,  1.004914,  1.007478,  0.981582,  1.006590,  1.003913,  1.002459,  0.986916,  1.004784,  1.003536,  0.994753,  0.992810,  1.009327,  1.007021,  0.986519,  0.994303,  1.007890,  1.008173,  0.970203,  1.013036,  1.001757,  1.000369,  0.993027,  1.003328,  1.006155,  0.988213,  0.988911,  1.015654,  1.005120,  0.984974,  0.989956,  1.015320,  1.009137,  0.964157,  1.014524,  1.001992,  0.996984,  0.996224,  1.007719,  1.002402,  0.988189,  0.989699,  1.014897,  1.008999, },
{ 1.000000,  0.999773,  0.999828,  1.000471,  1.000109,  0.998316,  1.000846,  1.000192,  0.999563,  0.999534,  1.001204,  1.000776,  0.997953,  0.998929,  1.001358,  1.001250,  0.996257,  1.000704,  1.001353,  1.000033,  0.994554,  1.003489,  0.999894,  0.998944,  0.998101,  1.003562,  1.001777,  0.995102,  0.996361,  1.003224,  1.003908,  0.990322,  1.003315,  1.002299,  1.000651,  0.992093,  1.004028,  1.000854,  0.996873,  0.996099,  1.006084,  1.003311,  0.992315,  0.996110,  1.006127,  1.003934,  0.982013,  1.008517,  1.000092,  1.001292,  0.993759,  1.004878,  1.002324,  0.992368,  0.993316,  1.009184,  1.003343,  0.990795,  0.993809,  1.008646,  1.007085,  0.973113,  1.012000,  1.000729,  0.997781,  0.997558,  1.005470,  1.000198,  0.991354,  0.994344,  1.011806,  1.004437,  0.986105,  0.992974,  1.010928,  1.003722,  0.973308,  1.011331,  1.002313,  0.997453,  0.995727,  1.008919,  1.003941,  0.987550,  0.992596,  1.009196,  1.006813,  0.980003,  0.998712,  1.010716,  0.998486,  0.977539,  1.014875,  0.998714,  0.997240,  0.988226,  1.016476,  1.007242,  0.980485,  0.990607, },
{ 1.000000,  1.000091,  1.000277,  0.999103,  1.000325,  1.000425,  1.000142,  0.998241,  1.000918,  1.000190,  0.999078,  0.999188,  1.001542,  1.001272,  0.997230,  0.998623,  1.002576,  1.001195,  0.993201,  1.003142,  1.000227,  1.000838,  0.996553,  1.002294,  1.000442,  0.997324,  0.996486,  1.005318,  1.001345,  0.995324,  0.997593,  1.003994,  1.003628,  0.985821,  1.006476,  1.000327,  0.999411,  0.997501,  1.002876,  1.001232,  0.994507,  0.997042,  1.006904,  1.002725,  0.991716,  0.995299,  1.007908,  1.002796,  0.981481,  1.006307,  1.003388,  0.997477,  0.995911,  1.006767,  1.003051,  0.991542,  0.995291,  1.005164,  1.005066,  0.986302,  0.999330,  1.008100,  1.000310,  0.983062,  1.010845,  0.996774,  0.999376,  0.990345,  1.011305,  1.006148,  0.986110,  0.994127,  1.006859,  1.008453,  0.979500,  1.004233,  1.007018,  1.000755,  0.980858,  1.009096,  1.000940,  0.995000,  0.994233,  1.008905,  1.008388,  0.982975,  0.991213,  1.014237,  1.006771,  0.966736,  1.014071,  1.002062,  1.007549,  0.980573,  1.009774,  1.002700,  0.986949,  0.987921,  1.019976,  1.006412, },
{ 1.000000,  0.999828,  0.999829,  1.000364,  1.000522,  0.997877,  1.001031,  1.000235,  0.999867,  0.999425,  1.000717,  1.000038,  0.998339,  0.999116,  1.002287,  1.001024,  0.997740,  0.997473,  1.003102,  1.002002,  0.991389,  1.002336,  1.001829,  0.999001,  0.998332,  1.002536,  1.001464,  0.995917,  0.997601,  1.003293,  1.002103,  0.993303,  0.998564,  1.004778,  1.000072,  0.990578,  1.005693,  0.999077,  0.999024,  0.995663,  1.005798,  1.004533,  0.990827,  0.996147,  1.004934,  1.005803,  0.986254,  1.002398,  1.005979,  0.997944,  0.988695,  1.007308,  0.999566,  0.997199,  0.995212,  1.007369,  1.006598,  0.987849,  0.992786,  1.009134,  1.006296,  0.976145,  1.010365,  1.001912,  1.005128,  0.986855,  1.005570,  1.002310,  0.991380,  0.990554,  1.014307,  1.003970,  0.987290,  0.995587,  1.007171,  1.008711,  0.967690,  1.013549,  1.004011,  1.000199,  0.991994,  1.006568,  1.001332,  0.987157,  0.994056,  1.012587,  1.008375,  0.986847,  0.986510,  1.017414,  1.006346,  0.959768,  1.011853,  1.007109,  0.998849,  0.994030,  1.007674,  1.005668,  0.984944,  0.992236, },
{ 1.000000,  1.000115,  1.000200,  0.999237,  0.999781,  1.000786,  0.999950,  0.998213,  1.001170,  1.000011,  0.999278,  0.999127,  1.001474,  1.001464,  0.997226,  0.998844,  1.001670,  1.001889,  0.995291,  1.000537,  1.002313,  0.999139,  0.994296,  1.004341,  0.999492,  0.998228,  0.998206,  1.003608,  1.003017,  0.993729,  0.996462,  1.004765,  1.003119,  0.987897,  1.005427,  1.001500,  1.001875,  0.992331,  1.002837,  1.001420,  0.995857,  0.994984,  1.007451,  1.003011,  0.991573,  0.996238,  1.006561,  1.005331,  0.979473,  1.009274,  1.001106,  0.999445,  0.995677,  1.003149,  1.002169,  0.991362,  0.994715,  1.009447,  1.005348,  0.990971,  0.991216,  1.012044,  1.005560,  0.971658,  1.007632,  1.004775,  0.999778,  0.995859,  1.005872,  1.001825,  0.990748,  0.994227,  1.010097,  1.007734,  0.980246,  0.995104,  1.011421,  0.998990,  0.979538,  1.011282,  1.000589,  0.995191,  0.993960,  1.009690,  1.008469,  0.984728,  0.992304,  1.008464,  1.008755,  0.976839,  1.004585,  1.008897,  0.997978,  0.974110,  1.017387,  1.000800,  0.993466,  0.989726,  1.016688,  1.006457, },
{ 1.000000,  0.999801,  0.999750,  1.000375,  1.000473,  0.998248,  1.000865,  1.000256,  1.000401,  0.997992,  1.000911,  1.000618,  0.998487,  0.998649,  1.002233,  1.001210,  0.997178,  0.998367,  1.002526,  1.002020,  0.991352,  1.003978,  1.000706,  0.999843,  0.997941,  1.000844,  1.002383,  0.995762,  0.996255,  1.004989,  1.002813,  0.994219,  0.996386,  1.006232,  1.003731,  0.983972,  1.005928,  1.001623,  0.999188,  0.997755,  1.003457,  1.001310,  0.994231,  0.996839,  1.006130,  1.004522,  0.988167,  0.996552,  1.007850,  1.000536,  0.983911,  1.007718,  1.001453,  0.997190,  0.995928,  1.007736,  1.004528,  0.988853,  0.994657,  1.006339,  1.005880,  0.983914,  1.003980,  1.003332,  1.000615,  0.980608,  1.013014,  0.998799,  0.996390,  0.994115,  1.012267,  1.004198,  0.985811,  0.991532,  1.006821,  1.010358,  0.974532,  1.009059,  1.005430,  1.003289,  0.982236,  1.006500,  1.004723,  0.992932,  0.990382,  1.012437,  1.009226,  0.982062,  0.992421,  1.010450,  1.010765,  0.960767,  1.017121,  1.002344,  1.000403,  0.990983,  1.004232,  1.007857,  0.984796,  0.985767, },
{ 1.000000,  1.000206,  1.000137,  0.999429,  0.999494,  1.000946,  1.000670,  0.996949,  1.001388,  1.000209,  0.999632,  0.999514,  1.001058,  1.000331,  0.998145,  0.998283,  1.002612,  1.001666,  0.995720,  0.998237,  1.003383,  1.000579,  0.992190,  1.003411,  1.000715,  0.998573,  0.998550,  1.003480,  1.002090,  0.994772,  0.997404,  1.003146,  1.002832,  0.991816,  1.001497,  1.002791,  1.000015,  0.989387,  1.006646,  0.999783,  0.997972,  0.996569,  1.006312,  1.003080,  0.991550,  0.993820,  1.005363,  1.006488,  0.984119,  1.005333,  1.003688,  1.001004,  0.987566,  1.006237,  1.001257,  0.995230,  0.994088,  1.009159,  1.004901,  0.988589,  0.994291,  1.008944,  1.005723,  0.973891,  1.012256,  1.000112,  1.001747,  0.991188,  1.006805,  1.003180,  0.989391,  0.990736,  1.012673,  1.004571,  0.987341,  0.991475,  1.011684,  1.009551,  0.963680,  1.016140,  1.000983,  0.996954,  0.996697,  1.007210,  1.000245,  0.988591,  0.992551,  1.015399,  1.005825,  0.981751,  0.990946,  1.014262,  1.004764,  0.965531,  1.014528,  1.003041,  0.996611,  0.994450,  1.011359,  1.004922, },
{ 1.000000,  0.999845,  0.999807,  1.000354,  1.000331,  0.998772,  0.999918,  1.000903,  0.999845,  0.997638,  1.001715,  0.999836,  0.999613,  0.998286,  1.002572,  1.001182,  0.996601,  0.998262,  1.001763,  1.002753,  0.993606,  1.001765,  1.001982,  1.000574,  0.993642,  1.002992,  1.000541,  0.997370,  0.997814,  1.003907,  1.003069,  0.993499,  0.996909,  1.005616,  1.002567,  0.986004,  1.006290,  1.000446,  1.001548,  0.993512,  1.004227,  1.000776,  0.995261,  0.993889,  1.009091,  1.002248,  0.992156,  0.996001,  1.006494,  1.005869,  0.977299,  1.010285,  1.000494,  0.998996,  0.996150,  1.004371,  1.001821,  0.991739,  0.995584,  1.010173,  1.004071,  0.987769,  0.993193,  1.011399,  1.003940,  0.973526,  1.008975,  1.004771,  0.996382,  0.994322,  1.009411,  1.004199,  0.988258,  0.993524,  1.007038,  1.006938,  0.981304,  0.999100,  1.010895,  1.000282,  0.977335,  1.014314,  0.995743,  0.999101,  0.987227,  1.014890,  1.008077,  0.981683,  0.992291,  1.008859,  1.011003,  0.973208,  1.005458,  1.009102,  1.000941,  0.975411,  1.011594,  1.001142,  0.993567,  0.992492, },
{ 1.000000,  1.000115,  1.000209,  0.999347,  0.999561,  1.000863,  1.000506,  0.997179,  1.001354,  1.000204,  1.000862,  0.997520,  1.001347,  1.000381,  0.997950,  0.998001,  1.003514,  1.001174,  0.996597,  0.998321,  1.002581,  1.002915,  0.990019,  1.004195,  1.000846,  0.999521,  0.998224,  1.002045,  1.000057,  0.995717,  0.997825,  1.005352,  1.002361,  0.994965,  0.994623,  1.006411,  1.003992,  0.983035,  1.004464,  1.003412,  0.998112,  0.996941,  1.004513,  1.002554,  0.992900,  0.995890,  1.005528,  1.003539,  0.988884,  0.997678,  1.007725,  1.000023,  0.985130,  1.008875,  0.998569,  0.998515,  0.993342,  1.008761,  1.006799,  0.986235,  0.994281,  1.007266,  1.008552,  0.979898,  1.003507,  1.008641,  0.996996,  0.983965,  1.010336,  0.999354,  0.996020,  0.993300,  1.010270,  1.009108,  0.983150,  0.990048,  1.012543,  1.008583,  0.967491,  1.014000,  1.002603,  1.006774,  0.982351,  1.007445,  1.002973,  0.988494,  0.987448,  1.018907,  1.005225,  0.983270,  0.994136,  1.009341,  1.011421,  0.957924,  1.017605,  1.005208,  1.000077,  0.989750,  1.008402,  1.001620, },
{ 1.000000,  0.999830,  0.999857,  1.000465,  1.000405,  0.999189,  0.999040,  1.001428,  1.000594,  0.995808,  1.001338,  1.000889,  0.999814,  0.999127,  1.001171,  1.000899,  0.997400,  0.998607,  1.002168,  1.001907,  0.994663,  0.998787,  1.003576,  0.999760,  0.993626,  1.003777,  1.000018,  0.997924,  0.997669,  1.003683,  1.003487,  0.993529,  0.997415,  1.003578,  1.003965,  0.990397,  1.001072,  1.004450,  0.998362,  0.989477,  1.007805,  0.999055,  0.996879,  0.996894,  1.006140,  1.005019,  0.989553,  0.994197,  1.007669,  1.004993,  0.980778,  1.008463,  1.002296,  1.002813,  0.988293,  1.004283,  1.002071,  0.993803,  0.992576,  1.010877,  1.004323,  0.987753,  0.994586,  1.009312,  1.007576,  0.970864,  1.012976,  1.001528,  0.999201,  0.993998,  1.004305,  1.002910,  0.988192,  0.992848,  1.012666,  1.007320,  0.987794,  0.988243,  1.016031,  1.007390,  0.962362,  1.010038,  1.006281,  0.999610,  0.994549,  1.007620,  1.002359,  0.987966,  0.992531,  1.012965,  1.009892,  0.974512,  0.993693,  1.014591,  0.998614,  0.974041,  1.014173,  1.000732,  0.993761,  0.992348, },
{ 1.000000,  1.000128,  1.000205,  0.999401,  0.999623,  1.000513,  1.000632,  0.998044,  1.000430,  1.000950,  0.999744,  0.996720,  1.002379,  1.000104,  0.998957,  0.998283,  1.002905,  1.001174,  0.996220,  0.997495,  1.002665,  1.002606,  0.991805,  1.003488,  1.000973,  1.001354,  0.993837,  1.002604,  1.001600,  0.996126,  0.996665,  1.005242,  1.002708,  0.993794,  0.996520,  1.005140,  1.004051,  0.982959,  1.007659,  1.001280,  0.999699,  0.996276,  1.001472,  1.004098,  0.992623,  0.993608,  1.008386,  1.004689,  0.990456,  0.994101,  1.009996,  1.005980,  0.974734,  1.009231,  1.002452,  0.998692,  0.996541,  1.005207,  1.001939,  0.991352,  0.995299,  1.008964,  1.006636,  0.982737,  0.995046,  1.011238,  1.000665,  0.977128,  1.010855,  1.002112,  0.995957,  0.994293,  1.010614,  1.006203,  0.984561,  0.992679,  1.008629,  1.008007,  0.978073,  1.005259,  1.004548,  1.000697,  0.974026,  1.017205,  0.998361,  0.995155,  0.992080,  1.016125,  1.005453,  0.981286,  0.988929,  1.008852,  1.013542,  0.966759,  1.011759,  1.007034,  1.004155,  0.977095,  1.008346,  1.005983, },
{ 1.000000,  0.999910,  0.999744,  1.000462,  1.000448,  0.998901,  0.999438,  1.000884,  1.001016,  0.995819,  1.001989,  1.000292,  1.000046,  0.998676,  1.000628,  1.001275,  0.997332,  0.997383,  1.003825,  1.001326,  0.995948,  0.997184,  1.004410,  1.002745,  0.988869,  1.004591,  1.000611,  0.998927,  0.998679,  1.002664,  1.000791,  0.995610,  0.996112,  1.005653,  1.003553,  0.991116,  0.996456,  1.006618,  1.001083,  0.985299,  1.006222,  1.001320,  0.997398,  0.997446,  1.005975,  1.003559,  0.991174,  0.995667,  1.005126,  1.004629,  0.986804,  1.002367,  1.004388,  0.999969,  0.983550,  1.010131,  0.999645,  0.996838,  0.994847,  1.009360,  1.004534,  0.987545,  0.990959,  1.007725,  1.009409,  0.977103,  1.007543,  1.005265,  1.001373,  0.982484,  1.008698,  1.001668,  0.993364,  0.991825,  1.012542,  1.006689,  0.984382,  0.992232,  1.012063,  1.007837,  0.964733,  1.016422,  1.000120,  1.002186,  0.988338,  1.008867,  1.004115,  0.985995,  0.987832,  1.016577,  1.005951,  0.983429,  0.988797,  1.015052,  1.012317,  0.953036,  1.020750,  1.001247,  0.995954,  0.995673, },
{ 1.000000,  1.000094,  1.000007,  0.999571,  0.999628,  1.000942,  1.000425,  0.998446,  0.999153,  1.001514,  1.000546,  0.995653,  1.001965,  1.000450,  0.999443,  0.999059,  1.001944,  1.000888,  0.996940,  0.998115,  1.002422,  1.001859,  0.994255,  0.999659,  1.003270,  0.999472,  0.992824,  1.004835,  0.999517,  0.998979,  0.995863,  1.005947,  1.002635,  0.992600,  0.996284,  1.003571,  1.005487,  0.987451,  1.003359,  1.003706,  1.000998,  0.988525,  1.005221,  1.000929,  0.995448,  0.996253,  1.006498,  1.005036,  0.989338,  0.995010,  1.008892,  1.004090,  0.977999,  1.009767,  1.000660,  1.002265,  0.990173,  1.006324,  1.001158,  0.992990,  0.991011,  1.013165,  1.003198,  0.988672,  0.994158,  1.009219,  1.008313,  0.967892,  1.014436,  1.000653,  0.998471,  0.994710,  1.005952,  1.002435,  0.988655,  0.993996,  1.013678,  1.005544,  0.983410,  0.990827,  1.015172,  1.005150,  0.964800,  1.011855,  1.006251,  0.995117,  0.992629,  1.012223,  1.005435,  0.984678,  0.991542,  1.009018,  1.009007,  0.975806,  0.998801,  1.013902,  1.000180,  0.971132,  1.017965,  0.994571, },
{ 1.000000,  0.999984,  0.999679,  1.000563,  1.000414,  0.998860,  0.999429,  1.000737,  1.001054,  0.997125,  1.000629,  1.001147,  1.000129,  0.996396,  1.001798,  1.000190,  0.998854,  0.998580,  1.002177,  1.002097,  0.995408,  0.997544,  1.004059,  1.002034,  0.989780,  1.004481,  1.000642,  1.002411,  0.993342,  1.003417,  1.000890,  0.995216,  0.995456,  1.007585,  1.002470,  0.992973,  0.996583,  1.005006,  1.005572,  0.981330,  1.007685,  1.001529,  0.999102,  0.996860,  1.003440,  1.000057,  0.992821,  0.996392,  1.008669,  1.003835,  0.991872,  0.991472,  1.010005,  1.006150,  0.973824,  1.006760,  1.005100,  0.997078,  0.995359,  1.006578,  1.003766,  0.989561,  0.994011,  1.007894,  1.005105,  0.984008,  0.996701,  1.010941,  0.999949,  0.979196,  1.012257,  0.997996,  0.997913,  0.990758,  1.011865,  1.009181,  0.981211,  0.992223,  1.009668,  1.011546,  0.972960,  1.004661,  1.011438,  0.995935,  0.978855,  1.013485,  0.999099,  0.994737,  0.991194,  1.013330,  1.011760,  0.978052,  0.987082,  1.016161,  1.011059,  0.958156,  1.017773,  1.003242,  1.008427,  0.977470, },
{ 1.000000,  1.000088,  1.000074,  0.999563,  0.999375,  1.001139,  1.000375,  0.998591,  0.999434,  1.000978,  1.001330,  0.994703,  1.002389,  1.000750,  0.999968,  0.998332,  1.001443,  1.000254,  0.996837,  0.998472,  1.003270,  1.002333,  0.996163,  0.996009,  1.005208,  1.002006,  0.987033,  1.003865,  1.002437,  0.999495,  0.997828,  1.002751,  1.002036,  0.994192,  0.997025,  1.004479,  1.003880,  0.989394,  0.997669,  1.006794,  0.999523,  0.988325,  1.006741,  1.000005,  0.996370,  0.995982,  1.006233,  1.005904,  0.989226,  0.995740,  1.005784,  1.006433,  0.984580,  1.001663,  1.007007,  0.997417,  0.983824,  1.011854,  0.998532,  0.995271,  0.995311,  1.009119,  1.007440,  0.984568,  0.991498,  1.011120,  1.007264,  0.972258,  1.012036,  1.003232,  1.003891,  0.983445,  1.006040,  1.002872,  0.991335,  0.989669,  1.014979,  1.005903,  0.983153,  0.992603,  1.012603,  1.010332,  0.960386,  1.017393,  1.002038,  0.998890,  0.991960,  1.005647,  1.003834,  0.984310,  0.990571,  1.016571,  1.009750,  0.983900,  0.984565,  1.020914,  1.009678,  0.950895,  1.012980,  1.008161, },
{ 1.000000,  0.999996,  0.999866,  1.000291,  1.000124,  0.999219,  0.999443,  1.001116,  1.000945,  0.997236,  0.999239,  1.001899,  0.999799,  0.996122,  1.002235,  1.000110,  0.998846,  0.998546,  1.002344,  1.002186,  0.995843,  0.997868,  1.002389,  1.002623,  0.992853,  1.001421,  1.002931,  0.999246,  0.991157,  1.006082,  1.000234,  0.997508,  0.996093,  1.006298,  1.002471,  0.992157,  0.994924,  1.005193,  1.005031,  0.984485,  1.006399,  1.001784,  1.002400,  0.989158,  1.004462,  1.002674,  0.993450,  0.994396,  1.008583,  1.004369,  0.989982,  0.994397,  1.008066,  1.006371,  0.973559,  1.011772,  1.001915,  0.999495,  0.994400,  1.002140,  1.005990,  0.989056,  0.990621,  1.012129,  1.006818,  0.986268,  0.991509,  1.014145,  1.008522,  0.964378,  1.012830,  1.003386,  0.998144,  0.995186,  1.007115,  1.002612,  0.988171,  0.993567,  1.012094,  1.009024,  0.976616,  0.993320,  1.014972,  1.000771,  0.969525,  1.014285,  1.002886,  0.994569,  0.992453,  1.013738,  1.008074,  0.979709,  0.990449,  1.011092,  1.010393,  0.971513,  1.006604,  1.005958,  1.000843,  0.966683, },
{ 1.000000,  1.000224,  0.999976,  0.999837,  0.999625,  1.001036,  1.000445,  0.998455,  0.998986,  1.001010,  1.001683,  0.995802,  1.001715,  1.001126,  1.000742,  0.996262,  1.001571,  1.001233,  0.998315,  0.997627,  1.003481,  1.002686,  0.994920,  0.997819,  1.003393,  1.003627,  0.987197,  1.005966,  1.001001,  1.000259,  0.996956,  1.001677,  1.003105,  0.994342,  0.994646,  1.008176,  1.002970,  0.992175,  0.994784,  1.008679,  1.005436,  0.979810,  1.008554,  1.001393,  0.998386,  0.998023,  1.004793,  1.001628,  0.993004,  0.993979,  1.009506,  1.006114,  0.986117,  0.994755,  1.010732,  1.002053,  0.977747,  1.009834,  1.002437,  0.996418,  0.996565,  1.009253,  1.005729,  0.987406,  0.994107,  1.007844,  1.007215,  0.981431,  1.003911,  1.006715,  1.000389,  0.977217,  1.014659,  0.999984,  0.995986,  0.993362,  1.013468,  1.006814,  0.983418,  0.988184,  1.011030,  1.013439,  0.969450,  1.010712,  1.007694,  1.002390,  0.977128,  1.012189,  1.002798,  0.991801,  0.989826,  1.017199,  1.009462,  0.980136,  0.990487,  1.016388,  1.010986,  0.954713,  1.021990,  1.000843, },
{ 1.000000,  1.000022,  0.999703,  1.000338,  1.000208,  0.999129,  0.999096,  1.001399,  1.000556,  0.998224,  0.998663,  1.001903,  1.001686,  0.993050,  1.003236,  1.000195,  0.999248,  0.999182,  1.001726,  1.000051,  0.996931,  0.997903,  1.004332,  1.001742,  0.994276,  0.997144,  1.004657,  1.001564,  0.988129,  1.005037,  1.001150,  0.998597,  0.997818,  1.004239,  1.001892,  0.993576,  0.996145,  1.004762,  1.003588,  0.989011,  0.999392,  1.005985,  0.999023,  0.987279,  1.008360,  0.999176,  0.998198,  0.993074,  1.009813,  1.004300,  0.987967,  0.993957,  1.005627,  1.008676,  0.980241,  1.005177,  1.005698,  1.001415,  0.982547,  1.007730,  1.001347,  0.993209,  0.994416,  1.009513,  1.007309,  0.984425,  0.992790,  1.012680,  1.005886,  0.968512,  1.013817,  1.000903,  1.003060,  0.986263,  1.008775,  1.001588,  0.990278,  0.987645,  1.017894,  1.004282,  0.984551,  0.991939,  1.012368,  1.011163,  0.956745,  1.019327,  1.000806,  0.997763,  0.992971,  1.007806,  1.003145,  0.985034,  0.992104,  1.017809,  1.007272,  0.978208,  0.988036,  1.019617,  1.006518,  0.954346, },
{ 1.000000,  1.000148,  1.000162,  0.999812,  0.999640,  1.000743,  1.000392,  0.998699,  0.999193,  1.000954,  1.001071,  0.996905,  0.999825,  1.002033,  0.999992,  0.995213,  1.003087,  0.999013,  0.999738,  0.996716,  1.003932,  1.002240,  0.994703,  0.997671,  1.002626,  1.003468,  0.991213,  1.001748,  1.003098,  1.000309,  0.991251,  1.004148,  1.000400,  0.997471,  0.996943,  1.004432,  1.004164,  0.991023,  0.995300,  1.007561,  1.003747,  0.981584,  1.007898,  1.001085,  1.004011,  0.988716,  1.005706,  1.001426,  0.992207,  0.992664,  1.012045,  1.003850,  0.988971,  0.994631,  1.007666,  1.008503,  0.971727,  1.011515,  1.002227,  0.998558,  0.995375,  1.004916,  1.000026,  0.989649,  0.994810,  1.012218,  1.005469,  0.988384,  0.987969,  1.013947,  1.008441,  0.963674,  1.009214,  1.006901,  0.995882,  0.993590,  1.008787,  1.005021,  0.985878,  0.991936,  1.010381,  1.006840,  0.978585,  0.995612,  1.014426,  0.999789,  0.972686,  1.015932,  0.997299,  0.997257,  0.987896,  1.015206,  1.011751,  0.975653,  0.989985,  1.012282,  1.014803,  0.965347,  1.005942,  1.014470, },
{ 1.000000,  0.999938,  0.999459,  1.000510,  0.999957,  0.999665,  0.999349,  1.001128,  1.001113,  0.997641,  0.998476,  1.002075,  1.001515,  0.993795,  1.002771,  1.000526,  1.001437,  0.995800,  1.001813,  1.000700,  0.996839,  0.996465,  1.005398,  1.001525,  0.994822,  0.998050,  1.002967,  1.003827,  0.985531,  1.006152,  1.001847,  0.999838,  0.996192,  1.003121,  1.000516,  0.993367,  0.996839,  1.006379,  1.004524,  0.992646,  0.992498,  1.009444,  1.003657,  0.976965,  1.006670,  1.004200,  0.999034,  0.996282,  1.004476,  1.003302,  0.990495,  0.995169,  1.007053,  1.006104,  0.983292,  0.996343,  1.010408,  0.999236,  0.982229,  1.010050,  0.999888,  0.994539,  0.993997,  1.009078,  1.008601,  0.984239,  0.993768,  1.008191,  1.009202,  0.977852,  1.002299,  1.009805,  0.996317,  0.977381,  1.016298,  0.997882,  0.993393,  0.993449,  1.012444,  1.010107,  0.978862,  0.988398,  1.014968,  1.009811,  0.962477,  1.016013,  1.004189,  1.004976,  0.977892,  1.007965,  1.003737,  0.988457,  0.986279,  1.019563,  1.007595,  0.977859,  0.990275,  1.016199,  1.013412,  0.948382, },
{ 1.000000,  1.000215,  1.000063,  0.999956,  0.999587,  1.000332,  1.000282,  0.998637,  0.999070,  1.001770,  1.001167,  0.997915,  0.997848,  1.003104,  1.001534,  0.991692,  1.002265,  1.001514,  0.999833,  0.998530,  1.002015,  1.000678,  0.996415,  0.997706,  1.004001,  1.003163,  0.991369,  0.997740,  1.005116,  0.999424,  0.990417,  1.005215,  1.000266,  0.997362,  0.996839,  1.004774,  1.004397,  0.991698,  0.995890,  1.004428,  1.004861,  0.986909,  1.002509,  1.005162,  0.998592,  0.984863,  1.010177,  1.000318,  0.995766,  0.993549,  1.010041,  1.003874,  0.987450,  0.991946,  1.008030,  1.007758,  0.976095,  1.009662,  1.002662,  1.003449,  0.983764,  1.006538,  1.003824,  0.990322,  0.991659,  1.012295,  1.006219,  0.985557,  0.991911,  1.011285,  1.008984,  0.962726,  1.016393,  1.002545,  0.999196,  0.992217,  1.002808,  1.008048,  0.984858,  0.987184,  1.016283,  1.009202,  0.981454,  0.988463,  1.018796,  1.011392,  0.952483,  1.016770,  1.004386,  0.997397,  0.993550,  1.009168,  1.003375,  0.984444,  0.991530,  1.015510,  1.011728,  0.969518,  0.991278,  1.019146, },
{ 1.000000,  1.000008,  0.999216,  1.000527,  1.000150,  0.999649,  0.999446,  1.001121,  1.000750,  0.997824,  0.998893,  1.001381,  1.001415,  0.995789,  1.000992,  1.000997,  1.000121,  0.993865,  1.004115,  0.999558,  0.998647,  0.997726,  1.004547,  1.001587,  0.994222,  0.996457,  1.002814,  1.004533,  0.988484,  1.004118,  1.002488,  1.001411,  0.991346,  1.003119,  1.002305,  0.996195,  0.994943,  1.006401,  1.004703,  0.990195,  0.995632,  1.005699,  1.006033,  0.977375,  1.009795,  1.001291,  0.999961,  0.994596,  1.002208,  1.004488,  0.990561,  0.991163,  1.012170,  1.004132,  0.987564,  0.991596,  1.012540,  1.007699,  0.969438,  1.012010,  1.001480,  0.997036,  0.996574,  1.006199,  1.001715,  0.989464,  0.990961,  1.012653,  1.007970,  0.979982,  0.992062,  1.014109,  1.002114,  0.968962,  1.012652,  1.002652,  0.994386,  0.994659,  1.011631,  1.006986,  0.982473,  0.991450,  1.009561,  1.008838,  0.974756,  1.004386,  1.007983,  0.999626,  0.969519,  1.018104,  0.999151,  0.993817,  0.990619,  1.016409,  1.007907,  0.978015,  0.984092,  1.013059,  1.016257,  0.960337, },
{ 1.000000,  1.000131,  1.000182,  1.000059,  0.998810,  1.000688,  1.000143,  0.999236,  0.998939,  1.001723,  1.001014,  0.997379,  0.998587,  1.002262,  1.001610,  0.992308,  1.003690,  0.999995,  1.000429,  0.996948,  1.002280,  1.001074,  0.995860,  0.996289,  1.005081,  1.001868,  0.994475,  0.996073,  1.005116,  1.004295,  0.982796,  1.007619,  1.000416,  0.998254,  0.998181,  1.003497,  1.000091,  0.993890,  0.995889,  1.008102,  1.003237,  0.989413,  0.994832,  1.008262,  1.002664,  0.979533,  1.008463,  1.001946,  0.997522,  0.996320,  1.006748,  1.003005,  0.989693,  0.993876,  1.007328,  1.005557,  0.982953,  0.999084,  1.008994,  0.998483,  0.980939,  1.012229,  0.998723,  0.997177,  0.989911,  1.014110,  1.006149,  0.982702,  0.991202,  1.007839,  1.012270,  0.971934,  1.007150,  1.007912,  1.001782,  0.975736,  1.010460,  1.001796,  0.990612,  0.992197,  1.012858,  1.009803,  0.978827,  0.990231,  1.016804,  1.007908,  0.957734,  1.018254,  1.001087,  1.003790,  0.981767,  1.011432,  1.002114,  0.987175,  0.983788,  1.023060,  1.005434,  0.979857,  0.989276,  1.015817, },
{ 1.000000,  1.000144,  0.998879,  1.000735,  1.000031,  0.999832,  0.999482,  1.000644,  1.000293,  0.998391,  0.999056,  1.002252,  1.001003,  0.996737,  0.998090,  1.003256,  1.001112,  0.991465,  1.002975,  1.001597,  0.998577,  0.997949,  1.003521,  1.001627,  0.995145,  0.997188,  1.002900,  1.003088,  0.991454,  0.999492,  1.005020,  0.999861,  0.988934,  1.006720,  0.997843,  0.999344,  0.993258,  1.007798,  1.004353,  0.989775,  0.995526,  1.004732,  1.006268,  0.984156,  1.002988,  1.005292,  1.000488,  0.985133,  1.006785,  1.000632,  0.995743,  0.994865,  1.006976,  1.006506,  0.985743,  0.992530,  1.011623,  1.005723,  0.971760,  1.011935,  1.001496,  1.005790,  0.983112,  1.008330,  1.002009,  0.988556,  0.989218,  1.017284,  1.005430,  0.984067,  0.992160,  1.010787,  1.011988,  0.960010,  1.016024,  1.003011,  0.997750,  0.993427,  1.006584,  0.999942,  0.985722,  0.992806,  1.016427,  1.007368,  0.983972,  0.983626,  1.018666,  1.011120,  0.951210,  1.012133,  1.009039,  0.994298,  0.991284,  1.011344,  1.006521,  0.981237,  0.989250,  1.013327,  1.008885,  0.971747, },
{ 1.000000,  0.999939,  1.000377,  0.999976,  0.998585,  1.000998,  0.999781,  0.999746,  0.998795,  1.001634,  1.001394,  0.996772,  0.998566,  1.001809,  1.002391,  0.994014,  1.001051,  1.002722,  0.998926,  0.994439,  1.003592,  0.999703,  0.998369,  0.997271,  1.004112,  1.003721,  0.992580,  0.995517,  1.005630,  1.003926,  0.984473,  1.006535,  1.001144,  1.003078,  0.990880,  1.003732,  1.001336,  0.993587,  0.992989,  1.010229,  1.002851,  0.990387,  0.996341,  1.005205,  1.006770,  0.974776,  1.010501,  1.003076,  0.999514,  0.993699,  1.004972,  1.000742,  0.989258,  0.994922,  1.009857,  1.006987,  0.988443,  0.988346,  1.014205,  1.005510,  0.965241,  1.009860,  1.006190,  0.998326,  0.994414,  1.006341,  1.004674,  0.986103,  0.992929,  1.009892,  1.008599,  0.976137,  0.994752,  1.014489,  0.998830,  0.975105,  1.013734,  0.999668,  0.992346,  0.991578,  1.012248,  1.011686,  0.978371,  0.991377,  1.010877,  1.012415,  0.969845,  1.002974,  1.012988,  0.994942,  0.969873,  1.021237,  0.997046,  0.991080,  0.991165,  1.016140,  1.013178,  0.972136,  0.984662,  1.019293, },
{ 1.000000,  1.000131,  0.999020,  1.000620,  1.000199,  1.000290,  0.998329,  1.000679,  1.000352,  0.998722,  0.998327,  1.002507,  1.001042,  0.996635,  0.998424,  1.002695,  1.002379,  0.990191,  1.004321,  1.000501,  0.999617,  0.997644,  1.001586,  1.001104,  0.994907,  0.996857,  1.005396,  1.003384,  0.994172,  0.994297,  1.007670,  1.003637,  0.980716,  1.004998,  1.003232,  0.999545,  0.996965,  1.003921,  1.001299,  0.993051,  0.995629,  1.007288,  1.005622,  0.984442,  0.995877,  1.008831,  0.998890,  0.983676,  1.008595,  1.000349,  0.995469,  0.994760,  1.007458,  1.006945,  0.986705,  0.993521,  1.006692,  1.007464,  0.979853,  1.003699,  1.007742,  0.997713,  0.977417,  1.014940,  1.000351,  0.993508,  0.990498,  1.014256,  1.005467,  0.981767,  0.988326,  1.011311,  1.010896,  0.965969,  1.013432,  1.003639,  1.004579,  0.977335,  1.008916,  1.005107,  0.986449,  0.988329,  1.016604,  1.008267,  0.980171,  0.988848,  1.014911,  1.012008,  0.949756,  1.021844,  1.003193,  0.998675,  0.989568,  1.003513,  1.010355,  0.979680,  0.982969,  1.021133,  1.011963,  0.975653, },
{ 1.000000,  0.999846,  1.000485,  1.000434,  0.997569,  1.001034,  1.000308,  0.999748,  0.999368,  1.000957,  1.000393,  0.997979,  0.998799,  1.002276,  1.001855,  0.994800,  0.998424,  1.003548,  1.000060,  0.991915,  1.003834,  1.000816,  0.998265,  0.997606,  1.004099,  1.002542,  0.993097,  0.996693,  1.003740,  1.003685,  0.989363,  1.002287,  1.002277,  1.000184,  0.986566,  1.008602,  0.999055,  0.997160,  0.995393,  1.008681,  1.002964,  0.989134,  0.993412,  1.005043,  1.008034,  0.979596,  1.007086,  1.004187,  1.002272,  0.985405,  1.005051,  1.003731,  0.993645,  0.991740,  1.010091,  1.007247,  0.984518,  0.993050,  1.008704,  1.009203,  0.965299,  1.014745,  1.001851,  0.999724,  0.991898,  1.003004,  1.006437,  0.986047,  0.987057,  1.017384,  1.005902,  0.982044,  0.987837,  1.017762,  1.010882,  0.956508,  1.016678,  1.001927,  0.995672,  0.995089,  1.008314,  1.002188,  0.985250,  0.987461,  1.017048,  1.010747,  0.972519,  0.989038,  1.018909,  1.002615,  0.958037,  1.016713,  1.003415,  0.992243,  0.992643,  1.015170,  1.009154,  0.976552,  0.988476,  1.012308, },
{ 1.000000,  1.000111,  0.999328,  1.000167,  1.000407,  0.999952,  0.997660,  1.001558,  0.999889,  0.999268,  0.998829,  1.002132,  1.001098,  0.996634,  0.997390,  1.002177,  1.002913,  0.992359,  1.002423,  1.001775,  1.000399,  0.993241,  1.003243,  1.000556,  0.997115,  0.996395,  1.005356,  1.002929,  0.992695,  0.996255,  1.005580,  1.003856,  0.982134,  1.008132,  0.999930,  1.000754,  0.993702,  1.004416,  1.002029,  0.991978,  0.992900,  1.009330,  1.003320,  0.990002,  0.992887,  1.008818,  1.007288,  0.970672,  1.012630,  1.000603,  0.996931,  0.996911,  1.005453,  1.000094,  0.990261,  0.993422,  1.012376,  1.004928,  0.983587,  0.992016,  1.012445,  1.003846,  0.969259,  1.012413,  1.002842,  0.996090,  0.994438,  1.009593,  1.004269,  0.984974,  0.991101,  1.010262,  1.007761,  0.975703,  0.998715,  1.012499,  0.997762,  0.973306,  1.016709,  0.998157,  0.995825,  0.986149,  1.019098,  1.008265,  0.976353,  0.987798,  1.010373,  1.016441,  0.961874,  1.009395,  1.010428,  1.002050,  0.967546,  1.013547,  1.002265,  0.987394,  0.989448,  1.016755,  1.012653,  0.972030, },
{ 1.000000,  0.999861,  1.000431,  1.000308,  0.997834,  1.001142,  1.000054,  1.000293,  0.998220,  1.001215,  1.000254,  0.998315,  0.997726,  1.003404,  1.000829,  0.996556,  0.997998,  1.002934,  1.002798,  0.988402,  1.005271,  1.000167,  0.999152,  0.997818,  1.002353,  1.000943,  0.994918,  0.997200,  1.006107,  1.002599,  0.991755,  0.995333,  1.007423,  1.002375,  0.981404,  1.006165,  1.003196,  0.997002,  0.995964,  1.006608,  1.002996,  0.990950,  0.994771,  1.005119,  1.005415,  0.985012,  0.999009,  1.008409,  0.999548,  0.981541,  1.010746,  0.996472,  0.998764,  0.989167,  1.012214,  1.006783,  0.983979,  0.992912,  1.007034,  1.009478,  0.975820,  1.004258,  1.007782,  1.000596,  0.978036,  1.009735,  1.000882,  0.993620,  0.992329,  1.009836,  1.009139,  0.979540,  0.989244,  1.016225,  1.007953,  0.960300,  1.016529,  1.001922,  1.007640,  0.976570,  1.011309,  1.002666,  0.984244,  0.985158,  1.023213,  1.007125,  0.978328,  0.989159,  1.014367,  1.015933,  0.946378,  1.021102,  1.003832,  0.996664,  0.991078,  1.008334,  0.999771,  0.981132,  0.990394,  1.021153, },
{ 1.000000,  1.000097,  0.999576,  0.999350,  1.000945,  1.000685,  0.996317,  1.001034,  1.000865,  0.999330,  0.998908,  1.001431,  1.000911,  0.997136,  0.998223,  1.002206,  1.001606,  0.994544,  0.998808,  1.003849,  0.999845,  0.991978,  1.004670,  0.999092,  0.999012,  0.995806,  1.005001,  1.003982,  0.991061,  0.996187,  1.004430,  1.005641,  0.986148,  1.002256,  1.005782,  0.997706,  0.988605,  1.007049,  0.999400,  0.996772,  0.994817,  1.007474,  1.006617,  0.986649,  0.992047,  1.009691,  1.006627,  0.973671,  1.010723,  1.001743,  1.004835,  0.985075,  1.005859,  1.001983,  0.989676,  0.988899,  1.015712,  1.004303,  0.985219,  0.994199,  1.007701,  1.010100,  0.962402,  1.015363,  1.004426,  0.998973,  0.990781,  1.006952,  1.000913,  0.984474,  0.992587,  1.013736,  1.009769,  0.983512,  0.983510,  1.019465,  1.007584,  0.951774,  1.013345,  1.008472,  0.997373,  0.992126,  1.008346,  1.006145,  0.980956,  0.990262,  1.012951,  1.011298,  0.967870,  0.992859,  1.019066,  0.998350,  0.966843,  1.017799,  0.999286,  0.989772,  0.988677,  1.015753,  1.015213,  0.971592, },
{ 1.000000,  0.999884,  1.000272,  1.000480,  0.998437,  1.000172,  1.000962,  0.999549,  0.997068,  1.002251,  0.999622,  0.998812,  0.998719,  1.002386,  1.002085,  0.995218,  0.997217,  1.003590,  1.002481,  0.989794,  1.004330,  1.001065,  1.001313,  0.993070,  1.002499,  1.001153,  0.995954,  0.995074,  1.006811,  1.002606,  0.991609,  0.996185,  1.006049,  1.005263,  0.978708,  1.008875,  1.000939,  0.999170,  0.995320,  1.002936,  1.001972,  0.990540,  0.994235,  1.009463,  1.005896,  0.989855,  0.990181,  1.012898,  1.006010,  0.968042,  1.008048,  1.005140,  0.999110,  0.995076,  1.005974,  1.002027,  0.989156,  0.993209,  1.010875,  1.008308,  0.976391,  0.993646,  1.013014,  0.998220,  0.975969,  1.012374,  1.000390,  0.993195,  0.992230,  1.010415,  1.009783,  0.980955,  0.990758,  1.009149,  1.010343,  0.971792,  1.004947,  1.010584,  0.996613,  0.968921,  1.020169,  1.000285,  0.990875,  0.986981,  1.018846,  1.007227,  0.975274,  0.984141,  1.014979,  1.014382,  0.954474,  1.017542,  1.004642,  1.005778,  0.970038,  1.011532,  1.006448,  0.982051,  0.984390,  1.021365, },
{ 1.000000,  1.000103,  0.999481,  0.999552,  1.000725,  1.000744,  0.996248,  1.001851,  1.000290,  0.999834,  0.998736,  1.000417,  1.001386,  0.996903,  0.997259,  1.003485,  1.002107,  0.995442,  0.996930,  1.004897,  1.003125,  0.986198,  1.004763,  1.001218,  0.999002,  0.997765,  1.002891,  1.001090,  0.994347,  0.996753,  1.005516,  1.004396,  0.987927,  0.996390,  1.007523,  0.999972,  0.983365,  1.007527,  1.001551,  0.996500,  0.995342,  1.007289,  1.004491,  0.987492,  0.994062,  1.006296,  1.006251,  0.981791,  1.003532,  1.003747,  1.000144,  0.978078,  1.013490,  0.998415,  0.995314,  0.992519,  1.013140,  1.004396,  0.983224,  0.989778,  1.007436,  1.011930,  0.969319,  1.010335,  1.005949,  1.003043,  0.978503,  1.007060,  1.005262,  0.990549,  0.987922,  1.014062,  1.009934,  0.977978,  0.989892,  1.011887,  1.012664,  0.951520,  1.020018,  1.002379,  0.999284,  0.988688,  1.003623,  1.008469,  0.980826,  0.982278,  1.022891,  1.007754,  0.975703,  0.983472,  1.023428,  1.014362,  0.941887,  1.021539,  1.002249,  0.993943,  0.993238,  1.010378,  1.002559,  0.980344, },
{ 1.000000,  0.999829,  1.000440,  1.000408,  0.998561,  0.999278,  1.001396,  1.000184,  0.995850,  1.001776,  1.000376,  0.998921,  0.998913,  1.002231,  1.001437,  0.995934,  0.997847,  1.002246,  1.002240,  0.992952,  1.001126,  1.002207,  0.999721,  0.990176,  1.005694,  0.999588,  0.997555,  0.996469,  1.005792,  1.002807,  0.991483,  0.993649,  1.004913,  1.006458,  0.983278,  1.004969,  1.003573,  1.000669,  0.986618,  1.006089,  1.000983,  0.994535,  0.993320,  1.009464,  1.005107,  0.987165,  0.993486,  1.009299,  1.006451,  0.970152,  1.013188,  0.999798,  1.000959,  0.989882,  1.006674,  1.003048,  0.987331,  0.988860,  1.014158,  1.004950,  0.984707,  0.989024,  1.013028,  1.010604,  0.956463,  1.018304,  1.000721,  0.995261,  0.995301,  1.007556,  1.000082,  0.985990,  0.990471,  1.017136,  1.006838,  0.976661,  0.988670,  1.017222,  1.005078,  0.957286,  1.016872,  1.003835,  0.994206,  0.992070,  1.012713,  1.005695,  0.979383,  0.987830,  1.013419,  1.010191,  0.967172,  0.998302,  1.016394,  0.996874,  0.964410,  1.021720,  0.997438,  0.994009,  0.981798,  1.024735, },
{ 1.000000,  1.000106,  0.999385,  0.999511,  1.000518,  1.001034,  0.997068,  1.000788,  1.000991,  1.000187,  0.996028,  1.001704,  1.000290,  0.998037,  0.998202,  1.002831,  1.002235,  0.994594,  0.997378,  1.004411,  1.002174,  0.987317,  1.005417,  1.000206,  1.000970,  0.993769,  1.003756,  1.000729,  0.995154,  0.993866,  1.008461,  1.001866,  0.991816,  0.995255,  1.006331,  1.005847,  0.975658,  1.010595,  1.000206,  0.998110,  0.995712,  1.004273,  1.001574,  0.990646,  0.994821,  1.010592,  1.004404,  0.985598,  0.991905,  1.012259,  1.003679,  0.969077,  1.009939,  1.004961,  0.994931,  0.993513,  1.010194,  1.004518,  0.985707,  0.991710,  1.007657,  1.008101,  0.977100,  0.998292,  1.012352,  0.998886,  0.972401,  1.015329,  0.994729,  0.997830,  0.984053,  1.017444,  1.009573,  0.976765,  0.989570,  1.009584,  1.013215,  0.965418,  1.005669,  1.010585,  1.000568,  0.969181,  1.013129,  1.001080,  0.990792,  0.988922,  1.013125,  1.012112,  0.971777,  0.985094,  1.021624,  1.010520,  0.946049,  1.022003,  1.002240,  1.009520,  0.968381,  1.014806,  1.003291,  0.978864, },
{ 1.000000,  0.999804,  1.000599,  1.000261,  0.998863,  0.999283,  1.001064,  1.001370,  0.994675,  1.002273,  1.000415,  0.999485,  0.998681,  1.001194,  0.999927,  0.996734,  0.998224,  1.003915,  1.001856,  0.995410,  0.995241,  1.005347,  1.003117,  0.984545,  1.003758,  1.002818,  0.997776,  0.996690,  1.003777,  1.002292,  0.992700,  0.995639,  1.004928,  1.003463,  0.987983,  0.997379,  1.007791,  0.999501,  0.984124,  1.008796,  0.998151,  0.998043,  0.992180,  1.008696,  1.006821,  0.984232,  0.993311,  1.007263,  1.009261,  0.976818,  1.003575,  1.009169,  0.996217,  0.981735,  1.010852,  0.998913,  0.994755,  0.991818,  1.011208,  1.009764,  0.979579,  0.987916,  1.014303,  1.009581,  0.960930,  1.015401,  1.002232,  1.006579,  0.978138,  1.008140,  1.002564,  0.984886,  0.983955,  1.021838,  1.005818,  0.979038,  0.991456,  1.010399,  1.013840,  0.947825,  1.020896,  1.005785,  0.997996,  0.987273,  1.009009,  1.000853,  0.978663,  0.989731,  1.018011,  1.012689,  0.977490,  0.977692,  1.025271,  1.009741,  0.935953,  1.017200,  1.010915,  0.995921,  0.989217,  1.010415, },
{ 1.000000,  1.000087,  0.999477,  0.999605,  1.000641,  1.000680,  0.997535,  0.999367,  1.001858,  0.999791,  0.995951,  1.002286,  0.999823,  0.998378,  0.998087,  1.002649,  1.002720,  0.994490,  0.997613,  1.002763,  1.003442,  0.990869,  1.000744,  1.003923,  0.998211,  0.989910,  1.006939,  0.998795,  0.996565,  0.996498,  1.005881,  1.004968,  0.988714,  0.993576,  1.007707,  1.005210,  0.978612,  1.008551,  1.001887,  1.002340,  0.986663,  1.004558,  1.002038,  0.992457,  0.990984,  1.011797,  1.004315,  0.985445,  0.993445,  1.009836,  1.008575,  0.964726,  1.014074,  1.001337,  0.998470,  0.992401,  1.004420,  1.002861,  0.985099,  0.990962,  1.014139,  1.008835,  0.984478,  0.985089,  1.019009,  1.008702,  0.952527,  1.011464,  1.007313,  0.998373,  0.992654,  1.008184,  1.002829,  0.984275,  0.990149,  1.014994,  1.011309,  0.966423,  0.990708,  1.017875,  0.997225,  0.966423,  1.016744,  1.000253,  0.990141,  0.988916,  1.013720,  1.013047,  0.973727,  0.987257,  1.011893,  1.013722,  0.961762,  1.006215,  1.013875,  0.995039,  0.958391,  1.026296,  0.999990,  0.987315, },
{ 1.000000,  0.999823,  1.000475,  1.000269,  0.998698,  0.998960,  1.001114,  1.001221,  0.995432,  1.001877,  1.000511,  1.000698,  0.995718,  1.001692,  1.000976,  0.996831,  0.997041,  1.003976,  1.001979,  0.994434,  0.996671,  1.004139,  1.003533,  0.984069,  1.006883,  1.000885,  0.999353,  0.996138,  1.001095,  1.003506,  0.991935,  0.993216,  1.008077,  1.004671,  0.989930,  0.993304,  1.010082,  1.006207,  0.972406,  1.008950,  1.002169,  0.997947,  0.995708,  1.005003,  1.001788,  0.989810,  0.994163,  1.009241,  1.007287,  0.979440,  0.993803,  1.012133,  0.999524,  0.972989,  1.011831,  1.002275,  0.994119,  0.992433,  1.010869,  1.006619,  0.980552,  0.990798,  1.009199,  1.009135,  0.972442,  1.004811,  1.005441,  0.999922,  0.967665,  1.019204,  0.997505,  0.992827,  0.988816,  1.018312,  1.005920,  0.975784,  0.985164,  1.010293,  1.016491,  0.956516,  1.014154,  1.007921,  1.003743,  0.969887,  1.009367,  1.006976,  0.986390,  0.983021,  1.018773,  1.012853,  0.969770,  0.985823,  1.015638,  1.016665,  0.934381,  1.026295,  1.002838,  0.998428,  0.984598,  1.004145, },
{ 1.000000,  1.000109,  0.999476,  0.999281,  1.001151,  1.000482,  0.998116,  0.998513,  1.002307,  1.001545,  0.992886,  1.002752,  1.000247,  0.998985,  0.998814,  1.001677,  1.000372,  0.996103,  0.996634,  1.004433,  1.002856,  0.991644,  0.996413,  1.005706,  1.000518,  0.985746,  1.005438,  1.001019,  0.996845,  0.996940,  1.005398,  1.003345,  0.990322,  0.994942,  1.004713,  1.004624,  0.985187,  1.002103,  1.004155,  0.999224,  0.981019,  1.010362,  0.999064,  0.995265,  0.993434,  1.009947,  1.004707,  0.985203,  0.989057,  1.007947,  1.010465,  0.972213,  1.007758,  1.005455,  1.000786,  0.978574,  1.009130,  1.001357,  0.991292,  0.989461,  1.014107,  1.007518,  0.980445,  0.990027,  1.013475,  1.009336,  0.955637,  1.018892,  0.999496,  1.000857,  0.985149,  1.008968,  1.004034,  0.981630,  0.983773,  1.019635,  1.006655,  0.978223,  0.984109,  1.017819,  1.014273,  0.939383,  1.024668,  1.000619,  0.992988,  0.993100,  1.009711,  0.999864,  0.980762,  0.986676,  1.022426,  1.008841,  0.968129,  0.984290,  1.022687,  1.006213,  0.942801,  1.021802,  1.004772,  0.991598, },
{ 1.000000,  0.999883,  1.000317,  1.000223,  0.998900,  0.999185,  1.000970,  1.000859,  0.996676,  0.999805,  1.001923,  0.999555,  0.994822,  1.003239,  0.999527,  0.998827,  0.996636,  1.004646,  1.002051,  0.993408,  0.996258,  1.002863,  1.004905,  0.987551,  1.002840,  1.003328,  1.000401,  0.988236,  1.004604,  1.000698,  0.994932,  0.995495,  1.006477,  1.004919,  0.988052,  0.994310,  1.008883,  1.004328,  0.974699,  1.010295,  1.000227,  1.001519,  0.988471,  1.006595,  1.001313,  0.991279,  0.989240,  1.014163,  1.002951,  0.986137,  0.991753,  1.010160,  1.009275,  0.960625,  1.016614,  1.000144,  0.996665,  0.993172,  1.006398,  1.002244,  0.985549,  0.991929,  1.015584,  1.006386,  0.978279,  0.987805,  1.017664,  1.004913,  0.954653,  1.014159,  1.006766,  0.992276,  0.990619,  1.014142,  1.006224,  0.979529,  0.987975,  1.010455,  1.011131,  0.967838,  0.997393,  1.016703,  0.997830,  0.961699,  1.020273,  0.992695,  0.996541,  0.978134,  1.023310,  1.012778,  0.968396,  0.985519,  1.012297,  1.017411,  0.953278,  1.007044,  1.013618,  1.000425,  0.959024,  1.016795, },
{ 1.000000,  1.000020,  0.999743,  0.999552,  1.000636,  1.000725,  0.997889,  0.998702,  1.002038,  1.001073,  0.993596,  1.002750,  1.000242,  1.001248,  0.994953,  1.002404,  1.000532,  0.996019,  0.996065,  1.006004,  1.001744,  0.993512,  0.996489,  1.004272,  1.004909,  0.982027,  1.006907,  1.001071,  0.998374,  0.996388,  1.002734,  0.999694,  0.992412,  0.995931,  1.008252,  1.003676,  0.990276,  0.990384,  1.010187,  1.005534,  0.970938,  1.006722,  1.004856,  0.995724,  0.993928,  1.006271,  1.003690,  0.987487,  0.992520,  1.007742,  1.005374,  0.980275,  0.995621,  1.012066,  0.998873,  0.975075,  1.013212,  0.996925,  0.996724,  0.987769,  1.012670,  1.009733,  0.976282,  0.989868,  1.010188,  1.013048,  0.966118,  1.004790,  1.012695,  0.994417,  0.973837,  1.014775,  0.998287,  0.992205,  0.988292,  1.015183,  1.012956,  0.971398,  0.983183,  1.019301,  1.012594,  0.946560,  1.020327,  1.002473,  1.008120,  0.970073,  1.010512,  1.002953,  0.979213,  0.978181,  1.028349,  1.007212,  0.971949,  0.988023,  1.013217,  1.017821,  0.931520,  1.026765,  1.007059,  0.996452, },
{ 1.000000,  0.999824,  1.000234,  1.000010,  0.998842,  0.999290,  1.001349,  1.001067,  0.997644,  0.997433,  1.003007,  1.001215,  0.990646,  1.002581,  1.001723,  0.999112,  0.997846,  1.001882,  1.001399,  0.994460,  0.996903,  1.003539,  1.003103,  0.989369,  0.997455,  1.006233,  0.999149,  0.987700,  1.006218,  0.999279,  0.995751,  0.995045,  1.006034,  1.006006,  0.987577,  0.994546,  1.005465,  1.006787,  0.981361,  1.001172,  1.007249,  0.996357,  0.981137,  1.012235,  0.997550,  0.993597,  0.993509,  1.009807,  1.008114,  0.980612,  0.988927,  1.012431,  1.008172,  0.964765,  1.013288,  1.002499,  1.003207,  0.978637,  1.006835,  1.002803,  0.987903,  0.985665,  1.017558,  1.005961,  0.977769,  0.989921,  1.013992,  1.012199,  0.947526,  1.019862,  1.001462,  0.997258,  0.988546,  1.005913,  1.003472,  0.978127,  0.986720,  1.019424,  1.011971,  0.977708,  0.978630,  1.026038,  1.011484,  0.933466,  1.015241,  1.009580,  0.997000,  0.989286,  1.010418,  1.003502,  0.978036,  0.986114,  1.019461,  1.014232,  0.953918,  0.986779,  1.023305,  0.995530,  0.954568,  1.021668, },
{ 1.000000,  1.000013,  0.999728,  0.999561,  1.000727,  1.000857,  0.997977,  0.998893,  1.001200,  1.001565,  0.995329,  1.000836,  1.002055,  0.999254,  0.993231,  1.004597,  1.000032,  0.997517,  0.996513,  1.005080,  1.002124,  0.992455,  0.994964,  1.004894,  1.004775,  0.984194,  1.006081,  1.001693,  1.002063,  0.988656,  1.004479,  1.002515,  0.992569,  0.993266,  1.008980,  1.004366,  0.988364,  0.993259,  1.008403,  1.007176,  0.969323,  1.013224,  1.001878,  0.998973,  0.993213,  1.002281,  1.006257,  0.985965,  0.988599,  1.013943,  1.008112,  0.983614,  0.989117,  1.016809,  1.010321,  0.955792,  1.014231,  1.003648,  0.997011,  0.993596,  1.007962,  1.003084,  0.984687,  0.991341,  1.014179,  1.011232,  0.969401,  0.991018,  1.018210,  0.999313,  0.960761,  1.017644,  1.003701,  0.991624,  0.989291,  1.015579,  1.009760,  0.972559,  0.987339,  1.013262,  1.013300,  0.961532,  1.006838,  1.008288,  1.000217,  0.955488,  1.026783,  0.997132,  0.990322,  0.984827,  1.025151,  1.008394,  0.967280,  0.980043,  1.014609,  1.022854,  0.941316,  1.019642,  1.011003,  1.005301, },
{ 1.000000,  0.999583,  1.000244,  1.000261,  0.999225,  0.998826,  1.001410,  1.001055,  0.996863,  0.998315,  1.001841,  1.002171,  0.990295,  1.003977,  1.000375,  0.999579,  0.997004,  1.000633,  1.001998,  0.994236,  0.994552,  1.006587,  1.002189,  0.991793,  0.994164,  1.007949,  1.004920,  0.978115,  1.007500,  1.000460,  0.997167,  0.996826,  1.003707,  1.000612,  0.990892,  0.992467,  1.009099,  1.005626,  0.982593,  0.992525,  1.010795,  1.000479,  0.972840,  1.009800,  1.001562,  0.993909,  0.994083,  1.008984,  1.005484,  0.982895,  0.990966,  1.007446,  1.007364,  0.974973,  1.003011,  1.006315,  0.998236,  0.969025,  1.015932,  0.998096,  0.991920,  0.989112,  1.014937,  1.006800,  0.976871,  0.982954,  1.011449,  1.015232,  0.957733,  1.010959,  1.007462,  1.000607,  0.968059,  1.012602,  1.001620,  0.986728,  0.984171,  1.019651,  1.010270,  0.971458,  0.985300,  1.018427,  1.012815,  0.936561,  1.025760,  0.998857,  1.000307,  0.978859,  1.011361,  1.004910,  0.973830,  0.976839,  1.026327,  1.008573,  0.969424,  0.977367,  1.023769,  1.018635,  0.916991,  1.032369, },
{ 1.000000,  0.999999,  0.999792,  0.999689,  1.000470,  0.999957,  0.998458,  0.998740,  1.002177,  1.000935,  0.995888,  0.997746,  1.003217,  1.000818,  0.990308,  1.003723,  1.000778,  0.998115,  0.997476,  1.003242,  1.001507,  0.993313,  0.995813,  1.003905,  1.003059,  0.988098,  0.999289,  1.005563,  0.998537,  0.985666,  1.008058,  0.998589,  0.996812,  0.992078,  1.010181,  1.004154,  0.985795,  0.991866,  1.005418,  1.009342,  0.975243,  1.005074,  1.005815,  1.000186,  0.978252,  1.007822,  1.000925,  0.990698,  0.991633,  1.010747,  1.007842,  0.979522,  0.990159,  1.014038,  1.006610,  0.958338,  1.015973,  0.999825,  1.001644,  0.981469,  1.009700,  1.001830,  0.985945,  0.983082,  1.020889,  1.003791,  0.978455,  0.986739,  1.014522,  1.013037,  0.941015,  1.023752,  0.999635,  0.994197,  0.989489,  1.008784,  1.002595,  0.978676,  0.987761,  1.021438,  1.008390,  0.968408,  0.982125,  1.023959,  1.005737,  0.935719,  1.019099,  1.008446,  0.988192,  0.986429,  1.018723,  1.007834,  0.971017,  0.982628,  1.013599,  1.014384,  0.955435,  0.995869,  1.021687,  0.995685, },
{ 1.000000,  0.999452,  1.000517,  0.999682,  0.999754,  0.998510,  1.001792,  1.001092,  0.996682,  0.998222,  1.001400,  1.002262,  0.992942,  1.000956,  1.002114,  0.999893,  0.992131,  1.003136,  1.000149,  0.996983,  0.996263,  1.003713,  1.003500,  0.990344,  0.994593,  1.007172,  1.003408,  0.979614,  1.007959,  1.000461,  1.002847,  0.986786,  1.005766,  1.001102,  0.990511,  0.990827,  1.012913,  1.003295,  0.985995,  0.992314,  1.008393,  1.009362,  0.964340,  1.012996,  1.001605,  0.996356,  0.992828,  1.004524,  0.999121,  0.986139,  0.992467,  1.014062,  1.005914,  0.982483,  0.983175,  1.016782,  1.008328,  0.951180,  1.010772,  1.007384,  0.992348,  0.989534,  1.009509,  1.005422,  0.979620,  0.987527,  1.011453,  1.007828,  0.968523,  0.992734,  1.018026,  0.997569,  0.961341,  1.019432,  0.994783,  0.994435,  0.980820,  1.018301,  1.013607,  0.964001,  0.984194,  1.014148,  1.018220,  0.949519,  1.006317,  1.017663,  0.991536,  0.961422,  1.020375,  0.997031,  0.987912,  0.982509,  1.020949,  1.017335,  0.958475,  0.975492,  1.026863,  1.016926,  0.923815,  1.027649, },
{ 1.000000,  1.000017,  1.000189,  0.998684,  1.000533,  1.000150,  0.998201,  0.997853,  1.002914,  1.000732,  0.996233,  0.998114,  1.001912,  1.002792,  0.987871,  1.004798,  1.001187,  0.998932,  0.996133,  1.002224,  0.999821,  0.992924,  0.996265,  1.005682,  1.003823,  0.991286,  0.991318,  1.008795,  1.003166,  0.974185,  1.006408,  1.004079,  0.997371,  0.994422,  1.003861,  1.002723,  0.987689,  0.993009,  1.006727,  1.005598,  0.978583,  0.994708,  1.011453,  0.998038,  0.976745,  1.010825,  0.998154,  0.992105,  0.990620,  1.009978,  1.009864,  0.978296,  0.990107,  1.008395,  1.010705,  0.968475,  1.001250,  1.011140,  0.993600,  0.969681,  1.018422,  0.995574,  0.989351,  0.989100,  1.014363,  1.011787,  0.969722,  0.982482,  1.018135,  1.011621,  0.946308,  1.018801,  1.002715,  1.003766,  0.967837,  1.009427,  1.003498,  0.981398,  0.978130,  1.024598,  1.007616,  0.967421,  0.984930,  1.018842,  1.016490,  0.924581,  1.026645,  1.001240,  0.995067,  0.983030,  1.007475,  1.003704,  0.968444,  0.980724,  1.025873,  1.015554,  0.968387,  0.969731,  1.034736,  1.014577, },
{ 1.000000,  0.999043,  1.000404,  1.000363,  0.999784,  0.999203,  1.000736,  1.000269,  0.997611,  0.998287,  1.002303,  1.001738,  0.992933,  0.997724,  1.003771,  0.999013,  0.991140,  1.004147,  0.999689,  0.996666,  0.996071,  1.003832,  1.003807,  0.990551,  0.995032,  1.003689,  1.004609,  0.984919,  1.001749,  1.005020,  0.997263,  0.982174,  1.010442,  0.999199,  0.993389,  0.991477,  1.010020,  1.003667,  0.983383,  0.988796,  1.008899,  1.008355,  0.968400,  1.010392,  1.002049,  1.002683,  0.978549,  1.007029,  1.003258,  0.985814,  0.986887,  1.014209,  1.005995,  0.978968,  0.987447,  1.012425,  1.010494,  0.948548,  1.019949,  1.001710,  0.996874,  0.987783,  1.002433,  1.007968,  0.976309,  0.980850,  1.019944,  1.010871,  0.973861,  0.981851,  1.023831,  1.013708,  0.932066,  1.018976,  1.003537,  0.993758,  0.988707,  1.009751,  1.002783,  0.975850,  0.985350,  1.018450,  1.014042,  0.953810,  0.985140,  1.023849,  0.996385,  0.942452,  1.023084,  1.002981,  0.985791,  0.982409,  1.019124,  1.011302,  0.959368,  0.980162,  1.016005,  1.016143,  0.944374,  1.006670, },
{ 1.000000,  1.000105,  0.999940,  0.998073,  1.001342,  0.999670,  0.999038,  0.998375,  1.002347,  1.000694,  0.995529,  0.996888,  1.001938,  1.003339,  0.989479,  1.003190,  1.001614,  1.000559,  0.991033,  1.002389,  1.001750,  0.994913,  0.993696,  1.005928,  1.003668,  0.988413,  0.993963,  1.005363,  1.005948,  0.972739,  1.010084,  1.000548,  0.998454,  0.992442,  1.000976,  1.003909,  0.986870,  0.988049,  1.013015,  1.004050,  0.983284,  0.988207,  1.014908,  1.008908,  0.958456,  1.012862,  1.000161,  0.994395,  0.993628,  1.005741,  1.000342,  0.983558,  0.986663,  1.014564,  1.008593,  0.970153,  0.986914,  1.016700,  0.999509,  0.955584,  1.014959,  1.001693,  0.989475,  0.989558,  1.012884,  1.007636,  0.972586,  0.985068,  1.010350,  1.010273,  0.960986,  1.003481,  1.008498,  0.996240,  0.952610,  1.022496,  0.996152,  0.986788,  0.982544,  1.020861,  1.008839,  0.965316,  0.974444,  1.015381,  1.020643,  0.937970,  1.014469,  1.009206,  0.999654,  0.953775,  1.016347,  1.001463,  0.980022,  0.976408,  1.026245,  1.013058,  0.959053,  0.978434,  1.023986,  1.016660, },
{ 1.000000,  0.999100,  1.000671,  0.999912,  0.999943,  0.998520,  1.000740,  1.000314,  0.997157,  0.997147,  1.003152,  1.001021,  0.995248,  0.996138,  1.003844,  1.003086,  0.983963,  1.006052,  0.999667,  0.997393,  0.997282,  1.002418,  0.999534,  0.992951,  0.994702,  1.007310,  1.002735,  0.986808,  0.992984,  1.008406,  1.001511,  0.975076,  1.008592,  1.001329,  0.995048,  0.993695,  1.006349,  1.002776,  0.985519,  0.990911,  1.006948,  1.005281,  0.976377,  0.998407,  1.009586,  0.996792,  0.973153,  1.013602,  0.996852,  0.993441,  0.985822,  1.016714,  1.006280,  0.975536,  0.985536,  1.008061,  1.014409,  0.958523,  1.007280,  1.008255,  0.999239,  0.964764,  1.011303,  1.000640,  0.984700,  0.985870,  1.015645,  1.010889,  0.967921,  0.984253,  1.019800,  1.008991,  0.936382,  1.022427,  0.998617,  1.000821,  0.971920,  1.012794,  1.002056,  0.978281,  0.974469,  1.028781,  1.004167,  0.967732,  0.979152,  1.019431,  1.017183,  0.914923,  1.031954,  0.998176,  0.990173,  0.983878,  1.011253,  1.002320,  0.969109,  0.981542,  1.028081,  1.010147,  0.954675,  0.974081, },
{ 1.000000,  1.000321,  1.000090,  0.997208,  1.000989,  1.000459,  0.998882,  0.998581,  1.001823,  1.000742,  0.996019,  0.997306,  1.001858,  1.002092,  0.991946,  0.999055,  1.003894,  0.998675,  0.988156,  1.005325,  0.997263,  0.998072,  0.992146,  1.007663,  1.003940,  0.987652,  0.993501,  1.003817,  1.006192,  0.979382,  1.002018,  1.004815,  0.999137,  0.980638,  1.006659,  0.999897,  0.992679,  0.991097,  1.007156,  1.006467,  0.979784,  0.988674,  1.013141,  1.005845,  0.960507,  1.014119,  1.000100,  1.003800,  0.975615,  1.009449,  1.001241,  0.982849,  0.983501,  1.020995,  1.004381,  0.975592,  0.985982,  1.012992,  1.014291,  0.940559,  1.020021,  1.001340,  0.992748,  0.987301,  1.005922,  0.997725,  0.977473,  0.987327,  1.020605,  1.007961,  0.971129,  0.973144,  1.024127,  1.010318,  0.925186,  1.015241,  1.009483,  0.986966,  0.982884,  1.012672,  1.006696,  0.968660,  0.980231,  1.014933,  1.009970,  0.952473,  0.988329,  1.024385,  0.994834,  0.942874,  1.026078,  0.991067,  0.990604,  0.970963,  1.024418,  1.017165,  0.947463,  0.975876,  1.017663,  1.023346, },
{ 1.000000,  0.999243,  1.000136,  1.000661,  0.999496,  0.997244,  1.001503,  0.999626,  0.998527,  0.997740,  1.002512,  1.002150,  0.993371,  0.995772,  1.004485,  1.002811,  0.984727,  1.005325,  1.000032,  1.001619,  0.989352,  1.002964,  1.000353,  0.991573,  0.990931,  1.010080,  1.001932,  0.987659,  0.993709,  1.004952,  1.007118,  0.968127,  1.011439,  1.002182,  0.996617,  0.990551,  1.004212,  0.998955,  0.984532,  0.991642,  1.011017,  1.006713,  0.981782,  0.982477,  1.015674,  1.004778,  0.951531,  1.011021,  1.006554,  0.994116,  0.988847,  1.005764,  1.003754,  0.977872,  0.986839,  1.010087,  1.007839,  0.963142,  0.990547,  1.017818,  0.995789,  0.961159,  1.016349,  0.995620,  0.986652,  0.983617,  1.014652,  1.014230,  0.964928,  0.982994,  1.011339,  1.015073,  0.949882,  1.000454,  1.015384,  0.989276,  0.953805,  1.025757,  0.992077,  0.982889,  0.982338,  1.019579,  1.015675,  0.954105,  0.972978,  1.025170,  1.015439,  0.920273,  1.025179,  1.001689,  1.003436,  0.952222,  1.012268,  1.003624,  0.971566,  0.966682,  1.033302,  1.008867,  0.952503,  0.977340, },
{ 1.000000,  1.000244,  1.000422,  0.996719,  1.001360,  0.999956,  0.999411,  0.998225,  1.000636,  1.000173,  0.995583,  0.997027,  1.003728,  1.002217,  0.994081,  0.994030,  1.006409,  1.002525,  0.979660,  1.004002,  1.002441,  0.998029,  0.995317,  1.002762,  1.000684,  0.990788,  0.993682,  1.006513,  1.004212,  0.979227,  0.993242,  1.009029,  0.996840,  0.977912,  1.009043,  0.998444,  0.991865,  0.990406,  1.007214,  1.007007,  0.979676,  0.988994,  1.006279,  1.008022,  0.970119,  1.002091,  1.008294,  0.993856,  0.966926,  1.017459,  0.997310,  0.987010,  0.984178,  1.015797,  1.005204,  0.970508,  0.979868,  1.013965,  1.012432,  0.946485,  1.015310,  1.001751,  1.002882,  0.964711,  1.010087,  1.003671,  0.976129,  0.977519,  1.020755,  1.007405,  0.965657,  0.979141,  1.017143,  1.014263,  0.920256,  1.028141,  1.001070,  0.993488,  0.979981,  1.002537,  1.009331,  0.962566,  0.970318,  1.027656,  1.014021,  0.960771,  0.971793,  1.032974,  1.017404,  0.899898,  1.024404,  1.002910,  0.988909,  0.981728,  1.011673,  1.002119,  0.963668,  0.976911,  1.023590,  1.016851, },
{ 1.000000,  0.999297,  0.999508,  1.000912,  0.999642,  0.995927,  1.001730,  1.000058,  0.998221,  0.997584,  1.002077,  1.001244,  0.993398,  0.996372,  1.002341,  1.002572,  0.988632,  1.000739,  1.001662,  0.998864,  0.984668,  1.007611,  0.997838,  0.995032,  0.992801,  1.007590,  1.001626,  0.985112,  0.989875,  1.004973,  1.008183,  0.971762,  1.007095,  1.002821,  1.000315,  0.978843,  1.004456,  1.002836,  0.987957,  0.985527,  1.011031,  1.005833,  0.976079,  0.987082,  1.008922,  1.009976,  0.948227,  1.016993,  0.999769,  0.995889,  0.985315,  1.000434,  1.005122,  0.975673,  0.978445,  1.020343,  1.005374,  0.971259,  0.979356,  1.023250,  1.013213,  0.931071,  1.018083,  0.998533,  0.989646,  0.988106,  1.007031,  0.998830,  0.972423,  0.977943,  1.020438,  1.011087,  0.951923,  0.978030,  1.022960,  0.996178,  0.931608,  1.020605,  1.000568,  0.982183,  0.981766,  1.015979,  1.009022,  0.957328,  0.975727,  1.012588,  1.012697,  0.940638,  1.002350,  1.010137,  0.991937,  0.929345,  1.029437,  0.992163,  0.978300,  0.971871,  1.026768,  1.009974,  0.948167,  0.961493, },
{ 1.000000,  1.000202,  1.000526,  0.997155,  1.000678,  1.000418,  0.999764,  0.995313,  1.001454,  0.999928,  0.996943,  0.996083,  1.003671,  1.001680,  0.992146,  0.995354,  1.004173,  1.002995,  0.979464,  1.007049,  0.998829,  0.998838,  0.991544,  1.002516,  1.000502,  0.988307,  0.989115,  1.009435,  1.002455,  0.985292,  0.988193,  1.009609,  1.007034,  0.959001,  1.013098,  0.998034,  0.992971,  0.992550,  1.003943,  0.997927,  0.984107,  0.987875,  1.013337,  1.004251,  0.972119,  0.984691,  1.014625,  1.000799,  0.951922,  1.014458,  1.000907,  0.989181,  0.986422,  1.009327,  1.003595,  0.972695,  0.982230,  1.009729,  1.007123,  0.957489,  0.996099,  1.014012,  0.992848,  0.952953,  1.020338,  0.992942,  0.986709,  0.975143,  1.025048,  1.007907,  0.959006,  0.974480,  1.010597,  1.020222,  0.931635,  1.008939,  1.009953,  0.996173,  0.943333,  1.014815,  0.998802,  0.974253,  0.975142,  1.021371,  1.013565,  0.949169,  0.973787,  1.026555,  1.010961,  0.901355,  1.030183,  0.995190,  0.997488,  0.956046,  1.015277,  1.000966,  0.964847,  0.959669,  1.038883,  1.003185, },
{ 1.000000,  0.999461,  0.999253,  1.000746,  1.000839,  0.993568,  1.002419,  0.999529,  0.998510,  0.997582,  1.001158,  0.999919,  0.994590,  0.996226,  1.004485,  1.001352,  0.989811,  0.993632,  1.006180,  1.000128,  0.976913,  1.005560,  1.001429,  0.993765,  0.993071,  1.005812,  1.001729,  0.985968,  0.990527,  1.004301,  1.004762,  0.977239,  0.996779,  1.008275,  0.995300,  0.970502,  1.010527,  0.992691,  0.994039,  0.982054,  1.014902,  1.006713,  0.973669,  0.984942,  1.005664,  1.010267,  0.957979,  1.002039,  1.006817,  0.996472,  0.962801,  1.010011,  0.998281,  0.984943,  0.981674,  1.010601,  1.008947,  0.963088,  0.978734,  1.019862,  1.007802,  0.931047,  1.021094,  0.997975,  1.002474,  0.958248,  1.012753,  1.000029,  0.970371,  0.971330,  1.030634,  1.003781,  0.958698,  0.974399,  1.017790,  1.019213,  0.904064,  1.027948,  0.998744,  0.985216,  0.977041,  1.005853,  0.993973,  0.963419,  0.977838,  1.028109,  1.008987,  0.951716,  0.956566,  1.032292,  1.009631,  0.885568,  1.020080,  1.010026,  0.976466,  0.970650,  1.014941,  1.006351,  0.950602,  0.967061, },
{ 1.000000,  1.000159,  1.000186,  0.997756,  0.999181,  1.001437,  0.999250,  0.994068,  1.002435,  0.998489,  0.998239,  0.995230,  1.003374,  1.002141,  0.989885,  0.994492,  1.002597,  1.003891,  0.982726,  1.000710,  1.004131,  0.996114,  0.984559,  1.005679,  0.997550,  0.993315,  0.990923,  1.006893,  1.004925,  0.979507,  0.987291,  1.010611,  1.005806,  0.960864,  1.011270,  0.998247,  1.001322,  0.974671,  1.004733,  0.999106,  0.980735,  0.979729,  1.018096,  1.001558,  0.974129,  0.985267,  1.007565,  1.011378,  0.938923,  1.018957,  1.001142,  0.990962,  0.980635,  1.004923,  0.995671,  0.971303,  0.983346,  1.016676,  1.008336,  0.965626,  0.967938,  1.022439,  1.003766,  0.918268,  1.015597,  1.007314,  0.986861,  0.978023,  1.005951,  1.002769,  0.961847,  0.975420,  1.011666,  1.007817,  0.939004,  0.982744,  1.023954,  0.990128,  0.936677,  1.021511,  0.989141,  0.976948,  0.970852,  1.018794,  1.017314,  0.943692,  0.969780,  1.011822,  1.018031,  0.920582,  0.996392,  1.017698,  0.980986,  0.929784,  1.032453,  0.984465,  0.971019,  0.969751,  1.023492,  1.017156, },
{ 1.000000,  0.999233,  0.999034,  1.000979,  1.000670,  0.993689,  1.001775,  0.999587,  0.999740,  0.993247,  1.001144,  0.999901,  0.994440,  0.993036,  1.005385,  1.000697,  0.989002,  0.993785,  1.004422,  1.003904,  0.971271,  1.007544,  0.998313,  0.995580,  0.990778,  1.001099,  0.998845,  0.983526,  0.988958,  1.009803,  1.004505,  0.981380,  0.982192,  1.014288,  1.003743,  0.948522,  1.007516,  1.003596,  0.992870,  0.986459,  1.003489,  0.999423,  0.978191,  0.984025,  1.010012,  1.004850,  0.955464,  0.984254,  1.014404,  0.991289,  0.954864,  1.014343,  0.993792,  0.982432,  0.978240,  1.010010,  1.009284,  0.959822,  0.976036,  1.007155,  1.010763,  0.943435,  0.999399,  1.010297,  0.986091,  0.940761,  1.025040,  0.991209,  0.974126,  0.969458,  1.021310,  1.004634,  0.947049,  0.962473,  1.019233,  1.015995,  0.907793,  1.019350,  0.997300,  0.999673,  0.939821,  1.012056,  1.001023,  0.957590,  0.958313,  1.027681,  1.005760,  0.940862,  0.962121,  1.020838,  1.016832,  0.871207,  1.036916,  0.996397,  0.984092,  0.963105,  0.999729,  1.006955,  0.936734,  0.949860, },
{ 1.000000,  1.000350,  1.000252,  0.998047,  0.998026,  1.001994,  1.000911,  0.989486,  1.001982,  0.999642,  0.997591,  0.996248,  1.000895,  0.999437,  0.992226,  0.994210,  1.003338,  1.001881,  0.982923,  0.992982,  1.005931,  0.995825,  0.976596,  1.006808,  0.998226,  0.991334,  0.989099,  1.004712,  1.001726,  0.978131,  0.987251,  1.003930,  1.004512,  0.968535,  0.998953,  1.001859,  0.994641,  0.963142,  1.014085,  0.992500,  0.986273,  0.981678,  1.011751,  0.999919,  0.966582,  0.976299,  1.007459,  1.012487,  0.942005,  1.009597,  1.000977,  0.996561,  0.958051,  1.004997,  1.001118,  0.973912,  0.969059,  1.015473,  1.004723,  0.954046,  0.973046,  1.010513,  1.012433,  0.908077,  1.023236,  0.994945,  0.988077,  0.970598,  0.996707,  1.002074,  0.954356,  0.960710,  1.027438,  1.003423,  0.950075,  0.962506,  1.032358,  1.015341,  0.885934,  1.020452,  0.991726,  0.978315,  0.974861,  1.004720,  0.992304,  0.951022,  0.960366,  1.024294,  1.009329,  0.918863,  0.960010,  1.027393,  0.984939,  0.891267,  1.025356,  0.993742,  0.966350,  0.963701,  1.014973,  1.005619, },
{ 1.000000,  0.999172,  0.998956,  1.000247,  1.000382,  0.994683,  0.999448,  1.000396,  0.998113,  0.989512,  1.003221,  0.997509,  0.994830,  0.992994,  1.003610,  1.000386,  0.986417,  0.989054,  1.003148,  1.004619,  0.972908,  1.002693,  0.999807,  0.996433,  0.977224,  1.003443,  0.997456,  0.986408,  0.983704,  1.008659,  1.001565,  0.974272,  0.983803,  1.007634,  1.004530,  0.944279,  1.013498,  0.993762,  0.993207,  0.977005,  1.001411,  0.996360,  0.969783,  0.972384,  1.015449,  1.001233,  0.965743,  0.971303,  1.015556,  1.009330,  0.914549,  1.018756,  0.990559,  0.981688,  0.979991,  1.001495,  0.990960,  0.965392,  0.972407,  1.017808,  1.001659,  0.941988,  0.965770,  1.019060,  0.992872,  0.909831,  1.019523,  0.994472,  0.974203,  0.967927,  1.007929,  0.999760,  0.945763,  0.961850,  1.007624,  1.004373,  0.919805,  0.986750,  1.015340,  0.980502,  0.913731,  1.025007,  0.980343,  0.969029,  0.951496,  1.032274,  1.004223,  0.925432,  0.949731,  1.008996,  1.022807,  0.879133,  1.005266,  1.004611,  0.983998,  0.902523,  1.014135,  0.989152,  0.950162,  0.949425, },
{ 1.000000,  1.000218,  1.000119,  0.997094,  0.997706,  1.001268,  1.000201,  0.988038,  1.002400,  0.998044,  0.997867,  0.991376,  1.000650,  0.998354,  0.990629,  0.989157,  1.006305,  0.998540,  0.984821,  0.987519,  1.004186,  1.002982,  0.959478,  1.008278,  0.994532,  0.990371,  0.986920,  1.000664,  0.996375,  0.979060,  0.984330,  1.008490,  0.999700,  0.966683,  0.978229,  1.010740,  0.993697,  0.938626,  1.008846,  0.997553,  0.979519,  0.977588,  1.006668,  0.998486,  0.963169,  0.973003,  1.002412,  1.003555,  0.945744,  0.988056,  1.009623,  0.983338,  0.933530,  1.012900,  0.979169,  0.980138,  0.959142,  1.021330,  1.005016,  0.943760,  0.962837,  1.002196,  1.010328,  0.912045,  0.995146,  1.001928,  0.984277,  0.925665,  1.008924,  0.989283,  0.963970,  0.956345,  1.009210,  1.005033,  0.926565,  0.953843,  1.022658,  1.003716,  0.870458,  1.024785,  0.986337,  0.989617,  0.921069,  1.009440,  0.990154,  0.939890,  0.942032,  1.038129,  0.994292,  0.920418,  0.943457,  1.018015,  1.018351,  0.830179,  1.030993,  0.984106,  0.961703,  0.948736,  0.996429,  0.978964, },
{ 1.000000,  0.999197,  0.998867,  1.000847,  0.999876,  0.994694,  0.994583,  1.002175,  0.998934,  0.982047,  1.001711,  0.999324,  0.993038,  0.991302,  1.000388,  0.998753,  0.985175,  0.988337,  1.000716,  0.999198,  0.974774,  0.990966,  1.004936,  0.991688,  0.966614,  1.006146,  0.989653,  0.988255,  0.978281,  1.007092,  1.001534,  0.963241,  0.977076,  1.001339,  1.004300,  0.944433,  0.995808,  1.002790,  0.984210,  0.955093,  1.006728,  0.988105,  0.976666,  0.970221,  1.008354,  1.002213,  0.945952,  0.964596,  1.014975,  1.004607,  0.906514,  1.015423,  0.986773,  0.990118,  0.938769,  1.000017,  0.989294,  0.951753,  0.950000,  1.024591,  0.992093,  0.938777,  0.958292,  1.004756,  1.010809,  0.871255,  1.024223,  0.988848,  0.968943,  0.950376,  0.996917,  0.980635,  0.936471,  0.957196,  1.018695,  1.001738,  0.919100,  0.928359,  1.024670,  0.986990,  0.840766,  1.016678,  0.997321,  0.959677,  0.942516,  0.995085,  0.990562,  0.916849,  0.939458,  1.002257,  0.995443,  0.875397,  0.957568,  1.025009,  0.966015,  0.872552,  1.020314,  0.964061,  0.944863,  0.931999, },
{ 1.000000,  1.000103,  1.000049,  0.996044,  0.996474,  0.999502,  1.000075,  0.987648,  0.997240,  0.999686,  0.994260,  0.984523,  1.002876,  0.993415,  0.989473,  0.987912,  1.001364,  0.999078,  0.975199,  0.982471,  1.004500,  1.000104,  0.953860,  1.003765,  0.990955,  0.990606,  0.965534,  0.997880,  0.992954,  0.973050,  0.968956,  1.009038,  0.993673,  0.959391,  0.972499,  1.003876,  1.001245,  0.913817,  1.009085,  0.984472,  0.976604,  0.965972,  0.992262,  0.985910,  0.950909,  0.963809,  1.011588,  0.997647,  0.943021,  0.948397,  1.016285,  0.990306,  0.877711,  1.004512,  0.992994,  0.968391,  0.954034,  0.991954,  0.985173,  0.940382,  0.951164,  1.001408,  0.990275,  0.893233,  0.955465,  1.010534,  0.966151,  0.894584,  1.011313,  0.969911,  0.950147,  0.938763,  1.002130,  0.998180,  0.904633,  0.932401,  0.992104,  0.999617,  0.870137,  0.977812,  0.994901,  0.955228,  0.875631,  1.022896,  0.963001,  0.930835,  0.922129,  1.014091,  0.984291,  0.882173,  0.911336,  1.013363,  1.005793,  0.809780,  1.008556,  0.967004,  0.970277,  0.872803,  0.998794,  0.977409, },
{ 1.000000,  0.998816,  0.997619,  1.000251,  0.998697,  0.992779,  0.993465,  0.999674,  0.998928,  0.976846,  1.001589,  0.994611,  0.991319,  0.986646,  0.994790,  0.995141,  0.977683,  0.980640,  1.002967,  0.996616,  0.971926,  0.976630,  1.004451,  0.993944,  0.937037,  1.000329,  0.988274,  0.978843,  0.972857,  0.991697,  0.987956,  0.962187,  0.968052,  0.995841,  0.990452,  0.934374,  0.967570,  1.001963,  0.973411,  0.922913,  1.003870,  0.979042,  0.962838,  0.954362,  0.995062,  0.987119,  0.929418,  0.949381,  0.989846,  0.992304,  0.905127,  0.977036,  0.983448,  0.968507,  0.902671,  1.009162,  0.963759,  0.948552,  0.937164,  0.999139,  0.976076,  0.905445,  0.926712,  0.995593,  1.002891,  0.852638,  0.993521,  0.972837,  0.963557,  0.892382,  0.986464,  0.976569,  0.919831,  0.907133,  1.002487,  0.978236,  0.880788,  0.916202,  0.990734,  0.993546,  0.792574,  1.010503,  0.957746,  0.942753,  0.910218,  0.965083,  0.968615,  0.879789,  0.896351,  1.018303,  0.973362,  0.872848,  0.898221,  1.024763,  0.986172,  0.755929,  0.998079,  0.946580,  0.921803,  0.909889, },
{ 1.000000,  0.999320,  0.998236,  0.994351,  0.993363,  0.998313,  0.995939,  0.981585,  0.987639,  0.997860,  0.988025,  0.967815,  0.997771,  0.988185,  0.980111,  0.976408,  0.991615,  0.988400,  0.961203,  0.968208,  0.987899,  0.988333,  0.941258,  0.978888,  0.984495,  0.971350,  0.933271,  0.994916,  0.970117,  0.956923,  0.948942,  0.988850,  0.976963,  0.927310,  0.938772,  0.989291,  0.989630,  0.884093,  0.980683,  0.967703,  0.956523,  0.908149,  0.981670,  0.964089,  0.928746,  0.919840,  0.990343,  0.967459,  0.897189,  0.920506,  0.983756,  0.973703,  0.821546,  0.992722,  0.945436,  0.939111,  0.903314,  0.963894,  0.946346,  0.883160,  0.894334,  0.992114,  0.960347,  0.873923,  0.889389,  0.991866,  0.965700,  0.761436,  0.988764,  0.926791,  0.905602,  0.897696,  0.949054,  0.931481,  0.870498,  0.885080,  0.977782,  0.943076,  0.806379,  0.870978,  0.980380,  0.915017,  0.753527,  0.987617,  0.926941,  0.882727,  0.860712,  0.950136,  0.936752,  0.818188,  0.848445,  0.946381,  0.942693,  0.753047,  0.905112,  0.961448,  0.889290,  0.760328,  0.978955,  0.891527, },
{ 1.000000,  0.997642,  0.994354,  0.997419,  0.993996,  0.983508,  0.983824,  0.991762,  0.991982,  0.959964,  0.985601,  0.981852,  0.975502,  0.954946,  0.983816,  0.975094,  0.958686,  0.953977,  0.980943,  0.972841,  0.934234,  0.945558,  0.978081,  0.967203,  0.886665,  0.975254,  0.950247,  0.945743,  0.917158,  0.960933,  0.948772,  0.914894,  0.912339,  0.975991,  0.947105,  0.890037,  0.902486,  0.961506,  0.947426,  0.810499,  0.965189,  0.920256,  0.905747,  0.888325,  0.937167,  0.928423,  0.872075,  0.883429,  0.947884,  0.923997,  0.818136,  0.867110,  0.949825,  0.893403,  0.757884,  0.951331,  0.909640,  0.859823,  0.844025,  0.928050,  0.910023,  0.810680,  0.831955,  0.910131,  0.916482,  0.750168,  0.876841,  0.921223,  0.857667,  0.739216,  0.928688,  0.850621,  0.840739,  0.790590,  0.942040,  0.900668,  0.753902,  0.795511,  0.901072,  0.911479,  0.651950,  0.871536,  0.867619,  0.829237,  0.712303,  0.903439,  0.858446,  0.787986,  0.757349,  0.894004,  0.873066,  0.696720,  0.757974,  0.913085,  0.872130,  0.557082,  0.910271,  0.825904,  0.811764,  0.679220, },
{ 1.000000,  0.995403,  0.989801,  0.979263,  0.973769,  0.980716,  0.969740,  0.944869,  0.947593,  0.960189,  0.949478,  0.893897,  0.951136,  0.929543,  0.911594,  0.897647,  0.918561,  0.911745,  0.876875,  0.880774,  0.911784,  0.894610,  0.816079,  0.841581,  0.896036,  0.852902,  0.754875,  0.890330,  0.864884,  0.812037,  0.794792,  0.849259,  0.841526,  0.754612,  0.771654,  0.831362,  0.821988,  0.678669,  0.783987,  0.824873,  0.759211,  0.671739,  0.824242,  0.766570,  0.731120,  0.693829,  0.804348,  0.774991,  0.618501,  0.676753,  0.773049,  0.764397,  0.514523,  0.731888,  0.728658,  0.654604,  0.583777,  0.758766,  0.702572,  0.624283,  0.594336,  0.734010,  0.697871,  0.493554,  0.579463,  0.733133,  0.685229,  0.362700,  0.720637,  0.625280,  0.582318,  0.453975,  0.656485,  0.625568,  0.484849,  0.496764,  0.702176,  0.607088,  0.392861,  0.488683,  0.633107,  0.597212,  0.222705,  0.676867,  0.556619,  0.463268,  0.393752,  0.564612,  0.543639,  0.378850,  0.433943,  0.601802,  0.550871,  0.213086,  0.343784,  0.587291,  0.418910,  0.086410,  0.618387,  0.525016, },
};
