// th added new file
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <asm/uaccess.h>
#include <linux/vmalloc.h>
#include "procfs.h"

#define bzero(addr, len)        memset(addr, 0, len)

/* the buffer procfs is writing into after copy_from_user */
char * procbuf = NULL;
static struct proc_dir_entry *nistnet_dir, *nistnet_input_file, *nistnet_stats_file;

/* don't call this function directly. it is called after a packet has been taken out
 * of a buffer and it was the last. */
int reload_flowbuffer (flowbuffer *myrbuf) {
	if (myrbuf->buffer_in_use ==  myrbuf->buffer1) {
		myrbuf->buffer1_empty = myrbuf->buffer1;

		if (myrbuf->buffer2_empty!=NULL) {
			//printk("FATAL ERROR: flow %d try to "
			//    "switch to empty buffer2.\n", myrbuf->flowid);
			procstats[myrbuf->flowid].switch_to_emptybuffer2++;
			return -EFAULT;
		}
	  
		//printk("flow %d: reload buffer1 -> buffer2.\n", myrbuf->flowid);
		myrbuf->buffer_in_use = myrbuf->buffer2;
		myrbuf->offsetpos =myrbuf->buffer2;
		procstats[myrbuf->flowid].tobuffer2_switch++;
	}
	else {
		myrbuf->buffer2_empty = myrbuf->buffer2;

		if (myrbuf->buffer1_empty!=NULL) {
			//printk("FATAL ERROR: flow %d try to "
			//    "switch to empty buffer1.\n", myrbuf->flowid);
			procstats[myrbuf->flowid].switch_to_emptybuffer1++;
			return -EFAULT;
		}

		//printk("flow %d: reload buffer2 -> buffer1.\n", myrbuf->flowid);
		myrbuf->buffer_in_use = myrbuf->buffer1;
		myrbuf->offsetpos = myrbuf->buffer1;
		procstats[myrbuf->flowid].tobuffer1_switch++;

	}
	kill_proc(myrbuf->upid,SIGCONT,1);
	//printk("Signal sent .... \n");
	
	return 0;
}

/* return delay struct - called by rcv_packet_munger */
strdelay get_next_delay(flowbuffer *myrbuf) {
	
	strdelay retval;
	bzero(&retval, sizeof(retval));	

	int variout;

	/* on error, drop packet */
	retval.head = 1;

        MOD_INC_USE_COUNT;

	/* sanity check... does our flow exist? */
	if (myrbuf == NULL) {
	  	//printk("FATAL ERROR: read from a uninitialized flow.\n");
		procstats[myrbuf->flowid].uninitialized++;
	        MOD_DEC_USE_COUNT;
		return retval;
	}

	procstats[myrbuf->flowid].packetcount++;

	/* check if we have to reload a buffer */
	if (myrbuf->offsetpos - myrbuf->buffer_in_use == DATA_PACKAGE) {
	  	/* this function returns a negative value if the reload fails.
		 * but i don't care. a normal program would throw an exeption and
		 * stop. we could stop the kernel with a kernel panic? ouuuh...
		 * ok. let's keep using printk's and continue ... 
		 */
		reload_flowbuffer(myrbuf);
	}

	/* sanity check... empty buffers? */
	if ((myrbuf->buffer1_empty != NULL) && (myrbuf->buffer2_empty != NULL)) {
	  	//printk("ERROR: flow %d run out of data. buffer underrun.\n", myrbuf->flowid);
		procstats[myrbuf->flowid].bufferunderrun++;
	        MOD_DEC_USE_COUNT;
		return retval;
	}

	/* sanity check ... active buffer empty? */
	if (myrbuf->buffer1_empty == myrbuf->buffer_in_use ||
				  myrbuf->buffer2_empty == myrbuf->buffer_in_use) {
	  	//printk("FATAL ERROR: buffer in use is empty! flow %d.\n", myrbuf->flowid);
		procstats[myrbuf->flowid].bufferinuseempty++;
	        MOD_DEC_USE_COUNT;
		return retval;
	}

	/* offset check */
	if (myrbuf->offsetpos - myrbuf->buffer_in_use >= DATA_PACKAGE) {
	  	//printk("FATAL ERROR: flow %d: read behind buffer, segfault.\n", myrbuf->flowid);
		procstats[myrbuf->flowid].readbehindbuffer++;
	        MOD_DEC_USE_COUNT;
		return retval;
	}

	/* now it's safe to read :) */
	memcpy(&variout, myrbuf->offsetpos, 4);
	myrbuf->offsetpos+=4;
	
	/* printout what we've read */
	retval.delay = variout & mask_delay;
	retval.head =  (variout & mask_head) >> 29 ;

	/* head 00 (0) -> normal delay
	 *	01 (1) -> drop packet
	 *	10 (2) -> duplicate
	 *	11 (3) -> spare!
	 *
	 * for duplicated packets, nistnet processes them recursively. we
	 * don't have to apply delays to both packets. nistnet requests
	 * for it's delay for itself. how practical. all duplicater code 
	 * deleted again :(
	 */

	switch (retval.head) {
	  case 0:
		procstats[myrbuf->flowid].normaldelay++;
		break;
	  case 1:
		procstats[myrbuf->flowid].drops++;
		break;
	  case 2:
		procstats[myrbuf->flowid].dupl++;
		break;
	}

	procstats[myrbuf->flowid].packetok++;

	MOD_DEC_USE_COUNT;

	return retval;
}


void free_flowbuffer(flowbuffer *victim) {

        /* flowseed delete section */
        int flowid=0, upid=0;

        //printk("how about entry %p and buffer %p with flowid %d?\n", 
        //   &finger->ltEntry, finger->ltEntry.bufferptr, finger->ltEntry.flowid);

        /* while adding a nistnettableentry, we check if the flowid is >= 0. 
         * if this is not the case, we set the bufferptr to NULL. that means if the 
         * bufferptr ist NULL, there isn't a corresponding process and tracefile
         * to this flow and nothing has to be deleted here.
         */

        if (victim != NULL) {
	        
                printk("\nfree_flowbuffer: existing flowbuffer found\n");

                flowid = victim->flowid;
                upid = victim->upid;

                flowbufferptr[flowid]=NULL;

                if (upid > 0) {
                        kill_proc(upid,SIGKILL,1);
                        kill_proc(upid,SIGCONT,1);
                }

                vfree(victim->buffer1);
                vfree(victim->buffer2);
                vfree(victim);

		/* set the bufferptr to zero or bad things will happen... */
	        victim=NULL;

                printk("free_flowbuffer: freed flowbuffer %d\n", flowid);
        
        } else {
	  	printk("ERROR: can't free given flowbuffer, nullpointer\n");
	}
	
}



void Convert(int bin, char *str)
{
    unsigned int mask;      // used to check each individual bit, unsigned 
                            //    to alleviate sign extension problems

    mask = 0x80000000;      // Set only the high-end bit
    while (mask)            // Loop until MASK is empty
    {
        if (bin & mask)     // test the masked bit
              *str = '1';   // if true, value is 1
          else
              *str = '0';   // if false, value is 0
        str++;              // next character
        mask >>= 1;         // shift the mask 1 bit
    }
    *str = 0;               // add the trailing null 
}


static int proc_read_input(char *page, char **start,
                            off_t off, int count, 
                            int *eof, void *data)
{
	start=NULL;
	off=0;
	count=0;
	data=NULL;
	eof=NULL;

        MOD_INC_USE_COUNT;
	
	int flowid, set=0;

	/* checks for an empty flowbuffer slot, allocates and initializes the memory */
	for (flowid=0; flowid < MAX_FLOWS; flowid++) {
		if (flowbufferptr[flowid]==NULL) {	  
			/* found one */
	                flowbufferptr[flowid] = vmalloc(sizeof(flowbuffer));
        	        mybuf = flowbufferptr[flowid];

                	mybuf->buffer1 = vmalloc(DATA_PACKAGE);
	                mybuf->buffer2 = vmalloc(DATA_PACKAGE);
	                mybuf->buffer_in_use = mybuf->buffer1;
	                mybuf->offsetpos = mybuf->buffer1;
	                mybuf->buffer1_empty = mybuf->buffer1;
	                mybuf->buffer2_empty = mybuf->buffer2;
	                mybuf->flowid=flowid;
	                mybuf->upid=0;  /* we don't know yet */
        	        printk("procfs: flowbuffer %d initialized\n", flowid);
			set=1;
			memcpy(page, &flowid, 4);
			break;
		}
	}

	if (set==0) {
		flowid=-1;
		memcpy(page, &flowid, 4);
	}

        MOD_DEC_USE_COUNT;

	return 4;
}

static int proc_write_input(struct file *file,
                             const char *buffer,
                             unsigned long count, 
                             void *data)
{
        int len;
	file=NULL;
	data=NULL;	

        MOD_INC_USE_COUNT;
	//printk("\nreloader: procfs call starts...\n");
	
        if(count > DATA_PACKAGE_ID) {
		printk("FATAL ERROR: Unexpected data received. Size too big.... exit.\n");
        	MOD_DEC_USE_COUNT;
		return -EFAULT;
	}
	else 
	  	len = count;

	//printk("length is %d\n", len);

        if(copy_from_user(procbuf, buffer, len)) {
                MOD_DEC_USE_COUNT;
                return -EFAULT;
        }

	int counter = 0, upid, flowid;
	//int variout,head,delay;
	//char string[33];    // assuming 32bit integers

        while (counter < DATA_PACKAGE) {

	  	/* debug
		memcpy(&variout, procbuf+counter, 4);
	
	        delay = variout & mask_delay;
        	head =  (variout & mask_head) >> 29 ;

	        Convert(variout, string);
        	printk("%s  head: %d delay: %d value: %d\n",
                                        string, head, delay, variout);
		*/
		counter+=4;
	}
	
	memcpy(&upid, procbuf+counter, 4);
	//printk("pid: %d\n", upid);

	memcpy(&flowid, procbuf+counter+4, 4);
	//printk("flowid: %d\n", flowid);

	/* exit if flowid is not in our expected range */
	if (flowid > MAX_FLOWS || flowid < 0) {
		printk("FATAL ERROR: Invalid flowid received.... exit.\n");
        	MOD_DEC_USE_COUNT;
		return -EFAULT;
	}

	/* check if we have to initialize a new bufferstruct */
	if (flowbufferptr[flowid]==NULL) {
		flowbufferptr[flowid] = vmalloc(sizeof(flowbuffer));
		mybuf = flowbufferptr[flowid];

		mybuf->buffer1 = vmalloc(DATA_PACKAGE);
		mybuf->buffer2 = vmalloc(DATA_PACKAGE);
		mybuf->buffer_in_use = mybuf->buffer1;
		mybuf->offsetpos = mybuf->buffer1;	
		mybuf->buffer1_empty = mybuf->buffer1;
		mybuf->buffer2_empty = mybuf->buffer2;
		mybuf->flowid=flowid;
		mybuf->upid=upid;
		printk("\nflowbuffer %d initialized\n", flowid);

	}

	/* ahhh, i don't like long names */
	mybuf = flowbufferptr[flowid];

	/* update pid */
	mybuf->upid = upid;

	/* check if flowbuffer has empty buffer and copy data into it */
	if (mybuf->buffer1_empty != NULL) {
		memcpy(mybuf->buffer1, procbuf, DATA_PACKAGE);
		mybuf->buffer1_empty = NULL;
		procstats[flowid].buffer1_reloads++;
		//printk("flow %d: copied new data into buffer 1\n", flowid);
	} 
	else if (mybuf->buffer2_empty != NULL) {
		memcpy(mybuf->buffer2, procbuf, DATA_PACKAGE);
		mybuf->buffer2_empty = NULL;
		procstats[flowid].buffer2_reloads++;
		//printk("flow %d: copied new data into buffer 2\n", flowid);
	} 
	else {
		printk("FATAL ERROR flow %d: no empty buffer. data loss. exit.\n",flowid);
		procstats[flowid].noemptybuffer++;
        	MOD_DEC_USE_COUNT;
		return -EFAULT;
	}

	/* send stop signal to process if no more empty buffers exist */
	kill_proc(upid,SIGSTOP,1);

	/* if buffers are loaded the first time, only buffer1 gets data. the
	 * following call sends a start for the process to send again data for buffer2 */
	if (mybuf->buffer2_empty != NULL) kill_proc(upid,SIGCONT,1);

	//printk("reloader (flow %d): procfs call ends...\n", flowid);
        MOD_DEC_USE_COUNT;

        return 0;
}

static int proc_read_stats(char *page, char **start,
                            off_t off, int count, 
                            int *eof, void *data)
{
        start=NULL;
        off=0;
        count=0;
        data=NULL;
        eof=NULL;

	char * message;
	message = vmalloc(1024);
	
	int i, offset=0;
	bzero(message, 1024);
	
        MOD_INC_USE_COUNT;
	
	for (i=0; i < MAX_FLOWS; i++) {
	  		
		if (procstats[i].packetcount <= 0) continue;

		bzero(message, 1024);
	
 		sprintf(message, "Statistics for Flow %2d\n"
		    	         "----------------------\n"
		    	 "Packet count:                 %d\n"
	    		 "Packets ok:                   %d\n"
			 "Packets with normal Delay:    %d\n"
			 "Duplicated Packets:           %d\n"
			 "Drops on Request:             %d\n"
			 "Uninitialized access:         %d\n"
			 "Bufferunderruns:              %d\n"
			 "Use of empty Buffer:          %d\n"
			 "No empty Buffer:              %d\n"
			 "Read behind Buffer:           %d\n"
			 "Buffer1 reloads:              %d\n"
			 "Buffer2 reloads:              %d\n"
			 "Switches to Buffer1:          %d\n" 
			 "Switches to Buffer2:          %d\n" 
			 "Switches to empty Buffer1:    %d\n" 
			 "Switches to empty Buffer2:    %d\n\n", 
			 i,
			 procstats[i].packetcount, procstats[i].packetok,
			 procstats[i].normaldelay, procstats[i].drops,
			 procstats[i].dupl,
			 procstats[i].uninitialized, procstats[i].bufferunderrun,
			 procstats[i].bufferinuseempty, procstats[i].noemptybuffer,
			 procstats[i].readbehindbuffer, procstats[i].buffer1_reloads,
			 procstats[i].buffer2_reloads, procstats[i].tobuffer1_switch,
			 procstats[i].tobuffer2_switch, 
			 procstats[i].switch_to_emptybuffer1, 
			 procstats[i].switch_to_emptybuffer2);

		memcpy(page+offset, message, strlen(message));

		offset+=strlen(message);
	}


	vfree(message);

        MOD_DEC_USE_COUNT;

	return offset;
}


static int proc_write_stats(struct file *file,
                             const char *buffer,
                             unsigned long count, 
                             void *data)
{
        file=NULL;
        data=NULL;      

        MOD_INC_USE_COUNT;

	/* clean up */
	bzero(&procstats, sizeof(procstats));

        MOD_DEC_USE_COUNT;

        return count;
}

static int __init init_procfs(void)
{
        int rv = 0;
	bzero(&procstats, sizeof(procstats));

        /* allocate buffer for data from procfs */
        procbuf = vmalloc(DATA_PACKAGE_ID);

        /* initialize flowbufferpointers all to NULL */
        int i;
        for (i = 0 ; i < MAX_FLOWS ; i++) flowbufferptr[i] = NULL;
        mybuf = NULL;

        /* create directory */
	nistnet_dir = proc_mkdir("nistnet", NULL);
        if(nistnet_dir == NULL) {
                rv = -ENOMEM;
                goto out;
        }
        
        nistnet_dir->owner = THIS_MODULE;
        
        /* create files */
        nistnet_input_file = create_proc_entry("input", 0644, nistnet_dir);
        if(nistnet_input_file == NULL) {
                rv = -ENOMEM;
                goto no_input;
        }

	nistnet_stats_file = create_proc_entry("stats", 0644, nistnet_dir);
	if(nistnet_stats_file == NULL) {
	  	rv = -ENOMEM;
		goto no_stats;
	}

        nistnet_input_file->read_proc = proc_read_input;
        nistnet_input_file->write_proc = proc_write_input;
        nistnet_input_file->owner = THIS_MODULE;

        nistnet_stats_file->read_proc = proc_read_stats;
        nistnet_stats_file->write_proc = proc_write_stats;
        nistnet_stats_file->owner = THIS_MODULE;

        /* everything OK */
        printk(KERN_INFO "procfs: initialization passed\n");
        return 0;

no_stats:
	remove_proc_entry("stats", nistnet_dir);
no_input:
        remove_proc_entry("input", nistnet_dir);
	remove_proc_entry("nistnet", NULL);
out:
        return rv;
}


static void __exit cleanup_procfs(void)
{
        remove_proc_entry("input", nistnet_dir);
        remove_proc_entry("stats", nistnet_dir);
        remove_proc_entry("nistnet", NULL);
        vfree(procbuf);

        /* free allocated mem for flowbufferpointers */
        int i;
        for (i = 0 ; i < MAX_FLOWS ; i++) {
                if (flowbufferptr[i] != NULL) {
                        vfree(flowbufferptr[i]->buffer1);
                        vfree(flowbufferptr[i]->buffer2);
                }
        }

        printk(KERN_INFO "procfs part cleaned up\n");
}

