// th added new file
#ifndef _PROC_FS_H
#define _PROC_FS_H

#include <linux/proc_fs.h>
#include "flow.h"

typedef struct _strdelay {
  	u_int8_t head;
  	int delay;
} strdelay;

struct _proc_stats {
  	int packetcount;
  	int packetok;
	int normaldelay;
	int drops;
	int dupl;
	int uninitialized;
	int bufferunderrun;
	int bufferinuseempty;
	int noemptybuffer;
	int readbehindbuffer;
	int buffer1_reloads;
	int buffer2_reloads;
	int tobuffer1_switch;
	int tobuffer2_switch;
  	int switch_to_emptybuffer1;
	int switch_to_emptybuffer2;
} procstats[MAX_FLOWS];

static int mask_head = -536870912; // 11100000000000000000000000000000
static int mask_delay = 536870911; // 00011111111111111111111111111111

flowbuffer *flowbufferptr[MAX_FLOWS], *mybuf, *myrbuf; 

strdelay get_next_delay(flowbuffer *myrbuf);

void free_flowbuffer(flowbuffer *victim);

void Convert(int bin, char *str);

static int proc_read_input(char *page, char **start,
                            off_t off, int count,
                            int *eof, void *data);

static int proc_write_input(struct file *file,
                             const char *buffer,
                             unsigned long count,
                             void *data);

static int proc_read_stats(char *page, char **start,
                            off_t off, int count,
                            int *eof, void *data);

static int proc_write_stats(struct file *file,
                             const char *buffer,
                             unsigned long count,
                             void *data);

static int __init init_procfs(void);
static void __exit cleanup_procfs(void);

#endif
