/* This is the mu "correction" table, indexed by rho from -1.0 to 0.990
 * by 0.010, and sigma from 0 to 0.990 (fraction of mu) by 0.010
 * (Far more precision than really required...)  This is the table
 * for the paretonormal distribution.  You could actually just
 * use this one for all of them (they're all quite close),
 * but I guess I'll make separate tables for each.
 */
/* To determine correction:
 *	index = rint((rho+1)*100)
 * We use linear interpolation between entries...
 */
#define MU_RHO_STEP 100
#define MU_RHO_DOMAIN 200
#define MU_SIGMA_STEP 100
#define MU_SIGMA_DOMAIN 99

double rhomucorrect[MU_RHO_DOMAIN][MU_SIGMA_DOMAIN+1] = {
{ 1.000000,  1.002693,  1.005577,  1.008680,  1.011003,  1.013923,  1.016293,  1.020240,  1.022544,  1.025137,  1.027384,  1.030882,  1.034526,  1.034685,  1.039565,  1.042866,  1.045767,  1.045794,  1.051037,  1.053432,  1.056414,  1.056957,  1.063098,  1.066458,  1.065722,  1.068721,  1.073713,  1.077314,  1.075101,  1.082251,  1.085613,  1.087921,  1.087414,  1.093462,  1.096395,  1.098287,  1.096249,  1.106956,  1.107978,  1.107837,  1.109153,  1.117051,  1.121197,  1.114195,  1.125666,  1.127121,  1.129779,  1.129642,  1.137646,  1.138274,  1.140345,  1.137417,  1.148362,  1.150722,  1.148913,  1.151037,  1.161332,  1.161468,  1.155569,  1.167200,  1.169741,  1.172648,  1.170144,  1.180079,  1.181162,  1.179470,  1.180122,  1.190607,  1.194518,  1.187554,  1.195608,  1.203820,  1.203121,  1.195812,  1.211414,  1.212040,  1.215014,  1.209298,  1.223958,  1.223813,  1.221107,  1.220547,  1.232953,  1.239594,  1.224935,  1.239737,  1.246413,  1.246400,  1.239307,  1.254116,  1.252423,  1.258178,  1.248565,  1.266406,  1.268890,  1.261687,  1.264273,  1.277304,  1.279194,  1.265911, },
{ 1.000000,  1.002687,  1.005854,  1.008573,  1.011300,  1.013953,  1.016806,  1.019586,  1.021281,  1.026072,  1.028414,  1.030917,  1.032949,  1.036580,  1.040335,  1.039391,  1.046035,  1.047975,  1.050781,  1.052501,  1.057508,  1.058788,  1.061353,  1.062135,  1.068800,  1.071216,  1.072064,  1.074202,  1.080726,  1.081909,  1.080450,  1.087742,  1.090500,  1.093578,  1.093492,  1.100401,  1.102305,  1.102538,  1.103603,  1.110937,  1.114296,  1.111737,  1.116665,  1.124014,  1.124339,  1.120902,  1.131636,  1.132045,  1.135717,  1.132870,  1.144402,  1.145084,  1.143564,  1.143820,  1.153124,  1.158526,  1.150215,  1.160147,  1.165779,  1.167763,  1.162173,  1.174353,  1.173572,  1.178253,  1.174062,  1.185536,  1.189731,  1.183512,  1.186926,  1.197363,  1.198637,  1.190801,  1.203960,  1.206910,  1.211371,  1.204073,  1.216098,  1.217088,  1.219224,  1.212184,  1.230243,  1.229961,  1.227677,  1.227484,  1.238520,  1.244214,  1.228538,  1.248476,  1.248614,  1.251459,  1.247137,  1.259134,  1.259759,  1.260012,  1.253709,  1.272391,  1.272718,  1.269746,  1.267984,  1.284588, },
{ 1.000000,  1.002680,  1.005502,  1.008508,  1.010972,  1.013860,  1.016146,  1.019961,  1.022296,  1.024981,  1.027117,  1.030633,  1.033928,  1.034746,  1.038526,  1.042821,  1.045083,  1.044864,  1.051040,  1.052396,  1.056200,  1.056269,  1.062759,  1.065368,  1.065185,  1.067369,  1.072947,  1.077028,  1.074799,  1.080797,  1.085284,  1.086513,  1.085462,  1.093115,  1.094645,  1.098213,  1.097119,  1.104404,  1.108173,  1.105238,  1.108702,  1.116090,  1.118633,  1.113889,  1.123068,  1.127009,  1.130009,  1.125523,  1.135186,  1.137119,  1.139261,  1.136344,  1.147400,  1.149702,  1.147994,  1.149074,  1.156912,  1.162544,  1.152857,  1.165978,  1.168406,  1.170276,  1.168602,  1.177901,  1.177993,  1.179561,  1.176777,  1.190136,  1.191345,  1.190144,  1.188620,  1.200860,  1.204328,  1.191146,  1.208280,  1.211496,  1.213283,  1.208575,  1.221150,  1.221314,  1.219127,  1.218779,  1.230367,  1.234795,  1.227401,  1.231876,  1.245776,  1.243486,  1.234427,  1.252241,  1.249603,  1.254881,  1.247539,  1.264936,  1.265032,  1.259393,  1.259071,  1.272981,  1.279411,  1.263546, },
{ 1.000000,  1.002627,  1.005866,  1.007906,  1.010400,  1.013898,  1.016618,  1.019479,  1.021320,  1.024835,  1.027990,  1.029430,  1.032253,  1.036208,  1.039587,  1.038975,  1.044300,  1.047453,  1.050390,  1.050469,  1.055794,  1.057708,  1.060433,  1.061024,  1.067830,  1.070188,  1.070846,  1.072546,  1.077352,  1.081340,  1.078749,  1.086862,  1.088970,  1.091451,  1.090793,  1.097871,  1.099340,  1.101732,  1.101175,  1.109387,  1.111921,  1.112035,  1.111876,  1.121259,  1.123566,  1.116644,  1.128014,  1.130679,  1.133477,  1.131950,  1.140412,  1.140762,  1.141734,  1.141074,  1.150357,  1.154282,  1.150146,  1.153861,  1.164075,  1.163330,  1.158749,  1.170695,  1.171154,  1.173123,  1.171886,  1.182285,  1.184944,  1.181878,  1.182264,  1.191112,  1.197354,  1.188315,  1.197610,  1.205099,  1.204016,  1.198579,  1.213451,  1.213074,  1.214960,  1.210605,  1.225021,  1.227049,  1.220702,  1.223079,  1.233912,  1.239286,  1.226567,  1.241359,  1.246221,  1.248458,  1.238727,  1.253518,  1.254200,  1.257039,  1.249426,  1.267135,  1.269161,  1.262180,  1.264604,  1.274652, },
{ 1.000000,  1.002678,  1.005460,  1.008479,  1.010791,  1.013693,  1.016051,  1.019546,  1.022026,  1.024974,  1.026154,  1.030675,  1.033416,  1.035335,  1.037344,  1.041934,  1.044650,  1.043892,  1.050065,  1.052737,  1.055267,  1.056495,  1.061436,  1.062868,  1.065558,  1.066503,  1.072317,  1.075809,  1.074377,  1.078000,  1.084108,  1.085525,  1.084393,  1.091947,  1.093917,  1.096026,  1.096670,  1.103364,  1.106125,  1.105484,  1.107034,  1.113242,  1.117734,  1.113752,  1.120764,  1.125814,  1.126663,  1.123863,  1.133807,  1.135754,  1.137414,  1.135266,  1.146339,  1.146711,  1.145759,  1.146747,  1.155645,  1.159447,  1.152109,  1.163630,  1.166512,  1.169261,  1.163775,  1.175764,  1.176421,  1.179080,  1.174940,  1.186861,  1.189779,  1.185949,  1.188347,  1.196854,  1.201205,  1.190308,  1.205229,  1.207962,  1.210114,  1.206677,  1.215704,  1.218746,  1.219545,  1.211667,  1.230289,  1.231103,  1.227476,  1.226368,  1.239484,  1.244756,  1.226964,  1.249264,  1.248534,  1.250790,  1.246590,  1.260483,  1.258204,  1.260567,  1.255229,  1.269183,  1.273637,  1.265439, },
{ 1.000000,  1.002548,  1.005818,  1.008374,  1.010942,  1.013679,  1.016470,  1.019265,  1.021343,  1.025468,  1.027888,  1.030067,  1.032300,  1.036290,  1.039773,  1.039705,  1.044121,  1.047316,  1.049925,  1.050150,  1.056380,  1.058284,  1.061120,  1.061822,  1.068388,  1.069357,  1.070386,  1.072467,  1.077575,  1.082447,  1.079278,  1.086306,  1.089922,  1.092339,  1.090997,  1.098071,  1.099419,  1.102711,  1.101537,  1.109788,  1.113490,  1.110785,  1.114274,  1.119748,  1.124609,  1.118560,  1.128318,  1.131037,  1.133999,  1.132386,  1.139534,  1.142088,  1.143393,  1.139657,  1.154042,  1.154024,  1.152303,  1.153170,  1.162183,  1.167063,  1.156754,  1.172203,  1.172108,  1.175113,  1.173878,  1.183259,  1.182197,  1.184705,  1.180764,  1.193899,  1.196539,  1.192625,  1.195109,  1.206295,  1.205682,  1.198633,  1.212228,  1.214101,  1.216384,  1.213993,  1.225166,  1.226482,  1.222795,  1.223957,  1.234266,  1.239205,  1.230051,  1.239296,  1.248141,  1.247041,  1.238195,  1.256384,  1.255922,  1.258777,  1.251609,  1.268438,  1.267996,  1.263347,  1.263337,  1.275699, },
{ 1.000000,  1.002668,  1.005412,  1.008322,  1.011546,  1.013993,  1.016232,  1.019948,  1.022780,  1.026189,  1.027565,  1.031979,  1.034889,  1.036225,  1.039216,  1.043232,  1.045987,  1.046323,  1.051536,  1.054381,  1.057172,  1.057815,  1.063189,  1.065418,  1.068193,  1.068236,  1.075961,  1.077894,  1.078833,  1.080215,  1.086310,  1.090506,  1.085746,  1.095951,  1.096904,  1.099482,  1.100360,  1.107156,  1.107524,  1.110896,  1.109523,  1.119256,  1.121491,  1.120629,  1.122262,  1.130553,  1.131929,  1.128015,  1.137740,  1.139715,  1.142903,  1.141737,  1.150634,  1.151547,  1.151173,  1.152643,  1.161097,  1.165010,  1.159940,  1.165805,  1.174154,  1.174105,  1.168977,  1.182979,  1.181453,  1.185536,  1.181767,  1.195626,  1.195496,  1.191802,  1.193868,  1.203204,  1.210722,  1.198480,  1.210959,  1.216788,  1.217803,  1.210473,  1.226332,  1.223698,  1.228854,  1.223621,  1.236512,  1.241440,  1.231859,  1.237337,  1.248839,  1.250259,  1.239834,  1.255940,  1.258204,  1.262454,  1.253163,  1.268104,  1.267959,  1.270057,  1.261470,  1.282361,  1.281639,  1.277564, },
{ 1.000000,  1.002511,  1.005679,  1.008417,  1.010681,  1.013657,  1.016284,  1.019115,  1.021100,  1.025023,  1.027338,  1.030173,  1.031629,  1.036453,  1.039046,  1.040187,  1.042587,  1.047229,  1.049762,  1.049451,  1.055314,  1.058210,  1.060756,  1.061278,  1.066938,  1.068496,  1.070014,  1.071712,  1.077284,  1.081050,  1.079319,  1.084088,  1.089922,  1.091116,  1.088756,  1.098063,  1.097625,  1.102077,  1.100418,  1.109525,  1.111661,  1.109809,  1.112168,  1.118418,  1.123510,  1.117901,  1.126047,  1.130906,  1.131721,  1.129449,  1.139263,  1.139739,  1.143137,  1.140744,  1.149206,  1.154367,  1.148400,  1.152728,  1.161324,  1.163411,  1.156119,  1.168666,  1.172085,  1.174716,  1.167865,  1.180460,  1.180965,  1.182825,  1.179719,  1.193098,  1.195264,  1.191009,  1.192271,  1.200769,  1.207097,  1.194661,  1.211285,  1.212821,  1.213747,  1.211580,  1.222852,  1.220716,  1.222851,  1.218821,  1.234810,  1.235429,  1.232922,  1.231015,  1.244950,  1.248887,  1.232541,  1.252296,  1.254861,  1.255818,  1.250663,  1.265936,  1.264639,  1.261481,  1.260949,  1.273813, },
{ 1.000000,  1.002609,  1.005451,  1.007584,  1.010815,  1.013400,  1.015452,  1.018620,  1.020937,  1.023898,  1.025888,  1.030229,  1.032067,  1.033837,  1.036178,  1.040370,  1.043948,  1.042900,  1.047962,  1.051542,  1.053448,  1.053682,  1.059273,  1.061549,  1.063840,  1.064826,  1.070121,  1.073727,  1.072401,  1.075372,  1.081324,  1.083870,  1.080750,  1.088949,  1.092268,  1.094081,  1.091800,  1.099845,  1.101632,  1.103868,  1.102408,  1.112153,  1.113853,  1.112400,  1.115286,  1.120027,  1.124919,  1.118858,  1.130298,  1.131513,  1.133921,  1.131596,  1.140737,  1.141425,  1.142629,  1.141111,  1.151951,  1.154706,  1.152385,  1.151667,  1.163176,  1.164995,  1.155807,  1.169485,  1.171810,  1.174246,  1.171381,  1.182369,  1.181495,  1.181695,  1.180344,  1.191213,  1.194879,  1.188011,  1.193365,  1.205295,  1.203185,  1.196685,  1.210557,  1.210476,  1.212091,  1.211079,  1.222413,  1.225026,  1.219553,  1.220199,  1.230253,  1.236934,  1.225174,  1.236367,  1.244260,  1.241705,  1.235199,  1.252958,  1.251400,  1.251793,  1.247572,  1.263502,  1.266412,  1.256514, },
{ 1.000000,  1.002488,  1.005642,  1.007834,  1.009968,  1.013368,  1.016321,  1.019029,  1.020087,  1.024007,  1.026553,  1.029349,  1.030239,  1.035169,  1.037671,  1.038756,  1.041782,  1.044935,  1.048696,  1.047696,  1.054122,  1.056215,  1.058311,  1.059290,  1.064223,  1.066825,  1.068287,  1.068570,  1.075825,  1.078111,  1.078973,  1.079162,  1.086022,  1.089527,  1.084959,  1.094245,  1.096196,  1.098596,  1.097902,  1.105842,  1.105452,  1.108144,  1.107485,  1.115399,  1.119422,  1.114968,  1.119650,  1.127218,  1.128017,  1.124798,  1.133694,  1.135480,  1.137587,  1.137494,  1.145148,  1.148047,  1.145478,  1.146743,  1.155056,  1.159319,  1.152567,  1.161185,  1.167233,  1.167166,  1.162229,  1.175036,  1.176393,  1.177612,  1.173596,  1.187092,  1.188133,  1.183833,  1.186107,  1.195289,  1.199598,  1.188980,  1.203000,  1.207226,  1.208089,  1.200938,  1.215292,  1.215678,  1.216608,  1.212452,  1.226602,  1.229152,  1.222590,  1.225540,  1.235005,  1.240383,  1.225691,  1.243955,  1.245855,  1.247767,  1.242546,  1.253972,  1.257218,  1.255989,  1.246845,  1.268220, },
{ 1.000000,  1.002587,  1.005464,  1.007410,  1.010565,  1.013521,  1.014926,  1.018392,  1.020949,  1.023699,  1.025678,  1.029280,  1.031225,  1.034205,  1.035522,  1.039609,  1.042697,  1.043157,  1.046415,  1.050532,  1.052793,  1.052662,  1.058117,  1.060276,  1.062779,  1.063931,  1.069693,  1.072027,  1.071642,  1.073918,  1.079125,  1.083288,  1.080732,  1.086111,  1.090405,  1.092497,  1.089771,  1.098719,  1.099833,  1.102694,  1.101507,  1.109958,  1.111354,  1.110475,  1.111781,  1.117967,  1.124028,  1.117498,  1.126047,  1.130480,  1.132032,  1.128719,  1.137751,  1.138710,  1.142053,  1.139052,  1.149811,  1.153137,  1.147450,  1.151759,  1.158012,  1.163057,  1.154126,  1.166453,  1.169580,  1.171791,  1.168066,  1.176777,  1.179699,  1.179288,  1.174037,  1.191888,  1.191869,  1.187411,  1.188055,  1.198897,  1.204402,  1.189231,  1.208201,  1.207801,  1.210466,  1.207849,  1.218745,  1.217519,  1.219598,  1.213939,  1.229025,  1.231712,  1.225344,  1.227872,  1.240630,  1.240185,  1.230253,  1.246043,  1.247705,  1.249521,  1.245612,  1.258614,  1.259125,  1.254323, },
{ 1.000000,  1.002451,  1.005579,  1.007746,  1.009979,  1.013043,  1.016199,  1.018037,  1.019752,  1.023867,  1.026355,  1.029148,  1.030070,  1.034807,  1.037052,  1.038523,  1.040945,  1.044462,  1.048508,  1.047232,  1.053014,  1.055915,  1.057507,  1.058290,  1.063888,  1.065582,  1.068430,  1.068193,  1.074858,  1.077544,  1.076852,  1.079591,  1.084699,  1.087999,  1.085092,  1.092195,  1.094881,  1.097832,  1.096672,  1.103748,  1.105008,  1.107019,  1.105096,  1.115678,  1.117216,  1.115664,  1.117384,  1.124363,  1.129953,  1.119987,  1.133751,  1.134143,  1.136574,  1.136103,  1.143698,  1.143647,  1.146394,  1.143208,  1.154760,  1.156873,  1.154172,  1.155875,  1.165718,  1.166557,  1.159405,  1.171729,  1.173788,  1.176886,  1.173963,  1.183993,  1.184965,  1.183471,  1.183046,  1.193136,  1.197437,  1.189824,  1.196411,  1.205508,  1.205218,  1.198077,  1.213779,  1.211968,  1.215466,  1.210765,  1.226013,  1.225755,  1.220171,  1.221288,  1.231595,  1.240297,  1.224405,  1.238411,  1.245013,  1.245365,  1.236312,  1.253157,  1.250625,  1.255335,  1.249489,  1.263440, },
{ 1.000000,  1.002582,  1.005319,  1.007408,  1.010453,  1.013228,  1.015043,  1.018720,  1.020804,  1.023675,  1.025199,  1.029183,  1.031681,  1.033869,  1.034860,  1.040138,  1.042463,  1.043883,  1.045889,  1.049663,  1.053888,  1.051721,  1.058791,  1.060222,  1.062876,  1.063820,  1.068841,  1.070869,  1.072857,  1.072594,  1.080033,  1.082284,  1.082871,  1.083739,  1.090534,  1.093057,  1.089164,  1.098019,  1.100185,  1.102640,  1.101719,  1.109565,  1.109819,  1.110888,  1.111647,  1.118526,  1.123075,  1.118077,  1.123892,  1.131170,  1.131645,  1.127427,  1.138670,  1.136874,  1.142646,  1.138483,  1.150118,  1.151139,  1.148155,  1.150273,  1.157641,  1.164632,  1.154361,  1.164653,  1.169829,  1.170458,  1.166342,  1.177420,  1.177415,  1.180849,  1.178035,  1.187835,  1.193207,  1.184404,  1.189403,  1.198776,  1.201733,  1.190193,  1.205164,  1.209967,  1.212477,  1.202904,  1.217164,  1.216951,  1.219091,  1.214333,  1.229927,  1.231721,  1.225131,  1.227425,  1.236017,  1.244676,  1.226587,  1.246553,  1.248147,  1.249347,  1.245051,  1.257169,  1.254884,  1.257690, },
{ 1.000000,  1.002405,  1.005571,  1.007645,  1.010122,  1.012575,  1.015951,  1.018235,  1.019211,  1.023544,  1.026306,  1.028457,  1.029945,  1.034439,  1.036391,  1.038059,  1.040071,  1.044079,  1.047584,  1.047662,  1.050556,  1.055585,  1.057230,  1.057126,  1.062824,  1.064038,  1.067437,  1.068024,  1.073637,  1.076069,  1.075861,  1.078052,  1.082938,  1.087605,  1.083781,  1.090395,  1.094964,  1.095399,  1.094462,  1.102399,  1.103664,  1.105889,  1.105291,  1.112655,  1.117059,  1.112498,  1.115969,  1.122632,  1.126989,  1.119229,  1.130481,  1.133928,  1.136134,  1.131548,  1.140895,  1.142114,  1.144734,  1.141949,  1.153148,  1.155236,  1.151646,  1.154828,  1.160032,  1.166427,  1.156363,  1.170482,  1.171541,  1.174793,  1.169998,  1.180949,  1.180610,  1.182922,  1.179051,  1.191686,  1.195597,  1.191073,  1.189578,  1.202780,  1.205776,  1.191009,  1.208736,  1.211171,  1.213785,  1.208881,  1.220788,  1.219924,  1.220693,  1.217441,  1.229221,  1.234590,  1.224809,  1.230503,  1.243511,  1.242021,  1.232785,  1.248972,  1.247519,  1.249561,  1.247865,  1.260250, },
{ 1.000000,  1.002539,  1.005364,  1.007715,  1.010901,  1.013303,  1.014983,  1.018293,  1.021203,  1.023834,  1.025224,  1.029746,  1.031787,  1.034437,  1.035657,  1.039884,  1.043069,  1.043437,  1.046325,  1.050360,  1.054159,  1.052730,  1.057983,  1.061532,  1.063846,  1.063039,  1.069175,  1.071071,  1.074262,  1.073872,  1.080608,  1.083112,  1.081904,  1.085262,  1.089714,  1.094844,  1.089774,  1.098908,  1.101037,  1.103973,  1.102283,  1.108920,  1.110751,  1.113235,  1.111304,  1.121033,  1.123821,  1.122802,  1.122035,  1.130451,  1.135371,  1.125683,  1.138574,  1.140901,  1.143719,  1.140879,  1.150674,  1.149199,  1.152608,  1.150115,  1.159474,  1.164879,  1.157748,  1.162636,  1.172253,  1.172915,  1.166075,  1.178317,  1.179262,  1.182089,  1.180368,  1.190181,  1.192728,  1.189641,  1.189415,  1.197804,  1.205363,  1.194331,  1.204816,  1.211213,  1.211879,  1.204610,  1.219340,  1.220301,  1.221497,  1.216404,  1.231140,  1.232953,  1.226929,  1.228857,  1.238750,  1.245863,  1.229572,  1.246602,  1.250914,  1.253159,  1.242896,  1.258951,  1.259119,  1.261574, },
{ 1.000000,  1.002391,  1.005498,  1.007597,  1.009895,  1.012616,  1.015606,  1.018795,  1.019516,  1.023236,  1.025946,  1.028711,  1.030318,  1.033805,  1.036145,  1.038571,  1.039313,  1.044848,  1.047643,  1.048516,  1.050163,  1.054748,  1.058654,  1.055375,  1.063449,  1.064719,  1.067579,  1.067825,  1.073827,  1.074862,  1.077629,  1.077140,  1.083581,  1.087354,  1.085318,  1.088628,  1.094323,  1.097105,  1.093429,  1.101906,  1.103973,  1.105984,  1.105970,  1.113101,  1.115414,  1.114438,  1.115721,  1.121601,  1.127223,  1.122052,  1.128859,  1.133153,  1.135597,  1.130283,  1.141689,  1.142296,  1.145568,  1.143513,  1.152779,  1.154110,  1.151816,  1.153471,  1.159715,  1.168202,  1.156897,  1.168458,  1.173304,  1.174941,  1.168612,  1.180106,  1.180685,  1.184840,  1.180188,  1.191758,  1.196252,  1.188153,  1.192983,  1.198934,  1.207488,  1.192824,  1.208319,  1.210691,  1.215051,  1.208801,  1.218461,  1.220609,  1.221462,  1.213883,  1.233867,  1.234801,  1.227563,  1.228306,  1.239643,  1.248250,  1.227407,  1.250362,  1.248295,  1.252704,  1.247737,  1.260839, },
{ 1.000000,  1.002462,  1.005419,  1.007544,  1.010240,  1.013084,  1.015121,  1.017763,  1.021028,  1.023934,  1.024752,  1.028548,  1.031141,  1.033680,  1.035586,  1.039428,  1.042201,  1.043552,  1.045260,  1.049421,  1.052987,  1.052532,  1.056664,  1.060954,  1.063112,  1.062005,  1.068340,  1.070015,  1.073423,  1.072976,  1.079530,  1.081793,  1.081696,  1.083247,  1.088059,  1.094051,  1.088571,  1.096575,  1.100663,  1.102305,  1.100221,  1.107749,  1.108536,  1.112888,  1.110647,  1.118761,  1.122459,  1.118722,  1.122315,  1.128039,  1.132848,  1.125636,  1.136308,  1.138399,  1.141940,  1.138342,  1.146654,  1.148332,  1.150292,  1.146850,  1.159273,  1.161022,  1.158076,  1.158861,  1.167016,  1.175178,  1.159699,  1.178063,  1.177065,  1.180320,  1.177626,  1.187478,  1.185758,  1.190566,  1.184537,  1.197991,  1.201700,  1.195597,  1.197408,  1.208031,  1.211582,  1.199621,  1.214768,  1.216038,  1.219969,  1.216101,  1.226789,  1.227735,  1.226334,  1.224764,  1.235096,  1.241797,  1.230438,  1.237892,  1.248207,  1.249651,  1.238441,  1.256114,  1.253071,  1.259234, },
{ 1.000000,  1.002374,  1.005476,  1.007935,  1.010504,  1.012817,  1.015794,  1.019249,  1.020097,  1.023888,  1.026960,  1.029135,  1.029944,  1.034469,  1.036401,  1.039639,  1.040940,  1.045071,  1.048508,  1.048362,  1.051465,  1.055873,  1.059027,  1.057389,  1.063719,  1.066309,  1.069815,  1.068749,  1.074341,  1.076615,  1.079180,  1.078707,  1.085686,  1.088251,  1.087683,  1.089663,  1.094442,  1.100760,  1.093605,  1.104427,  1.105219,  1.109054,  1.107652,  1.114332,  1.115719,  1.118491,  1.116717,  1.125391,  1.129394,  1.127024,  1.127721,  1.136385,  1.140059,  1.131670,  1.143062,  1.145425,  1.148731,  1.145595,  1.155469,  1.155454,  1.156490,  1.155599,  1.163262,  1.170423,  1.161792,  1.168725,  1.177318,  1.178534,  1.170468,  1.185319,  1.182124,  1.189632,  1.183264,  1.196046,  1.198618,  1.193353,  1.194522,  1.202332,  1.212883,  1.197365,  1.210478,  1.215761,  1.217159,  1.210011,  1.223452,  1.223166,  1.227610,  1.223422,  1.232596,  1.241767,  1.229338,  1.234474,  1.244192,  1.250454,  1.232993,  1.252061,  1.255828,  1.260381,  1.246166,  1.263134, },
{ 1.000000,  1.002429,  1.005324,  1.007505,  1.010803,  1.013419,  1.015379,  1.017546,  1.020316,  1.024180,  1.024054,  1.029049,  1.031233,  1.034015,  1.035483,  1.039500,  1.041333,  1.044345,  1.045257,  1.050347,  1.052869,  1.053609,  1.055143,  1.060023,  1.064383,  1.060300,  1.068496,  1.070780,  1.073701,  1.073524,  1.079528,  1.081028,  1.082639,  1.083232,  1.088188,  1.093015,  1.090076,  1.094249,  1.100703,  1.102847,  1.099010,  1.108340,  1.108059,  1.112671,  1.111440,  1.119315,  1.121676,  1.119285,  1.121270,  1.127125,  1.134562,  1.125539,  1.134739,  1.139965,  1.140556,  1.137586,  1.147351,  1.148037,  1.151461,  1.149483,  1.156752,  1.163052,  1.156096,  1.159693,  1.166730,  1.173641,  1.160955,  1.175959,  1.179198,  1.182487,  1.174619,  1.186124,  1.187162,  1.189896,  1.185458,  1.198452,  1.201690,  1.195276,  1.198813,  1.204087,  1.214729,  1.197609,  1.216525,  1.216813,  1.221774,  1.214280,  1.225611,  1.224641,  1.228720,  1.223120,  1.236448,  1.242823,  1.235597,  1.233190,  1.247997,  1.253562,  1.232600,  1.255075,  1.256356,  1.259925, },
{ 1.000000,  1.002356,  1.005373,  1.007702,  1.010514,  1.012577,  1.015228,  1.018342,  1.019466,  1.022659,  1.026052,  1.028810,  1.029444,  1.033907,  1.035972,  1.038705,  1.040216,  1.043907,  1.046782,  1.047938,  1.049940,  1.053742,  1.058537,  1.056241,  1.061656,  1.065207,  1.066736,  1.066208,  1.072924,  1.074339,  1.076899,  1.077771,  1.083013,  1.087014,  1.084976,  1.088111,  1.092648,  1.097568,  1.092155,  1.100821,  1.104255,  1.106871,  1.103625,  1.111198,  1.112680,  1.116553,  1.114711,  1.122203,  1.125969,  1.122319,  1.126113,  1.130228,  1.138269,  1.127782,  1.140955,  1.141819,  1.145844,  1.142924,  1.149413,  1.150917,  1.153892,  1.151083,  1.161304,  1.165996,  1.161895,  1.161539,  1.171023,  1.178484,  1.162233,  1.179368,  1.180763,  1.184568,  1.180030,  1.190641,  1.189149,  1.192823,  1.189324,  1.198681,  1.206513,  1.194935,  1.201108,  1.211335,  1.213353,  1.203113,  1.218092,  1.218310,  1.221748,  1.219526,  1.228831,  1.231856,  1.227728,  1.227481,  1.235713,  1.246206,  1.230673,  1.243461,  1.249957,  1.251123,  1.241075,  1.257153, },
{ 1.000000,  1.002412,  1.005256,  1.007429,  1.010627,  1.013129,  1.015153,  1.017697,  1.020759,  1.024073,  1.024477,  1.028648,  1.031554,  1.034120,  1.035069,  1.039202,  1.041446,  1.044331,  1.045507,  1.049867,  1.053116,  1.052977,  1.056187,  1.059403,  1.064632,  1.060582,  1.068242,  1.070522,  1.073606,  1.073562,  1.078027,  1.080819,  1.083211,  1.081960,  1.089744,  1.092912,  1.091514,  1.093350,  1.099393,  1.105085,  1.095895,  1.108800,  1.109227,  1.112759,  1.111646,  1.118600,  1.119147,  1.122424,  1.120864,  1.127877,  1.133500,  1.127932,  1.131958,  1.139351,  1.142976,  1.135201,  1.146718,  1.148349,  1.151314,  1.150077,  1.158057,  1.160558,  1.158191,  1.159133,  1.165831,  1.174049,  1.164162,  1.173801,  1.177567,  1.181925,  1.172430,  1.187329,  1.186677,  1.190689,  1.187604,  1.197777,  1.199963,  1.195835,  1.197396,  1.203293,  1.215790,  1.198753,  1.213788,  1.218538,  1.220701,  1.212399,  1.224977,  1.224943,  1.230577,  1.224663,  1.236020,  1.243572,  1.231566,  1.237869,  1.242338,  1.255347,  1.234249,  1.254206,  1.255629,  1.261331, },
{ 1.000000,  1.002315,  1.005194,  1.007587,  1.010347,  1.012215,  1.016165,  1.019009,  1.020499,  1.023171,  1.026238,  1.029922,  1.029075,  1.034720,  1.036511,  1.039583,  1.040763,  1.045002,  1.047098,  1.049969,  1.050704,  1.055388,  1.059286,  1.058352,  1.061367,  1.066208,  1.069254,  1.066560,  1.073909,  1.076354,  1.079388,  1.079781,  1.084928,  1.087305,  1.087469,  1.089584,  1.094028,  1.099814,  1.094976,  1.101549,  1.106411,  1.109123,  1.104547,  1.114274,  1.115282,  1.119009,  1.117233,  1.124560,  1.127383,  1.125276,  1.127535,  1.132617,  1.141525,  1.130699,  1.142594,  1.146423,  1.148032,  1.143736,  1.153880,  1.152849,  1.158944,  1.154973,  1.163817,  1.169053,  1.162975,  1.167850,  1.172793,  1.180399,  1.167796,  1.182736,  1.183420,  1.188910,  1.182945,  1.192336,  1.193350,  1.195977,  1.191901,  1.204956,  1.208417,  1.202857,  1.204204,  1.212020,  1.224014,  1.200460,  1.225533,  1.221835,  1.227529,  1.223742,  1.233361,  1.231166,  1.236855,  1.229943,  1.243257,  1.249704,  1.239927,  1.242489,  1.253622,  1.259137,  1.241747,  1.261879, },
{ 1.000000,  1.002348,  1.005208,  1.007371,  1.010635,  1.013406,  1.015478,  1.017997,  1.020817,  1.024295,  1.024840,  1.028632,  1.032125,  1.034663,  1.034969,  1.039893,  1.041574,  1.045252,  1.046059,  1.050949,  1.053392,  1.053898,  1.056162,  1.059823,  1.065865,  1.062016,  1.068723,  1.071697,  1.074584,  1.072645,  1.079984,  1.081134,  1.084772,  1.085116,  1.089884,  1.094584,  1.091070,  1.095835,  1.100653,  1.105066,  1.098996,  1.109043,  1.110747,  1.115182,  1.112012,  1.119093,  1.120881,  1.123374,  1.121704,  1.130720,  1.133599,  1.131571,  1.133963,  1.138195,  1.147899,  1.134106,  1.150259,  1.149592,  1.154587,  1.151435,  1.158705,  1.159487,  1.163062,  1.159847,  1.170053,  1.175131,  1.169920,  1.171532,  1.180464,  1.186350,  1.171757,  1.188876,  1.190559,  1.194062,  1.189739,  1.200129,  1.200229,  1.200776,  1.199689,  1.207026,  1.217041,  1.203214,  1.213261,  1.221795,  1.224716,  1.212442,  1.230755,  1.225032,  1.234872,  1.226557,  1.240453,  1.244077,  1.236658,  1.239264,  1.246166,  1.259773,  1.238130,  1.255729,  1.260660,  1.262755, },
{ 1.000000,  1.002233,  1.005174,  1.007422,  1.010265,  1.012931,  1.015574,  1.018916,  1.019946,  1.022970,  1.025848,  1.029089,  1.028787,  1.034229,  1.036854,  1.039913,  1.039686,  1.044453,  1.046566,  1.048815,  1.050198,  1.055537,  1.058587,  1.058321,  1.060880,  1.064450,  1.070218,  1.065053,  1.073694,  1.075293,  1.079090,  1.078539,  1.083883,  1.084806,  1.088071,  1.088052,  1.094374,  1.097950,  1.097172,  1.098269,  1.104685,  1.110555,  1.100507,  1.113347,  1.114906,  1.118012,  1.116131,  1.124085,  1.125194,  1.125774,  1.126300,  1.132160,  1.138434,  1.131595,  1.137507,  1.145300,  1.148156,  1.140563,  1.152866,  1.151250,  1.156404,  1.154010,  1.163453,  1.166421,  1.162330,  1.164482,  1.170911,  1.180826,  1.165868,  1.179234,  1.184181,  1.184924,  1.179139,  1.191804,  1.191895,  1.195020,  1.192468,  1.200836,  1.208538,  1.198081,  1.203237,  1.210290,  1.219668,  1.200496,  1.220885,  1.223255,  1.227422,  1.216102,  1.229402,  1.230772,  1.233811,  1.228559,  1.243224,  1.246513,  1.237440,  1.242278,  1.246036,  1.261363,  1.236982,  1.261179, },
{ 1.000000,  1.002321,  1.005170,  1.007763,  1.010445,  1.013038,  1.015428,  1.017576,  1.021327,  1.024147,  1.025708,  1.027558,  1.031672,  1.035362,  1.033695,  1.039891,  1.041843,  1.045190,  1.046154,  1.050378,  1.052537,  1.054276,  1.055977,  1.060456,  1.064803,  1.062286,  1.066592,  1.072074,  1.074939,  1.072049,  1.079515,  1.080615,  1.083813,  1.084675,  1.090051,  1.093294,  1.092444,  1.094391,  1.098956,  1.106029,  1.099026,  1.107310,  1.111587,  1.113479,  1.109610,  1.119680,  1.120697,  1.123060,  1.122358,  1.129593,  1.134172,  1.129543,  1.133412,  1.138098,  1.146086,  1.134645,  1.148278,  1.151345,  1.154593,  1.147611,  1.157613,  1.159310,  1.163000,  1.159305,  1.169821,  1.173987,  1.167704,  1.172441,  1.176458,  1.187613,  1.171065,  1.189087,  1.189035,  1.194152,  1.188212,  1.197334,  1.198872,  1.201286,  1.196977,  1.209205,  1.215456,  1.208245,  1.207687,  1.218617,  1.228537,  1.205229,  1.228644,  1.228888,  1.233705,  1.226113,  1.239823,  1.237377,  1.240611,  1.235842,  1.246830,  1.258009,  1.239610,  1.249048,  1.259926,  1.264057, },
{ 1.000000,  1.002170,  1.005514,  1.007956,  1.010930,  1.013117,  1.016108,  1.019210,  1.021026,  1.023629,  1.026907,  1.030371,  1.030572,  1.034944,  1.037743,  1.040729,  1.040765,  1.046492,  1.048552,  1.050996,  1.052208,  1.056955,  1.060619,  1.060291,  1.062736,  1.067165,  1.072158,  1.068187,  1.076025,  1.078472,  1.082316,  1.079635,  1.086371,  1.088953,  1.091308,  1.091423,  1.098007,  1.101536,  1.099317,  1.102775,  1.107060,  1.114558,  1.104656,  1.116935,  1.118754,  1.123020,  1.120092,  1.126202,  1.130139,  1.131127,  1.128731,  1.138915,  1.143073,  1.138950,  1.140695,  1.148474,  1.156677,  1.139921,  1.159750,  1.158423,  1.162766,  1.159581,  1.168893,  1.168978,  1.172143,  1.168773,  1.177881,  1.186091,  1.175307,  1.181235,  1.190246,  1.195620,  1.181586,  1.197981,  1.199289,  1.202467,  1.199288,  1.210065,  1.212638,  1.208142,  1.208698,  1.217121,  1.228082,  1.211831,  1.225951,  1.229509,  1.235716,  1.220628,  1.239912,  1.239367,  1.242643,  1.238053,  1.251104,  1.253832,  1.246820,  1.248452,  1.254517,  1.271745,  1.246738,  1.267440, },
{ 1.000000,  1.002310,  1.005487,  1.007554,  1.010869,  1.013287,  1.016300,  1.018101,  1.021451,  1.024911,  1.025905,  1.029221,  1.031675,  1.036120,  1.035091,  1.040237,  1.043226,  1.046488,  1.047038,  1.050813,  1.053739,  1.055980,  1.056132,  1.063145,  1.065782,  1.064939,  1.067473,  1.072565,  1.078647,  1.071245,  1.082416,  1.083037,  1.086565,  1.086510,  1.092280,  1.093670,  1.096732,  1.095016,  1.102576,  1.107668,  1.103380,  1.106963,  1.114407,  1.118113,  1.110238,  1.121895,  1.123418,  1.127249,  1.125388,  1.132397,  1.135839,  1.133714,  1.135526,  1.141519,  1.150031,  1.139575,  1.149109,  1.154525,  1.158201,  1.149091,  1.162805,  1.163567,  1.167355,  1.163179,  1.173770,  1.177550,  1.172464,  1.174620,  1.180756,  1.192739,  1.175222,  1.191706,  1.195779,  1.197870,  1.189857,  1.203257,  1.202564,  1.207974,  1.202335,  1.214149,  1.219591,  1.210372,  1.215576,  1.221995,  1.232490,  1.213439,  1.232767,  1.233395,  1.240684,  1.230337,  1.242685,  1.244424,  1.244954,  1.239195,  1.255296,  1.260237,  1.251333,  1.252336,  1.262629,  1.278077, },
{ 1.000000,  1.002046,  1.005484,  1.007805,  1.010235,  1.012460,  1.015825,  1.018034,  1.020682,  1.021906,  1.026174,  1.029343,  1.029733,  1.032397,  1.036593,  1.039907,  1.038372,  1.043878,  1.046578,  1.049555,  1.050043,  1.054595,  1.057534,  1.058505,  1.059913,  1.064528,  1.069553,  1.066120,  1.070778,  1.075794,  1.079242,  1.075509,  1.083524,  1.085043,  1.088513,  1.086931,  1.094164,  1.097560,  1.095614,  1.097596,  1.102041,  1.110664,  1.101168,  1.111037,  1.114442,  1.118397,  1.112215,  1.122635,  1.123712,  1.126889,  1.125407,  1.132260,  1.138650,  1.131371,  1.135809,  1.141928,  1.148938,  1.137178,  1.150986,  1.152398,  1.158557,  1.150928,  1.160273,  1.162575,  1.164885,  1.160729,  1.172950,  1.177063,  1.171077,  1.173219,  1.178824,  1.192439,  1.170876,  1.191753,  1.190082,  1.197132,  1.189861,  1.199506,  1.200811,  1.203757,  1.198307,  1.210484,  1.217306,  1.208671,  1.209637,  1.221575,  1.229313,  1.207427,  1.229380,  1.230931,  1.234840,  1.227668,  1.240599,  1.241520,  1.239571,  1.236892,  1.245908,  1.259488,  1.239445,  1.251657, },
{ 1.000000,  1.002270,  1.005451,  1.007286,  1.010189,  1.012508,  1.015758,  1.017281,  1.020708,  1.023250,  1.025124,  1.027378,  1.030225,  1.034677,  1.033636,  1.038446,  1.041273,  1.044458,  1.043850,  1.049050,  1.050891,  1.054030,  1.054852,  1.058865,  1.063642,  1.061689,  1.064861,  1.069037,  1.073712,  1.068814,  1.077358,  1.080054,  1.084589,  1.080203,  1.087491,  1.089699,  1.091880,  1.091279,  1.098472,  1.102854,  1.099527,  1.102035,  1.106316,  1.116091,  1.103751,  1.116862,  1.117799,  1.122328,  1.119237,  1.126092,  1.127064,  1.130484,  1.128248,  1.136865,  1.141993,  1.137730,  1.138163,  1.146466,  1.155399,  1.138231,  1.155627,  1.157402,  1.160792,  1.156342,  1.166141,  1.167598,  1.166885,  1.166420,  1.172953,  1.182710,  1.170760,  1.177839,  1.187209,  1.192201,  1.178510,  1.194440,  1.192629,  1.198372,  1.193458,  1.204939,  1.209347,  1.202453,  1.203285,  1.211507,  1.224955,  1.203338,  1.219706,  1.225749,  1.228165,  1.216668,  1.232486,  1.233448,  1.235874,  1.230789,  1.241515,  1.252086,  1.237075,  1.241314,  1.249921,  1.263141, },
{ 1.000000,  1.002026,  1.005322,  1.007769,  1.010191,  1.011916,  1.015416,  1.017867,  1.020227,  1.021527,  1.025951,  1.028705,  1.029208,  1.032006,  1.035138,  1.039893,  1.037324,  1.043283,  1.045812,  1.049328,  1.048452,  1.053719,  1.055752,  1.058241,  1.058346,  1.063982,  1.068179,  1.066771,  1.067830,  1.074542,  1.079122,  1.071774,  1.082045,  1.084241,  1.087444,  1.086000,  1.091887,  1.094507,  1.095374,  1.095284,  1.100878,  1.108034,  1.100885,  1.106429,  1.113390,  1.117340,  1.109556,  1.120216,  1.121489,  1.124013,  1.123319,  1.130065,  1.134994,  1.131870,  1.132013,  1.137992,  1.148479,  1.135622,  1.146051,  1.150706,  1.154365,  1.146051,  1.158894,  1.160223,  1.161987,  1.159343,  1.168355,  1.175872,  1.166308,  1.170073,  1.175977,  1.187333,  1.169448,  1.186611,  1.189383,  1.194974,  1.182930,  1.195255,  1.197430,  1.200896,  1.194532,  1.207775,  1.213313,  1.203404,  1.207731,  1.213025,  1.228382,  1.204074,  1.225990,  1.225691,  1.232844,  1.223162,  1.232968,  1.235920,  1.237565,  1.231035,  1.245463,  1.253666,  1.242580,  1.241052, },
{ 1.000000,  1.002214,  1.005467,  1.006939,  1.009986,  1.012512,  1.015496,  1.017040,  1.020341,  1.022897,  1.025175,  1.026641,  1.029924,  1.034342,  1.033396,  1.036808,  1.040608,  1.044160,  1.042492,  1.048292,  1.050593,  1.053092,  1.053858,  1.058263,  1.062095,  1.061749,  1.063189,  1.067730,  1.073619,  1.068794,  1.075113,  1.078944,  1.082266,  1.078186,  1.086347,  1.089186,  1.090838,  1.089704,  1.097007,  1.101197,  1.097714,  1.099948,  1.105626,  1.112706,  1.102666,  1.114910,  1.116838,  1.120946,  1.114822,  1.124081,  1.126475,  1.128330,  1.126181,  1.135158,  1.139967,  1.133502,  1.137775,  1.142575,  1.152737,  1.136538,  1.152557,  1.154429,  1.159149,  1.153682,  1.160841,  1.165839,  1.165190,  1.160741,  1.173221,  1.178903,  1.170797,  1.172650,  1.182563,  1.192720,  1.168826,  1.193293,  1.191834,  1.196051,  1.190245,  1.201509,  1.201751,  1.203832,  1.198853,  1.209418,  1.219723,  1.203978,  1.210829,  1.221408,  1.228719,  1.208385,  1.229054,  1.230082,  1.233108,  1.227060,  1.239704,  1.244054,  1.236225,  1.235956,  1.245218,  1.259723, },
{ 1.000000,  1.002042,  1.005164,  1.007566,  1.010004,  1.011515,  1.015313,  1.017524,  1.019948,  1.021320,  1.025391,  1.028074,  1.028782,  1.031136,  1.034533,  1.039206,  1.036897,  1.042152,  1.045475,  1.048258,  1.047009,  1.052610,  1.054906,  1.057419,  1.057364,  1.063082,  1.067155,  1.064504,  1.067908,  1.071411,  1.078282,  1.071130,  1.080155,  1.082634,  1.086678,  1.084037,  1.088856,  1.093092,  1.093772,  1.092071,  1.101861,  1.104870,  1.101077,  1.103193,  1.109970,  1.117901,  1.103729,  1.119271,  1.119333,  1.123619,  1.120956,  1.128155,  1.129237,  1.131978,  1.128031,  1.137434,  1.144337,  1.135674,  1.140095,  1.148806,  1.154168,  1.140296,  1.156002,  1.157244,  1.160658,  1.156910,  1.165736,  1.169718,  1.165139,  1.166172,  1.173173,  1.183588,  1.168761,  1.180278,  1.185339,  1.191955,  1.176575,  1.193965,  1.194781,  1.197852,  1.191699,  1.203421,  1.209102,  1.200353,  1.202010,  1.209989,  1.224375,  1.200509,  1.220432,  1.224185,  1.228039,  1.215328,  1.231280,  1.230345,  1.235298,  1.227308,  1.241362,  1.248324,  1.234807,  1.240903, },
{ 1.000000,  1.002147,  1.005322,  1.006910,  1.009754,  1.012217,  1.015306,  1.016629,  1.019775,  1.022563,  1.024599,  1.025899,  1.030373,  1.033090,  1.033628,  1.035755,  1.039747,  1.044560,  1.040121,  1.048478,  1.049433,  1.052725,  1.053146,  1.057709,  1.059232,  1.061868,  1.061810,  1.067572,  1.071584,  1.069613,  1.072119,  1.077332,  1.082711,  1.075345,  1.085322,  1.086768,  1.090086,  1.089407,  1.095197,  1.098231,  1.097606,  1.098044,  1.104164,  1.110788,  1.102966,  1.109980,  1.115026,  1.119931,  1.111437,  1.123394,  1.123776,  1.127190,  1.123875,  1.133802,  1.136976,  1.132154,  1.134636,  1.140040,  1.150523,  1.135940,  1.149331,  1.152719,  1.157748,  1.147042,  1.160799,  1.161079,  1.163944,  1.161134,  1.170050,  1.177351,  1.165939,  1.171486,  1.178995,  1.187566,  1.169799,  1.188153,  1.189469,  1.196018,  1.184502,  1.196955,  1.199210,  1.199979,  1.194872,  1.209509,  1.213440,  1.204325,  1.207386,  1.214037,  1.230582,  1.200994,  1.228195,  1.224632,  1.232242,  1.222625,  1.234108,  1.235623,  1.237451,  1.230337,  1.245304,  1.253046, },
{ 1.000000,  1.002059,  1.004906,  1.007486,  1.009968,  1.011365,  1.015021,  1.017323,  1.019647,  1.021465,  1.024968,  1.027176,  1.029126,  1.030823,  1.034170,  1.038522,  1.037052,  1.041205,  1.045244,  1.048250,  1.045820,  1.053176,  1.053572,  1.057164,  1.056460,  1.062609,  1.065904,  1.064309,  1.066932,  1.071216,  1.077282,  1.071080,  1.079328,  1.081952,  1.085477,  1.081556,  1.089383,  1.091510,  1.093519,  1.093148,  1.098865,  1.105179,  1.098737,  1.103117,  1.108609,  1.114780,  1.103884,  1.117118,  1.119626,  1.124197,  1.116210,  1.126591,  1.128570,  1.128978,  1.128065,  1.137499,  1.142120,  1.135683,  1.138599,  1.143816,  1.156553,  1.136635,  1.155303,  1.156020,  1.159969,  1.154683,  1.164356,  1.163996,  1.166445,  1.163340,  1.174748,  1.179857,  1.172457,  1.173370,  1.183340,  1.194072,  1.169369,  1.193291,  1.194050,  1.196421,  1.190642,  1.202844,  1.204346,  1.201083,  1.200232,  1.208838,  1.219286,  1.202904,  1.212657,  1.222281,  1.228903,  1.209384,  1.230322,  1.227496,  1.231720,  1.226262,  1.240377,  1.244524,  1.233816,  1.236008, },
{ 1.000000,  1.002106,  1.005265,  1.006815,  1.009470,  1.012135,  1.014874,  1.016036,  1.019516,  1.022108,  1.024208,  1.025801,  1.029025,  1.032868,  1.032485,  1.035270,  1.038545,  1.043033,  1.039967,  1.046698,  1.049191,  1.052334,  1.050400,  1.055805,  1.058642,  1.060243,  1.060372,  1.067078,  1.069691,  1.067662,  1.070980,  1.074233,  1.081713,  1.072979,  1.083797,  1.085169,  1.089150,  1.085925,  1.093098,  1.094425,  1.096325,  1.095418,  1.102990,  1.107486,  1.103438,  1.105405,  1.112919,  1.118651,  1.105234,  1.121117,  1.121884,  1.124810,  1.121695,  1.130475,  1.131830,  1.130888,  1.131124,  1.138313,  1.145563,  1.134609,  1.142864,  1.149693,  1.155050,  1.143023,  1.157670,  1.157228,  1.158756,  1.158097,  1.166923,  1.171244,  1.165246,  1.166462,  1.173822,  1.184671,  1.167963,  1.181536,  1.185908,  1.189428,  1.177809,  1.194359,  1.194984,  1.194865,  1.192581,  1.203465,  1.210495,  1.197529,  1.203189,  1.209927,  1.222599,  1.198802,  1.221705,  1.222746,  1.228680,  1.213248,  1.228226,  1.230588,  1.232173,  1.225610,  1.241571,  1.246209, },
{ 1.000000,  1.001997,  1.004869,  1.007193,  1.009846,  1.010866,  1.014811,  1.016885,  1.019449,  1.020465,  1.024197,  1.026417,  1.028222,  1.029762,  1.034099,  1.037011,  1.037059,  1.038899,  1.043569,  1.047815,  1.042987,  1.051092,  1.053100,  1.055706,  1.055289,  1.060481,  1.062377,  1.064010,  1.064116,  1.070006,  1.074882,  1.069845,  1.074916,  1.079896,  1.084066,  1.078020,  1.087151,  1.088869,  1.090669,  1.090750,  1.096793,  1.100688,  1.097882,  1.099334,  1.104694,  1.112252,  1.103237,  1.112222,  1.115217,  1.119669,  1.112258,  1.123351,  1.125505,  1.126334,  1.124375,  1.133652,  1.137332,  1.131240,  1.134731,  1.140622,  1.149419,  1.134792,  1.150534,  1.151451,  1.156785,  1.147324,  1.158809,  1.161138,  1.161523,  1.159880,  1.170171,  1.173925,  1.165382,  1.170797,  1.175809,  1.188235,  1.165785,  1.186800,  1.187418,  1.191958,  1.184990,  1.193955,  1.198090,  1.196233,  1.191358,  1.206537,  1.211309,  1.200613,  1.203840,  1.214348,  1.226258,  1.195628,  1.226073,  1.222937,  1.226579,  1.219707,  1.233452,  1.232102,  1.232236,  1.228055, },
{ 1.000000,  1.002093,  1.005103,  1.006801,  1.009058,  1.011827,  1.014876,  1.015348,  1.019216,  1.021693,  1.023774,  1.025308,  1.028683,  1.031692,  1.032242,  1.034310,  1.037854,  1.042082,  1.040165,  1.045158,  1.047594,  1.051384,  1.048638,  1.055307,  1.057352,  1.059219,  1.059650,  1.065561,  1.068147,  1.066404,  1.068945,  1.072978,  1.079739,  1.072415,  1.081748,  1.084301,  1.087127,  1.083192,  1.090861,  1.092948,  1.094587,  1.093637,  1.101636,  1.105729,  1.099495,  1.105374,  1.107986,  1.117021,  1.104206,  1.118125,  1.119063,  1.123589,  1.119230,  1.126013,  1.129502,  1.128300,  1.126684,  1.138982,  1.140687,  1.134531,  1.137843,  1.145594,  1.155274,  1.135053,  1.156060,  1.154031,  1.158135,  1.154815,  1.164229,  1.163532,  1.165508,  1.161126,  1.172974,  1.178932,  1.167556,  1.173664,  1.182415,  1.189652,  1.170153,  1.190852,  1.190577,  1.193067,  1.189286,  1.199819,  1.203036,  1.195738,  1.197654,  1.206850,  1.217024,  1.198427,  1.213155,  1.217105,  1.225035,  1.205507,  1.226519,  1.226788,  1.227870,  1.222006,  1.236109,  1.240834, },
{ 1.000000,  1.001967,  1.004724,  1.007091,  1.009599,  1.010716,  1.014396,  1.016711,  1.019042,  1.020226,  1.023941,  1.025791,  1.028419,  1.029592,  1.033579,  1.036144,  1.036120,  1.039373,  1.042223,  1.046727,  1.043337,  1.050298,  1.052118,  1.055443,  1.054241,  1.059312,  1.061948,  1.062684,  1.063089,  1.070109,  1.072364,  1.070582,  1.073471,  1.078100,  1.084872,  1.073841,  1.087696,  1.087118,  1.090521,  1.089549,  1.096005,  1.096329,  1.098505,  1.097307,  1.105266,  1.109433,  1.104199,  1.107984,  1.113807,  1.120271,  1.107972,  1.122281,  1.123124,  1.125479,  1.124006,  1.131611,  1.134497,  1.131020,  1.132083,  1.140084,  1.146356,  1.135517,  1.145133,  1.149612,  1.155469,  1.143245,  1.158408,  1.158222,  1.160293,  1.156402,  1.169315,  1.171318,  1.163591,  1.167569,  1.173406,  1.185115,  1.165961,  1.183082,  1.185924,  1.190934,  1.177216,  1.194340,  1.194145,  1.194546,  1.192587,  1.203627,  1.210202,  1.194586,  1.202910,  1.211062,  1.219894,  1.197479,  1.220931,  1.220332,  1.227229,  1.213331,  1.228350,  1.229882,  1.228253,  1.224290, },
{ 1.000000,  1.002091,  1.004918,  1.006786,  1.008833,  1.011777,  1.014888,  1.014694,  1.019027,  1.021020,  1.023653,  1.024689,  1.028402,  1.030399,  1.032183,  1.033772,  1.038031,  1.040688,  1.040322,  1.043176,  1.047146,  1.051067,  1.046630,  1.054595,  1.056463,  1.058656,  1.058904,  1.064266,  1.066368,  1.066265,  1.067499,  1.072324,  1.077807,  1.072263,  1.078532,  1.083012,  1.086742,  1.080410,  1.091221,  1.090162,  1.093910,  1.091587,  1.100377,  1.103293,  1.098649,  1.102382,  1.107411,  1.114745,  1.104168,  1.115317,  1.117888,  1.121677,  1.114465,  1.125299,  1.126306,  1.127090,  1.127382,  1.134463,  1.140770,  1.130822,  1.136764,  1.142975,  1.150068,  1.134440,  1.151532,  1.153723,  1.158544,  1.147351,  1.160740,  1.162201,  1.160512,  1.160119,  1.171919,  1.175445,  1.166189,  1.170596,  1.176177,  1.190081,  1.165145,  1.188488,  1.187459,  1.191602,  1.185334,  1.196292,  1.195464,  1.195840,  1.193971,  1.207313,  1.210900,  1.201699,  1.203009,  1.214072,  1.226570,  1.194923,  1.224441,  1.224537,  1.224853,  1.219356,  1.233824,  1.234030, },
{ 1.000000,  1.001955,  1.004614,  1.006998,  1.009249,  1.010733,  1.013728,  1.016316,  1.018933,  1.019499,  1.023526,  1.025129,  1.027111,  1.029093,  1.033035,  1.035268,  1.035493,  1.038101,  1.041592,  1.045562,  1.042825,  1.048601,  1.051271,  1.053393,  1.052234,  1.058399,  1.059947,  1.061538,  1.062569,  1.067845,  1.071379,  1.067758,  1.071911,  1.076034,  1.081426,  1.073629,  1.084536,  1.085952,  1.089763,  1.084958,  1.092702,  1.095143,  1.095372,  1.095139,  1.104125,  1.106237,  1.101425,  1.106014,  1.109259,  1.118699,  1.104463,  1.120100,  1.120121,  1.124188,  1.119350,  1.128578,  1.128724,  1.129254,  1.128572,  1.138291,  1.141820,  1.135809,  1.138047,  1.147147,  1.153666,  1.134816,  1.155423,  1.155333,  1.157359,  1.153722,  1.164315,  1.164763,  1.161779,  1.162593,  1.171497,  1.178415,  1.164332,  1.174749,  1.181596,  1.187623,  1.172195,  1.189943,  1.188500,  1.188486,  1.188537,  1.199465,  1.202913,  1.193856,  1.196395,  1.205103,  1.215730,  1.196273,  1.211973,  1.215670,  1.219901,  1.205485,  1.225115,  1.224354,  1.222100,  1.220895, },
{ 1.000000,  1.002591,  1.004868,  1.006882,  1.009599,  1.012171,  1.015249,  1.015841,  1.019817,  1.022164,  1.024665,  1.025441,  1.029584,  1.031465,  1.033743,  1.035202,  1.039893,  1.042467,  1.042038,  1.045370,  1.048270,  1.053824,  1.048909,  1.057385,  1.058383,  1.061572,  1.061193,  1.066338,  1.068220,  1.069609,  1.070357,  1.076894,  1.079937,  1.077713,  1.080262,  1.086405,  1.091984,  1.081251,  1.094497,  1.095590,  1.098319,  1.096263,  1.104395,  1.104932,  1.105163,  1.105496,  1.113501,  1.118515,  1.110209,  1.117575,  1.122675,  1.128143,  1.118072,  1.131411,  1.131997,  1.132217,  1.132943,  1.141474,  1.144511,  1.138838,  1.141503,  1.148878,  1.156683,  1.144497,  1.156237,  1.159207,  1.164092,  1.153042,  1.168527,  1.169793,  1.168542,  1.167152,  1.179463,  1.182468,  1.172349,  1.177987,  1.185796,  1.194625,  1.175038,  1.196205,  1.196234,  1.201102,  1.189753,  1.203955,  1.205599,  1.204403,  1.202812,  1.217025,  1.219321,  1.206647,  1.215275,  1.221243,  1.234782,  1.205945,  1.233194,  1.232375,  1.236927,  1.228910,  1.240104,  1.243124, },
{ 1.000000,  1.001930,  1.004465,  1.006977,  1.009544,  1.011057,  1.013254,  1.016324,  1.019235,  1.018646,  1.023885,  1.025195,  1.027725,  1.029082,  1.033247,  1.034436,  1.036294,  1.038005,  1.041819,  1.045324,  1.043802,  1.047225,  1.051206,  1.054693,  1.051251,  1.058763,  1.060147,  1.061908,  1.062817,  1.068150,  1.070625,  1.068679,  1.071430,  1.076545,  1.080852,  1.076099,  1.083391,  1.085209,  1.089973,  1.083848,  1.093981,  1.094598,  1.096105,  1.096190,  1.103841,  1.106005,  1.101494,  1.105513,  1.110044,  1.117409,  1.106932,  1.118878,  1.121451,  1.123980,  1.118179,  1.128125,  1.128897,  1.130319,  1.129100,  1.139049,  1.142737,  1.133565,  1.141155,  1.143778,  1.154235,  1.137311,  1.154566,  1.154874,  1.159455,  1.153764,  1.162270,  1.164884,  1.162707,  1.160884,  1.175728,  1.175857,  1.168363,  1.171860,  1.181234,  1.191557,  1.166385,  1.192076,  1.188126,  1.192412,  1.188885,  1.200342,  1.197698,  1.198377,  1.194383,  1.208600,  1.212988,  1.200261,  1.207064,  1.216817,  1.223482,  1.201319,  1.225870,  1.223702,  1.225042,  1.222656, },
{ 1.000000,  1.001987,  1.004678,  1.006492,  1.008433,  1.011439,  1.013907,  1.014735,  1.018100,  1.020306,  1.022929,  1.023201,  1.027467,  1.029201,  1.031350,  1.032614,  1.036666,  1.039159,  1.038830,  1.041995,  1.045178,  1.049234,  1.046184,  1.052512,  1.054839,  1.057333,  1.055701,  1.062065,  1.062964,  1.064822,  1.065287,  1.071900,  1.073804,  1.070836,  1.075741,  1.079085,  1.083777,  1.076843,  1.087429,  1.087842,  1.091880,  1.089065,  1.095876,  1.097461,  1.097110,  1.097422,  1.106456,  1.107423,  1.104215,  1.107570,  1.113265,  1.120939,  1.105197,  1.123561,  1.121252,  1.124825,  1.123162,  1.131449,  1.129921,  1.131094,  1.130018,  1.140462,  1.142708,  1.137254,  1.140699,  1.147592,  1.154325,  1.138402,  1.156604,  1.156027,  1.157020,  1.156815,  1.165888,  1.166484,  1.161683,  1.164122,  1.172791,  1.178044,  1.166847,  1.176597,  1.181352,  1.187569,  1.173543,  1.190664,  1.189339,  1.190392,  1.186477,  1.202300,  1.202237,  1.192211,  1.198328,  1.205023,  1.215768,  1.194776,  1.213655,  1.216577,  1.220554,  1.206007,  1.225376,  1.222982, },
{ 1.000000,  1.001896,  1.004447,  1.006821,  1.009374,  1.010591,  1.013108,  1.015921,  1.018377,  1.018732,  1.023059,  1.025111,  1.027570,  1.028063,  1.032169,  1.033588,  1.035648,  1.037043,  1.041588,  1.043412,  1.043547,  1.046477,  1.049464,  1.054792,  1.049026,  1.058033,  1.058291,  1.061570,  1.061736,  1.066306,  1.067371,  1.069092,  1.069425,  1.076389,  1.078051,  1.076789,  1.079280,  1.084332,  1.089434,  1.079932,  1.092372,  1.093187,  1.094314,  1.094479,  1.101897,  1.102452,  1.100900,  1.103095,  1.108849,  1.113638,  1.107001,  1.114086,  1.118716,  1.123166,  1.113637,  1.127603,  1.124696,  1.128792,  1.125882,  1.137183,  1.138499,  1.131698,  1.137292,  1.142741,  1.150633,  1.136920,  1.150048,  1.152926,  1.155708,  1.147734,  1.160643,  1.160375,  1.160087,  1.161127,  1.170019,  1.174828,  1.162594,  1.170708,  1.177085,  1.183483,  1.165912,  1.186495,  1.186592,  1.192645,  1.179733,  1.194644,  1.194571,  1.192274,  1.192730,  1.206670,  1.206927,  1.197641,  1.202840,  1.209068,  1.223376,  1.195025,  1.222282,  1.218814,  1.223145,  1.217642, },
{ 1.000000,  1.001939,  1.004431,  1.006453,  1.008706,  1.011347,  1.013639,  1.015181,  1.017068,  1.020193,  1.023411,  1.022238,  1.027323,  1.029075,  1.031185,  1.032381,  1.036668,  1.038071,  1.039169,  1.041237,  1.044742,  1.047772,  1.046641,  1.050623,  1.053935,  1.057705,  1.054269,  1.061511,  1.061918,  1.063723,  1.065249,  1.071139,  1.072810,  1.070393,  1.073870,  1.078656,  1.083202,  1.077249,  1.085031,  1.087839,  1.089882,  1.086647,  1.095487,  1.095590,  1.096627,  1.097633,  1.104578,  1.107953,  1.101226,  1.106989,  1.112116,  1.117397,  1.106327,  1.120777,  1.121299,  1.125199,  1.118883,  1.128485,  1.129314,  1.129501,  1.128702,  1.140734,  1.139822,  1.135174,  1.140480,  1.143014,  1.153927,  1.136170,  1.155963,  1.153257,  1.158671,  1.153019,  1.163226,  1.161237,  1.162146,  1.162055,  1.173158,  1.174425,  1.169478,  1.170196,  1.181053,  1.187682,  1.165272,  1.189643,  1.187892,  1.189666,  1.187034,  1.198397,  1.196524,  1.193568,  1.194725,  1.204360,  1.209806,  1.196721,  1.206572,  1.213499,  1.220382,  1.202814,  1.223110,  1.219536, },
{ 1.000000,  1.001836,  1.004340,  1.006644,  1.008482,  1.010215,  1.012616,  1.015065,  1.017626,  1.017873,  1.021496,  1.023663,  1.025682,  1.026112,  1.030725,  1.031984,  1.033388,  1.035070,  1.039557,  1.041555,  1.040282,  1.043933,  1.047253,  1.050597,  1.047281,  1.054360,  1.055883,  1.058764,  1.056593,  1.062517,  1.063630,  1.065340,  1.065841,  1.072459,  1.073493,  1.071535,  1.075611,  1.078328,  1.084682,  1.076172,  1.087728,  1.086837,  1.090612,  1.089181,  1.095154,  1.095130,  1.096317,  1.096968,  1.104495,  1.105865,  1.103709,  1.105572,  1.111991,  1.118374,  1.103751,  1.120566,  1.119262,  1.121840,  1.120400,  1.128976,  1.126617,  1.127958,  1.127896,  1.136386,  1.139716,  1.131771,  1.138794,  1.143620,  1.148846,  1.137423,  1.152976,  1.150672,  1.150589,  1.152912,  1.161599,  1.161989,  1.156346,  1.159745,  1.167136,  1.173440,  1.161774,  1.173582,  1.175044,  1.179664,  1.168630,  1.185405,  1.183980,  1.182288,  1.181925,  1.195796,  1.195079,  1.185353,  1.192081,  1.199273,  1.206136,  1.187647,  1.209528,  1.207188,  1.212232,  1.200978, },
{ 1.000000,  1.001889,  1.004339,  1.006288,  1.008540,  1.011109,  1.013261,  1.014503,  1.017434,  1.019508,  1.022833,  1.021911,  1.027071,  1.028364,  1.030790,  1.031938,  1.035321,  1.037090,  1.038434,  1.040114,  1.044833,  1.046441,  1.046466,  1.049301,  1.052918,  1.057077,  1.050859,  1.061014,  1.061058,  1.063107,  1.063965,  1.069771,  1.069224,  1.070819,  1.072537,  1.077765,  1.080305,  1.077228,  1.081697,  1.085704,  1.089997,  1.082826,  1.094323,  1.093966,  1.094690,  1.096507,  1.103522,  1.103676,  1.100875,  1.104311,  1.110065,  1.114263,  1.107952,  1.116759,  1.117102,  1.122903,  1.114610,  1.127746,  1.126063,  1.127106,  1.128093,  1.137713,  1.137187,  1.131955,  1.136606,  1.141810,  1.149293,  1.136421,  1.151169,  1.152094,  1.154789,  1.148229,  1.160084,  1.157823,  1.159965,  1.158882,  1.171143,  1.171930,  1.162135,  1.170891,  1.173769,  1.184336,  1.163989,  1.185820,  1.182754,  1.188750,  1.182844,  1.192572,  1.191867,  1.189847,  1.188698,  1.206418,  1.201799,  1.196011,  1.200041,  1.209371,  1.220171,  1.191228,  1.221753,  1.214378, },
{ 1.000000,  1.002330,  1.004240,  1.006855,  1.008533,  1.011000,  1.012494,  1.015651,  1.018058,  1.018993,  1.021751,  1.024314,  1.027264,  1.026069,  1.031893,  1.033134,  1.034777,  1.036938,  1.040623,  1.042117,  1.042180,  1.045236,  1.048706,  1.051950,  1.050360,  1.055160,  1.057252,  1.060835,  1.057726,  1.065323,  1.065767,  1.067601,  1.068498,  1.075082,  1.075630,  1.073564,  1.077499,  1.081867,  1.086852,  1.079735,  1.089740,  1.090975,  1.093777,  1.090074,  1.099690,  1.097534,  1.100172,  1.100550,  1.109005,  1.109226,  1.104868,  1.111151,  1.114464,  1.120446,  1.109279,  1.124075,  1.122602,  1.127630,  1.123447,  1.132411,  1.131043,  1.131432,  1.131942,  1.143222,  1.141084,  1.138748,  1.141965,  1.148319,  1.158062,  1.135806,  1.160826,  1.154289,  1.159324,  1.157116,  1.167622,  1.162602,  1.164608,  1.163710,  1.176094,  1.175977,  1.170462,  1.175074,  1.181123,  1.189179,  1.169265,  1.192544,  1.188722,  1.189893,  1.190904,  1.201200,  1.198503,  1.193539,  1.197788,  1.207236,  1.210347,  1.199566,  1.210343,  1.213584,  1.221486,  1.204759, },
{ 1.000000,  1.002369,  1.004234,  1.006498,  1.008262,  1.011460,  1.012940,  1.014412,  1.016977,  1.019600,  1.022069,  1.022226,  1.026499,  1.028245,  1.031064,  1.030654,  1.035694,  1.036359,  1.038496,  1.040025,  1.044779,  1.046259,  1.045038,  1.049470,  1.052455,  1.055665,  1.051899,  1.060116,  1.060230,  1.064353,  1.062379,  1.068649,  1.068317,  1.070109,  1.071521,  1.078859,  1.078310,  1.077664,  1.080930,  1.084367,  1.091235,  1.080034,  1.094594,  1.092048,  1.095990,  1.095399,  1.101938,  1.100622,  1.102025,  1.102926,  1.111291,  1.111418,  1.109362,  1.112571,  1.118272,  1.124257,  1.110013,  1.126959,  1.126114,  1.127033,  1.127114,  1.136544,  1.134252,  1.132004,  1.135507,  1.142216,  1.146030,  1.138404,  1.146875,  1.150801,  1.155990,  1.143897,  1.161601,  1.155080,  1.159627,  1.157045,  1.171033,  1.169286,  1.161208,  1.168973,  1.174664,  1.181887,  1.166569,  1.182034,  1.183042,  1.186858,  1.177211,  1.193342,  1.188977,  1.189757,  1.191323,  1.202338,  1.204312,  1.190760,  1.200767,  1.207423,  1.212811,  1.193619,  1.217574,  1.214763, },
{ 1.000000,  1.002338,  1.004009,  1.006638,  1.008665,  1.010593,  1.012809,  1.015998,  1.017452,  1.018951,  1.021455,  1.023903,  1.027606,  1.025446,  1.031497,  1.032474,  1.034897,  1.036422,  1.040497,  1.040227,  1.042532,  1.044856,  1.049304,  1.050240,  1.051429,  1.052846,  1.056962,  1.061997,  1.054670,  1.065343,  1.065913,  1.067034,  1.068446,  1.074522,  1.073840,  1.073902,  1.077020,  1.081403,  1.083859,  1.081476,  1.086412,  1.090116,  1.094118,  1.087959,  1.099076,  1.096241,  1.098745,  1.100314,  1.108445,  1.108030,  1.103747,  1.109197,  1.114369,  1.119496,  1.110308,  1.121082,  1.123287,  1.124860,  1.120625,  1.131666,  1.129488,  1.130358,  1.132186,  1.141425,  1.142456,  1.134082,  1.141595,  1.147517,  1.151916,  1.138343,  1.157115,  1.154857,  1.160606,  1.152418,  1.164128,  1.161851,  1.162850,  1.162377,  1.177519,  1.172918,  1.168203,  1.174416,  1.176621,  1.189199,  1.166882,  1.191506,  1.186015,  1.192407,  1.186344,  1.199160,  1.192720,  1.194059,  1.195992,  1.208364,  1.206161,  1.202340,  1.203468,  1.214690,  1.221900,  1.194550, },
{ 1.000000,  1.002311,  1.004152,  1.006352,  1.008173,  1.011030,  1.012846,  1.014235,  1.016776,  1.019559,  1.021553,  1.022584,  1.025120,  1.027790,  1.030816,  1.030076,  1.035255,  1.035655,  1.037427,  1.040092,  1.044007,  1.045340,  1.045196,  1.048199,  1.051572,  1.054775,  1.052785,  1.058071,  1.059655,  1.062424,  1.060757,  1.068156,  1.067846,  1.068358,  1.071197,  1.077168,  1.078191,  1.074913,  1.079947,  1.083784,  1.087650,  1.081269,  1.092372,  1.091583,  1.095501,  1.092050,  1.099749,  1.098727,  1.100457,  1.101440,  1.111223,  1.109075,  1.106383,  1.112144,  1.114583,  1.122259,  1.109240,  1.125599,  1.122987,  1.126571,  1.125616,  1.132737,  1.129816,  1.131359,  1.133238,  1.142612,  1.141796,  1.139033,  1.141590,  1.148948,  1.155802,  1.136867,  1.158811,  1.155500,  1.157347,  1.156787,  1.167468,  1.161639,  1.162583,  1.164856,  1.174056,  1.176336,  1.167088,  1.174815,  1.180148,  1.185937,  1.171592,  1.191584,  1.186090,  1.185458,  1.190009,  1.199843,  1.197353,  1.190644,  1.196636,  1.203920,  1.210152,  1.197648,  1.210647,  1.210756, },
{ 1.000000,  1.002228,  1.004329,  1.006968,  1.008951,  1.010884,  1.013227,  1.016360,  1.018119,  1.019326,  1.022114,  1.024840,  1.027558,  1.027308,  1.032256,  1.033532,  1.036561,  1.036680,  1.041378,  1.042111,  1.044027,  1.046251,  1.051280,  1.052000,  1.051755,  1.055395,  1.058417,  1.063185,  1.057385,  1.066787,  1.067029,  1.070073,  1.070134,  1.074832,  1.075510,  1.076279,  1.077628,  1.085556,  1.085343,  1.084322,  1.087165,  1.092903,  1.098091,  1.086043,  1.102619,  1.100226,  1.101954,  1.103070,  1.111213,  1.107909,  1.109424,  1.111854,  1.118912,  1.120160,  1.115813,  1.121454,  1.125907,  1.130947,  1.120392,  1.136624,  1.133787,  1.133725,  1.137189,  1.146037,  1.143830,  1.139325,  1.144530,  1.151590,  1.155638,  1.147838,  1.158599,  1.157053,  1.164483,  1.154164,  1.171078,  1.166413,  1.166755,  1.169451,  1.181539,  1.178316,  1.171372,  1.177824,  1.183214,  1.192097,  1.176286,  1.193579,  1.193280,  1.197006,  1.189325,  1.203593,  1.198228,  1.200704,  1.200709,  1.215941,  1.214051,  1.202195,  1.212670,  1.215863,  1.227840,  1.203132, },
{ 1.000000,  1.002218,  1.004468,  1.007044,  1.008969,  1.011501,  1.013570,  1.015803,  1.017802,  1.021526,  1.022898,  1.024576,  1.026814,  1.030092,  1.033652,  1.030944,  1.038301,  1.038693,  1.041135,  1.043087,  1.047577,  1.047365,  1.049722,  1.050968,  1.056869,  1.057997,  1.057687,  1.060934,  1.064674,  1.068529,  1.063526,  1.073591,  1.073063,  1.074694,  1.077596,  1.082797,  1.082730,  1.081135,  1.086034,  1.090775,  1.093522,  1.089960,  1.096950,  1.098322,  1.102920,  1.097242,  1.108999,  1.107566,  1.108011,  1.110076,  1.118644,  1.118445,  1.113422,  1.119383,  1.124566,  1.130422,  1.120406,  1.133064,  1.133761,  1.136929,  1.132389,  1.144773,  1.139187,  1.142382,  1.143402,  1.155096,  1.152749,  1.147072,  1.154496,  1.159188,  1.165276,  1.150189,  1.169557,  1.166879,  1.172097,  1.167909,  1.178683,  1.175119,  1.174508,  1.176070,  1.190287,  1.185582,  1.183105,  1.185783,  1.194013,  1.205466,  1.177375,  1.208907,  1.199470,  1.203758,  1.204467,  1.215267,  1.206912,  1.209346,  1.209252,  1.224869,  1.221522,  1.216727,  1.220533,  1.228288, },
{ 1.000000,  1.002214,  1.004067,  1.006282,  1.008198,  1.010339,  1.012571,  1.014919,  1.016766,  1.018116,  1.020647,  1.023486,  1.025283,  1.026133,  1.029037,  1.031441,  1.034368,  1.033642,  1.038913,  1.039596,  1.041189,  1.042750,  1.047980,  1.048584,  1.047784,  1.051804,  1.054549,  1.058306,  1.055324,  1.061532,  1.062719,  1.065809,  1.063964,  1.071297,  1.070294,  1.071618,  1.074221,  1.080314,  1.081197,  1.077365,  1.082322,  1.086886,  1.090209,  1.083521,  1.093883,  1.093804,  1.097979,  1.095321,  1.103013,  1.101021,  1.102292,  1.104148,  1.113748,  1.110303,  1.110078,  1.112448,  1.117235,  1.125610,  1.109948,  1.128129,  1.124439,  1.127674,  1.128178,  1.134654,  1.132026,  1.133388,  1.134650,  1.144527,  1.142912,  1.141154,  1.143436,  1.149824,  1.156898,  1.138866,  1.159522,  1.158028,  1.156663,  1.158957,  1.168998,  1.165391,  1.161686,  1.166240,  1.173138,  1.177069,  1.169096,  1.176390,  1.181085,  1.186906,  1.173504,  1.193573,  1.184482,  1.187841,  1.187495,  1.202522,  1.199317,  1.188641,  1.198897,  1.204658,  1.212575,  1.195672, },
{ 1.000000,  1.002112,  1.004356,  1.006540,  1.008176,  1.010936,  1.012762,  1.014637,  1.016891,  1.019412,  1.021476,  1.021900,  1.024929,  1.027625,  1.030169,  1.029350,  1.034481,  1.036018,  1.039042,  1.038446,  1.043420,  1.044128,  1.045242,  1.047837,  1.053082,  1.053351,  1.053457,  1.055651,  1.058947,  1.064575,  1.057953,  1.067591,  1.067431,  1.069862,  1.071349,  1.076175,  1.074631,  1.076748,  1.079089,  1.085290,  1.085300,  1.085504,  1.086172,  1.091463,  1.098163,  1.085527,  1.100277,  1.100518,  1.100172,  1.102589,  1.109216,  1.107809,  1.106210,  1.110932,  1.115726,  1.117905,  1.114768,  1.118984,  1.123619,  1.129027,  1.120062,  1.133211,  1.129083,  1.130478,  1.133577,  1.142644,  1.141639,  1.134547,  1.141632,  1.147462,  1.153546,  1.141837,  1.153340,  1.155626,  1.157591,  1.152608,  1.165418,  1.161985,  1.160886,  1.164657,  1.174953,  1.175184,  1.164863,  1.172454,  1.179353,  1.184824,  1.168751,  1.188577,  1.186417,  1.192900,  1.183564,  1.196261,  1.193470,  1.192700,  1.193217,  1.210655,  1.203584,  1.199324,  1.203858,  1.206897, },
{ 1.000000,  1.002166,  1.003926,  1.006067,  1.007936,  1.010248,  1.012000,  1.014342,  1.015982,  1.017857,  1.019948,  1.022539,  1.024375,  1.025760,  1.027319,  1.030699,  1.033663,  1.030984,  1.037597,  1.038921,  1.039829,  1.042081,  1.045749,  1.046402,  1.047035,  1.049749,  1.053291,  1.055597,  1.054350,  1.057426,  1.060893,  1.064698,  1.061229,  1.068597,  1.068202,  1.068916,  1.072505,  1.077017,  1.077876,  1.075603,  1.079501,  1.083351,  1.087516,  1.083041,  1.088870,  1.090793,  1.093927,  1.090657,  1.100053,  1.098691,  1.097822,  1.101609,  1.108639,  1.109455,  1.103825,  1.109113,  1.114007,  1.118533,  1.109384,  1.121918,  1.121275,  1.126125,  1.120459,  1.129653,  1.128007,  1.128927,  1.129833,  1.141338,  1.138227,  1.134707,  1.139677,  1.142514,  1.152284,  1.135831,  1.154054,  1.150928,  1.154193,  1.153883,  1.160563,  1.157800,  1.157931,  1.160091,  1.170415,  1.169541,  1.166005,  1.166607,  1.176160,  1.184698,  1.160397,  1.185380,  1.182547,  1.182979,  1.183193,  1.193234,  1.187928,  1.187880,  1.190145,  1.199985,  1.202390,  1.192769, },
{ 1.000000,  1.001982,  1.004205,  1.005959,  1.007310,  1.010294,  1.011935,  1.013349,  1.015837,  1.018429,  1.020167,  1.020703,  1.023194,  1.025942,  1.028506,  1.028559,  1.031683,  1.033460,  1.036595,  1.035537,  1.040652,  1.041721,  1.042485,  1.044439,  1.049508,  1.050273,  1.049307,  1.052553,  1.055701,  1.058985,  1.055805,  1.062862,  1.063009,  1.066678,  1.064903,  1.071141,  1.070506,  1.071637,  1.073916,  1.080417,  1.079774,  1.078443,  1.081518,  1.085217,  1.090983,  1.081442,  1.092985,  1.093123,  1.095822,  1.095745,  1.100203,  1.100975,  1.100730,  1.101236,  1.110566,  1.109980,  1.108023,  1.109358,  1.116347,  1.122905,  1.106425,  1.125359,  1.122896,  1.123584,  1.124990,  1.132682,  1.129115,  1.130124,  1.132087,  1.139501,  1.140822,  1.135981,  1.139722,  1.145427,  1.151317,  1.137616,  1.155529,  1.152643,  1.150920,  1.155195,  1.164118,  1.161787,  1.155535,  1.160466,  1.168128,  1.172188,  1.164243,  1.173457,  1.171285,  1.181325,  1.168016,  1.185869,  1.181104,  1.180077,  1.183082,  1.195240,  1.192309,  1.184276,  1.189732,  1.195667, },
{ 1.000000,  1.002058,  1.003892,  1.006168,  1.007648,  1.009955,  1.011329,  1.014028,  1.015493,  1.017580,  1.019060,  1.022384,  1.024157,  1.024612,  1.027175,  1.029417,  1.033172,  1.030649,  1.035957,  1.037244,  1.039916,  1.040764,  1.044062,  1.045146,  1.046008,  1.047503,  1.053569,  1.053284,  1.053856,  1.055465,  1.059514,  1.064296,  1.057072,  1.067292,  1.066565,  1.068730,  1.070420,  1.074964,  1.073677,  1.076147,  1.076165,  1.083153,  1.083664,  1.082329,  1.084647,  1.089170,  1.093883,  1.085456,  1.097756,  1.096719,  1.096785,  1.099686,  1.105389,  1.104758,  1.102026,  1.106522,  1.111708,  1.114395,  1.110299,  1.116481,  1.117204,  1.123772,  1.115479,  1.127639,  1.125391,  1.125580,  1.127567,  1.136512,  1.135881,  1.129899,  1.134674,  1.140712,  1.146904,  1.135725,  1.147841,  1.148397,  1.152106,  1.146084,  1.158851,  1.152444,  1.155768,  1.155713,  1.167883,  1.165182,  1.159319,  1.164508,  1.170177,  1.177220,  1.160388,  1.178773,  1.176657,  1.182040,  1.177271,  1.187739,  1.183825,  1.182565,  1.183574,  1.198125,  1.192931,  1.191210, },
{ 1.000000,  1.001879,  1.004059,  1.006331,  1.007116,  1.010015,  1.011389,  1.013464,  1.015336,  1.018008,  1.019080,  1.021153,  1.022657,  1.026270,  1.027478,  1.028620,  1.030312,  1.033118,  1.036495,  1.034137,  1.040243,  1.040970,  1.042443,  1.044835,  1.048476,  1.048542,  1.048734,  1.051501,  1.055370,  1.057152,  1.057024,  1.059864,  1.061947,  1.066409,  1.062758,  1.070116,  1.069584,  1.070933,  1.072205,  1.079535,  1.078992,  1.076400,  1.080299,  1.084403,  1.088683,  1.082864,  1.090372,  1.091547,  1.095615,  1.091274,  1.100645,  1.098010,  1.099437,  1.101515,  1.108880,  1.109023,  1.104601,  1.108662,  1.114338,  1.118445,  1.108567,  1.121063,  1.120639,  1.125554,  1.120896,  1.129634,  1.126859,  1.128284,  1.128896,  1.140630,  1.136068,  1.136440,  1.136195,  1.142306,  1.152409,  1.132107,  1.153352,  1.148607,  1.152052,  1.152837,  1.159341,  1.155776,  1.157407,  1.156702,  1.168927,  1.166056,  1.165003,  1.164969,  1.172670,  1.182119,  1.159404,  1.182353,  1.180467,  1.179007,  1.180489,  1.191554,  1.187122,  1.183145,  1.187078,  1.194947, },
{ 1.000000,  1.001943,  1.003880,  1.005824,  1.007383,  1.009792,  1.010697,  1.013751,  1.014840,  1.017100,  1.018379,  1.021613,  1.023214,  1.023699,  1.026257,  1.028786,  1.031436,  1.030648,  1.034263,  1.036049,  1.038857,  1.038293,  1.042932,  1.043082,  1.044755,  1.047085,  1.050865,  1.052655,  1.050916,  1.053730,  1.057452,  1.060409,  1.056704,  1.063793,  1.064393,  1.068755,  1.065538,  1.072021,  1.071599,  1.072507,  1.074133,  1.081087,  1.080124,  1.080392,  1.080779,  1.085354,  1.092462,  1.081134,  1.093636,  1.092599,  1.095131,  1.096095,  1.101291,  1.098213,  1.101202,  1.101976,  1.109866,  1.108636,  1.109802,  1.107836,  1.114112,  1.123059,  1.105809,  1.122915,  1.123213,  1.122209,  1.124024,  1.131215,  1.128833,  1.127595,  1.131232,  1.136576,  1.137632,  1.135869,  1.137957,  1.142595,  1.150409,  1.137855,  1.152696,  1.147351,  1.149986,  1.151616,  1.161809,  1.159923,  1.152490,  1.157781,  1.164841,  1.171670,  1.159193,  1.169459,  1.171278,  1.174779,  1.168113,  1.181286,  1.176844,  1.176992,  1.179269,  1.190132,  1.190110,  1.180556, },
{ 1.000000,  1.001827,  1.003956,  1.005987,  1.006749,  1.009500,  1.011119,  1.013508,  1.014391,  1.017279,  1.018406,  1.020183,  1.021744,  1.025591,  1.026277,  1.027715,  1.029373,  1.031190,  1.035494,  1.032456,  1.038506,  1.039142,  1.042008,  1.042182,  1.045953,  1.046010,  1.048191,  1.049355,  1.053951,  1.055045,  1.055605,  1.055673,  1.060607,  1.065041,  1.057352,  1.067371,  1.067831,  1.068976,  1.070566,  1.075047,  1.074708,  1.075395,  1.076992,  1.081581,  1.083591,  1.082092,  1.084296,  1.088046,  1.093522,  1.086344,  1.096147,  1.094003,  1.095589,  1.098481,  1.104141,  1.104673,  1.101336,  1.104128,  1.109116,  1.114547,  1.108457,  1.113943,  1.115165,  1.120115,  1.114341,  1.125465,  1.122376,  1.122472,  1.125674,  1.133238,  1.133948,  1.127826,  1.131237,  1.137685,  1.143401,  1.131441,  1.145616,  1.143070,  1.150897,  1.142118,  1.152761,  1.149523,  1.151790,  1.150343,  1.164458,  1.160037,  1.157509,  1.159647,  1.163499,  1.175883,  1.154568,  1.175111,  1.171352,  1.176013,  1.174487,  1.180964,  1.176582,  1.179389,  1.178277,  1.190764, },
{ 1.000000,  1.001878,  1.003818,  1.005120,  1.007210,  1.009720,  1.009915,  1.012935,  1.014618,  1.016500,  1.018092,  1.020281,  1.021503,  1.023390,  1.024723,  1.027767,  1.029782,  1.030127,  1.032126,  1.034145,  1.037779,  1.035841,  1.041360,  1.041179,  1.042882,  1.045339,  1.048652,  1.049302,  1.049479,  1.051214,  1.054866,  1.058036,  1.056472,  1.059993,  1.060963,  1.065372,  1.062093,  1.069366,  1.068871,  1.069828,  1.071086,  1.077523,  1.077381,  1.075389,  1.077699,  1.082105,  1.086649,  1.080585,  1.089038,  1.087600,  1.093635,  1.089364,  1.096671,  1.095094,  1.096885,  1.097995,  1.105650,  1.104109,  1.102988,  1.104485,  1.108620,  1.116867,  1.102877,  1.117183,  1.115270,  1.119499,  1.119046,  1.123109,  1.122993,  1.124108,  1.121868,  1.133491,  1.132070,  1.130316,  1.130076,  1.137231,  1.147149,  1.124729,  1.146994,  1.143311,  1.145034,  1.145280,  1.153641,  1.148876,  1.151463,  1.150291,  1.159335,  1.160852,  1.156207,  1.157912,  1.162777,  1.172725,  1.155027,  1.174349,  1.169610,  1.170416,  1.173010,  1.182352,  1.179171,  1.174383, },
{ 1.000000,  1.001756,  1.003799,  1.005740,  1.007248,  1.009331,  1.010478,  1.013159,  1.013679,  1.016942,  1.017960,  1.019845,  1.021720,  1.024641,  1.025948,  1.026666,  1.028535,  1.031053,  1.034403,  1.032942,  1.037113,  1.038022,  1.041443,  1.040823,  1.044909,  1.044932,  1.047644,  1.048309,  1.053358,  1.054365,  1.053269,  1.055397,  1.057744,  1.063873,  1.057260,  1.065310,  1.065197,  1.069465,  1.068982,  1.072235,  1.073131,  1.073994,  1.073594,  1.082033,  1.080705,  1.081086,  1.080923,  1.086409,  1.094037,  1.081050,  1.094722,  1.092140,  1.095484,  1.097152,  1.101530,  1.098901,  1.102873,  1.100048,  1.108918,  1.109448,  1.108243,  1.109208,  1.113057,  1.121174,  1.107846,  1.122796,  1.119665,  1.122045,  1.124227,  1.129707,  1.128385,  1.126372,  1.128756,  1.134988,  1.138620,  1.134198,  1.139271,  1.138137,  1.148825,  1.136690,  1.150774,  1.146505,  1.149104,  1.149424,  1.158414,  1.157992,  1.152241,  1.154664,  1.161453,  1.170228,  1.155999,  1.169051,  1.166939,  1.175013,  1.166450,  1.180053,  1.171091,  1.177796,  1.175171,  1.187516, },
{ 1.000000,  1.001802,  1.003620,  1.005329,  1.007247,  1.009505,  1.010375,  1.013248,  1.014578,  1.017040,  1.018127,  1.020737,  1.021750,  1.023712,  1.024948,  1.028400,  1.029385,  1.031477,  1.032055,  1.035193,  1.039764,  1.034838,  1.042420,  1.041505,  1.044759,  1.046172,  1.049133,  1.048605,  1.052040,  1.051427,  1.056939,  1.057650,  1.058947,  1.059114,  1.061957,  1.068397,  1.060944,  1.070178,  1.069318,  1.072214,  1.073992,  1.077860,  1.077357,  1.077415,  1.079278,  1.083800,  1.086033,  1.085395,  1.087404,  1.088484,  1.096561,  1.089637,  1.098867,  1.096191,  1.099457,  1.099219,  1.107359,  1.106443,  1.103451,  1.106136,  1.110531,  1.118085,  1.109015,  1.117350,  1.116538,  1.124255,  1.116808,  1.127475,  1.122609,  1.126526,  1.127163,  1.134777,  1.135693,  1.131248,  1.132967,  1.139086,  1.146581,  1.132317,  1.146248,  1.144182,  1.152420,  1.145684,  1.154396,  1.150517,  1.154298,  1.152373,  1.165021,  1.160285,  1.162264,  1.158074,  1.165253,  1.180301,  1.152919,  1.177604,  1.170336,  1.177102,  1.177011,  1.182242,  1.177486,  1.183250, },
{ 1.000000,  1.001673,  1.003712,  1.005399,  1.007080,  1.008780,  1.010910,  1.013610,  1.013044,  1.016580,  1.018060,  1.019801,  1.021334,  1.024375,  1.025496,  1.026807,  1.028255,  1.030967,  1.033350,  1.033799,  1.035614,  1.037672,  1.042144,  1.039173,  1.044970,  1.044028,  1.047178,  1.047596,  1.052477,  1.053359,  1.052670,  1.055066,  1.058149,  1.063093,  1.059055,  1.063578,  1.064425,  1.069305,  1.065893,  1.072745,  1.071248,  1.073913,  1.075255,  1.079539,  1.081661,  1.079130,  1.080626,  1.085437,  1.090755,  1.082784,  1.091666,  1.091434,  1.098680,  1.091961,  1.100089,  1.098688,  1.100146,  1.100993,  1.109243,  1.107560,  1.108668,  1.105822,  1.111307,  1.123068,  1.105137,  1.120804,  1.118116,  1.122814,  1.122769,  1.128170,  1.123140,  1.128795,  1.126788,  1.136012,  1.135443,  1.136798,  1.131927,  1.138489,  1.153129,  1.127443,  1.148276,  1.148177,  1.148476,  1.149702,  1.156478,  1.153145,  1.153291,  1.154705,  1.160725,  1.163372,  1.161483,  1.160794,  1.165362,  1.178086,  1.160128,  1.177131,  1.169502,  1.175106,  1.175565,  1.185589, },
{ 1.000000,  1.001736,  1.003424,  1.005308,  1.007183,  1.009365,  1.010261,  1.012788,  1.014377,  1.016623,  1.017348,  1.020457,  1.021316,  1.023306,  1.024784,  1.027964,  1.029624,  1.029899,  1.031347,  1.034563,  1.037904,  1.035323,  1.040437,  1.041134,  1.045569,  1.043555,  1.047800,  1.048323,  1.050400,  1.050502,  1.056690,  1.056366,  1.058029,  1.057643,  1.060237,  1.068278,  1.059254,  1.068568,  1.067821,  1.072561,  1.071293,  1.075628,  1.074104,  1.077953,  1.077426,  1.083081,  1.084384,  1.085636,  1.082774,  1.088793,  1.096810,  1.082700,  1.096118,  1.096137,  1.098155,  1.099517,  1.103440,  1.102393,  1.104130,  1.104018,  1.109763,  1.112679,  1.110316,  1.110675,  1.114854,  1.124206,  1.112353,  1.124655,  1.120781,  1.123502,  1.126335,  1.131745,  1.132381,  1.129124,  1.129853,  1.135668,  1.144193,  1.135546,  1.139649,  1.140837,  1.149669,  1.139900,  1.152545,  1.148029,  1.149879,  1.151977,  1.159437,  1.161294,  1.155280,  1.155279,  1.162715,  1.172832,  1.156546,  1.171537,  1.166825,  1.180234,  1.166916,  1.178848,  1.173973,  1.178562, },
{ 1.000000,  1.001603,  1.003595,  1.005381,  1.006955,  1.008404,  1.010298,  1.013400,  1.012917,  1.016178,  1.017265,  1.019906,  1.021024,  1.023128,  1.023984,  1.026640,  1.027368,  1.030527,  1.032216,  1.033739,  1.033739,  1.036886,  1.041785,  1.036183,  1.043297,  1.043805,  1.046443,  1.047191,  1.050371,  1.050206,  1.053086,  1.052630,  1.057447,  1.060026,  1.059098,  1.059364,  1.062558,  1.069163,  1.062671,  1.070707,  1.069062,  1.071363,  1.073989,  1.077383,  1.077995,  1.078139,  1.078289,  1.082726,  1.087931,  1.084477,  1.087446,  1.087694,  1.095677,  1.088601,  1.097983,  1.096113,  1.097723,  1.098396,  1.105801,  1.105395,  1.103210,  1.103296,  1.109171,  1.116797,  1.106676,  1.116372,  1.113375,  1.123474,  1.115213,  1.124077,  1.121623,  1.124328,  1.124206,  1.133160,  1.131446,  1.130970,  1.129148,  1.134163,  1.147448,  1.126923,  1.143503,  1.140076,  1.147942,  1.145767,  1.148999,  1.148494,  1.151395,  1.146368,  1.159311,  1.158848,  1.158155,  1.153549,  1.162328,  1.177267,  1.146763,  1.173182,  1.167348,  1.171924,  1.171319,  1.179095, },
{ 1.000000,  1.001589,  1.003497,  1.005051,  1.006929,  1.009034,  1.010299,  1.011690,  1.013827,  1.016664,  1.015916,  1.019601,  1.020644,  1.022516,  1.024130,  1.026982,  1.027913,  1.028952,  1.030163,  1.033209,  1.035928,  1.035996,  1.038214,  1.038508,  1.044269,  1.041121,  1.046567,  1.046215,  1.048529,  1.049823,  1.053531,  1.054765,  1.054569,  1.055002,  1.058509,  1.064711,  1.059558,  1.064981,  1.064967,  1.070717,  1.067302,  1.072549,  1.071309,  1.075055,  1.074435,  1.080723,  1.082032,  1.080586,  1.080737,  1.083746,  1.093498,  1.081631,  1.091640,  1.090266,  1.097244,  1.095083,  1.098056,  1.098444,  1.100343,  1.098360,  1.108177,  1.107136,  1.107612,  1.103911,  1.111516,  1.123048,  1.103360,  1.119989,  1.115856,  1.121267,  1.122612,  1.126035,  1.122675,  1.128967,  1.122733,  1.133492,  1.134715,  1.132931,  1.130675,  1.135853,  1.148223,  1.129367,  1.147169,  1.142234,  1.146271,  1.148348,  1.152752,  1.151165,  1.150649,  1.149971,  1.157176,  1.163072,  1.157275,  1.160281,  1.159524,  1.174545,  1.157382,  1.173394,  1.167403,  1.172011, },
{ 1.000000,  1.001555,  1.003454,  1.005160,  1.006500,  1.007896,  1.010121,  1.012563,  1.012824,  1.015102,  1.016486,  1.019317,  1.019344,  1.022327,  1.022786,  1.025539,  1.026131,  1.029273,  1.030690,  1.031624,  1.032183,  1.034893,  1.039536,  1.035870,  1.040835,  1.040918,  1.045597,  1.044631,  1.047864,  1.047685,  1.050388,  1.050403,  1.055119,  1.055862,  1.057666,  1.055464,  1.060373,  1.067670,  1.057023,  1.068203,  1.064928,  1.069934,  1.071038,  1.073673,  1.071788,  1.076431,  1.073826,  1.080717,  1.081544,  1.082615,  1.080228,  1.084337,  1.093789,  1.081182,  1.093134,  1.090927,  1.094512,  1.096045,  1.099735,  1.098797,  1.099414,  1.099127,  1.104798,  1.107912,  1.106608,  1.106196,  1.108458,  1.119048,  1.108367,  1.118699,  1.115031,  1.119627,  1.117978,  1.126604,  1.125919,  1.122891,  1.123174,  1.128651,  1.138721,  1.126736,  1.134545,  1.133035,  1.144451,  1.133044,  1.144801,  1.138505,  1.144672,  1.143787,  1.151189,  1.152281,  1.149225,  1.146467,  1.154458,  1.164718,  1.147374,  1.161010,  1.157549,  1.169992,  1.161008,  1.169166, },
{ 1.000000,  1.001497,  1.003290,  1.004786,  1.006696,  1.008042,  1.010011,  1.010905,  1.012985,  1.016179,  1.014588,  1.018632,  1.018899,  1.021918,  1.023000,  1.024917,  1.025449,  1.028332,  1.028257,  1.031786,  1.033312,  1.034801,  1.034322,  1.037328,  1.042906,  1.036766,  1.043575,  1.044116,  1.046405,  1.047330,  1.050391,  1.050696,  1.052151,  1.052407,  1.055536,  1.059082,  1.058510,  1.059064,  1.061450,  1.068517,  1.061456,  1.069264,  1.066417,  1.071137,  1.070208,  1.076168,  1.076891,  1.075129,  1.076355,  1.080016,  1.087002,  1.080444,  1.084719,  1.085278,  1.092532,  1.086329,  1.094282,  1.091102,  1.095126,  1.095512,  1.099945,  1.102491,  1.100143,  1.099046,  1.104970,  1.111883,  1.101271,  1.110920,  1.109110,  1.120220,  1.110263,  1.118935,  1.115949,  1.118369,  1.118443,  1.127402,  1.125709,  1.127365,  1.121021,  1.128191,  1.143325,  1.119593,  1.137732,  1.132593,  1.140540,  1.139821,  1.144024,  1.137413,  1.146331,  1.141369,  1.150542,  1.151151,  1.153652,  1.143591,  1.152136,  1.171577,  1.139258,  1.162370,  1.160837,  1.163497, },
{ 1.000000,  1.001495,  1.003259,  1.004749,  1.006266,  1.007936,  1.009659,  1.011391,  1.012883,  1.013857,  1.015625,  1.019160,  1.018138,  1.021364,  1.021552,  1.024256,  1.025288,  1.027911,  1.029507,  1.029752,  1.030718,  1.033628,  1.037427,  1.035330,  1.038470,  1.039556,  1.043135,  1.041721,  1.045960,  1.045289,  1.048576,  1.048807,  1.052518,  1.054205,  1.053694,  1.053395,  1.057890,  1.062665,  1.057059,  1.063465,  1.062509,  1.069856,  1.064902,  1.069856,  1.069143,  1.072043,  1.070944,  1.078961,  1.077243,  1.079454,  1.076680,  1.079850,  1.090982,  1.076789,  1.088855,  1.086018,  1.093465,  1.090367,  1.094700,  1.091670,  1.097208,  1.094873,  1.101160,  1.102822,  1.104329,  1.097998,  1.105812,  1.116677,  1.096938,  1.112888,  1.111482,  1.115514,  1.116221,  1.118688,  1.117623,  1.120556,  1.118272,  1.124519,  1.128385,  1.125387,  1.123379,  1.128097,  1.140905,  1.124723,  1.138555,  1.132652,  1.137261,  1.139335,  1.144122,  1.145098,  1.142529,  1.140212,  1.146793,  1.157488,  1.147258,  1.149824,  1.150684,  1.162563,  1.149499,  1.163434, },
{ 1.000000,  1.001420,  1.003083,  1.004601,  1.006263,  1.007761,  1.009218,  1.010333,  1.012400,  1.014567,  1.014626,  1.017284,  1.017870,  1.021563,  1.020846,  1.023605,  1.024067,  1.026352,  1.026721,  1.030708,  1.031480,  1.032660,  1.032861,  1.035128,  1.040405,  1.035225,  1.041266,  1.040506,  1.045080,  1.044872,  1.046959,  1.046742,  1.050102,  1.049271,  1.053504,  1.055571,  1.056626,  1.054133,  1.058643,  1.066168,  1.055273,  1.064747,  1.064077,  1.068207,  1.068031,  1.070513,  1.069956,  1.073844,  1.071538,  1.077168,  1.080272,  1.078424,  1.076656,  1.080383,  1.090069,  1.079392,  1.089493,  1.086031,  1.089652,  1.091256,  1.094923,  1.095732,  1.095688,  1.093217,  1.099037,  1.105448,  1.100460,  1.102612,  1.102426,  1.113274,  1.102340,  1.113415,  1.110149,  1.112923,  1.111745,  1.120408,  1.119849,  1.117737,  1.114560,  1.122593,  1.131214,  1.119374,  1.128584,  1.124279,  1.137962,  1.126695,  1.135449,  1.132543,  1.135770,  1.134697,  1.144381,  1.142792,  1.142496,  1.137555,  1.144027,  1.159242,  1.135454,  1.153230,  1.147683,  1.159469, },
{ 1.000000,  1.001613,  1.003011,  1.004792,  1.006292,  1.007470,  1.009518,  1.011298,  1.012613,  1.013314,  1.015482,  1.018928,  1.016491,  1.021064,  1.021264,  1.023888,  1.024964,  1.027076,  1.027440,  1.030114,  1.030100,  1.033324,  1.035210,  1.035814,  1.035660,  1.038335,  1.043705,  1.038781,  1.045052,  1.044228,  1.047010,  1.048358,  1.051129,  1.052017,  1.052646,  1.051968,  1.056373,  1.059973,  1.058421,  1.060758,  1.059772,  1.068535,  1.061720,  1.069229,  1.067042,  1.070479,  1.070826,  1.075331,  1.076296,  1.075329,  1.073942,  1.078813,  1.086746,  1.079245,  1.084580,  1.083544,  1.092647,  1.085664,  1.091772,  1.089820,  1.094434,  1.092073,  1.100137,  1.100815,  1.099015,  1.097031,  1.101228,  1.113049,  1.097829,  1.108711,  1.105661,  1.116407,  1.112309,  1.113611,  1.114616,  1.116982,  1.112915,  1.124925,  1.123253,  1.123833,  1.117166,  1.126463,  1.140678,  1.116067,  1.134995,  1.128090,  1.137001,  1.137570,  1.139544,  1.135869,  1.143501,  1.134898,  1.147079,  1.148049,  1.146598,  1.141942,  1.147060,  1.163344,  1.139576,  1.159567, },
{ 1.000000,  1.001520,  1.002960,  1.004718,  1.006331,  1.007948,  1.009187,  1.010366,  1.012659,  1.014677,  1.015307,  1.016991,  1.018072,  1.021664,  1.020591,  1.024041,  1.024543,  1.026755,  1.027652,  1.030339,  1.032111,  1.032013,  1.032554,  1.036031,  1.040164,  1.037494,  1.040650,  1.041223,  1.046372,  1.043443,  1.048299,  1.046829,  1.050667,  1.049866,  1.054961,  1.056017,  1.055716,  1.054974,  1.059174,  1.065146,  1.057947,  1.064584,  1.063666,  1.070941,  1.067785,  1.071365,  1.070852,  1.073216,  1.072152,  1.078736,  1.079552,  1.080664,  1.076071,  1.082771,  1.093117,  1.075970,  1.091203,  1.085465,  1.093502,  1.093138,  1.095227,  1.093023,  1.098518,  1.093694,  1.102958,  1.103123,  1.104287,  1.099488,  1.104123,  1.117471,  1.099339,  1.113897,  1.110198,  1.116010,  1.116518,  1.119255,  1.119069,  1.119391,  1.117150,  1.124569,  1.128015,  1.126053,  1.124614,  1.125921,  1.140615,  1.125899,  1.137778,  1.132860,  1.139214,  1.135256,  1.145125,  1.145391,  1.139990,  1.139186,  1.147115,  1.157989,  1.144183,  1.151256,  1.149097,  1.164809, },
{ 1.000000,  1.001434,  1.002894,  1.004394,  1.006087,  1.007487,  1.009202,  1.010767,  1.012078,  1.012975,  1.015081,  1.017657,  1.016959,  1.019751,  1.020478,  1.024077,  1.023874,  1.025818,  1.026533,  1.028893,  1.029238,  1.032790,  1.033557,  1.035261,  1.034272,  1.037431,  1.043453,  1.036217,  1.043753,  1.041894,  1.047161,  1.047215,  1.048560,  1.048766,  1.052368,  1.050719,  1.055863,  1.056647,  1.058073,  1.055712,  1.059704,  1.068308,  1.056584,  1.066292,  1.065454,  1.069335,  1.069555,  1.072156,  1.072559,  1.073691,  1.073045,  1.076956,  1.081091,  1.079416,  1.079235,  1.081322,  1.091956,  1.080354,  1.090478,  1.085645,  1.092421,  1.089653,  1.096080,  1.098255,  1.093752,  1.094757,  1.099867,  1.108328,  1.099405,  1.103182,  1.103235,  1.113628,  1.104157,  1.112809,  1.108873,  1.114393,  1.113197,  1.117772,  1.121834,  1.117681,  1.114499,  1.123345,  1.130729,  1.117941,  1.126936,  1.124530,  1.140484,  1.126459,  1.135043,  1.132376,  1.134611,  1.133537,  1.144528,  1.142521,  1.143738,  1.135372,  1.143141,  1.162138,  1.132597,  1.152772, },
{ 1.000000,  1.001388,  1.003133,  1.004511,  1.006171,  1.007294,  1.009270,  1.010211,  1.012397,  1.013845,  1.015555,  1.015553,  1.017888,  1.022097,  1.018577,  1.023088,  1.024144,  1.026269,  1.027665,  1.029116,  1.030139,  1.031742,  1.032681,  1.035112,  1.037242,  1.037903,  1.037819,  1.039704,  1.046200,  1.041198,  1.046221,  1.044836,  1.049322,  1.049411,  1.052575,  1.054514,  1.052806,  1.053243,  1.057389,  1.063041,  1.058251,  1.061359,  1.062226,  1.068092,  1.064159,  1.069034,  1.067543,  1.072286,  1.071035,  1.075596,  1.077983,  1.075978,  1.073914,  1.080977,  1.086631,  1.078373,  1.085553,  1.082904,  1.094939,  1.086701,  1.091175,  1.090634,  1.094048,  1.091331,  1.101769,  1.099136,  1.101241,  1.096689,  1.100321,  1.114951,  1.095496,  1.109795,  1.104824,  1.117152,  1.111585,  1.114096,  1.111595,  1.118095,  1.114577,  1.121765,  1.123790,  1.125050,  1.115586,  1.124913,  1.140010,  1.113166,  1.132070,  1.129206,  1.136876,  1.136892,  1.136540,  1.136753,  1.139603,  1.136359,  1.143277,  1.148594,  1.143656,  1.140058,  1.144952,  1.163083, },
{ 1.000000,  1.001306,  1.002964,  1.004054,  1.005712,  1.007115,  1.008606,  1.010053,  1.011175,  1.012127,  1.014132,  1.016496,  1.016551,  1.017959,  1.019237,  1.022303,  1.021630,  1.024552,  1.024690,  1.027031,  1.027750,  1.030166,  1.032157,  1.032002,  1.031748,  1.035349,  1.039236,  1.036262,  1.039800,  1.039148,  1.045878,  1.042356,  1.045305,  1.045395,  1.048278,  1.047436,  1.053157,  1.053027,  1.053854,  1.052823,  1.055145,  1.063681,  1.054109,  1.061815,  1.059311,  1.066881,  1.065711,  1.065934,  1.065920,  1.070123,  1.067967,  1.073154,  1.075380,  1.076188,  1.071615,  1.076937,  1.087667,  1.071324,  1.083213,  1.080727,  1.088041,  1.087170,  1.087783,  1.087309,  1.092277,  1.088095,  1.094196,  1.099208,  1.095663,  1.092048,  1.095561,  1.109856,  1.094693,  1.105778,  1.100472,  1.107587,  1.107656,  1.109689,  1.112541,  1.111198,  1.107100,  1.113163,  1.122866,  1.115359,  1.117093,  1.115183,  1.130277,  1.116171,  1.127490,  1.122655,  1.128790,  1.125197,  1.133849,  1.134536,  1.131461,  1.125516,  1.135149,  1.146895,  1.132823,  1.140125, },
{ 1.000000,  1.001276,  1.003004,  1.003963,  1.005444,  1.006760,  1.008210,  1.009134,  1.011296,  1.012531,  1.013760,  1.014142,  1.015849,  1.019473,  1.017417,  1.020631,  1.020743,  1.024519,  1.024823,  1.025616,  1.026993,  1.029020,  1.028272,  1.032235,  1.033496,  1.034353,  1.033482,  1.036442,  1.042448,  1.034366,  1.042421,  1.040586,  1.045022,  1.045422,  1.046891,  1.046691,  1.050038,  1.048567,  1.052131,  1.055128,  1.054415,  1.052980,  1.055436,  1.064185,  1.054883,  1.063055,  1.060321,  1.065587,  1.065356,  1.067954,  1.069219,  1.069450,  1.066646,  1.072062,  1.077376,  1.073916,  1.076514,  1.073145,  1.085672,  1.075813,  1.084262,  1.079815,  1.086118,  1.084518,  1.089205,  1.090508,  1.088986,  1.085461,  1.091110,  1.101841,  1.091814,  1.096650,  1.094257,  1.106710,  1.097709,  1.102543,  1.100852,  1.106422,  1.102450,  1.111317,  1.112493,  1.109360,  1.106589,  1.109734,  1.125612,  1.106607,  1.117853,  1.112551,  1.128068,  1.122253,  1.120641,  1.123642,  1.126190,  1.119633,  1.133174,  1.131898,  1.131434,  1.123493,  1.132227,  1.150715, },
{ 1.000000,  1.001142,  1.002770,  1.003683,  1.005387,  1.006724,  1.007988,  1.008795,  1.010850,  1.011093,  1.013444,  1.014698,  1.015632,  1.016204,  1.017807,  1.021374,  1.018984,  1.022870,  1.022653,  1.025494,  1.026366,  1.027696,  1.028966,  1.029881,  1.029701,  1.032512,  1.035770,  1.034892,  1.036144,  1.036051,  1.042499,  1.038438,  1.042898,  1.041432,  1.045840,  1.044986,  1.047611,  1.049764,  1.048839,  1.047682,  1.051914,  1.057778,  1.052981,  1.056211,  1.055143,  1.063105,  1.057957,  1.062911,  1.059803,  1.065652,  1.062862,  1.069000,  1.069959,  1.068728,  1.066726,  1.070710,  1.079533,  1.068947,  1.076339,  1.073315,  1.084249,  1.079163,  1.081459,  1.081061,  1.084498,  1.080887,  1.088525,  1.089745,  1.090202,  1.084042,  1.090403,  1.104070,  1.082602,  1.099254,  1.090703,  1.102553,  1.101407,  1.101897,  1.098582,  1.106227,  1.098824,  1.108523,  1.109634,  1.110019,  1.103955,  1.107202,  1.123838,  1.102809,  1.118029,  1.111792,  1.121649,  1.120701,  1.121793,  1.122105,  1.123131,  1.118046,  1.125284,  1.131315,  1.128123,  1.125380, },
{ 1.000000,  1.001180,  1.002783,  1.003631,  1.005346,  1.006185,  1.008077,  1.008721,  1.010647,  1.012010,  1.012677,  1.013498,  1.015446,  1.018196,  1.017536,  1.019251,  1.019943,  1.023813,  1.022378,  1.025111,  1.024862,  1.027814,  1.027751,  1.030632,  1.032345,  1.032505,  1.031958,  1.034879,  1.039195,  1.035459,  1.039194,  1.038469,  1.044989,  1.042552,  1.044320,  1.044485,  1.047768,  1.045717,  1.051345,  1.051808,  1.052952,  1.050130,  1.053407,  1.062823,  1.050513,  1.060405,  1.056090,  1.064443,  1.063246,  1.063975,  1.063456,  1.068585,  1.064098,  1.070704,  1.071768,  1.072603,  1.068498,  1.072536,  1.084053,  1.067772,  1.079762,  1.076919,  1.083160,  1.082398,  1.084530,  1.084754,  1.086404,  1.083126,  1.087308,  1.093744,  1.090378,  1.089374,  1.090491,  1.104197,  1.090239,  1.100821,  1.093125,  1.104180,  1.097848,  1.105325,  1.108698,  1.102347,  1.102232,  1.107058,  1.118474,  1.107500,  1.110460,  1.109035,  1.122426,  1.111509,  1.119078,  1.114358,  1.122697,  1.118288,  1.123558,  1.129063,  1.123690,  1.118734,  1.127066,  1.137179, },
{ 1.000000,  1.001111,  1.002460,  1.003445,  1.005675,  1.006149,  1.007660,  1.008688,  1.010112,  1.010735,  1.013294,  1.014385,  1.015488,  1.015475,  1.017102,  1.021298,  1.018077,  1.022017,  1.021575,  1.025470,  1.025566,  1.026809,  1.026925,  1.030137,  1.028975,  1.032411,  1.034035,  1.034853,  1.033042,  1.035836,  1.043172,  1.033857,  1.041356,  1.040954,  1.044460,  1.045085,  1.046076,  1.046649,  1.048610,  1.047569,  1.050540,  1.053668,  1.053526,  1.051914,  1.053447,  1.062806,  1.054911,  1.060861,  1.057251,  1.064807,  1.061882,  1.066186,  1.068698,  1.065537,  1.064315,  1.069211,  1.077124,  1.069480,  1.072633,  1.072618,  1.080163,  1.075158,  1.079534,  1.076683,  1.083888,  1.079463,  1.085643,  1.088878,  1.085012,  1.081306,  1.088267,  1.096428,  1.085867,  1.093782,  1.088539,  1.104544,  1.093249,  1.097192,  1.096576,  1.102335,  1.094829,  1.108432,  1.105973,  1.106582,  1.101598,  1.102836,  1.121791,  1.098804,  1.113934,  1.106494,  1.122818,  1.114867,  1.116647,  1.113965,  1.122697,  1.114858,  1.124155,  1.127382,  1.126955,  1.116470, },
{ 1.000000,  1.001114,  1.002599,  1.003173,  1.004975,  1.005900,  1.007540,  1.008755,  1.009793,  1.010862,  1.012295,  1.012867,  1.014654,  1.016662,  1.016812,  1.017320,  1.018913,  1.022734,  1.020539,  1.023892,  1.023189,  1.026421,  1.026431,  1.028409,  1.030559,  1.030207,  1.029803,  1.032397,  1.036855,  1.034836,  1.035671,  1.036278,  1.041457,  1.038655,  1.042486,  1.040945,  1.045030,  1.043844,  1.047263,  1.049757,  1.048302,  1.046280,  1.050856,  1.056338,  1.051196,  1.055667,  1.052784,  1.062611,  1.056700,  1.059888,  1.059110,  1.063374,  1.059207,  1.068323,  1.067911,  1.067027,  1.065472,  1.066964,  1.078832,  1.065078,  1.074787,  1.069741,  1.080704,  1.077826,  1.077028,  1.077359,  1.082931,  1.076921,  1.084760,  1.087229,  1.086799,  1.081189,  1.086470,  1.099572,  1.078643,  1.093161,  1.088442,  1.098676,  1.096511,  1.096732,  1.095628,  1.101807,  1.094724,  1.102121,  1.108495,  1.103222,  1.098398,  1.101775,  1.118283,  1.100814,  1.113089,  1.105458,  1.115781,  1.112198,  1.116369,  1.119627,  1.117668,  1.110267,  1.117338,  1.129530, },
{ 1.000000,  1.001046,  1.002331,  1.003314,  1.005002,  1.005585,  1.007314,  1.007869,  1.009687,  1.010041,  1.012216,  1.013377,  1.013889,  1.014062,  1.016242,  1.019167,  1.017793,  1.020190,  1.019793,  1.024232,  1.022694,  1.024805,  1.025331,  1.027159,  1.026929,  1.030787,  1.031422,  1.031630,  1.031173,  1.032626,  1.039365,  1.032422,  1.038500,  1.036207,  1.042824,  1.041198,  1.041626,  1.043105,  1.045731,  1.042119,  1.048828,  1.049608,  1.049305,  1.047578,  1.050740,  1.059849,  1.045675,  1.057798,  1.053168,  1.059744,  1.059062,  1.061161,  1.059332,  1.063611,  1.060432,  1.065244,  1.068946,  1.066194,  1.064225,  1.066705,  1.077562,  1.064719,  1.075665,  1.070279,  1.078091,  1.074817,  1.079674,  1.080209,  1.080028,  1.074911,  1.080897,  1.089101,  1.082676,  1.086291,  1.080473,  1.095840,  1.083787,  1.094091,  1.086555,  1.095697,  1.090824,  1.098806,  1.098911,  1.095871,  1.091072,  1.097292,  1.110404,  1.097650,  1.103731,  1.099225,  1.114162,  1.102617,  1.108432,  1.105877,  1.112934,  1.105270,  1.118069,  1.118756,  1.113517,  1.110284, },
{ 1.000000,  1.000952,  1.002490,  1.002963,  1.004484,  1.005191,  1.007237,  1.007727,  1.008773,  1.009930,  1.011402,  1.011207,  1.014105,  1.014925,  1.015485,  1.015503,  1.017584,  1.021464,  1.017220,  1.022176,  1.020549,  1.024306,  1.024907,  1.026155,  1.025953,  1.028922,  1.026751,  1.031030,  1.032313,  1.031977,  1.031822,  1.033390,  1.039125,  1.032690,  1.039494,  1.036846,  1.041455,  1.041045,  1.043392,  1.043597,  1.044398,  1.042691,  1.045995,  1.050944,  1.047687,  1.049893,  1.048016,  1.056750,  1.050122,  1.056593,  1.052925,  1.058644,  1.055790,  1.060976,  1.062237,  1.059745,  1.057817,  1.062404,  1.070755,  1.062527,  1.067309,  1.064427,  1.074553,  1.066837,  1.073461,  1.068570,  1.075391,  1.070605,  1.079686,  1.079512,  1.076813,  1.074469,  1.077900,  1.089229,  1.074234,  1.085407,  1.078896,  1.092437,  1.085902,  1.088796,  1.087383,  1.091475,  1.085355,  1.096072,  1.096211,  1.095137,  1.089042,  1.095521,  1.111272,  1.084242,  1.105715,  1.093235,  1.107894,  1.105085,  1.106821,  1.100849,  1.110976,  1.100541,  1.112878,  1.113565, },
{ 1.000000,  1.001141,  1.001969,  1.003107,  1.004858,  1.004812,  1.006890,  1.007322,  1.009248,  1.009863,  1.011363,  1.012122,  1.013124,  1.013428,  1.015246,  1.017431,  1.017242,  1.018070,  1.018786,  1.022697,  1.020695,  1.024130,  1.022895,  1.026211,  1.024984,  1.029081,  1.029533,  1.028498,  1.029064,  1.031417,  1.036157,  1.032328,  1.035116,  1.034486,  1.040412,  1.036473,  1.040670,  1.038670,  1.042505,  1.041067,  1.046078,  1.047002,  1.045306,  1.044614,  1.047288,  1.054042,  1.046089,  1.052561,  1.049297,  1.058439,  1.053818,  1.056627,  1.055652,  1.059119,  1.055322,  1.064081,  1.062922,  1.063237,  1.059886,  1.063079,  1.075293,  1.056873,  1.071536,  1.063706,  1.074376,  1.071852,  1.073684,  1.070882,  1.077388,  1.071071,  1.080116,  1.080218,  1.079122,  1.075228,  1.079781,  1.092930,  1.070757,  1.087973,  1.082049,  1.089623,  1.087715,  1.092510,  1.089626,  1.091350,  1.087229,  1.091691,  1.100525,  1.093483,  1.093807,  1.094416,  1.108979,  1.091873,  1.106493,  1.094381,  1.107684,  1.098378,  1.111094,  1.111503,  1.102925,  1.104131, },
{ 1.000000,  1.001040,  1.002177,  1.002879,  1.004009,  1.004790,  1.006632,  1.006901,  1.008317,  1.008826,  1.010369,  1.010766,  1.012665,  1.013864,  1.013856,  1.014346,  1.015971,  1.018804,  1.016778,  1.019554,  1.018965,  1.024050,  1.021075,  1.023884,  1.024094,  1.025429,  1.024671,  1.029403,  1.029446,  1.029813,  1.028652,  1.030007,  1.037790,  1.028505,  1.035808,  1.032994,  1.039157,  1.037585,  1.039573,  1.037704,  1.042027,  1.039265,  1.044352,  1.045716,  1.045324,  1.042061,  1.045551,  1.055650,  1.039750,  1.051832,  1.049145,  1.053730,  1.053343,  1.055413,  1.054623,  1.056363,  1.054152,  1.057851,  1.061954,  1.059412,  1.058135,  1.059271,  1.070407,  1.058990,  1.067630,  1.061086,  1.070714,  1.065440,  1.072611,  1.073831,  1.068296,  1.066925,  1.072097,  1.082673,  1.070941,  1.075317,  1.074878,  1.082820,  1.076331,  1.082156,  1.078072,  1.085127,  1.079027,  1.088251,  1.090436,  1.083866,  1.081076,  1.087232,  1.098149,  1.082252,  1.094794,  1.085673,  1.104778,  1.090075,  1.096072,  1.094239,  1.099189,  1.090367,  1.108199,  1.103066, },
{ 1.000000,  1.000999,  1.001881,  1.002614,  1.004397,  1.004054,  1.005979,  1.006249,  1.008487,  1.008553,  1.009722,  1.010345,  1.012012,  1.011719,  1.013969,  1.015268,  1.015669,  1.014936,  1.017260,  1.020987,  1.015678,  1.020966,  1.020271,  1.023567,  1.023515,  1.024388,  1.025233,  1.026425,  1.025404,  1.027930,  1.031301,  1.029042,  1.028687,  1.030738,  1.036799,  1.030800,  1.036223,  1.033333,  1.038152,  1.036642,  1.039865,  1.041870,  1.039885,  1.038364,  1.041343,  1.048200,  1.042801,  1.043959,  1.044190,  1.050735,  1.045480,  1.051161,  1.047932,  1.052527,  1.049953,  1.055357,  1.057904,  1.053452,  1.051163,  1.055890,  1.063994,  1.054531,  1.061380,  1.055942,  1.069025,  1.059738,  1.064029,  1.063111,  1.066472,  1.060928,  1.073618,  1.071404,  1.068712,  1.067433,  1.067274,  1.083523,  1.063442,  1.077101,  1.068604,  1.083155,  1.077907,  1.077015,  1.077515,  1.082502,  1.074760,  1.085549,  1.087564,  1.084835,  1.078525,  1.084497,  1.100487,  1.072347,  1.091404,  1.084175,  1.097552,  1.092266,  1.093321,  1.092486,  1.097289,  1.088851, },
{ 1.000000,  1.000930,  1.002019,  1.002665,  1.003315,  1.004245,  1.006083,  1.005526,  1.007521,  1.007610,  1.009518,  1.009564,  1.011307,  1.012344,  1.012609,  1.012157,  1.014026,  1.017173,  1.015536,  1.016785,  1.017055,  1.020885,  1.018125,  1.021550,  1.020902,  1.023370,  1.021691,  1.026107,  1.026961,  1.025436,  1.024511,  1.027139,  1.032639,  1.027457,  1.030852,  1.028928,  1.036498,  1.031756,  1.034157,  1.035322,  1.035915,  1.034294,  1.040992,  1.041024,  1.039070,  1.038118,  1.039140,  1.049501,  1.036692,  1.045453,  1.041361,  1.050658,  1.046927,  1.046405,  1.049794,  1.050833,  1.044674,  1.054852,  1.055321,  1.052635,  1.049718,  1.054254,  1.066244,  1.044901,  1.061082,  1.054699,  1.063083,  1.060090,  1.062893,  1.061506,  1.064543,  1.059213,  1.066379,  1.071574,  1.065038,  1.061853,  1.066543,  1.078760,  1.060719,  1.074860,  1.068201,  1.077688,  1.070474,  1.078773,  1.078861,  1.076617,  1.069589,  1.076560,  1.088489,  1.077017,  1.081089,  1.074917,  1.092818,  1.076663,  1.089147,  1.080740,  1.090406,  1.083057,  1.093847,  1.094241, },
{ 1.000000,  1.000804,  1.001508,  1.002492,  1.003986,  1.003949,  1.005114,  1.005729,  1.007779,  1.007281,  1.008500,  1.009527,  1.010534,  1.010167,  1.013045,  1.014022,  1.013361,  1.013729,  1.014437,  1.019379,  1.014648,  1.018424,  1.017358,  1.022260,  1.020385,  1.020989,  1.023239,  1.023624,  1.021211,  1.027375,  1.027297,  1.026566,  1.024812,  1.028023,  1.035314,  1.024297,  1.032612,  1.029444,  1.035059,  1.033622,  1.035372,  1.035134,  1.037924,  1.032804,  1.039778,  1.041983,  1.038838,  1.037350,  1.040450,  1.048263,  1.036374,  1.046111,  1.042611,  1.048561,  1.045443,  1.049587,  1.050093,  1.049063,  1.045040,  1.049671,  1.057872,  1.050302,  1.052646,  1.050660,  1.061672,  1.050943,  1.059289,  1.055634,  1.061453,  1.056009,  1.063388,  1.065887,  1.059463,  1.056838,  1.061827,  1.075173,  1.060830,  1.066259,  1.062875,  1.076501,  1.064032,  1.071465,  1.069003,  1.073381,  1.066511,  1.079184,  1.079950,  1.072431,  1.070252,  1.073389,  1.090125,  1.067284,  1.080806,  1.074290,  1.090548,  1.079432,  1.082970,  1.085514,  1.085166,  1.076953, },
{ 1.000000,  1.000901,  1.001703,  1.002453,  1.002883,  1.003989,  1.005892,  1.004332,  1.006858,  1.006642,  1.008737,  1.008865,  1.009936,  1.010211,  1.011777,  1.010673,  1.013656,  1.014862,  1.014438,  1.013987,  1.015605,  1.019659,  1.014527,  1.019441,  1.018477,  1.021562,  1.020426,  1.022889,  1.023474,  1.023345,  1.021587,  1.024518,  1.028778,  1.025765,  1.025751,  1.026577,  1.032737,  1.026998,  1.031921,  1.030150,  1.034104,  1.030027,  1.036635,  1.037485,  1.033241,  1.033116,  1.035975,  1.044392,  1.035757,  1.038763,  1.037888,  1.046396,  1.038340,  1.043714,  1.042853,  1.044901,  1.041730,  1.049602,  1.051327,  1.045358,  1.044625,  1.047579,  1.057681,  1.043706,  1.052368,  1.048211,  1.060143,  1.051468,  1.055094,  1.056224,  1.056988,  1.050868,  1.063914,  1.062286,  1.059800,  1.055072,  1.058859,  1.075819,  1.048788,  1.067227,  1.058622,  1.071766,  1.065159,  1.067879,  1.066743,  1.071727,  1.061542,  1.074952,  1.076189,  1.070900,  1.065315,  1.072382,  1.088338,  1.057955,  1.078876,  1.074316,  1.081622,  1.075677,  1.083626,  1.082235, },
{ 1.000000,  1.000674,  1.001258,  1.002034,  1.003165,  1.003379,  1.003962,  1.004735,  1.006527,  1.005449,  1.007472,  1.007243,  1.008988,  1.008166,  1.010770,  1.011680,  1.010389,  1.011076,  1.012338,  1.015921,  1.012958,  1.014183,  1.014750,  1.018149,  1.015495,  1.017865,  1.018370,  1.019301,  1.018441,  1.021650,  1.023669,  1.020464,  1.020435,  1.022909,  1.027633,  1.020854,  1.025742,  1.024160,  1.031415,  1.024742,  1.028718,  1.029806,  1.028820,  1.026805,  1.034835,  1.034244,  1.032211,  1.030145,  1.031525,  1.043139,  1.026883,  1.037479,  1.034036,  1.041255,  1.037175,  1.039513,  1.038703,  1.041448,  1.036403,  1.044684,  1.046460,  1.042770,  1.038225,  1.043380,  1.056197,  1.032308,  1.048504,  1.047140,  1.049939,  1.047839,  1.051634,  1.051658,  1.050623,  1.046455,  1.052183,  1.058788,  1.051558,  1.049950,  1.052590,  1.064936,  1.048900,  1.059590,  1.054337,  1.062295,  1.054492,  1.064996,  1.067039,  1.057565,  1.054244,  1.061446,  1.076116,  1.057553,  1.062235,  1.064216,  1.071832,  1.061694,  1.069035,  1.068009,  1.071055,  1.063434, },
{ 1.000000,  1.000714,  1.001449,  1.001789,  1.002212,  1.003168,  1.004592,  1.003668,  1.005475,  1.005289,  1.007618,  1.006412,  1.007643,  1.008668,  1.008901,  1.008153,  1.012041,  1.011713,  1.011372,  1.011206,  1.011759,  1.016865,  1.010486,  1.015556,  1.014305,  1.018257,  1.016035,  1.017322,  1.018107,  1.018803,  1.017073,  1.021541,  1.022984,  1.021128,  1.018764,  1.022682,  1.028228,  1.016175,  1.025744,  1.024577,  1.027595,  1.026305,  1.027628,  1.028851,  1.028172,  1.025761,  1.029768,  1.035008,  1.028601,  1.028182,  1.031191,  1.038745,  1.027987,  1.036041,  1.033493,  1.036387,  1.033903,  1.039040,  1.041681,  1.036392,  1.033569,  1.038236,  1.047553,  1.036951,  1.038978,  1.040136,  1.046579,  1.038326,  1.046197,  1.043788,  1.045459,  1.041959,  1.049913,  1.054046,  1.044281,  1.041259,  1.048315,  1.058078,  1.042962,  1.052935,  1.046899,  1.060787,  1.047998,  1.053164,  1.055565,  1.053705,  1.047178,  1.064779,  1.062168,  1.054542,  1.053044,  1.054752,  1.073315,  1.045920,  1.064003,  1.054785,  1.069421,  1.062051,  1.060968,  1.064886, },
{ 1.000000,  1.000549,  1.001006,  1.001877,  1.002539,  1.002818,  1.002937,  1.004034,  1.005712,  1.003316,  1.006033,  1.006007,  1.007405,  1.007300,  1.008159,  1.008771,  1.009017,  1.008450,  1.010648,  1.012770,  1.010507,  1.010266,  1.012076,  1.015704,  1.010770,  1.015539,  1.014229,  1.015795,  1.014938,  1.017975,  1.018920,  1.016903,  1.015269,  1.018406,  1.023263,  1.017634,  1.019972,  1.019741,  1.024361,  1.018748,  1.024349,  1.023578,  1.023926,  1.021630,  1.028303,  1.029294,  1.023994,  1.022496,  1.026815,  1.033524,  1.024033,  1.029760,  1.026672,  1.035021,  1.028021,  1.030852,  1.034245,  1.030247,  1.029178,  1.038763,  1.038515,  1.032499,  1.031389,  1.033754,  1.045432,  1.026879,  1.040244,  1.034315,  1.043512,  1.039062,  1.037623,  1.043948,  1.040046,  1.033779,  1.048332,  1.047323,  1.041370,  1.038260,  1.044333,  1.057201,  1.028318,  1.051869,  1.043769,  1.049738,  1.046937,  1.050855,  1.049733,  1.048626,  1.044232,  1.053579,  1.058839,  1.048069,  1.045710,  1.051895,  1.063648,  1.040317,  1.059804,  1.053709,  1.058203,  1.051888, },
{ 1.000000,  1.000543,  1.001095,  1.001339,  1.001619,  1.002493,  1.003601,  1.002990,  1.003981,  1.003912,  1.005716,  1.004374,  1.006573,  1.006333,  1.006871,  1.006816,  1.009002,  1.009587,  1.007810,  1.007701,  1.009588,  1.012889,  1.009014,  1.011535,  1.011159,  1.014372,  1.011429,  1.012945,  1.015040,  1.013557,  1.012393,  1.018041,  1.018778,  1.014405,  1.014670,  1.016086,  1.022704,  1.012844,  1.020000,  1.017144,  1.022608,  1.020013,  1.019502,  1.023774,  1.020264,  1.017489,  1.027650,  1.025548,  1.022643,  1.019815,  1.025061,  1.032777,  1.015627,  1.029848,  1.024487,  1.028449,  1.027673,  1.029680,  1.029475,  1.028811,  1.023957,  1.033729,  1.035000,  1.028810,  1.027432,  1.032231,  1.038600,  1.022473,  1.037911,  1.033302,  1.035179,  1.033828,  1.039515,  1.039647,  1.033633,  1.030623,  1.037205,  1.045953,  1.033746,  1.038639,  1.036482,  1.045801,  1.032884,  1.044330,  1.041867,  1.041856,  1.038688,  1.047783,  1.050479,  1.038609,  1.036302,  1.044768,  1.057130,  1.038011,  1.046758,  1.043611,  1.055136,  1.041484,  1.050291,  1.050177, },
{ 1.000000,  1.000357,  1.000680,  1.001453,  1.001925,  1.001710,  1.002006,  1.002724,  1.004082,  1.002362,  1.004364,  1.003948,  1.005544,  1.005041,  1.005471,  1.006831,  1.005735,  1.005481,  1.008582,  1.008747,  1.007550,  1.006722,  1.009125,  1.012597,  1.004704,  1.011755,  1.009365,  1.011601,  1.011558,  1.011970,  1.012228,  1.012206,  1.010094,  1.015343,  1.015788,  1.013189,  1.011759,  1.015000,  1.018618,  1.009317,  1.018158,  1.016163,  1.017150,  1.017209,  1.019463,  1.020284,  1.016653,  1.015258,  1.019406,  1.023967,  1.018027,  1.018148,  1.020089,  1.024682,  1.016972,  1.024204,  1.022447,  1.022867,  1.020065,  1.027880,  1.028618,  1.019979,  1.020489,  1.025212,  1.033176,  1.021074,  1.025649,  1.025729,  1.031716,  1.023043,  1.029248,  1.029537,  1.026895,  1.025531,  1.034788,  1.036923,  1.025792,  1.026188,  1.031188,  1.039190,  1.021922,  1.034718,  1.029422,  1.038397,  1.031944,  1.033513,  1.037502,  1.032204,  1.027855,  1.044338,  1.040379,  1.034989,  1.030627,  1.036349,  1.051129,  1.019663,  1.044722,  1.034156,  1.042911,  1.040554, },
{ 1.000000,  1.000319,  1.000655,  1.000900,  1.000916,  1.001892,  1.002251,  1.001995,  1.001806,  1.003035,  1.004211,  1.001270,  1.004197,  1.004288,  1.004190,  1.004711,  1.005660,  1.006093,  1.004867,  1.004516,  1.006017,  1.008754,  1.005786,  1.005960,  1.007542,  1.009676,  1.005419,  1.009609,  1.008138,  1.009140,  1.007752,  1.011403,  1.012934,  1.007783,  1.008553,  1.010695,  1.015749,  1.008872,  1.010504,  1.012038,  1.014414,  1.010356,  1.013180,  1.014682,  1.012528,  1.012632,  1.015973,  1.019760,  1.011508,  1.011978,  1.015790,  1.020376,  1.009714,  1.017532,  1.015294,  1.021621,  1.014433,  1.017344,  1.021179,  1.015156,  1.014107,  1.024813,  1.023450,  1.017986,  1.015876,  1.018762,  1.030054,  1.008638,  1.024092,  1.019396,  1.024179,  1.022981,  1.021755,  1.024087,  1.021361,  1.017778,  1.028860,  1.029834,  1.022927,  1.016664,  1.026190,  1.036519,  1.007284,  1.028700,  1.028578,  1.025189,  1.028068,  1.029440,  1.031361,  1.024175,  1.022083,  1.028914,  1.036535,  1.025310,  1.022940,  1.029763,  1.037484,  1.020531,  1.033765,  1.029699, },
{ 1.000000,  1.000212,  1.000390,  1.000775,  1.001211,  1.000685,  1.000760,  1.001490,  1.002690,  1.001117,  1.001782,  1.002506,  1.002692,  1.002140,  1.003073,  1.003435,  1.002971,  1.003042,  1.004567,  1.006252,  1.002537,  1.002844,  1.004806,  1.006889,  1.002040,  1.006466,  1.004530,  1.007544,  1.004721,  1.005618,  1.007569,  1.005076,  1.004040,  1.010751,  1.008870,  1.006327,  1.005657,  1.006886,  1.012569,  1.001441,  1.010289,  1.007569,  1.010545,  1.009428,  1.008520,  1.010622,  1.007901,  1.007072,  1.012974,  1.014316,  1.009769,  1.005582,  1.013134,  1.016288,  0.999819,  1.013728,  1.012627,  1.011794,  1.014100,  1.012879,  1.015185,  1.010277,  1.009189,  1.013918,  1.019842,  1.009805,  1.008907,  1.015221,  1.018946,  1.007639,  1.017359,  1.015130,  1.012979,  1.015387,  1.017757,  1.022580,  1.011418,  1.010488,  1.016078,  1.025657,  1.011581,  1.014023,  1.017434,  1.018891,  1.012765,  1.020618,  1.018876,  1.015373,  1.016493,  1.022355,  1.029441,  1.012044,  1.011876,  1.020234,  1.027586,  1.010812,  1.023164,  1.017477,  1.026236,  1.017234, },
{ 1.000000,  1.000082,  1.000275,  1.000159,  1.000087,  1.001015,  1.001081,  1.000319,  1.000346,  1.000851,  1.002121,  0.999365,  1.001832,  1.000716,  1.001777,  1.001981,  1.001096,  1.002328,  1.001044,  1.000466,  1.003338,  1.003947,  1.001750,  1.000256,  1.003248,  1.005106,  0.997364,  1.003463,  1.003037,  1.003032,  1.003853,  1.003337,  1.004157,  1.002260,  1.001160,  1.004361,  1.007510,  1.001696,  1.000403,  1.004408,  1.006868,  0.999480,  1.006303,  1.004150,  1.003396,  1.004734,  1.006140,  1.008464,  1.002561,  1.000800,  1.004602,  1.010871,  1.001744,  1.003994,  1.005021,  1.007271,  1.001487,  1.007485,  1.006985,  1.004334,  1.003860,  1.009716,  1.012397,  1.001746,  1.001226,  1.006386,  1.013239,  1.000719,  1.007628,  1.004904,  1.010378,  1.004767,  1.006013,  1.011447,  1.003095,  1.003800,  1.013709,  1.014414,  1.003764,  1.002837,  1.007451,  1.016845,  0.995217,  1.012309,  1.005159,  1.010944,  1.010975,  1.005182,  1.014573,  1.005087,  1.000362,  1.016991,  1.016466,  1.005567,  1.001847,  1.012683,  1.020930,  0.988651,  1.016654,  1.008822, },
{ 1.000000,  0.999965,  1.000016,  0.999988,  1.000024,  0.999700,  0.999487,  1.000099,  1.000613,  0.999298,  0.998948,  1.000023,  1.000645,  0.997871,  1.000543,  0.999676,  0.999332,  0.999731,  1.000480,  1.000973,  0.998509,  0.997689,  0.999529,  1.002103,  0.997892,  0.999373,  0.998425,  1.001029,  0.996858,  1.000739,  0.999350,  0.998638,  0.999240,  1.001135,  1.002116,  0.996594,  0.996251,  0.998803,  1.003585,  0.995787,  0.999393,  0.998602,  1.001241,  0.997249,  0.998095,  1.001351,  0.997463,  0.996185,  1.002668,  1.004320,  0.995363,  0.995582,  0.998216,  1.005028,  0.990729,  1.001013,  0.996266,  1.000800,  1.000243,  0.996712,  1.002836,  0.995338,  0.992734,  1.005088,  1.003189,  0.995843,  0.992492,  1.001051,  1.006941,  0.984676,  1.003421,  0.996702,  0.998100,  1.000796,  0.999724,  1.000302,  0.996213,  0.991840,  1.002671,  1.005065,  0.994493,  0.991881,  1.000918,  1.003694,  0.985212,  1.003472,  0.998083,  0.996155,  1.000442,  1.001633,  1.003774,  0.993038,  0.990665,  0.997600,  1.008005,  0.992235,  0.996288,  0.996277,  1.002449,  0.989458, },
{ 1.000000,  0.999882,  0.999705,  0.999472,  0.999341,  0.999420,  0.999605,  0.998387,  0.998032,  0.998655,  0.999726,  0.997184,  0.998150,  0.997747,  0.998634,  0.996701,  0.997800,  0.997589,  0.996679,  0.996258,  0.998161,  0.998746,  0.995152,  0.994684,  0.996419,  0.998818,  0.991962,  0.996965,  0.994506,  0.996518,  0.995494,  0.994923,  0.996748,  0.993029,  0.992224,  0.997082,  0.997214,  0.992819,  0.990842,  0.995068,  0.999360,  0.984627,  0.996347,  0.991893,  0.993608,  0.994723,  0.993053,  0.993303,  0.991419,  0.988198,  0.995804,  0.996075,  0.989842,  0.986886,  0.993224,  0.995963,  0.981676,  0.994189,  0.990778,  0.990163,  0.992714,  0.992151,  0.993815,  0.987252,  0.984700,  0.990660,  0.995766,  0.986498,  0.985584,  0.989258,  0.993184,  0.982312,  0.991680,  0.988597,  0.987849,  0.986142,  0.992622,  0.994669,  0.981355,  0.982125,  0.987439,  0.997672,  0.980045,  0.985902,  0.986425,  0.991455,  0.980504,  0.988159,  0.987428,  0.982984,  0.983474,  0.990392,  0.995440,  0.979110,  0.978889,  0.986342,  0.994262,  0.971356,  0.987934,  0.980890, },
{ 1.000000,  0.999744,  0.999384,  0.999069,  0.998974,  0.998321,  0.997712,  0.998648,  0.998106,  0.997060,  0.996278,  0.996862,  0.998152,  0.993264,  0.996787,  0.994953,  0.995603,  0.995394,  0.994547,  0.994871,  0.993520,  0.991968,  0.995491,  0.994792,  0.991698,  0.990040,  0.993664,  0.995106,  0.985662,  0.992570,  0.991752,  0.990037,  0.991151,  0.991639,  0.991482,  0.987890,  0.986270,  0.989384,  0.992716,  0.985989,  0.985763,  0.988625,  0.990811,  0.982113,  0.989238,  0.985309,  0.986482,  0.984183,  0.988505,  0.989991,  0.980925,  0.981366,  0.984969,  0.991254,  0.979160,  0.981925,  0.983733,  0.985653,  0.978641,  0.983112,  0.983479,  0.980079,  0.980836,  0.983218,  0.988240,  0.975530,  0.975020,  0.981834,  0.986367,  0.969351,  0.980958,  0.977616,  0.983760,  0.974546,  0.977823,  0.981507,  0.972767,  0.971000,  0.985372,  0.982538,  0.972797,  0.969996,  0.975618,  0.987553,  0.957692,  0.978786,  0.972303,  0.976087,  0.976303,  0.972966,  0.975254,  0.969379,  0.965346,  0.980746,  0.979713,  0.968653,  0.960162,  0.975407,  0.985467,  0.946212, },
{ 1.000000,  0.999540,  0.999110,  0.998466,  0.998154,  0.997725,  0.997373,  0.996216,  0.995461,  0.995908,  0.996037,  0.993980,  0.993214,  0.993961,  0.994324,  0.990819,  0.992906,  0.991430,  0.991200,  0.990345,  0.991405,  0.991815,  0.987378,  0.986590,  0.988788,  0.991525,  0.984306,  0.985962,  0.987047,  0.986591,  0.983268,  0.985485,  0.984906,  0.983139,  0.982563,  0.984581,  0.986786,  0.978709,  0.977715,  0.982139,  0.985224,  0.973109,  0.981888,  0.977693,  0.981974,  0.975637,  0.977004,  0.979488,  0.974088,  0.971424,  0.982270,  0.978119,  0.972444,  0.970436,  0.973338,  0.981119,  0.960432,  0.975300,  0.970940,  0.973797,  0.971109,  0.969385,  0.971845,  0.966080,  0.964306,  0.973621,  0.974054,  0.965336,  0.958115,  0.971268,  0.974252,  0.946890,  0.968103,  0.966371,  0.964026,  0.965802,  0.963554,  0.966369,  0.958195,  0.955076,  0.963877,  0.969915,  0.952649,  0.952537,  0.961938,  0.965167,  0.947226,  0.961556,  0.957154,  0.954076,  0.956244,  0.959051,  0.964040,  0.947946,  0.946015,  0.955055,  0.966165,  0.943798,  0.947969,  0.953136, },
{ 1.000000,  0.999372,  0.998438,  0.998114,  0.997323,  0.996491,  0.995831,  0.995604,  0.995513,  0.993133,  0.992182,  0.992925,  0.993245,  0.989225,  0.991182,  0.989517,  0.990338,  0.987368,  0.987665,  0.987992,  0.985582,  0.983880,  0.987894,  0.986036,  0.982380,  0.981179,  0.982842,  0.985533,  0.975279,  0.982266,  0.978454,  0.980171,  0.978798,  0.976941,  0.978370,  0.974550,  0.972505,  0.978389,  0.977673,  0.972364,  0.968228,  0.974801,  0.977123,  0.959921,  0.971663,  0.970586,  0.969632,  0.969147,  0.968157,  0.968390,  0.964293,  0.961141,  0.967777,  0.970545,  0.958677,  0.957485,  0.963593,  0.966027,  0.952585,  0.963523,  0.959089,  0.957701,  0.957904,  0.960358,  0.961745,  0.952440,  0.948690,  0.955599,  0.962732,  0.946828,  0.950751,  0.951889,  0.954908,  0.942694,  0.953352,  0.950698,  0.946906,  0.944940,  0.953195,  0.953349,  0.939839,  0.936528,  0.946233,  0.954936,  0.931326,  0.944804,  0.939439,  0.947345,  0.934530,  0.939209,  0.944471,  0.933301,  0.932313,  0.945963,  0.944032,  0.930600,  0.926715,  0.936047,  0.946860,  0.912330, },
{ 1.000000,  0.999208,  0.998227,  0.997538,  0.996636,  0.995624,  0.995330,  0.993666,  0.992256,  0.993336,  0.992269,  0.989985,  0.988501,  0.989784,  0.990109,  0.983106,  0.987520,  0.985538,  0.984770,  0.984059,  0.983426,  0.982814,  0.980243,  0.978560,  0.981070,  0.981396,  0.975480,  0.974390,  0.977272,  0.977897,  0.969070,  0.975545,  0.972963,  0.971388,  0.970603,  0.972538,  0.971757,  0.966019,  0.963696,  0.967688,  0.970876,  0.961051,  0.963821,  0.962215,  0.965715,  0.955870,  0.963596,  0.960027,  0.958246,  0.957433,  0.961213,  0.960204,  0.951438,  0.949216,  0.954491,  0.961114,  0.944543,  0.952276,  0.950331,  0.954042,  0.943866,  0.947331,  0.950793,  0.944212,  0.940922,  0.950484,  0.950378,  0.937786,  0.936387,  0.941796,  0.950320,  0.924872,  0.942286,  0.935329,  0.940576,  0.935855,  0.933506,  0.940000,  0.928680,  0.923674,  0.942145,  0.936392,  0.925595,  0.919493,  0.933820,  0.939937,  0.905598,  0.931785,  0.923938,  0.925028,  0.924663,  0.924550,  0.924478,  0.917314,  0.910106,  0.927514,  0.927290,  0.909640,  0.906878,  0.920201, },
{ 1.000000,  0.999099,  0.997557,  0.997166,  0.995969,  0.994841,  0.993899,  0.993283,  0.992331,  0.990187,  0.988832,  0.989070,  0.989147,  0.985514,  0.985321,  0.984734,  0.984635,  0.980500,  0.982462,  0.980932,  0.979343,  0.978070,  0.978899,  0.978331,  0.973464,  0.971634,  0.974322,  0.976340,  0.967304,  0.970679,  0.969289,  0.970552,  0.964029,  0.967288,  0.966105,  0.963084,  0.961325,  0.965271,  0.964478,  0.957311,  0.955373,  0.959526,  0.962405,  0.947190,  0.957625,  0.952623,  0.955497,  0.950655,  0.951559,  0.952661,  0.945679,  0.943218,  0.952205,  0.949461,  0.942205,  0.937777,  0.945877,  0.950778,  0.925121,  0.944336,  0.937566,  0.938708,  0.937759,  0.936780,  0.935829,  0.931140,  0.926129,  0.938750,  0.935888,  0.925022,  0.920847,  0.930544,  0.933660,  0.910182,  0.928968,  0.924279,  0.921902,  0.922287,  0.923935,  0.923835,  0.913339,  0.909538,  0.919582,  0.923254,  0.907692,  0.907645,  0.913795,  0.916403,  0.899369,  0.913444,  0.908596,  0.907019,  0.901668,  0.912527,  0.911286,  0.894161,  0.893262,  0.903175,  0.914073,  0.885976, },
{ 1.000000,  0.998820,  0.997681,  0.996684,  0.994838,  0.994298,  0.993112,  0.991472,  0.990310,  0.990035,  0.989235,  0.986103,  0.984686,  0.985299,  0.985088,  0.979319,  0.981886,  0.979544,  0.979864,  0.976604,  0.976751,  0.976093,  0.973043,  0.970570,  0.974860,  0.971933,  0.968286,  0.965700,  0.967964,  0.970375,  0.956701,  0.965940,  0.961575,  0.961996,  0.959892,  0.959083,  0.958838,  0.954758,  0.951762,  0.958711,  0.955533,  0.948851,  0.945665,  0.952190,  0.953631,  0.935729,  0.948252,  0.946361,  0.942497,  0.942054,  0.944095,  0.942679,  0.935415,  0.932746,  0.938122,  0.941035,  0.929041,  0.929178,  0.933885,  0.935324,  0.920163,  0.932451,  0.925024,  0.926402,  0.920752,  0.928556,  0.928065,  0.914605,  0.914271,  0.920677,  0.927361,  0.907642,  0.913273,  0.915670,  0.916870,  0.903292,  0.912616,  0.911416,  0.905653,  0.905048,  0.909411,  0.913313,  0.895879,  0.893960,  0.905592,  0.909180,  0.881783,  0.901100,  0.895171,  0.904090,  0.884957,  0.894828,  0.896445,  0.883773,  0.880360,  0.901120,  0.893550,  0.880514,  0.875639,  0.885585, },
{ 1.000000,  0.998877,  0.996832,  0.996259,  0.994686,  0.993548,  0.992068,  0.990847,  0.989592,  0.987669,  0.985912,  0.986806,  0.985018,  0.982280,  0.979591,  0.981172,  0.981520,  0.972592,  0.977125,  0.975847,  0.973247,  0.972344,  0.971880,  0.970860,  0.966812,  0.964720,  0.967111,  0.966706,  0.960830,  0.959291,  0.961740,  0.961646,  0.952882,  0.958468,  0.954564,  0.953914,  0.951084,  0.953894,  0.953470,  0.944533,  0.943096,  0.947610,  0.950874,  0.937056,  0.940644,  0.942766,  0.940459,  0.933063,  0.938457,  0.936247,  0.932808,  0.930716,  0.934579,  0.936197,  0.923478,  0.921126,  0.929208,  0.932033,  0.911199,  0.926096,  0.919784,  0.925477,  0.912283,  0.917312,  0.919003,  0.910297,  0.905586,  0.921551,  0.914121,  0.905023,  0.902079,  0.907376,  0.915796,  0.884900,  0.907231,  0.901479,  0.903274,  0.896341,  0.897511,  0.898374,  0.889470,  0.886553,  0.900685,  0.897924,  0.885359,  0.875553,  0.894700,  0.895692,  0.857924,  0.887532,  0.884822,  0.880614,  0.879421,  0.878724,  0.881192,  0.868878,  0.864849,  0.877613,  0.881879,  0.858100, },
{ 1.000000,  0.998440,  0.997187,  0.995906,  0.993606,  0.993054,  0.991312,  0.989619,  0.988188,  0.987481,  0.986465,  0.983032,  0.981469,  0.981612,  0.981494,  0.976475,  0.976059,  0.976026,  0.974354,  0.970015,  0.972249,  0.969794,  0.967290,  0.965949,  0.966602,  0.966517,  0.959643,  0.957645,  0.961019,  0.961397,  0.950654,  0.956659,  0.953371,  0.954777,  0.947233,  0.949330,  0.949604,  0.944274,  0.940824,  0.948721,  0.944798,  0.937446,  0.935321,  0.939439,  0.942410,  0.923586,  0.936833,  0.930712,  0.931892,  0.928249,  0.926976,  0.928314,  0.921106,  0.917944,  0.927888,  0.924831,  0.915894,  0.909489,  0.921164,  0.922102,  0.895561,  0.913885,  0.912313,  0.909571,  0.907291,  0.906967,  0.906579,  0.899278,  0.894926,  0.905384,  0.906755,  0.888699,  0.887988,  0.897650,  0.897891,  0.878858,  0.894655,  0.888532,  0.885149,  0.883695,  0.888690,  0.889123,  0.875157,  0.870535,  0.880991,  0.887175,  0.865009,  0.871223,  0.874323,  0.874773,  0.856690,  0.873475,  0.868894,  0.862355,  0.858598,  0.870910,  0.868364,  0.850597,  0.846019,  0.860710, },
{ 1.000000,  0.998572,  0.996410,  0.995326,  0.993635,  0.992485,  0.989784,  0.988953,  0.987853,  0.985037,  0.983322,  0.983728,  0.981975,  0.978398,  0.976354,  0.976890,  0.976810,  0.968615,  0.972766,  0.969636,  0.968882,  0.966235,  0.964644,  0.965358,  0.960244,  0.957156,  0.962088,  0.959282,  0.953493,  0.950368,  0.955128,  0.955172,  0.939451,  0.950182,  0.946515,  0.944556,  0.942734,  0.942246,  0.941163,  0.935712,  0.933027,  0.938199,  0.937856,  0.926772,  0.925530,  0.931309,  0.930771,  0.915808,  0.927125,  0.923016,  0.919624,  0.917643,  0.921446,  0.919532,  0.909763,  0.906623,  0.913428,  0.916387,  0.900931,  0.905538,  0.904238,  0.907082,  0.891934,  0.904566,  0.898822,  0.895330,  0.893065,  0.899688,  0.896658,  0.883887,  0.880584,  0.889213,  0.896307,  0.871637,  0.883873,  0.881976,  0.884799,  0.869096,  0.876102,  0.879830,  0.869709,  0.864536,  0.877775,  0.876805,  0.858860,  0.857075,  0.866024,  0.874406,  0.838570,  0.864359,  0.855536,  0.859405,  0.851597,  0.851111,  0.858323,  0.841871,  0.835435,  0.860164,  0.850711,  0.835603, },
{ 1.000000,  0.998112,  0.996695,  0.995193,  0.991978,  0.991739,  0.989604,  0.987877,  0.986100,  0.984613,  0.983000,  0.980358,  0.977831,  0.978876,  0.977080,  0.972324,  0.970414,  0.971672,  0.970362,  0.962728,  0.966718,  0.964032,  0.961289,  0.959849,  0.959903,  0.958405,  0.952642,  0.950411,  0.952547,  0.952956,  0.944460,  0.945240,  0.944956,  0.944567,  0.935859,  0.941260,  0.938267,  0.935194,  0.932551,  0.935159,  0.933714,  0.924916,  0.921825,  0.927539,  0.929985,  0.913941,  0.920775,  0.919161,  0.919761,  0.908738,  0.915089,  0.913170,  0.907479,  0.904480,  0.911207,  0.909496,  0.897902,  0.895176,  0.902422,  0.905019,  0.881155,  0.898525,  0.891030,  0.894007,  0.885619,  0.888703,  0.889330,  0.878454,  0.874825,  0.888368,  0.883246,  0.872242,  0.866188,  0.878686,  0.883198,  0.847282,  0.874771,  0.865574,  0.865276,  0.863230,  0.863028,  0.861368,  0.853364,  0.847436,  0.864393,  0.859308,  0.843274,  0.838632,  0.852450,  0.854313,  0.822576,  0.848382,  0.842292,  0.837621,  0.836323,  0.840397,  0.839148,  0.824363,  0.819862,  0.833718, },
{ 1.000000,  0.998254,  0.996119,  0.994172,  0.992706,  0.990946,  0.988003,  0.987335,  0.985196,  0.983216,  0.980751,  0.980522,  0.978577,  0.974399,  0.972558,  0.972620,  0.972519,  0.965576,  0.966415,  0.965144,  0.963975,  0.957945,  0.959952,  0.957919,  0.953979,  0.952244,  0.953479,  0.952538,  0.945125,  0.942976,  0.946224,  0.945814,  0.932938,  0.940459,  0.936234,  0.936880,  0.930187,  0.932071,  0.930908,  0.925157,  0.920845,  0.929426,  0.924227,  0.917432,  0.913582,  0.918425,  0.921399,  0.898637,  0.914694,  0.908012,  0.907915,  0.904249,  0.903936,  0.903535,  0.896207,  0.892425,  0.902915,  0.897774,  0.886824,  0.882905,  0.893279,  0.893459,  0.867591,  0.886407,  0.883815,  0.877266,  0.875572,  0.879723,  0.877488,  0.866037,  0.862841,  0.870831,  0.873406,  0.856112,  0.857236,  0.864514,  0.864067,  0.843234,  0.860938,  0.850522,  0.851619,  0.842924,  0.854620,  0.852839,  0.834353,  0.834111,  0.843320,  0.849910,  0.823154,  0.832116,  0.835841,  0.834792,  0.816121,  0.830095,  0.828094,  0.819490,  0.817731,  0.824497,  0.828273,  0.805234, },
{ 1.000000,  0.997859,  0.996206,  0.994354,  0.991054,  0.990347,  0.988043,  0.986726,  0.982962,  0.982397,  0.980624,  0.977076,  0.974792,  0.976044,  0.973057,  0.969038,  0.966497,  0.966813,  0.966945,  0.956637,  0.961542,  0.958200,  0.956545,  0.953849,  0.952458,  0.950845,  0.946421,  0.943758,  0.947757,  0.944422,  0.938400,  0.933376,  0.938805,  0.939444,  0.921285,  0.932098,  0.930327,  0.925317,  0.923806,  0.924055,  0.922661,  0.915001,  0.912219,  0.917061,  0.915983,  0.905880,  0.904161,  0.909142,  0.907782,  0.893802,  0.903723,  0.897634,  0.896179,  0.891410,  0.896716,  0.895911,  0.881568,  0.880298,  0.887556,  0.891083,  0.870168,  0.876727,  0.880395,  0.875287,  0.864194,  0.873427,  0.869884,  0.864238,  0.860938,  0.867187,  0.868837,  0.850474,  0.847469,  0.859642,  0.861909,  0.832047,  0.854165,  0.845965,  0.852039,  0.833170,  0.841604,  0.843379,  0.830496,  0.824261,  0.845755,  0.835685,  0.822103,  0.819110,  0.827156,  0.835768,  0.794510,  0.825484,  0.818185,  0.818188,  0.808513,  0.811820,  0.812202,  0.799013,  0.796250,  0.814100, },
{ 1.000000,  0.997983,  0.995648,  0.993204,  0.992035,  0.990037,  0.985386,  0.985695,  0.983439,  0.980928,  0.978740,  0.976910,  0.975367,  0.971470,  0.969069,  0.969330,  0.967969,  0.961669,  0.960216,  0.961286,  0.958957,  0.952003,  0.955038,  0.951435,  0.948330,  0.946196,  0.946653,  0.945582,  0.937698,  0.935894,  0.938022,  0.938508,  0.927825,  0.928718,  0.930024,  0.926625,  0.918525,  0.924630,  0.920097,  0.915747,  0.913745,  0.916050,  0.916055,  0.904087,  0.901371,  0.908139,  0.908316,  0.889991,  0.901539,  0.896702,  0.898172,  0.885856,  0.890564,  0.891016,  0.882307,  0.877305,  0.889430,  0.883696,  0.872051,  0.869614,  0.876676,  0.879734,  0.851459,  0.872404,  0.863801,  0.864188,  0.858602,  0.858169,  0.859686,  0.848425,  0.844739,  0.858604,  0.854173,  0.840789,  0.832449,  0.849719,  0.848967,  0.812589,  0.838669,  0.836709,  0.831667,  0.828024,  0.828598,  0.827919,  0.816888,  0.811861,  0.825964,  0.826381,  0.801456,  0.802223,  0.815586,  0.813068,  0.788684,  0.809892,  0.802042,  0.796484,  0.793778,  0.801320,  0.801465,  0.782036, },
{ 1.000000,  0.997707,  0.995614,  0.993697,  0.990588,  0.988705,  0.986908,  0.984718,  0.980836,  0.980655,  0.978012,  0.975098,  0.972516,  0.972383,  0.969985,  0.965090,  0.962303,  0.963182,  0.962448,  0.953656,  0.956419,  0.953392,  0.952697,  0.945828,  0.947051,  0.946162,  0.940143,  0.937463,  0.940842,  0.938029,  0.930710,  0.927721,  0.930771,  0.930965,  0.914604,  0.925185,  0.919809,  0.918682,  0.914239,  0.912577,  0.914533,  0.905529,  0.900973,  0.910093,  0.905874,  0.895916,  0.891592,  0.900470,  0.899905,  0.874860,  0.892957,  0.887737,  0.884322,  0.881332,  0.881413,  0.880255,  0.871328,  0.868058,  0.876325,  0.875207,  0.858262,  0.857641,  0.866855,  0.864585,  0.843286,  0.860226,  0.854745,  0.849125,  0.846066,  0.852396,  0.849438,  0.835075,  0.831656,  0.841431,  0.844211,  0.822673,  0.830032,  0.829042,  0.830831,  0.810172,  0.828699,  0.820611,  0.815202,  0.811679,  0.821655,  0.816790,  0.799355,  0.795698,  0.807548,  0.815305,  0.781955,  0.799873,  0.797756,  0.799378,  0.778401,  0.789189,  0.793422,  0.779478,  0.772759,  0.789694, },
{ 1.000000,  0.997724,  0.995160,  0.992695,  0.990795,  0.988948,  0.984280,  0.984158,  0.981176,  0.979168,  0.976175,  0.974142,  0.972886,  0.968262,  0.965309,  0.967150,  0.963559,  0.958653,  0.955223,  0.957544,  0.955859,  0.944407,  0.950298,  0.946186,  0.943566,  0.941179,  0.939874,  0.937858,  0.932409,  0.928604,  0.933130,  0.930421,  0.920896,  0.918808,  0.923153,  0.920695,  0.906745,  0.915997,  0.911947,  0.907312,  0.905422,  0.906832,  0.904607,  0.894793,  0.892278,  0.896718,  0.897190,  0.883654,  0.886067,  0.886475,  0.885044,  0.871769,  0.881405,  0.876945,  0.872177,  0.868361,  0.873322,  0.870774,  0.857652,  0.853903,  0.862915,  0.865714,  0.842301,  0.853533,  0.851584,  0.851171,  0.835670,  0.845827,  0.843150,  0.834624,  0.830568,  0.840383,  0.837812,  0.821409,  0.818513,  0.829131,  0.831174,  0.798397,  0.823594,  0.813444,  0.816203,  0.804682,  0.810263,  0.810544,  0.795432,  0.790980,  0.809043,  0.802018,  0.786768,  0.779827,  0.796744,  0.800629,  0.754219,  0.790885,  0.779115,  0.777186,  0.774447,  0.775251,  0.772974,  0.761240, },
{ 1.000000,  0.997441,  0.995352,  0.992904,  0.989631,  0.987001,  0.985622,  0.983371,  0.978203,  0.978507,  0.975543,  0.972609,  0.970116,  0.968720,  0.966345,  0.961657,  0.958829,  0.959101,  0.957206,  0.950762,  0.949186,  0.949332,  0.946554,  0.939580,  0.942257,  0.938616,  0.935546,  0.931197,  0.933828,  0.930782,  0.922203,  0.920141,  0.922514,  0.923347,  0.909768,  0.913576,  0.912719,  0.910649,  0.900051,  0.905498,  0.902826,  0.896222,  0.893969,  0.897100,  0.896030,  0.883893,  0.881397,  0.887896,  0.886846,  0.866362,  0.879928,  0.873707,  0.874360,  0.864250,  0.868566,  0.866762,  0.857892,  0.852090,  0.865438,  0.857929,  0.847461,  0.843015,  0.850858,  0.853878,  0.821479,  0.845639,  0.836518,  0.835477,  0.830346,  0.831140,  0.830448,  0.819461,  0.815329,  0.829501,  0.822755,  0.806850,  0.802641,  0.817266,  0.815872,  0.781848,  0.807592,  0.804420,  0.795073,  0.792071,  0.798719,  0.795622,  0.779867,  0.776478,  0.787219,  0.789300,  0.766434,  0.769178,  0.779172,  0.776342,  0.750225,  0.773681,  0.760176,  0.760752,  0.749132,  0.765349, },
{ 1.000000,  0.997441,  0.994581,  0.991895,  0.989744,  0.987572,  0.983328,  0.981566,  0.979503,  0.976910,  0.972275,  0.971715,  0.969179,  0.965471,  0.962739,  0.961688,  0.960095,  0.953532,  0.950853,  0.952158,  0.949999,  0.939575,  0.943899,  0.940088,  0.939676,  0.930976,  0.933253,  0.931103,  0.924130,  0.920708,  0.926497,  0.921373,  0.913521,  0.910353,  0.913158,  0.914146,  0.894664,  0.906360,  0.901268,  0.898480,  0.894692,  0.893715,  0.891497,  0.884317,  0.881103,  0.888443,  0.883519,  0.873876,  0.866842,  0.876725,  0.877254,  0.849310,  0.867143,  0.865069,  0.857423,  0.855002,  0.856587,  0.854929,  0.843298,  0.839872,  0.847854,  0.845872,  0.830906,  0.829568,  0.837808,  0.834324,  0.815033,  0.830125,  0.821647,  0.819227,  0.812419,  0.821032,  0.819591,  0.799307,  0.798745,  0.809025,  0.812788,  0.784226,  0.794359,  0.799930,  0.791508,  0.776700,  0.790396,  0.785254,  0.777506,  0.772742,  0.782013,  0.783663,  0.759027,  0.755829,  0.772619,  0.774268,  0.734483,  0.764834,  0.754801,  0.760922,  0.736283,  0.748708,  0.750316,  0.733131, },
{ 1.000000,  0.997144,  0.994896,  0.992041,  0.988756,  0.985964,  0.983955,  0.982128,  0.975846,  0.976446,  0.973253,  0.970571,  0.966832,  0.965069,  0.962659,  0.957968,  0.955220,  0.956031,  0.953006,  0.947108,  0.942603,  0.945977,  0.942875,  0.929690,  0.936692,  0.933827,  0.929489,  0.926420,  0.924834,  0.923417,  0.916022,  0.913133,  0.916000,  0.914426,  0.902602,  0.901806,  0.905834,  0.901724,  0.890021,  0.897269,  0.892091,  0.887208,  0.884299,  0.886636,  0.885573,  0.872633,  0.871031,  0.875580,  0.876338,  0.859548,  0.862361,  0.865512,  0.859675,  0.847592,  0.858507,  0.851844,  0.845616,  0.842939,  0.847449,  0.847422,  0.829777,  0.826865,  0.837585,  0.837129,  0.810611,  0.828612,  0.822424,  0.823494,  0.806405,  0.814393,  0.814802,  0.802685,  0.796321,  0.813123,  0.805501,  0.789055,  0.786645,  0.797242,  0.799881,  0.761775,  0.791294,  0.780459,  0.779499,  0.772092,  0.772923,  0.774584,  0.759127,  0.755245,  0.773318,  0.767490,  0.749100,  0.739327,  0.762691,  0.759813,  0.713357,  0.747751,  0.745689,  0.737889,  0.732990,  0.734918, },
{ 1.000000,  0.997267,  0.994134,  0.991207,  0.989005,  0.986418,  0.982008,  0.979335,  0.977993,  0.974843,  0.969628,  0.969540,  0.966091,  0.962662,  0.959565,  0.958538,  0.956025,  0.949965,  0.946843,  0.947114,  0.945678,  0.936903,  0.936931,  0.935865,  0.932438,  0.924356,  0.928313,  0.924246,  0.919133,  0.915332,  0.918305,  0.914507,  0.905294,  0.901758,  0.905864,  0.905317,  0.889127,  0.896894,  0.892585,  0.892076,  0.880307,  0.884539,  0.883967,  0.873998,  0.870720,  0.877514,  0.873546,  0.862020,  0.858204,  0.864551,  0.864635,  0.838996,  0.857255,  0.849874,  0.847710,  0.841278,  0.840332,  0.843411,  0.829748,  0.824220,  0.838082,  0.832421,  0.817389,  0.812221,  0.826226,  0.824325,  0.789039,  0.815792,  0.809049,  0.803510,  0.799605,  0.800785,  0.799178,  0.786453,  0.782772,  0.794690,  0.792596,  0.768937,  0.769799,  0.782982,  0.778171,  0.750245,  0.773549,  0.766906,  0.758505,  0.754477,  0.763749,  0.759774,  0.740062,  0.736628,  0.750178,  0.752325,  0.723939,  0.734826,  0.734573,  0.734858,  0.708200,  0.733742,  0.722799,  0.715270, },
{ 1.000000,  0.996952,  0.994403,  0.991395,  0.987686,  0.984552,  0.982663,  0.980424,  0.974563,  0.973832,  0.970954,  0.968248,  0.962873,  0.961933,  0.959833,  0.954878,  0.951271,  0.951743,  0.949009,  0.941735,  0.938998,  0.939361,  0.938439,  0.925092,  0.931449,  0.926389,  0.924189,  0.919051,  0.917461,  0.917338,  0.908522,  0.904247,  0.911073,  0.905249,  0.896231,  0.891564,  0.898608,  0.896134,  0.875504,  0.888840,  0.882744,  0.878756,  0.875673,  0.875005,  0.872508,  0.863858,  0.858906,  0.867516,  0.863685,  0.848423,  0.846723,  0.854897,  0.850816,  0.829821,  0.845163,  0.839952,  0.833021,  0.830467,  0.833853,  0.830940,  0.816486,  0.813737,  0.821046,  0.821425,  0.801926,  0.806683,  0.808384,  0.805331,  0.786881,  0.801938,  0.795615,  0.788916,  0.783673,  0.791854,  0.788023,  0.769932,  0.765660,  0.778735,  0.781658,  0.749784,  0.766444,  0.764584,  0.762497,  0.742054,  0.756956,  0.753217,  0.741669,  0.736320,  0.750137,  0.746588,  0.724666,  0.721643,  0.736439,  0.737652,  0.694946,  0.729127,  0.716449,  0.718528,  0.703533,  0.712459, },
{ 1.000000,  0.997019,  0.993686,  0.990469,  0.988340,  0.984968,  0.980981,  0.977538,  0.976279,  0.973784,  0.965775,  0.967483,  0.963292,  0.960068,  0.956959,  0.954478,  0.951415,  0.946468,  0.942852,  0.944406,  0.940422,  0.932957,  0.929798,  0.931594,  0.928616,  0.916301,  0.922359,  0.918211,  0.913498,  0.910251,  0.910176,  0.907074,  0.898702,  0.895207,  0.898441,  0.895967,  0.884531,  0.883886,  0.886123,  0.881564,  0.870318,  0.877370,  0.871966,  0.867596,  0.861218,  0.867181,  0.862798,  0.849492,  0.847513,  0.852602,  0.854174,  0.833088,  0.840761,  0.840542,  0.837195,  0.821500,  0.831324,  0.827687,  0.818052,  0.815316,  0.821190,  0.819853,  0.802234,  0.799690,  0.810027,  0.807883,  0.778740,  0.799854,  0.791630,  0.791833,  0.777960,  0.785504,  0.782788,  0.770655,  0.763164,  0.782017,  0.771880,  0.757129,  0.752316,  0.763814,  0.766735,  0.723793,  0.757198,  0.745542,  0.742933,  0.736400,  0.738669,  0.737783,  0.722608,  0.718443,  0.736805,  0.728172,  0.706548,  0.702802,  0.722259,  0.718504,  0.675672,  0.709266,  0.705760,  0.692866, },
{ 1.000000,  0.996839,  0.993796,  0.990724,  0.986993,  0.983625,  0.981394,  0.978638,  0.973497,  0.970955,  0.969296,  0.965784,  0.959609,  0.960181,  0.955355,  0.952562,  0.947826,  0.948107,  0.944823,  0.937394,  0.934902,  0.934900,  0.933516,  0.923019,  0.923735,  0.922701,  0.918796,  0.909935,  0.912983,  0.909619,  0.903660,  0.900309,  0.901139,  0.899579,  0.888059,  0.885273,  0.889948,  0.887173,  0.869152,  0.879593,  0.874174,  0.874360,  0.860517,  0.866340,  0.863690,  0.853039,  0.848837,  0.859490,  0.852052,  0.840172,  0.836596,  0.842393,  0.843880,  0.814802,  0.834240,  0.827421,  0.823274,  0.818323,  0.818183,  0.815459,  0.805078,  0.801659,  0.812757,  0.806313,  0.792397,  0.783799,  0.798845,  0.798422,  0.760736,  0.786238,  0.784065,  0.773312,  0.770198,  0.773520,  0.771363,  0.755573,  0.751914,  0.763176,  0.760184,  0.740140,  0.739864,  0.751469,  0.745309,  0.721009,  0.741430,  0.730770,  0.727233,  0.718559,  0.730722,  0.728621,  0.702207,  0.702585,  0.716213,  0.720059,  0.683486,  0.697852,  0.705604,  0.693476,  0.674802,  0.693641, },
{ 1.000000,  0.996706,  0.993279,  0.989975,  0.987215,  0.984210,  0.979378,  0.975949,  0.974398,  0.971610,  0.964084,  0.964804,  0.960652,  0.958336,  0.951867,  0.951102,  0.948389,  0.942401,  0.938160,  0.940849,  0.935596,  0.928654,  0.925560,  0.925528,  0.924460,  0.909195,  0.916935,  0.912173,  0.908471,  0.902562,  0.902135,  0.899363,  0.891296,  0.888330,  0.892466,  0.888577,  0.878185,  0.871853,  0.880536,  0.875785,  0.853379,  0.868112,  0.864700,  0.858101,  0.854036,  0.853162,  0.851991,  0.840550,  0.837214,  0.843105,  0.841131,  0.823214,  0.823670,  0.831118,  0.824571,  0.807946,  0.819993,  0.813287,  0.806269,  0.802610,  0.807291,  0.805957,  0.787411,  0.786387,  0.793760,  0.794654,  0.771042,  0.776628,  0.781926,  0.773011,  0.756718,  0.773309,  0.764043,  0.755636,  0.752282,  0.759495,  0.759380,  0.735330,  0.732724,  0.747909,  0.746626,  0.711001,  0.736529,  0.729153,  0.729471,  0.707033,  0.718917,  0.719139,  0.703212,  0.695674,  0.717680,  0.708054,  0.686154,  0.684129,  0.698938,  0.700932,  0.651996,  0.691289,  0.677839,  0.675328, },
{ 1.000000,  0.996573,  0.993108,  0.989890,  0.985894,  0.982242,  0.980268,  0.976756,  0.971731,  0.967629,  0.967219,  0.963587,  0.954368,  0.956209,  0.952909,  0.948554,  0.944772,  0.942277,  0.939152,  0.933200,  0.929258,  0.930416,  0.927344,  0.916748,  0.915067,  0.916779,  0.911843,  0.901690,  0.906256,  0.901119,  0.895867,  0.892092,  0.892801,  0.890196,  0.879510,  0.875747,  0.878939,  0.877712,  0.862800,  0.865330,  0.865593,  0.860107,  0.847417,  0.856698,  0.850643,  0.843375,  0.838287,  0.844664,  0.839511,  0.825462,  0.821483,  0.829308,  0.829008,  0.804326,  0.818116,  0.812651,  0.811841,  0.795109,  0.802862,  0.802303,  0.788396,  0.784275,  0.795153,  0.789988,  0.773488,  0.769372,  0.779516,  0.779197,  0.743469,  0.770801,  0.761056,  0.757359,  0.749298,  0.749084,  0.753613,  0.734803,  0.728266,  0.747433,  0.740222,  0.719700,  0.713910,  0.733680,  0.729962,  0.683833,  0.720231,  0.711766,  0.704079,  0.699169,  0.701542,  0.699687,  0.682723,  0.679027,  0.694822,  0.691877,  0.660649,  0.663506,  0.681212,  0.673212,  0.638633,  0.668768, },
{ 1.000000,  0.996452,  0.992891,  0.989221,  0.986203,  0.982629,  0.977991,  0.974329,  0.972198,  0.969092,  0.962761,  0.960892,  0.957755,  0.954337,  0.947299,  0.948394,  0.943405,  0.938873,  0.934970,  0.935007,  0.930484,  0.922449,  0.918989,  0.919752,  0.918496,  0.904922,  0.908780,  0.905557,  0.902217,  0.892073,  0.894242,  0.892505,  0.884261,  0.879322,  0.883191,  0.879997,  0.867212,  0.864641,  0.867843,  0.867280,  0.844338,  0.858687,  0.851418,  0.848272,  0.841039,  0.840506,  0.841241,  0.827682,  0.822377,  0.834632,  0.826433,  0.812790,  0.807133,  0.819495,  0.815821,  0.785230,  0.806883,  0.798835,  0.793102,  0.789226,  0.789489,  0.786645,  0.774314,  0.768291,  0.781423,  0.776595,  0.754556,  0.753775,  0.766533,  0.760033,  0.731517,  0.753780,  0.747590,  0.737686,  0.734651,  0.740393,  0.736663,  0.716953,  0.714442,  0.724930,  0.725031,  0.699005,  0.706746,  0.709652,  0.704705,  0.680871,  0.701877,  0.693420,  0.684723,  0.678236,  0.689783,  0.684609,  0.661023,  0.656340,  0.673925,  0.677011,  0.635698,  0.658755,  0.656986,  0.653002, },
{ 1.000000,  0.996177,  0.992832,  0.989207,  0.985146,  0.981295,  0.978826,  0.975205,  0.969803,  0.966127,  0.964503,  0.961284,  0.952295,  0.954021,  0.948942,  0.945900,  0.940210,  0.938884,  0.935624,  0.928578,  0.924480,  0.926525,  0.921518,  0.913690,  0.909086,  0.911757,  0.909252,  0.891291,  0.901252,  0.894560,  0.890158,  0.886433,  0.884645,  0.880866,  0.872948,  0.868551,  0.874148,  0.868486,  0.856013,  0.852777,  0.858272,  0.854100,  0.834399,  0.847132,  0.841742,  0.834890,  0.830832,  0.832499,  0.828553,  0.816057,  0.812148,  0.818600,  0.815661,  0.798643,  0.799503,  0.804207,  0.797245,  0.781571,  0.793516,  0.786135,  0.780290,  0.771809,  0.781914,  0.776062,  0.757342,  0.755748,  0.763928,  0.766194,  0.736799,  0.749162,  0.749736,  0.744526,  0.723757,  0.738527,  0.733831,  0.720909,  0.717767,  0.726598,  0.724996,  0.701280,  0.698999,  0.713935,  0.710395,  0.671873,  0.701457,  0.691063,  0.690568,  0.672780,  0.683996,  0.680214,  0.664437,  0.655619,  0.680418,  0.667517,  0.648009,  0.643082,  0.658668,  0.661148,  0.606897,  0.650590, },
{ 1.000000,  0.996303,  0.992439,  0.988598,  0.985001,  0.981447,  0.976714,  0.972894,  0.970942,  0.966802,  0.960729,  0.956984,  0.956142,  0.952194,  0.942336,  0.944455,  0.940645,  0.935043,  0.930925,  0.929930,  0.925982,  0.918197,  0.914548,  0.914678,  0.911922,  0.901427,  0.900081,  0.900564,  0.895604,  0.883996,  0.889660,  0.882086,  0.878937,  0.871478,  0.875678,  0.871220,  0.858504,  0.856233,  0.859041,  0.858170,  0.840330,  0.844625,  0.844529,  0.838814,  0.825263,  0.832638,  0.828114,  0.819786,  0.815484,  0.818556,  0.817180,  0.799758,  0.796857,  0.805951,  0.801990,  0.774984,  0.793022,  0.785763,  0.786278,  0.766693,  0.776895,  0.773268,  0.758626,  0.753415,  0.769757,  0.759790,  0.742905,  0.739066,  0.748695,  0.750283,  0.710098,  0.738644,  0.730019,  0.723874,  0.717720,  0.718763,  0.715325,  0.701194,  0.697872,  0.713167,  0.704866,  0.686112,  0.675739,  0.696830,  0.695280,  0.646185,  0.680548,  0.678550,  0.663995,  0.660042,  0.665556,  0.662897,  0.641910,  0.638429,  0.653404,  0.649236,  0.623272,  0.624347,  0.639960,  0.630649, },
{ 1.000000,  0.995862,  0.992337,  0.988393,  0.984421,  0.980130,  0.977293,  0.973572,  0.967462,  0.964032,  0.961992,  0.958923,  0.950487,  0.949170,  0.947132,  0.941566,  0.934962,  0.935157,  0.930448,  0.925268,  0.920714,  0.920345,  0.917482,  0.906909,  0.903134,  0.905661,  0.902450,  0.886189,  0.893906,  0.887858,  0.886107,  0.874425,  0.876764,  0.873891,  0.864217,  0.858793,  0.866703,  0.858906,  0.847665,  0.844622,  0.847034,  0.846759,  0.821291,  0.837335,  0.830920,  0.825763,  0.817851,  0.818864,  0.815606,  0.803716,  0.800787,  0.808629,  0.803750,  0.788292,  0.780341,  0.795005,  0.788189,  0.755938,  0.779083,  0.775194,  0.765953,  0.760836,  0.761138,  0.759936,  0.743886,  0.740553,  0.749848,  0.747391,  0.722453,  0.724753,  0.736049,  0.726523,  0.704680,  0.722320,  0.713695,  0.704240,  0.699831,  0.707237,  0.706019,  0.680838,  0.680736,  0.691317,  0.692291,  0.661054,  0.669973,  0.677691,  0.665119,  0.644353,  0.667470,  0.655370,  0.644489,  0.640496,  0.650808,  0.650588,  0.619393,  0.617261,  0.637507,  0.635188,  0.589488,  0.623675, },
{ 1.000000,  0.996065,  0.992025,  0.987401,  0.984074,  0.980305,  0.975296,  0.970905,  0.969199,  0.964719,  0.958417,  0.954593,  0.953065,  0.949763,  0.938608,  0.941584,  0.935985,  0.931886,  0.926666,  0.923984,  0.921003,  0.913228,  0.909123,  0.911058,  0.906296,  0.896979,  0.891058,  0.895970,  0.891056,  0.872142,  0.881418,  0.877947,  0.871444,  0.866373,  0.864866,  0.861304,  0.851929,  0.847392,  0.852146,  0.848424,  0.831166,  0.830788,  0.836005,  0.828832,  0.813568,  0.823033,  0.816496,  0.809094,  0.804505,  0.807437,  0.804688,  0.788701,  0.784952,  0.791072,  0.789966,  0.768418,  0.774075,  0.775606,  0.767796,  0.750289,  0.765511,  0.757303,  0.747532,  0.741128,  0.751552,  0.744772,  0.725313,  0.721348,  0.733201,  0.732806,  0.699150,  0.719916,  0.713227,  0.711826,  0.689667,  0.701844,  0.701028,  0.682709,  0.678146,  0.693376,  0.686749,  0.665079,  0.660775,  0.675121,  0.674168,  0.627546,  0.664918,  0.652883,  0.647240,  0.637396,  0.638453,  0.644357,  0.619716,  0.612693,  0.637409,  0.628488,  0.602015,  0.595890,  0.621730,  0.616136, },
{ 1.000000,  0.995397,  0.991992,  0.987726,  0.983329,  0.979203,  0.975456,  0.971410,  0.965935,  0.961879,  0.959822,  0.955731,  0.947950,  0.944707,  0.943730,  0.938788,  0.929349,  0.931097,  0.926203,  0.920480,  0.915926,  0.915276,  0.910918,  0.901446,  0.897572,  0.898640,  0.895579,  0.882789,  0.883863,  0.881091,  0.876845,  0.864275,  0.871343,  0.863813,  0.857552,  0.852563,  0.855911,  0.849670,  0.836744,  0.833118,  0.837054,  0.836689,  0.814716,  0.823941,  0.820430,  0.816227,  0.801138,  0.806760,  0.805255,  0.793595,  0.787171,  0.794816,  0.791312,  0.772522,  0.770154,  0.776801,  0.776507,  0.743052,  0.766284,  0.756783,  0.752481,  0.743124,  0.743814,  0.745565,  0.726825,  0.720808,  0.738761,  0.728057,  0.709223,  0.703049,  0.721061,  0.715881,  0.674707,  0.705859,  0.695345,  0.687751,  0.683282,  0.684664,  0.681131,  0.664940,  0.658215,  0.676138,  0.670120,  0.640792,  0.641426,  0.658981,  0.649775,  0.613345,  0.643157,  0.635797,  0.622827,  0.619330,  0.627876,  0.623100,  0.597708,  0.595857,  0.609749,  0.609358,  0.576193,  0.587760, },
{ 1.000000,  0.995818,  0.991572,  0.986595,  0.983404,  0.978926,  0.974303,  0.969615,  0.966786,  0.962447,  0.955896,  0.951477,  0.950002,  0.946694,  0.936642,  0.936767,  0.932896,  0.928334,  0.919936,  0.920489,  0.915760,  0.908986,  0.904057,  0.904912,  0.900406,  0.890002,  0.886120,  0.887973,  0.884414,  0.866258,  0.875947,  0.868187,  0.864956,  0.856124,  0.857125,  0.853430,  0.842215,  0.837366,  0.844130,  0.837189,  0.824937,  0.819380,  0.826512,  0.823739,  0.794847,  0.814322,  0.804724,  0.798784,  0.794534,  0.793577,  0.788955,  0.777633,  0.772767,  0.782770,  0.775287,  0.757072,  0.754252,  0.763915,  0.758123,  0.730035,  0.750061,  0.743343,  0.734046,  0.729142,  0.732912,  0.728059,  0.710918,  0.706820,  0.716902,  0.713254,  0.689815,  0.692911,  0.700206,  0.690270,  0.669838,  0.687513,  0.677805,  0.670355,  0.659652,  0.674379,  0.666907,  0.642038,  0.641085,  0.652790,  0.655837,  0.617065,  0.634979,  0.636369,  0.628914,  0.602435,  0.622948,  0.617033,  0.600536,  0.597006,  0.609235,  0.607381,  0.576761,  0.575111,  0.595028,  0.589737, },
{ 1.000000,  0.995183,  0.991442,  0.986816,  0.982645,  0.977351,  0.974091,  0.969612,  0.964187,  0.959132,  0.958000,  0.952532,  0.946023,  0.941406,  0.940082,  0.936493,  0.923541,  0.927609,  0.921150,  0.916557,  0.911253,  0.908727,  0.904747,  0.896581,  0.892237,  0.894304,  0.888281,  0.877302,  0.873286,  0.876969,  0.871296,  0.853050,  0.862211,  0.857982,  0.849238,  0.844265,  0.845573,  0.840538,  0.828493,  0.824470,  0.827633,  0.824618,  0.808276,  0.808576,  0.811810,  0.804551,  0.787543,  0.798808,  0.788442,  0.784658,  0.774609,  0.782973,  0.777365,  0.758815,  0.757168,  0.762970,  0.762356,  0.736807,  0.745073,  0.746401,  0.738305,  0.719870,  0.732070,  0.726515,  0.715312,  0.710333,  0.715852,  0.714825,  0.690750,  0.688144,  0.701976,  0.696758,  0.659987,  0.686646,  0.677350,  0.677841,  0.652379,  0.667328,  0.662839,  0.643647,  0.637777,  0.660121,  0.647649,  0.625087,  0.621569,  0.635091,  0.636799,  0.584699,  0.623507,  0.612691,  0.604441,  0.597089,  0.599523,  0.595333,  0.576993,  0.574185,  0.593666,  0.583815,  0.559451,  0.547764, },
{ 1.000000,  0.995620,  0.991265,  0.985212,  0.982202,  0.977876,  0.972629,  0.968030,  0.964570,  0.960212,  0.953742,  0.949217,  0.947162,  0.942604,  0.934621,  0.930985,  0.929766,  0.924065,  0.914614,  0.916128,  0.909740,  0.904849,  0.898676,  0.899068,  0.894920,  0.882803,  0.879780,  0.880884,  0.878321,  0.861923,  0.864450,  0.863944,  0.855241,  0.844943,  0.849588,  0.843149,  0.835745,  0.830020,  0.832513,  0.829961,  0.812904,  0.809105,  0.815931,  0.812242,  0.786196,  0.802133,  0.794048,  0.792348,  0.775176,  0.781241,  0.778020,  0.764325,  0.757449,  0.771309,  0.760964,  0.744822,  0.742170,  0.747374,  0.747519,  0.710939,  0.736616,  0.728300,  0.721321,  0.711007,  0.714003,  0.710140,  0.693973,  0.691430,  0.703216,  0.697377,  0.676223,  0.666780,  0.688107,  0.678940,  0.635538,  0.668278,  0.663980,  0.651736,  0.645516,  0.646979,  0.645870,  0.624713,  0.621693,  0.634648,  0.631876,  0.598936,  0.603683,  0.619185,  0.606191,  0.578844,  0.602378,  0.591795,  0.579716,  0.574605,  0.585064,  0.583737,  0.551275,  0.552469,  0.566564,  0.567652, },
{ 1.000000,  0.995212,  0.990618,  0.986446,  0.981324,  0.975721,  0.972969,  0.967599,  0.962377,  0.957737,  0.954627,  0.950577,  0.942150,  0.937812,  0.936911,  0.932410,  0.920577,  0.922948,  0.917343,  0.913201,  0.903527,  0.903425,  0.899593,  0.891117,  0.885352,  0.888489,  0.881921,  0.870838,  0.866928,  0.868873,  0.865511,  0.844085,  0.855948,  0.847739,  0.842369,  0.835633,  0.833771,  0.830990,  0.818934,  0.814605,  0.820853,  0.814863,  0.800211,  0.792990,  0.803725,  0.797074,  0.767433,  0.785349,  0.781657,  0.772655,  0.766392,  0.766012,  0.761807,  0.748546,  0.743814,  0.752373,  0.747936,  0.722944,  0.724696,  0.733867,  0.723550,  0.702837,  0.718210,  0.709839,  0.700020,  0.694439,  0.700084,  0.697314,  0.675111,  0.671570,  0.681262,  0.680106,  0.650953,  0.660323,  0.663609,  0.652886,  0.629956,  0.652063,  0.641576,  0.628849,  0.621113,  0.636073,  0.627590,  0.602015,  0.597986,  0.614702,  0.614180,  0.570113,  0.599053,  0.590991,  0.588831,  0.560774,  0.577706,  0.576866,  0.553741,  0.548436,  0.568473,  0.560577,  0.532858,  0.528625, },
{ 1.000000,  0.995317,  0.990695,  0.984606,  0.981525,  0.976358,  0.971425,  0.966330,  0.962009,  0.958223,  0.951096,  0.946081,  0.944985,  0.939685,  0.931373,  0.926424,  0.926708,  0.921618,  0.906662,  0.911978,  0.906031,  0.899794,  0.894549,  0.891725,  0.887527,  0.878258,  0.873773,  0.875142,  0.870557,  0.855823,  0.853988,  0.856833,  0.849651,  0.833577,  0.841626,  0.835385,  0.827151,  0.821735,  0.823772,  0.818318,  0.803722,  0.799946,  0.804210,  0.801117,  0.781509,  0.786197,  0.783595,  0.778157,  0.759784,  0.773496,  0.763134,  0.754972,  0.748701,  0.756015,  0.747933,  0.729484,  0.725796,  0.733475,  0.733996,  0.702327,  0.718088,  0.714418,  0.708751,  0.688361,  0.698137,  0.696983,  0.681286,  0.673555,  0.685295,  0.681233,  0.655924,  0.654193,  0.664404,  0.664302,  0.619452,  0.652971,  0.640642,  0.634938,  0.623588,  0.625524,  0.628342,  0.604001,  0.597224,  0.621505,  0.608234,  0.583621,  0.576913,  0.601324,  0.594480,  0.541340,  0.583115,  0.570291,  0.560261,  0.555272,  0.557942,  0.554008,  0.533258,  0.525989,  0.549069,  0.541933, },
{ 1.000000,  0.994955,  0.989869,  0.985713,  0.980709,  0.973988,  0.971145,  0.966125,  0.960451,  0.955633,  0.952059,  0.947222,  0.939512,  0.934796,  0.932645,  0.928421,  0.918562,  0.916447,  0.913239,  0.907517,  0.897468,  0.899399,  0.892998,  0.886503,  0.880628,  0.880708,  0.875295,  0.863575,  0.858497,  0.860982,  0.858138,  0.839379,  0.844913,  0.840869,  0.834913,  0.821403,  0.826547,  0.820895,  0.811106,  0.804917,  0.809600,  0.804148,  0.788064,  0.784096,  0.789925,  0.785839,  0.757304,  0.776265,  0.765497,  0.761848,  0.749892,  0.753688,  0.749449,  0.733639,  0.727943,  0.739988,  0.730979,  0.713513,  0.707195,  0.719401,  0.716182,  0.675029,  0.705404,  0.692941,  0.685171,  0.680288,  0.680366,  0.674848,  0.659571,  0.654441,  0.669209,  0.659841,  0.634940,  0.633002,  0.647364,  0.639578,  0.602496,  0.630912,  0.622793,  0.610572,  0.604814,  0.611001,  0.605183,  0.582721,  0.578729,  0.592756,  0.588380,  0.557539,  0.563534,  0.574045,  0.560489,  0.534951,  0.559119,  0.546811,  0.537449,  0.524387,  0.544223,  0.535119,  0.503196,  0.503199, },
{ 1.000000,  0.995019,  0.990379,  0.984131,  0.980162,  0.975448,  0.970338,  0.963447,  0.960751,  0.955529,  0.949263,  0.944214,  0.941505,  0.936855,  0.927906,  0.923256,  0.922486,  0.917209,  0.903789,  0.907422,  0.900753,  0.896123,  0.887326,  0.886913,  0.881727,  0.872813,  0.866268,  0.870567,  0.862495,  0.851726,  0.846687,  0.848907,  0.845419,  0.821615,  0.835181,  0.826048,  0.820074,  0.813676,  0.812164,  0.808067,  0.795686,  0.791446,  0.797463,  0.789851,  0.772972,  0.769421,  0.777717,  0.770280,  0.742681,  0.760024,  0.755060,  0.743018,  0.737354,  0.741136,  0.735250,  0.718171,  0.714398,  0.720467,  0.717498,  0.694287,  0.697186,  0.703049,  0.693369,  0.670405,  0.688176,  0.674488,  0.670311,  0.657194,  0.670529,  0.663729,  0.638733,  0.638021,  0.647096,  0.646868,  0.612694,  0.625892,  0.628307,  0.617874,  0.593937,  0.611860,  0.604772,  0.590874,  0.584882,  0.593455,  0.592430,  0.561503,  0.559490,  0.578451,  0.571771,  0.524488,  0.560751,  0.549138,  0.549664,  0.517892,  0.538277,  0.532525,  0.508716,  0.502177,  0.531014,  0.515772, },
{ 1.000000,  0.994737,  0.989507,  0.984772,  0.980018,  0.972124,  0.969823,  0.964069,  0.958570,  0.953123,  0.948816,  0.943715,  0.936493,  0.931598,  0.930046,  0.924196,  0.915377,  0.908966,  0.909888,  0.904936,  0.888148,  0.893115,  0.888622,  0.880218,  0.874891,  0.872735,  0.867953,  0.856961,  0.852259,  0.853546,  0.847939,  0.834390,  0.831841,  0.834054,  0.825727,  0.810583,  0.817909,  0.809012,  0.803077,  0.794674,  0.798443,  0.793891,  0.774943,  0.772711,  0.777350,  0.775278,  0.749951,  0.757225,  0.758396,  0.746056,  0.731729,  0.741622,  0.732959,  0.723342,  0.716389,  0.722216,  0.719638,  0.695102,  0.691550,  0.703480,  0.699129,  0.662006,  0.687441,  0.677093,  0.675471,  0.652351,  0.662588,  0.658907,  0.640782,  0.632670,  0.653130,  0.639540,  0.617832,  0.615865,  0.624289,  0.624811,  0.575859,  0.612536,  0.602128,  0.593022,  0.580256,  0.585547,  0.580961,  0.560053,  0.558002,  0.574078,  0.567206,  0.539633,  0.528801,  0.557292,  0.545582,  0.490004,  0.533557,  0.528657,  0.513113,  0.505682,  0.508762,  0.507771,  0.480747,  0.478346, },
{ 1.000000,  0.994761,  0.989742,  0.983426,  0.978364,  0.974149,  0.968417,  0.961198,  0.958327,  0.952602,  0.946358,  0.940869,  0.937725,  0.932927,  0.923247,  0.918796,  0.916785,  0.912470,  0.900351,  0.898765,  0.896453,  0.888347,  0.878244,  0.881287,  0.873175,  0.865639,  0.860421,  0.859940,  0.855748,  0.840822,  0.836505,  0.839974,  0.834821,  0.813529,  0.823604,  0.816306,  0.811673,  0.796713,  0.800259,  0.796248,  0.783980,  0.776698,  0.785009,  0.776573,  0.759677,  0.756210,  0.762104,  0.758376,  0.725477,  0.747443,  0.736341,  0.729593,  0.720928,  0.720523,  0.717798,  0.700692,  0.696651,  0.707430,  0.699991,  0.679499,  0.670911,  0.688400,  0.679515,  0.637970,  0.665810,  0.661709,  0.649677,  0.642316,  0.643200,  0.638474,  0.620834,  0.615839,  0.628731,  0.623561,  0.589711,  0.594200,  0.607598,  0.593975,  0.567245,  0.588926,  0.578903,  0.566185,  0.559831,  0.568185,  0.565520,  0.536449,  0.533321,  0.546739,  0.545753,  0.507848,  0.522176,  0.526951,  0.512670,  0.484061,  0.514051,  0.500515,  0.484767,  0.475697,  0.495724,  0.485259, },
{ 1.000000,  0.994444,  0.988898,  0.983972,  0.978840,  0.971136,  0.967965,  0.962362,  0.957149,  0.949150,  0.946180,  0.941176,  0.933348,  0.927801,  0.926130,  0.920152,  0.910696,  0.905390,  0.904466,  0.899659,  0.882730,  0.888948,  0.881277,  0.875005,  0.867945,  0.864383,  0.861788,  0.849386,  0.843336,  0.847554,  0.840758,  0.826577,  0.820865,  0.826740,  0.820356,  0.793910,  0.808988,  0.801033,  0.792654,  0.786459,  0.784839,  0.780068,  0.766536,  0.761890,  0.767054,  0.761592,  0.739115,  0.739339,  0.746303,  0.736169,  0.712833,  0.728163,  0.720452,  0.709202,  0.702709,  0.707881,  0.701461,  0.680571,  0.677345,  0.685189,  0.682041,  0.654272,  0.663478,  0.661288,  0.654307,  0.629344,  0.650684,  0.637038,  0.626802,  0.619313,  0.630840,  0.620586,  0.595868,  0.592551,  0.604156,  0.605637,  0.562904,  0.586593,  0.582257,  0.575065,  0.548761,  0.563524,  0.562078,  0.542094,  0.533032,  0.549502,  0.545036,  0.511734,  0.510998,  0.525485,  0.525619,  0.467395,  0.513054,  0.497398,  0.490059,  0.476237,  0.479921,  0.483954,  0.453331,  0.445513, },
{ 1.000000,  0.994571,  0.989116,  0.982810,  0.976952,  0.972953,  0.967495,  0.957899,  0.956385,  0.950179,  0.943892,  0.938247,  0.933628,  0.928299,  0.920177,  0.914153,  0.913403,  0.907454,  0.895486,  0.891570,  0.891595,  0.884234,  0.869581,  0.874083,  0.867547,  0.858995,  0.853740,  0.852404,  0.846600,  0.833391,  0.829096,  0.829885,  0.825442,  0.808744,  0.809906,  0.807567,  0.799827,  0.784205,  0.792369,  0.783524,  0.774936,  0.767916,  0.771176,  0.764584,  0.746861,  0.741483,  0.748290,  0.745942,  0.717157,  0.729397,  0.725081,  0.717250,  0.698338,  0.708652,  0.701727,  0.688446,  0.681194,  0.690242,  0.683566,  0.660887,  0.657304,  0.667644,  0.662696,  0.622705,  0.652457,  0.638071,  0.633691,  0.618361,  0.625494,  0.620345,  0.599306,  0.593270,  0.611018,  0.599574,  0.576621,  0.569517,  0.587201,  0.583302,  0.528844,  0.571569,  0.555421,  0.545551,  0.540282,  0.541470,  0.534771,  0.515484,  0.510150,  0.529935,  0.518571,  0.486376,  0.485547,  0.504987,  0.494925,  0.447833,  0.485664,  0.475959,  0.460728,  0.453875,  0.462823,  0.455812, },
{ 1.000000,  0.994165,  0.988388,  0.983290,  0.977722,  0.970327,  0.965347,  0.960888,  0.954404,  0.946586,  0.944136,  0.937554,  0.931271,  0.924197,  0.922298,  0.916036,  0.905653,  0.900805,  0.898961,  0.895047,  0.880068,  0.880942,  0.876629,  0.869592,  0.857264,  0.859512,  0.853165,  0.843404,  0.837974,  0.838084,  0.833236,  0.817476,  0.813217,  0.816739,  0.810268,  0.786672,  0.799381,  0.789941,  0.784885,  0.771629,  0.774968,  0.768503,  0.755868,  0.747799,  0.758084,  0.747162,  0.731284,  0.726063,  0.732090,  0.728584,  0.692277,  0.717059,  0.704418,  0.697008,  0.689132,  0.689157,  0.684319,  0.667368,  0.663153,  0.673749,  0.664135,  0.640584,  0.637528,  0.651399,  0.641432,  0.603158,  0.629840,  0.624217,  0.608361,  0.601723,  0.608634,  0.601433,  0.578772,  0.575150,  0.584627,  0.581424,  0.550358,  0.556324,  0.565368,  0.552430,  0.522948,  0.548049,  0.530542,  0.525588,  0.509241,  0.528084,  0.520012,  0.487249,  0.487887,  0.500589,  0.500965,  0.456264,  0.475698,  0.479448,  0.465991,  0.435900,  0.460358,  0.451608,  0.434339,  0.427297, },
{ 1.000000,  0.994183,  0.988636,  0.981868,  0.976145,  0.971567,  0.965653,  0.956424,  0.954217,  0.947834,  0.942532,  0.933512,  0.930962,  0.924902,  0.916320,  0.910055,  0.910111,  0.902488,  0.891963,  0.886658,  0.885528,  0.881226,  0.861772,  0.868959,  0.861011,  0.853582,  0.846944,  0.843543,  0.837702,  0.826782,  0.821797,  0.824382,  0.816700,  0.803029,  0.794779,  0.801680,  0.795641,  0.766907,  0.781308,  0.776481,  0.764557,  0.758229,  0.758071,  0.752877,  0.736645,  0.731982,  0.736813,  0.730259,  0.710400,  0.709370,  0.715332,  0.704038,  0.682848,  0.696569,  0.684692,  0.677594,  0.666984,  0.674772,  0.669714,  0.642921,  0.642225,  0.650586,  0.649073,  0.613549,  0.626581,  0.629646,  0.612988,  0.594375,  0.610071,  0.599246,  0.587055,  0.578663,  0.588252,  0.585672,  0.553181,  0.550036,  0.567423,  0.562261,  0.513151,  0.549356,  0.536277,  0.534655,  0.504924,  0.520152,  0.515780,  0.492719,  0.483435,  0.510916,  0.494243,  0.466325,  0.465215,  0.477149,  0.478262,  0.415769,  0.464667,  0.451626,  0.440113,  0.425034,  0.432953,  0.427321, },
{ 1.000000,  0.993883,  0.987860,  0.982591,  0.976511,  0.969271,  0.962816,  0.959491,  0.953055,  0.941884,  0.941178,  0.935354,  0.927820,  0.921490,  0.916846,  0.911551,  0.901809,  0.896392,  0.894492,  0.888775,  0.875141,  0.872093,  0.871655,  0.862848,  0.850205,  0.852988,  0.845088,  0.836284,  0.830126,  0.829463,  0.824751,  0.808287,  0.804838,  0.805822,  0.801842,  0.781470,  0.783358,  0.783211,  0.771674,  0.756857,  0.766429,  0.755129,  0.745144,  0.739162,  0.741742,  0.737572,  0.714948,  0.711225,  0.719738,  0.713814,  0.681533,  0.700811,  0.691544,  0.686094,  0.665393,  0.673465,  0.668879,  0.652339,  0.643746,  0.657890,  0.647124,  0.623921,  0.621234,  0.631338,  0.627348,  0.581472,  0.615233,  0.600686,  0.592376,  0.581855,  0.582878,  0.580317,  0.557662,  0.553812,  0.569644,  0.561011,  0.533981,  0.523996,  0.548857,  0.537753,  0.482669,  0.521687,  0.517327,  0.502185,  0.493278,  0.495858,  0.490533,  0.467725,  0.462905,  0.480463,  0.474348,  0.430804,  0.438762,  0.456904,  0.439173,  0.405970,  0.434987,  0.422689,  0.407016,  0.399916, },
{ 1.000000,  0.993896,  0.988065,  0.981074,  0.974873,  0.969673,  0.964052,  0.955210,  0.950741,  0.945582,  0.938543,  0.929411,  0.927890,  0.920716,  0.912910,  0.906027,  0.904174,  0.897360,  0.885886,  0.880056,  0.879409,  0.874381,  0.856831,  0.860935,  0.853821,  0.848028,  0.834345,  0.835585,  0.830513,  0.817908,  0.811595,  0.814226,  0.807163,  0.791870,  0.786233,  0.789606,  0.784298,  0.755664,  0.772483,  0.761897,  0.753896,  0.744774,  0.742008,  0.741128,  0.722632,  0.715742,  0.725785,  0.717291,  0.696662,  0.690375,  0.702501,  0.694472,  0.655009,  0.681259,  0.671439,  0.660485,  0.653079,  0.653006,  0.647570,  0.629101,  0.624756,  0.634071,  0.627739,  0.596300,  0.599074,  0.610950,  0.597397,  0.565978,  0.589575,  0.580058,  0.565403,  0.558079,  0.566726,  0.559171,  0.531222,  0.528764,  0.540865,  0.537522,  0.500573,  0.515250,  0.513261,  0.504305,  0.472269,  0.502533,  0.484938,  0.472261,  0.463579,  0.479900,  0.467468,  0.435517,  0.432959,  0.448834,  0.451224,  0.396351,  0.429285,  0.424031,  0.414940,  0.382215,  0.402495,  0.401003, },
{ 1.000000,  0.993663,  0.987237,  0.981697,  0.975429,  0.967599,  0.961564,  0.956877,  0.951204,  0.939496,  0.938904,  0.931309,  0.924716,  0.917289,  0.912436,  0.907694,  0.897142,  0.890444,  0.891058,  0.882694,  0.871026,  0.864424,  0.866381,  0.859429,  0.838425,  0.846930,  0.837827,  0.829586,  0.823362,  0.819835,  0.813751,  0.801506,  0.794786,  0.798545,  0.791509,  0.771941,  0.769287,  0.774180,  0.764263,  0.741178,  0.753554,  0.745371,  0.733811,  0.728002,  0.729217,  0.722612,  0.703425,  0.699524,  0.703496,  0.699046,  0.674506,  0.679726,  0.678487,  0.668577,  0.646683,  0.661861,  0.650376,  0.639331,  0.631121,  0.638215,  0.630213,  0.605963,  0.600545,  0.612055,  0.610102,  0.570383,  0.590451,  0.585558,  0.575771,  0.551011,  0.567229,  0.558634,  0.541775,  0.533442,  0.547125,  0.539364,  0.509589,  0.506531,  0.521571,  0.515894,  0.463336,  0.505056,  0.486756,  0.481716,  0.462867,  0.473349,  0.467353,  0.440878,  0.434212,  0.458317,  0.444571,  0.415138,  0.407460,  0.431248,  0.426805,  0.357467,  0.414169,  0.394101,  0.381718,  0.375962, },
{ 1.000000,  0.993588,  0.987318,  0.980335,  0.973970,  0.968902,  0.962364,  0.953710,  0.947591,  0.943793,  0.936830,  0.925409,  0.924555,  0.917726,  0.909779,  0.903052,  0.899248,  0.892588,  0.881984,  0.875876,  0.874403,  0.868063,  0.853974,  0.851396,  0.849431,  0.840054,  0.827077,  0.830371,  0.821304,  0.813261,  0.804126,  0.806661,  0.798859,  0.781903,  0.777562,  0.779256,  0.776147,  0.751304,  0.758116,  0.754520,  0.745273,  0.726793,  0.734927,  0.727077,  0.713746,  0.707788,  0.711272,  0.706051,  0.683126,  0.679610,  0.687865,  0.680082,  0.645209,  0.668303,  0.655692,  0.649951,  0.632503,  0.639906,  0.632134,  0.615302,  0.605804,  0.622526,  0.608396,  0.587061,  0.581738,  0.592476,  0.588721,  0.538813,  0.576171,  0.559595,  0.550530,  0.541210,  0.542978,  0.537729,  0.515595,  0.511892,  0.527103,  0.515650,  0.484601,  0.482566,  0.502202,  0.489445,  0.440087,  0.477053,  0.470678,  0.450675,  0.443131,  0.453227,  0.444672,  0.415978,  0.412736,  0.426152,  0.422802,  0.383157,  0.392831,  0.404951,  0.388571,  0.352068,  0.385350,  0.363952, },
{ 1.000000,  0.993464,  0.986438,  0.980702,  0.974010,  0.965903,  0.959681,  0.954387,  0.948509,  0.937739,  0.934036,  0.928447,  0.920891,  0.910800,  0.908668,  0.901623,  0.892902,  0.886091,  0.882930,  0.877242,  0.863654,  0.857946,  0.858256,  0.851125,  0.831196,  0.838197,  0.829049,  0.824115,  0.808312,  0.810961,  0.803799,  0.790249,  0.783218,  0.789296,  0.778902,  0.762583,  0.757081,  0.760121,  0.755874,  0.723543,  0.741646,  0.730971,  0.721518,  0.713236,  0.711235,  0.704392,  0.689108,  0.684516,  0.691266,  0.681877,  0.662012,  0.652234,  0.665799,  0.658435,  0.616433,  0.641141,  0.636185,  0.620090,  0.612727,  0.614966,  0.608947,  0.586981,  0.582471,  0.591255,  0.583815,  0.556171,  0.557562,  0.567407,  0.552595,  0.524424,  0.545748,  0.530651,  0.521868,  0.508819,  0.521126,  0.515564,  0.480038,  0.480740,  0.493545,  0.492571,  0.445332,  0.465208,  0.470132,  0.448812,  0.424938,  0.447755,  0.433956,  0.418962,  0.409289,  0.422843,  0.420541,  0.378500,  0.376122,  0.399991,  0.393576,  0.330661,  0.379411,  0.363061,  0.361355,  0.324116, },
{ 1.000000,  0.993299,  0.986601,  0.979254,  0.972189,  0.967297,  0.959963,  0.951559,  0.945159,  0.940144,  0.934254,  0.920384,  0.920851,  0.913095,  0.905396,  0.897157,  0.892756,  0.886014,  0.875294,  0.869519,  0.868286,  0.861305,  0.847931,  0.839747,  0.843027,  0.834219,  0.811173,  0.820432,  0.813899,  0.803316,  0.795652,  0.792147,  0.786778,  0.771714,  0.766494,  0.768104,  0.762058,  0.739928,  0.739404,  0.743012,  0.730573,  0.711783,  0.720933,  0.710617,  0.699165,  0.692122,  0.694569,  0.689880,  0.665531,  0.663273,  0.667630,  0.663859,  0.634278,  0.640582,  0.642608,  0.626921,  0.606690,  0.623905,  0.608924,  0.596462,  0.589768,  0.595682,  0.591416,  0.560021,  0.557065,  0.571141,  0.564167,  0.519819,  0.549692,  0.537919,  0.531530,  0.504476,  0.517654,  0.512366,  0.491329,  0.481225,  0.501705,  0.488481,  0.457898,  0.456166,  0.471065,  0.466600,  0.406198,  0.453467,  0.435207,  0.424958,  0.412234,  0.415037,  0.412476,  0.383765,  0.380396,  0.401643,  0.391673,  0.356974,  0.345662,  0.378698,  0.364957,  0.295089,  0.346879,  0.341986, },
{ 1.000000,  0.992973,  0.986073,  0.979352,  0.972619,  0.964603,  0.957787,  0.952628,  0.945927,  0.935000,  0.929690,  0.925626,  0.917215,  0.906291,  0.904766,  0.896748,  0.888204,  0.880968,  0.877474,  0.871270,  0.857925,  0.851850,  0.850086,  0.844336,  0.827447,  0.827032,  0.823300,  0.812977,  0.798286,  0.803889,  0.793817,  0.782975,  0.774763,  0.777359,  0.768682,  0.750534,  0.744895,  0.748887,  0.743728,  0.715070,  0.728003,  0.718751,  0.712406,  0.692268,  0.698754,  0.692963,  0.675362,  0.668338,  0.676033,  0.667247,  0.645552,  0.639853,  0.647846,  0.642011,  0.600223,  0.629323,  0.615187,  0.605258,  0.594094,  0.592446,  0.593014,  0.567694,  0.560169,  0.576435,  0.566217,  0.538332,  0.531678,  0.550611,  0.540812,  0.486930,  0.525910,  0.513580,  0.499844,  0.491383,  0.492729,  0.486806,  0.462857,  0.459086,  0.472517,  0.465579,  0.424058,  0.430249,  0.446964,  0.429703,  0.389359,  0.422268,  0.410658,  0.392554,  0.384146,  0.396467,  0.387808,  0.352119,  0.350856,  0.367220,  0.363745,  0.316697,  0.337421,  0.335855,  0.324691,  0.284722, },
{ 1.000000,  0.993115,  0.985920,  0.978648,  0.971392,  0.965640,  0.958306,  0.949147,  0.942295,  0.937416,  0.931225,  0.918086,  0.916246,  0.909314,  0.901848,  0.890404,  0.887899,  0.881649,  0.871067,  0.863137,  0.861768,  0.855066,  0.839972,  0.834495,  0.833473,  0.827994,  0.803672,  0.814064,  0.803397,  0.795344,  0.785200,  0.781636,  0.777856,  0.761209,  0.753573,  0.760694,  0.749675,  0.731612,  0.724382,  0.732885,  0.724257,  0.690036,  0.710122,  0.698108,  0.687447,  0.680537,  0.678125,  0.671216,  0.654161,  0.646755,  0.655767,  0.647473,  0.618955,  0.618183,  0.628407,  0.615271,  0.582506,  0.604132,  0.594281,  0.579144,  0.572833,  0.576866,  0.569239,  0.543056,  0.539910,  0.547732,  0.543132,  0.509561,  0.519720,  0.519417,  0.506631,  0.477585,  0.501406,  0.486595,  0.472767,  0.463262,  0.474658,  0.465115,  0.433158,  0.427763,  0.444900,  0.443489,  0.391014,  0.420259,  0.414603,  0.402442,  0.370896,  0.394309,  0.383739,  0.362714,  0.352940,  0.372008,  0.362899,  0.324766,  0.322847,  0.343300,  0.336621,  0.269400,  0.325336,  0.302193, },
{ 1.000000,  0.992716,  0.985317,  0.978551,  0.971312,  0.962829,  0.955564,  0.950671,  0.942820,  0.933089,  0.925771,  0.922125,  0.915164,  0.898879,  0.901184,  0.891645,  0.883200,  0.876246,  0.870692,  0.863085,  0.851990,  0.845192,  0.844824,  0.835986,  0.820525,  0.815196,  0.815845,  0.806708,  0.785475,  0.793498,  0.784635,  0.773852,  0.766079,  0.764383,  0.756556,  0.740289,  0.734180,  0.736376,  0.729245,  0.707324,  0.707734,  0.708521,  0.695535,  0.676729,  0.686974,  0.674572,  0.664737,  0.652821,  0.660598,  0.650698,  0.626326,  0.622830,  0.628253,  0.626376,  0.589607,  0.603832,  0.600330,  0.588745,  0.563265,  0.578069,  0.568466,  0.550892,  0.544480,  0.551621,  0.546219,  0.514701,  0.512039,  0.525837,  0.516293,  0.468307,  0.503609,  0.487382,  0.480909,  0.458014,  0.470510,  0.460962,  0.439299,  0.427959,  0.452179,  0.434670,  0.406558,  0.401429,  0.417331,  0.413305,  0.347504,  0.399648,  0.378506,  0.367177,  0.356355,  0.359940,  0.354215,  0.326127,  0.322888,  0.343687,  0.329803,  0.289932,  0.289109,  0.315720,  0.299696,  0.236700, },
{ 1.000000,  0.992764,  0.985321,  0.977554,  0.970094,  0.963482,  0.956102,  0.946909,  0.939572,  0.934188,  0.927302,  0.915499,  0.910361,  0.905650,  0.896709,  0.884226,  0.883706,  0.873655,  0.866183,  0.856096,  0.855319,  0.847215,  0.831922,  0.826579,  0.824519,  0.819065,  0.798856,  0.800291,  0.795855,  0.785642,  0.769265,  0.773269,  0.764485,  0.752517,  0.744653,  0.744411,  0.739003,  0.717334,  0.712387,  0.718009,  0.709097,  0.677559,  0.695131,  0.682897,  0.678174,  0.655372,  0.663600,  0.654869,  0.636382,  0.628243,  0.641414,  0.627863,  0.604559,  0.599602,  0.607124,  0.603150,  0.556198,  0.586917,  0.573056,  0.561124,  0.551550,  0.551074,  0.542865,  0.523032,  0.518915,  0.530384,  0.519058,  0.492678,  0.481090,  0.502050,  0.493310,  0.436264,  0.473111,  0.467737,  0.446932,  0.438636,  0.443460,  0.436788,  0.408295,  0.404215,  0.417260,  0.408752,  0.372778,  0.377184,  0.391381,  0.372340,  0.336632,  0.366619,  0.347621,  0.337515,  0.321396,  0.338797,  0.332960,  0.287329,  0.290351,  0.307752,  0.307171,  0.247228,  0.275141,  0.281812, },
{ 1.000000,  0.992367,  0.984510,  0.977796,  0.969936,  0.962071,  0.954182,  0.948396,  0.941311,  0.930104,  0.923099,  0.919170,  0.911707,  0.896188,  0.896963,  0.887814,  0.881259,  0.868156,  0.865815,  0.858551,  0.846462,  0.838177,  0.839870,  0.829359,  0.814969,  0.809139,  0.807159,  0.802017,  0.774949,  0.786857,  0.776693,  0.766684,  0.756125,  0.753872,  0.746121,  0.730544,  0.725331,  0.728077,  0.720228,  0.699956,  0.690196,  0.700972,  0.689587,  0.653412,  0.674122,  0.666846,  0.652870,  0.643772,  0.641740,  0.636448,  0.615095,  0.610393,  0.615964,  0.609458,  0.577896,  0.580809,  0.588741,  0.572443,  0.547031,  0.563421,  0.550515,  0.536039,  0.528127,  0.533869,  0.529277,  0.496204,  0.495698,  0.503756,  0.500487,  0.460435,  0.472164,  0.476522,  0.456347,  0.430220,  0.456222,  0.436710,  0.421452,  0.414212,  0.423925,  0.419504,  0.378717,  0.376911,  0.397235,  0.389052,  0.331281,  0.373369,  0.358633,  0.351266,  0.317184,  0.336187,  0.329991,  0.304117,  0.292550,  0.320044,  0.304224,  0.265611,  0.265448,  0.285445,  0.280511,  0.204274, },
{ 1.000000,  0.992352,  0.984590,  0.976637,  0.968472,  0.961174,  0.953859,  0.944207,  0.936580,  0.931570,  0.923764,  0.912410,  0.903889,  0.901933,  0.893147,  0.874771,  0.876967,  0.869697,  0.859578,  0.850940,  0.845501,  0.838024,  0.825236,  0.817987,  0.817277,  0.809513,  0.789135,  0.786448,  0.786934,  0.774534,  0.757140,  0.762314,  0.752152,  0.740387,  0.732187,  0.731349,  0.725312,  0.704198,  0.698704,  0.700551,  0.694985,  0.668397,  0.673147,  0.670720,  0.656814,  0.635491,  0.649548,  0.636075,  0.621825,  0.611840,  0.619788,  0.608938,  0.583115,  0.577608,  0.587189,  0.581666,  0.540240,  0.563431,  0.551964,  0.544641,  0.517212,  0.529728,  0.523267,  0.499658,  0.492009,  0.505331,  0.494922,  0.465392,  0.460003,  0.473302,  0.466951,  0.409586,  0.453491,  0.434932,  0.422866,  0.409071,  0.409129,  0.411093,  0.377985,  0.370077,  0.393420,  0.381443,  0.344788,  0.338274,  0.364705,  0.352999,  0.282193,  0.336249,  0.320850,  0.303965,  0.293987,  0.297604,  0.290715,  0.260523,  0.257257,  0.275774,  0.267957,  0.214777,  0.225111,  0.247516, },
{ 1.000000,  0.992159,  0.983253,  0.976532,  0.968531,  0.960001,  0.951741,  0.945385,  0.937487,  0.926591,  0.919081,  0.913957,  0.906644,  0.892665,  0.889092,  0.882024,  0.873401,  0.859156,  0.860310,  0.849395,  0.839566,  0.830854,  0.829526,  0.819924,  0.803715,  0.797150,  0.796272,  0.791200,  0.766079,  0.772640,  0.764688,  0.755387,  0.737439,  0.740050,  0.733621,  0.718071,  0.708662,  0.712040,  0.704462,  0.681079,  0.676582,  0.679763,  0.674293,  0.635566,  0.658930,  0.644448,  0.634494,  0.621837,  0.619911,  0.616976,  0.593504,  0.585030,  0.599422,  0.585141,  0.559811,  0.552196,  0.567824,  0.557403,  0.508104,  0.541703,  0.525858,  0.512482,  0.504917,  0.503944,  0.495863,  0.473397,  0.465536,  0.480392,  0.470756,  0.432095,  0.433833,  0.449798,  0.433002,  0.389381,  0.421770,  0.409469,  0.390381,  0.383606,  0.390751,  0.382012,  0.347881,  0.345896,  0.357549,  0.352877,  0.309024,  0.325084,  0.325652,  0.310039,  0.272888,  0.306519,  0.287702,  0.270840,  0.259958,  0.276178,  0.264947,  0.224316,  0.218973,  0.242231,  0.241474,  0.174466, },
{ 1.000000,  0.991948,  0.983927,  0.975683,  0.966348,  0.959664,  0.951346,  0.942067,  0.933597,  0.928150,  0.919934,  0.907870,  0.900365,  0.896145,  0.887972,  0.869775,  0.872607,  0.861505,  0.853537,  0.842211,  0.838701,  0.830504,  0.816320,  0.808132,  0.809196,  0.798847,  0.782873,  0.774581,  0.776647,  0.769078,  0.737928,  0.753381,  0.739741,  0.728966,  0.721198,  0.716820,  0.707943,  0.692232,  0.685037,  0.689934,  0.678656,  0.654939,  0.650940,  0.656968,  0.645278,  0.612651,  0.631161,  0.620180,  0.605806,  0.596708,  0.597785,  0.588721,  0.565840,  0.560017,  0.566594,  0.558688,  0.527311,  0.531687,  0.535503,  0.518206,  0.492840,  0.511351,  0.495246,  0.483044,  0.468346,  0.482222,  0.470039,  0.436810,  0.434519,  0.444418,  0.443613,  0.393348,  0.416606,  0.413267,  0.398643,  0.365052,  0.387987,  0.376322,  0.353899,  0.347028,  0.358699,  0.352669,  0.311456,  0.310326,  0.330145,  0.318512,  0.255537,  0.305416,  0.284473,  0.277317,  0.248554,  0.267042,  0.255048,  0.228039,  0.215040,  0.247669,  0.225994,  0.190520,  0.185869,  0.207439, },
{ 1.000000,  0.991805,  0.982306,  0.975678,  0.966761,  0.958324,  0.949667,  0.942373,  0.934143,  0.923588,  0.915816,  0.910812,  0.901737,  0.888774,  0.881344,  0.878607,  0.868775,  0.850112,  0.852747,  0.844273,  0.832250,  0.823717,  0.820169,  0.811401,  0.795962,  0.788811,  0.786889,  0.779655,  0.759317,  0.757546,  0.755603,  0.743060,  0.723683,  0.730811,  0.716623,  0.708355,  0.694480,  0.699558,  0.689920,  0.666177,  0.662155,  0.663769,  0.658888,  0.627416,  0.635476,  0.631963,  0.618643,  0.595369,  0.606407,  0.595374,  0.580073,  0.570860,  0.573911,  0.568606,  0.537988,  0.533816,  0.545496,  0.534797,  0.489610,  0.519737,  0.503794,  0.499402,  0.468266,  0.483432,  0.472773,  0.448336,  0.439426,  0.460430,  0.443150,  0.412301,  0.407931,  0.420394,  0.416955,  0.353107,  0.398474,  0.381001,  0.366150,  0.354938,  0.356252,  0.346716,  0.321492,  0.318015,  0.334842,  0.321370,  0.287054,  0.274146,  0.303512,  0.292736,  0.219082,  0.269634,  0.263541,  0.237845,  0.228107,  0.235959,  0.228789,  0.192601,  0.189355,  0.207231,  0.197485,  0.151587, },
{ 1.000000,  0.991278,  0.983300,  0.974373,  0.964534,  0.957973,  0.948775,  0.939904,  0.930600,  0.924509,  0.916391,  0.902958,  0.895849,  0.890717,  0.883467,  0.866092,  0.863847,  0.857732,  0.845669,  0.832468,  0.832119,  0.821240,  0.810481,  0.800857,  0.798743,  0.791423,  0.771193,  0.764338,  0.766302,  0.757596,  0.728553,  0.740864,  0.728501,  0.721579,  0.701131,  0.704025,  0.695302,  0.677821,  0.667723,  0.677164,  0.662916,  0.641283,  0.636256,  0.637885,  0.633089,  0.590533,  0.616149,  0.602601,  0.589695,  0.576157,  0.576485,  0.567539,  0.545670,  0.541445,  0.548873,  0.539791,  0.511130,  0.499934,  0.518869,  0.504639,  0.452686,  0.486941,  0.478571,  0.460199,  0.449310,  0.449367,  0.443513,  0.414939,  0.411021,  0.420905,  0.413765,  0.370712,  0.377858,  0.390737,  0.369363,  0.335943,  0.361428,  0.344687,  0.326722,  0.317738,  0.327522,  0.322960,  0.279370,  0.280671,  0.293270,  0.290079,  0.237231,  0.255988,  0.262654,  0.236971,  0.203760,  0.240243,  0.215361,  0.196694,  0.188551,  0.202935,  0.198447,  0.145586,  0.145549,  0.172961, },
{ 1.000000,  0.991498,  0.981437,  0.974241,  0.965118,  0.956501,  0.945675,  0.939089,  0.930348,  0.919733,  0.910490,  0.905930,  0.896297,  0.882783,  0.875207,  0.870828,  0.862723,  0.840866,  0.845810,  0.833830,  0.824128,  0.813738,  0.807806,  0.800228,  0.784394,  0.777041,  0.777048,  0.767588,  0.748764,  0.738792,  0.744397,  0.732940,  0.699817,  0.714047,  0.705936,  0.692109,  0.681780,  0.677861,  0.669360,  0.650890,  0.643729,  0.647602,  0.638704,  0.607466,  0.608351,  0.613612,  0.596529,  0.571908,  0.585082,  0.571965,  0.556752,  0.547438,  0.549999,  0.543639,  0.513760,  0.509209,  0.514881,  0.509406,  0.471893,  0.482920,  0.481668,  0.463642,  0.434760,  0.459036,  0.441000,  0.422959,  0.411158,  0.424914,  0.411663,  0.377034,  0.372289,  0.387671,  0.381990,  0.325587,  0.361365,  0.346549,  0.338402,  0.302508,  0.322117,  0.314695,  0.284342,  0.276208,  0.295697,  0.283390,  0.244875,  0.240283,  0.259231,  0.252428,  0.177077,  0.238173,  0.214493,  0.199929,  0.183427,  0.185082,  0.188768,  0.146506,  0.138582,  0.169623,  0.155745,  0.109259, },
{ 1.000000,  0.990863,  0.982606,  0.973761,  0.961589,  0.955968,  0.946623,  0.936982,  0.927788,  0.920044,  0.911249,  0.899504,  0.890919,  0.885691,  0.876941,  0.860421,  0.854622,  0.851111,  0.839446,  0.821682,  0.823586,  0.813267,  0.800953,  0.791603,  0.788573,  0.779269,  0.760557,  0.753812,  0.752551,  0.744921,  0.720944,  0.723047,  0.715893,  0.705049,  0.682540,  0.693190,  0.677700,  0.665278,  0.654813,  0.658535,  0.646224,  0.622142,  0.615804,  0.619428,  0.615267,  0.576401,  0.593131,  0.583580,  0.572520,  0.546901,  0.555426,  0.548448,  0.527489,  0.516344,  0.525224,  0.516869,  0.483748,  0.480301,  0.488249,  0.483051,  0.427329,  0.466124,  0.446913,  0.435045,  0.419156,  0.418887,  0.417186,  0.385738,  0.376348,  0.398990,  0.381342,  0.347368,  0.339274,  0.363453,  0.350847,  0.283677,  0.333293,  0.313180,  0.296589,  0.288173,  0.288662,  0.279464,  0.250590,  0.242309,  0.263941,  0.252670,  0.202040,  0.206662,  0.229575,  0.208320,  0.151928,  0.197084,  0.182125,  0.158348,  0.150911,  0.161921,  0.151780,  0.108175,  0.107677,  0.124149, },
{ 1.000000,  0.990964,  0.980976,  0.972466,  0.963684,  0.954091,  0.942702,  0.936867,  0.926909,  0.916760,  0.907168,  0.901058,  0.891528,  0.877500,  0.868651,  0.864485,  0.856680,  0.836452,  0.836622,  0.827612,  0.816993,  0.800790,  0.800690,  0.790469,  0.776943,  0.766941,  0.766381,  0.756571,  0.736307,  0.729349,  0.729987,  0.720899,  0.688335,  0.704395,  0.688415,  0.679459,  0.663793,  0.664057,  0.654716,  0.634348,  0.625348,  0.633102,  0.619780,  0.596398,  0.587379,  0.595841,  0.587344,  0.539153,  0.570487,  0.551762,  0.538123,  0.529636,  0.526637,  0.516301,  0.495137,  0.487779,  0.498449,  0.484753,  0.451599,  0.449347,  0.461332,  0.446437,  0.400868,  0.431612,  0.417843,  0.399407,  0.389207,  0.393697,  0.383047,  0.352555,  0.347277,  0.358622,  0.349677,  0.307358,  0.317243,  0.324141,  0.301947,  0.268789,  0.297060,  0.276352,  0.261507,  0.243660,  0.264722,  0.250130,  0.206800,  0.205926,  0.220842,  0.221352,  0.155277,  0.189362,  0.185768,  0.167767,  0.125181,  0.157548,  0.143253,  0.115401,  0.107963,  0.125049,  0.118262,  0.065697, },
{ 1.000000,  0.990394,  0.981726,  0.972333,  0.960228,  0.953978,  0.943924,  0.934577,  0.923165,  0.916465,  0.906847,  0.895015,  0.884828,  0.881418,  0.870051,  0.856034,  0.847160,  0.843328,  0.834718,  0.809841,  0.817005,  0.803418,  0.792623,  0.782209,  0.776519,  0.767331,  0.750947,  0.743149,  0.743284,  0.731740,  0.710094,  0.703734,  0.706901,  0.693876,  0.662062,  0.676387,  0.666416,  0.649568,  0.639814,  0.639753,  0.628964,  0.606333,  0.599732,  0.601471,  0.593974,  0.563351,  0.565904,  0.567114,  0.550268,  0.522685,  0.539080,  0.519690,  0.510306,  0.492460,  0.504171,  0.492564,  0.459218,  0.456592,  0.462324,  0.457799,  0.413323,  0.429479,  0.426510,  0.409746,  0.378430,  0.397738,  0.383991,  0.364396,  0.353782,  0.360967,  0.355411,  0.314339,  0.311480,  0.329980,  0.317143,  0.255986,  0.300959,  0.280287,  0.276177,  0.235440,  0.258875,  0.245491,  0.214511,  0.204654,  0.234461,  0.213141,  0.172857,  0.169537,  0.187915,  0.184728,  0.100970,  0.164170,  0.141891,  0.123691,  0.110235,  0.113985,  0.102916,  0.071114,  0.068643,  0.091601, },
{ 1.000000,  0.990436,  0.980404,  0.970362,  0.962549,  0.952873,  0.938678,  0.933545,  0.924114,  0.912847,  0.902897,  0.895471,  0.885999,  0.872162,  0.863402,  0.857952,  0.848381,  0.831491,  0.825362,  0.821153,  0.808075,  0.790575,  0.792099,  0.778875,  0.768257,  0.755874,  0.754534,  0.745400,  0.722376,  0.716722,  0.716050,  0.708945,  0.678740,  0.683927,  0.679330,  0.662058,  0.643006,  0.650155,  0.635713,  0.621577,  0.610343,  0.612432,  0.605054,  0.574066,  0.568047,  0.576611,  0.566499,  0.521911,  0.548033,  0.531562,  0.524629,  0.495315,  0.504866,  0.494568,  0.470820,  0.459199,  0.477283,  0.458951,  0.428758,  0.425238,  0.430662,  0.426776,  0.366074,  0.407884,  0.390330,  0.374188,  0.357380,  0.360930,  0.350335,  0.321632,  0.318402,  0.331362,  0.320780,  0.282835,  0.269953,  0.298525,  0.280865,  0.210978,  0.260966,  0.251352,  0.228036,  0.215122,  0.217457,  0.211439,  0.174277,  0.171743,  0.186282,  0.178783,  0.122749,  0.134977,  0.153590,  0.126303,  0.084044,  0.119827,  0.098848,  0.076910,  0.066645,  0.081361,  0.076887,  0.021164, },
{ 1.000000,  0.989893,  0.980571,  0.970941,  0.958860,  0.950597,  0.941700,  0.930404,  0.918187,  0.912899,  0.901073,  0.890053,  0.880035,  0.873508,  0.864468,  0.847079,  0.838544,  0.835397,  0.825331,  0.801767,  0.805852,  0.793749,  0.783915,  0.765671,  0.764661,  0.754815,  0.738675,  0.727647,  0.729803,  0.716999,  0.695491,  0.688758,  0.689217,  0.680544,  0.642159,  0.661790,  0.645343,  0.633297,  0.619944,  0.616216,  0.608054,  0.585178,  0.578260,  0.584090,  0.572657,  0.545427,  0.533755,  0.547928,  0.533659,  0.482965,  0.511675,  0.502536,  0.484574,  0.471912,  0.470298,  0.460432,  0.435452,  0.428521,  0.437439,  0.427336,  0.383088,  0.388791,  0.399451,  0.376928,  0.343877,  0.366775,  0.349851,  0.330575,  0.320090,  0.326427,  0.320214,  0.279756,  0.276757,  0.286865,  0.281607,  0.230969,  0.250084,  0.249830,  0.226668,  0.189331,  0.225454,  0.202250,  0.179712,  0.166052,  0.186441,  0.170760,  0.125519,  0.121580,  0.144251,  0.137944,  0.064231,  0.114927,  0.096345,  0.087007,  0.041554,  0.069576,  0.060429,  0.022776,  0.013724,  0.040815, },
{ 1.000000,  0.990147,  0.979745,  0.969698,  0.960909,  0.951193,  0.936675,  0.932100,  0.920807,  0.910252,  0.899499,  0.890828,  0.882452,  0.867625,  0.857875,  0.854300,  0.843605,  0.826902,  0.817294,  0.815911,  0.805047,  0.777430,  0.785318,  0.772970,  0.760217,  0.749666,  0.743553,  0.733707,  0.715938,  0.708018,  0.707157,  0.697397,  0.670039,  0.667628,  0.669167,  0.653059,  0.625997,  0.637990,  0.624956,  0.608511,  0.597981,  0.598829,  0.588093,  0.560577,  0.555575,  0.558550,  0.550623,  0.515398,  0.524346,  0.517086,  0.503763,  0.472463,  0.494131,  0.473456,  0.457989,  0.445820,  0.455354,  0.440124,  0.407057,  0.401979,  0.410608,  0.407508,  0.353072,  0.381876,  0.370347,  0.357225,  0.323326,  0.339192,  0.331508,  0.304404,  0.291738,  0.306790,  0.297311,  0.253522,  0.252223,  0.265417,  0.260344,  0.185861,  0.242310,  0.217741,  0.203651,  0.184453,  0.186691,  0.186046,  0.145988,  0.136058,  0.167534,  0.146219,  0.102765,  0.095244,  0.128382,  0.113451,  0.026728,  0.094335,  0.069230,  0.049304,  0.040148,  0.042925,  0.032166, -0.003575, },
{ 1.000000,  0.989558,  0.979689,  0.969541,  0.957091,  0.947421,  0.939153,  0.927991,  0.912947,  0.908193,  0.897050,  0.884922,  0.874792,  0.867317,  0.856950,  0.840628,  0.831809,  0.825948,  0.816556,  0.796287,  0.793171,  0.784791,  0.772179,  0.752367,  0.755900,  0.741671,  0.728091,  0.716861,  0.715222,  0.703722,  0.680838,  0.671918,  0.673222,  0.665836,  0.630973,  0.641401,  0.631102,  0.617674,  0.593573,  0.601031,  0.588127,  0.569608,  0.557996,  0.563187,  0.551571,  0.521521,  0.515685,  0.521991,  0.511550,  0.462129,  0.494017,  0.472244,  0.462032,  0.441485,  0.446189,  0.435095,  0.407188,  0.397557,  0.413230,  0.396330,  0.364309,  0.354652,  0.370672,  0.360958,  0.292909,  0.342878,  0.318106,  0.301024,  0.291833,  0.290617,  0.278109,  0.250728,  0.243289,  0.260707,  0.243857,  0.199710,  0.199761,  0.218875,  0.199942,  0.139336,  0.184699,  0.167628,  0.144524,  0.132699,  0.141040,  0.128400,  0.089085,  0.084617,  0.101524,  0.091343,  0.036169,  0.052750,  0.063092,  0.035353, -0.007192,  0.033154,  0.006686, -0.011222, -0.032660, -0.003290, },
{ 1.000000,  0.989631,  0.978140,  0.967661,  0.957971,  0.948184,  0.933334,  0.926257,  0.916058,  0.904686,  0.889937,  0.884617,  0.873182,  0.859930,  0.849326,  0.843191,  0.832957,  0.814311,  0.805553,  0.802285,  0.790628,  0.764071,  0.771003,  0.756190,  0.745805,  0.728437,  0.726938,  0.714916,  0.697440,  0.685344,  0.689393,  0.673861,  0.652302,  0.643549,  0.644685,  0.635641,  0.592749,  0.616318,  0.596850,  0.583651,  0.571143,  0.567531,  0.556930,  0.533870,  0.526419,  0.532150,  0.517624,  0.486095,  0.480776,  0.491159,  0.474169,  0.426975,  0.455215,  0.443318,  0.420802,  0.409607,  0.413954,  0.400828,  0.369855,  0.363600,  0.369961,  0.362077,  0.319319,  0.327152,  0.332041,  0.309826,  0.272527,  0.300144,  0.274828,  0.264078,  0.241219,  0.261228,  0.247233,  0.201981,  0.201627,  0.212103,  0.208373,  0.147774,  0.174246,  0.171818,  0.151186,  0.109647,  0.139472,  0.122268,  0.097591,  0.085199,  0.097687,  0.091758,  0.038067,  0.037026,  0.063830,  0.047916, -0.032057,  0.031156,  0.004643,  0.000549, -0.051323, -0.017866, -0.034343, -0.073424, },
{ 1.000000,  0.989013,  0.978807,  0.967846,  0.955368,  0.944790,  0.935927,  0.925594,  0.907683,  0.904150,  0.891886,  0.879998,  0.868378,  0.859608,  0.848517,  0.833726,  0.824149,  0.819079,  0.807103,  0.789200,  0.777279,  0.777100,  0.765218,  0.734228,  0.742350,  0.731848,  0.715189,  0.703563,  0.698835,  0.688338,  0.666796,  0.658209,  0.657074,  0.645995,  0.619129,  0.616149,  0.616499,  0.598538,  0.571816,  0.583361,  0.564825,  0.552333,  0.536233,  0.540548,  0.530517,  0.495600,  0.492378,  0.496532,  0.489704,  0.444512,  0.458611,  0.455610,  0.432259,  0.406151,  0.422327,  0.403442,  0.385751,  0.372368,  0.379734,  0.371747,  0.328459,  0.323755,  0.339982,  0.327865,  0.264934,  0.307866,  0.285895,  0.279183,  0.239594,  0.257007,  0.244724,  0.213305,  0.200307,  0.228223,  0.205122,  0.165257,  0.163251,  0.173434,  0.170319,  0.088284,  0.149808,  0.126851,  0.106981,  0.086433,  0.093947,  0.081029,  0.044295,  0.042866,  0.061978,  0.049577,  0.000370, -0.013844,  0.025458,  0.004124, -0.086895, -0.018070, -0.029481, -0.058727, -0.073883, -0.068367, },
{ 1.000000,  0.988857,  0.977203,  0.965987,  0.955824,  0.945032,  0.930414,  0.921052,  0.912377,  0.899345,  0.884350,  0.878833,  0.865989,  0.853100,  0.841635,  0.834500,  0.824482,  0.804495,  0.796054,  0.790220,  0.780558,  0.756300,  0.753899,  0.746909,  0.730427,  0.710793,  0.715140,  0.698027,  0.683249,  0.672234,  0.669826,  0.659935,  0.631311,  0.623857,  0.627093,  0.615504,  0.575785,  0.593813,  0.577603,  0.566555,  0.539540,  0.545312,  0.533838,  0.511624,  0.498351,  0.508331,  0.492142,  0.460619,  0.455434,  0.461523,  0.451869,  0.393809,  0.431544,  0.409145,  0.394781,  0.378064,  0.376682,  0.367936,  0.336690,  0.330247,  0.343024,  0.329470,  0.291673,  0.278768,  0.303076,  0.285126,  0.213820,  0.259892,  0.249229,  0.226388,  0.211102,  0.212136,  0.200730,  0.167980,  0.161480,  0.176335,  0.164884,  0.105473,  0.116818,  0.134033,  0.104910,  0.061646,  0.096556,  0.075004,  0.050597,  0.038941,  0.050167,  0.043672, -0.009185, -0.010060,  0.005103, -0.000056, -0.066157, -0.037272, -0.036388, -0.065477, -0.113237, -0.062456, -0.091986, -0.120129, },
{ 1.000000,  0.988299,  0.977384,  0.965845,  0.952607,  0.941223,  0.931934,  0.920855,  0.903156,  0.897923,  0.885418,  0.874028,  0.857480,  0.851579,  0.840114,  0.824126,  0.812631,  0.808039,  0.795596,  0.775965,  0.765837,  0.762158,  0.751306,  0.718819,  0.730103,  0.713270,  0.699867,  0.685424,  0.678090,  0.670616,  0.646408,  0.635575,  0.639445,  0.626027,  0.598814,  0.588688,  0.595430,  0.581797,  0.533974,  0.558622,  0.542201,  0.525434,  0.512460,  0.508397,  0.497051,  0.471541,  0.463674,  0.468014,  0.456736,  0.414882,  0.417028,  0.424565,  0.402355,  0.362776,  0.387766,  0.370747,  0.348815,  0.336200,  0.341872,  0.329069,  0.290044,  0.286714,  0.294826,  0.286208,  0.235653,  0.253796,  0.246100,  0.229326,  0.185534,  0.221755,  0.193943,  0.174348,  0.159279,  0.176696,  0.157300,  0.112325,  0.108248,  0.123411,  0.121319,  0.046029,  0.090752,  0.076038,  0.060142,  0.014537,  0.040132,  0.031078, -0.004422, -0.019571,  0.003858, -0.007686, -0.065773, -0.064767, -0.044659, -0.049860, -0.149724, -0.069782, -0.101847, -0.119050, -0.143335, -0.137901, },
{ 1.000000,  0.988346,  0.975901,  0.963872,  0.953999,  0.941538,  0.927260,  0.915501,  0.907794,  0.895692,  0.874549,  0.872635,  0.858776,  0.845274,  0.833507,  0.823990,  0.811995,  0.795223,  0.783768,  0.779946,  0.767610,  0.743512,  0.735908,  0.733843,  0.717862,  0.690310,  0.697313,  0.683034,  0.665911,  0.654579,  0.650632,  0.638110,  0.612351,  0.604339,  0.602780,  0.592638,  0.560086,  0.563713,  0.555727,  0.538973,  0.509102,  0.524165,  0.504482,  0.486956,  0.473550,  0.477751,  0.463438,  0.430125,  0.420884,  0.428889,  0.421691,  0.369282,  0.392240,  0.379912,  0.363392,  0.329357,  0.346496,  0.329922,  0.305649,  0.291913,  0.304314,  0.290149,  0.248558,  0.244116,  0.256882,  0.244677,  0.174542,  0.226166,  0.197006,  0.185447,  0.158748,  0.169113,  0.155817,  0.119164,  0.108253,  0.133413,  0.112282,  0.069503,  0.059606,  0.084480,  0.073283, -0.019028,  0.054076,  0.021209,  0.000364, -0.010095, -0.008656, -0.023989, -0.058974, -0.066262, -0.040965, -0.061697, -0.119451, -0.116149, -0.088570, -0.112409, -0.191463, -0.127750, -0.149426, -0.178371, },
{ 1.000000,  0.987839,  0.975961,  0.963948,  0.950488,  0.938609,  0.928194,  0.916309,  0.899869,  0.890649,  0.880706,  0.866497,  0.849762,  0.845100,  0.830437,  0.817045,  0.802998,  0.798247,  0.784770,  0.763414,  0.753649,  0.748314,  0.739246,  0.708908,  0.711340,  0.700689,  0.685638,  0.661580,  0.664741,  0.650442,  0.631397,  0.619836,  0.618218,  0.606861,  0.576642,  0.569511,  0.572303,  0.558083,  0.513796,  0.537018,  0.516186,  0.504826,  0.480021,  0.484993,  0.470021,  0.445895,  0.431419,  0.444544,  0.423729,  0.393282,  0.384445,  0.392003,  0.382056,  0.317720,  0.361176,  0.334601,  0.318212,  0.303459,  0.302415,  0.290035,  0.258790,  0.251883,  0.264261,  0.246314,  0.202641,  0.199149,  0.217736,  0.196042,  0.130218,  0.175844,  0.160972,  0.131958,  0.118921,  0.128449,  0.112544,  0.071300,  0.065815,  0.077560,  0.069359,  0.011602,  0.026530,  0.035262,  0.006604, -0.042509, -0.000852, -0.033639, -0.045918, -0.074892, -0.044475, -0.061749, -0.120925, -0.118882, -0.102578, -0.105567, -0.185275, -0.146489, -0.148273, -0.173643, -0.227322, -0.184752, },
{ 1.000000,  0.987516,  0.974864,  0.962122,  0.950865,  0.938748,  0.923060,  0.911368,  0.902317,  0.889593,  0.868706,  0.865573,  0.851017,  0.839488,  0.820534,  0.815483,  0.801838,  0.784147,  0.771468,  0.769593,  0.753714,  0.731958,  0.721820,  0.717850,  0.707479,  0.669649,  0.682787,  0.665301,  0.649528,  0.635557,  0.628533,  0.614944,  0.593694,  0.584268,  0.585125,  0.569640,  0.541706,  0.528328,  0.537129,  0.522425,  0.470998,  0.495189,  0.483259,  0.459881,  0.446360,  0.445054,  0.432643,  0.401931,  0.393615,  0.397843,  0.384747,  0.344922,  0.346956,  0.352258,  0.327826,  0.290121,  0.313955,  0.289086,  0.273912,  0.253161,  0.264811,  0.252860,  0.203932,  0.203552,  0.213541,  0.206841,  0.142830,  0.168921,  0.167135,  0.136473,  0.101464,  0.128983,  0.104601,  0.082134,  0.066205,  0.080325,  0.070974,  0.012310,  0.009743,  0.035210,  0.020652, -0.065169, -0.001335, -0.030110, -0.036920, -0.089148, -0.061618, -0.076980, -0.117580, -0.132533, -0.091853, -0.121461, -0.173583, -0.173142, -0.157354, -0.159683, -0.268112, -0.181957, -0.211680, -0.236671, },
{ 1.000000,  0.987018,  0.974552,  0.961724,  0.947613,  0.935183,  0.924500,  0.911496,  0.894999,  0.881693,  0.874678,  0.860709,  0.836488,  0.835460,  0.822587,  0.806650,  0.792893,  0.783448,  0.771293,  0.750925,  0.739973,  0.734098,  0.721835,  0.694244,  0.689185,  0.685457,  0.666335,  0.641708,  0.646086,  0.628405,  0.610970,  0.597690,  0.595115,  0.583977,  0.551558,  0.544851,  0.543542,  0.533757,  0.493925,  0.499689,  0.494649,  0.471388,  0.443032,  0.459368,  0.435039,  0.416141,  0.403184,  0.406068,  0.395088,  0.352322,  0.346564,  0.357850,  0.343691,  0.284161,  0.319706,  0.297869,  0.285566,  0.247738,  0.262098,  0.248030,  0.217969,  0.202280,  0.222045,  0.200944,  0.157575,  0.154701,  0.167002,  0.156305,  0.074088,  0.133910,  0.104363,  0.086760,  0.065609,  0.067815,  0.057375,  0.016046,  0.010768,  0.031602,  0.015179, -0.035182, -0.049713, -0.013020, -0.035930, -0.132568, -0.064609, -0.077941, -0.106653, -0.125274, -0.120746, -0.134265, -0.176497, -0.182529, -0.160375, -0.174325, -0.252286, -0.233220, -0.208450, -0.245950, -0.301611, -0.251839, },
{ 1.000000,  0.986744,  0.973346,  0.959886,  0.947664,  0.935005,  0.918661,  0.906081,  0.895442,  0.882929,  0.862990,  0.855072,  0.843456,  0.827472,  0.808272,  0.805693,  0.788951,  0.772619,  0.758358,  0.753404,  0.738703,  0.714712,  0.703448,  0.700652,  0.688407,  0.653070,  0.661804,  0.644959,  0.631991,  0.605288,  0.607141,  0.593484,  0.569267,  0.556300,  0.558767,  0.543246,  0.512618,  0.502876,  0.505629,  0.493380,  0.439300,  0.470561,  0.446831,  0.430108,  0.411640,  0.406382,  0.399582,  0.364308,  0.352870,  0.365723,  0.349213,  0.309690,  0.299284,  0.315893,  0.298842,  0.227010,  0.272269,  0.250836,  0.229493,  0.214039,  0.212809,  0.198881,  0.164514,  0.157091,  0.167677,  0.154467,  0.095819,  0.103779,  0.118384,  0.088768,  0.034876,  0.075792,  0.053902,  0.025533,  0.010668,  0.022443,  0.007079, -0.045498, -0.046016, -0.031978, -0.041442, -0.109755, -0.080352, -0.088513, -0.109361, -0.167686, -0.113806, -0.150145, -0.174573, -0.192784, -0.166239, -0.190747, -0.249596, -0.251854, -0.228760, -0.229907, -0.329780, -0.265396, -0.284244, -0.303047, },
{ 1.000000,  0.986017,  0.973065,  0.959657,  0.944918,  0.930947,  0.919895,  0.906419,  0.888160,  0.875733,  0.865847,  0.853215,  0.827041,  0.827140,  0.810298,  0.795760,  0.779767,  0.769467,  0.758168,  0.736172,  0.722655,  0.721378,  0.704202,  0.679564,  0.667212,  0.668268,  0.652945,  0.610706,  0.626638,  0.606906,  0.589554,  0.576045,  0.568175,  0.553737,  0.529039,  0.516749,  0.519984,  0.504617,  0.465990,  0.461979,  0.467095,  0.445006,  0.402180,  0.424094,  0.405367,  0.382256,  0.369494,  0.369832,  0.355112,  0.317547,  0.310892,  0.314379,  0.303005,  0.255012,  0.267626,  0.259644,  0.238290,  0.195648,  0.225631,  0.198892,  0.176341,  0.160344,  0.171918,  0.153866,  0.107631,  0.098900,  0.114574,  0.107500,  0.033221,  0.072196,  0.057121,  0.036715, -0.009502,  0.019530, -0.001056, -0.032608, -0.048784, -0.027540, -0.045139, -0.101079, -0.103305, -0.082928, -0.097055, -0.192669, -0.116624, -0.154955, -0.168335, -0.202503, -0.185342, -0.201332, -0.248911, -0.260587, -0.223738, -0.250405, -0.306391, -0.316392, -0.280785, -0.294261, -0.416238, -0.314651, },
{ 1.000000,  0.985949,  0.971880,  0.957757,  0.944338,  0.930310,  0.914490,  0.900627,  0.890092,  0.875477,  0.855826,  0.843555,  0.835239,  0.819371,  0.794244,  0.793340,  0.777411,  0.760028,  0.745732,  0.737073,  0.722318,  0.699320,  0.687564,  0.681932,  0.668017,  0.638326,  0.634833,  0.627551,  0.607229,  0.580272,  0.586950,  0.566020,  0.548698,  0.530313,  0.533498,  0.515928,  0.482043,  0.473134,  0.473505,  0.465047,  0.414938,  0.430355,  0.418413,  0.398700,  0.362635,  0.377253,  0.358724,  0.332438,  0.319511,  0.324169,  0.310587,  0.266210,  0.261099,  0.271578,  0.253823,  0.187336,  0.231353,  0.202634,  0.189838,  0.155802,  0.169115,  0.150418,  0.117604,  0.100319,  0.124958,  0.097165,  0.055229,  0.047198,  0.062423,  0.050891, -0.040454,  0.028888, -0.007272, -0.027842, -0.045458, -0.042460, -0.057953, -0.099165, -0.105155, -0.084545, -0.107288, -0.166100, -0.166872, -0.138296, -0.166461, -0.255408, -0.187424, -0.206513, -0.243942, -0.258697, -0.242236, -0.262484, -0.316618, -0.320541, -0.302078, -0.311444, -0.388093, -0.363295, -0.350218, -0.387755, },
{ 1.000000,  0.984896,  0.971542,  0.956337,  0.941686,  0.926207,  0.914763,  0.900112,  0.880913,  0.867647,  0.856648,  0.843384,  0.819002,  0.812480,  0.799497,  0.782940,  0.760549,  0.756604,  0.740290,  0.721669,  0.706434,  0.699411,  0.686065,  0.657576,  0.646592,  0.644795,  0.628395,  0.588092,  0.602089,  0.580907,  0.568737,  0.537900,  0.542100,  0.524412,  0.498081,  0.483542,  0.491424,  0.469437,  0.436077,  0.426452,  0.429075,  0.417742,  0.355298,  0.389789,  0.364926,  0.344717,  0.327168,  0.322890,  0.306279,  0.276476,  0.267783,  0.275461,  0.255417,  0.215145,  0.199944,  0.219988,  0.200817,  0.124414,  0.169626,  0.154756,  0.123202,  0.106910,  0.110513,  0.095461,  0.052979,  0.045229,  0.055877,  0.040200, -0.015831, -0.007283,  0.004174, -0.028949, -0.080224, -0.040310, -0.073917, -0.092203, -0.119279, -0.097804, -0.112586, -0.179493, -0.175738, -0.158746, -0.165752, -0.252810, -0.211837, -0.212060, -0.251945, -0.298465, -0.255971, -0.288100, -0.316390, -0.335504, -0.312765, -0.324129, -0.402075, -0.401780, -0.364093, -0.382903, -0.497184, -0.406766, },
{ 1.000000,  0.985184,  0.970550,  0.954196,  0.941135,  0.926146,  0.909186,  0.893894,  0.884172,  0.867413,  0.847747,  0.834421,  0.823588,  0.810363,  0.779696,  0.781811,  0.763772,  0.746495,  0.728986,  0.719705,  0.703770,  0.681165,  0.669332,  0.664241,  0.648606,  0.620034,  0.604627,  0.607646,  0.588871,  0.543017,  0.560060,  0.544565,  0.521944,  0.504848,  0.498176,  0.484293,  0.453286,  0.443170,  0.442505,  0.428191,  0.384504,  0.385329,  0.387438,  0.360406,  0.323879,  0.340956,  0.316695,  0.293926,  0.278065,  0.281498,  0.269344,  0.221291,  0.217070,  0.221218,  0.211049,  0.151791,  0.168226,  0.165314,  0.133488,  0.094162,  0.125483,  0.092134,  0.068054,  0.053337,  0.062872,  0.050064, -0.010004, -0.013509,  0.007738, -0.009730, -0.094171, -0.036514, -0.065495, -0.079406, -0.131048, -0.105398, -0.122615, -0.162403, -0.181152, -0.149092, -0.176513, -0.234602, -0.234408, -0.214372, -0.226711, -0.339001, -0.251383, -0.289945, -0.311531, -0.337812, -0.330938, -0.343982, -0.397855, -0.401564, -0.370375, -0.390933, -0.456883, -0.472971, -0.421126, -0.450308, },
{ 1.000000,  0.983703,  0.969674,  0.954454,  0.938394,  0.922595,  0.908572,  0.893200,  0.874931,  0.860156,  0.848919,  0.833522,  0.808825,  0.798235,  0.788961,  0.769326,  0.745972,  0.742834,  0.724259,  0.704949,  0.689201,  0.681140,  0.666996,  0.637804,  0.626333,  0.619947,  0.606697,  0.570666,  0.571328,  0.560238,  0.537506,  0.506960,  0.518337,  0.494147,  0.471493,  0.454422,  0.457038,  0.437828,  0.400552,  0.389868,  0.394946,  0.380996,  0.323613,  0.350002,  0.327527,  0.312837,  0.273129,  0.285239,  0.268413,  0.233995,  0.219333,  0.231030,  0.210749,  0.166571,  0.157996,  0.167963,  0.153946,  0.073113,  0.129334,  0.096905,  0.076212,  0.052216,  0.050324,  0.043646, -0.005623, -0.017274,  0.006975, -0.014204, -0.068613, -0.079008, -0.050510, -0.072137, -0.173588, -0.102870, -0.130604, -0.157310, -0.176394, -0.173446, -0.190664, -0.236287, -0.242952, -0.224374, -0.240342, -0.320083, -0.304267, -0.280885, -0.320662, -0.391648, -0.330256, -0.359436, -0.395469, -0.413164, -0.393971, -0.412738, -0.481973, -0.479066, -0.457390, -0.468222, -0.558983, -0.515012, },
{ 1.000000,  0.984259,  0.968296,  0.950375,  0.937625,  0.920451,  0.903711,  0.887034,  0.875078,  0.858121,  0.836690,  0.822040,  0.811168,  0.797196,  0.766866,  0.764634,  0.747405,  0.730544,  0.705097,  0.700272,  0.684685,  0.661047,  0.644015,  0.640102,  0.623575,  0.591262,  0.580277,  0.576101,  0.562429,  0.511567,  0.532940,  0.508163,  0.489952,  0.468296,  0.460254,  0.448885,  0.414867,  0.399710,  0.409194,  0.385925,  0.348196,  0.335545,  0.347483,  0.327636,  0.258437,  0.297150,  0.269832,  0.247499,  0.231279,  0.225981,  0.207919,  0.173188,  0.159916,  0.172093,  0.152976,  0.095884,  0.096530,  0.110440,  0.079918,  0.018188,  0.059588,  0.034379,  0.003778, -0.011122, -0.004888, -0.023063, -0.075868, -0.080577, -0.070545, -0.083356, -0.151387, -0.126738, -0.134907, -0.162583, -0.221778, -0.172203, -0.208543, -0.237418, -0.256873, -0.235516, -0.258875, -0.321576, -0.329601, -0.303511, -0.311116, -0.413561, -0.353400, -0.372445, -0.397908, -0.459778, -0.415173, -0.441389, -0.482614, -0.501935, -0.468865, -0.491557, -0.565618, -0.564952, -0.534398, -0.551507, },
{ 1.000000,  0.982484,  0.967746,  0.950441,  0.934072,  0.916105,  0.901933,  0.885197,  0.865430,  0.848773,  0.838584,  0.820383,  0.797789,  0.781626,  0.773424,  0.756889,  0.720140,  0.725945,  0.703624,  0.684461,  0.668255,  0.656280,  0.638372,  0.614118,  0.599316,  0.595732,  0.576100,  0.541918,  0.531538,  0.530829,  0.508644,  0.464425,  0.480723,  0.459169,  0.434952,  0.417577,  0.413217,  0.395036,  0.359758,  0.348220,  0.348389,  0.331948,  0.284604,  0.289777,  0.285112,  0.256723,  0.216257,  0.238399,  0.208430,  0.186266,  0.162641,  0.176374,  0.152502,  0.102999,  0.095377,  0.102653,  0.094742,  0.018950,  0.051351,  0.037429,  0.012017, -0.039466, -0.010184, -0.034461, -0.069537, -0.084890, -0.071682, -0.088714, -0.151336, -0.153396, -0.133179, -0.156088, -0.251141, -0.179951, -0.218839, -0.233984, -0.279501, -0.255449, -0.279211, -0.323250, -0.343766, -0.304850, -0.341784, -0.398411, -0.406129, -0.380324, -0.394151, -0.520119, -0.417687, -0.466178, -0.491977, -0.513729, -0.504857, -0.524905, -0.579106, -0.583959, -0.552433, -0.582045, -0.660325, -0.657133, },
{ 1.000000,  0.983236,  0.966024,  0.945946,  0.932550,  0.915179,  0.896377,  0.879067,  0.865078,  0.847334,  0.825250,  0.809507,  0.797088,  0.780791,  0.753077,  0.742912,  0.730728,  0.708874,  0.681302,  0.680327,  0.656708,  0.639325,  0.616836,  0.614645,  0.595131,  0.561085,  0.549196,  0.542803,  0.529146,  0.484176,  0.489221,  0.475767,  0.453321,  0.417655,  0.425830,  0.403815,  0.377820,  0.359429,  0.358082,  0.342692,  0.297342,  0.288134,  0.295599,  0.274005,  0.208697,  0.245434,  0.215213,  0.201891,  0.156093,  0.172474,  0.149396,  0.111946,  0.095444,  0.116026,  0.085260,  0.037316,  0.028949,  0.039676,  0.027054, -0.067444, -0.004867, -0.039364, -0.065743, -0.087651, -0.087685, -0.109081, -0.149227, -0.157341, -0.140494, -0.166837, -0.223842, -0.240109, -0.205634, -0.231578, -0.339149, -0.266679, -0.285870, -0.327703, -0.347861, -0.337214, -0.356125, -0.413772, -0.420544, -0.401978, -0.420985, -0.498079, -0.480490, -0.461370, -0.505642, -0.574890, -0.513540, -0.558979, -0.580931, -0.616070, -0.581482, -0.600839, -0.690215, -0.681401, -0.655156, -0.662801, },
{ 1.000000,  0.981409,  0.964691,  0.947451,  0.928512,  0.908596,  0.894891,  0.875841,  0.856560,  0.838005,  0.825079,  0.807580,  0.780516,  0.765077,  0.755975,  0.737329,  0.700750,  0.703639,  0.680784,  0.664846,  0.634536,  0.630357,  0.610914,  0.583466,  0.565049,  0.566484,  0.541880,  0.509014,  0.496457,  0.490348,  0.476496,  0.417681,  0.443422,  0.417160,  0.393470,  0.369955,  0.365080,  0.344104,  0.310605,  0.299351,  0.301496,  0.281228,  0.236908,  0.219006,  0.234958,  0.209078,  0.134710,  0.176196,  0.156299,  0.124679,  0.102516,  0.100095,  0.083222,  0.037924,  0.028300,  0.034662,  0.016674, -0.048441, -0.038564, -0.029150, -0.067483, -0.119973, -0.085407, -0.119492, -0.149010, -0.169150, -0.156847, -0.171768, -0.240963, -0.241895, -0.230434, -0.241777, -0.327422, -0.296121, -0.296726, -0.339544, -0.393622, -0.342149, -0.388361, -0.419360, -0.436874, -0.418395, -0.434739, -0.517718, -0.518158, -0.483429, -0.506115, -0.624502, -0.536823, -0.576057, -0.592114, -0.661952, -0.620520, -0.643171, -0.696185, -0.719390, -0.670284, -0.707172, -0.785044, -0.780591, },
{ 1.000000,  0.981673,  0.963626,  0.941185,  0.927317,  0.907399,  0.888499,  0.868768,  0.852470,  0.833882,  0.810612,  0.793372,  0.781659,  0.762356,  0.735103,  0.716189,  0.710204,  0.688985,  0.646303,  0.651989,  0.633141,  0.609423,  0.588541,  0.576776,  0.557671,  0.528205,  0.512270,  0.506994,  0.487446,  0.442417,  0.437992,  0.435440,  0.405492,  0.367718,  0.378908,  0.352221,  0.325602,  0.305947,  0.303853,  0.286940,  0.239917,  0.229766,  0.229325,  0.214222,  0.155865,  0.168468,  0.157770,  0.125154,  0.079251,  0.109673,  0.074242,  0.042975,  0.021909,  0.034695,  0.008787, -0.047009, -0.056810, -0.040733, -0.058206, -0.146235, -0.095210, -0.126053, -0.143400, -0.200930, -0.174522, -0.196836, -0.245242, -0.262586, -0.237936, -0.265918, -0.328939, -0.335616, -0.315285, -0.332682, -0.450241, -0.359668, -0.404358, -0.431152, -0.462713, -0.459513, -0.467756, -0.536210, -0.547728, -0.507897, -0.536456, -0.611073, -0.621744, -0.576873, -0.606216, -0.748358, -0.642415, -0.679279, -0.713575, -0.737932, -0.728951, -0.751726, -0.812623, -0.818763, -0.789140, -0.810406, },
{ 1.000000,  0.980211,  0.961111,  0.943436,  0.922941,  0.900070,  0.886402,  0.866032,  0.844585,  0.824966,  0.810053,  0.790569,  0.763115,  0.746748,  0.733651,  0.715378,  0.681412,  0.674212,  0.656464,  0.634582,  0.600970,  0.604123,  0.576433,  0.553375,  0.532037,  0.527757,  0.503830,  0.466937,  0.452264,  0.448573,  0.433743,  0.376171,  0.392801,  0.369880,  0.348330,  0.307115,  0.313499,  0.293967,  0.258511,  0.236906,  0.243171,  0.221023,  0.170304,  0.161020,  0.164518,  0.148611,  0.064342,  0.114831,  0.079087,  0.055419,  0.025877,  0.021496,  0.009050, -0.041571, -0.058497, -0.034780, -0.066841, -0.122001, -0.135263, -0.108665, -0.135188, -0.241106, -0.172158, -0.209636, -0.238821, -0.258661, -0.260443, -0.284165, -0.332837, -0.346670, -0.322727, -0.348152, -0.430719, -0.423501, -0.397389, -0.440724, -0.527377, -0.458995, -0.493705, -0.534546, -0.553213, -0.538874, -0.562081, -0.635272, -0.637336, -0.618456, -0.634153, -0.729534, -0.688144, -0.696618, -0.733842, -0.815999, -0.738611, -0.788903, -0.826584, -0.851476, -0.815634, -0.847221, -0.932467, -0.939724, },
{ 1.000000,  0.980143,  0.960245,  0.936706,  0.919944,  0.899729,  0.878993,  0.854233,  0.840220,  0.818776,  0.795344,  0.774466,  0.761717,  0.740394,  0.710016,  0.692842,  0.681726,  0.661211,  0.616419,  0.624207,  0.595994,  0.575677,  0.548137,  0.538962,  0.517743,  0.484524,  0.465008,  0.465326,  0.439498,  0.401292,  0.382897,  0.384936,  0.363695,  0.293429,  0.327779,  0.293119,  0.267502,  0.247191,  0.237749,  0.213758,  0.177897,  0.161274,  0.167000,  0.139757,  0.085220,  0.077546,  0.087436,  0.055408, -0.015328,  0.025807, -0.005124, -0.038818, -0.061058, -0.059023, -0.082661, -0.135470, -0.146863, -0.138521, -0.159521, -0.231378, -0.213911, -0.215237, -0.255449, -0.315561, -0.271160, -0.314335, -0.343982, -0.374669, -0.346124, -0.379602, -0.451305, -0.457245, -0.439974, -0.448183, -0.560314, -0.503432, -0.520741, -0.554646, -0.627833, -0.577806, -0.610380, -0.658554, -0.677473, -0.651970, -0.675026, -0.762837, -0.760747, -0.727206, -0.757744, -0.893872, -0.783762, -0.837612, -0.856317, -0.918210, -0.879333, -0.909986, -0.970361, -0.995882, -0.936113, -0.987129, },
{ 1.000000,  0.978682,  0.957607,  0.938295,  0.917785,  0.889563,  0.877486,  0.853934,  0.832018,  0.810385,  0.792971,  0.771447,  0.744945,  0.725581,  0.712895,  0.689640,  0.656659,  0.639581,  0.631172,  0.605177,  0.560558,  0.567716,  0.543952,  0.514767,  0.493655,  0.485157,  0.461238,  0.424192,  0.407475,  0.400671,  0.381237,  0.332258,  0.330478,  0.321140,  0.288191,  0.243029,  0.259970,  0.224202,  0.202645,  0.170897,  0.181760,  0.154343,  0.100007,  0.089300,  0.089632,  0.074714,  0.000443,  0.022733,  0.007892, -0.023185, -0.077355, -0.052413, -0.082391, -0.118793, -0.142387, -0.134829, -0.154449, -0.222491, -0.229194, -0.209240, -0.238439, -0.338792, -0.270191, -0.312914, -0.329262, -0.394456, -0.361634, -0.392409, -0.445199, -0.465516, -0.427261, -0.471287, -0.539011, -0.546342, -0.523300, -0.539060, -0.677913, -0.575927, -0.624380, -0.659434, -0.687732, -0.681217, -0.709708, -0.763888, -0.771640, -0.741687, -0.777912, -0.858728, -0.875880, -0.821421, -0.859438, -1.008692, -0.897333, -0.923814, -0.980427, -1.006146, -0.984822, -1.010111, -1.088596, -1.094650, },
{ 1.000000,  0.978379,  0.956654,  0.932354,  0.912197,  0.892691,  0.868774,  0.841819,  0.828080,  0.802898,  0.780604,  0.755944,  0.742212,  0.719696,  0.685313,  0.667784,  0.654646,  0.634613,  0.590953,  0.586988,  0.569146,  0.539395,  0.505915,  0.504911,  0.476262,  0.449007,  0.425025,  0.419143,  0.396840,  0.348743,  0.334162,  0.335880,  0.310804,  0.242064,  0.271320,  0.237065,  0.218452,  0.169449,  0.177729,  0.151723,  0.110164,  0.087239,  0.104280,  0.067778,  0.016996,  0.005215,  0.006592, -0.009063, -0.106437, -0.047386, -0.086337, -0.118890, -0.150893, -0.148642, -0.177179, -0.225412, -0.235981, -0.223203, -0.251604, -0.318038, -0.338234, -0.305013, -0.341901, -0.453816, -0.378239, -0.405513, -0.449653, -0.479331, -0.474304, -0.496494, -0.561128, -0.570394, -0.554352, -0.578005, -0.671802, -0.649504, -0.630038, -0.684344, -0.759391, -0.699377, -0.748667, -0.786282, -0.813368, -0.787681, -0.807772, -0.905249, -0.902720, -0.880768, -0.893825, -1.016626, -0.963756, -0.961265, -1.019299, -1.093285, -1.014985, -1.078961, -1.119096, -1.141159, -1.109491, -1.132454, },
{ 1.000000,  0.975745,  0.952032,  0.930481,  0.906636,  0.875898,  0.860551,  0.834985,  0.811636,  0.781579,  0.765938,  0.741589,  0.712037,  0.687065,  0.675990,  0.648470,  0.612833,  0.593670,  0.581067,  0.557688,  0.500474,  0.513414,  0.480992,  0.454562,  0.426326,  0.412931,  0.388272,  0.348420,  0.329907,  0.327689,  0.299892,  0.252357,  0.229000,  0.237902,  0.205782,  0.124748,  0.159980,  0.134243,  0.098748,  0.069450,  0.062267,  0.036475, -0.009880, -0.028041, -0.024703, -0.052089, -0.126730, -0.121418, -0.114849, -0.160519, -0.220487, -0.186781, -0.227638, -0.264629, -0.291868, -0.283977, -0.306224, -0.380433, -0.389101, -0.380450, -0.398709, -0.491434, -0.460233, -0.470860, -0.518351, -0.587518, -0.529215, -0.582239, -0.626020, -0.653731, -0.625724, -0.662427, -0.746205, -0.755575, -0.721616, -0.745602, -0.881058, -0.792605, -0.836494, -0.857713, -0.942114, -0.893975, -0.925508, -0.994931, -1.018274, -0.972291, -1.013585, -1.104557, -1.109434, -1.073001, -1.096307, -1.270557, -1.127569, -1.190356, -1.227043, -1.271479, -1.258577, -1.271484, -1.368201, -1.379964, },
{ 1.000000,  0.975403,  0.950409,  0.923119,  0.897999,  0.877282,  0.851457,  0.814222,  0.802253,  0.775102,  0.747814,  0.721595,  0.701327,  0.675399,  0.642435,  0.619351,  0.604326,  0.578278,  0.532788,  0.518352,  0.506922,  0.471781,  0.426550,  0.432161,  0.399653,  0.366499,  0.339408,  0.330716,  0.303428,  0.253429,  0.237223,  0.230358,  0.206804,  0.143163,  0.149359,  0.128805,  0.095960,  0.038351,  0.065103,  0.020058, -0.013467, -0.042871, -0.036260, -0.071758, -0.133067, -0.148738, -0.140237, -0.158808, -0.259709, -0.213847, -0.246675, -0.276415, -0.341966, -0.317994, -0.345294, -0.400551, -0.430450, -0.407013, -0.440601, -0.520279, -0.527023, -0.511652, -0.532115, -0.669636, -0.573706, -0.627289, -0.660210, -0.703339, -0.700638, -0.718317, -0.794957, -0.814351, -0.768557, -0.816321, -0.898804, -0.913361, -0.863479, -0.903067, -1.067694, -0.951616, -1.004954, -1.045297, -1.073052, -1.067707, -1.102112, -1.173112, -1.189088, -1.145978, -1.183919, -1.306960, -1.289433, -1.243466, -1.310579, -1.435282, -1.322525, -1.375203, -1.432638, -1.459250, -1.431064, -1.463047, },
{ 1.000000,  0.973737,  0.948015,  0.923801,  0.898523,  0.867724,  0.846677,  0.822312,  0.794587,  0.760989,  0.748185,  0.717916,  0.689331,  0.662423,  0.647123,  0.619022,  0.579843,  0.556565,  0.544885,  0.521140,  0.464633,  0.467535,  0.440052,  0.411190,  0.367345,  0.366631,  0.336406,  0.299387,  0.271392,  0.269753,  0.238935,  0.186612,  0.169315,  0.167080,  0.140019,  0.055253,  0.096051,  0.052399,  0.025765, -0.014909, -0.017036, -0.046045, -0.097905, -0.121512, -0.105308, -0.143034, -0.203411, -0.224898, -0.207158, -0.236678, -0.354930, -0.281018, -0.332301, -0.367150, -0.393790, -0.399193, -0.432300, -0.484226, -0.503766, -0.484721, -0.523917, -0.608520, -0.611881, -0.586086, -0.634758, -0.740713, -0.663284, -0.709192, -0.756427, -0.787313, -0.774761, -0.806144, -0.884174, -0.895844, -0.875988, -0.903145, -1.011264, -0.974413, -0.971163, -1.029329, -1.117625, -1.040349, -1.103209, -1.143681, -1.184877, -1.133749, -1.182849, -1.285333, -1.289813, -1.256427, -1.267021, -1.432822, -1.338889, -1.362260, -1.408119, -1.510903, -1.431446, -1.476984, -1.543181, -1.569204, },
{ 1.000000,  0.971124,  0.942254,  0.910053,  0.881684,  0.856322,  0.826621,  0.784861,  0.770580,  0.737267,  0.708076,  0.672387,  0.652724,  0.621981,  0.584601,  0.554142,  0.542639,  0.506500,  0.463076,  0.436353,  0.424545,  0.395271,  0.321150,  0.341456,  0.299166,  0.265403,  0.233211,  0.218006,  0.185784,  0.138261,  0.114194,  0.110379,  0.073421,  0.009834, -0.008009, -0.003639, -0.049002, -0.134811, -0.093389, -0.131782, -0.180436, -0.210917, -0.210543, -0.246638, -0.312182, -0.332334, -0.330191, -0.357346, -0.445862, -0.433033, -0.439322, -0.494660, -0.573238, -0.524474, -0.583609, -0.615019, -0.664327, -0.630434, -0.674553, -0.766104, -0.777755, -0.765033, -0.784971, -0.915074, -0.861292, -0.880987, -0.928659, -1.016901, -0.962608, -1.008415, -1.066116, -1.102510, -1.077266, -1.108164, -1.217995, -1.221960, -1.179989, -1.224800, -1.392934, -1.265229, -1.331587, -1.357942, -1.457081, -1.396326, -1.442048, -1.524507, -1.552163, -1.482771, -1.553168, -1.659071, -1.667638, -1.619218, -1.644539, -1.868221, -1.693706, -1.768478, -1.821678, -1.863460, -1.844237, -1.887031, },
{ 1.000000,  0.968162,  0.936739,  0.907471,  0.875535,  0.839278,  0.807993,  0.784313,  0.750337,  0.702127,  0.690533,  0.657560,  0.619663,  0.586951,  0.564966,  0.532672,  0.487846,  0.459288,  0.441088,  0.408772,  0.353095,  0.337434,  0.320676,  0.276516,  0.220845,  0.228016,  0.181994,  0.148140,  0.107453,  0.105250,  0.069296, -0.000230, -0.018716, -0.024527, -0.052268, -0.143944, -0.124711, -0.147391, -0.197260, -0.257528, -0.238171, -0.285509, -0.330053, -0.367271, -0.360254, -0.395931, -0.483748, -0.497854, -0.477910, -0.517986, -0.648713, -0.571150, -0.629648, -0.657895, -0.740740, -0.710654, -0.750613, -0.820645, -0.854425, -0.810309, -0.871941, -0.957207, -0.971156, -0.954241, -0.977622, -1.150269, -1.029104, -1.093853, -1.146246, -1.195798, -1.180163, -1.224904, -1.302190, -1.314517, -1.282088, -1.328847, -1.442970, -1.467155, -1.401401, -1.466361, -1.647166, -1.504252, -1.550987, -1.622302, -1.669723, -1.648492, -1.682045, -1.787774, -1.798653, -1.764287, -1.801310, -1.954153, -1.904707, -1.867538, -1.956802, -2.079634, -1.967870, -2.048925, -2.103900, -2.147109, },
{ 1.000000,  0.966851,  0.933343,  0.896251,  0.863047,  0.832855,  0.799963,  0.754649,  0.730151,  0.699616,  0.660794,  0.618246,  0.602262,  0.560464,  0.522741,  0.487757,  0.467631,  0.432403,  0.375986,  0.348824,  0.337180,  0.299973,  0.221406,  0.236075,  0.191011,  0.157094,  0.099236,  0.097194,  0.059749,  0.006597, -0.031146, -0.025388, -0.072857, -0.139441, -0.161461, -0.163741, -0.198662, -0.317447, -0.259279, -0.315485, -0.357105, -0.400936, -0.408479, -0.446671, -0.514761, -0.536863, -0.523131, -0.569135, -0.655457, -0.685253, -0.652471, -0.708752, -0.852631, -0.764621, -0.806676, -0.865751, -0.912440, -0.909286, -0.947695, -1.025479, -1.049793, -1.032774, -1.076302, -1.203965, -1.178882, -1.158182, -1.234153, -1.335107, -1.259459, -1.328512, -1.384011, -1.428037, -1.399748, -1.435632, -1.559322, -1.568569, -1.541844, -1.567550, -1.726512, -1.659036, -1.672234, -1.744961, -1.854250, -1.749080, -1.834762, -1.903044, -1.944704, -1.888587, -1.948350, -2.080962, -2.089474, -2.022498, -2.061637, -2.286423, -2.129490, -2.199409, -2.231092, -2.358893, -2.271194, -2.321983, },
{ 1.000000,  0.961425,  0.922827,  0.888147,  0.849301,  0.805933,  0.769011,  0.738391,  0.700420,  0.640483,  0.628016,  0.583904,  0.542967,  0.500785,  0.471927,  0.435184,  0.379953,  0.345007,  0.330766,  0.287151,  0.225052,  0.191434,  0.182951,  0.135612,  0.039791,  0.066189,  0.017522, -0.030138, -0.073529, -0.091549, -0.132028, -0.196091, -0.228465, -0.236229, -0.278771, -0.373332, -0.378117, -0.379765, -0.446130, -0.534536, -0.491180, -0.551419, -0.606849, -0.652892, -0.648229, -0.693129, -0.788807, -0.807742, -0.802189, -0.836955, -0.963255, -0.929662, -0.957432, -1.011427, -1.114745, -1.046349, -1.126179, -1.181846, -1.230834, -1.204169, -1.263334, -1.372910, -1.391304, -1.356657, -1.386225, -1.577578, -1.473238, -1.528882, -1.576773, -1.686747, -1.628612, -1.673987, -1.770703, -1.821335, -1.760911, -1.821401, -1.957815, -1.962866, -1.921721, -1.955186, -2.198402, -2.015867, -2.104100, -2.158688, -2.229566, -2.209343, -2.241505, -2.370001, -2.393337, -2.304785, -2.386559, -2.525944, -2.541996, -2.447960, -2.522384, -2.795941, -2.588936, -2.675329, -2.740487, -2.789723, },
{ 1.000000,  0.953779,  0.907213,  0.858080,  0.811430,  0.770898,  0.723075,  0.663433,  0.623436,  0.588452,  0.533265,  0.467840,  0.451349,  0.397097,  0.343114,  0.294054,  0.263779,  0.215274,  0.143136,  0.103510,  0.078225,  0.033282, -0.058544, -0.068333, -0.106888, -0.165933, -0.248448, -0.234395, -0.302492, -0.362330, -0.415940, -0.421479, -0.478324, -0.572269, -0.608247, -0.602715, -0.647965, -0.797813, -0.749408, -0.805669, -0.863039, -0.956440, -0.929955, -0.991087, -1.072427, -1.127334, -1.102563, -1.169871, -1.284241, -1.309692, -1.290844, -1.345542, -1.541714, -1.420110, -1.509821, -1.563292, -1.644497, -1.629342, -1.690402, -1.798867, -1.835676, -1.783382, -1.859259, -1.989284, -2.023199, -1.965800, -2.035865, -2.283130, -2.106824, -2.210274, -2.278928, -2.332463, -2.326231, -2.387422, -2.494307, -2.528278, -2.479388, -2.558472, -2.738524, -2.724153, -2.659530, -2.769239, -2.973692, -2.791988, -2.892180, -2.984125, -3.051957, -3.007733, -3.065340, -3.227322, -3.247133, -3.192085, -3.241500, -3.473524, -3.374749, -3.360341, -3.477624, -3.647796, -3.483143, -3.607999, },
{ 1.000000,  0.941223,  0.881745,  0.828514,  0.768701,  0.701835,  0.645715,  0.597594,  0.541390,  0.452985,  0.421936,  0.362444,  0.299598,  0.222411,  0.195025,  0.130400,  0.057365, -0.004116, -0.032798, -0.097024, -0.191885, -0.238233, -0.260770, -0.327800, -0.465547, -0.433572, -0.513550, -0.575313, -0.661102, -0.672479, -0.740373, -0.831394, -0.891347, -0.882292, -0.967498, -1.080783, -1.126667, -1.122184, -1.192412, -1.386614, -1.288491, -1.388184, -1.460641, -1.534861, -1.540859, -1.605556, -1.718832, -1.765837, -1.754962, -1.835448, -1.997567, -2.007694, -1.978862, -2.091642, -2.284797, -2.148083, -2.243100, -2.351531, -2.424748, -2.394723, -2.468790, -2.624556, -2.662747, -2.637004, -2.687571, -2.910960, -2.843493, -2.851867, -2.972759, -3.147883, -3.015648, -3.145752, -3.216016, -3.323246, -3.224879, -3.323084, -3.525754, -3.544576, -3.490901, -3.537491, -3.855049, -3.694412, -3.749421, -3.846015, -4.021197, -3.885708, -3.983795, -4.113620, -4.202101, -4.118042, -4.194973, -4.427104, -4.427960, -4.324556, -4.420833, -4.795570, -4.499104, -4.635629, -4.708860, -4.900679, },
{ 1.000000,  0.913721,  0.826684,  0.734414,  0.647180,  0.572618,  0.480145,  0.373663,  0.294314,  0.225519,  0.133428, -0.004058, -0.028436, -0.131396, -0.231248, -0.327089, -0.387317, -0.475842, -0.592382, -0.670632, -0.720566, -0.819516, -0.979356, -1.036523, -1.062885, -1.187590, -1.367740, -1.313940, -1.420086, -1.555467, -1.654667, -1.680822, -1.770402, -1.938713, -2.004627, -2.025094, -2.116343, -2.341345, -2.319269, -2.358272, -2.506181, -2.675380, -2.604825, -2.742458, -2.861127, -2.980228, -2.949876, -3.061231, -3.298484, -3.324303, -3.307511, -3.398157, -3.730271, -3.595928, -3.678328, -3.835159, -3.988445, -3.894892, -4.030968, -4.192629, -4.304482, -4.244508, -4.362469, -4.647624, -4.646557, -4.571900, -4.701545, -5.106741, -4.829921, -5.005554, -5.132020, -5.343883, -5.220730, -5.332509, -5.556013, -5.626821, -5.500226, -5.677446, -5.972503, -5.962350, -5.896128, -6.013720, -6.471585, -6.097817, -6.298206, -6.476064, -6.628799, -6.536092, -6.638440, -6.886064, -6.914831, -6.825113, -6.958100, -7.376638, -7.331614, -7.166455, -7.416269, -7.832900, -7.381656, -7.553609, },
};
