/* This is the mu "correction" table, indexed by rho from -1.0 to 0.990
 * by 0.010, and sigma from 0 to 0.990 (fraction of mu) by 0.010
 * (Far more precision than really required...)  This is the table
 * for the experimental distribution.  You could actually just
 * use this one for all of them (they're all quite close),
 * but I guess I'll make separate tables for each.
 */
/* To determine correction:
 *	index = rint((rho+1)*100)
 * We use linear interpolation between entries...
 */
#define MU_RHO_STEP 100
#define MU_RHO_DOMAIN 200
#define MU_SIGMA_STEP 100
#define MU_SIGMA_DOMAIN 99

double rhomucorrect[MU_RHO_DOMAIN][MU_SIGMA_DOMAIN+1] = {
{ 1.000000,  1.003491,  1.006416,  1.009513,  1.012686,  1.016137,  1.019058,  1.023228,  1.025673,  1.028268,  1.031232,  1.035903,  1.039764,  1.040060,  1.044876,  1.049214,  1.052200,  1.053216,  1.058082,  1.061386,  1.064786,  1.065696,  1.072015,  1.075375,  1.075722,  1.078698,  1.084704,  1.088657,  1.086169,  1.093534,  1.097719,  1.100967,  1.101058,  1.106347,  1.110427,  1.112330,  1.111045,  1.122105,  1.123724,  1.123959,  1.124728,  1.134447,  1.138102,  1.131641,  1.143087,  1.145813,  1.148971,  1.148959,  1.156590,  1.157951,  1.160577,  1.158449,  1.169733,  1.172625,  1.171028,  1.172618,  1.184988,  1.184652,  1.179492,  1.190482,  1.194986,  1.197542,  1.195634,  1.204915,  1.208129,  1.206020,  1.207011,  1.218117,  1.222063,  1.215751,  1.222913,  1.234072,  1.232926,  1.225685,  1.240495,  1.243093,  1.246004,  1.240998,  1.255132,  1.256571,  1.253376,  1.253060,  1.266927,  1.272856,  1.260068,  1.272984,  1.282738,  1.282141,  1.274748,  1.289188,  1.289401,  1.295829,  1.286694,  1.303239,  1.307931,  1.300102,  1.302266,  1.317444,  1.318856,  1.306770, },
{ 1.000000,  1.003454,  1.006719,  1.010182,  1.012246,  1.016136,  1.019566,  1.022627,  1.025105,  1.029841,  1.033176,  1.035121,  1.037559,  1.042694,  1.046314,  1.046378,  1.052687,  1.055817,  1.058232,  1.060314,  1.065711,  1.067973,  1.071268,  1.071965,  1.079368,  1.081843,  1.082932,  1.085225,  1.092672,  1.094691,  1.093873,  1.101008,  1.104557,  1.107281,  1.107947,  1.115028,  1.117838,  1.118870,  1.120230,  1.127380,  1.131629,  1.129363,  1.133969,  1.142700,  1.143321,  1.140955,  1.150676,  1.152571,  1.156024,  1.154275,  1.165560,  1.167433,  1.165890,  1.166336,  1.176403,  1.182217,  1.174930,  1.183949,  1.191639,  1.192823,  1.187427,  1.199879,  1.200850,  1.205466,  1.201832,  1.212924,  1.219029,  1.211863,  1.215104,  1.227903,  1.228667,  1.222046,  1.234074,  1.239905,  1.242598,  1.236206,  1.247928,  1.250812,  1.253243,  1.246503,  1.263518,  1.265389,  1.262724,  1.262054,  1.275045,  1.280608,  1.266607,  1.284416,  1.286963,  1.289484,  1.285649,  1.297790,  1.299597,  1.300279,  1.293748,  1.312223,  1.314540,  1.311526,  1.308670,  1.328608, },
{ 1.000000,  1.003465,  1.006352,  1.009342,  1.012671,  1.016035,  1.018923,  1.022202,  1.025414,  1.028092,  1.031081,  1.034764,  1.038445,  1.040126,  1.044016,  1.048312,  1.050664,  1.051727,  1.058133,  1.059557,  1.063623,  1.064390,  1.070988,  1.073428,  1.074439,  1.076932,  1.082975,  1.086987,  1.085292,  1.091523,  1.096604,  1.097799,  1.097988,  1.105295,  1.107985,  1.110790,  1.110837,  1.117728,  1.122886,  1.120066,  1.123486,  1.131736,  1.134038,  1.130133,  1.139233,  1.144666,  1.147381,  1.143040,  1.152980,  1.155307,  1.157953,  1.156705,  1.166452,  1.170326,  1.168527,  1.170044,  1.178139,  1.183195,  1.175901,  1.188161,  1.191284,  1.193078,  1.192337,  1.201757,  1.201967,  1.204254,  1.202283,  1.215166,  1.216922,  1.216359,  1.214673,  1.229001,  1.230512,  1.219821,  1.235385,  1.240789,  1.240994,  1.237566,  1.250307,  1.252094,  1.248965,  1.249410,  1.260936,  1.266118,  1.259238,  1.263312,  1.279002,  1.276177,  1.268103,  1.284928,  1.283919,  1.288336,  1.282993,  1.298942,  1.300877,  1.295253,  1.294860,  1.308642,  1.316212,  1.302078, },
{ 1.000000,  1.003405,  1.006716,  1.009967,  1.012814,  1.016037,  1.019342,  1.022461,  1.025220,  1.029293,  1.033118,  1.034825,  1.038130,  1.042725,  1.045485,  1.046373,  1.051708,  1.055741,  1.058682,  1.059577,  1.065070,  1.068243,  1.070711,  1.071811,  1.078646,  1.081738,  1.082769,  1.085741,  1.090905,  1.095106,  1.093417,  1.100763,  1.104043,  1.106923,  1.107398,  1.114110,  1.116408,  1.119096,  1.119286,  1.127636,  1.130712,  1.131486,  1.131087,  1.141658,  1.143486,  1.138904,  1.149375,  1.153429,  1.156143,  1.155034,  1.163224,  1.165150,  1.166561,  1.166495,  1.175258,  1.180549,  1.176855,  1.180106,  1.191880,  1.190502,  1.187881,  1.198448,  1.200756,  1.202654,  1.203238,  1.212753,  1.215697,  1.213437,  1.213613,  1.223626,  1.230143,  1.222448,  1.231252,  1.239936,  1.238626,  1.234480,  1.248531,  1.249603,  1.251150,  1.249032,  1.261593,  1.265864,  1.259819,  1.262138,  1.273653,  1.278317,  1.267693,  1.281669,  1.288868,  1.289746,  1.282016,  1.295635,  1.297074,  1.300697,  1.294720,  1.310344,  1.314907,  1.307651,  1.310746,  1.321852, },
{ 1.000000,  1.003453,  1.006308,  1.010056,  1.013220,  1.015858,  1.018842,  1.022509,  1.025830,  1.028806,  1.031302,  1.035951,  1.039433,  1.041371,  1.043295,  1.048886,  1.052104,  1.052244,  1.058217,  1.061832,  1.064667,  1.066498,  1.071581,  1.073489,  1.076797,  1.078040,  1.084107,  1.088590,  1.088077,  1.091834,  1.098229,  1.099464,  1.099650,  1.106602,  1.109934,  1.112381,  1.114061,  1.120420,  1.124207,  1.123557,  1.124939,  1.132541,  1.137170,  1.134179,  1.140772,  1.147132,  1.148048,  1.146701,  1.155648,  1.158518,  1.160562,  1.159695,  1.170094,  1.172322,  1.171243,  1.172872,  1.181687,  1.185469,  1.179552,  1.190213,  1.195757,  1.197370,  1.193620,  1.204544,  1.206853,  1.208720,  1.206507,  1.217487,  1.221720,  1.218305,  1.220873,  1.230293,  1.235051,  1.224691,  1.238978,  1.243228,  1.245142,  1.243292,  1.251732,  1.256338,  1.256997,  1.250449,  1.267044,  1.269883,  1.267242,  1.265533,  1.280594,  1.284507,  1.269386,  1.289700,  1.290510,  1.292822,  1.290175,  1.303290,  1.301791,  1.304903,  1.300254,  1.314365,  1.319943,  1.311791, },
{ 1.000000,  1.003316,  1.006672,  1.009228,  1.011898,  1.015771,  1.019258,  1.022229,  1.024437,  1.028456,  1.031835,  1.034278,  1.036914,  1.040819,  1.044731,  1.045874,  1.050255,  1.053676,  1.056481,  1.057527,  1.063600,  1.066502,  1.068645,  1.070394,  1.076845,  1.079035,  1.080678,  1.082132,  1.088078,  1.092998,  1.090975,  1.097468,  1.101963,  1.103872,  1.103747,  1.110875,  1.113623,  1.116207,  1.115891,  1.124056,  1.128306,  1.125703,  1.129392,  1.135728,  1.140294,  1.135949,  1.144608,  1.149061,  1.151602,  1.151059,  1.157534,  1.161140,  1.162399,  1.159507,  1.173484,  1.175007,  1.173339,  1.173828,  1.184564,  1.188703,  1.179999,  1.193454,  1.195765,  1.197926,  1.198191,  1.207211,  1.207105,  1.209776,  1.206043,  1.219469,  1.222248,  1.219299,  1.220940,  1.234219,  1.233189,  1.227183,  1.239114,  1.243881,  1.245042,  1.243980,  1.253763,  1.256640,  1.253288,  1.254296,  1.266144,  1.270403,  1.262585,  1.270924,  1.282021,  1.279983,  1.272303,  1.288435,  1.290647,  1.292618,  1.287189,  1.302981,  1.303742,  1.299657,  1.299383,  1.312695, },
{ 1.000000,  1.003442,  1.006259,  1.009868,  1.013271,  1.015697,  1.018506,  1.022375,  1.025505,  1.028846,  1.031068,  1.035597,  1.039253,  1.040351,  1.043452,  1.048290,  1.051302,  1.052218,  1.057484,  1.061238,  1.064294,  1.065561,  1.070321,  1.073371,  1.076110,  1.076417,  1.084288,  1.087342,  1.088388,  1.090130,  1.096419,  1.100626,  1.096792,  1.106515,  1.109023,  1.111549,  1.113019,  1.119486,  1.121333,  1.123747,  1.122497,  1.132465,  1.135396,  1.135266,  1.136619,  1.146373,  1.147732,  1.143794,  1.152916,  1.157123,  1.159756,  1.159658,  1.167647,  1.170599,  1.170248,  1.171044,  1.179752,  1.184039,  1.179955,  1.184755,  1.195274,  1.194754,  1.190918,  1.203316,  1.203635,  1.207431,  1.204449,  1.217719,  1.219046,  1.216012,  1.216616,  1.227685,  1.234924,  1.223610,  1.234594,  1.242854,  1.243178,  1.237108,  1.251428,  1.251828,  1.256095,  1.251913,  1.263322,  1.270213,  1.260881,  1.264907,  1.278631,  1.278982,  1.270477,  1.284511,  1.289570,  1.292694,  1.284715,  1.297999,  1.300696,  1.302605,  1.294654,  1.314482,  1.316408,  1.311330, },
{ 1.000000,  1.003281,  1.006518,  1.009278,  1.011662,  1.015752,  1.019065,  1.022123,  1.024181,  1.028035,  1.031327,  1.034391,  1.036298,  1.040833,  1.044190,  1.046297,  1.048696,  1.054368,  1.056349,  1.056845,  1.062413,  1.066564,  1.069088,  1.069756,  1.076044,  1.078442,  1.080345,  1.082087,  1.088187,  1.092034,  1.090940,  1.095329,  1.102539,  1.103612,  1.101995,  1.110808,  1.111931,  1.116373,  1.115279,  1.123736,  1.126812,  1.125622,  1.127686,  1.135355,  1.140365,  1.135257,  1.143124,  1.149410,  1.150165,  1.147978,  1.157178,  1.159735,  1.162549,  1.161787,  1.169272,  1.175713,  1.170248,  1.173861,  1.184186,  1.185455,  1.179103,  1.190765,  1.197002,  1.199180,  1.192307,  1.204229,  1.206944,  1.208518,  1.205947,  1.218105,  1.222361,  1.218024,  1.219370,  1.229353,  1.235002,  1.223539,  1.238923,  1.242924,  1.243762,  1.241305,  1.251858,  1.252864,  1.254550,  1.250710,  1.266251,  1.268426,  1.265998,  1.262794,  1.279843,  1.282192,  1.267145,  1.285279,  1.291364,  1.291188,  1.286684,  1.300448,  1.302233,  1.298735,  1.297593,  1.311028, },
{ 1.000000,  1.003385,  1.006285,  1.008884,  1.012492,  1.015559,  1.018191,  1.022214,  1.025258,  1.027666,  1.030248,  1.034949,  1.038030,  1.040061,  1.042224,  1.046855,  1.050986,  1.050959,  1.056039,  1.060211,  1.061758,  1.063407,  1.069139,  1.072234,  1.074836,  1.075522,  1.081599,  1.086102,  1.085055,  1.088239,  1.094254,  1.097781,  1.095089,  1.103300,  1.107946,  1.109606,  1.108079,  1.115717,  1.118988,  1.121257,  1.120907,  1.129701,  1.132936,  1.131495,  1.134363,  1.140931,  1.145018,  1.139788,  1.150866,  1.154149,  1.156717,  1.154318,  1.163040,  1.165379,  1.167351,  1.165612,  1.176663,  1.180249,  1.178731,  1.177415,  1.190881,  1.192148,  1.183102,  1.196822,  1.201369,  1.203284,  1.201087,  1.210645,  1.212594,  1.212933,  1.211087,  1.222367,  1.227965,  1.220949,  1.225168,  1.239670,  1.236891,  1.231859,  1.244225,  1.246508,  1.247515,  1.247321,  1.258557,  1.262989,  1.257325,  1.257059,  1.269038,  1.276281,  1.264849,  1.274653,  1.285432,  1.282272,  1.276890,  1.293219,  1.293982,  1.294100,  1.291093,  1.305729,  1.311240,  1.301085, },
{ 1.000000,  1.003244,  1.006474,  1.009904,  1.011589,  1.015472,  1.019116,  1.022021,  1.024270,  1.028391,  1.030962,  1.034261,  1.036070,  1.041125,  1.044495,  1.045927,  1.049111,  1.053017,  1.056999,  1.056464,  1.063014,  1.066156,  1.069241,  1.069716,  1.074944,  1.078241,  1.080742,  1.081153,  1.088621,  1.091515,  1.092491,  1.093129,  1.101367,  1.104763,  1.100641,  1.110142,  1.113104,  1.115853,  1.115203,  1.123313,  1.124851,  1.127809,  1.126451,  1.134627,  1.139696,  1.136446,  1.140432,  1.149926,  1.150248,  1.146872,  1.156576,  1.159798,  1.162029,  1.161872,  1.170392,  1.173829,  1.172013,  1.172492,  1.181751,  1.187395,  1.180610,  1.189304,  1.196438,  1.196083,  1.192202,  1.204376,  1.207934,  1.208772,  1.205091,  1.218357,  1.221081,  1.217333,  1.218370,  1.230033,  1.233994,  1.223292,  1.237343,  1.243888,  1.244730,  1.237865,  1.251611,  1.253593,  1.255218,  1.251098,  1.264907,  1.269512,  1.262776,  1.264993,  1.276142,  1.281858,  1.267113,  1.285091,  1.290358,  1.291578,  1.285933,  1.296537,  1.302318,  1.301852,  1.292004,  1.313223, },
{ 1.000000,  1.003357,  1.006277,  1.008717,  1.012228,  1.015675,  1.017595,  1.022016,  1.024495,  1.027521,  1.029936,  1.034510,  1.036372,  1.039718,  1.041597,  1.046458,  1.050178,  1.050454,  1.053795,  1.059551,  1.061893,  1.062106,  1.067334,  1.070927,  1.073757,  1.075008,  1.080573,  1.083470,  1.084453,  1.086540,  1.092517,  1.096538,  1.094612,  1.100580,  1.105767,  1.108090,  1.105418,  1.114453,  1.116938,  1.119969,  1.119671,  1.127557,  1.129936,  1.129502,  1.131472,  1.137697,  1.144266,  1.137916,  1.146950,  1.153393,  1.153648,  1.150583,  1.160682,  1.162902,  1.166641,  1.163061,  1.173627,  1.178814,  1.173449,  1.177156,  1.184321,  1.190350,  1.181336,  1.194036,  1.198026,  1.200655,  1.197217,  1.206039,  1.210092,  1.210395,  1.204905,  1.222402,  1.224272,  1.219257,  1.220114,  1.232838,  1.237874,  1.223551,  1.241746,  1.243185,  1.246119,  1.243112,  1.255199,  1.253971,  1.257272,  1.250508,  1.266743,  1.270815,  1.263969,  1.266236,  1.281803,  1.280644,  1.270077,  1.285550,  1.290294,  1.291877,  1.287672,  1.300389,  1.303083,  1.298735, },
{ 1.000000,  1.003206,  1.006384,  1.009817,  1.011568,  1.015137,  1.018925,  1.021725,  1.023871,  1.028213,  1.030688,  1.033978,  1.035829,  1.040754,  1.043731,  1.045707,  1.047752,  1.052387,  1.056829,  1.055868,  1.061811,  1.066171,  1.068420,  1.068476,  1.074455,  1.076893,  1.080705,  1.080845,  1.087521,  1.090778,  1.090162,  1.093581,  1.099681,  1.103228,  1.100429,  1.108699,  1.111652,  1.115045,  1.113703,  1.121141,  1.124040,  1.126435,  1.124070,  1.134477,  1.137584,  1.136720,  1.138087,  1.146532,  1.151385,  1.142099,  1.156657,  1.157920,  1.161052,  1.160155,  1.168851,  1.168979,  1.172684,  1.168844,  1.181162,  1.184913,  1.181920,  1.182993,  1.194572,  1.195834,  1.188853,  1.200836,  1.205169,  1.207868,  1.204935,  1.215098,  1.217336,  1.216863,  1.215805,  1.226864,  1.231992,  1.223741,  1.230462,  1.242095,  1.241858,  1.234483,  1.249056,  1.249252,  1.253582,  1.248708,  1.264085,  1.265262,  1.260815,  1.260303,  1.271865,  1.281811,  1.265370,  1.279844,  1.288888,  1.288260,  1.278697,  1.295953,  1.295549,  1.300576,  1.294614,  1.307489, },
{ 1.000000,  1.003348,  1.006134,  1.009384,  1.012069,  1.015385,  1.017664,  1.021575,  1.025023,  1.028214,  1.029373,  1.033856,  1.036761,  1.040063,  1.041324,  1.046966,  1.049592,  1.051016,  1.053921,  1.058373,  1.063035,  1.061026,  1.067910,  1.070582,  1.074013,  1.074689,  1.080275,  1.083120,  1.085626,  1.085230,  1.092899,  1.096373,  1.096829,  1.098341,  1.105743,  1.108554,  1.104785,  1.113649,  1.117664,  1.120598,  1.118963,  1.127109,  1.129106,  1.130514,  1.130921,  1.138453,  1.143529,  1.139051,  1.144533,  1.153546,  1.154499,  1.149800,  1.161241,  1.160728,  1.166996,  1.163048,  1.174306,  1.177656,  1.174229,  1.175790,  1.184176,  1.192091,  1.182037,  1.192536,  1.198810,  1.199818,  1.194793,  1.206725,  1.208386,  1.212328,  1.208838,  1.218079,  1.226013,  1.217398,  1.221702,  1.232380,  1.235566,  1.223896,  1.239257,  1.245930,  1.248982,  1.238097,  1.252808,  1.254191,  1.257048,  1.251880,  1.266647,  1.272114,  1.263585,  1.266263,  1.275837,  1.285735,  1.266914,  1.287354,  1.290840,  1.292335,  1.286554,  1.299805,  1.299266,  1.303243, },
{ 1.000000,  1.003141,  1.006353,  1.008983,  1.011719,  1.014617,  1.018639,  1.021866,  1.022573,  1.027108,  1.030589,  1.033741,  1.035514,  1.039574,  1.042559,  1.044992,  1.047110,  1.051054,  1.055163,  1.055770,  1.059184,  1.065139,  1.066671,  1.066464,  1.073201,  1.075247,  1.079076,  1.078942,  1.085546,  1.088893,  1.089167,  1.091214,  1.096453,  1.102291,  1.098273,  1.105214,  1.111004,  1.111499,  1.110536,  1.118674,  1.121262,  1.123754,  1.123199,  1.130439,  1.136282,  1.132549,  1.135114,  1.142867,  1.147941,  1.140400,  1.151610,  1.156178,  1.159372,  1.153566,  1.163956,  1.166536,  1.169185,  1.166374,  1.177694,  1.181805,  1.177509,  1.180433,  1.186934,  1.194519,  1.183497,  1.197540,  1.200590,  1.204775,  1.198875,  1.210100,  1.210910,  1.214404,  1.209518,  1.222536,  1.228288,  1.223677,  1.221329,  1.236603,  1.239899,  1.225116,  1.242301,  1.246579,  1.249951,  1.244266,  1.256641,  1.257066,  1.258831,  1.253681,  1.266532,  1.273795,  1.263223,  1.268469,  1.284253,  1.283162,  1.272297,  1.288444,  1.290104,  1.292393,  1.289691,  1.301233, },
{ 1.000000,  1.003284,  1.006183,  1.009211,  1.012472,  1.016133,  1.017561,  1.021123,  1.024893,  1.027577,  1.029601,  1.034088,  1.037129,  1.039976,  1.042145,  1.046677,  1.050429,  1.050884,  1.053706,  1.058497,  1.062646,  1.061536,  1.067903,  1.071942,  1.074959,  1.074037,  1.080513,  1.082785,  1.086226,  1.086317,  1.092915,  1.097185,  1.096005,  1.099639,  1.104550,  1.110404,  1.105143,  1.115026,  1.117315,  1.120854,  1.119560,  1.126533,  1.129167,  1.132318,  1.130477,  1.140029,  1.144285,  1.143272,  1.142856,  1.152186,  1.157444,  1.147508,  1.160760,  1.164151,  1.167975,  1.164346,  1.174604,  1.174988,  1.179011,  1.175999,  1.184720,  1.191877,  1.184703,  1.189489,  1.200369,  1.201477,  1.194781,  1.206889,  1.210014,  1.212655,  1.210425,  1.219975,  1.224270,  1.222076,  1.220811,  1.230680,  1.238891,  1.227947,  1.238662,  1.246460,  1.247513,  1.238884,  1.253509,  1.257205,  1.258591,  1.253795,  1.267528,  1.271564,  1.266013,  1.266752,  1.278156,  1.285980,  1.269276,  1.286202,  1.292780,  1.295219,  1.284001,  1.299889,  1.302481,  1.305399, },
{ 1.000000,  1.003139,  1.006262,  1.008907,  1.011490,  1.014664,  1.018200,  1.021710,  1.022424,  1.026835,  1.030204,  1.033488,  1.034536,  1.038722,  1.042224,  1.044905,  1.046087,  1.050947,  1.054633,  1.055938,  1.058119,  1.063731,  1.067154,  1.064230,  1.072727,  1.075042,  1.078041,  1.078205,  1.084612,  1.086649,  1.090062,  1.089341,  1.095672,  1.100645,  1.098969,  1.102299,  1.109032,  1.111728,  1.108360,  1.117008,  1.120400,  1.122572,  1.122630,  1.129993,  1.133382,  1.132268,  1.133189,  1.140296,  1.146886,  1.141493,  1.148117,  1.153522,  1.157034,  1.151277,  1.162971,  1.164256,  1.167795,  1.166271,  1.175467,  1.178389,  1.175877,  1.177178,  1.184366,  1.193979,  1.182035,  1.193491,  1.200195,  1.202196,  1.195570,  1.206775,  1.209097,  1.213511,  1.209204,  1.219767,  1.226198,  1.218467,  1.222862,  1.229680,  1.238339,  1.223736,  1.239751,  1.243915,  1.248474,  1.240962,  1.250561,  1.255219,  1.256421,  1.249015,  1.267160,  1.270447,  1.263915,  1.264070,  1.277111,  1.285306,  1.263892,  1.287542,  1.287320,  1.291805,  1.286124,  1.299231, },
{ 1.000000,  1.003199,  1.006204,  1.008370,  1.011729,  1.015179,  1.017650,  1.020565,  1.024639,  1.026865,  1.028356,  1.033035,  1.036136,  1.039299,  1.041259,  1.044923,  1.048301,  1.050121,  1.052560,  1.057005,  1.061539,  1.060386,  1.065162,  1.069881,  1.072561,  1.071703,  1.078582,  1.080748,  1.084288,  1.084424,  1.090751,  1.094147,  1.094402,  1.095984,  1.101309,  1.107888,  1.102522,  1.111149,  1.115868,  1.117232,  1.115737,  1.123485,  1.125271,  1.130026,  1.128385,  1.135424,  1.140288,  1.137294,  1.141144,  1.147390,  1.153097,  1.145001,  1.156232,  1.159458,  1.163785,  1.160360,  1.168588,  1.170824,  1.173537,  1.170126,  1.181892,  1.186041,  1.182856,  1.183617,  1.192139,  1.200997,  1.184914,  1.204432,  1.204093,  1.207717,  1.205396,  1.214579,  1.214869,  1.219594,  1.213795,  1.226145,  1.231972,  1.225997,  1.227821,  1.240039,  1.243175,  1.230728,  1.245904,  1.249532,  1.253557,  1.249808,  1.259868,  1.262459,  1.261175,  1.259082,  1.269809,  1.278852,  1.265769,  1.273927,  1.285767,  1.287250,  1.275663,  1.293648,  1.292071,  1.298095, },
{ 1.000000,  1.003099,  1.006229,  1.009456,  1.012048,  1.015059,  1.018343,  1.022296,  1.023355,  1.027013,  1.030700,  1.033481,  1.034953,  1.039742,  1.042356,  1.045762,  1.047622,  1.051987,  1.056249,  1.056266,  1.059726,  1.064631,  1.068223,  1.066813,  1.073590,  1.077071,  1.080532,  1.079274,  1.085308,  1.088091,  1.091296,  1.090899,  1.098396,  1.102272,  1.101565,  1.104334,  1.109388,  1.116255,  1.108811,  1.120639,  1.122050,  1.126196,  1.124985,  1.131851,  1.134374,  1.136683,  1.135106,  1.143789,  1.148882,  1.146669,  1.147890,  1.157746,  1.161069,  1.153011,  1.164878,  1.169184,  1.171847,  1.169606,  1.178816,  1.180674,  1.181576,  1.180585,  1.188720,  1.196464,  1.187538,  1.194991,  1.204884,  1.206159,  1.197772,  1.212972,  1.211153,  1.218580,  1.212804,  1.225073,  1.229262,  1.224481,  1.225987,  1.234344,  1.245603,  1.229677,  1.243784,  1.250187,  1.250584,  1.243419,  1.257401,  1.258489,  1.262640,  1.259634,  1.267246,  1.278757,  1.266228,  1.271314,  1.282258,  1.288538,  1.270776,  1.290630,  1.297131,  1.300644,  1.287002,  1.302891, },
{ 1.000000,  1.003168,  1.006083,  1.008344,  1.011606,  1.015012,  1.017448,  1.020320,  1.023852,  1.027007,  1.027622,  1.032875,  1.035699,  1.038857,  1.040637,  1.044303,  1.046911,  1.050080,  1.051694,  1.056664,  1.060588,  1.061002,  1.062754,  1.068783,  1.072672,  1.069551,  1.077547,  1.080339,  1.083166,  1.083641,  1.089747,  1.092199,  1.094063,  1.094704,  1.100094,  1.105689,  1.102848,  1.107402,  1.114768,  1.116225,  1.113240,  1.122103,  1.123469,  1.127440,  1.127252,  1.134384,  1.137676,  1.136392,  1.138037,  1.144776,  1.152740,  1.143133,  1.153040,  1.159350,  1.159580,  1.157054,  1.166969,  1.168342,  1.171678,  1.170536,  1.177686,  1.185281,  1.178583,  1.181736,  1.189722,  1.196649,  1.183974,  1.199556,  1.204323,  1.206632,  1.199266,  1.210229,  1.213027,  1.215987,  1.213018,  1.224047,  1.228960,  1.222435,  1.226585,  1.232495,  1.242922,  1.225659,  1.245258,  1.246608,  1.251253,  1.244451,  1.255824,  1.256170,  1.259982,  1.254899,  1.267493,  1.275709,  1.268187,  1.265396,  1.282036,  1.286492,  1.266642,  1.289127,  1.292226,  1.294796, },
{ 1.000000,  1.003082,  1.006097,  1.009212,  1.012017,  1.014792,  1.017671,  1.021107,  1.022891,  1.026121,  1.030387,  1.033012,  1.034382,  1.039031,  1.041848,  1.044658,  1.047135,  1.051398,  1.054106,  1.055715,  1.057788,  1.062263,  1.067485,  1.065460,  1.071309,  1.075768,  1.077787,  1.077415,  1.084619,  1.086770,  1.088955,  1.090370,  1.095639,  1.100416,  1.098745,  1.102033,  1.107303,  1.113160,  1.107644,  1.117111,  1.121495,  1.123960,  1.120523,  1.128118,  1.130810,  1.134547,  1.133493,  1.141059,  1.145978,  1.142557,  1.146671,  1.151633,  1.159491,  1.148809,  1.162694,  1.164605,  1.168480,  1.166161,  1.172988,  1.175926,  1.178737,  1.176406,  1.186386,  1.192254,  1.188321,  1.187339,  1.198647,  1.205028,  1.189818,  1.207525,  1.210072,  1.213874,  1.209619,  1.220188,  1.220214,  1.223913,  1.220550,  1.229332,  1.238951,  1.226871,  1.233891,  1.245365,  1.246901,  1.236759,  1.251954,  1.253893,  1.256912,  1.255104,  1.264375,  1.269078,  1.264844,  1.264064,  1.273480,  1.284230,  1.268391,  1.282319,  1.290561,  1.290670,  1.280472,  1.297640, },
{ 1.000000,  1.003133,  1.005997,  1.008895,  1.012094,  1.015322,  1.017625,  1.020619,  1.023993,  1.027718,  1.028360,  1.033277,  1.037056,  1.040150,  1.041152,  1.045862,  1.048611,  1.051777,  1.053669,  1.058022,  1.061889,  1.062248,  1.065722,  1.069507,  1.074730,  1.071193,  1.079403,  1.082226,  1.085575,  1.085994,  1.090602,  1.094434,  1.096602,  1.096371,  1.104145,  1.108289,  1.107275,  1.109618,  1.116321,  1.121843,  1.113047,  1.126600,  1.127476,  1.131487,  1.130455,  1.137840,  1.138999,  1.142531,  1.141743,  1.148479,  1.155232,  1.149351,  1.154416,  1.162733,  1.165902,  1.158339,  1.170455,  1.173649,  1.176598,  1.175726,  1.184085,  1.187236,  1.185332,  1.186472,  1.193449,  1.202356,  1.191996,  1.203005,  1.207931,  1.211444,  1.202492,  1.217477,  1.217963,  1.221801,  1.219697,  1.229700,  1.232635,  1.228964,  1.230834,  1.238012,  1.250420,  1.233331,  1.249476,  1.255674,  1.257119,  1.249075,  1.261484,  1.263102,  1.268475,  1.263501,  1.274304,  1.282624,  1.271461,  1.278058,  1.283250,  1.295725,  1.274904,  1.295907,  1.298902,  1.303899, },
{ 1.000000,  1.003014,  1.005933,  1.009069,  1.011802,  1.014424,  1.018131,  1.021292,  1.023236,  1.026178,  1.029868,  1.033821,  1.033891,  1.040104,  1.042316,  1.045714,  1.047281,  1.051849,  1.054224,  1.057246,  1.058298,  1.063491,  1.067803,  1.067063,  1.070722,  1.076231,  1.079270,  1.076820,  1.084617,  1.087572,  1.090387,  1.091360,  1.096722,  1.100092,  1.100770,  1.103028,  1.108440,  1.114455,  1.109503,  1.117026,  1.122094,  1.124952,  1.120473,  1.130626,  1.132501,  1.135995,  1.134724,  1.142705,  1.146490,  1.144031,  1.146888,  1.152680,  1.161308,  1.150375,  1.162934,  1.167996,  1.170022,  1.165727,  1.176329,  1.176687,  1.181938,  1.178806,  1.188116,  1.193280,  1.187463,  1.192801,  1.198928,  1.206020,  1.193428,  1.209093,  1.211601,  1.216400,  1.210491,  1.220220,  1.222726,  1.224286,  1.221177,  1.233752,  1.239013,  1.233334,  1.235111,  1.244396,  1.255503,  1.232339,  1.258231,  1.255770,  1.260702,  1.256789,  1.267274,  1.266390,  1.271168,  1.264539,  1.278675,  1.285840,  1.275561,  1.279312,  1.292268,  1.296470,  1.278987,  1.299165, },
{ 1.000000,  1.003078,  1.005946,  1.008803,  1.011910,  1.015009,  1.017454,  1.020267,  1.023613,  1.027376,  1.028244,  1.032157,  1.036171,  1.038971,  1.039685,  1.044897,  1.047344,  1.050472,  1.051851,  1.057723,  1.060846,  1.061265,  1.064276,  1.068306,  1.074082,  1.070420,  1.077762,  1.081662,  1.084426,  1.082865,  1.090523,  1.092230,  1.095550,  1.096320,  1.101778,  1.107089,  1.103505,  1.108204,  1.113766,  1.118304,  1.112518,  1.122944,  1.126062,  1.130058,  1.126608,  1.134309,  1.137116,  1.139153,  1.138327,  1.147359,  1.151340,  1.148145,  1.151640,  1.157004,  1.165895,  1.153152,  1.169959,  1.169762,  1.174847,  1.171635,  1.179813,  1.182006,  1.184097,  1.181888,  1.192085,  1.197839,  1.192135,  1.194510,  1.205417,  1.209789,  1.196295,  1.212932,  1.216164,  1.218959,  1.214956,  1.226099,  1.227838,  1.226117,  1.226038,  1.234220,  1.244924,  1.230460,  1.241253,  1.251933,  1.253182,  1.241014,  1.259718,  1.256376,  1.264098,  1.256929,  1.271151,  1.275904,  1.267991,  1.271201,  1.279517,  1.292846,  1.270792,  1.289682,  1.296431,  1.296961, },
{ 1.000000,  1.002906,  1.005905,  1.008894,  1.011672,  1.014823,  1.018213,  1.021840,  1.023257,  1.026500,  1.030048,  1.033597,  1.033483,  1.039651,  1.042900,  1.046135,  1.045945,  1.051456,  1.054033,  1.056551,  1.058006,  1.064118,  1.067901,  1.067471,  1.070583,  1.074781,  1.080707,  1.075655,  1.084888,  1.088060,  1.091098,  1.090888,  1.096967,  1.098823,  1.101467,  1.101837,  1.108879,  1.113888,  1.112308,  1.113684,  1.121632,  1.126814,  1.117241,  1.130621,  1.133429,  1.135768,  1.134663,  1.143393,  1.145547,  1.145341,  1.146088,  1.152898,  1.160085,  1.152505,  1.159434,  1.168965,  1.170800,  1.163215,  1.176360,  1.176304,  1.180403,  1.177993,  1.189093,  1.192954,  1.188159,  1.190213,  1.198130,  1.208173,  1.193002,  1.206601,  1.214874,  1.214002,  1.207451,  1.221675,  1.223093,  1.224818,  1.222481,  1.232167,  1.240946,  1.230168,  1.235021,  1.244124,  1.252906,  1.233344,  1.254422,  1.259287,  1.262492,  1.250654,  1.265838,  1.268260,  1.269607,  1.264760,  1.280558,  1.285000,  1.274582,  1.280851,  1.286796,  1.300442,  1.275920,  1.301313, },
{ 1.000000,  1.003026,  1.005891,  1.008942,  1.012355,  1.015043,  1.017980,  1.020394,  1.024696,  1.027993,  1.029708,  1.032017,  1.037341,  1.040566,  1.039593,  1.045904,  1.048674,  1.052244,  1.053417,  1.058303,  1.060985,  1.062739,  1.065081,  1.069828,  1.074967,  1.072367,  1.077569,  1.083762,  1.086365,  1.083758,  1.091936,  1.094333,  1.096778,  1.097947,  1.104063,  1.108014,  1.107491,  1.109330,  1.114836,  1.122148,  1.115473,  1.124176,  1.129449,  1.131203,  1.127060,  1.138838,  1.140309,  1.141916,  1.141879,  1.149716,  1.155986,  1.150390,  1.154150,  1.160781,  1.168275,  1.157297,  1.171363,  1.175838,  1.178466,  1.171813,  1.182971,  1.185337,  1.187962,  1.185015,  1.196811,  1.201745,  1.194226,  1.199692,  1.205093,  1.216256,  1.199567,  1.218131,  1.219552,  1.224702,  1.218629,  1.228521,  1.231222,  1.232165,  1.229324,  1.242207,  1.248952,  1.240861,  1.240779,  1.255084,  1.263203,  1.239543,  1.264496,  1.265869,  1.270129,  1.262335,  1.277156,  1.276164,  1.278141,  1.274068,  1.285747,  1.297746,  1.278315,  1.288937,  1.302583,  1.304937, },
{ 1.000000,  1.002839,  1.006460,  1.009216,  1.012794,  1.015218,  1.018748,  1.022429,  1.024324,  1.026972,  1.031069,  1.035201,  1.035676,  1.040421,  1.043928,  1.047224,  1.047249,  1.053681,  1.056740,  1.058709,  1.060633,  1.066041,  1.070314,  1.069873,  1.072588,  1.078234,  1.083162,  1.078792,  1.087929,  1.091455,  1.095044,  1.092422,  1.100022,  1.103459,  1.105484,  1.106265,  1.113379,  1.117816,  1.114876,  1.119108,  1.124636,  1.131898,  1.122022,  1.135023,  1.138066,  1.141811,  1.139324,  1.146239,  1.151627,  1.151675,  1.149335,  1.160440,  1.165939,  1.161053,  1.163258,  1.172963,  1.180373,  1.163912,  1.183829,  1.184370,  1.188209,  1.184658,  1.195602,  1.196371,  1.198780,  1.195957,  1.206255,  1.215043,  1.202916,  1.210160,  1.221420,  1.225977,  1.211293,  1.229175,  1.232208,  1.233503,  1.230377,  1.243088,  1.247238,  1.241360,  1.242250,  1.251452,  1.263481,  1.245756,  1.261466,  1.267396,  1.271960,  1.256603,  1.277467,  1.278691,  1.280169,  1.275695,  1.290560,  1.294836,  1.285748,  1.288112,  1.296898,  1.313442,  1.287346,  1.308908, },
{ 1.000000,  1.003009,  1.006416,  1.008698,  1.012067,  1.014844,  1.018395,  1.020452,  1.024269,  1.027671,  1.029384,  1.032532,  1.035878,  1.040171,  1.039611,  1.045402,  1.048496,  1.051812,  1.052699,  1.057044,  1.060595,  1.062355,  1.063479,  1.070383,  1.073735,  1.072907,  1.075933,  1.081830,  1.087168,  1.080628,  1.091979,  1.093369,  1.097114,  1.096658,  1.103559,  1.105364,  1.107967,  1.106665,  1.115017,  1.120625,  1.115957,  1.119745,  1.128538,  1.131960,  1.124286,  1.136566,  1.139477,  1.141843,  1.140669,  1.148805,  1.152727,  1.150171,  1.151893,  1.159330,  1.167443,  1.157093,  1.166834,  1.174004,  1.177730,  1.167812,  1.181782,  1.184623,  1.187020,  1.183460,  1.193890,  1.199686,  1.193365,  1.195796,  1.203426,  1.215403,  1.197550,  1.214052,  1.219903,  1.222251,  1.213384,  1.227338,  1.228225,  1.232529,  1.226973,  1.239495,  1.246390,  1.235964,  1.241815,  1.249780,  1.259609,  1.240608,  1.259981,  1.262700,  1.269407,  1.258994,  1.271291,  1.275446,  1.274797,  1.268981,  1.285470,  1.292161,  1.281908,  1.283340,  1.295520,  1.309576, },
{ 1.000000,  1.002724,  1.006406,  1.009006,  1.012102,  1.014331,  1.018397,  1.020970,  1.023933,  1.025576,  1.030404,  1.033825,  1.034818,  1.037501,  1.042480,  1.046005,  1.044910,  1.051441,  1.054133,  1.057231,  1.058258,  1.063616,  1.066767,  1.067798,  1.069396,  1.074916,  1.080212,  1.077116,  1.082657,  1.088035,  1.091625,  1.088062,  1.096927,  1.098835,  1.102237,  1.100959,  1.109427,  1.112985,  1.110975,  1.113060,  1.119223,  1.127305,  1.118219,  1.128955,  1.133525,  1.137026,  1.131000,  1.142266,  1.143970,  1.146872,  1.145357,  1.153565,  1.160637,  1.152744,  1.158079,  1.165772,  1.171514,  1.160689,  1.174703,  1.177856,  1.183421,  1.175644,  1.185930,  1.189771,  1.190769,  1.186959,  1.199842,  1.205166,  1.198464,  1.201715,  1.208894,  1.221043,  1.200347,  1.221923,  1.221261,  1.227963,  1.220900,  1.231385,  1.234412,  1.235692,  1.230819,  1.244141,  1.251737,  1.241958,  1.244108,  1.258272,  1.264690,  1.243242,  1.264968,  1.269040,  1.271434,  1.264623,  1.278568,  1.281398,  1.277578,  1.275565,  1.285850,  1.299988,  1.279445,  1.291930, },
{ 1.000000,  1.002968,  1.006371,  1.008447,  1.012015,  1.014439,  1.018287,  1.020058,  1.023926,  1.027093,  1.029231,  1.031727,  1.035431,  1.039761,  1.039189,  1.044433,  1.048099,  1.050813,  1.050987,  1.056593,  1.059331,  1.061919,  1.063608,  1.068076,  1.073444,  1.071746,  1.075191,  1.080452,  1.084852,  1.080408,  1.089358,  1.093246,  1.096979,  1.093339,  1.100991,  1.104217,  1.105702,  1.106067,  1.113706,  1.118899,  1.114762,  1.118544,  1.123899,  1.132528,  1.121073,  1.134811,  1.137278,  1.140908,  1.138498,  1.145924,  1.148079,  1.150100,  1.149091,  1.158507,  1.163907,  1.159310,  1.160315,  1.171067,  1.177901,  1.161617,  1.179739,  1.183090,  1.184940,  1.181275,  1.191676,  1.195210,  1.192738,  1.192906,  1.200996,  1.210473,  1.198291,  1.206138,  1.217733,  1.221073,  1.207845,  1.224456,  1.224729,  1.228783,  1.224113,  1.236609,  1.242647,  1.234242,  1.235540,  1.245802,  1.258754,  1.236982,  1.253301,  1.262785,  1.263158,  1.251890,  1.268343,  1.271618,  1.272380,  1.267663,  1.279263,  1.291631,  1.274551,  1.279519,  1.291409,  1.302436, },
{ 1.000000,  1.002698,  1.006229,  1.008990,  1.011995,  1.013759,  1.017913,  1.020738,  1.023388,  1.025209,  1.030065,  1.033155,  1.034106,  1.037150,  1.040835,  1.045690,  1.043763,  1.050807,  1.053196,  1.056792,  1.056496,  1.062218,  1.064826,  1.067199,  1.067771,  1.074192,  1.078480,  1.077504,  1.078950,  1.086605,  1.090759,  1.084241,  1.095317,  1.097848,  1.100709,  1.099807,  1.106923,  1.109803,  1.110264,  1.110587,  1.117501,  1.124261,  1.117563,  1.123392,  1.131695,  1.135057,  1.128041,  1.139666,  1.141246,  1.143383,  1.143139,  1.150990,  1.156424,  1.152779,  1.153374,  1.161348,  1.170507,  1.158391,  1.169068,  1.175666,  1.178372,  1.170330,  1.184101,  1.186377,  1.186992,  1.185434,  1.194956,  1.203149,  1.193183,  1.197075,  1.205850,  1.215360,  1.198000,  1.215888,  1.220714,  1.224689,  1.213396,  1.226126,  1.230329,  1.231939,  1.226453,  1.240501,  1.247174,  1.235605,  1.241658,  1.248457,  1.261822,  1.238854,  1.260973,  1.263274,  1.268470,  1.259526,  1.270461,  1.274863,  1.274354,  1.268853,  1.284734,  1.293059,  1.281314,  1.280463, },
{ 1.000000,  1.002888,  1.006344,  1.008072,  1.011766,  1.014409,  1.017915,  1.019748,  1.023527,  1.026019,  1.029168,  1.030911,  1.034904,  1.038892,  1.038830,  1.042695,  1.047195,  1.050261,  1.049427,  1.055751,  1.058217,  1.061240,  1.062461,  1.067346,  1.071226,  1.071564,  1.073213,  1.078302,  1.084010,  1.080060,  1.086906,  1.091122,  1.094267,  1.090995,  1.099639,  1.102836,  1.104174,  1.104126,  1.111580,  1.116227,  1.113329,  1.115796,  1.122339,  1.128907,  1.119835,  1.132018,  1.135347,  1.138851,  1.133505,  1.142770,  1.146590,  1.147381,  1.146797,  1.155603,  1.160940,  1.154490,  1.159409,  1.165334,  1.174868,  1.159564,  1.175617,  1.179070,  1.182619,  1.177819,  1.185841,  1.191719,  1.190191,  1.186489,  1.199586,  1.205846,  1.197510,  1.199934,  1.211622,  1.220280,  1.197162,  1.222365,  1.222489,  1.225408,  1.220128,  1.232399,  1.233554,  1.234011,  1.230321,  1.242071,  1.251893,  1.236375,  1.244081,  1.256627,  1.262171,  1.242304,  1.264087,  1.267011,  1.267148,  1.262879,  1.276414,  1.282115,  1.272637,  1.273177,  1.284539,  1.297581, },
{ 1.000000,  1.002697,  1.006063,  1.008724,  1.011766,  1.013317,  1.017768,  1.020320,  1.023007,  1.025496,  1.029468,  1.032370,  1.033998,  1.036651,  1.040117,  1.044960,  1.043543,  1.049535,  1.052761,  1.056167,  1.055357,  1.060877,  1.064456,  1.066597,  1.067199,  1.072951,  1.078034,  1.075274,  1.079505,  1.083600,  1.090437,  1.083491,  1.093193,  1.096607,  1.100253,  1.098032,  1.104196,  1.108586,  1.108829,  1.108374,  1.117973,  1.121585,  1.117660,  1.120942,  1.128388,  1.135658,  1.122734,  1.139025,  1.139321,  1.143494,  1.141276,  1.149559,  1.150907,  1.153059,  1.150126,  1.160309,  1.167238,  1.159115,  1.163794,  1.173268,  1.178333,  1.165004,  1.181402,  1.184425,  1.185673,  1.183421,  1.193366,  1.197767,  1.192094,  1.194039,  1.202910,  1.212405,  1.197628,  1.210445,  1.216824,  1.221980,  1.207188,  1.225446,  1.227307,  1.228897,  1.224584,  1.237135,  1.242844,  1.233611,  1.236176,  1.245649,  1.258751,  1.236045,  1.256457,  1.262047,  1.264496,  1.252032,  1.268656,  1.270367,  1.273007,  1.266003,  1.280693,  1.288466,  1.274121,  1.281244, },
{ 1.000000,  1.002809,  1.006186,  1.008027,  1.011537,  1.014689,  1.017706,  1.019321,  1.022944,  1.026214,  1.028528,  1.030226,  1.035087,  1.038240,  1.038952,  1.042221,  1.046247,  1.051039,  1.047660,  1.056167,  1.057491,  1.061155,  1.061866,  1.066879,  1.068866,  1.071759,  1.071950,  1.078298,  1.082901,  1.080860,  1.084081,  1.090515,  1.094861,  1.088471,  1.099103,  1.101612,  1.103696,  1.104407,  1.110794,  1.113973,  1.112598,  1.114928,  1.121082,  1.127266,  1.121062,  1.127924,  1.133945,  1.138542,  1.130840,  1.142688,  1.144533,  1.147095,  1.144588,  1.155545,  1.158800,  1.153742,  1.156740,  1.163725,  1.173188,  1.159234,  1.173748,  1.178169,  1.181452,  1.172425,  1.186486,  1.187881,  1.189796,  1.187888,  1.197558,  1.205247,  1.193358,  1.200078,  1.208464,  1.215910,  1.199430,  1.218129,  1.220758,  1.226155,  1.215574,  1.228788,  1.231790,  1.231453,  1.227856,  1.242626,  1.246896,  1.238092,  1.242179,  1.249923,  1.264293,  1.236286,  1.264306,  1.261846,  1.268540,  1.259706,  1.272446,  1.274830,  1.274587,  1.269097,  1.285342,  1.291957, },
{ 1.000000,  1.002712,  1.005802,  1.008673,  1.011693,  1.012872,  1.017452,  1.020137,  1.022726,  1.024496,  1.029070,  1.031632,  1.033344,  1.035450,  1.039714,  1.043906,  1.043087,  1.047362,  1.051955,  1.055182,  1.053153,  1.060308,  1.062027,  1.065623,  1.065347,  1.071674,  1.075645,  1.074324,  1.077128,  1.082226,  1.088352,  1.082602,  1.090842,  1.095025,  1.097797,  1.094178,  1.102547,  1.105658,  1.107152,  1.107622,  1.113644,  1.120279,  1.114205,  1.119087,  1.125093,  1.131126,  1.121291,  1.134363,  1.137822,  1.142285,  1.134504,  1.145138,  1.148367,  1.148581,  1.147990,  1.157844,  1.162699,  1.156229,  1.160512,  1.166245,  1.177897,  1.159709,  1.178045,  1.179784,  1.183285,  1.178696,  1.188633,  1.189749,  1.190843,  1.189207,  1.200855,  1.205333,  1.199587,  1.200053,  1.211871,  1.220537,  1.198083,  1.221278,  1.224029,  1.224163,  1.219959,  1.232955,  1.235651,  1.230374,  1.231293,  1.240998,  1.250074,  1.235767,  1.245004,  1.256434,  1.261180,  1.243774,  1.263994,  1.262965,  1.265598,  1.261095,  1.276285,  1.281168,  1.269266,  1.272819, },
{ 1.000000,  1.002766,  1.006135,  1.007929,  1.011232,  1.014023,  1.017291,  1.018721,  1.022668,  1.025189,  1.028135,  1.030045,  1.033985,  1.037427,  1.037758,  1.041074,  1.045077,  1.048953,  1.046926,  1.054076,  1.056763,  1.059920,  1.058823,  1.064811,  1.067736,  1.069852,  1.070487,  1.077333,  1.080157,  1.078621,  1.082750,  1.086373,  1.093200,  1.085796,  1.097156,  1.098718,  1.102322,  1.100184,  1.107732,  1.109583,  1.110798,  1.111305,  1.119363,  1.123504,  1.120063,  1.122149,  1.131225,  1.136124,  1.123933,  1.139733,  1.141670,  1.143577,  1.141911,  1.150956,  1.153038,  1.151441,  1.152289,  1.160540,  1.167470,  1.157303,  1.165554,  1.174089,  1.178244,  1.166572,  1.182026,  1.182936,  1.183343,  1.183530,  1.193551,  1.198207,  1.191520,  1.193450,  1.202396,  1.212126,  1.195769,  1.210255,  1.216192,  1.218679,  1.207064,  1.224895,  1.226378,  1.224657,  1.223607,  1.235871,  1.242844,  1.229067,  1.235401,  1.244879,  1.255029,  1.232668,  1.256222,  1.259290,  1.263124,  1.248379,  1.264600,  1.268370,  1.267797,  1.262788,  1.279618,  1.284324, },
{ 1.000000,  1.002635,  1.005762,  1.008350,  1.011564,  1.012669,  1.017258,  1.019663,  1.022504,  1.024013,  1.028247,  1.030826,  1.032931,  1.034706,  1.039553,  1.042808,  1.043280,  1.045528,  1.050820,  1.054993,  1.050822,  1.059097,  1.061874,  1.064421,  1.064449,  1.070892,  1.072818,  1.074167,  1.075099,  1.081363,  1.086333,  1.082018,  1.087205,  1.093173,  1.096987,  1.091356,  1.101119,  1.103690,  1.104901,  1.105762,  1.112331,  1.117031,  1.113782,  1.115830,  1.122878,  1.129303,  1.121458,  1.130383,  1.134986,  1.138634,  1.131345,  1.143245,  1.146704,  1.146432,  1.145424,  1.155215,  1.159892,  1.153125,  1.157089,  1.164398,  1.172271,  1.158634,  1.174484,  1.177016,  1.181247,  1.172404,  1.184298,  1.188477,  1.187394,  1.186816,  1.197355,  1.202440,  1.192830,  1.199336,  1.205519,  1.217087,  1.195634,  1.216412,  1.218892,  1.222607,  1.215634,  1.225796,  1.230979,  1.227810,  1.224139,  1.239716,  1.244841,  1.234252,  1.237679,  1.250378,  1.260832,  1.231226,  1.261711,  1.260048,  1.262826,  1.256391,  1.271003,  1.271218,  1.269675,  1.266391, },
{ 1.000000,  1.002732,  1.005964,  1.007910,  1.010817,  1.014274,  1.017247,  1.018038,  1.022671,  1.025360,  1.027616,  1.030125,  1.033970,  1.036909,  1.038001,  1.040686,  1.044624,  1.049192,  1.047656,  1.052991,  1.056203,  1.059817,  1.057617,  1.065053,  1.067444,  1.069108,  1.070917,  1.076623,  1.079711,  1.078379,  1.081467,  1.085961,  1.092849,  1.086334,  1.095286,  1.099546,  1.101803,  1.098451,  1.106595,  1.109428,  1.110716,  1.111090,  1.118887,  1.123630,  1.117739,  1.123670,  1.127551,  1.136451,  1.124213,  1.137988,  1.140692,  1.144485,  1.140387,  1.148219,  1.152580,  1.150575,  1.150256,  1.162546,  1.165105,  1.158955,  1.162660,  1.171592,  1.180618,  1.161203,  1.182366,  1.181779,  1.185322,  1.182307,  1.192741,  1.193320,  1.193171,  1.190624,  1.203374,  1.208876,  1.198148,  1.205059,  1.214996,  1.220546,  1.202693,  1.222868,  1.225352,  1.225406,  1.223910,  1.234590,  1.239068,  1.230108,  1.233710,  1.243897,  1.253050,  1.235531,  1.250289,  1.256863,  1.262622,  1.244229,  1.265639,  1.266931,  1.266763,  1.262995,  1.277537,  1.282530, },
{ 1.000000,  1.002577,  1.005581,  1.008228,  1.011268,  1.013004,  1.016757,  1.019437,  1.022368,  1.023686,  1.027857,  1.030572,  1.032820,  1.034591,  1.039440,  1.042413,  1.042009,  1.046468,  1.049855,  1.053771,  1.051460,  1.058639,  1.060884,  1.064446,  1.063894,  1.069344,  1.072487,  1.073028,  1.074455,  1.081513,  1.084366,  1.082499,  1.086120,  1.091698,  1.097610,  1.088309,  1.101836,  1.102040,  1.105474,  1.104817,  1.111867,  1.113295,  1.114347,  1.113974,  1.123530,  1.126884,  1.121999,  1.127083,  1.133881,  1.138625,  1.128195,  1.142481,  1.144184,  1.145941,  1.145591,  1.153901,  1.157064,  1.152903,  1.155355,  1.163883,  1.169794,  1.159483,  1.169603,  1.175948,  1.180056,  1.169388,  1.184679,  1.185069,  1.186600,  1.183891,  1.197151,  1.200242,  1.190916,  1.196380,  1.204321,  1.214219,  1.195813,  1.213844,  1.218318,  1.220911,  1.209113,  1.226560,  1.226721,  1.226666,  1.226014,  1.238347,  1.244683,  1.228097,  1.238458,  1.248028,  1.254076,  1.234144,  1.256986,  1.258829,  1.264073,  1.251274,  1.267002,  1.269353,  1.266173,  1.263777, },
{ 1.000000,  1.002697,  1.005775,  1.007831,  1.010584,  1.013766,  1.017125,  1.017375,  1.022366,  1.024548,  1.027771,  1.029441,  1.032961,  1.036014,  1.037728,  1.039691,  1.044649,  1.047615,  1.047500,  1.050885,  1.055572,  1.059005,  1.055924,  1.063537,  1.066266,  1.068412,  1.069390,  1.075544,  1.077692,  1.077237,  1.080048,  1.085132,  1.090089,  1.085837,  1.092242,  1.097297,  1.100994,  1.095458,  1.105842,  1.106146,  1.109530,  1.108900,  1.117381,  1.120581,  1.116179,  1.120908,  1.126089,  1.133620,  1.123478,  1.134755,  1.139091,  1.141332,  1.135577,  1.146739,  1.148493,  1.148411,  1.150405,  1.157229,  1.164461,  1.153853,  1.161553,  1.168517,  1.173870,  1.160294,  1.177304,  1.180668,  1.184359,  1.175012,  1.187849,  1.190305,  1.188033,  1.189089,  1.200380,  1.205336,  1.194559,  1.202108,  1.207454,  1.219885,  1.197401,  1.219786,  1.220473,  1.223165,  1.219028,  1.229842,  1.230013,  1.228700,  1.229043,  1.242256,  1.245718,  1.237344,  1.239376,  1.252059,  1.262099,  1.234020,  1.261256,  1.263923,  1.262467,  1.258882,  1.273110,  1.275138, },
{ 1.000000,  1.002567,  1.005465,  1.008066,  1.010919,  1.013040,  1.016015,  1.019574,  1.022225,  1.023016,  1.027669,  1.029831,  1.032120,  1.034560,  1.038683,  1.041846,  1.042002,  1.045053,  1.049377,  1.053511,  1.050952,  1.057199,  1.060872,  1.062732,  1.062276,  1.068606,  1.071200,  1.072721,  1.074010,  1.080006,  1.084207,  1.080250,  1.085357,  1.090135,  1.095415,  1.088406,  1.099037,  1.102271,  1.105444,  1.101096,  1.109288,  1.112309,  1.112552,  1.113404,  1.122008,  1.125385,  1.120257,  1.126043,  1.129677,  1.138284,  1.125726,  1.141226,  1.142086,  1.146149,  1.142414,  1.150939,  1.152579,  1.152641,  1.152985,  1.162780,  1.166621,  1.161867,  1.163296,  1.174161,  1.179867,  1.162762,  1.181869,  1.183988,  1.185302,  1.182904,  1.193179,  1.194886,  1.191854,  1.192865,  1.201869,  1.209730,  1.196655,  1.205792,  1.215644,  1.219932,  1.206344,  1.222913,  1.223332,  1.222939,  1.223672,  1.234388,  1.239353,  1.229943,  1.232811,  1.242567,  1.253047,  1.234608,  1.249291,  1.256062,  1.258568,  1.245501,  1.264668,  1.265403,  1.262665,  1.262745, },
{ 1.000000,  1.002630,  1.005711,  1.007592,  1.010363,  1.013012,  1.016560,  1.017281,  1.021372,  1.024352,  1.027101,  1.027763,  1.032150,  1.034706,  1.036617,  1.038310,  1.043405,  1.046076,  1.045567,  1.050081,  1.052922,  1.057721,  1.054500,  1.062175,  1.063898,  1.066822,  1.067352,  1.072229,  1.074227,  1.075881,  1.077378,  1.083384,  1.087086,  1.085299,  1.087684,  1.093920,  1.099334,  1.090266,  1.102549,  1.104470,  1.106607,  1.105787,  1.113073,  1.114521,  1.115051,  1.115600,  1.123437,  1.128489,  1.121290,  1.128155,  1.134541,  1.138301,  1.130047,  1.142683,  1.143869,  1.143941,  1.145964,  1.153676,  1.157099,  1.152457,  1.154833,  1.162419,  1.169413,  1.159499,  1.169721,  1.173921,  1.177980,  1.168772,  1.182878,  1.184996,  1.183985,  1.183066,  1.194821,  1.198304,  1.188886,  1.194607,  1.203090,  1.210041,  1.193845,  1.212759,  1.214524,  1.218277,  1.208330,  1.222271,  1.224090,  1.222797,  1.222757,  1.235483,  1.238330,  1.226681,  1.235427,  1.241895,  1.253028,  1.228821,  1.252759,  1.253713,  1.257553,  1.250750,  1.261368,  1.264983, },
{ 1.000000,  1.002524,  1.005296,  1.008004,  1.010638,  1.012921,  1.015523,  1.018514,  1.022042,  1.021742,  1.026968,  1.029388,  1.031613,  1.033363,  1.037843,  1.039758,  1.041437,  1.043937,  1.048076,  1.051336,  1.050810,  1.054473,  1.059207,  1.062347,  1.059486,  1.067367,  1.069511,  1.070511,  1.072676,  1.078351,  1.080665,  1.079576,  1.082484,  1.087708,  1.092754,  1.088360,  1.095323,  1.098225,  1.102669,  1.097295,  1.107642,  1.108658,  1.110030,  1.111266,  1.118955,  1.121173,  1.117366,  1.121494,  1.126548,  1.134355,  1.124277,  1.135855,  1.139792,  1.141883,  1.136793,  1.146580,  1.148390,  1.149476,  1.149297,  1.158752,  1.163391,  1.154298,  1.162172,  1.166355,  1.175350,  1.159878,  1.177181,  1.178055,  1.182126,  1.178259,  1.185933,  1.189679,  1.186603,  1.186400,  1.200631,  1.201652,  1.194508,  1.198233,  1.208671,  1.217605,  1.194542,  1.219409,  1.216950,  1.219892,  1.218125,  1.229243,  1.227451,  1.227714,  1.224375,  1.238985,  1.243432,  1.232021,  1.238382,  1.249697,  1.254540,  1.234551,  1.258083,  1.257992,  1.257520,  1.257066, },
{ 1.000000,  1.002571,  1.005502,  1.007496,  1.010100,  1.013266,  1.016103,  1.017238,  1.020962,  1.023656,  1.026829,  1.027374,  1.031793,  1.034405,  1.036376,  1.038254,  1.042927,  1.045459,  1.045079,  1.048874,  1.052585,  1.056432,  1.054323,  1.060860,  1.063554,  1.066126,  1.065415,  1.072307,  1.072920,  1.075393,  1.076786,  1.082935,  1.085332,  1.082956,  1.088174,  1.092002,  1.096673,  1.090518,  1.101104,  1.102374,  1.106157,  1.104080,  1.111660,  1.112817,  1.113164,  1.114630,  1.122656,  1.125069,  1.122063,  1.125759,  1.131818,  1.139202,  1.124691,  1.143308,  1.140829,  1.144135,  1.144301,  1.152207,  1.151124,  1.152432,  1.152245,  1.162960,  1.165106,  1.160162,  1.164662,  1.171984,  1.176889,  1.164215,  1.181271,  1.181209,  1.182426,  1.183359,  1.191865,  1.193470,  1.188268,  1.192031,  1.200537,  1.205729,  1.196053,  1.205421,  1.211433,  1.216159,  1.204226,  1.221298,  1.219862,  1.221178,  1.218590,  1.233953,  1.234670,  1.223709,  1.231745,  1.238608,  1.248169,  1.229804,  1.248219,  1.252186,  1.254618,  1.242214,  1.261470,  1.258960, },
{ 1.000000,  1.002473,  1.005238,  1.007807,  1.010936,  1.012390,  1.015268,  1.018544,  1.021056,  1.022171,  1.026356,  1.028618,  1.031846,  1.032640,  1.037148,  1.038867,  1.041360,  1.043034,  1.047955,  1.050173,  1.050607,  1.054063,  1.057347,  1.062053,  1.057790,  1.066821,  1.067598,  1.070870,  1.071186,  1.076776,  1.077856,  1.079710,  1.080999,  1.087462,  1.089711,  1.088775,  1.091910,  1.097870,  1.102146,  1.094297,  1.105646,  1.107755,  1.108901,  1.109796,  1.117474,  1.117897,  1.117022,  1.119399,  1.125753,  1.130655,  1.124635,  1.131954,  1.137448,  1.141001,  1.133143,  1.146791,  1.144275,  1.148262,  1.146783,  1.157650,  1.159543,  1.153073,  1.158989,  1.165331,  1.171800,  1.160687,  1.173092,  1.176935,  1.179000,  1.171982,  1.185608,  1.184862,  1.185151,  1.186997,  1.195574,  1.201210,  1.189027,  1.197558,  1.205250,  1.209646,  1.195208,  1.213963,  1.216539,  1.220866,  1.209188,  1.224921,  1.224289,  1.222660,  1.223740,  1.237184,  1.238831,  1.229263,  1.235967,  1.242089,  1.254399,  1.229463,  1.255391,  1.253415,  1.256594,  1.252548, },
{ 1.000000,  1.002509,  1.005224,  1.007423,  1.010287,  1.013124,  1.015797,  1.017729,  1.020336,  1.023642,  1.026646,  1.026277,  1.031571,  1.034058,  1.036057,  1.038208,  1.042372,  1.044034,  1.045400,  1.048016,  1.052192,  1.055186,  1.054967,  1.058779,  1.063282,  1.066141,  1.063606,  1.071355,  1.071812,  1.074480,  1.075814,  1.082677,  1.084027,  1.082439,  1.086303,  1.091165,  1.096257,  1.090403,  1.098882,  1.102443,  1.104312,  1.101662,  1.110261,  1.111368,  1.112198,  1.114085,  1.121288,  1.124839,  1.118565,  1.124874,  1.130791,  1.134933,  1.125682,  1.139445,  1.141435,  1.145076,  1.139149,  1.149101,  1.149921,  1.150855,  1.150486,  1.162525,  1.162375,  1.157718,  1.163888,  1.167412,  1.177153,  1.160527,  1.180233,  1.178609,  1.183575,  1.178714,  1.189910,  1.187785,  1.188690,  1.189336,  1.200570,  1.202121,  1.197453,  1.199045,  1.210558,  1.216369,  1.195171,  1.219134,  1.218888,  1.219749,  1.218563,  1.229551,  1.228820,  1.225216,  1.227720,  1.237449,  1.242570,  1.230894,  1.239829,  1.249703,  1.253860,  1.238167,  1.258604,  1.255844, },
{ 1.000000,  1.002404,  1.005121,  1.007654,  1.010062,  1.011781,  1.014785,  1.017464,  1.020431,  1.021474,  1.025016,  1.027543,  1.030367,  1.030922,  1.035480,  1.037220,  1.039257,  1.041406,  1.045721,  1.048743,  1.047610,  1.051472,  1.055525,  1.058878,  1.055923,  1.063340,  1.065605,  1.068521,  1.066633,  1.073264,  1.074710,  1.076266,  1.077707,  1.084666,  1.086034,  1.083661,  1.088998,  1.092089,  1.098205,  1.090396,  1.102067,  1.102265,  1.106010,  1.104718,  1.111224,  1.111588,  1.112813,  1.114139,  1.122034,  1.124178,  1.121504,  1.123925,  1.131803,  1.137321,  1.123352,  1.140083,  1.140562,  1.142463,  1.140989,  1.150869,  1.149075,  1.149443,  1.150748,  1.159379,  1.163411,  1.155114,  1.162421,  1.169070,  1.173369,  1.162102,  1.178209,  1.177120,  1.177049,  1.179044,  1.188777,  1.189457,  1.184101,  1.187378,  1.195659,  1.202773,  1.190738,  1.202559,  1.205892,  1.210191,  1.198799,  1.215796,  1.215905,  1.214053,  1.213343,  1.228674,  1.228281,  1.218004,  1.225179,  1.234031,  1.240371,  1.222213,  1.243788,  1.243332,  1.248349,  1.236677, },
{ 1.000000,  1.002438,  1.005147,  1.007271,  1.009578,  1.012377,  1.015156,  1.016516,  1.019359,  1.021944,  1.025677,  1.024885,  1.029923,  1.031737,  1.034733,  1.035879,  1.039648,  1.041634,  1.043286,  1.044961,  1.050080,  1.051922,  1.052177,  1.055151,  1.059527,  1.063435,  1.058010,  1.068173,  1.068575,  1.070679,  1.071766,  1.078131,  1.077918,  1.079503,  1.081367,  1.087100,  1.089679,  1.086934,  1.091931,  1.096554,  1.100280,  1.093821,  1.105225,  1.105789,  1.106091,  1.108294,  1.116126,  1.116318,  1.113229,  1.117166,  1.123677,  1.127933,  1.121488,  1.130735,  1.132051,  1.137538,  1.129078,  1.142874,  1.141776,  1.142599,  1.143386,  1.154310,  1.153516,  1.148207,  1.153147,  1.159687,  1.166915,  1.154250,  1.168591,  1.171161,  1.173607,  1.166227,  1.179189,  1.177965,  1.179383,  1.178369,  1.191392,  1.192899,  1.182313,  1.191433,  1.195942,  1.205457,  1.185989,  1.206542,  1.206006,  1.211252,  1.205005,  1.215052,  1.216569,  1.212912,  1.212417,  1.230158,  1.227303,  1.219964,  1.224528,  1.235547,  1.244987,  1.217381,  1.246623,  1.241819, },
{ 1.000000,  1.002395,  1.005028,  1.007532,  1.010143,  1.012244,  1.014355,  1.017935,  1.020028,  1.021847,  1.024491,  1.028151,  1.030676,  1.030134,  1.035908,  1.037339,  1.039831,  1.041812,  1.045891,  1.047818,  1.048025,  1.051745,  1.055442,  1.058981,  1.057349,  1.062410,  1.065372,  1.068769,  1.066331,  1.073921,  1.074703,  1.076646,  1.077987,  1.085043,  1.085675,  1.084113,  1.088093,  1.093093,  1.097888,  1.091612,  1.101346,  1.103580,  1.105901,  1.103142,  1.112509,  1.111139,  1.114104,  1.114604,  1.123447,  1.123729,  1.119983,  1.126036,  1.131159,  1.135690,  1.125459,  1.140024,  1.139663,  1.144834,  1.140860,  1.149832,  1.149304,  1.149128,  1.150546,  1.161822,  1.160986,  1.157959,  1.161184,  1.169001,  1.177148,  1.157369,  1.181012,  1.175839,  1.180518,  1.178932,  1.189902,  1.185362,  1.186744,  1.186527,  1.199481,  1.199358,  1.194067,  1.198750,  1.207130,  1.212709,  1.195185,  1.216691,  1.215182,  1.215899,  1.217400,  1.228120,  1.225646,  1.219820,  1.225430,  1.235164,  1.238799,  1.227965,  1.238145,  1.244026,  1.249454,  1.234727, },
{ 1.000000,  1.002763,  1.005031,  1.007675,  1.010162,  1.013816,  1.015639,  1.017455,  1.020758,  1.023439,  1.026693,  1.027235,  1.031295,  1.034120,  1.037029,  1.037502,  1.042726,  1.043947,  1.046427,  1.048474,  1.053582,  1.055765,  1.054802,  1.059000,  1.063564,  1.066567,  1.063209,  1.071487,  1.073206,  1.077295,  1.075473,  1.082292,  1.082958,  1.084312,  1.086370,  1.094425,  1.093938,  1.093665,  1.097424,  1.102410,  1.108239,  1.098300,  1.112882,  1.111124,  1.115210,  1.115197,  1.122574,  1.121453,  1.122705,  1.124725,  1.133445,  1.133960,  1.132226,  1.135724,  1.142972,  1.147773,  1.135013,  1.151403,  1.152097,  1.153105,  1.153038,  1.163788,  1.162043,  1.159102,  1.163514,  1.170825,  1.175608,  1.167443,  1.176117,  1.182599,  1.186507,  1.174988,  1.193392,  1.187451,  1.191867,  1.189837,  1.204978,  1.203553,  1.194391,  1.203624,  1.210781,  1.217517,  1.202437,  1.218090,  1.221517,  1.223736,  1.214548,  1.232067,  1.228013,  1.228487,  1.231073,  1.242474,  1.244781,  1.231226,  1.241981,  1.250939,  1.254687,  1.236473,  1.259231,  1.260218, },
{ 1.000000,  1.002715,  1.004787,  1.007798,  1.010244,  1.012349,  1.014961,  1.018524,  1.020481,  1.022196,  1.025122,  1.027966,  1.031782,  1.030728,  1.036387,  1.038194,  1.041136,  1.042532,  1.046925,  1.048016,  1.049713,  1.052471,  1.057810,  1.058862,  1.059953,  1.062231,  1.067018,  1.071428,  1.065641,  1.075456,  1.077358,  1.078725,  1.080171,  1.086436,  1.087075,  1.086307,  1.090535,  1.095467,  1.097975,  1.096136,  1.100814,  1.105869,  1.109445,  1.104308,  1.115083,  1.113573,  1.116066,  1.117581,  1.126337,  1.126653,  1.121748,  1.128091,  1.134069,  1.139208,  1.130362,  1.140747,  1.144852,  1.145607,  1.142340,  1.153621,  1.152398,  1.152985,  1.155132,  1.164845,  1.166477,  1.157864,  1.165665,  1.173337,  1.176993,  1.164401,  1.181780,  1.182445,  1.187213,  1.179456,  1.191384,  1.190498,  1.190768,  1.190730,  1.206138,  1.203080,  1.197207,  1.204035,  1.208467,  1.218789,  1.198511,  1.222302,  1.219290,  1.224214,  1.219500,  1.231811,  1.227415,  1.227140,  1.229895,  1.242816,  1.242308,  1.237074,  1.238087,  1.252317,  1.257124,  1.232186, },
{ 1.000000,  1.002678,  1.005461,  1.007489,  1.010034,  1.013248,  1.015598,  1.017198,  1.020096,  1.023377,  1.026180,  1.026929,  1.030177,  1.033747,  1.036618,  1.036319,  1.041752,  1.043250,  1.045256,  1.047826,  1.052503,  1.054513,  1.054294,  1.057626,  1.061762,  1.065798,  1.063641,  1.069133,  1.072146,  1.074488,  1.073618,  1.081397,  1.081588,  1.082421,  1.085614,  1.092183,  1.093806,  1.090183,  1.095591,  1.101118,  1.104491,  1.098460,  1.109347,  1.111179,  1.114061,  1.110746,  1.119312,  1.119762,  1.120661,  1.121921,  1.132244,  1.131827,  1.128279,  1.134102,  1.138052,  1.145733,  1.133475,  1.148957,  1.148715,  1.151561,  1.151147,  1.158370,  1.157572,  1.157539,  1.160087,  1.170148,  1.170515,  1.167299,  1.169710,  1.178954,  1.185540,  1.166849,  1.188543,  1.188185,  1.188551,  1.188447,  1.199368,  1.196247,  1.195041,  1.197621,  1.208345,  1.211991,  1.201379,  1.209029,  1.217447,  1.221784,  1.207927,  1.227699,  1.224860,  1.223015,  1.227966,  1.238593,  1.238269,  1.229514,  1.235475,  1.245161,  1.251616,  1.238558,  1.250868,  1.254420, },
{ 1.000000,  1.002608,  1.005100,  1.008081,  1.010542,  1.012758,  1.015028,  1.018495,  1.020758,  1.022235,  1.025357,  1.028602,  1.031729,  1.031856,  1.036802,  1.039010,  1.042018,  1.042684,  1.047053,  1.048770,  1.050580,  1.053184,  1.058511,  1.059978,  1.059878,  1.063744,  1.067496,  1.072335,  1.067347,  1.075745,  1.077567,  1.080315,  1.081470,  1.085964,  1.088342,  1.088441,  1.090132,  1.098205,  1.099563,  1.097976,  1.100978,  1.107338,  1.112635,  1.101510,  1.116853,  1.116718,  1.117759,  1.119600,  1.127311,  1.126192,  1.126711,  1.129350,  1.136393,  1.139287,  1.134365,  1.139448,  1.146267,  1.150586,  1.140732,  1.155915,  1.155903,  1.154491,  1.158735,  1.167670,  1.167001,  1.161053,  1.166789,  1.174719,  1.179747,  1.171703,  1.181583,  1.182695,  1.189615,  1.179471,  1.196036,  1.193234,  1.192292,  1.196108,  1.207847,  1.206211,  1.198480,  1.205332,  1.211975,  1.221600,  1.205848,  1.221402,  1.224607,  1.227012,  1.219465,  1.233245,  1.231064,  1.231711,  1.232167,  1.247398,  1.248068,  1.235036,  1.245338,  1.250332,  1.261940,  1.238387, },
{ 1.000000,  1.002573,  1.005253,  1.007378,  1.009704,  1.012667,  1.015162,  1.016723,  1.019235,  1.023202,  1.025096,  1.026387,  1.028832,  1.032721,  1.036210,  1.034594,  1.040599,  1.042027,  1.044536,  1.046951,  1.050817,  1.051782,  1.053787,  1.055468,  1.060764,  1.062838,  1.062517,  1.065835,  1.070692,  1.073491,  1.069806,  1.078701,  1.079945,  1.080577,  1.083807,  1.088813,  1.090259,  1.088447,  1.092839,  1.097968,  1.101577,  1.098270,  1.103865,  1.107106,  1.111230,  1.106510,  1.116358,  1.116874,  1.116932,  1.119788,  1.127800,  1.128130,  1.123835,  1.129045,  1.135093,  1.140709,  1.131749,  1.142421,  1.145752,  1.147899,  1.143848,  1.155119,  1.152345,  1.155006,  1.155083,  1.166527,  1.166070,  1.160446,  1.166239,  1.172506,  1.178177,  1.165603,  1.180788,  1.181412,  1.185834,  1.182574,  1.192058,  1.190784,  1.189225,  1.191189,  1.204788,  1.202158,  1.198462,  1.200756,  1.210573,  1.220406,  1.195960,  1.223144,  1.217572,  1.220382,  1.221537,  1.231055,  1.226359,  1.226997,  1.226436,  1.241792,  1.240726,  1.235430,  1.237637,  1.248377, },
{ 1.000000,  1.002573,  1.004842,  1.007342,  1.009794,  1.012211,  1.014821,  1.017811,  1.020080,  1.021225,  1.024192,  1.027459,  1.030246,  1.031276,  1.034321,  1.037258,  1.040169,  1.040108,  1.045462,  1.047176,  1.048744,  1.050538,  1.056313,  1.057675,  1.056793,  1.061006,  1.065001,  1.068594,  1.065817,  1.071908,  1.075123,  1.077816,  1.076094,  1.083418,  1.083609,  1.084954,  1.087719,  1.094270,  1.095880,  1.092181,  1.097035,  1.102955,  1.106259,  1.100177,  1.109634,  1.111942,  1.115571,  1.112884,  1.121014,  1.120995,  1.120892,  1.123100,  1.132982,  1.131840,  1.130409,  1.133081,  1.139131,  1.146586,  1.132497,  1.149786,  1.148343,  1.150668,  1.151581,  1.158376,  1.157795,  1.157510,  1.159407,  1.170017,  1.169871,  1.166758,  1.168730,  1.178701,  1.184143,  1.167068,  1.185997,  1.188087,  1.185299,  1.187981,  1.198256,  1.197039,  1.190728,  1.196769,  1.204479,  1.209726,  1.200814,  1.207425,  1.215664,  1.219830,  1.206896,  1.226587,  1.220367,  1.222052,  1.221975,  1.237424,  1.237035,  1.224483,  1.234619,  1.242126,  1.250332,  1.233406, },
{ 1.000000,  1.002466,  1.005150,  1.007190,  1.009153,  1.012441,  1.014654,  1.016769,  1.019322,  1.022225,  1.024793,  1.025488,  1.028787,  1.032187,  1.034848,  1.034198,  1.039131,  1.041838,  1.044778,  1.044492,  1.049771,  1.050933,  1.052103,  1.054832,  1.060396,  1.061796,  1.061385,  1.063854,  1.068322,  1.073681,  1.067679,  1.076977,  1.078180,  1.079972,  1.081646,  1.086978,  1.087023,  1.088182,  1.090559,  1.097200,  1.098202,  1.098272,  1.098833,  1.106342,  1.111512,  1.100231,  1.114011,  1.116575,  1.115566,  1.117491,  1.124362,  1.125036,  1.122387,  1.127214,  1.132840,  1.135465,  1.132387,  1.135816,  1.143300,  1.147524,  1.138738,  1.151735,  1.150032,  1.150591,  1.153263,  1.163216,  1.163751,  1.155737,  1.162347,  1.169580,  1.175954,  1.164587,  1.174435,  1.180317,  1.181020,  1.175485,  1.188776,  1.187866,  1.185676,  1.188799,  1.199760,  1.201722,  1.190849,  1.198038,  1.207197,  1.211303,  1.196542,  1.214100,  1.216890,  1.221532,  1.210789,  1.224235,  1.224419,  1.221771,  1.222557,  1.240051,  1.235288,  1.229677,  1.234093,  1.239939, },
{ 1.000000,  1.002518,  1.004646,  1.007100,  1.009444,  1.012079,  1.014103,  1.016650,  1.018838,  1.020905,  1.023265,  1.026753,  1.028689,  1.030242,  1.031961,  1.036412,  1.039543,  1.036836,  1.043423,  1.045764,  1.047230,  1.049077,  1.053149,  1.054823,  1.055529,  1.058415,  1.062125,  1.065250,  1.064335,  1.067305,  1.072301,  1.075317,  1.071982,  1.079886,  1.080719,  1.080995,  1.084489,  1.090039,  1.091705,  1.089309,  1.092980,  1.097836,  1.102769,  1.098338,  1.103687,  1.107512,  1.110519,  1.106669,  1.116829,  1.116198,  1.115485,  1.119174,  1.126742,  1.128811,  1.122600,  1.127530,  1.134466,  1.138685,  1.130157,  1.141618,  1.143574,  1.148044,  1.141618,  1.151213,  1.151381,  1.151830,  1.152373,  1.164858,  1.163060,  1.158683,  1.163498,  1.168290,  1.178040,  1.161088,  1.178649,  1.178995,  1.181404,  1.180030,  1.187358,  1.186971,  1.185829,  1.187961,  1.198706,  1.199520,  1.195725,  1.195485,  1.207494,  1.215132,  1.191585,  1.215199,  1.215961,  1.215413,  1.214513,  1.225440,  1.222910,  1.221044,  1.222562,  1.233901,  1.238204,  1.227324, },
{ 1.000000,  1.002325,  1.004936,  1.007010,  1.008699,  1.011989,  1.014127,  1.015692,  1.018448,  1.021426,  1.023651,  1.024868,  1.027130,  1.030395,  1.033312,  1.034006,  1.037244,  1.039386,  1.042687,  1.042188,  1.047759,  1.048949,  1.050071,  1.052257,  1.057891,  1.059203,  1.058042,  1.061411,  1.065838,  1.069290,  1.066031,  1.072890,  1.074658,  1.078393,  1.076398,  1.082573,  1.083486,  1.084731,  1.086628,  1.093891,  1.093849,  1.092719,  1.095733,  1.100682,  1.106050,  1.096951,  1.108505,  1.110011,  1.112782,  1.112456,  1.116984,  1.119578,  1.118834,  1.119192,  1.128819,  1.129479,  1.127487,  1.128861,  1.136888,  1.143221,  1.127299,  1.145811,  1.145387,  1.145671,  1.146292,  1.155104,  1.153266,  1.153114,  1.154654,  1.163245,  1.165775,  1.160677,  1.163679,  1.171614,  1.176958,  1.163576,  1.181003,  1.179970,  1.178353,  1.181769,  1.191803,  1.190648,  1.183859,  1.188253,  1.197740,  1.201823,  1.194294,  1.202679,  1.203298,  1.212493,  1.198578,  1.217074,  1.213423,  1.212695,  1.215430,  1.228005,  1.225731,  1.217887,  1.222537,  1.230962, },
{ 1.000000,  1.002420,  1.004571,  1.007186,  1.009132,  1.011750,  1.013359,  1.016438,  1.018406,  1.020851,  1.022248,  1.026049,  1.028314,  1.029039,  1.031795,  1.034687,  1.038183,  1.036379,  1.041892,  1.044111,  1.046952,  1.047756,  1.051005,  1.053300,  1.054236,  1.055646,  1.062347,  1.062872,  1.063053,  1.064638,  1.070183,  1.074770,  1.067887,  1.078202,  1.078219,  1.080501,  1.082185,  1.087343,  1.087185,  1.089424,  1.088678,  1.096674,  1.098137,  1.096838,  1.099188,  1.105265,  1.108986,  1.100824,  1.113139,  1.113732,  1.114332,  1.116417,  1.122619,  1.123237,  1.120115,  1.124314,  1.130914,  1.133951,  1.129689,  1.135385,  1.138496,  1.144237,  1.135563,  1.148631,  1.147314,  1.147881,  1.149171,  1.158847,  1.159033,  1.153507,  1.157086,  1.165194,  1.171631,  1.159674,  1.171690,  1.175021,  1.178038,  1.170774,  1.184500,  1.179865,  1.183840,  1.181469,  1.195010,  1.193949,  1.187785,  1.191926,  1.200428,  1.206672,  1.189484,  1.207594,  1.208345,  1.213379,  1.207070,  1.218511,  1.216475,  1.214965,  1.214734,  1.230363,  1.227517,  1.224535, },
{ 1.000000,  1.002234,  1.004791,  1.007702,  1.008942,  1.012470,  1.014330,  1.016707,  1.019266,  1.022355,  1.023955,  1.026273,  1.027709,  1.032017,  1.034208,  1.035817,  1.037460,  1.041205,  1.044832,  1.042846,  1.049207,  1.050918,  1.052602,  1.055027,  1.059515,  1.060857,  1.060848,  1.063597,  1.068314,  1.071036,  1.071033,  1.073656,  1.077400,  1.081544,  1.078043,  1.086466,  1.086514,  1.088394,  1.089377,  1.097241,  1.097948,  1.095521,  1.098960,  1.104441,  1.109639,  1.103688,  1.111182,  1.114304,  1.118179,  1.113116,  1.123256,  1.122023,  1.124265,  1.125365,  1.133636,  1.135243,  1.130766,  1.134188,  1.142000,  1.146144,  1.135697,  1.148623,  1.150389,  1.155504,  1.149795,  1.159382,  1.158532,  1.159662,  1.159305,  1.172023,  1.169212,  1.168996,  1.168483,  1.177019,  1.187027,  1.166132,  1.187747,  1.185354,  1.188766,  1.188623,  1.195951,  1.194359,  1.196087,  1.193782,  1.207763,  1.206687,  1.204745,  1.204021,  1.215147,  1.223583,  1.200564,  1.222735,  1.224454,  1.222902,  1.223259,  1.235227,  1.233181,  1.227902,  1.230951,  1.240561, },
{ 1.000000,  1.002325,  1.004571,  1.006840,  1.009301,  1.011578,  1.012762,  1.016190,  1.017686,  1.020437,  1.022029,  1.025778,  1.027696,  1.028655,  1.031242,  1.034025,  1.037529,  1.036854,  1.040677,  1.043260,  1.046230,  1.045749,  1.051034,  1.051766,  1.054210,  1.055508,  1.059878,  1.062538,  1.061349,  1.063950,  1.068846,  1.072143,  1.068219,  1.075462,  1.077359,  1.081656,  1.078104,  1.085381,  1.085763,  1.086961,  1.088435,  1.096198,  1.096227,  1.096365,  1.096212,  1.102007,  1.109486,  1.098246,  1.110831,  1.111131,  1.113897,  1.114326,  1.120409,  1.118588,  1.121220,  1.121049,  1.130041,  1.130302,  1.130807,  1.128578,  1.137247,  1.145534,  1.128430,  1.145330,  1.147082,  1.146552,  1.147650,  1.155232,  1.154637,  1.153195,  1.155504,  1.162826,  1.165060,  1.162465,  1.163458,  1.171465,  1.178152,  1.165459,  1.180818,  1.176589,  1.180624,  1.180150,  1.191587,  1.191256,  1.183824,  1.187313,  1.196255,  1.204649,  1.190779,  1.201077,  1.206163,  1.208556,  1.201129,  1.214941,  1.211623,  1.213513,  1.212895,  1.225208,  1.226978,  1.217099, },
{ 1.000000,  1.002185,  1.004657,  1.006632,  1.008147,  1.011201,  1.013331,  1.016059,  1.017137,  1.019997,  1.021870,  1.024049,  1.025730,  1.029944,  1.031235,  1.032708,  1.034319,  1.037184,  1.041741,  1.039046,  1.045278,  1.046213,  1.049404,  1.049853,  1.053951,  1.054870,  1.056878,  1.057900,  1.063101,  1.065008,  1.066102,  1.065856,  1.071475,  1.076054,  1.068742,  1.078662,  1.080449,  1.081895,  1.083108,  1.087657,  1.088594,  1.089358,  1.090528,  1.096188,  1.098794,  1.097243,  1.098980,  1.104777,  1.109815,  1.102533,  1.112569,  1.111643,  1.113720,  1.116049,  1.122074,  1.123254,  1.120728,  1.122517,  1.128675,  1.134930,  1.128712,  1.133365,  1.137076,  1.141627,  1.135485,  1.147248,  1.144991,  1.146048,  1.147706,  1.155905,  1.158140,  1.152526,  1.154464,  1.162326,  1.168593,  1.156873,  1.170284,  1.170268,  1.177674,  1.167794,  1.179013,  1.177548,  1.180440,  1.177777,  1.191913,  1.189340,  1.186966,  1.187921,  1.193750,  1.206310,  1.184928,  1.204921,  1.203118,  1.208036,  1.205222,  1.212558,  1.210200,  1.212871,  1.210078,  1.223347, },
{ 1.000000,  1.002238,  1.004522,  1.006108,  1.008614,  1.011459,  1.011992,  1.015518,  1.017304,  1.019551,  1.021369,  1.024281,  1.025615,  1.027808,  1.029282,  1.032939,  1.035588,  1.035767,  1.037786,  1.041121,  1.044812,  1.042969,  1.048318,  1.049326,  1.051319,  1.053819,  1.057527,  1.058945,  1.059320,  1.060891,  1.065124,  1.068677,  1.067495,  1.070635,  1.073155,  1.077824,  1.074049,  1.081728,  1.081967,  1.083613,  1.084627,  1.091067,  1.091849,  1.090562,  1.092403,  1.097921,  1.102571,  1.096674,  1.104791,  1.105366,  1.111096,  1.106240,  1.114157,  1.113861,  1.115993,  1.116039,  1.124547,  1.124004,  1.123548,  1.124145,  1.129500,  1.137758,  1.124384,  1.137788,  1.138332,  1.142595,  1.141330,  1.145419,  1.147401,  1.147985,  1.145111,  1.157016,  1.157583,  1.156144,  1.154189,  1.163537,  1.173205,  1.151278,  1.172753,  1.170708,  1.172920,  1.172951,  1.181358,  1.178286,  1.180508,  1.178659,  1.188339,  1.191601,  1.186956,  1.187037,  1.195252,  1.204235,  1.186151,  1.204773,  1.202863,  1.203774,  1.205446,  1.215763,  1.213574,  1.208731, },
{ 1.000000,  1.002107,  1.004486,  1.006394,  1.008235,  1.010701,  1.012680,  1.015616,  1.016349,  1.019584,  1.021043,  1.023397,  1.025382,  1.028666,  1.030435,  1.031300,  1.033088,  1.036175,  1.040243,  1.039040,  1.043059,  1.044756,  1.048436,  1.047569,  1.052069,  1.053028,  1.056076,  1.055978,  1.061531,  1.063384,  1.062999,  1.064833,  1.068140,  1.074143,  1.067792,  1.075547,  1.076880,  1.081334,  1.080493,  1.083638,  1.085727,  1.087173,  1.086460,  1.095173,  1.095143,  1.095423,  1.094493,  1.101409,  1.109116,  1.096383,  1.109539,  1.108321,  1.111990,  1.113156,  1.118067,  1.116765,  1.120419,  1.116744,  1.126534,  1.128547,  1.126739,  1.127077,  1.133061,  1.140592,  1.127515,  1.141839,  1.141167,  1.143535,  1.144728,  1.150612,  1.150678,  1.148867,  1.150315,  1.157452,  1.161980,  1.157222,  1.161497,  1.163765,  1.173260,  1.160693,  1.174506,  1.171797,  1.175586,  1.174740,  1.183839,  1.184653,  1.179386,  1.180329,  1.188918,  1.198815,  1.184343,  1.195425,  1.197018,  1.204533,  1.194259,  1.208247,  1.201686,  1.209548,  1.203627,  1.217460, },
{ 1.000000,  1.002158,  1.004295,  1.006293,  1.008223,  1.010943,  1.011779,  1.014782,  1.016800,  1.019637,  1.020310,  1.023242,  1.025060,  1.027146,  1.028392,  1.032199,  1.033743,  1.035457,  1.035970,  1.040155,  1.044701,  1.040131,  1.047251,  1.047646,  1.050746,  1.052108,  1.055581,  1.055991,  1.058810,  1.058035,  1.064129,  1.065773,  1.066876,  1.066739,  1.071130,  1.076940,  1.069866,  1.078485,  1.079753,  1.082101,  1.083147,  1.087405,  1.088404,  1.088393,  1.089592,  1.094965,  1.098377,  1.096953,  1.098231,  1.102521,  1.108737,  1.101666,  1.111172,  1.109800,  1.113282,  1.112243,  1.120689,  1.121223,  1.118573,  1.119587,  1.125689,  1.133461,  1.124463,  1.131423,  1.134471,  1.140386,  1.132030,  1.143150,  1.140519,  1.144936,  1.143450,  1.151436,  1.154122,  1.149811,  1.149823,  1.158320,  1.165760,  1.151561,  1.163653,  1.165506,  1.172942,  1.164895,  1.174218,  1.172015,  1.175649,  1.172050,  1.184924,  1.183474,  1.184544,  1.178727,  1.188758,  1.202191,  1.176374,  1.198848,  1.195266,  1.201835,  1.198863,  1.205588,  1.203326,  1.208279, },
{ 1.000000,  1.001993,  1.004376,  1.006425,  1.008404,  1.010066,  1.012827,  1.015612,  1.015470,  1.019179,  1.021281,  1.023240,  1.024876,  1.028460,  1.029941,  1.031523,  1.033053,  1.036299,  1.039120,  1.039790,  1.041526,  1.044922,  1.048714,  1.046033,  1.052308,  1.051926,  1.055367,  1.055611,  1.061141,  1.062669,  1.061713,  1.063861,  1.068119,  1.073148,  1.069296,  1.073542,  1.076481,  1.080434,  1.077216,  1.084715,  1.084166,  1.086941,  1.087448,  1.092641,  1.095855,  1.093202,  1.094226,  1.100551,  1.105580,  1.097870,  1.106410,  1.108287,  1.114989,  1.107378,  1.116768,  1.115853,  1.117398,  1.117456,  1.126630,  1.126355,  1.126906,  1.123769,  1.131773,  1.142306,  1.124892,  1.140390,  1.139440,  1.143834,  1.142714,  1.149608,  1.145780,  1.150581,  1.147832,  1.158420,  1.159050,  1.159794,  1.153280,  1.164428,  1.176366,  1.151913,  1.171929,  1.174124,  1.173939,  1.173814,  1.181878,  1.180473,  1.179653,  1.180161,  1.188522,  1.191568,  1.189366,  1.186804,  1.196689,  1.206108,  1.188580,  1.205916,  1.200409,  1.205664,  1.204020,  1.216006, },
{ 1.000000,  1.002058,  1.004069,  1.005963,  1.008631,  1.011153,  1.012136,  1.014486,  1.016946,  1.019282,  1.019979,  1.023423,  1.025043,  1.027525,  1.028700,  1.032112,  1.034287,  1.034923,  1.036051,  1.040087,  1.043950,  1.041497,  1.046523,  1.048177,  1.052711,  1.050142,  1.055110,  1.056458,  1.058866,  1.058546,  1.065358,  1.065672,  1.067052,  1.066498,  1.070532,  1.078356,  1.069674,  1.078991,  1.079411,  1.084112,  1.082119,  1.087265,  1.086650,  1.090520,  1.089387,  1.096342,  1.098505,  1.098999,  1.095169,  1.104183,  1.111651,  1.097248,  1.110386,  1.112217,  1.114459,  1.114254,  1.119212,  1.119506,  1.121374,  1.119811,  1.127419,  1.131188,  1.127869,  1.127184,  1.135413,  1.142781,  1.130846,  1.142980,  1.141612,  1.143996,  1.145285,  1.152038,  1.153603,  1.150801,  1.149825,  1.157907,  1.166852,  1.157366,  1.160196,  1.166099,  1.172653,  1.161845,  1.176059,  1.172985,  1.175195,  1.174661,  1.184203,  1.186776,  1.180976,  1.178901,  1.190277,  1.199724,  1.183059,  1.196212,  1.196283,  1.208528,  1.192849,  1.206284,  1.203413,  1.207702, },
{ 1.000000,  1.001888,  1.004199,  1.006366,  1.008328,  1.009959,  1.012288,  1.015613,  1.015343,  1.018971,  1.020546,  1.023646,  1.024595,  1.027185,  1.028687,  1.031194,  1.032073,  1.035899,  1.038182,  1.039561,  1.039511,  1.044224,  1.048885,  1.043194,  1.050508,  1.052261,  1.055088,  1.055067,  1.058830,  1.059897,  1.062979,  1.061688,  1.067353,  1.071183,  1.069600,  1.069380,  1.075102,  1.081110,  1.074179,  1.082425,  1.082584,  1.084943,  1.086340,  1.091089,  1.092715,  1.092593,  1.091577,  1.098284,  1.103813,  1.099565,  1.101971,  1.105767,  1.112560,  1.104168,  1.114314,  1.114295,  1.116477,  1.114867,  1.123844,  1.124822,  1.122903,  1.120934,  1.129719,  1.137431,  1.126816,  1.135233,  1.136131,  1.145772,  1.135426,  1.145138,  1.144734,  1.147360,  1.145092,  1.156179,  1.156019,  1.155083,  1.151360,  1.160182,  1.172520,  1.151622,  1.167829,  1.167467,  1.175557,  1.170074,  1.174661,  1.177052,  1.179423,  1.171833,  1.186883,  1.188997,  1.186948,  1.179384,  1.193544,  1.207356,  1.175742,  1.201907,  1.199183,  1.204108,  1.200188,  1.209699, },
{ 1.000000,  1.001914,  1.004017,  1.005896,  1.008326,  1.010440,  1.011897,  1.013666,  1.016415,  1.019357,  1.018746,  1.022982,  1.024443,  1.026448,  1.027984,  1.031576,  1.033151,  1.034169,  1.034785,  1.038968,  1.042369,  1.041992,  1.044107,  1.046179,  1.051313,  1.048054,  1.054158,  1.054352,  1.057328,  1.057696,  1.062844,  1.064000,  1.064302,  1.064051,  1.069155,  1.075422,  1.069881,  1.075049,  1.077698,  1.082600,  1.077829,  1.084478,  1.084884,  1.088297,  1.085921,  1.094374,  1.096156,  1.094623,  1.093563,  1.099511,  1.108566,  1.096350,  1.106328,  1.107172,  1.113980,  1.110084,  1.114047,  1.116490,  1.118059,  1.114267,  1.125954,  1.126515,  1.125805,  1.120892,  1.132476,  1.142180,  1.122073,  1.139373,  1.137235,  1.142524,  1.141256,  1.147381,  1.145207,  1.150739,  1.142607,  1.156323,  1.158892,  1.155142,  1.151528,  1.162773,  1.172081,  1.152005,  1.169996,  1.169000,  1.171911,  1.171261,  1.178199,  1.178442,  1.177044,  1.173830,  1.184944,  1.191473,  1.183734,  1.185426,  1.191077,  1.202484,  1.184240,  1.201240,  1.198090,  1.202692, },
{ 1.000000,  1.001842,  1.004208,  1.006113,  1.007864,  1.009447,  1.012186,  1.014785,  1.015176,  1.018114,  1.020167,  1.022871,  1.022817,  1.026769,  1.027448,  1.030442,  1.030717,  1.035105,  1.036706,  1.037563,  1.038434,  1.042346,  1.046445,  1.042821,  1.048509,  1.049713,  1.054015,  1.052961,  1.056993,  1.057667,  1.059764,  1.059776,  1.065651,  1.067216,  1.068148,  1.066133,  1.072835,  1.079733,  1.068625,  1.080830,  1.078712,  1.083462,  1.083623,  1.087636,  1.086796,  1.091223,  1.087958,  1.096178,  1.097905,  1.098098,  1.095420,  1.102651,  1.110296,  1.097707,  1.109933,  1.109890,  1.113315,  1.113457,  1.118376,  1.118830,  1.118971,  1.117946,  1.125056,  1.129488,  1.126625,  1.126187,  1.132220,  1.140509,  1.129091,  1.141103,  1.138290,  1.143364,  1.139527,  1.150483,  1.151098,  1.147176,  1.146174,  1.154436,  1.164654,  1.151350,  1.159414,  1.162449,  1.171244,  1.157476,  1.172027,  1.167639,  1.173486,  1.169257,  1.180357,  1.182492,  1.178224,  1.174062,  1.186465,  1.195113,  1.176662,  1.190907,  1.191517,  1.202120,  1.190371,  1.201190, },
{ 1.000000,  1.001810,  1.004026,  1.005619,  1.008037,  1.009758,  1.011893,  1.012934,  1.015551,  1.019032,  1.017735,  1.022047,  1.022865,  1.026128,  1.026930,  1.029650,  1.031087,  1.033593,  1.033573,  1.037759,  1.039909,  1.041071,  1.040693,  1.045524,  1.050217,  1.044362,  1.051432,  1.053064,  1.055341,  1.055536,  1.060094,  1.060984,  1.061985,  1.062116,  1.066618,  1.070514,  1.069137,  1.070204,  1.074642,  1.080519,  1.073089,  1.082366,  1.080275,  1.084917,  1.082888,  1.090495,  1.092194,  1.089483,  1.090499,  1.096145,  1.103154,  1.096150,  1.100412,  1.103755,  1.109222,  1.102193,  1.111917,  1.110018,  1.114045,  1.112362,  1.118932,  1.122789,  1.119266,  1.117618,  1.126396,  1.132623,  1.121272,  1.131012,  1.132586,  1.142527,  1.130208,  1.141141,  1.139843,  1.141465,  1.139532,  1.151571,  1.151197,  1.150731,  1.144479,  1.154353,  1.168646,  1.143949,  1.163490,  1.160511,  1.167951,  1.163987,  1.171415,  1.166671,  1.173258,  1.167811,  1.179423,  1.181799,  1.181173,  1.170950,  1.184814,  1.200639,  1.168481,  1.192290,  1.193545,  1.195200, },
{ 1.000000,  1.001764,  1.003979,  1.005744,  1.007539,  1.009444,  1.011642,  1.013638,  1.015272,  1.016528,  1.019200,  1.022537,  1.021654,  1.025310,  1.026496,  1.028986,  1.029800,  1.033684,  1.035606,  1.035315,  1.036740,  1.040550,  1.044632,  1.042380,  1.045486,  1.048261,  1.051446,  1.049350,  1.054546,  1.054937,  1.058042,  1.057417,  1.062453,  1.065307,  1.063698,  1.063428,  1.070258,  1.074321,  1.068294,  1.075167,  1.076147,  1.083120,  1.077061,  1.083191,  1.083842,  1.086173,  1.084067,  1.093740,  1.093507,  1.093915,  1.091517,  1.097196,  1.107115,  1.092483,  1.105478,  1.104383,  1.111541,  1.106574,  1.112555,  1.111474,  1.115391,  1.112861,  1.120797,  1.124272,  1.123442,  1.116718,  1.128395,  1.137809,  1.117158,  1.133996,  1.134967,  1.138166,  1.136604,  1.141631,  1.142830,  1.143232,  1.140610,  1.148954,  1.154586,  1.148662,  1.146809,  1.156436,  1.166393,  1.149287,  1.164163,  1.161445,  1.164576,  1.163792,  1.172229,  1.175145,  1.169229,  1.166897,  1.177004,  1.187435,  1.174902,  1.177960,  1.184302,  1.192635,  1.177925,  1.194335, },
{ 1.000000,  1.001722,  1.003803,  1.005392,  1.007546,  1.009792,  1.010985,  1.012244,  1.015230,  1.017613,  1.017654,  1.020709,  1.022179,  1.025596,  1.025029,  1.028196,  1.029571,  1.031865,  1.032127,  1.036735,  1.038242,  1.038827,  1.039435,  1.043033,  1.048164,  1.042761,  1.049306,  1.049695,  1.054095,  1.053278,  1.056328,  1.057239,  1.060070,  1.059190,  1.064367,  1.067351,  1.067467,  1.065119,  1.071718,  1.078807,  1.066981,  1.077240,  1.078335,  1.082351,  1.080470,  1.084992,  1.085669,  1.088111,  1.086034,  1.092889,  1.097024,  1.093430,  1.092420,  1.098677,  1.107224,  1.095766,  1.106374,  1.105596,  1.108446,  1.108158,  1.113956,  1.116945,  1.113969,  1.112133,  1.119955,  1.126871,  1.119962,  1.122948,  1.126081,  1.135258,  1.122558,  1.135451,  1.134297,  1.136636,  1.133200,  1.144364,  1.145475,  1.140930,  1.137585,  1.149048,  1.157308,  1.144223,  1.152722,  1.153044,  1.165507,  1.151644,  1.161878,  1.162447,  1.163574,  1.160468,  1.173293,  1.173615,  1.170441,  1.165640,  1.175407,  1.189898,  1.164793,  1.182605,  1.180888,  1.192554, },
{ 1.000000,  1.001673,  1.003686,  1.005424,  1.007234,  1.008761,  1.011155,  1.012924,  1.014277,  1.015438,  1.018276,  1.021498,  1.019441,  1.024083,  1.024931,  1.027811,  1.028575,  1.031160,  1.032614,  1.034610,  1.034791,  1.038680,  1.041240,  1.041062,  1.041249,  1.045375,  1.050129,  1.045056,  1.051742,  1.052222,  1.054743,  1.055302,  1.059154,  1.061102,  1.060770,  1.060191,  1.065772,  1.069884,  1.067464,  1.069742,  1.070979,  1.078796,  1.071449,  1.079614,  1.078593,  1.082164,  1.081274,  1.087483,  1.088870,  1.086909,  1.085758,  1.092445,  1.100011,  1.091890,  1.096907,  1.099187,  1.106517,  1.098774,  1.105798,  1.106015,  1.109772,  1.105976,  1.115263,  1.117783,  1.114263,  1.112539,  1.118860,  1.129947,  1.114383,  1.124876,  1.124665,  1.134867,  1.128523,  1.131450,  1.134914,  1.135333,  1.130833,  1.144090,  1.144256,  1.142380,  1.136151,  1.148115,  1.161141,  1.135838,  1.155353,  1.150522,  1.159593,  1.156425,  1.161621,  1.160151,  1.165042,  1.156140,  1.170659,  1.172832,  1.168443,  1.164256,  1.174361,  1.187038,  1.162827,  1.182742, },
{ 1.000000,  1.001627,  1.003658,  1.005205,  1.007273,  1.009100,  1.010752,  1.011985,  1.014625,  1.016811,  1.017664,  1.019344,  1.021484,  1.024855,  1.023881,  1.027565,  1.028635,  1.031125,  1.031787,  1.034818,  1.037216,  1.036993,  1.037618,  1.041985,  1.046252,  1.043219,  1.046511,  1.048619,  1.053406,  1.049925,  1.055353,  1.055005,  1.058604,  1.057223,  1.063097,  1.064946,  1.064005,  1.063537,  1.068971,  1.074847,  1.067367,  1.074005,  1.074710,  1.081967,  1.077655,  1.082017,  1.082752,  1.084690,  1.083054,  1.090595,  1.092643,  1.092169,  1.088185,  1.096702,  1.106255,  1.088874,  1.103992,  1.100539,  1.108341,  1.106175,  1.109878,  1.109099,  1.112981,  1.108116,  1.118760,  1.120098,  1.118895,  1.114525,  1.122857,  1.133828,  1.115629,  1.129876,  1.129031,  1.134710,  1.132896,  1.137241,  1.139359,  1.137683,  1.135127,  1.144086,  1.149240,  1.144007,  1.142967,  1.149212,  1.160915,  1.145105,  1.158481,  1.154722,  1.161889,  1.155243,  1.166906,  1.168995,  1.161811,  1.160279,  1.171266,  1.182131,  1.166154,  1.172544,  1.176167,  1.189182, },
{ 1.000000,  1.001795,  1.003533,  1.005294,  1.007363,  1.008585,  1.010995,  1.013060,  1.014360,  1.015387,  1.018388,  1.021036,  1.020331,  1.023346,  1.025094,  1.028609,  1.028153,  1.030877,  1.032096,  1.034464,  1.034707,  1.039172,  1.040439,  1.041738,  1.040964,  1.045205,  1.051095,  1.043997,  1.051452,  1.051096,  1.056509,  1.055443,  1.058096,  1.059212,  1.062318,  1.060371,  1.066631,  1.068612,  1.068535,  1.066357,  1.073003,  1.080027,  1.068591,  1.078173,  1.079199,  1.083111,  1.082062,  1.086161,  1.087620,  1.088178,  1.086947,  1.091993,  1.097679,  1.094040,  1.094002,  1.099694,  1.108198,  1.096401,  1.106858,  1.103704,  1.111280,  1.106093,  1.114374,  1.117896,  1.112341,  1.112593,  1.120187,  1.128846,  1.118423,  1.122196,  1.126449,  1.134480,  1.124259,  1.133551,  1.132297,  1.137279,  1.133996,  1.140360,  1.146027,  1.140426,  1.136637,  1.148843,  1.155365,  1.141096,  1.150298,  1.152254,  1.166914,  1.149921,  1.160193,  1.160615,  1.161438,  1.158442,  1.171823,  1.172002,  1.169884,  1.162259,  1.173019,  1.190644,  1.160867,  1.180173, },
{ 1.000000,  1.001802,  1.003525,  1.005174,  1.007105,  1.008757,  1.010522,  1.011783,  1.014379,  1.016305,  1.017665,  1.017999,  1.021229,  1.025076,  1.021825,  1.026611,  1.028175,  1.030544,  1.031456,  1.033462,  1.035376,  1.036815,  1.037451,  1.040484,  1.043599,  1.043354,  1.043347,  1.047184,  1.052837,  1.047926,  1.053207,  1.053003,  1.057725,  1.056300,  1.060877,  1.063820,  1.061596,  1.061542,  1.067051,  1.073536,  1.067010,  1.070450,  1.074194,  1.078297,  1.073988,  1.079619,  1.079819,  1.083970,  1.081369,  1.087347,  1.091493,  1.087389,  1.085630,  1.094456,  1.100424,  1.090757,  1.098226,  1.098519,  1.109568,  1.099186,  1.105323,  1.106735,  1.109427,  1.105137,  1.116632,  1.116831,  1.115568,  1.112066,  1.117743,  1.131765,  1.111696,  1.125742,  1.123895,  1.135458,  1.127168,  1.131831,  1.132064,  1.136313,  1.131774,  1.140768,  1.145880,  1.142760,  1.134032,  1.147633,  1.160274,  1.132573,  1.151702,  1.152345,  1.159196,  1.155735,  1.158156,  1.161022,  1.161424,  1.157238,  1.165878,  1.174303,  1.164450,  1.161760,  1.172338,  1.186211, },
{ 1.000000,  1.001667,  1.003302,  1.004923,  1.006940,  1.008166,  1.010205,  1.012079,  1.013255,  1.014467,  1.016686,  1.019716,  1.019721,  1.021145,  1.023415,  1.026453,  1.025547,  1.029142,  1.029776,  1.032329,  1.032622,  1.035674,  1.038539,  1.037927,  1.037839,  1.042268,  1.046603,  1.042995,  1.047106,  1.047760,  1.054007,  1.049965,  1.053685,  1.054677,  1.057631,  1.055667,  1.062763,  1.064022,  1.063106,  1.063121,  1.066379,  1.074976,  1.064745,  1.073214,  1.071827,  1.079478,  1.076536,  1.078418,  1.080032,  1.082958,  1.080272,  1.086916,  1.090528,  1.089446,  1.085655,  1.092816,  1.102879,  1.085098,  1.098345,  1.097537,  1.104617,  1.101835,  1.104649,  1.105201,  1.109041,  1.104562,  1.111872,  1.118498,  1.112188,  1.109814,  1.116654,  1.128127,  1.113004,  1.124532,  1.121641,  1.128507,  1.125781,  1.130718,  1.134914,  1.131866,  1.127157,  1.135327,  1.146086,  1.136104,  1.138203,  1.140844,  1.152858,  1.137837,  1.150754,  1.147663,  1.154191,  1.147102,  1.158514,  1.161192,  1.155456,  1.149972,  1.161468,  1.174081,  1.157289,  1.165218, },
{ 1.000000,  1.001667,  1.003385,  1.004679,  1.006604,  1.008268,  1.009834,  1.010993,  1.013589,  1.015339,  1.016369,  1.017227,  1.019394,  1.023391,  1.021128,  1.024928,  1.025673,  1.029821,  1.029398,  1.030922,  1.033254,  1.034990,  1.034005,  1.038755,  1.040942,  1.040948,  1.040582,  1.044525,  1.050803,  1.042023,  1.050732,  1.049729,  1.054536,  1.053883,  1.056712,  1.057148,  1.060366,  1.058514,  1.063026,  1.067092,  1.064947,  1.064071,  1.068670,  1.076337,  1.066859,  1.075349,  1.074392,  1.079625,  1.077478,  1.082334,  1.084455,  1.083850,  1.080473,  1.087174,  1.093812,  1.088993,  1.091214,  1.090925,  1.102202,  1.091557,  1.101177,  1.097588,  1.104753,  1.100863,  1.108045,  1.109669,  1.107410,  1.103539,  1.110840,  1.122549,  1.110937,  1.115637,  1.116684,  1.128034,  1.117101,  1.123788,  1.123567,  1.129684,  1.122225,  1.133749,  1.136851,  1.131798,  1.129046,  1.133553,  1.150526,  1.129845,  1.141620,  1.138586,  1.154511,  1.145311,  1.146171,  1.150902,  1.153314,  1.144040,  1.160145,  1.161094,  1.157063,  1.150021,  1.161491,  1.179357, },
{ 1.000000,  1.001484,  1.003386,  1.004526,  1.006595,  1.007989,  1.009808,  1.010949,  1.013050,  1.013535,  1.016320,  1.018325,  1.018867,  1.019754,  1.022216,  1.025819,  1.023456,  1.027564,  1.028127,  1.031311,  1.031732,  1.033903,  1.035780,  1.036657,  1.036555,  1.039759,  1.043677,  1.042267,  1.044072,  1.045470,  1.050916,  1.046935,  1.052063,  1.051624,  1.055806,  1.054226,  1.058452,  1.061160,  1.059748,  1.058607,  1.063799,  1.070409,  1.064495,  1.068079,  1.069085,  1.076480,  1.070338,  1.076416,  1.074530,  1.080562,  1.076118,  1.083918,  1.085939,  1.083749,  1.082130,  1.087212,  1.096141,  1.084490,  1.093117,  1.091492,  1.102475,  1.095582,  1.099433,  1.100251,  1.103637,  1.098532,  1.107796,  1.110708,  1.108731,  1.104041,  1.111689,  1.124859,  1.102489,  1.120298,  1.113654,  1.125166,  1.121227,  1.124789,  1.122607,  1.129154,  1.120887,  1.132312,  1.135218,  1.132596,  1.127330,  1.134229,  1.148393,  1.127387,  1.142235,  1.139167,  1.148930,  1.144912,  1.149220,  1.150649,  1.150263,  1.144818,  1.153455,  1.161275,  1.154891,  1.152694, },
{ 1.000000,  1.001567,  1.003369,  1.004318,  1.006181,  1.007499,  1.009604,  1.010128,  1.012573,  1.014301,  1.014989,  1.015898,  1.018215,  1.021383,  1.020639,  1.022566,  1.024220,  1.027724,  1.026298,  1.029314,  1.029985,  1.032962,  1.032340,  1.035937,  1.038290,  1.037749,  1.037890,  1.041175,  1.045590,  1.041571,  1.045852,  1.046214,  1.052229,  1.049219,  1.052088,  1.052961,  1.056025,  1.053272,  1.060189,  1.061377,  1.061326,  1.059342,  1.063741,  1.072168,  1.060315,  1.070327,  1.067836,  1.075283,  1.072696,  1.075313,  1.076094,  1.079816,  1.075291,  1.083047,  1.085225,  1.084058,  1.080728,  1.087442,  1.096517,  1.080906,  1.092389,  1.092534,  1.097779,  1.094817,  1.099548,  1.100835,  1.101103,  1.097512,  1.102997,  1.110668,  1.105394,  1.104613,  1.109607,  1.119665,  1.106676,  1.116815,  1.111809,  1.122435,  1.113553,  1.123907,  1.127793,  1.120270,  1.120402,  1.126327,  1.138172,  1.125516,  1.129023,  1.131926,  1.141483,  1.130568,  1.138786,  1.137177,  1.144124,  1.137070,  1.145419,  1.152162,  1.144007,  1.140728,  1.150547,  1.160010, },
{ 1.000000,  1.001435,  1.003055,  1.004262,  1.006369,  1.007000,  1.008970,  1.010458,  1.011801,  1.012481,  1.015410,  1.016987,  1.017865,  1.018378,  1.020399,  1.024442,  1.021319,  1.025588,  1.026152,  1.029383,  1.029264,  1.031369,  1.032212,  1.034820,  1.033849,  1.037966,  1.040129,  1.040255,  1.038773,  1.043242,  1.049098,  1.040343,  1.047958,  1.049226,  1.051861,  1.051411,  1.054039,  1.055722,  1.056615,  1.055553,  1.059414,  1.063274,  1.061884,  1.060704,  1.064973,  1.071687,  1.064356,  1.070512,  1.069149,  1.075435,  1.071445,  1.077804,  1.080786,  1.076528,  1.075680,  1.081786,  1.089518,  1.080910,  1.084337,  1.087997,  1.092416,  1.087290,  1.092365,  1.092199,  1.097717,  1.091939,  1.100334,  1.104584,  1.098513,  1.096152,  1.104747,  1.112283,  1.099694,  1.109110,  1.107459,  1.120662,  1.107823,  1.113810,  1.115050,  1.119268,  1.110444,  1.126243,  1.125660,  1.123028,  1.119537,  1.123554,  1.139513,  1.116549,  1.132541,  1.128950,  1.141629,  1.132211,  1.136780,  1.136631,  1.141808,  1.134219,  1.145566,  1.150506,  1.146210,  1.136905, },
{ 1.000000,  1.001480,  1.003148,  1.003988,  1.006167,  1.007416,  1.009179,  1.010230,  1.012171,  1.013607,  1.014931,  1.015619,  1.017966,  1.020518,  1.020345,  1.021203,  1.023966,  1.026980,  1.025074,  1.029059,  1.029044,  1.031913,  1.031658,  1.035392,  1.037386,  1.036690,  1.036634,  1.040228,  1.044638,  1.041792,  1.043544,  1.046242,  1.049737,  1.046792,  1.052215,  1.051142,  1.054605,  1.052799,  1.058546,  1.061130,  1.058081,  1.057174,  1.063490,  1.068125,  1.061676,  1.068005,  1.067050,  1.075315,  1.068130,  1.073744,  1.073430,  1.077062,  1.072239,  1.083666,  1.083560,  1.080608,  1.080399,  1.084103,  1.094279,  1.079154,  1.091951,  1.087790,  1.097341,  1.092768,  1.095597,  1.096013,  1.099861,  1.094045,  1.104644,  1.107226,  1.104008,  1.099699,  1.109095,  1.118842,  1.096141,  1.114304,  1.111068,  1.119785,  1.114543,  1.119872,  1.118874,  1.122390,  1.116050,  1.125849,  1.132887,  1.123484,  1.121206,  1.129583,  1.140778,  1.122712,  1.137948,  1.132687,  1.140415,  1.134427,  1.144241,  1.146814,  1.142341,  1.135795,  1.146075,  1.157015, },
{ 1.000000,  1.001324,  1.002719,  1.004117,  1.006052,  1.006673,  1.008716,  1.009698,  1.011405,  1.011803,  1.015014,  1.016149,  1.016503,  1.017137,  1.019854,  1.022575,  1.021292,  1.024159,  1.024786,  1.028646,  1.026743,  1.029824,  1.031116,  1.032572,  1.031879,  1.037468,  1.037877,  1.037455,  1.037838,  1.040530,  1.046150,  1.038945,  1.046192,  1.045078,  1.050766,  1.048631,  1.050594,  1.052824,  1.054167,  1.050666,  1.059380,  1.059951,  1.058129,  1.057527,  1.062981,  1.069903,  1.055487,  1.069365,  1.065906,  1.071295,  1.069076,  1.074212,  1.072876,  1.075296,  1.072329,  1.079830,  1.083013,  1.077822,  1.077589,  1.084043,  1.090829,  1.077764,  1.090310,  1.087259,  1.092755,  1.088156,  1.097389,  1.097095,  1.094631,  1.090949,  1.099264,  1.106626,  1.097867,  1.102480,  1.101988,  1.112556,  1.099983,  1.113013,  1.106926,  1.113966,  1.107595,  1.120417,  1.119198,  1.114066,  1.111014,  1.119625,  1.130876,  1.115824,  1.124415,  1.124422,  1.134576,  1.121762,  1.130876,  1.130227,  1.135160,  1.125025,  1.143223,  1.143168,  1.134905,  1.133564, },
{ 1.000000,  1.001282,  1.003135,  1.003722,  1.005597,  1.006547,  1.008832,  1.009399,  1.010836,  1.012367,  1.013817,  1.013888,  1.017386,  1.018311,  1.018671,  1.019212,  1.022010,  1.025704,  1.021288,  1.027064,  1.026189,  1.029683,  1.029620,  1.032299,  1.032399,  1.034659,  1.032966,  1.038344,  1.039966,  1.038252,  1.039061,  1.042663,  1.046887,  1.040001,  1.048104,  1.046541,  1.050569,  1.049149,  1.053857,  1.054230,  1.053706,  1.052596,  1.057326,  1.062558,  1.057253,  1.060637,  1.061840,  1.068101,  1.060916,  1.069149,  1.066554,  1.071282,  1.067745,  1.075113,  1.076821,  1.072323,  1.071653,  1.077350,  1.086209,  1.075370,  1.082084,  1.081926,  1.089901,  1.080908,  1.089659,  1.086357,  1.092011,  1.085615,  1.097958,  1.097915,  1.093038,  1.092044,  1.097646,  1.107742,  1.090553,  1.104703,  1.100068,  1.111875,  1.103241,  1.109372,  1.109051,  1.110706,  1.104609,  1.118339,  1.118803,  1.114239,  1.110230,  1.119706,  1.133476,  1.103740,  1.128647,  1.118696,  1.130921,  1.125405,  1.131953,  1.126506,  1.133554,  1.123203,  1.139574,  1.140429, },
{ 1.000000,  1.001231,  1.002532,  1.003921,  1.005668,  1.005678,  1.008057,  1.008736,  1.010812,  1.011487,  1.013437,  1.014468,  1.015558,  1.015869,  1.018070,  1.020485,  1.020287,  1.021240,  1.022923,  1.026538,  1.024333,  1.028127,  1.027236,  1.031193,  1.029173,  1.034068,  1.035199,  1.033735,  1.034315,  1.037340,  1.042536,  1.037892,  1.041022,  1.042147,  1.047223,  1.042574,  1.047832,  1.046606,  1.050443,  1.047690,  1.054201,  1.055868,  1.053009,  1.052984,  1.056854,  1.063170,  1.054157,  1.061995,  1.059655,  1.068660,  1.062260,  1.066994,  1.066539,  1.070153,  1.065003,  1.075156,  1.074825,  1.073884,  1.070784,  1.075661,  1.087375,  1.068074,  1.083645,  1.077143,  1.088364,  1.082673,  1.086860,  1.085550,  1.090478,  1.083859,  1.094468,  1.095648,  1.092104,  1.088554,  1.096775,  1.107757,  1.084789,  1.102776,  1.098640,  1.106732,  1.100666,  1.109108,  1.107559,  1.107285,  1.102869,  1.109073,  1.118856,  1.109305,  1.110117,  1.114797,  1.126480,  1.108552,  1.124429,  1.113530,  1.128189,  1.114880,  1.130567,  1.131823,  1.122198,  1.122726, },
{ 1.000000,  1.001339,  1.002805,  1.003619,  1.004847,  1.006304,  1.008053,  1.008397,  1.010126,  1.011220,  1.012881,  1.013150,  1.015591,  1.017474,  1.017068,  1.017725,  1.020277,  1.023232,  1.020565,  1.023921,  1.024522,  1.029401,  1.025793,  1.029319,  1.030415,  1.031698,  1.030358,  1.036025,  1.037196,  1.036345,  1.035330,  1.038242,  1.045946,  1.035935,  1.043808,  1.042393,  1.048584,  1.045430,  1.048364,  1.048396,  1.051491,  1.048591,  1.054678,  1.057554,  1.055347,  1.051793,  1.058234,  1.067561,  1.050499,  1.062941,  1.062507,  1.067090,  1.064165,  1.067873,  1.069873,  1.069333,  1.066476,  1.071873,  1.077829,  1.072595,  1.071245,  1.076280,  1.085896,  1.073108,  1.082404,  1.078266,  1.087580,  1.080018,  1.089050,  1.092641,  1.084866,  1.082917,  1.090173,  1.102291,  1.087518,  1.091564,  1.096363,  1.102029,  1.093506,  1.100484,  1.099322,  1.105680,  1.096958,  1.107907,  1.114008,  1.102955,  1.100608,  1.109907,  1.121512,  1.101270,  1.115470,  1.110763,  1.128335,  1.110097,  1.117936,  1.119702,  1.123031,  1.111916,  1.132010,  1.130351, },
{ 1.000000,  1.001263,  1.002232,  1.003478,  1.005530,  1.005283,  1.007322,  1.008211,  1.010550,  1.010406,  1.012047,  1.013329,  1.014647,  1.014568,  1.017536,  1.019488,  1.019262,  1.018404,  1.022386,  1.025751,  1.020089,  1.025554,  1.026524,  1.029359,  1.028383,  1.030462,  1.032326,  1.032681,  1.031388,  1.035070,  1.039452,  1.035987,  1.035481,  1.040168,  1.045212,  1.038575,  1.043855,  1.043751,  1.047575,  1.044938,  1.049610,  1.052948,  1.049825,  1.047721,  1.052542,  1.060376,  1.052750,  1.053931,  1.057999,  1.062898,  1.056391,  1.062744,  1.062126,  1.065814,  1.061155,  1.068787,  1.073343,  1.066177,  1.063972,  1.071351,  1.079988,  1.067507,  1.075063,  1.074022,  1.085267,  1.073566,  1.079150,  1.081378,  1.083461,  1.075598,  1.090551,  1.090856,  1.084986,  1.083072,  1.087233,  1.102892,  1.079975,  1.094299,  1.090443,  1.102928,  1.094997,  1.095895,  1.099851,  1.102204,  1.093005,  1.106413,  1.111278,  1.104806,  1.096719,  1.109000,  1.123226,  1.092000,  1.111504,  1.110810,  1.121224,  1.111427,  1.116671,  1.119201,  1.120526,  1.109893, },
{ 1.000000,  1.001201,  1.002561,  1.003368,  1.004302,  1.005842,  1.007782,  1.007345,  1.009550,  1.010326,  1.012228,  1.012170,  1.014627,  1.016167,  1.016247,  1.015945,  1.018503,  1.022140,  1.019979,  1.021454,  1.023117,  1.026574,  1.023494,  1.027634,  1.027986,  1.030326,  1.028037,  1.033434,  1.035175,  1.032680,  1.032032,  1.036130,  1.041907,  1.035474,  1.039525,  1.039664,  1.046620,  1.040373,  1.044305,  1.046785,  1.046981,  1.044347,  1.052515,  1.053657,  1.050406,  1.049295,  1.052762,  1.062643,  1.048279,  1.058186,  1.056631,  1.064714,  1.059443,  1.060647,  1.065578,  1.065398,  1.058660,  1.070433,  1.072577,  1.067716,  1.064681,  1.072367,  1.083427,  1.060012,  1.077645,  1.074454,  1.081537,  1.075604,  1.081670,  1.081580,  1.083406,  1.076627,  1.086419,  1.092928,  1.083482,  1.080563,  1.090116,  1.099790,  1.079612,  1.094642,  1.092649,  1.099621,  1.090211,  1.102179,  1.103553,  1.098410,  1.091271,  1.100963,  1.114382,  1.099084,  1.103034,  1.102772,  1.118331,  1.098767,  1.113699,  1.108764,  1.117001,  1.107015,  1.120746,  1.122835, },
{ 1.000000,  1.001051,  1.001924,  1.003015,  1.004757,  1.004832,  1.006251,  1.007206,  1.009165,  1.008692,  1.010419,  1.011919,  1.012782,  1.012310,  1.015684,  1.017192,  1.016175,  1.016553,  1.018269,  1.023017,  1.018023,  1.022250,  1.022199,  1.026542,  1.024206,  1.025824,  1.028407,  1.028455,  1.026019,  1.032945,  1.033329,  1.031841,  1.030339,  1.035039,  1.041532,  1.029932,  1.039249,  1.037647,  1.042353,  1.039443,  1.043005,  1.043485,  1.045414,  1.040195,  1.048208,  1.051136,  1.046574,  1.045427,  1.051199,  1.056978,  1.044644,  1.054894,  1.054155,  1.058242,  1.053856,  1.060330,  1.061771,  1.059105,  1.054994,  1.061592,  1.069855,  1.060616,  1.062905,  1.065077,  1.073168,  1.061346,  1.071092,  1.069954,  1.074154,  1.067486,  1.076804,  1.080208,  1.072270,  1.069405,  1.076673,  1.090268,  1.073035,  1.079606,  1.080664,  1.090889,  1.076507,  1.086580,  1.086088,  1.089435,  1.080065,  1.095354,  1.097032,  1.087798,  1.085259,  1.092536,  1.106957,  1.082193,  1.097927,  1.094670,  1.108068,  1.094083,  1.101511,  1.105009,  1.103059,  1.093751, },
{ 1.000000,  1.001081,  1.002099,  1.002948,  1.003642,  1.005040,  1.007025,  1.005543,  1.008332,  1.008509,  1.010486,  1.010645,  1.012179,  1.012738,  1.014254,  1.013316,  1.016838,  1.018084,  1.017379,  1.017210,  1.020140,  1.023277,  1.018256,  1.023434,  1.023519,  1.025873,  1.024789,  1.027965,  1.028922,  1.028381,  1.027096,  1.030890,  1.034736,  1.031425,  1.031475,  1.034864,  1.038829,  1.033265,  1.038918,  1.037993,  1.041102,  1.037330,  1.044534,  1.045693,  1.041262,  1.040840,  1.045289,  1.053188,  1.043622,  1.047357,  1.049574,  1.055089,  1.046761,  1.053806,  1.053600,  1.055127,  1.051156,  1.060085,  1.062429,  1.055688,  1.054809,  1.060881,  1.068793,  1.054085,  1.064515,  1.062353,  1.071746,  1.062479,  1.068210,  1.069492,  1.069637,  1.063193,  1.077545,  1.076312,  1.072479,  1.068182,  1.074861,  1.089105,  1.062293,  1.082188,  1.075702,  1.086138,  1.078892,  1.083585,  1.083350,  1.086198,  1.077256,  1.091806,  1.093133,  1.085998,  1.080717,  1.092585,  1.104158,  1.074075,  1.095751,  1.094699,  1.098581,  1.091838,  1.102451,  1.101901, },
{ 1.000000,  1.000905,  1.001628,  1.002860,  1.004169,  1.004344,  1.005219,  1.006754,  1.008295,  1.007252,  1.009769,  1.009966,  1.011620,  1.011001,  1.014032,  1.015329,  1.013962,  1.014661,  1.016937,  1.020298,  1.016853,  1.018949,  1.020896,  1.023117,  1.020189,  1.023748,  1.024993,  1.025237,  1.024341,  1.028332,  1.031166,  1.026877,  1.027160,  1.031716,  1.035373,  1.027594,  1.034316,  1.034234,  1.039578,  1.032661,  1.037992,  1.039966,  1.037908,  1.036111,  1.045228,  1.045463,  1.041579,  1.040176,  1.044427,  1.053823,  1.036783,  1.049677,  1.047697,  1.052923,  1.048524,  1.052075,  1.052657,  1.053329,  1.049217,  1.059043,  1.060895,  1.055677,  1.051243,  1.060736,  1.069720,  1.045584,  1.063827,  1.064969,  1.064700,  1.062060,  1.068042,  1.069466,  1.065718,  1.062344,  1.070410,  1.076788,  1.067079,  1.066558,  1.074218,  1.082036,  1.064984,  1.078384,  1.075353,  1.080065,  1.072564,  1.085173,  1.088096,  1.076124,  1.073316,  1.084244,  1.096933,  1.075528,  1.082591,  1.090188,  1.092146,  1.080680,  1.091425,  1.092492,  1.092569,  1.084673, },
{ 1.000000,  1.000966,  1.001951,  1.002362,  1.003082,  1.004500,  1.005845,  1.005032,  1.007278,  1.007652,  1.009672,  1.008675,  1.010412,  1.011697,  1.011703,  1.011525,  1.015665,  1.015729,  1.014911,  1.015162,  1.017123,  1.021198,  1.014768,  1.021089,  1.020268,  1.023450,  1.021604,  1.023499,  1.024738,  1.024315,  1.023969,  1.028839,  1.030515,  1.027895,  1.025672,  1.032013,  1.035645,  1.023411,  1.034721,  1.034375,  1.035733,  1.035032,  1.037430,  1.038837,  1.036694,  1.035831,  1.040813,  1.045567,  1.038097,  1.038450,  1.044800,  1.049008,  1.038348,  1.048255,  1.046764,  1.047301,  1.046380,  1.052596,  1.054983,  1.047806,  1.046953,  1.053474,  1.061375,  1.049201,  1.052960,  1.057726,  1.059913,  1.051772,  1.062397,  1.059937,  1.059901,  1.057420,  1.066655,  1.071248,  1.058371,  1.057474,  1.067964,  1.074854,  1.057691,  1.070909,  1.067969,  1.077627,  1.064710,  1.072097,  1.075136,  1.071335,  1.066465,  1.084582,  1.082984,  1.072158,  1.071604,  1.079201,  1.092597,  1.063752,  1.086494,  1.078651,  1.089121,  1.082762,  1.083652,  1.088097, },
{ 1.000000,  1.000772,  1.001386,  1.002572,  1.003531,  1.003750,  1.004120,  1.005722,  1.007278,  1.005020,  1.008214,  1.008649,  1.009858,  1.009928,  1.011310,  1.012183,  1.012071,  1.011993,  1.014816,  1.017005,  1.014273,  1.014501,  1.017763,  1.020210,  1.015395,  1.020915,  1.020334,  1.021115,  1.020866,  1.024402,  1.025818,  1.022655,  1.022089,  1.026119,  1.030643,  1.024348,  1.027256,  1.029357,  1.031802,  1.026319,  1.033378,  1.032558,  1.032583,  1.030639,  1.037770,  1.039689,  1.032516,  1.032185,  1.038464,  1.043866,  1.033453,  1.040584,  1.039668,  1.045766,  1.038331,  1.043260,  1.046294,  1.042364,  1.041231,  1.051443,  1.052005,  1.044514,  1.043704,  1.049680,  1.058359,  1.039057,  1.054886,  1.050387,  1.057507,  1.053389,  1.052653,  1.059628,  1.054275,  1.049391,  1.064508,  1.064446,  1.056132,  1.053348,  1.063862,  1.073079,  1.043470,  1.070001,  1.063046,  1.066768,  1.064176,  1.069461,  1.069222,  1.065544,  1.062502,  1.074107,  1.078731,  1.065144,  1.064268,  1.075981,  1.082359,  1.058468,  1.080641,  1.076600,  1.077274,  1.073099, },
{ 1.000000,  1.000754,  1.001575,  1.001790,  1.002425,  1.003490,  1.004831,  1.004262,  1.005486,  1.006030,  1.007464,  1.006402,  1.008975,  1.008923,  1.009352,  1.009970,  1.012056,  1.013251,  1.010702,  1.011572,  1.013711,  1.017011,  1.012893,  1.015919,  1.016697,  1.018734,  1.016133,  1.018437,  1.020540,  1.019170,  1.018439,  1.023772,  1.025603,  1.019817,  1.021487,  1.023829,  1.029296,  1.019203,  1.027865,  1.025599,  1.029656,  1.028163,  1.027632,  1.032288,  1.027986,  1.026787,  1.036265,  1.035557,  1.030539,  1.029418,  1.036366,  1.041789,  1.025012,  1.040476,  1.036030,  1.038267,  1.038984,  1.040562,  1.041594,  1.038714,  1.035981,  1.046018,  1.047796,  1.039395,  1.039451,  1.047659,  1.050116,  1.034771,  1.050919,  1.047983,  1.047216,  1.048834,  1.052890,  1.055230,  1.045579,  1.046036,  1.052788,  1.060983,  1.047524,  1.053387,  1.055421,  1.059636,  1.048081,  1.060610,  1.059021,  1.057009,  1.056815,  1.064095,  1.069077,  1.053109,  1.054550,  1.063510,  1.075243,  1.053952,  1.065032,  1.065512,  1.071949,  1.059153,  1.069906,  1.069667, },
{ 1.000000,  1.000554,  1.001088,  1.001989,  1.002847,  1.002616,  1.003250,  1.004388,  1.005613,  1.003961,  1.006564,  1.006462,  1.007671,  1.007757,  1.008443,  1.009805,  1.008648,  1.009220,  1.012158,  1.012948,  1.011112,  1.011007,  1.014242,  1.016817,  1.009231,  1.017098,  1.015271,  1.016360,  1.017526,  1.017899,  1.018739,  1.017530,  1.016997,  1.022268,  1.023137,  1.019342,  1.018766,  1.024200,  1.025561,  1.016827,  1.026138,  1.025495,  1.024565,  1.026924,  1.028011,  1.030131,  1.024510,  1.025314,  1.029777,  1.034048,  1.027104,  1.028402,  1.032913,  1.033877,  1.027700,  1.035490,  1.034597,  1.033325,  1.032893,  1.039617,  1.041925,  1.030339,  1.033584,  1.038659,  1.046625,  1.032804,  1.039033,  1.042353,  1.043663,  1.036285,  1.043932,  1.044664,  1.040600,  1.041307,  1.048865,  1.053558,  1.038904,  1.042020,  1.049516,  1.054537,  1.036476,  1.052047,  1.048272,  1.053451,  1.049070,  1.051437,  1.055050,  1.047942,  1.046975,  1.061840,  1.060377,  1.051263,  1.049388,  1.057861,  1.068446,  1.037412,  1.065389,  1.056162,  1.060477,  1.061273, },
{ 1.000000,  1.000480,  1.001071,  1.001410,  1.001742,  1.002847,  1.003470,  1.003118,  1.003323,  1.005150,  1.005894,  1.003327,  1.006441,  1.007028,  1.006523,  1.007784,  1.008662,  1.009442,  1.007899,  1.008400,  1.010105,  1.012647,  1.009546,  1.010440,  1.013085,  1.013792,  1.010248,  1.014873,  1.013561,  1.014356,  1.013948,  1.017190,  1.019170,  1.013271,  1.015425,  1.017874,  1.022415,  1.015225,  1.017914,  1.021050,  1.020900,  1.017799,  1.021675,  1.022765,  1.020644,  1.021763,  1.024334,  1.028980,  1.019521,  1.021612,  1.026746,  1.029515,  1.018624,  1.028228,  1.027120,  1.030821,  1.025089,  1.028792,  1.031742,  1.025825,  1.026363,  1.036105,  1.036076,  1.028201,  1.028349,  1.033360,  1.041107,  1.020603,  1.037865,  1.033948,  1.035821,  1.037172,  1.035829,  1.038026,  1.033663,  1.033344,  1.043470,  1.045065,  1.036019,  1.031675,  1.044674,  1.049678,  1.022892,  1.044434,  1.046130,  1.039743,  1.045550,  1.045407,  1.048687,  1.039451,  1.040029,  1.047312,  1.053660,  1.041378,  1.040911,  1.051706,  1.053196,  1.038633,  1.052746,  1.049069, },
{ 1.000000,  1.000419,  1.000734,  1.001361,  1.002025,  1.001560,  1.001949,  1.002933,  1.004283,  1.002616,  1.003701,  1.004879,  1.004869,  1.004280,  1.006038,  1.006169,  1.006095,  1.006247,  1.007984,  1.009896,  1.006055,  1.006827,  1.009504,  1.011378,  1.005858,  1.011520,  1.010161,  1.012625,  1.009503,  1.011601,  1.013088,  1.010960,  1.010195,  1.016912,  1.015825,  1.012186,  1.012422,  1.015023,  1.019606,  1.007783,  1.018767,  1.016116,  1.018061,  1.017333,  1.017365,  1.019135,  1.016223,  1.016108,  1.022401,  1.024354,  1.018149,  1.014875,  1.024826,  1.026003,  1.008944,  1.024737,  1.024103,  1.022563,  1.024593,  1.024122,  1.027062,  1.021432,  1.020906,  1.026728,  1.032225,  1.020608,  1.021816,  1.030165,  1.031145,  1.019565,  1.031248,  1.028919,  1.026366,  1.029418,  1.031556,  1.037411,  1.024856,  1.025508,  1.032018,  1.041339,  1.024990,  1.029815,  1.035552,  1.034085,  1.026465,  1.038603,  1.034739,  1.032296,  1.033254,  1.039360,  1.046638,  1.027732,  1.029684,  1.040156,  1.046032,  1.025748,  1.042876,  1.038481,  1.044535,  1.033863, },
{ 1.000000,  1.000286,  1.000621,  1.000710,  1.000830,  1.001917,  1.002141,  1.001467,  1.001783,  1.002794,  1.003875,  1.001011,  1.004318,  1.003237,  1.004151,  1.004472,  1.004277,  1.005305,  1.004064,  1.004039,  1.007125,  1.007808,  1.005106,  1.004334,  1.008409,  1.009526,  1.001226,  1.008783,  1.008299,  1.008137,  1.009046,  1.009343,  1.009763,  1.007987,  1.007198,  1.011447,  1.013799,  1.007114,  1.008102,  1.012448,  1.013503,  1.006286,  1.014471,  1.011782,  1.011007,  1.012928,  1.014695,  1.016908,  1.010449,  1.009915,  1.014779,  1.019835,  1.009824,  1.014353,  1.016011,  1.016781,  1.010243,  1.019284,  1.016802,  1.014911,  1.014935,  1.021124,  1.022894,  1.012091,  1.012889,  1.020086,  1.025267,  1.010388,  1.021541,  1.018620,  1.022592,  1.015747,  1.020811,  1.023407,  1.016848,  1.017576,  1.027525,  1.027786,  1.016881,  1.016815,  1.024955,  1.031067,  1.007343,  1.029239,  1.021612,  1.025440,  1.025616,  1.022164,  1.029882,  1.020298,  1.017055,  1.033871,  1.033769,  1.019906,  1.018870,  1.032941,  1.037538,  1.003586,  1.036226,  1.027488, },
{ 1.000000,  1.000152,  1.000345,  1.000549,  1.000792,  1.000568,  1.000532,  1.001473,  1.002092,  1.000605,  1.000855,  1.002377,  1.002815,  0.999818,  1.003111,  1.002611,  1.002083,  1.002610,  1.003904,  1.004601,  1.001597,  1.001473,  1.004025,  1.006359,  1.001465,  1.003971,  1.004049,  1.005901,  1.000849,  1.006444,  1.004996,  1.004079,  1.004531,  1.007646,  1.008139,  1.002141,  1.002701,  1.006343,  1.011306,  1.000914,  1.007108,  1.007252,  1.008771,  1.003352,  1.006811,  1.009544,  1.005783,  1.004238,  1.011389,  1.013230,  1.003396,  1.004801,  1.009171,  1.015390,  0.998083,  1.011727,  1.007611,  1.011138,  1.009325,  1.008092,  1.013947,  1.005569,  1.003707,  1.016681,  1.015749,  1.005506,  1.004244,  1.015124,  1.019927,  0.994382,  1.016891,  1.010654,  1.011396,  1.012293,  1.013854,  1.014619,  1.008981,  1.005009,  1.018210,  1.019954,  1.006133,  1.006504,  1.018606,  1.019192,  0.997689,  1.018932,  1.014876,  1.011451,  1.014947,  1.018239,  1.021100,  1.007481,  1.007214,  1.016751,  1.025262,  1.006453,  1.013793,  1.017487,  1.020041,  1.003838, },
{ 1.000000,  1.000068,  1.000100,  1.000020,  1.000023,  1.000419,  1.000694,  0.999530,  0.999460,  1.000516,  1.001804,  0.998568,  1.000511,  1.000619,  1.001183,  0.998875,  1.000877,  1.000888,  0.999837,  0.999569,  1.002019,  1.002480,  0.998767,  0.998876,  1.001635,  1.003851,  0.995273,  1.002313,  1.000251,  1.002042,  1.000168,  1.001076,  1.002627,  0.998527,  0.998420,  1.003682,  1.004151,  0.998673,  0.997612,  1.003178,  1.007384,  0.990062,  1.004711,  1.000612,  1.001671,  1.002026,  1.001938,  1.002371,  0.999102,  0.997373,  1.005831,  1.006086,  0.997065,  0.996586,  1.005020,  1.006856,  0.989640,  1.004421,  1.002608,  1.000695,  1.002726,  1.003645,  1.005926,  0.997180,  0.996881,  1.004040,  1.008786,  0.995424,  0.998361,  1.004958,  1.005804,  0.992917,  1.004945,  1.002755,  1.001088,  0.998834,  1.007719,  1.008838,  0.994137,  0.996290,  1.003864,  1.014507,  0.990361,  1.002187,  1.004943,  1.007192,  0.992801,  1.004893,  1.004706,  0.998404,  0.999593,  1.007587,  1.012027,  0.994091,  0.995510,  1.007436,  1.013696,  0.983874,  1.007128,  1.001474, },
{ 1.000000,  0.999943,  0.999661,  0.999691,  0.999663,  0.999178,  0.998762,  0.999918,  0.999643,  0.998428,  0.997988,  0.999103,  1.000514,  0.995012,  0.999445,  0.997998,  0.998581,  0.997929,  0.998020,  0.998490,  0.996677,  0.995941,  0.999423,  0.999345,  0.995131,  0.994601,  0.999015,  1.000256,  0.989731,  0.997785,  0.997671,  0.995871,  0.995899,  0.997839,  0.998054,  0.993443,  0.993034,  0.996447,  0.999948,  0.991333,  0.993262,  0.997579,  0.998455,  0.988312,  0.997453,  0.993516,  0.995093,  0.991599,  0.997796,  0.998775,  0.989085,  0.990439,  0.995181,  1.001717,  0.986106,  0.992697,  0.995584,  0.996325,  0.986418,  0.994660,  0.994501,  0.991317,  0.991081,  0.995169,  0.999319,  0.985997,  0.986529,  0.995936,  1.000045,  0.977801,  0.994544,  0.992093,  0.998111,  0.984241,  0.992921,  0.994524,  0.985958,  0.984691,  0.999574,  0.997457,  0.985063,  0.983843,  0.992652,  1.003962,  0.968535,  0.995244,  0.989948,  0.992203,  0.989672,  0.990080,  0.991500,  0.984224,  0.982930,  0.997348,  0.997822,  0.983344,  0.976706,  0.995705,  1.003896,  0.960844, },
{ 1.000000,  0.999765,  0.999543,  0.999117,  0.998840,  0.998784,  0.998661,  0.997565,  0.997131,  0.997897,  0.998108,  0.995944,  0.995764,  0.997205,  0.997158,  0.993488,  0.996411,  0.995000,  0.995031,  0.993766,  0.995839,  0.996191,  0.991438,  0.991533,  0.994286,  0.996733,  0.988637,  0.991903,  0.994080,  0.992515,  0.988132,  0.992697,  0.991529,  0.990143,  0.988901,  0.992335,  0.994024,  0.985722,  0.985410,  0.991577,  0.993923,  0.979513,  0.991048,  0.988151,  0.991895,  0.982535,  0.987927,  0.988913,  0.983944,  0.981435,  0.992496,  0.988978,  0.981791,  0.981409,  0.986310,  0.992767,  0.969695,  0.988194,  0.984558,  0.986286,  0.980942,  0.983733,  0.984539,  0.978316,  0.977897,  0.987494,  0.988093,  0.977523,  0.971890,  0.987530,  0.988814,  0.959929,  0.983517,  0.982839,  0.980071,  0.978684,  0.980121,  0.983045,  0.973106,  0.972052,  0.981480,  0.986251,  0.967220,  0.970208,  0.982747,  0.982148,  0.962831,  0.980369,  0.975870,  0.972805,  0.972503,  0.979321,  0.983164,  0.965231,  0.966291,  0.976768,  0.985955,  0.960430,  0.969290,  0.977920, },
{ 1.000000,  0.999658,  0.998946,  0.999083,  0.998511,  0.997922,  0.997462,  0.997777,  0.997812,  0.995589,  0.995102,  0.996555,  0.996841,  0.992409,  0.995456,  0.994523,  0.995162,  0.991542,  0.993433,  0.993494,  0.991445,  0.989953,  0.994207,  0.992941,  0.988793,  0.988456,  0.991489,  0.993523,  0.982148,  0.991341,  0.988360,  0.989209,  0.986918,  0.987477,  0.988403,  0.984320,  0.983190,  0.989501,  0.989021,  0.982703,  0.979625,  0.988381,  0.989448,  0.971158,  0.985195,  0.984720,  0.983246,  0.981348,  0.982977,  0.983105,  0.978331,  0.976319,  0.983957,  0.985864,  0.972573,  0.974104,  0.982582,  0.981992,  0.968177,  0.981079,  0.977624,  0.975515,  0.974415,  0.979609,  0.981151,  0.969899,  0.968620,  0.976967,  0.982200,  0.964771,  0.971795,  0.976243,  0.975513,  0.960949,  0.976894,  0.973170,  0.969031,  0.965764,  0.977444,  0.976201,  0.961805,  0.960101,  0.973217,  0.979138,  0.952166,  0.970975,  0.968236,  0.973411,  0.955929,  0.968005,  0.970620,  0.959862,  0.958166,  0.973534,  0.971704,  0.956687,  0.954613,  0.968226,  0.975729,  0.936691, },
{ 1.000000,  0.999624,  0.999088,  0.998726,  0.998045,  0.997642,  0.997673,  0.996351,  0.995428,  0.996846,  0.996263,  0.994068,  0.993162,  0.995281,  0.995500,  0.988666,  0.993997,  0.992522,  0.991880,  0.990857,  0.991493,  0.991173,  0.988695,  0.987760,  0.990801,  0.991038,  0.984959,  0.985229,  0.989400,  0.988908,  0.980130,  0.987809,  0.986087,  0.984272,  0.983157,  0.986644,  0.986141,  0.979648,  0.979000,  0.983934,  0.986141,  0.976056,  0.980501,  0.981009,  0.982564,  0.971919,  0.982603,  0.978603,  0.977143,  0.975358,  0.981727,  0.979953,  0.971062,  0.970166,  0.977048,  0.982579,  0.964466,  0.975100,  0.975625,  0.976855,  0.964940,  0.973092,  0.974816,  0.969202,  0.965085,  0.975979,  0.976364,  0.962860,  0.963359,  0.971017,  0.977634,  0.949845,  0.971890,  0.966504,  0.969572,  0.962641,  0.964954,  0.970056,  0.958710,  0.954872,  0.973414,  0.968533,  0.955860,  0.951816,  0.969447,  0.972873,  0.937124,  0.967422,  0.959920,  0.959883,  0.957399,  0.961656,  0.961050,  0.952910,  0.947345,  0.965564,  0.964963,  0.944947,  0.945635,  0.963170, },
{ 1.000000,  0.999535,  0.998497,  0.998572,  0.997938,  0.997224,  0.996637,  0.996645,  0.996259,  0.994322,  0.993717,  0.994568,  0.994752,  0.991406,  0.992096,  0.992515,  0.992179,  0.988064,  0.991392,  0.990044,  0.988962,  0.987617,  0.989760,  0.989316,  0.984684,  0.983607,  0.987298,  0.989228,  0.979821,  0.984880,  0.984995,  0.985044,  0.978250,  0.983760,  0.982491,  0.980000,  0.977747,  0.983385,  0.982622,  0.975384,  0.974729,  0.980478,  0.982317,  0.966181,  0.979536,  0.975401,  0.977755,  0.971474,  0.975774,  0.975798,  0.969422,  0.967424,  0.977294,  0.975090,  0.967110,  0.964111,  0.974104,  0.977838,  0.951557,  0.973889,  0.967319,  0.967739,  0.965729,  0.968092,  0.966718,  0.961548,  0.958311,  0.970975,  0.968604,  0.956400,  0.954699,  0.967095,  0.967837,  0.943301,  0.964857,  0.961254,  0.958586,  0.956908,  0.962226,  0.962036,  0.950500,  0.949166,  0.960219,  0.962533,  0.945493,  0.949005,  0.958812,  0.957002,  0.939359,  0.957361,  0.951956,  0.950855,  0.943347,  0.958540,  0.956409,  0.938360,  0.939480,  0.951585,  0.960811,  0.930085, },
{ 1.000000,  0.999379,  0.998874,  0.998307,  0.996910,  0.997159,  0.996446,  0.995352,  0.994625,  0.995137,  0.994825,  0.992128,  0.991489,  0.993052,  0.992869,  0.987246,  0.991128,  0.989571,  0.990043,  0.986558,  0.988468,  0.987665,  0.985297,  0.983367,  0.988285,  0.986174,  0.982249,  0.980820,  0.984431,  0.986401,  0.972830,  0.983774,  0.980081,  0.980461,  0.977890,  0.979366,  0.979230,  0.975027,  0.973584,  0.980221,  0.978302,  0.970913,  0.969544,  0.977684,  0.977681,  0.960262,  0.974191,  0.973362,  0.969597,  0.967904,  0.972554,  0.971692,  0.963770,  0.963052,  0.968961,  0.971437,  0.959029,  0.961719,  0.968718,  0.967483,  0.952686,  0.967211,  0.959965,  0.961960,  0.954848,  0.965886,  0.965192,  0.951282,  0.952749,  0.960680,  0.966184,  0.945179,  0.954602,  0.959492,  0.957479,  0.942885,  0.956610,  0.954712,  0.949724,  0.947449,  0.955287,  0.958431,  0.940685,  0.940700,  0.955309,  0.956509,  0.927018,  0.951165,  0.947199,  0.953717,  0.932390,  0.948128,  0.947182,  0.935582,  0.932665,  0.954289,  0.948050,  0.932609,  0.930455,  0.944124, },
{ 1.000000,  0.999469,  0.998077,  0.998148,  0.997277,  0.996655,  0.995695,  0.995374,  0.994621,  0.993181,  0.992372,  0.993593,  0.992686,  0.990226,  0.988314,  0.991078,  0.991261,  0.983128,  0.988513,  0.988052,  0.985902,  0.984933,  0.985850,  0.985559,  0.981557,  0.980674,  0.983692,  0.983548,  0.977830,  0.977652,  0.981720,  0.980624,  0.972484,  0.979398,  0.976064,  0.975904,  0.972778,  0.977614,  0.977609,  0.968291,  0.968628,  0.974090,  0.976992,  0.962833,  0.968752,  0.972806,  0.968775,  0.961222,  0.969588,  0.966985,  0.964302,  0.961616,  0.967944,  0.969475,  0.956528,  0.955696,  0.965985,  0.967730,  0.945750,  0.963588,  0.959598,  0.963702,  0.949232,  0.958371,  0.958785,  0.950963,  0.946856,  0.963347,  0.957338,  0.946845,  0.946225,  0.953996,  0.960605,  0.928795,  0.955062,  0.950020,  0.950805,  0.942512,  0.948088,  0.947982,  0.938893,  0.938323,  0.951548,  0.950738,  0.936491,  0.929064,  0.950793,  0.949703,  0.912244,  0.943858,  0.942746,  0.937825,  0.934734,  0.938200,  0.941046,  0.927314,  0.926210,  0.939224,  0.942375,  0.918304, },
{ 1.000000,  0.999178,  0.998663,  0.997898,  0.996327,  0.996513,  0.995519,  0.994508,  0.993642,  0.993791,  0.993445,  0.990518,  0.989918,  0.990889,  0.991195,  0.986471,  0.987332,  0.988502,  0.986658,  0.982681,  0.986647,  0.984334,  0.982563,  0.981497,  0.983678,  0.983859,  0.977328,  0.976508,  0.981216,  0.981471,  0.970629,  0.978544,  0.976748,  0.977647,  0.969803,  0.974481,  0.974359,  0.970097,  0.967288,  0.975517,  0.972792,  0.965173,  0.964698,  0.970527,  0.972921,  0.953512,  0.969424,  0.964751,  0.965106,  0.961050,  0.962801,  0.963703,  0.956804,  0.955333,  0.964986,  0.963535,  0.953806,  0.949233,  0.962891,  0.962883,  0.936264,  0.956970,  0.956415,  0.953339,  0.950078,  0.953067,  0.952807,  0.945347,  0.942865,  0.953867,  0.954916,  0.936360,  0.939040,  0.951085,  0.948258,  0.930021,  0.947542,  0.943026,  0.939293,  0.937036,  0.944933,  0.946112,  0.930681,  0.929333,  0.940777,  0.945588,  0.922907,  0.932512,  0.938923,  0.935887,  0.916781,  0.938601,  0.932970,  0.926863,  0.922082,  0.938223,  0.935074,  0.916741,  0.914519,  0.932084, },
{ 1.000000,  0.999276,  0.997932,  0.997635,  0.996813,  0.996225,  0.994157,  0.994437,  0.993832,  0.991873,  0.990850,  0.992063,  0.991051,  0.988136,  0.986959,  0.988657,  0.988818,  0.980978,  0.986566,  0.984572,  0.984022,  0.981646,  0.981594,  0.982749,  0.978272,  0.976287,  0.981547,  0.979949,  0.974236,  0.972353,  0.978481,  0.978573,  0.963081,  0.975553,  0.972790,  0.971039,  0.969036,  0.970740,  0.970057,  0.965077,  0.963550,  0.969662,  0.969385,  0.958354,  0.959270,  0.967040,  0.965086,  0.950518,  0.963432,  0.960917,  0.957354,  0.955226,  0.961405,  0.960115,  0.949595,  0.948731,  0.956879,  0.959081,  0.943564,  0.950621,  0.951987,  0.952846,  0.937084,  0.953569,  0.947153,  0.944594,  0.941573,  0.951553,  0.948145,  0.935172,  0.933891,  0.944409,  0.950616,  0.924871,  0.940409,  0.941619,  0.941835,  0.924976,  0.937281,  0.939010,  0.930529,  0.924808,  0.940040,  0.939807,  0.921331,  0.921821,  0.933206,  0.940090,  0.902545,  0.932947,  0.926267,  0.928378,  0.918899,  0.923107,  0.929131,  0.913301,  0.908636,  0.933032,  0.925617,  0.908869, },
{ 1.000000,  0.998952,  0.998476,  0.997751,  0.995223,  0.995977,  0.994767,  0.993772,  0.992669,  0.992401,  0.991494,  0.989528,  0.987972,  0.989872,  0.988882,  0.984702,  0.984076,  0.986659,  0.985333,  0.978426,  0.983554,  0.982016,  0.979887,  0.978866,  0.980372,  0.979583,  0.974183,  0.973487,  0.976686,  0.977095,  0.969297,  0.971648,  0.973185,  0.972133,  0.963792,  0.971316,  0.968573,  0.966423,  0.963978,  0.968616,  0.967442,  0.959100,  0.957402,  0.964509,  0.967010,  0.950980,  0.960040,  0.960569,  0.959782,  0.948850,  0.958253,  0.956045,  0.951693,  0.948183,  0.957402,  0.955737,  0.944562,  0.943560,  0.952901,  0.954496,  0.930344,  0.950701,  0.944986,  0.947247,  0.938001,  0.944969,  0.944501,  0.934880,  0.932156,  0.946595,  0.942592,  0.931260,  0.927086,  0.941774,  0.945294,  0.909366,  0.940211,  0.931784,  0.930864,  0.928151,  0.931975,  0.929680,  0.921940,  0.918206,  0.935225,  0.931047,  0.914422,  0.912670,  0.929575,  0.928779,  0.897020,  0.925226,  0.921158,  0.916307,  0.913698,  0.921530,  0.920443,  0.905044,  0.903595,  0.918488, },
{ 1.000000,  0.999121,  0.997822,  0.996995,  0.996522,  0.995440,  0.993306,  0.993820,  0.992447,  0.991418,  0.989639,  0.990703,  0.989510,  0.986054,  0.985268,  0.986551,  0.987039,  0.980667,  0.982867,  0.983169,  0.981971,  0.976555,  0.980325,  0.978813,  0.975908,  0.974550,  0.977308,  0.977012,  0.970296,  0.969453,  0.974278,  0.973754,  0.961353,  0.970801,  0.968053,  0.968757,  0.962080,  0.966481,  0.965034,  0.960505,  0.957270,  0.966608,  0.962641,  0.955784,  0.953609,  0.960442,  0.962921,  0.940771,  0.958906,  0.953445,  0.953253,  0.949412,  0.952127,  0.951766,  0.944847,  0.943046,  0.953215,  0.949997,  0.938697,  0.936993,  0.949490,  0.948251,  0.923502,  0.943610,  0.942870,  0.936642,  0.934119,  0.941099,  0.939623,  0.928122,  0.927282,  0.935986,  0.938298,  0.921187,  0.925226,  0.935292,  0.932099,  0.912550,  0.931991,  0.922821,  0.924560,  0.914945,  0.930098,  0.928441,  0.909936,  0.911765,  0.922961,  0.928648,  0.901229,  0.913893,  0.920877,  0.916643,  0.897831,  0.916180,  0.913396,  0.906312,  0.903123,  0.913816,  0.916948,  0.894330, },
{ 1.000000,  0.998874,  0.998171,  0.997197,  0.994821,  0.995154,  0.993984,  0.993477,  0.990593,  0.991202,  0.990160,  0.987716,  0.986335,  0.988583,  0.986709,  0.983194,  0.981878,  0.983660,  0.984282,  0.974664,  0.981099,  0.978863,  0.977713,  0.975522,  0.976032,  0.974868,  0.971308,  0.970138,  0.974459,  0.972534,  0.967050,  0.963390,  0.970628,  0.970743,  0.954014,  0.965807,  0.965597,  0.961191,  0.959563,  0.961877,  0.961446,  0.954260,  0.953086,  0.958930,  0.958224,  0.948527,  0.948760,  0.956129,  0.953479,  0.940641,  0.951902,  0.947150,  0.946392,  0.941551,  0.949451,  0.949222,  0.934868,  0.935662,  0.944331,  0.947801,  0.926871,  0.936045,  0.942368,  0.935468,  0.924676,  0.937237,  0.933313,  0.929141,  0.925269,  0.934652,  0.936278,  0.918090,  0.917029,  0.931939,  0.933189,  0.902783,  0.927622,  0.922822,  0.927053,  0.907582,  0.920478,  0.920723,  0.909637,  0.904389,  0.926478,  0.918054,  0.903730,  0.903174,  0.914232,  0.921302,  0.879831,  0.914240,  0.908563,  0.907737,  0.897316,  0.905057,  0.904634,  0.891955,  0.891751,  0.908822, },
{ 1.000000,  0.999033,  0.997633,  0.996250,  0.996195,  0.995138,  0.991461,  0.992810,  0.991832,  0.990171,  0.988847,  0.988354,  0.987788,  0.984692,  0.983580,  0.984821,  0.984205,  0.978922,  0.978783,  0.981361,  0.979203,  0.973368,  0.977492,  0.975279,  0.972988,  0.971520,  0.973535,  0.973401,  0.966161,  0.965869,  0.969188,  0.970164,  0.960096,  0.962769,  0.965997,  0.962208,  0.954741,  0.963209,  0.958969,  0.955873,  0.954180,  0.958674,  0.959042,  0.947726,  0.946618,  0.955321,  0.955386,  0.937264,  0.950966,  0.948455,  0.949305,  0.936997,  0.944971,  0.944789,  0.937810,  0.933901,  0.946600,  0.942356,  0.930818,  0.930297,  0.939581,  0.942120,  0.913894,  0.937426,  0.931138,  0.930614,  0.925076,  0.927925,  0.929202,  0.918898,  0.917260,  0.930811,  0.928536,  0.914711,  0.908625,  0.927987,  0.926737,  0.890852,  0.919024,  0.918848,  0.913611,  0.909480,  0.913602,  0.913208,  0.902695,  0.899750,  0.914627,  0.915082,  0.890459,  0.894411,  0.910710,  0.905426,  0.882333,  0.904839,  0.899654,  0.893857,  0.890766,  0.901337,  0.902601,  0.882195, },
{ 1.000000,  0.998783,  0.997806,  0.996913,  0.994836,  0.994230,  0.993576,  0.992214,  0.989451,  0.990496,  0.988889,  0.987057,  0.985384,  0.986630,  0.985158,  0.981244,  0.979721,  0.981960,  0.981818,  0.974097,  0.978173,  0.976748,  0.976524,  0.970381,  0.973514,  0.973109,  0.968411,  0.966745,  0.971277,  0.969393,  0.963179,  0.961420,  0.966155,  0.966726,  0.950966,  0.963231,  0.959921,  0.958755,  0.954857,  0.955400,  0.957815,  0.949827,  0.946945,  0.956383,  0.953884,  0.944285,  0.941669,  0.952292,  0.951793,  0.927697,  0.947553,  0.943769,  0.940655,  0.937850,  0.940675,  0.939877,  0.932051,  0.930349,  0.939499,  0.938749,  0.922694,  0.924500,  0.935961,  0.932297,  0.912263,  0.930451,  0.927244,  0.921822,  0.919047,  0.927714,  0.925824,  0.911161,  0.910421,  0.921692,  0.923919,  0.903073,  0.912944,  0.915092,  0.915168,  0.894609,  0.916643,  0.908228,  0.904321,  0.900477,  0.913775,  0.908973,  0.892064,  0.890478,  0.904441,  0.911481,  0.878417,  0.898784,  0.900569,  0.899695,  0.878523,  0.894479,  0.896627,  0.885235,  0.878254,  0.897385, },
{ 1.000000,  0.998873,  0.997348,  0.996048,  0.995353,  0.994561,  0.990855,  0.992024,  0.990327,  0.989246,  0.987179,  0.986578,  0.986276,  0.982795,  0.981036,  0.983834,  0.981540,  0.977385,  0.975360,  0.979127,  0.978247,  0.967447,  0.975133,  0.972224,  0.970396,  0.968621,  0.969271,  0.968051,  0.963674,  0.961062,  0.966756,  0.965104,  0.956200,  0.955727,  0.962243,  0.959644,  0.946448,  0.957128,  0.954917,  0.951012,  0.949520,  0.952822,  0.951800,  0.942451,  0.941694,  0.947714,  0.948316,  0.935429,  0.939838,  0.942879,  0.940788,  0.927806,  0.940123,  0.936058,  0.932580,  0.928992,  0.936459,  0.934650,  0.922063,  0.919793,  0.930743,  0.934050,  0.910485,  0.924247,  0.925232,  0.923402,  0.908069,  0.921795,  0.918820,  0.912155,  0.907521,  0.920644,  0.918063,  0.902504,  0.901311,  0.914602,  0.915945,  0.883025,  0.911308,  0.903599,  0.905710,  0.893713,  0.903328,  0.902581,  0.889199,  0.886011,  0.905186,  0.899576,  0.884372,  0.879235,  0.898782,  0.902254,  0.855926,  0.896076,  0.885526,  0.883186,  0.880139,  0.884993,  0.882270,  0.871524, },
{ 1.000000,  0.998603,  0.997661,  0.996432,  0.994430,  0.992992,  0.992895,  0.991708,  0.987615,  0.989130,  0.987593,  0.985807,  0.984280,  0.984264,  0.982988,  0.979315,  0.977975,  0.979532,  0.978585,  0.973075,  0.973160,  0.974943,  0.972551,  0.966548,  0.971121,  0.968323,  0.966513,  0.962943,  0.967320,  0.965302,  0.957784,  0.957118,  0.960941,  0.962624,  0.949713,  0.955327,  0.956612,  0.954513,  0.944674,  0.952458,  0.950213,  0.945110,  0.943369,  0.948698,  0.948298,  0.937107,  0.936241,  0.944786,  0.943774,  0.923892,  0.939746,  0.935612,  0.936400,  0.926404,  0.933727,  0.931674,  0.924545,  0.920024,  0.934255,  0.928420,  0.918262,  0.915452,  0.925673,  0.928753,  0.897214,  0.923519,  0.915989,  0.915208,  0.910073,  0.914017,  0.913713,  0.903647,  0.901767,  0.915655,  0.911158,  0.895374,  0.893622,  0.910786,  0.908195,  0.875346,  0.902498,  0.901752,  0.892856,  0.889645,  0.899014,  0.897101,  0.881583,  0.880757,  0.892333,  0.894886,  0.872467,  0.878099,  0.891221,  0.886144,  0.861563,  0.886417,  0.874982,  0.876458,  0.864335,  0.883912, },
{ 1.000000,  0.998750,  0.997039,  0.995664,  0.994859,  0.993929,  0.990776,  0.990457,  0.989863,  0.988149,  0.984779,  0.985758,  0.984227,  0.981932,  0.980225,  0.980809,  0.980166,  0.974918,  0.973648,  0.976444,  0.975160,  0.965876,  0.971786,  0.969643,  0.969906,  0.962385,  0.966524,  0.964967,  0.959638,  0.957568,  0.964308,  0.960694,  0.953786,  0.952017,  0.956780,  0.958306,  0.939894,  0.953372,  0.949892,  0.947876,  0.944597,  0.945985,  0.944477,  0.938469,  0.937256,  0.944874,  0.941906,  0.933060,  0.927662,  0.939771,  0.939691,  0.913992,  0.932714,  0.932716,  0.925838,  0.923776,  0.927490,  0.927104,  0.916325,  0.915019,  0.923849,  0.922704,  0.908728,  0.909585,  0.920318,  0.915883,  0.898313,  0.914374,  0.907942,  0.906614,  0.900149,  0.911224,  0.910928,  0.891222,  0.892677,  0.904608,  0.908723,  0.880608,  0.893475,  0.902036,  0.892154,  0.878142,  0.895017,  0.889777,  0.883967,  0.879151,  0.891578,  0.893438,  0.869724,  0.868488,  0.888072,  0.889030,  0.849875,  0.882287,  0.876205,  0.880608,  0.856390,  0.872933,  0.873129,  0.858559, },
{ 1.000000,  0.998478,  0.997520,  0.995920,  0.993910,  0.992473,  0.991889,  0.991057,  0.985996,  0.988086,  0.986242,  0.984768,  0.982105,  0.981939,  0.980688,  0.977309,  0.975978,  0.977798,  0.976366,  0.971421,  0.968404,  0.973227,  0.971150,  0.959351,  0.967538,  0.966283,  0.963006,  0.960921,  0.961141,  0.960985,  0.954533,  0.953302,  0.957234,  0.956702,  0.946166,  0.947060,  0.953071,  0.949164,  0.938946,  0.947274,  0.943918,  0.940124,  0.938098,  0.942235,  0.942392,  0.930294,  0.930481,  0.936630,  0.938046,  0.922075,  0.927154,  0.932619,  0.926343,  0.915218,  0.928839,  0.922510,  0.917863,  0.915664,  0.922722,  0.923288,  0.906653,  0.905461,  0.918519,  0.918229,  0.892366,  0.912585,  0.909099,  0.909752,  0.892933,  0.904419,  0.904188,  0.894327,  0.889307,  0.906784,  0.900987,  0.885079,  0.884718,  0.897742,  0.900470,  0.862557,  0.894667,  0.886432,  0.885020,  0.878103,  0.881917,  0.883874,  0.869734,  0.868110,  0.885807,  0.882718,  0.864407,  0.856898,  0.882400,  0.879580,  0.833872,  0.870377,  0.870388,  0.862788,  0.857828,  0.863203, },
{ 1.000000,  0.998609,  0.996850,  0.995275,  0.994453,  0.993149,  0.990088,  0.988875,  0.989013,  0.987064,  0.983148,  0.984462,  0.982472,  0.980279,  0.978526,  0.978867,  0.977907,  0.972841,  0.971351,  0.973093,  0.972673,  0.965295,  0.966859,  0.967713,  0.964959,  0.957968,  0.963873,  0.960827,  0.957225,  0.954459,  0.959096,  0.956606,  0.948609,  0.946627,  0.952555,  0.952702,  0.937733,  0.947178,  0.945081,  0.944890,  0.934120,  0.940794,  0.940590,  0.932488,  0.930435,  0.938757,  0.935812,  0.925673,  0.923432,  0.931754,  0.932510,  0.907720,  0.927954,  0.922952,  0.920888,  0.915538,  0.916690,  0.920635,  0.908461,  0.904781,  0.919018,  0.915342,  0.901332,  0.897993,  0.913743,  0.912576,  0.878343,  0.907055,  0.901948,  0.897227,  0.893636,  0.897594,  0.896884,  0.885631,  0.883793,  0.896558,  0.895244,  0.873101,  0.876282,  0.892067,  0.886284,  0.859949,  0.884303,  0.880376,  0.872597,  0.869165,  0.880780,  0.878297,  0.858616,  0.858088,  0.873122,  0.875460,  0.848046,  0.861534,  0.864573,  0.863575,  0.837514,  0.866235,  0.855382,  0.849916, },
{ 1.000000,  0.998342,  0.997154,  0.995542,  0.993318,  0.991598,  0.991011,  0.990203,  0.985667,  0.986357,  0.985137,  0.983521,  0.979389,  0.980216,  0.979274,  0.975909,  0.973347,  0.975503,  0.974071,  0.968153,  0.966903,  0.968871,  0.969066,  0.956841,  0.964982,  0.961756,  0.960358,  0.956413,  0.956697,  0.957558,  0.950339,  0.947631,  0.955362,  0.951250,  0.943531,  0.940401,  0.949054,  0.947770,  0.928129,  0.943439,  0.938820,  0.935851,  0.933603,  0.935165,  0.933795,  0.926632,  0.923112,  0.932923,  0.930507,  0.916460,  0.916519,  0.927173,  0.923007,  0.903244,  0.920079,  0.917068,  0.911100,  0.909411,  0.914665,  0.913305,  0.899696,  0.899086,  0.908118,  0.908771,  0.890611,  0.897451,  0.901905,  0.898545,  0.880925,  0.898472,  0.892878,  0.887863,  0.883398,  0.893872,  0.891302,  0.874220,  0.871412,  0.886637,  0.890443,  0.859135,  0.878110,  0.879504,  0.876308,  0.856589,  0.874824,  0.871265,  0.861881,  0.856335,  0.873569,  0.870029,  0.849798,  0.848512,  0.866091,  0.867039,  0.824790,  0.861799,  0.851893,  0.853784,  0.838942,  0.851330, },
{ 1.000000,  0.998421,  0.996607,  0.994813,  0.994160,  0.992369,  0.989784,  0.987867,  0.988071,  0.986912,  0.980421,  0.983631,  0.980980,  0.979056,  0.977203,  0.976620,  0.974815,  0.971454,  0.969351,  0.972096,  0.969696,  0.963648,  0.962107,  0.965681,  0.963595,  0.952876,  0.960289,  0.957930,  0.954614,  0.952482,  0.954135,  0.952453,  0.945344,  0.943751,  0.948283,  0.947161,  0.937029,  0.938272,  0.942691,  0.938548,  0.928685,  0.937533,  0.933234,  0.930593,  0.925230,  0.933243,  0.930233,  0.918251,  0.917925,  0.924726,  0.927286,  0.907387,  0.916969,  0.919457,  0.915892,  0.901549,  0.913841,  0.910882,  0.903213,  0.901155,  0.909348,  0.908906,  0.892840,  0.891916,  0.904726,  0.902900,  0.875105,  0.898036,  0.892401,  0.893050,  0.879778,  0.890212,  0.887535,  0.877489,  0.871905,  0.891447,  0.883249,  0.869625,  0.866343,  0.880511,  0.883655,  0.842245,  0.877616,  0.867905,  0.866047,  0.859891,  0.865160,  0.865039,  0.851417,  0.849663,  0.867555,  0.861603,  0.841049,  0.839351,  0.861587,  0.857242,  0.816162,  0.850768,  0.850052,  0.838043, },
{ 1.000000,  0.998257,  0.996789,  0.995154,  0.992796,  0.991060,  0.990343,  0.988970,  0.985366,  0.984342,  0.984268,  0.982042,  0.977351,  0.979278,  0.976150,  0.974774,  0.971248,  0.973331,  0.971552,  0.965449,  0.964462,  0.966172,  0.966052,  0.956726,  0.959365,  0.960188,  0.957001,  0.949639,  0.954515,  0.952292,  0.948219,  0.945831,  0.948667,  0.948277,  0.938261,  0.936935,  0.943744,  0.941816,  0.924958,  0.937294,  0.934037,  0.934714,  0.922387,  0.930432,  0.928336,  0.919688,  0.916973,  0.928816,  0.923170,  0.912404,  0.910262,  0.918516,  0.920725,  0.892714,  0.914307,  0.909421,  0.906144,  0.901874,  0.904308,  0.902466,  0.893569,  0.892439,  0.903765,  0.899592,  0.886933,  0.879936,  0.897587,  0.896873,  0.861449,  0.887895,  0.888253,  0.878404,  0.875987,  0.881303,  0.880978,  0.866098,  0.864785,  0.877171,  0.875294,  0.856580,  0.858371,  0.872896,  0.866121,  0.843625,  0.864941,  0.856768,  0.854608,  0.846284,  0.860958,  0.860654,  0.834860,  0.837184,  0.852894,  0.857560,  0.821477,  0.838672,  0.849685,  0.836220,  0.818857,  0.840592, },
{ 1.000000,  0.998289,  0.996448,  0.994423,  0.993326,  0.991850,  0.988596,  0.986638,  0.986797,  0.985337,  0.979314,  0.981544,  0.979262,  0.978244,  0.973114,  0.974227,  0.972691,  0.968452,  0.965794,  0.969808,  0.966120,  0.960652,  0.959161,  0.961088,  0.961200,  0.947143,  0.956784,  0.953733,  0.951365,  0.946738,  0.948097,  0.946699,  0.940243,  0.939020,  0.944172,  0.942207,  0.933142,  0.928462,  0.938942,  0.935485,  0.914727,  0.930577,  0.929254,  0.923832,  0.921052,  0.922142,  0.922391,  0.912184,  0.910981,  0.918040,  0.917380,  0.901051,  0.903298,  0.913222,  0.906986,  0.892010,  0.905239,  0.900700,  0.895024,  0.892399,  0.899077,  0.899577,  0.881968,  0.882855,  0.892033,  0.894023,  0.871483,  0.879332,  0.887293,  0.878193,  0.863178,  0.882456,  0.873855,  0.867308,  0.864791,  0.874795,  0.875504,  0.852774,  0.851785,  0.869787,  0.868939,  0.834284,  0.861917,  0.857673,  0.857743,  0.836025,  0.851454,  0.851454,  0.838108,  0.832061,  0.854769,  0.847199,  0.826532,  0.826439,  0.843692,  0.846304,  0.797918,  0.839710,  0.829420,  0.826490, },
{ 1.000000,  0.998156,  0.996344,  0.994698,  0.992324,  0.990339,  0.989849,  0.987929,  0.984608,  0.982124,  0.983251,  0.981299,  0.973677,  0.976995,  0.975539,  0.972546,  0.970219,  0.969645,  0.968023,  0.963618,  0.961544,  0.964023,  0.962481,  0.953610,  0.953655,  0.957296,  0.953461,  0.944989,  0.950905,  0.947872,  0.944021,  0.941528,  0.944093,  0.943324,  0.933710,  0.932156,  0.936862,  0.936891,  0.923661,  0.927929,  0.930455,  0.925833,  0.914494,  0.925745,  0.921173,  0.915535,  0.911676,  0.920151,  0.916515,  0.903972,  0.901618,  0.911693,  0.912209,  0.889169,  0.904650,  0.901922,  0.901491,  0.886046,  0.896500,  0.896572,  0.884789,  0.882233,  0.894704,  0.890702,  0.876246,  0.873703,  0.886009,  0.886722,  0.852254,  0.881264,  0.874664,  0.871127,  0.864384,  0.866421,  0.872043,  0.855161,  0.850836,  0.870182,  0.865449,  0.846375,  0.842373,  0.863982,  0.861647,  0.816899,  0.855128,  0.848706,  0.841963,  0.837700,  0.843031,  0.842476,  0.827156,  0.825631,  0.842254,  0.840403,  0.811477,  0.816279,  0.836896,  0.828508,  0.795486,  0.826688, },
{ 1.000000,  0.998108,  0.996145,  0.994098,  0.992744,  0.990949,  0.987732,  0.985800,  0.985435,  0.983918,  0.979040,  0.979017,  0.977722,  0.975727,  0.970181,  0.973082,  0.969622,  0.966958,  0.964373,  0.966237,  0.963458,  0.957019,  0.955061,  0.957737,  0.957974,  0.945955,  0.951448,  0.950480,  0.948140,  0.939598,  0.943842,  0.943191,  0.937083,  0.933255,  0.939115,  0.937461,  0.926419,  0.925401,  0.930609,  0.931475,  0.909852,  0.926006,  0.921071,  0.918988,  0.913203,  0.914522,  0.916692,  0.905077,  0.901674,  0.914796,  0.908713,  0.896664,  0.892743,  0.906905,  0.904758,  0.875434,  0.899319,  0.892892,  0.888496,  0.885756,  0.888360,  0.886898,  0.876379,  0.872159,  0.886538,  0.883328,  0.863096,  0.864142,  0.879571,  0.873265,  0.846387,  0.870003,  0.866318,  0.857926,  0.855998,  0.863484,  0.861872,  0.843241,  0.843041,  0.855393,  0.856216,  0.831766,  0.841757,  0.847830,  0.842681,  0.820100,  0.843453,  0.836259,  0.829464,  0.823997,  0.837904,  0.834571,  0.812205,  0.809065,  0.828989,  0.833519,  0.793075,  0.818365,  0.820183,  0.815216, },
{ 1.000000,  0.997826,  0.996153,  0.994282,  0.991907,  0.989641,  0.988912,  0.986977,  0.983277,  0.981248,  0.981380,  0.979843,  0.972443,  0.975878,  0.972644,  0.971186,  0.967048,  0.967559,  0.965755,  0.960635,  0.958227,  0.961742,  0.958517,  0.952496,  0.949469,  0.953934,  0.953010,  0.936742,  0.948556,  0.943603,  0.940596,  0.938433,  0.938612,  0.936339,  0.930190,  0.927704,  0.934542,  0.930721,  0.920001,  0.918528,  0.926289,  0.923074,  0.904825,  0.919075,  0.915910,  0.910587,  0.907864,  0.911362,  0.909316,  0.898221,  0.896400,  0.904444,  0.902943,  0.887410,  0.890399,  0.897680,  0.891306,  0.877049,  0.890969,  0.885143,  0.881226,  0.873957,  0.886176,  0.882133,  0.864918,  0.864935,  0.875097,  0.878979,  0.850761,  0.865175,  0.868794,  0.863648,  0.844295,  0.861569,  0.857921,  0.847311,  0.844931,  0.856430,  0.855814,  0.834050,  0.833445,  0.850949,  0.848279,  0.810962,  0.842641,  0.835202,  0.835366,  0.818435,  0.832547,  0.829274,  0.815715,  0.808900,  0.834662,  0.823985,  0.805990,  0.802361,  0.821033,  0.824384,  0.771443,  0.817399, },
{ 1.000000,  0.997985,  0.995917,  0.993727,  0.991987,  0.990195,  0.987282,  0.985200,  0.984917,  0.982537,  0.978299,  0.976233,  0.977335,  0.974874,  0.966976,  0.970640,  0.968863,  0.964842,  0.962465,  0.963091,  0.960964,  0.954897,  0.953110,  0.955000,  0.953875,  0.945228,  0.945724,  0.948305,  0.944453,  0.934889,  0.941898,  0.936456,  0.935103,  0.929206,  0.935218,  0.932672,  0.921600,  0.921168,  0.925736,  0.926384,  0.910348,  0.916544,  0.918865,  0.913912,  0.902244,  0.911537,  0.908575,  0.902238,  0.899200,  0.904655,  0.904578,  0.889231,  0.888012,  0.899265,  0.896596,  0.871273,  0.891012,  0.886431,  0.887596,  0.869969,  0.882365,  0.879703,  0.867266,  0.864055,  0.881485,  0.873626,  0.858478,  0.856322,  0.868427,  0.871256,  0.832709,  0.863232,  0.856717,  0.851915,  0.846751,  0.850299,  0.848332,  0.836070,  0.835316,  0.850571,  0.845178,  0.828194,  0.819486,  0.843154,  0.841680,  0.795723,  0.830790,  0.831537,  0.818338,  0.815626,  0.822717,  0.822504,  0.803025,  0.801961,  0.818067,  0.815473,  0.791326,  0.794555,  0.813028,  0.803692, },
{ 1.000000,  0.997705,  0.995980,  0.993604,  0.991464,  0.988982,  0.988011,  0.986127,  0.981690,  0.979944,  0.979786,  0.978515,  0.971850,  0.972312,  0.972166,  0.968124,  0.963339,  0.965480,  0.962359,  0.958959,  0.956062,  0.957790,  0.956581,  0.947745,  0.945816,  0.950271,  0.948646,  0.934132,  0.943544,  0.939878,  0.939268,  0.929321,  0.933914,  0.932275,  0.924716,  0.921020,  0.930509,  0.924620,  0.915147,  0.913840,  0.918536,  0.919662,  0.895641,  0.913826,  0.909385,  0.905799,  0.899369,  0.902314,  0.900756,  0.890769,  0.890107,  0.898802,  0.896179,  0.882444,  0.876295,  0.892971,  0.887884,  0.857303,  0.881720,  0.880406,  0.872509,  0.869086,  0.871053,  0.871977,  0.857426,  0.856614,  0.866953,  0.866038,  0.843359,  0.847526,  0.861417,  0.852545,  0.832748,  0.851277,  0.845342,  0.837580,  0.834669,  0.843875,  0.844837,  0.821044,  0.823063,  0.835575,  0.837934,  0.808193,  0.819412,  0.830037,  0.817754,  0.798497,  0.824139,  0.813023,  0.804480,  0.801697,  0.814758,  0.815607,  0.786310,  0.785891,  0.808979,  0.807462,  0.763410,  0.799452, },
{ 1.000000,  0.997933,  0.995740,  0.992936,  0.991492,  0.989496,  0.986433,  0.983902,  0.983926,  0.981337,  0.976949,  0.974966,  0.975319,  0.973686,  0.964494,  0.969287,  0.965765,  0.963176,  0.959906,  0.959120,  0.957951,  0.951965,  0.949984,  0.953319,  0.950591,  0.943126,  0.939241,  0.945914,  0.942759,  0.925755,  0.936836,  0.935437,  0.930467,  0.927252,  0.927688,  0.925979,  0.918408,  0.916092,  0.922238,  0.920228,  0.905158,  0.906797,  0.914215,  0.908136,  0.894910,  0.905867,  0.901661,  0.895955,  0.893009,  0.897858,  0.897209,  0.882696,  0.881328,  0.889163,  0.889585,  0.869996,  0.877625,  0.881703,  0.874881,  0.859189,  0.876310,  0.869880,  0.862091,  0.857227,  0.869932,  0.864931,  0.847375,  0.845079,  0.859326,  0.860096,  0.828590,  0.850867,  0.847306,  0.846500,  0.826083,  0.840911,  0.841040,  0.825170,  0.822524,  0.839245,  0.834181,  0.815070,  0.812347,  0.828863,  0.829441,  0.784589,  0.823522,  0.814724,  0.809832,  0.801706,  0.804572,  0.812065,  0.790008,  0.785319,  0.810036,  0.804038,  0.779816,  0.775355,  0.802779,  0.799326, },
{ 1.000000,  0.997282,  0.995732,  0.993361,  0.990833,  0.988394,  0.986682,  0.984527,  0.980959,  0.978648,  0.978521,  0.976286,  0.970319,  0.968944,  0.970158,  0.966720,  0.959137,  0.962686,  0.960032,  0.955933,  0.953214,  0.954578,  0.952084,  0.944289,  0.942500,  0.945385,  0.944109,  0.933206,  0.936236,  0.935713,  0.932969,  0.922050,  0.931059,  0.925374,  0.921146,  0.917708,  0.923257,  0.918908,  0.907855,  0.905870,  0.912056,  0.913383,  0.893052,  0.904117,  0.903461,  0.900124,  0.886728,  0.894906,  0.894756,  0.885273,  0.880230,  0.890310,  0.888240,  0.871660,  0.871088,  0.879830,  0.881307,  0.849324,  0.874585,  0.867743,  0.864695,  0.856969,  0.859578,  0.863089,  0.846580,  0.842581,  0.861545,  0.853262,  0.836618,  0.831793,  0.852156,  0.848947,  0.808820,  0.842496,  0.834118,  0.827778,  0.824809,  0.828593,  0.826969,  0.812698,  0.808007,  0.827196,  0.823149,  0.796207,  0.798410,  0.818971,  0.810385,  0.775647,  0.807001,  0.802534,  0.791190,  0.789220,  0.799292,  0.797229,  0.773174,  0.773669,  0.789457,  0.790406,  0.759223,  0.772728, },
{ 1.000000,  0.997725,  0.995345,  0.992396,  0.991084,  0.988490,  0.985780,  0.983128,  0.982333,  0.979900,  0.975248,  0.972682,  0.973270,  0.971833,  0.963670,  0.965678,  0.963953,  0.961097,  0.954582,  0.957156,  0.954357,  0.949617,  0.946451,  0.949537,  0.946627,  0.938354,  0.936227,  0.940301,  0.938477,  0.922178,  0.933707,  0.928391,  0.926709,  0.919803,  0.922910,  0.920798,  0.911913,  0.909021,  0.917320,  0.912410,  0.902334,  0.898513,  0.907706,  0.906786,  0.879761,  0.901376,  0.893952,  0.889597,  0.886995,  0.888201,  0.885502,  0.876342,  0.873411,  0.884746,  0.879352,  0.863575,  0.862384,  0.874637,  0.869980,  0.843813,  0.865571,  0.861431,  0.853929,  0.850660,  0.856280,  0.853704,  0.838295,  0.836483,  0.848187,  0.846319,  0.824888,  0.830091,  0.840272,  0.831252,  0.812671,  0.832237,  0.824354,  0.819142,  0.809903,  0.826901,  0.821449,  0.798615,  0.799257,  0.813254,  0.818050,  0.780991,  0.800988,  0.805753,  0.798589,  0.774002,  0.796954,  0.792365,  0.778371,  0.775977,  0.791167,  0.790255,  0.762388,  0.762119,  0.784877,  0.780997, },
{ 1.000000,  0.997260,  0.995392,  0.992879,  0.990567,  0.987320,  0.985984,  0.983517,  0.980025,  0.977075,  0.977752,  0.974361,  0.969832,  0.967020,  0.967756,  0.966175,  0.955072,  0.961247,  0.956943,  0.954127,  0.950769,  0.950253,  0.948323,  0.942121,  0.939952,  0.943516,  0.939779,  0.930863,  0.928772,  0.934638,  0.930733,  0.914369,  0.925359,  0.923431,  0.916623,  0.913661,  0.916681,  0.913855,  0.903610,  0.901910,  0.906670,  0.905677,  0.891363,  0.893800,  0.899381,  0.893456,  0.878683,  0.891419,  0.883446,  0.881805,  0.873304,  0.883858,  0.880485,  0.863888,  0.864179,  0.871992,  0.873370,  0.849628,  0.859988,  0.864025,  0.856937,  0.840554,  0.854777,  0.850991,  0.842189,  0.838455,  0.846774,  0.846932,  0.825645,  0.824640,  0.841021,  0.837346,  0.802547,  0.830878,  0.824709,  0.826069,  0.802706,  0.820173,  0.816775,  0.800187,  0.796392,  0.820200,  0.809762,  0.789805,  0.787406,  0.803968,  0.807185,  0.756872,  0.797722,  0.789396,  0.782754,  0.776677,  0.781614,  0.779177,  0.763240,  0.762894,  0.782747,  0.775810,  0.754032,  0.743601, },
{ 1.000000,  0.997702,  0.995264,  0.991292,  0.990323,  0.987981,  0.984773,  0.982255,  0.980625,  0.978301,  0.973868,  0.971470,  0.971283,  0.968785,  0.962894,  0.961187,  0.962244,  0.958367,  0.951111,  0.954279,  0.950196,  0.947410,  0.943018,  0.945374,  0.943394,  0.933158,  0.932164,  0.935420,  0.934781,  0.920380,  0.924999,  0.927001,  0.919718,  0.911501,  0.918238,  0.913687,  0.908533,  0.904582,  0.909409,  0.908442,  0.893711,  0.891727,  0.900921,  0.899016,  0.875065,  0.892633,  0.887467,  0.887131,  0.871845,  0.880410,  0.878765,  0.867367,  0.862583,  0.878192,  0.869749,  0.855954,  0.854879,  0.862814,  0.864636,  0.829900,  0.857708,  0.851632,  0.846491,  0.838111,  0.843151,  0.841280,  0.827371,  0.827233,  0.839805,  0.836655,  0.817795,  0.809857,  0.833485,  0.826422,  0.785177,  0.819080,  0.817812,  0.807139,  0.802797,  0.806136,  0.807614,  0.788208,  0.787798,  0.801909,  0.800721,  0.770945,  0.777296,  0.795757,  0.783611,  0.758718,  0.783173,  0.775620,  0.765569,  0.762159,  0.774428,  0.775830,  0.745279,  0.748443,  0.764583,  0.767528, },
{ 1.000000,  0.997152,  0.994811,  0.992613,  0.989691,  0.986010,  0.985212,  0.982064,  0.978816,  0.976216,  0.975299,  0.973249,  0.967001,  0.964514,  0.965820,  0.963347,  0.953615,  0.957837,  0.954611,  0.952330,  0.944693,  0.946850,  0.944732,  0.938557,  0.934892,  0.939768,  0.935462,  0.926524,  0.924729,  0.928772,  0.927329,  0.907976,  0.921721,  0.916008,  0.912448,  0.907605,  0.907925,  0.907175,  0.897265,  0.895207,  0.902798,  0.899321,  0.886913,  0.881574,  0.894469,  0.889987,  0.862217,  0.882055,  0.880817,  0.873433,  0.869323,  0.870853,  0.869059,  0.857800,  0.855200,  0.865565,  0.863052,  0.840521,  0.844243,  0.855948,  0.847225,  0.828574,  0.845353,  0.839955,  0.831878,  0.828352,  0.835786,  0.835602,  0.815094,  0.813920,  0.825491,  0.826335,  0.799342,  0.810793,  0.816882,  0.807400,  0.786414,  0.810498,  0.802046,  0.791739,  0.785535,  0.803012,  0.796687,  0.773165,  0.770856,  0.790337,  0.791153,  0.749512,  0.779896,  0.775538,  0.774093,  0.747718,  0.767726,  0.768058,  0.747446,  0.744360,  0.766552,  0.760000,  0.735271,  0.732334, },
{ 1.000000,  0.997447,  0.995077,  0.990919,  0.989949,  0.987095,  0.984218,  0.981060,  0.978973,  0.977310,  0.972343,  0.969443,  0.970301,  0.967183,  0.961266,  0.958142,  0.960544,  0.957779,  0.944911,  0.952111,  0.948506,  0.944285,  0.941090,  0.940571,  0.938344,  0.931292,  0.929129,  0.932332,  0.929648,  0.917566,  0.917650,  0.922878,  0.917447,  0.903551,  0.913495,  0.909842,  0.903433,  0.900203,  0.904254,  0.901183,  0.888470,  0.887042,  0.893298,  0.892318,  0.874860,  0.881518,  0.881735,  0.877969,  0.861578,  0.877258,  0.869001,  0.863199,  0.858961,  0.868321,  0.862404,  0.846443,  0.844567,  0.854415,  0.856959,  0.827671,  0.845063,  0.844495,  0.840040,  0.821715,  0.834214,  0.834380,  0.821377,  0.815279,  0.829789,  0.827197,  0.804800,  0.804711,  0.817238,  0.819377,  0.776412,  0.811576,  0.802565,  0.798373,  0.788818,  0.792918,  0.797724,  0.776021,  0.771600,  0.796864,  0.786056,  0.764637,  0.759033,  0.785745,  0.781450,  0.730081,  0.774094,  0.763620,  0.755286,  0.752124,  0.757217,  0.755338,  0.737260,  0.732180,  0.756452,  0.751468, },
{ 1.000000,  0.997076,  0.994287,  0.992147,  0.989224,  0.984579,  0.984009,  0.981182,  0.977614,  0.974751,  0.973438,  0.970818,  0.965160,  0.962772,  0.962631,  0.960451,  0.952740,  0.952866,  0.952038,  0.948114,  0.940068,  0.944286,  0.940064,  0.935696,  0.932049,  0.934194,  0.930956,  0.921389,  0.918373,  0.923170,  0.922361,  0.905611,  0.913372,  0.911912,  0.907580,  0.896294,  0.903614,  0.899985,  0.892469,  0.888133,  0.895578,  0.891592,  0.878061,  0.876007,  0.884345,  0.882275,  0.855588,  0.876705,  0.868625,  0.866727,  0.856838,  0.862959,  0.860405,  0.847038,  0.843691,  0.857538,  0.850716,  0.835968,  0.831045,  0.845778,  0.844818,  0.805516,  0.838359,  0.828003,  0.821998,  0.819208,  0.821542,  0.818213,  0.805353,  0.802250,  0.818699,  0.811614,  0.789635,  0.788951,  0.806489,  0.800115,  0.764785,  0.795139,  0.790099,  0.779781,  0.775980,  0.783929,  0.780846,  0.760449,  0.758585,  0.774678,  0.772227,  0.743822,  0.751853,  0.765368,  0.753266,  0.729439,  0.755629,  0.745640,  0.738871,  0.727313,  0.749555,  0.742802,  0.713323,  0.714754, },
{ 1.000000,  0.997313,  0.994649,  0.990710,  0.988834,  0.986353,  0.983274,  0.978687,  0.977989,  0.975056,  0.970924,  0.967938,  0.967503,  0.965030,  0.958181,  0.955676,  0.957199,  0.954175,  0.942612,  0.948543,  0.944232,  0.941643,  0.934826,  0.936842,  0.933525,  0.926937,  0.922746,  0.928945,  0.923141,  0.914756,  0.911445,  0.916204,  0.914967,  0.892881,  0.908912,  0.902022,  0.898044,  0.893598,  0.894472,  0.892429,  0.882450,  0.880371,  0.888121,  0.882881,  0.868592,  0.866593,  0.877782,  0.872122,  0.846347,  0.865684,  0.863660,  0.853577,  0.849950,  0.855689,  0.852383,  0.837293,  0.835801,  0.843966,  0.842980,  0.822216,  0.827124,  0.835816,  0.827487,  0.807016,  0.826095,  0.815385,  0.813376,  0.801968,  0.817682,  0.813409,  0.790373,  0.791593,  0.803122,  0.805135,  0.772765,  0.788212,  0.793822,  0.784382,  0.762767,  0.782753,  0.778068,  0.766451,  0.761894,  0.773589,  0.774069,  0.746026,  0.745300,  0.767417,  0.762629,  0.717004,  0.755286,  0.747109,  0.748741,  0.719013,  0.742242,  0.737876,  0.716572,  0.712280,  0.743144,  0.729863, },
{ 1.000000,  0.996886,  0.993941,  0.991577,  0.988988,  0.983374,  0.983224,  0.979995,  0.976608,  0.973275,  0.971287,  0.968350,  0.963506,  0.960949,  0.961379,  0.957789,  0.951590,  0.947135,  0.950570,  0.947556,  0.933037,  0.940314,  0.938226,  0.931829,  0.928841,  0.928797,  0.926461,  0.917705,  0.915208,  0.918696,  0.915418,  0.904167,  0.903735,  0.908505,  0.902142,  0.889464,  0.898417,  0.892142,  0.888556,  0.882242,  0.888376,  0.886208,  0.869369,  0.869371,  0.876352,  0.876517,  0.853377,  0.862663,  0.866873,  0.856172,  0.844024,  0.856098,  0.849901,  0.842559,  0.837562,  0.846055,  0.845253,  0.823623,  0.821654,  0.836386,  0.834081,  0.799269,  0.826511,  0.819372,  0.819170,  0.798286,  0.811249,  0.809292,  0.793784,  0.787748,  0.810241,  0.798953,  0.780132,  0.779549,  0.790962,  0.793718,  0.746669,  0.785544,  0.777634,  0.770636,  0.760086,  0.767304,  0.765322,  0.746671,  0.747235,  0.764547,  0.760572,  0.735754,  0.726236,  0.757489,  0.748202,  0.694865,  0.739586,  0.738340,  0.724283,  0.719136,  0.724060,  0.725978,  0.701238,  0.701335, },
{ 1.000000,  0.997090,  0.994227,  0.990443,  0.987685,  0.985841,  0.982230,  0.977382,  0.976872,  0.973408,  0.969507,  0.966335,  0.965291,  0.963079,  0.955752,  0.953584,  0.953726,  0.951748,  0.942164,  0.942648,  0.942875,  0.936940,  0.929179,  0.934285,  0.928703,  0.923572,  0.920381,  0.922436,  0.920424,  0.908007,  0.905747,  0.911832,  0.908905,  0.889852,  0.902108,  0.897672,  0.894830,  0.882129,  0.888251,  0.886267,  0.876572,  0.871680,  0.882004,  0.875745,  0.861804,  0.860242,  0.868552,  0.867189,  0.836452,  0.860644,  0.852326,  0.847593,  0.841247,  0.842709,  0.842781,  0.828114,  0.826343,  0.838688,  0.834127,  0.816536,  0.809573,  0.829449,  0.823148,  0.783760,  0.813601,  0.812428,  0.802335,  0.797145,  0.800071,  0.798238,  0.782836,  0.780305,  0.795004,  0.791985,  0.761353,  0.767580,  0.784043,  0.772041,  0.747790,  0.770847,  0.764237,  0.753642,  0.749447,  0.759811,  0.759956,  0.733107,  0.732526,  0.747863,  0.749203,  0.714015,  0.730100,  0.738203,  0.725665,  0.699256,  0.730795,  0.720281,  0.706941,  0.699589,  0.722274,  0.714385, },
{ 1.000000,  0.996762,  0.993555,  0.991169,  0.988370,  0.983037,  0.981983,  0.978816,  0.975885,  0.970402,  0.969786,  0.967118,  0.961647,  0.958447,  0.959111,  0.955554,  0.948507,  0.945337,  0.946870,  0.944396,  0.929966,  0.938362,  0.933356,  0.929245,  0.924532,  0.923131,  0.923050,  0.913081,  0.909419,  0.915655,  0.911326,  0.900027,  0.896226,  0.904534,  0.900672,  0.876427,  0.893618,  0.888369,  0.882160,  0.878235,  0.878906,  0.876722,  0.865581,  0.863498,  0.870629,  0.867497,  0.847811,  0.849856,  0.859855,  0.851698,  0.830685,  0.847807,  0.843193,  0.834097,  0.830059,  0.837377,  0.833745,  0.814796,  0.814007,  0.824254,  0.823461,  0.798273,  0.809393,  0.810333,  0.805316,  0.782605,  0.805968,  0.794735,  0.787000,  0.781644,  0.795663,  0.788119,  0.765965,  0.764382,  0.778678,  0.782429,  0.742473,  0.767558,  0.766859,  0.761092,  0.736993,  0.754407,  0.755217,  0.737969,  0.730460,  0.750184,  0.747323,  0.717450,  0.718151,  0.735345,  0.738042,  0.681851,  0.729256,  0.717388,  0.711831,  0.700169,  0.705858,  0.712308,  0.684362,  0.679306, },
{ 1.000000,  0.997091,  0.993819,  0.990071,  0.986696,  0.985083,  0.981980,  0.974725,  0.975751,  0.971914,  0.967964,  0.964813,  0.962700,  0.959631,  0.954063,  0.950405,  0.951868,  0.948459,  0.939108,  0.937260,  0.940063,  0.934926,  0.922781,  0.929228,  0.925544,  0.919458,  0.916368,  0.917360,  0.914352,  0.903472,  0.901501,  0.904779,  0.902651,  0.888504,  0.891721,  0.892391,  0.886922,  0.873420,  0.883835,  0.877785,  0.871397,  0.866779,  0.872417,  0.868355,  0.853351,  0.849894,  0.859366,  0.859483,  0.833207,  0.847506,  0.846200,  0.840186,  0.823865,  0.836527,  0.831977,  0.821397,  0.815952,  0.828067,  0.823270,  0.803828,  0.802016,  0.814913,  0.812492,  0.774991,  0.806457,  0.795402,  0.793185,  0.780102,  0.789492,  0.786598,  0.768494,  0.764868,  0.784377,  0.775592,  0.756041,  0.750108,  0.770712,  0.769521,  0.717230,  0.762240,  0.748849,  0.740963,  0.738111,  0.741455,  0.737702,  0.721052,  0.717917,  0.739542,  0.730609,  0.702095,  0.702529,  0.725367,  0.717045,  0.672245,  0.711685,  0.705606,  0.692484,  0.688138,  0.698634,  0.694934, },
{ 1.000000,  0.996542,  0.993283,  0.990549,  0.987352,  0.982547,  0.980048,  0.978021,  0.973898,  0.968401,  0.968408,  0.964260,  0.960376,  0.955823,  0.956433,  0.952609,  0.944656,  0.942018,  0.942779,  0.941297,  0.928648,  0.931756,  0.930483,  0.925578,  0.915591,  0.920208,  0.916416,  0.909038,  0.905793,  0.908599,  0.906037,  0.893168,  0.890846,  0.897055,  0.893137,  0.871763,  0.886621,  0.880034,  0.877355,  0.866489,  0.872249,  0.868099,  0.858002,  0.852401,  0.864916,  0.856308,  0.843524,  0.839867,  0.848975,  0.847930,  0.813843,  0.841043,  0.830971,  0.825761,  0.820291,  0.822573,  0.820650,  0.806087,  0.804432,  0.816868,  0.809943,  0.789314,  0.787984,  0.804926,  0.797123,  0.761000,  0.789877,  0.787491,  0.773638,  0.769528,  0.778273,  0.774218,  0.753741,  0.752537,  0.764448,  0.763766,  0.735410,  0.743229,  0.755584,  0.744384,  0.717561,  0.743927,  0.730116,  0.727589,  0.713210,  0.734452,  0.729370,  0.699165,  0.701421,  0.716799,  0.719987,  0.677766,  0.698924,  0.706346,  0.694397,  0.666722,  0.693304,  0.687390,  0.672624,  0.667457, },
{ 1.000000,  0.996740,  0.993565,  0.989366,  0.985966,  0.984144,  0.980773,  0.973935,  0.974200,  0.970313,  0.967503,  0.960845,  0.960868,  0.957333,  0.951301,  0.947621,  0.949999,  0.944885,  0.937161,  0.933900,  0.935517,  0.933624,  0.916838,  0.926286,  0.921037,  0.916121,  0.911786,  0.910842,  0.907518,  0.899235,  0.896843,  0.901572,  0.896668,  0.885712,  0.879568,  0.889132,  0.885427,  0.859457,  0.875837,  0.873976,  0.864355,  0.860791,  0.862651,  0.860341,  0.846638,  0.844343,  0.851507,  0.847581,  0.830585,  0.831645,  0.840459,  0.831437,  0.812816,  0.828241,  0.819573,  0.814966,  0.806652,  0.816940,  0.814735,  0.790655,  0.791792,  0.802887,  0.803932,  0.771038,  0.785934,  0.792428,  0.777913,  0.761661,  0.779539,  0.771422,  0.761895,  0.755718,  0.768180,  0.767747,  0.738517,  0.736967,  0.757536,  0.754679,  0.708232,  0.745947,  0.736582,  0.736691,  0.709481,  0.727633,  0.725361,  0.705158,  0.698171,  0.728033,  0.713582,  0.689305,  0.689304,  0.704459,  0.708460,  0.647987,  0.699125,  0.689054,  0.679894,  0.667302,  0.676975,  0.674564, },
{ 1.000000,  0.996449,  0.992994,  0.990243,  0.986771,  0.982116,  0.978163,  0.977405,  0.973561,  0.964965,  0.966535,  0.963397,  0.958533,  0.954805,  0.952591,  0.949999,  0.942644,  0.939792,  0.940322,  0.937319,  0.926579,  0.925786,  0.927966,  0.921586,  0.911584,  0.916565,  0.911507,  0.905489,  0.901675,  0.903415,  0.901468,  0.887678,  0.886543,  0.890133,  0.888709,  0.871072,  0.875228,  0.878040,  0.868830,  0.856606,  0.868447,  0.859715,  0.852546,  0.848981,  0.854369,  0.852534,  0.832862,  0.830958,  0.842446,  0.838971,  0.809671,  0.830872,  0.824905,  0.821430,  0.803217,  0.814037,  0.811771,  0.798212,  0.792260,  0.808452,  0.800143,  0.780335,  0.779397,  0.792366,  0.791096,  0.747819,  0.783499,  0.772196,  0.766214,  0.758308,  0.761320,  0.761829,  0.741915,  0.740660,  0.758195,  0.752661,  0.728944,  0.720576,  0.747963,  0.739765,  0.687454,  0.728385,  0.727263,  0.714210,  0.707914,  0.712433,  0.710477,  0.690354,  0.688123,  0.707678,  0.703937,  0.664242,  0.673430,  0.695056,  0.679438,  0.649173,  0.679480,  0.670827,  0.657533,  0.652923, },
{ 1.000000,  0.996641,  0.993370,  0.989144,  0.985842,  0.983362,  0.980285,  0.974314,  0.972477,  0.970123,  0.965627,  0.959508,  0.960465,  0.955974,  0.950975,  0.946822,  0.947614,  0.943419,  0.935116,  0.931781,  0.933869,  0.931337,  0.916976,  0.923216,  0.919043,  0.915975,  0.905269,  0.909028,  0.906474,  0.896843,  0.893328,  0.898507,  0.893910,  0.882151,  0.878747,  0.884557,  0.882062,  0.856787,  0.875544,  0.868135,  0.862709,  0.856483,  0.856026,  0.857796,  0.842534,  0.838626,  0.850340,  0.844771,  0.828001,  0.823656,  0.838000,  0.833036,  0.797369,  0.825113,  0.818289,  0.809987,  0.805454,  0.807455,  0.805237,  0.790057,  0.788417,  0.799370,  0.795788,  0.768786,  0.773124,  0.787653,  0.776917,  0.749041,  0.773495,  0.767736,  0.755930,  0.751383,  0.761801,  0.757720,  0.733106,  0.733121,  0.747176,  0.746503,  0.713734,  0.729500,  0.731253,  0.724833,  0.696155,  0.727159,  0.713163,  0.703539,  0.697320,  0.715972,  0.706690,  0.678715,  0.677634,  0.696029,  0.700889,  0.650708,  0.683971,  0.682850,  0.675827,  0.646436,  0.668640,  0.669770, },
{ 1.000000,  0.996235,  0.992561,  0.989619,  0.986096,  0.980909,  0.977550,  0.975469,  0.972420,  0.963253,  0.965347,  0.960624,  0.956604,  0.951736,  0.949549,  0.947469,  0.939511,  0.935460,  0.938660,  0.933107,  0.924277,  0.919911,  0.924736,  0.920493,  0.901913,  0.913025,  0.906941,  0.901190,  0.897566,  0.896442,  0.893369,  0.883748,  0.879559,  0.885894,  0.881648,  0.865127,  0.864476,  0.872412,  0.865045,  0.844446,  0.859019,  0.854189,  0.845231,  0.842030,  0.845480,  0.841924,  0.825429,  0.823969,  0.830742,  0.828857,  0.807375,  0.814540,  0.816613,  0.809053,  0.789810,  0.807211,  0.798874,  0.790320,  0.784780,  0.794426,  0.789276,  0.767880,  0.764478,  0.779055,  0.779869,  0.742908,  0.764958,  0.763526,  0.755738,  0.733684,  0.752601,  0.746926,  0.732650,  0.726268,  0.743652,  0.737702,  0.711583,  0.710166,  0.728453,  0.725555,  0.675370,  0.719091,  0.704476,  0.701699,  0.685332,  0.698298,  0.695171,  0.671568,  0.667577,  0.693755,  0.682734,  0.657295,  0.650653,  0.677664,  0.676311,  0.609352,  0.668283,  0.651292,  0.641308,  0.638380, },
{ 1.000000,  0.996338,  0.992665,  0.988299,  0.984505,  0.982194,  0.978241,  0.972435,  0.968978,  0.967704,  0.963493,  0.954543,  0.956432,  0.952343,  0.946932,  0.942997,  0.941660,  0.937935,  0.929862,  0.926312,  0.927436,  0.923888,  0.912653,  0.912464,  0.913500,  0.906510,  0.896150,  0.902018,  0.895812,  0.890548,  0.883726,  0.889030,  0.883986,  0.869882,  0.867908,  0.872215,  0.872063,  0.849675,  0.858977,  0.858530,  0.851698,  0.835783,  0.846410,  0.841568,  0.830718,  0.827249,  0.833696,  0.830882,  0.811227,  0.809535,  0.821045,  0.815834,  0.783352,  0.808799,  0.799600,  0.796516,  0.781370,  0.791403,  0.786331,  0.772109,  0.765288,  0.784744,  0.773068,  0.755162,  0.751317,  0.765445,  0.764696,  0.716748,  0.756845,  0.743254,  0.736693,  0.729991,  0.734055,  0.732002,  0.712619,  0.711420,  0.728989,  0.720397,  0.692619,  0.692036,  0.715412,  0.705355,  0.657785,  0.697048,  0.694407,  0.676604,  0.671973,  0.683978,  0.679194,  0.652638,  0.652056,  0.667929,  0.667554,  0.630865,  0.642322,  0.658159,  0.643887,  0.610303,  0.644844,  0.627307, },
{ 1.000000,  0.996215,  0.992016,  0.989035,  0.985329,  0.979850,  0.976341,  0.974031,  0.970774,  0.963023,  0.961972,  0.959306,  0.954462,  0.947174,  0.947710,  0.943566,  0.937814,  0.933484,  0.933241,  0.930385,  0.919692,  0.916640,  0.919804,  0.915350,  0.898482,  0.907873,  0.901883,  0.899583,  0.886813,  0.891962,  0.887605,  0.876897,  0.872670,  0.881567,  0.873718,  0.860736,  0.857513,  0.863465,  0.862290,  0.832754,  0.853103,  0.845661,  0.838985,  0.833439,  0.833901,  0.830191,  0.817833,  0.815988,  0.825186,  0.818680,  0.802412,  0.794679,  0.811115,  0.806562,  0.767731,  0.794464,  0.792889,  0.779350,  0.775097,  0.779223,  0.776965,  0.757661,  0.755823,  0.767239,  0.762485,  0.738485,  0.741760,  0.754942,  0.742800,  0.717755,  0.740450,  0.729134,  0.723509,  0.712775,  0.727619,  0.725456,  0.692972,  0.695786,  0.711507,  0.713416,  0.669520,  0.691162,  0.699847,  0.680954,  0.660118,  0.684617,  0.674418,  0.662423,  0.654891,  0.671905,  0.671766,  0.633673,  0.632899,  0.659866,  0.656551,  0.596861,  0.646725,  0.634708,  0.635274,  0.600922, },
{ 1.000000,  0.996095,  0.992367,  0.987819,  0.983544,  0.981605,  0.977051,  0.971344,  0.967781,  0.965622,  0.962569,  0.951667,  0.954820,  0.949937,  0.945219,  0.939786,  0.938025,  0.934404,  0.926519,  0.923543,  0.924895,  0.920814,  0.910446,  0.904938,  0.911052,  0.905172,  0.885152,  0.896851,  0.893402,  0.885677,  0.880947,  0.879857,  0.877817,  0.865388,  0.862930,  0.867253,  0.863982,  0.845298,  0.847107,  0.853795,  0.844122,  0.828423,  0.839690,  0.832664,  0.824282,  0.819930,  0.824710,  0.823320,  0.802014,  0.802095,  0.809451,  0.808604,  0.782070,  0.790765,  0.796080,  0.783138,  0.765905,  0.785231,  0.773370,  0.763902,  0.759727,  0.768795,  0.767266,  0.739286,  0.738240,  0.755687,  0.751580,  0.710348,  0.742191,  0.734117,  0.730188,  0.705856,  0.721812,  0.719329,  0.701430,  0.694165,  0.717067,  0.706657,  0.680056,  0.679957,  0.698102,  0.696844,  0.639083,  0.688507,  0.673625,  0.666183,  0.656429,  0.661141,  0.662266,  0.636640,  0.636035,  0.659144,  0.652715,  0.621867,  0.612046,  0.648127,  0.637778,  0.570616,  0.624326,  0.623135, },
{ 1.000000,  0.995970,  0.991862,  0.988080,  0.984182,  0.979190,  0.974969,  0.972761,  0.968879,  0.961056,  0.958357,  0.957375,  0.951769,  0.943848,  0.944913,  0.940088,  0.934333,  0.930036,  0.929081,  0.926003,  0.915487,  0.912306,  0.913290,  0.910617,  0.896645,  0.898897,  0.898217,  0.890901,  0.878982,  0.887179,  0.880081,  0.872195,  0.866632,  0.872345,  0.866551,  0.851561,  0.848211,  0.855509,  0.853136,  0.827622,  0.842759,  0.837078,  0.833172,  0.815977,  0.825161,  0.822510,  0.807690,  0.803667,  0.814349,  0.808108,  0.789989,  0.786389,  0.797492,  0.794704,  0.755503,  0.787191,  0.776497,  0.769368,  0.761013,  0.761857,  0.765686,  0.743446,  0.738851,  0.757547,  0.750429,  0.726153,  0.721146,  0.743255,  0.736892,  0.685534,  0.727134,  0.718091,  0.707083,  0.701485,  0.705300,  0.703015,  0.681949,  0.680731,  0.696737,  0.692632,  0.655228,  0.662846,  0.683342,  0.668768,  0.631336,  0.665938,  0.658593,  0.643031,  0.637367,  0.652171,  0.647064,  0.614227,  0.615511,  0.634665,  0.634347,  0.590680,  0.613120,  0.615514,  0.607293,  0.569832, },
{ 1.000000,  0.996097,  0.991729,  0.987438,  0.983155,  0.980222,  0.975889,  0.969751,  0.965798,  0.963773,  0.960769,  0.950706,  0.951467,  0.947709,  0.943138,  0.934524,  0.934941,  0.931745,  0.924016,  0.918906,  0.920719,  0.916832,  0.904898,  0.902028,  0.904083,  0.901575,  0.880231,  0.893264,  0.885745,  0.880624,  0.873690,  0.872693,  0.872107,  0.858508,  0.853694,  0.863572,  0.855501,  0.841139,  0.835874,  0.847560,  0.842206,  0.810685,  0.833549,  0.824724,  0.816802,  0.812902,  0.813106,  0.809500,  0.795514,  0.790962,  0.802881,  0.797434,  0.772731,  0.773925,  0.787475,  0.777366,  0.747469,  0.771169,  0.765176,  0.752870,  0.749370,  0.755895,  0.751821,  0.728782,  0.728087,  0.738842,  0.737324,  0.707161,  0.719159,  0.722762,  0.712898,  0.686845,  0.712546,  0.701532,  0.690599,  0.683874,  0.698021,  0.691808,  0.663429,  0.659892,  0.680154,  0.681979,  0.632974,  0.663765,  0.662062,  0.652491,  0.623974,  0.649766,  0.642782,  0.624573,  0.617234,  0.640279,  0.633370,  0.599552,  0.598966,  0.622890,  0.619477,  0.555218,  0.612986,  0.593793, },
{ 1.000000,  0.995724,  0.991315,  0.987523,  0.983316,  0.978029,  0.973581,  0.971633,  0.966973,  0.960432,  0.955687,  0.955289,  0.951396,  0.937930,  0.943297,  0.936867,  0.931415,  0.927444,  0.924728,  0.920338,  0.912472,  0.908387,  0.910923,  0.905329,  0.893013,  0.890215,  0.894284,  0.888207,  0.869682,  0.880550,  0.875129,  0.867091,  0.862526,  0.863488,  0.859022,  0.845834,  0.842509,  0.847696,  0.843755,  0.825083,  0.828067,  0.832131,  0.822111,  0.806459,  0.818980,  0.810208,  0.803367,  0.794397,  0.804953,  0.798502,  0.777387,  0.776141,  0.784895,  0.785990,  0.752585,  0.769139,  0.769373,  0.760260,  0.738179,  0.755492,  0.749333,  0.734699,  0.730935,  0.741582,  0.738681,  0.711263,  0.710358,  0.727706,  0.721319,  0.676387,  0.713874,  0.701382,  0.697837,  0.678055,  0.693202,  0.686787,  0.668256,  0.660050,  0.686932,  0.672177,  0.648631,  0.644626,  0.664265,  0.663586,  0.600789,  0.655295,  0.637547,  0.629205,  0.621572,  0.627494,  0.625373,  0.600689,  0.600213,  0.623112,  0.612734,  0.577233,  0.577733,  0.608001,  0.595292,  0.535052, },
{ 1.000000,  0.995749,  0.991538,  0.986580,  0.982135,  0.978682,  0.974374,  0.968194,  0.963821,  0.961445,  0.957580,  0.949090,  0.946763,  0.944992,  0.939052,  0.929808,  0.932006,  0.925036,  0.920754,  0.913615,  0.915827,  0.910999,  0.898668,  0.896035,  0.897275,  0.894930,  0.877799,  0.881860,  0.880810,  0.873466,  0.860308,  0.867076,  0.861449,  0.852601,  0.847511,  0.850607,  0.847972,  0.829792,  0.827177,  0.836113,  0.830561,  0.801760,  0.821855,  0.813412,  0.811563,  0.791675,  0.802919,  0.797303,  0.781686,  0.776775,  0.793017,  0.782051,  0.762783,  0.759663,  0.770823,  0.770265,  0.725824,  0.759246,  0.749013,  0.740058,  0.733419,  0.735347,  0.730889,  0.714087,  0.712868,  0.727025,  0.718913,  0.696262,  0.686719,  0.711362,  0.705407,  0.651456,  0.690712,  0.689199,  0.671164,  0.666122,  0.672951,  0.670455,  0.644920,  0.643556,  0.659581,  0.654134,  0.621856,  0.627969,  0.646253,  0.630033,  0.597446,  0.629152,  0.614379,  0.607209,  0.593927,  0.614287,  0.611902,  0.569845,  0.574473,  0.595467,  0.598460,  0.541621,  0.571270,  0.582403, },
{ 1.000000,  0.995559,  0.990521,  0.986992,  0.982370,  0.977306,  0.972592,  0.969856,  0.965947,  0.957850,  0.953670,  0.953018,  0.948637,  0.936096,  0.939895,  0.933967,  0.930368,  0.920456,  0.921264,  0.916900,  0.908003,  0.902653,  0.907410,  0.899976,  0.888988,  0.885638,  0.887109,  0.885138,  0.860942,  0.875845,  0.868863,  0.862148,  0.854346,  0.854959,  0.850829,  0.838048,  0.835990,  0.841706,  0.836857,  0.820155,  0.812953,  0.826755,  0.818848,  0.785756,  0.808985,  0.805273,  0.794070,  0.788390,  0.788744,  0.787101,  0.768962,  0.767102,  0.775489,  0.772190,  0.744644,  0.749308,  0.760942,  0.747780,  0.725362,  0.744018,  0.734934,  0.723542,  0.718682,  0.727097,  0.726031,  0.696439,  0.698203,  0.709596,  0.709433,  0.672850,  0.686700,  0.694788,  0.677842,  0.654816,  0.682722,  0.667257,  0.655106,  0.650336,  0.663718,  0.662397,  0.625227,  0.625153,  0.649136,  0.644419,  0.589793,  0.633642,  0.623319,  0.618677,  0.587382,  0.609484,  0.606783,  0.583744,  0.575294,  0.605643,  0.592603,  0.558623,  0.559731,  0.583325,  0.582244,  0.508471, },
{ 1.000000,  0.995562,  0.990819,  0.986094,  0.981349,  0.977197,  0.972958,  0.966531,  0.962114,  0.960242,  0.955507,  0.947509,  0.942181,  0.943276,  0.937808,  0.922669,  0.927867,  0.923825,  0.916839,  0.911662,  0.909188,  0.905031,  0.895439,  0.891327,  0.893553,  0.889042,  0.872247,  0.872414,  0.876169,  0.867090,  0.852912,  0.860766,  0.854132,  0.845557,  0.840509,  0.842854,  0.840092,  0.822388,  0.819784,  0.824618,  0.822435,  0.799390,  0.806753,  0.807871,  0.797294,  0.779152,  0.795656,  0.785889,  0.774801,  0.767786,  0.779071,  0.771624,  0.749343,  0.746213,  0.759194,  0.757048,  0.719091,  0.744607,  0.737063,  0.732806,  0.708571,  0.723757,  0.720902,  0.700460,  0.696020,  0.712752,  0.705046,  0.679889,  0.676296,  0.693025,  0.690358,  0.636019,  0.682151,  0.667832,  0.658900,  0.648328,  0.650687,  0.656601,  0.626781,  0.621909,  0.648057,  0.639475,  0.607389,  0.601891,  0.632162,  0.624321,  0.556448,  0.612714,  0.601543,  0.587627,  0.581011,  0.586734,  0.584344,  0.557216,  0.556968,  0.578248,  0.573749,  0.525227,  0.536616,  0.563150, },
{ 1.000000,  0.995381,  0.989899,  0.986160,  0.981406,  0.976086,  0.971230,  0.967893,  0.963251,  0.955592,  0.951431,  0.949336,  0.945290,  0.934802,  0.934183,  0.930551,  0.924968,  0.914101,  0.918218,  0.910759,  0.904130,  0.898559,  0.900484,  0.894206,  0.881527,  0.877614,  0.880110,  0.878355,  0.856749,  0.865809,  0.861539,  0.855572,  0.840802,  0.846287,  0.843290,  0.831150,  0.824592,  0.831617,  0.827051,  0.807428,  0.805368,  0.812021,  0.810137,  0.774403,  0.800460,  0.789737,  0.783206,  0.773500,  0.774434,  0.775350,  0.755108,  0.749535,  0.767018,  0.756111,  0.734917,  0.728966,  0.748551,  0.741770,  0.695317,  0.731848,  0.719609,  0.709405,  0.705021,  0.706694,  0.702695,  0.683387,  0.678519,  0.696552,  0.690312,  0.655530,  0.659005,  0.679180,  0.665888,  0.624833,  0.659565,  0.651935,  0.635814,  0.632016,  0.641987,  0.637232,  0.606461,  0.607050,  0.622038,  0.620898,  0.580834,  0.598571,  0.603508,  0.591213,  0.557095,  0.592726,  0.578573,  0.564514,  0.556506,  0.576201,  0.568665,  0.531575,  0.528202,  0.555192,  0.558144,  0.494456, },
{ 1.000000,  0.995165,  0.990574,  0.985553,  0.979626,  0.976353,  0.971306,  0.965441,  0.960123,  0.957982,  0.953112,  0.944449,  0.940141,  0.939205,  0.934573,  0.919782,  0.925603,  0.917928,  0.913382,  0.905243,  0.905030,  0.900165,  0.889479,  0.884674,  0.888874,  0.881740,  0.869647,  0.863946,  0.869652,  0.865499,  0.837488,  0.856255,  0.846102,  0.838566,  0.834203,  0.832698,  0.827742,  0.815243,  0.811050,  0.819232,  0.811573,  0.791585,  0.790134,  0.799725,  0.791709,  0.762132,  0.783210,  0.776427,  0.765157,  0.759500,  0.763494,  0.758285,  0.738870,  0.735855,  0.745690,  0.741341,  0.713755,  0.720477,  0.728164,  0.714502,  0.692427,  0.713047,  0.701228,  0.692385,  0.680743,  0.697504,  0.689480,  0.659966,  0.659968,  0.673353,  0.676220,  0.629728,  0.654828,  0.655779,  0.644356,  0.614341,  0.639930,  0.632305,  0.612915,  0.608954,  0.624503,  0.621375,  0.584703,  0.585078,  0.609036,  0.601362,  0.541479,  0.593352,  0.576879,  0.573018,  0.547458,  0.568699,  0.560943,  0.536957,  0.527179,  0.562978,  0.544438,  0.513859,  0.510167,  0.535958, },
{ 1.000000,  0.995237,  0.988951,  0.985548,  0.980071,  0.974853,  0.969635,  0.965504,  0.960598,  0.953457,  0.948861,  0.947268,  0.941473,  0.931837,  0.927582,  0.928225,  0.921926,  0.906289,  0.912028,  0.907281,  0.898551,  0.893313,  0.892762,  0.887508,  0.875444,  0.871573,  0.872738,  0.869035,  0.852263,  0.853242,  0.855026,  0.845816,  0.829632,  0.839618,  0.829230,  0.824343,  0.813574,  0.821822,  0.815869,  0.795682,  0.794104,  0.799388,  0.798001,  0.769944,  0.780746,  0.780934,  0.770922,  0.750954,  0.764909,  0.757907,  0.745353,  0.739252,  0.746211,  0.744022,  0.717067,  0.715327,  0.730767,  0.723925,  0.681770,  0.714248,  0.702579,  0.701362,  0.673345,  0.691916,  0.684713,  0.663378,  0.657785,  0.682266,  0.668036,  0.641273,  0.638686,  0.655523,  0.655865,  0.594376,  0.642928,  0.629279,  0.617858,  0.609781,  0.613657,  0.608542,  0.586415,  0.586056,  0.606134,  0.596116,  0.565800,  0.554710,  0.588378,  0.581162,  0.509902,  0.563440,  0.561925,  0.538904,  0.532855,  0.542880,  0.540348,  0.507345,  0.506763,  0.528056,  0.522017,  0.479909, },
{ 1.000000,  0.994889,  0.990161,  0.984873,  0.978266,  0.975243,  0.969374,  0.964126,  0.958019,  0.955542,  0.950733,  0.940991,  0.936910,  0.935475,  0.931566,  0.917864,  0.918746,  0.916293,  0.907695,  0.897872,  0.900693,  0.893579,  0.886155,  0.879868,  0.881272,  0.877411,  0.860845,  0.856949,  0.862485,  0.857631,  0.831812,  0.847244,  0.838534,  0.835235,  0.817973,  0.824342,  0.819340,  0.805221,  0.798392,  0.811318,  0.800427,  0.782807,  0.780288,  0.785762,  0.784944,  0.745367,  0.774163,  0.764226,  0.755109,  0.744685,  0.748110,  0.743151,  0.724863,  0.723650,  0.734481,  0.728902,  0.704396,  0.695649,  0.718286,  0.708002,  0.659289,  0.696179,  0.692101,  0.676847,  0.669648,  0.672206,  0.670795,  0.645705,  0.644832,  0.657942,  0.654407,  0.615976,  0.624984,  0.641939,  0.624420,  0.594310,  0.621895,  0.609833,  0.595357,  0.589481,  0.602298,  0.601907,  0.562082,  0.565774,  0.581999,  0.582919,  0.533711,  0.554381,  0.565535,  0.543819,  0.513608,  0.552326,  0.532030,  0.516751,  0.511412,  0.529852,  0.528745,  0.480132,  0.481710,  0.513457, },
{ 1.000000,  0.994924,  0.988529,  0.984715,  0.979275,  0.974090,  0.966896,  0.963729,  0.958665,  0.951672,  0.945842,  0.944902,  0.938704,  0.929021,  0.924611,  0.923933,  0.919432,  0.901151,  0.909288,  0.901111,  0.894912,  0.887931,  0.885402,  0.881575,  0.869358,  0.865369,  0.868855,  0.863191,  0.848277,  0.841244,  0.850368,  0.842825,  0.813090,  0.830508,  0.826306,  0.815981,  0.809183,  0.808404,  0.803917,  0.789055,  0.785151,  0.792361,  0.787214,  0.759941,  0.763700,  0.772749,  0.759686,  0.738403,  0.754367,  0.745490,  0.733701,  0.727869,  0.733529,  0.731291,  0.705112,  0.703610,  0.712718,  0.711215,  0.677569,  0.690939,  0.693881,  0.679834,  0.654500,  0.680968,  0.667747,  0.652962,  0.644501,  0.661793,  0.652630,  0.621693,  0.619273,  0.638729,  0.636862,  0.584417,  0.622070,  0.612112,  0.607294,  0.575012,  0.597487,  0.594336,  0.567578,  0.562715,  0.586134,  0.576825,  0.543264,  0.540233,  0.563334,  0.560739,  0.488796,  0.552102,  0.532923,  0.522023,  0.508879,  0.513340,  0.521466,  0.482889,  0.478190,  0.512555,  0.502399,  0.460875, },
{ 1.000000,  0.994500,  0.989680,  0.984497,  0.976162,  0.973927,  0.968258,  0.962244,  0.956510,  0.952302,  0.947290,  0.939142,  0.934183,  0.932542,  0.927463,  0.914579,  0.912091,  0.912340,  0.904234,  0.890295,  0.895459,  0.888954,  0.880258,  0.874480,  0.874753,  0.869302,  0.854342,  0.850961,  0.853329,  0.849502,  0.829187,  0.834238,  0.831196,  0.824131,  0.805222,  0.818823,  0.807617,  0.798501,  0.791556,  0.798897,  0.790338,  0.770040,  0.766953,  0.774202,  0.773894,  0.738920,  0.758068,  0.752888,  0.745489,  0.723242,  0.735199,  0.732400,  0.715027,  0.706819,  0.719788,  0.714920,  0.686003,  0.685207,  0.697080,  0.695963,  0.643715,  0.685145,  0.670162,  0.662019,  0.649668,  0.652539,  0.655147,  0.627328,  0.621167,  0.647236,  0.633289,  0.603959,  0.597867,  0.626285,  0.617962,  0.553942,  0.606480,  0.590613,  0.577514,  0.572661,  0.576100,  0.571624,  0.546313,  0.541338,  0.565991,  0.558762,  0.512809,  0.519180,  0.546465,  0.529614,  0.476155,  0.523492,  0.513876,  0.493482,  0.489389,  0.503400,  0.497972,  0.458098,  0.460318,  0.480381, },
{ 1.000000,  0.994616,  0.988290,  0.983348,  0.978466,  0.972543,  0.964785,  0.962459,  0.956084,  0.949536,  0.943752,  0.941261,  0.935494,  0.925161,  0.919722,  0.919295,  0.915420,  0.898893,  0.902361,  0.897232,  0.890295,  0.877746,  0.881243,  0.874738,  0.864799,  0.858207,  0.861526,  0.855341,  0.839216,  0.835310,  0.839730,  0.834649,  0.805593,  0.824805,  0.813101,  0.807823,  0.795723,  0.799379,  0.793787,  0.777095,  0.771809,  0.783086,  0.773513,  0.754410,  0.747944,  0.760462,  0.756031,  0.711489,  0.745810,  0.731283,  0.721339,  0.716420,  0.716474,  0.710725,  0.693079,  0.688965,  0.703180,  0.693489,  0.664503,  0.664878,  0.680917,  0.670262,  0.627944,  0.661313,  0.652502,  0.637733,  0.631058,  0.638276,  0.632284,  0.605450,  0.603126,  0.618349,  0.613429,  0.575466,  0.587342,  0.598526,  0.580714,  0.551174,  0.581439,  0.566059,  0.554676,  0.540191,  0.564199,  0.554392,  0.515166,  0.516445,  0.535340,  0.540180,  0.478140,  0.513934,  0.515542,  0.501208,  0.462310,  0.497215,  0.487868,  0.463325,  0.458983,  0.480163,  0.477086,  0.429283, },
{ 1.000000,  0.994240,  0.989015,  0.983494,  0.975228,  0.972743,  0.966194,  0.960727,  0.953144,  0.950225,  0.944136,  0.936107,  0.929761,  0.929941,  0.922271,  0.912317,  0.906907,  0.906835,  0.902061,  0.880950,  0.891491,  0.881739,  0.874870,  0.868265,  0.865969,  0.860794,  0.848253,  0.844145,  0.847788,  0.840113,  0.822572,  0.819265,  0.826439,  0.817445,  0.789293,  0.806664,  0.800964,  0.787880,  0.781828,  0.785055,  0.778550,  0.759778,  0.756492,  0.762042,  0.758437,  0.732087,  0.737306,  0.742698,  0.729935,  0.706032,  0.725045,  0.710592,  0.704756,  0.690448,  0.705613,  0.698190,  0.668876,  0.669174,  0.678901,  0.678482,  0.637947,  0.656621,  0.658364,  0.645335,  0.617682,  0.639945,  0.631120,  0.614624,  0.607427,  0.618841,  0.617037,  0.580310,  0.579895,  0.602466,  0.594020,  0.536593,  0.583915,  0.568261,  0.567660,  0.530649,  0.557389,  0.548719,  0.520864,  0.514649,  0.548202,  0.530690,  0.495206,  0.493689,  0.516645,  0.517769,  0.437520,  0.503265,  0.485614,  0.471338,  0.461567,  0.468077,  0.462146,  0.433906,  0.434728,  0.461069, },
{ 1.000000,  0.994301,  0.987895,  0.981895,  0.977722,  0.971951,  0.961349,  0.959997,  0.954719,  0.947085,  0.941012,  0.937070,  0.931834,  0.921879,  0.916619,  0.915017,  0.909188,  0.896481,  0.893630,  0.893393,  0.884392,  0.870485,  0.875587,  0.866442,  0.859676,  0.850827,  0.853373,  0.848425,  0.829137,  0.826883,  0.829979,  0.827196,  0.800966,  0.809070,  0.808824,  0.795392,  0.780158,  0.790410,  0.780576,  0.770062,  0.762465,  0.768506,  0.765017,  0.738167,  0.735224,  0.747752,  0.742033,  0.701017,  0.730116,  0.717919,  0.715203,  0.689598,  0.702425,  0.696603,  0.676525,  0.668471,  0.690254,  0.675858,  0.650244,  0.649246,  0.658957,  0.659447,  0.602188,  0.647085,  0.633918,  0.621944,  0.608591,  0.615203,  0.609625,  0.584633,  0.584856,  0.601296,  0.595010,  0.561430,  0.551177,  0.583590,  0.570726,  0.504332,  0.556965,  0.552444,  0.532487,  0.523688,  0.528548,  0.527826,  0.494585,  0.495086,  0.513244,  0.509995,  0.458833,  0.472978,  0.495799,  0.473371,  0.434638,  0.472418,  0.457092,  0.438828,  0.431994,  0.449863,  0.450448,  0.398693, },
{ 1.000000,  0.993950,  0.988247,  0.982711,  0.974508,  0.969976,  0.965216,  0.957853,  0.949447,  0.948040,  0.940269,  0.933043,  0.926821,  0.924365,  0.919282,  0.905825,  0.901078,  0.901841,  0.895813,  0.876323,  0.883837,  0.875924,  0.870166,  0.855710,  0.858365,  0.852852,  0.840541,  0.833239,  0.839221,  0.830575,  0.813267,  0.809747,  0.814381,  0.809981,  0.775294,  0.798433,  0.786033,  0.778251,  0.768830,  0.768249,  0.764833,  0.745969,  0.742434,  0.752118,  0.744960,  0.721868,  0.713443,  0.731625,  0.721797,  0.675002,  0.706715,  0.702274,  0.688016,  0.679469,  0.680876,  0.675962,  0.654902,  0.651453,  0.664099,  0.658409,  0.618606,  0.626787,  0.641917,  0.624038,  0.594545,  0.620192,  0.608501,  0.592992,  0.586060,  0.595946,  0.594458,  0.558145,  0.558227,  0.572019,  0.571483,  0.525328,  0.546168,  0.551128,  0.532756,  0.498727,  0.537178,  0.519607,  0.500643,  0.490505,  0.514823,  0.503927,  0.462841,  0.461313,  0.488269,  0.486617,  0.417163,  0.469622,  0.456474,  0.451423,  0.409526,  0.440435,  0.436589,  0.402385,  0.396998,  0.428334, },
{ 1.000000,  0.993995,  0.987227,  0.980964,  0.976269,  0.970449,  0.959472,  0.958729,  0.951353,  0.944659,  0.937504,  0.932799,  0.928447,  0.917395,  0.911199,  0.911511,  0.904755,  0.891992,  0.885736,  0.888519,  0.881731,  0.857325,  0.869043,  0.860797,  0.852070,  0.845114,  0.842533,  0.837109,  0.822926,  0.818488,  0.821571,  0.816066,  0.792314,  0.793231,  0.799003,  0.787057,  0.763161,  0.778808,  0.770386,  0.757622,  0.750567,  0.755118,  0.748724,  0.724952,  0.723269,  0.730333,  0.726712,  0.694954,  0.706845,  0.704308,  0.695125,  0.667127,  0.692043,  0.676197,  0.664237,  0.655407,  0.669054,  0.658428,  0.628923,  0.626659,  0.639703,  0.640966,  0.589879,  0.621513,  0.615015,  0.605887,  0.575072,  0.594494,  0.591627,  0.567943,  0.558184,  0.578132,  0.572741,  0.532974,  0.533861,  0.551616,  0.551504,  0.479458,  0.539426,  0.519555,  0.509503,  0.493517,  0.499090,  0.503511,  0.466921,  0.460193,  0.496046,  0.478715,  0.439807,  0.433586,  0.472079,  0.462173,  0.377497,  0.448880,  0.428290,  0.412297,  0.406536,  0.412071,  0.407341,  0.374758, },
{ 1.000000,  0.993399,  0.987798,  0.981529,  0.973359,  0.967442,  0.963477,  0.956272,  0.945194,  0.944366,  0.937487,  0.929376,  0.923076,  0.919750,  0.913429,  0.901185,  0.896251,  0.894453,  0.889313,  0.873167,  0.873594,  0.869638,  0.861003,  0.845406,  0.852251,  0.842683,  0.833022,  0.825702,  0.828111,  0.820978,  0.802189,  0.796638,  0.802388,  0.799139,  0.768554,  0.782145,  0.776390,  0.767156,  0.746814,  0.758132,  0.749658,  0.735238,  0.727095,  0.736850,  0.729308,  0.703610,  0.700878,  0.711289,  0.705820,  0.659800,  0.695300,  0.678040,  0.672017,  0.655282,  0.663702,  0.657238,  0.633360,  0.627495,  0.647012,  0.634468,  0.607135,  0.600035,  0.620723,  0.615826,  0.551208,  0.604518,  0.584303,  0.571643,  0.566210,  0.568312,  0.561160,  0.537498,  0.533593,  0.554995,  0.542928,  0.502917,  0.505818,  0.529189,  0.515715,  0.458037,  0.506451,  0.494949,  0.475481,  0.467723,  0.479029,  0.472062,  0.436458,  0.435369,  0.456228,  0.450841,  0.400255,  0.418873,  0.434090,  0.411345,  0.372538,  0.414694,  0.394600,  0.380398,  0.362649,  0.395400, },
{ 1.000000,  0.993667,  0.986482,  0.979804,  0.974405,  0.968699,  0.958134,  0.954766,  0.948949,  0.941654,  0.931163,  0.929766,  0.922603,  0.913300,  0.906892,  0.904884,  0.899012,  0.884302,  0.879439,  0.880319,  0.873259,  0.850330,  0.861210,  0.850808,  0.844762,  0.831333,  0.833718,  0.826124,  0.812720,  0.804611,  0.812701,  0.801407,  0.784402,  0.778907,  0.784630,  0.779917,  0.740873,  0.768142,  0.753300,  0.744299,  0.735790,  0.735741,  0.730194,  0.711032,  0.707374,  0.717055,  0.707242,  0.679908,  0.678073,  0.692548,  0.680607,  0.636840,  0.668600,  0.661572,  0.643124,  0.636060,  0.643684,  0.635793,  0.608568,  0.606045,  0.616563,  0.613442,  0.575085,  0.585673,  0.595058,  0.577929,  0.544427,  0.574510,  0.554919,  0.548117,  0.529263,  0.552974,  0.543734,  0.502987,  0.505512,  0.520499,  0.521400,  0.465167,  0.493996,  0.497068,  0.480720,  0.443012,  0.475910,  0.464473,  0.443217,  0.434385,  0.451316,  0.450229,  0.400997,  0.402531,  0.433528,  0.423366,  0.346714,  0.412670,  0.391605,  0.391897,  0.343566,  0.380707,  0.369588,  0.333971, },
{ 1.000000,  0.993051,  0.987139,  0.980226,  0.972046,  0.965406,  0.960650,  0.954667,  0.940689,  0.941397,  0.933279,  0.925466,  0.918088,  0.913422,  0.906648,  0.896050,  0.890408,  0.889629,  0.881889,  0.868025,  0.860007,  0.864063,  0.856804,  0.829428,  0.841480,  0.835635,  0.822929,  0.815621,  0.814525,  0.808627,  0.791232,  0.786439,  0.789680,  0.782900,  0.760156,  0.760772,  0.765510,  0.752029,  0.729285,  0.744372,  0.730941,  0.722399,  0.710224,  0.718582,  0.713231,  0.682476,  0.682635,  0.691178,  0.689168,  0.647736,  0.665219,  0.667180,  0.648134,  0.625671,  0.645374,  0.631880,  0.617742,  0.608167,  0.620005,  0.616715,  0.577345,  0.575918,  0.596598,  0.589683,  0.530199,  0.576501,  0.559600,  0.557294,  0.521419,  0.542534,  0.535356,  0.507679,  0.498228,  0.530859,  0.512162,  0.476683,  0.477339,  0.492371,  0.494519,  0.415299,  0.480591,  0.462533,  0.447100,  0.430198,  0.441038,  0.433937,  0.400895,  0.403013,  0.426395,  0.419192,  0.374023,  0.362492,  0.406609,  0.390787,  0.302413,  0.374559,  0.369031,  0.343364,  0.332506,  0.340703, },
{ 1.000000,  0.993126,  0.985730,  0.978768,  0.972864,  0.966382,  0.956048,  0.950575,  0.946447,  0.937818,  0.926997,  0.925550,  0.917227,  0.908572,  0.901306,  0.898338,  0.892837,  0.877075,  0.872432,  0.871150,  0.866035,  0.845738,  0.847348,  0.844998,  0.832801,  0.817434,  0.825606,  0.813346,  0.802631,  0.795501,  0.797640,  0.792463,  0.767713,  0.764238,  0.771948,  0.764957,  0.729326,  0.751084,  0.739495,  0.733088,  0.709989,  0.719790,  0.713224,  0.694829,  0.685737,  0.700118,  0.688347,  0.661461,  0.659591,  0.670030,  0.665750,  0.611079,  0.652497,  0.635073,  0.625147,  0.612340,  0.614750,  0.611285,  0.584161,  0.581598,  0.598401,  0.590053,  0.556500,  0.546455,  0.575724,  0.562917,  0.494784,  0.544682,  0.539340,  0.520540,  0.509759,  0.513645,  0.508211,  0.479457,  0.476475,  0.495945,  0.489263,  0.434059,  0.448462,  0.470340,  0.446672,  0.407082,  0.444606,  0.429173,  0.409055,  0.400979,  0.415836,  0.415134,  0.366353,  0.368752,  0.388179,  0.388602,  0.326725,  0.357506,  0.364267,  0.340534,  0.295985,  0.349323,  0.326359,  0.301929, },
{ 1.000000,  0.992769,  0.986115,  0.979092,  0.970316,  0.963109,  0.958332,  0.951815,  0.938354,  0.937432,  0.929550,  0.922490,  0.910336,  0.908749,  0.901799,  0.889970,  0.882647,  0.882567,  0.874769,  0.859484,  0.853389,  0.854316,  0.848109,  0.819772,  0.835306,  0.823002,  0.814205,  0.804098,  0.800731,  0.798293,  0.778364,  0.771581,  0.779944,  0.771353,  0.748596,  0.741960,  0.753640,  0.744819,  0.700938,  0.729612,  0.718073,  0.705782,  0.697241,  0.696760,  0.690796,  0.669364,  0.665509,  0.674287,  0.667798,  0.630445,  0.636182,  0.648278,  0.631365,  0.595707,  0.623876,  0.612765,  0.595065,  0.586514,  0.596184,  0.588778,  0.554014,  0.554311,  0.567035,  0.563539,  0.517424,  0.538395,  0.536250,  0.524405,  0.484710,  0.523743,  0.502186,  0.486493,  0.475402,  0.496976,  0.483300,  0.442150,  0.441454,  0.461556,  0.464583,  0.393465,  0.440876,  0.431952,  0.420955,  0.379101,  0.408292,  0.405229,  0.373523,  0.362027,  0.390343,  0.384056,  0.330607,  0.334154,  0.359083,  0.360043,  0.263410,  0.346419,  0.320026,  0.307773,  0.287214,  0.296224, },
{ 1.000000,  0.992830,  0.984836,  0.977274,  0.971882,  0.963922,  0.954159,  0.946677,  0.943537,  0.936029,  0.919216,  0.921717,  0.912427,  0.903410,  0.896094,  0.890806,  0.883680,  0.871259,  0.864187,  0.864811,  0.857167,  0.837522,  0.834002,  0.836575,  0.825486,  0.802000,  0.813086,  0.803940,  0.791098,  0.784213,  0.784206,  0.776927,  0.755531,  0.751622,  0.754595,  0.749381,  0.721270,  0.728432,  0.725659,  0.713603,  0.688036,  0.706630,  0.692589,  0.679174,  0.670019,  0.678667,  0.669565,  0.640224,  0.634975,  0.647807,  0.645613,  0.597411,  0.623979,  0.616855,  0.605027,  0.575268,  0.596003,  0.585185,  0.564947,  0.555191,  0.572409,  0.563426,  0.526199,  0.524973,  0.542397,  0.536124,  0.469405,  0.524887,  0.501005,  0.494132,  0.471517,  0.485889,  0.478081,  0.445316,  0.438726,  0.468469,  0.452501,  0.414532,  0.407097,  0.437430,  0.431984,  0.342520,  0.419472,  0.392246,  0.376072,  0.369931,  0.374575,  0.365951,  0.334564,  0.331124,  0.360813,  0.345941,  0.292356,  0.298560,  0.331140,  0.313553,  0.237400,  0.304198,  0.289185,  0.264180, },
{ 1.000000,  0.992309,  0.985303,  0.977803,  0.969005,  0.961538,  0.955807,  0.948684,  0.936737,  0.931987,  0.926830,  0.917209,  0.905112,  0.904799,  0.895009,  0.886169,  0.876554,  0.876530,  0.867903,  0.850949,  0.845539,  0.844982,  0.840849,  0.814982,  0.821545,  0.815988,  0.805485,  0.786076,  0.793503,  0.784260,  0.769635,  0.762326,  0.765662,  0.759214,  0.733537,  0.730311,  0.737912,  0.729103,  0.688885,  0.716124,  0.700650,  0.693806,  0.673350,  0.682848,  0.673090,  0.653196,  0.643075,  0.660821,  0.645220,  0.619452,  0.614310,  0.626793,  0.622088,  0.561853,  0.609325,  0.588110,  0.576315,  0.565929,  0.569016,  0.562446,  0.535497,  0.532784,  0.549543,  0.537114,  0.497856,  0.498230,  0.521530,  0.505533,  0.443583,  0.492610,  0.483851,  0.459113,  0.450799,  0.463976,  0.454056,  0.417006,  0.415644,  0.431980,  0.429253,  0.376308,  0.394183,  0.408128,  0.385064,  0.340638,  0.384453,  0.358702,  0.350235,  0.326090,  0.360236,  0.349011,  0.294357,  0.299690,  0.320902,  0.323370,  0.248466,  0.289684,  0.294179,  0.273546,  0.224365,  0.270238, },
{ 1.000000,  0.992197,  0.984202,  0.976111,  0.969333,  0.961949,  0.951158,  0.943760,  0.939438,  0.931359,  0.915197,  0.916628,  0.906660,  0.899888,  0.885462,  0.885039,  0.876309,  0.862899,  0.855029,  0.857690,  0.846708,  0.829606,  0.823626,  0.824619,  0.819103,  0.785446,  0.803371,  0.790599,  0.779564,  0.769980,  0.767431,  0.759302,  0.742167,  0.737174,  0.742764,  0.732452,  0.709031,  0.699398,  0.713475,  0.704009,  0.656314,  0.684951,  0.678475,  0.659505,  0.650538,  0.653198,  0.646746,  0.620141,  0.615996,  0.624937,  0.617201,  0.582051,  0.587524,  0.597993,  0.578946,  0.545503,  0.572840,  0.553904,  0.543193,  0.526784,  0.542675,  0.536636,  0.491989,  0.495256,  0.510274,  0.509126,  0.449439,  0.478757,  0.482942,  0.457107,  0.426105,  0.457584,  0.439383,  0.420656,  0.409174,  0.427981,  0.424725,  0.369930,  0.370944,  0.401553,  0.392948,  0.310481,  0.378292,  0.355162,  0.353503,  0.304979,  0.336841,  0.327607,  0.290774,  0.279808,  0.325641,  0.301766,  0.253978,  0.257089,  0.278793,  0.282612,  0.176817,  0.267132,  0.243203,  0.223216, },
{ 1.000000,  0.991910,  0.984087,  0.976186,  0.966726,  0.959137,  0.953143,  0.945330,  0.933468,  0.924903,  0.922822,  0.913743,  0.894232,  0.897660,  0.889962,  0.878605,  0.869806,  0.864899,  0.857874,  0.842313,  0.836021,  0.835089,  0.827726,  0.805026,  0.804180,  0.805485,  0.791652,  0.771483,  0.780149,  0.767896,  0.755166,  0.746485,  0.748428,  0.743133,  0.715242,  0.712867,  0.716352,  0.711997,  0.676759,  0.686396,  0.686839,  0.668793,  0.645022,  0.665157,  0.646905,  0.632162,  0.624161,  0.631569,  0.626518,  0.588276,  0.586330,  0.602732,  0.594218,  0.538971,  0.578369,  0.562279,  0.554829,  0.521486,  0.540242,  0.532156,  0.506486,  0.495154,  0.519768,  0.504253,  0.465797,  0.466197,  0.483781,  0.479240,  0.400677,  0.464695,  0.440534,  0.428214,  0.411615,  0.417649,  0.414035,  0.376708,  0.375726,  0.401170,  0.390805,  0.344959,  0.333677,  0.375692,  0.359206,  0.266208,  0.337580,  0.331336,  0.306700,  0.293216,  0.300659,  0.294497,  0.256375,  0.254245,  0.281475,  0.273317,  0.200033,  0.222017,  0.252293,  0.221030,  0.169696,  0.222251, },
{ 1.000000,  0.991629,  0.983103,  0.974505,  0.967129,  0.959440,  0.947947,  0.940350,  0.934401,  0.926920,  0.912028,  0.908482,  0.901991,  0.891201,  0.876512,  0.878764,  0.867349,  0.855478,  0.846240,  0.846112,  0.836541,  0.817393,  0.810643,  0.812669,  0.805949,  0.775117,  0.788420,  0.776894,  0.768949,  0.746831,  0.753306,  0.745137,  0.725474,  0.717199,  0.724585,  0.714530,  0.688694,  0.683172,  0.690919,  0.684355,  0.634495,  0.670261,  0.651826,  0.640381,  0.626289,  0.625684,  0.624835,  0.593656,  0.586987,  0.604869,  0.593757,  0.559259,  0.552162,  0.574414,  0.563428,  0.495199,  0.544920,  0.529404,  0.512787,  0.502183,  0.504785,  0.497577,  0.467231,  0.464270,  0.480151,  0.472783,  0.418193,  0.430291,  0.450306,  0.426492,  0.376694,  0.421222,  0.406053,  0.382111,  0.371965,  0.388015,  0.379008,  0.330926,  0.334093,  0.353465,  0.350233,  0.286180,  0.318511,  0.317162,  0.301578,  0.247441,  0.304851,  0.275648,  0.254880,  0.241543,  0.272648,  0.255016,  0.200109,  0.201124,  0.230171,  0.235265,  0.138814,  0.206946,  0.194682,  0.180866, },
{ 1.000000,  0.990873,  0.982982,  0.974497,  0.964827,  0.955673,  0.949717,  0.941251,  0.928227,  0.920473,  0.915798,  0.908257,  0.886890,  0.891800,  0.879970,  0.870559,  0.859320,  0.853981,  0.847964,  0.830808,  0.821984,  0.825932,  0.814165,  0.794554,  0.786367,  0.792772,  0.782980,  0.744906,  0.765879,  0.751387,  0.739083,  0.730404,  0.727103,  0.718539,  0.698426,  0.690799,  0.699196,  0.689596,  0.655363,  0.655805,  0.666237,  0.649998,  0.611106,  0.637558,  0.625000,  0.606431,  0.598510,  0.603515,  0.594703,  0.561566,  0.559379,  0.567969,  0.562840,  0.519202,  0.535680,  0.533836,  0.517842,  0.479636,  0.513429,  0.493570,  0.475190,  0.463809,  0.480232,  0.468687,  0.426422,  0.421833,  0.443286,  0.442256,  0.371858,  0.415122,  0.406012,  0.390957,  0.349044,  0.382506,  0.368493,  0.340754,  0.329154,  0.355566,  0.344731,  0.292764,  0.293971,  0.320249,  0.313054,  0.220183,  0.301080,  0.268718,  0.260262,  0.230600,  0.252111,  0.242921,  0.199215,  0.192026,  0.234194,  0.214109,  0.162485,  0.155024,  0.197423,  0.190812,  0.071195,  0.177316, },
{ 1.000000,  0.991030,  0.982027,  0.972979,  0.964794,  0.955755,  0.945167,  0.936301,  0.931098,  0.921516,  0.907038,  0.899692,  0.896521,  0.886013,  0.865908,  0.869624,  0.859433,  0.846968,  0.837713,  0.833930,  0.824752,  0.806814,  0.799624,  0.799438,  0.790960,  0.766205,  0.767253,  0.765601,  0.750453,  0.728610,  0.739668,  0.724854,  0.712148,  0.698970,  0.706987,  0.695407,  0.666190,  0.661967,  0.667487,  0.665029,  0.619456,  0.639092,  0.633223,  0.618682,  0.587642,  0.606661,  0.594464,  0.572652,  0.564467,  0.574278,  0.567141,  0.527120,  0.526149,  0.542156,  0.530876,  0.468039,  0.517034,  0.494207,  0.486646,  0.457223,  0.475310,  0.462966,  0.434256,  0.421944,  0.451684,  0.430319,  0.393110,  0.388471,  0.409650,  0.404932,  0.316820,  0.391064,  0.360787,  0.345630,  0.332679,  0.340048,  0.331727,  0.294503,  0.292891,  0.319108,  0.302751,  0.247908,  0.251390,  0.285642,  0.264458,  0.178491,  0.250794,  0.238901,  0.205917,  0.196260,  0.216760,  0.203720,  0.153953,  0.153800,  0.178082,  0.175365,  0.103295,  0.131259,  0.150545,  0.119508, },
{ 1.000000,  0.990425,  0.982059,  0.972461,  0.963047,  0.952853,  0.946615,  0.937426,  0.923718,  0.915568,  0.909906,  0.902101,  0.883182,  0.881395,  0.874196,  0.862981,  0.845786,  0.847122,  0.836352,  0.822932,  0.812903,  0.811123,  0.803825,  0.780237,  0.774267,  0.777809,  0.767389,  0.731928,  0.751007,  0.735572,  0.728842,  0.703021,  0.712274,  0.700843,  0.679141,  0.669865,  0.683230,  0.667143,  0.639118,  0.633783,  0.642086,  0.636900,  0.579071,  0.618543,  0.599581,  0.584697,  0.572348,  0.572856,  0.562738,  0.537877,  0.533865,  0.546951,  0.533493,  0.497826,  0.487122,  0.512846,  0.500414,  0.428229,  0.477718,  0.469788,  0.443083,  0.432144,  0.439939,  0.432160,  0.394500,  0.391106,  0.407317,  0.397948,  0.347326,  0.359468,  0.376908,  0.350507,  0.303878,  0.347219,  0.321298,  0.307507,  0.285721,  0.311578,  0.304335,  0.242318,  0.249706,  0.272655,  0.272509,  0.189932,  0.234508,  0.241249,  0.207343,  0.165213,  0.211495,  0.187659,  0.163108,  0.149001,  0.176817,  0.173094,  0.099798,  0.103572,  0.146782,  0.135564,  0.025388,  0.119728, },
{ 1.000000,  0.990698,  0.981322,  0.970448,  0.962620,  0.953244,  0.941703,  0.931609,  0.927389,  0.916335,  0.902091,  0.894013,  0.888580,  0.881121,  0.855452,  0.862925,  0.850573,  0.838594,  0.826511,  0.822206,  0.812431,  0.795033,  0.788217,  0.788731,  0.778818,  0.755769,  0.745332,  0.753837,  0.741269,  0.699999,  0.722081,  0.712946,  0.695260,  0.683798,  0.681685,  0.674400,  0.648551,  0.643198,  0.648216,  0.639865,  0.601334,  0.607178,  0.614823,  0.594026,  0.562422,  0.583862,  0.566693,  0.548614,  0.538174,  0.546294,  0.540981,  0.497999,  0.498117,  0.508091,  0.504224,  0.449977,  0.470516,  0.474139,  0.448558,  0.413986,  0.449495,  0.423788,  0.403835,  0.394413,  0.408887,  0.403559,  0.348050,  0.348625,  0.375713,  0.365153,  0.284946,  0.347182,  0.324704,  0.316561,  0.269712,  0.300221,  0.290325,  0.254779,  0.241012,  0.278343,  0.258273,  0.205098,  0.208742,  0.234848,  0.229792,  0.121245,  0.213572,  0.181382,  0.165583,  0.144088,  0.155396,  0.150772,  0.100860,  0.101712,  0.138361,  0.125294,  0.063957,  0.051053,  0.109389,  0.087884, },
{ 1.000000,  0.989171,  0.980816,  0.971136,  0.960527,  0.950456,  0.941772,  0.932107,  0.919431,  0.910041,  0.904350,  0.894837,  0.875463,  0.870179,  0.866685,  0.852789,  0.834771,  0.836927,  0.824449,  0.810598,  0.800520,  0.797687,  0.789885,  0.765964,  0.759508,  0.758992,  0.751758,  0.720927,  0.726592,  0.721649,  0.704600,  0.679539,  0.695636,  0.678109,  0.660599,  0.648855,  0.656747,  0.644415,  0.611955,  0.606154,  0.617185,  0.609597,  0.556978,  0.588508,  0.572318,  0.563316,  0.528840,  0.545885,  0.535702,  0.506451,  0.496905,  0.513990,  0.500813,  0.461612,  0.457221,  0.473619,  0.466463,  0.389816,  0.451346,  0.425113,  0.410011,  0.391354,  0.394362,  0.395185,  0.350385,  0.343587,  0.373744,  0.359568,  0.310026,  0.303365,  0.338473,  0.324006,  0.226537,  0.301832,  0.281213,  0.259813,  0.246312,  0.253291,  0.244539,  0.203020,  0.201083,  0.225731,  0.216950,  0.141360,  0.161854,  0.191207,  0.158629,  0.092156,  0.156928,  0.136511,  0.104818,  0.092558,  0.116496,  0.105739,  0.041387,  0.048087,  0.076000,  0.072746, -0.013633,  0.033595, },
{ 1.000000,  0.989964,  0.979455,  0.967438,  0.960286,  0.948711,  0.937560,  0.926750,  0.920263,  0.909263,  0.893067,  0.883963,  0.879105,  0.870847,  0.845881,  0.849247,  0.837920,  0.826826,  0.806877,  0.807362,  0.797974,  0.779897,  0.768181,  0.769979,  0.759856,  0.732755,  0.726946,  0.728518,  0.721267,  0.675175,  0.702252,  0.683464,  0.670988,  0.654594,  0.652221,  0.647508,  0.618268,  0.608500,  0.623918,  0.607206,  0.574629,  0.566544,  0.584810,  0.571858,  0.506594,  0.551080,  0.530057,  0.513068,  0.502726,  0.502352,  0.491464,  0.461380,  0.453720,  0.471502,  0.459403,  0.406722,  0.412182,  0.432550,  0.409064,  0.351275,  0.397536,  0.380160,  0.354141,  0.345006,  0.356125,  0.345299,  0.297522,  0.297357,  0.313473,  0.308014,  0.244421,  0.273358,  0.272538,  0.250685,  0.196589,  0.250334,  0.222411,  0.197633,  0.183413,  0.210688,  0.195249,  0.136248,  0.132890,  0.165535,  0.165149,  0.066509,  0.131779,  0.119517,  0.100350,  0.043264,  0.092595,  0.074454,  0.037522,  0.023060,  0.061978,  0.047734, -0.022742, -0.017969,  0.019025,  0.010409, },
{ 1.000000,  0.988357,  0.979277,  0.968133,  0.957403,  0.945301,  0.936770,  0.926086,  0.912065,  0.901227,  0.896756,  0.884723,  0.867584,  0.857231,  0.854904,  0.844652,  0.813000,  0.824765,  0.808289,  0.795232,  0.784663,  0.778277,  0.766771,  0.747895,  0.738814,  0.741278,  0.727955,  0.698976,  0.694270,  0.699626,  0.684106,  0.644719,  0.666462,  0.651713,  0.633026,  0.621302,  0.622566,  0.611074,  0.581004,  0.574932,  0.581270,  0.571355,  0.529234,  0.539397,  0.541179,  0.519170,  0.484261,  0.510984,  0.488760,  0.471197,  0.453660,  0.472733,  0.456384,  0.411478,  0.408988,  0.422674,  0.421819,  0.350650,  0.388185,  0.381185,  0.361820,  0.315720,  0.350177,  0.333450,  0.302759,  0.293192,  0.312097,  0.303142,  0.244711,  0.247298,  0.273952,  0.259164,  0.167159,  0.244479,  0.212088,  0.202901,  0.162588,  0.192359,  0.176183,  0.136356,  0.121009,  0.166510,  0.137413,  0.085170,  0.081597,  0.114126,  0.108829, -0.014692,  0.094065,  0.052205,  0.032087,  0.016070,  0.029861,  0.018428, -0.031899, -0.031894,  0.006392, -0.015092, -0.090045, -0.081923, },
{ 1.000000,  0.989312,  0.978254,  0.963966,  0.956620,  0.945500,  0.932708,  0.921274,  0.913286,  0.901878,  0.885745,  0.875513,  0.869276,  0.859329,  0.837536,  0.833015,  0.827055,  0.811533,  0.789912,  0.794338,  0.777606,  0.765842,  0.749538,  0.753015,  0.740257,  0.711950,  0.705741,  0.705416,  0.698430,  0.659057,  0.669775,  0.662738,  0.646265,  0.616381,  0.630373,  0.615235,  0.594529,  0.582124,  0.586850,  0.578615,  0.538534,  0.534747,  0.548446,  0.534151,  0.473504,  0.516298,  0.492688,  0.485470,  0.445073,  0.467518,  0.451771,  0.419171,  0.408207,  0.435093,  0.411966,  0.368894,  0.365471,  0.382878,  0.377966,  0.287391,  0.356169,  0.328407,  0.308073,  0.292119,  0.297191,  0.284101,  0.248613,  0.245944,  0.269058,  0.250604,  0.198193,  0.186971,  0.227960,  0.210214,  0.105896,  0.184159,  0.172982,  0.136185,  0.122265,  0.138018,  0.127316,  0.074418,  0.072834,  0.098146,  0.086619,  0.014447,  0.037001,  0.062765,  0.025750, -0.038197,  0.027123, -0.008765, -0.026864, -0.055692, -0.015966, -0.026433, -0.111458, -0.098125, -0.064790, -0.064247, },
{ 1.000000,  0.987712,  0.977264,  0.966368,  0.953761,  0.939840,  0.932624,  0.919861,  0.906674,  0.894675,  0.887723,  0.876937,  0.856175,  0.846662,  0.843831,  0.831917,  0.801256,  0.810368,  0.794014,  0.784470,  0.760271,  0.762039,  0.749440,  0.728139,  0.715600,  0.723316,  0.706090,  0.678824,  0.672045,  0.672716,  0.665712,  0.612365,  0.644332,  0.624712,  0.607260,  0.589787,  0.590943,  0.577582,  0.549353,  0.544001,  0.552944,  0.539710,  0.501028,  0.488990,  0.511247,  0.493099,  0.423561,  0.470818,  0.458643,  0.432333,  0.417022,  0.420009,  0.410868,  0.371315,  0.367380,  0.380119,  0.369626,  0.310044,  0.325457,  0.341324,  0.310587,  0.263767,  0.303031,  0.277435,  0.253163,  0.239388,  0.257116,  0.250678,  0.186856,  0.190966,  0.209375,  0.205900,  0.125245,  0.161431,  0.168786,  0.132719,  0.084245,  0.140464,  0.103531,  0.076864,  0.065370,  0.089916,  0.082901,  0.004148,  0.009173,  0.050329,  0.036133, -0.077916,  0.015550, -0.016315, -0.025851, -0.090282, -0.043079, -0.057092, -0.105492, -0.122897, -0.067518, -0.095403, -0.168341, -0.159420, },
{ 1.000000,  0.988166,  0.976436,  0.960408,  0.953289,  0.939907,  0.927273,  0.914013,  0.904142,  0.892354,  0.875361,  0.864522,  0.859371,  0.846674,  0.825633,  0.813017,  0.813889,  0.799440,  0.762667,  0.774727,  0.762737,  0.745118,  0.731151,  0.725491,  0.713430,  0.689920,  0.680327,  0.681750,  0.669076,  0.630069,  0.632069,  0.635828,  0.612893,  0.581384,  0.598346,  0.579392,  0.558491,  0.545410,  0.549312,  0.540022,  0.498807,  0.494915,  0.500981,  0.493367,  0.440670,  0.459069,  0.455475,  0.429869,  0.390156,  0.425893,  0.398821,  0.372761,  0.358251,  0.377044,  0.359738,  0.309029,  0.304983,  0.327832,  0.318243,  0.235117,  0.292569,  0.269068,  0.258384,  0.206728,  0.238972,  0.224865,  0.181839,  0.170519,  0.201595,  0.182356,  0.124409,  0.122923,  0.150399,  0.141599,  0.027888,  0.125304,  0.087650,  0.067234,  0.041766,  0.051210,  0.051767, -0.012082, -0.017816,  0.028934,  0.009038, -0.060667, -0.066650, -0.014106, -0.034458, -0.173396, -0.061268, -0.089588, -0.118524, -0.135861, -0.121783, -0.134841, -0.191810, -0.191712, -0.154862, -0.167267, },
{ 1.000000,  0.986644,  0.974263,  0.963278,  0.949550,  0.933065,  0.926008,  0.912335,  0.897653,  0.884536,  0.876268,  0.863497,  0.842564,  0.832752,  0.826446,  0.814985,  0.787360,  0.786427,  0.775989,  0.760558,  0.733572,  0.742818,  0.722596,  0.705551,  0.691024,  0.693192,  0.676809,  0.645616,  0.637423,  0.640660,  0.632899,  0.581104,  0.604294,  0.588654,  0.573674,  0.538807,  0.551583,  0.539626,  0.509999,  0.495118,  0.507723,  0.493702,  0.448373,  0.445209,  0.455760,  0.447803,  0.368349,  0.425923,  0.396923,  0.380034,  0.356910,  0.359024,  0.354392,  0.309245,  0.298731,  0.329305,  0.305335,  0.255531,  0.247732,  0.281981,  0.263689,  0.161932,  0.237989,  0.207687,  0.184922,  0.171906,  0.175918,  0.160874,  0.117249,  0.109845,  0.140868,  0.123684,  0.045652,  0.059142,  0.092551,  0.057259, -0.024448,  0.049524,  0.024259, -0.011846, -0.023243, -0.002978, -0.017606, -0.085700, -0.081866, -0.055773, -0.063026, -0.153556, -0.106861, -0.106649, -0.137243, -0.212995, -0.131155, -0.171111, -0.204809, -0.222584, -0.180373, -0.202446, -0.283754, -0.284846, },
{ 1.000000,  0.987043,  0.974304,  0.957611,  0.947710,  0.934423,  0.920603,  0.902942,  0.895762,  0.881683,  0.864670,  0.850677,  0.845036,  0.831074,  0.807454,  0.796976,  0.792865,  0.779704,  0.741218,  0.756015,  0.735103,  0.721509,  0.701128,  0.698471,  0.684763,  0.658172,  0.645410,  0.652996,  0.634817,  0.602631,  0.590806,  0.600138,  0.586906,  0.522427,  0.563770,  0.536603,  0.517301,  0.504451,  0.501364,  0.485564,  0.455704,  0.445852,  0.458745,  0.439519,  0.390574,  0.389932,  0.406775,  0.382789,  0.318164,  0.365190,  0.343191,  0.315163,  0.300116,  0.308953,  0.293579,  0.246587,  0.241630,  0.257322,  0.244581,  0.178544,  0.202452,  0.208371,  0.175518,  0.122561,  0.172205,  0.138844,  0.114043,  0.090793,  0.125651,  0.101295,  0.035142,  0.035287,  0.060191,  0.060391, -0.046786,  0.016577,  0.007549, -0.019454, -0.085658, -0.029510, -0.053036, -0.096419, -0.108353, -0.075949, -0.089109, -0.172203, -0.164110, -0.123527, -0.144086, -0.276592, -0.159038, -0.204900, -0.217277, -0.272367, -0.226900, -0.248259, -0.303994, -0.322795, -0.255447, -0.296586, },
{ 1.000000,  0.985505,  0.971512,  0.959066,  0.945510,  0.923860,  0.919051,  0.902360,  0.887230,  0.872485,  0.862090,  0.847705,  0.827719,  0.815149,  0.810000,  0.793897,  0.767164,  0.756960,  0.755856,  0.737079,  0.698413,  0.712693,  0.696628,  0.673780,  0.659597,  0.657970,  0.641650,  0.610783,  0.600709,  0.601241,  0.589463,  0.546339,  0.551448,  0.549297,  0.523541,  0.484897,  0.508416,  0.480718,  0.464972,  0.440417,  0.458270,  0.438885,  0.390406,  0.386168,  0.394111,  0.386860,  0.318234,  0.347433,  0.340174,  0.315732,  0.268050,  0.300150,  0.278267,  0.246960,  0.230691,  0.245391,  0.234492,  0.171184,  0.171146,  0.198690,  0.178071,  0.081198,  0.158745,  0.122931,  0.113429,  0.054036,  0.094673,  0.072157,  0.024372,  0.010894,  0.057316,  0.021829, -0.041475, -0.042728, -0.011380, -0.018291, -0.154512, -0.043224, -0.084565, -0.113679, -0.134623, -0.121637, -0.140717, -0.190639, -0.191867, -0.153627, -0.180903, -0.257982, -0.268968, -0.206068, -0.234465, -0.382231, -0.261793, -0.279324, -0.331287, -0.349225, -0.321359, -0.337372, -0.411506, -0.411216, },
{ 1.000000,  0.985647,  0.970995,  0.953901,  0.940537,  0.928335,  0.911452,  0.891693,  0.884945,  0.867300,  0.851719,  0.834164,  0.827790,  0.812605,  0.785057,  0.774423,  0.768675,  0.756209,  0.718789,  0.722330,  0.711834,  0.689237,  0.662163,  0.668667,  0.647673,  0.626760,  0.610196,  0.611534,  0.597421,  0.554912,  0.547540,  0.556746,  0.539729,  0.476035,  0.513940,  0.486599,  0.475033,  0.432586,  0.448456,  0.430552,  0.394637,  0.378691,  0.403836,  0.375410,  0.330226,  0.325167,  0.334649,  0.327038,  0.233838,  0.301966,  0.270268,  0.244210,  0.219441,  0.228794,  0.208705,  0.165810,  0.162196,  0.183430,  0.163189,  0.101909,  0.088304,  0.129825,  0.101901, -0.007222,  0.077504,  0.058893,  0.019757, -0.001966,  0.009883, -0.003242, -0.063107, -0.065258, -0.040992, -0.056157, -0.146253, -0.115515, -0.088039, -0.135304, -0.204176, -0.137324, -0.176973, -0.210336, -0.229504, -0.196268, -0.206930, -0.300543, -0.291236, -0.260380, -0.264754, -0.384069, -0.323397, -0.312110, -0.363355, -0.431654, -0.345671, -0.399938, -0.436393, -0.450960, -0.411353, -0.423868, },
{ 1.000000,  0.983639,  0.967846,  0.954445,  0.938857,  0.915904,  0.908489,  0.890879,  0.875677,  0.853512,  0.845748,  0.829559,  0.807870,  0.791101,  0.787907,  0.768766,  0.740688,  0.729511,  0.724846,  0.710140,  0.660292,  0.681231,  0.657106,  0.638389,  0.618220,  0.612563,  0.596469,  0.564401,  0.553748,  0.559552,  0.540300,  0.500088,  0.484688,  0.501476,  0.478363,  0.404381,  0.447343,  0.430760,  0.402278,  0.381413,  0.381661,  0.365115,  0.325928,  0.315609,  0.327150,  0.308560,  0.240917,  0.254412,  0.268580,  0.231337,  0.179728,  0.220318,  0.189231,  0.158612,  0.139879,  0.155322,  0.142521,  0.075528,  0.074370,  0.091265,  0.082044, -0.003714,  0.034869,  0.032913, -0.006476, -0.067382, -0.002411, -0.045011, -0.083001, -0.102187, -0.066536, -0.093130, -0.170385, -0.172115, -0.130305, -0.144499, -0.274073, -0.177313, -0.212611, -0.226154, -0.302235, -0.246731, -0.268443, -0.331796, -0.347088, -0.293380, -0.323903, -0.408950, -0.406401, -0.361940, -0.374647, -0.543667, -0.392263, -0.446665, -0.476270, -0.511479, -0.491223, -0.493885, -0.584890, -0.588734, },
{ 1.000000,  0.983963,  0.967349,  0.948571,  0.931981,  0.919827,  0.902503,  0.873667,  0.870185,  0.851759,  0.832653,  0.815106,  0.803317,  0.786002,  0.761316,  0.746753,  0.740383,  0.723010,  0.685674,  0.679857,  0.676629,  0.650264,  0.613629,  0.627505,  0.604170,  0.578900,  0.560675,  0.560351,  0.541950,  0.500215,  0.492314,  0.493907,  0.479445,  0.423877,  0.438272,  0.426612,  0.402114,  0.353564,  0.387501,  0.352571,  0.326208,  0.305879,  0.320563,  0.294874,  0.241189,  0.233891,  0.250807,  0.241445,  0.148202,  0.202340,  0.178546,  0.157174,  0.100470,  0.132273,  0.114685,  0.066726,  0.045656,  0.077044,  0.053910, -0.018414, -0.017427,  0.006682, -0.003834, -0.134105, -0.029996, -0.074405, -0.099685, -0.133683, -0.122653, -0.130287, -0.199551, -0.210792, -0.156599, -0.193910, -0.269348, -0.276247, -0.217592, -0.246758, -0.404756, -0.280434, -0.324150, -0.357162, -0.375463, -0.362412, -0.386094, -0.450693, -0.458020, -0.406349, -0.433824, -0.550621, -0.524247, -0.470286, -0.527370, -0.644271, -0.524828, -0.565692, -0.617478, -0.634403, -0.598246, -0.619737, },
{ 1.000000,  0.981475,  0.963494,  0.947155,  0.929982,  0.906388,  0.893282,  0.876840,  0.856745,  0.830656,  0.825964,  0.803671,  0.782555,  0.763255,  0.756223,  0.736108,  0.703771,  0.688279,  0.685135,  0.669488,  0.619104,  0.631142,  0.611326,  0.589956,  0.553107,  0.561186,  0.539132,  0.508564,  0.488729,  0.495860,  0.473231,  0.426709,  0.417313,  0.424099,  0.405599,  0.324752,  0.376856,  0.340595,  0.320986,  0.287479,  0.294174,  0.273642,  0.227477,  0.211661,  0.237928,  0.208507,  0.153267,  0.139124,  0.166788,  0.146128,  0.030016,  0.116589,  0.072609,  0.044067,  0.025878,  0.028904,  0.004364, -0.042574, -0.054132, -0.024623, -0.055273, -0.136597, -0.130933, -0.095156, -0.136384, -0.238976, -0.149911, -0.186575, -0.229042, -0.251641, -0.229578, -0.252125, -0.326445, -0.330042, -0.299593, -0.317740, -0.423419, -0.376259, -0.363490, -0.415123, -0.497799, -0.410272, -0.463956, -0.500173, -0.533119, -0.471165, -0.511427, -0.611435, -0.607678, -0.563238, -0.564011, -0.730693, -0.623508, -0.637750, -0.677262, -0.775221, -0.684171, -0.720380, -0.783645, -0.801101, },
{ 1.000000,  0.980918,  0.961921,  0.939512,  0.920686,  0.905343,  0.885415,  0.853306,  0.848803,  0.825448,  0.805859,  0.780118,  0.770206,  0.749589,  0.721744,  0.700880,  0.699357,  0.673289,  0.639366,  0.622276,  0.620304,  0.601073,  0.536678,  0.566565,  0.534241,  0.510039,  0.487780,  0.482453,  0.460457,  0.422143,  0.407717,  0.413885,  0.387186,  0.332950,  0.324959,  0.338657,  0.304095,  0.227405,  0.277998,  0.250696,  0.210900,  0.190378,  0.200691,  0.174989,  0.118837,  0.108195,  0.120237,  0.103717,  0.024274,  0.046503,  0.049994,  0.004901, -0.063454, -0.006376, -0.053478, -0.077274, -0.115575, -0.072742, -0.105824, -0.188150, -0.190525, -0.167831, -0.177030, -0.298232, -0.235244, -0.244464, -0.282521, -0.360106, -0.297456, -0.331358, -0.381379, -0.407300, -0.372806, -0.391752, -0.493185, -0.488079, -0.436531, -0.469259, -0.629382, -0.492298, -0.547659, -0.565403, -0.653934, -0.584352, -0.617819, -0.692585, -0.710395, -0.631314, -0.689551, -0.787250, -0.786907, -0.728678, -0.742262, -0.957270, -0.774151, -0.837622, -0.882778, -0.913541, -0.884679, -0.915377, },
{ 1.000000,  0.978351,  0.956826,  0.938032,  0.916343,  0.890128,  0.868788,  0.855573,  0.831955,  0.793600,  0.792028,  0.769500,  0.741688,  0.719240,  0.707243,  0.685406,  0.650404,  0.632190,  0.624216,  0.602271,  0.556338,  0.551156,  0.544343,  0.510434,  0.465052,  0.482043,  0.447036,  0.422396,  0.392178,  0.400331,  0.374751,  0.315010,  0.306535,  0.311433,  0.293997,  0.211741,  0.241269,  0.229227,  0.189215,  0.138860,  0.168560,  0.132575,  0.096532,  0.069713,  0.087478,  0.062976, -0.016093, -0.020232,  0.010296, -0.018345, -0.141128, -0.052341, -0.100237, -0.118930, -0.191756, -0.151225, -0.179859, -0.241266, -0.264852, -0.209965, -0.260280, -0.336917, -0.341266, -0.313101, -0.325094, -0.490113, -0.357909, -0.411835, -0.455256, -0.494061, -0.468146, -0.501271, -0.570088, -0.572615, -0.529089, -0.564602, -0.670199, -0.684005, -0.608153, -0.660604, -0.834813, -0.680609, -0.715408, -0.779065, -0.815474, -0.783684, -0.805578, -0.903159, -0.904383, -0.858235, -0.884371, -1.029565, -0.968959, -0.921543, -1.000728, -1.112674, -0.992180, -1.060151, -1.108313, -1.140712, },
{ 1.000000,  0.976903,  0.953462,  0.926239,  0.903293,  0.883348,  0.860548,  0.824729,  0.810796,  0.790279,  0.761520,  0.728648,  0.723198,  0.691549,  0.663289,  0.638572,  0.628863,  0.604107,  0.556573,  0.539831,  0.538908,  0.512201,  0.441387,  0.467790,  0.432916,  0.408699,  0.360157,  0.369172,  0.342326,  0.297874,  0.270037,  0.287476,  0.250332,  0.191913,  0.179850,  0.189364,  0.165131,  0.052344,  0.123868,  0.077767,  0.044998,  0.011074,  0.014828, -0.012829, -0.072827, -0.085061, -0.058791, -0.094529, -0.173561, -0.193316, -0.147788, -0.193481, -0.333160, -0.230369, -0.261449, -0.312981, -0.349770, -0.334571, -0.362319, -0.432984, -0.447184, -0.417069, -0.450554, -0.572766, -0.535201, -0.502520, -0.569913, -0.662724, -0.574150, -0.632798, -0.680603, -0.714781, -0.673326, -0.698610, -0.816516, -0.815284, -0.775327, -0.790044, -0.945081, -0.863874, -0.865369, -0.929690, -1.031550, -0.912481, -0.987235, -1.049146, -1.080745, -1.010928, -1.059838, -1.187756, -1.185739, -1.104389, -1.132266, -1.356664, -1.182036, -1.241743, -1.264407, -1.385907, -1.283621, -1.322840, },
{ 1.000000,  0.972434,  0.944825,  0.921334,  0.893527,  0.860870,  0.835002,  0.815749,  0.788952,  0.738862,  0.738574,  0.705381,  0.675100,  0.643821,  0.626522,  0.600963,  0.555810,  0.531980,  0.529833,  0.497494,  0.444879,  0.422419,  0.426201,  0.390006,  0.302173,  0.342392,  0.304584,  0.267136,  0.234593,  0.228819,  0.199459,  0.144975,  0.123876,  0.128756,  0.097128,  0.010523,  0.018276,  0.029179, -0.027242, -0.106866, -0.049468, -0.098678, -0.144553, -0.179536, -0.161768, -0.195449, -0.283220, -0.290736, -0.271789, -0.295086, -0.414799, -0.367434, -0.383023, -0.426980, -0.521710, -0.438546, -0.507567, -0.554256, -0.592563, -0.551678, -0.600045, -0.702825, -0.709379, -0.660345, -0.677995, -0.866135, -0.744720, -0.788744, -0.826655, -0.928763, -0.855421, -0.889155, -0.978666, -1.018835, -0.942799, -0.992259, -1.123015, -1.115877, -1.059846, -1.080645, -1.323591, -1.120371, -1.198565, -1.244414, -1.305305, -1.270578, -1.291204, -1.413510, -1.425589, -1.320413, -1.391854, -1.525478, -1.529649, -1.419178, -1.482079, -1.756967, -1.528313, -1.604346, -1.661347, -1.699796, },
{ 1.000000,  0.968644,  0.936928,  0.902144,  0.870338,  0.844666,  0.811718,  0.766677,  0.741490,  0.721091,  0.680836,  0.630293,  0.628148,  0.588983,  0.549880,  0.515348,  0.499678,  0.466152,  0.408812,  0.383973,  0.373559,  0.343082,  0.266155,  0.270893,  0.247343,  0.202959,  0.135599,  0.163464,  0.110911,  0.065710,  0.026658,  0.035916, -0.005739, -0.085143, -0.106730, -0.086477, -0.116606, -0.251455, -0.189074, -0.230283, -0.272805, -0.351317, -0.310430, -0.356341, -0.423449, -0.463426, -0.423992, -0.475932, -0.575756, -0.586586, -0.553484, -0.592341, -0.774238, -0.638623, -0.712814, -0.751776, -0.818501, -0.788618, -0.834189, -0.927973, -0.950237, -0.883694, -0.944174, -1.059445, -1.078762, -1.007029, -1.061253, -1.293916, -1.104113, -1.191956, -1.246201, -1.285231, -1.263573, -1.309653, -1.402322, -1.421939, -1.358220, -1.421840, -1.587133, -1.558913, -1.479711, -1.574161, -1.763314, -1.568256, -1.652812, -1.729992, -1.783158, -1.724004, -1.766345, -1.913837, -1.919125, -1.849355, -1.883484, -2.100780, -1.988302, -1.959301, -2.060643, -2.215189, -2.038692, -2.146517, },
{ 1.000000,  0.959506,  0.917749,  0.882756,  0.841180,  0.792354,  0.754236,  0.724314,  0.686161,  0.615912,  0.602757,  0.561363,  0.516721,  0.457431,  0.448149,  0.401869,  0.346720,  0.303458,  0.292898,  0.246422,  0.170038,  0.141995,  0.136829,  0.088463, -0.030853,  0.018656, -0.043512, -0.086767, -0.154492, -0.148030, -0.197975, -0.270380, -0.312201, -0.285704, -0.352547, -0.447208, -0.475240, -0.453224, -0.504591, -0.680777, -0.565014, -0.646751, -0.700341, -0.757015, -0.745037, -0.791759, -0.886419, -0.915499, -0.887010, -0.949081, -1.093006, -1.084773, -1.038450, -1.132926, -1.307165, -1.153597, -1.230990, -1.319786, -1.375252, -1.327589, -1.383579, -1.520603, -1.540832, -1.497718, -1.530149, -1.734417, -1.649223, -1.640765, -1.742254, -1.898591, -1.750464, -1.861569, -1.912355, -2.002806, -1.886735, -1.966318, -2.150474, -2.151268, -2.080261, -2.108313, -2.406551, -2.228861, -2.266848, -2.344049, -2.501434, -2.349079, -2.428261, -2.538844, -2.609958, -2.508324, -2.567518, -2.780285, -2.762675, -2.642775, -2.719917, -3.075074, -2.762689, -2.881737, -2.935406, -3.109466, },
{ 1.000000,  0.940402,  0.879543,  0.813941,  0.753064,  0.705294,  0.639238,  0.559021,  0.506497,  0.464561,  0.398514,  0.287496,  0.289689,  0.213424,  0.140158,  0.070304,  0.037370, -0.025051, -0.115304, -0.166860, -0.190091, -0.262323, -0.396492, -0.427104, -0.425866, -0.524796, -0.678863, -0.597857, -0.677439, -0.786179, -0.859811, -0.858187, -0.921562, -1.064281, -1.103386, -1.096898, -1.161386, -1.360575, -1.311469, -1.323408, -1.444911, -1.588836, -1.491653, -1.602052, -1.693605, -1.787790, -1.729834, -1.814362, -2.026798, -2.025520, -1.981091, -2.045357, -2.351787, -2.190207, -2.246627, -2.376354, -2.504838, -2.383941, -2.492550, -2.627092, -2.714514, -2.626375, -2.718188, -2.977857, -2.949940, -2.847284, -2.950898, -3.330378, -3.027136, -3.176113, -3.275234, -3.462570, -3.311648, -3.396246, -3.594415, -3.639251, -3.484386, -3.635523, -3.905529, -3.867658, -3.773976, -3.865176, -4.297864, -3.897642, -4.070533, -4.221112, -4.349481, -4.227726, -4.304920, -4.526690, -4.529261, -4.411148, -4.517897, -4.912129, -4.841248, -4.645702, -4.871029, -5.262256, -4.783065, -4.928121, },
};
