#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include "flow.h"

// th added file

void Convert(int, char*);

int main (int argc, char *argv[]) {

    char *sendpkg;
    sendpkg = calloc(1, DATA_PACKAGE_ID);

    if (sendpkg == NULL) {
	printf("we couldn't allocate memory. it seems that you have a big problem, dude...\n");
 	return 0;
    }

    int pid = getpid();
    int fd, fproc, count;

    /* wait or the flowseed process will die randomly.
     * there is some kind of a race condition if cnistnet
     * starts flowseed and the kernel prepares the flowbuffer.
     * the flowseed process gets killed by a supernaturally
     * force without any word...
     */
    sleep(1);

    /*
    int head, delay;
    char string[33];    // assuming 32bit integers
    int mask_head = -536870912; // 11100000000000000000000000000000
    int mask_delay = 536870911; // 00011111111111111111111111111111
    */

    if (argc < 2) {
      printf("Give input filename as first argument!\n");
      return 0;
    }

    if ((fd = open(argv[1], O_RDONLY,0)) < 0) {
        fprintf(stderr, "Cannot open input file\n");
	return 0;
    }

    if ((fproc = open("/proc/nistnet/input", O_WRONLY,0)) < 0) {
        fprintf(stderr, "Cannot open procfs. Module loaded?\n");
	return 0;
    }

    int debugout,r,w, flowid;
    flowid = atoi(argv[2]);
    
    //printf("my pid: %d\n", pid);
    //printf("my flowid: %d\n", flowid);

    while ((r = read(fd, sendpkg, DATA_PACKAGE))) {

	// debug put to loop
	/*
	if (r < DATA_PACKAGE) {
		lseek(fd, 0, 0);
		printf("Reached EOF, continuing from start, skipping rest.\n");
		continue;
	}
	*/

	if (r < DATA_PACKAGE) {
		printf("Tail of input file reached. "
		    "Not enough Data, dropping rest: %d Bytes. Exit.\n", r);
		
		close(fd);
		close(fproc);
		free(sendpkg);
		return 0;
	}
       
        // write our pid and the flowid in the package	
	memcpy(sendpkg+DATA_PACKAGE, &pid,4);
	memcpy(sendpkg+DATA_PACKAGE+4, &flowid,4);

	// debug
	count=0;
	while (count < DATA_PACKAGE) {
	
		memcpy(&debugout, sendpkg+count,4);
		//printf("checking... count: %d  -  %d\n", count, debugout);
		count+=4;
	}
		memcpy(&debugout, sendpkg+count,4);
		//printf("checking... pid:   %d  -  %d\n", count, debugout);
		memcpy(&debugout, sendpkg+count+4,4);
		//printf("checking... flowid: %d  -  %d\n", count+4, debugout);

    	// actually writing to kernel (procfs)
	w = write(fproc, sendpkg, DATA_PACKAGE_ID); 

	if (w < 0) {
		printf("FATAL ERROR: Failure writing to procfs. exitting...\n");
    		close(fd);
		close(fproc);
		close(fproc);
		return 0;
	}

       	//printf("wrote chunk size %d bytes.\n", w);
    }
		
    printf("Tail of input file reached. Exit.\n");

    close(fd);
    close(fproc);
    free(sendpkg);

    return 0;
}


void Convert(int bin, char *str)
{
    unsigned int mask;      // used to check each individual bit, unsigned 
                            //    to alleviate sign extension problems

    mask = 0x80000000;      // Set only the high-end bit
    while (mask)            // Loop until MASK is empty
    {
        if (bin & mask)     // test the masked bit
              *str = '1';   // if true, value is 1
          else
              *str = '0';   // if false, value is 0
        str++;              // next character
        mask >>= 1;         // shift the mask 1 bit
    }
    *str = 0;               // add the trailing null 
}

