#ifndef __CLASS_MAIN_WINDOW_HPP__
#define __CLASS_MAIN_WINDOW_HPP__

#include "classNistnetEngine.hpp"

class classMainWindow;
//--------------------------------------------------------------------------------------------
class classMainWindow {
private:
    // data
    int selectedRow;

    // GTK+ Widgets
    GtkWidget *gwMainWindow;
    GtkWidget *gwHbox;

    GtkWidget *gwVbox1;
    GtkWidget *gwClistScrWindow;
    GtkWidget *gwClist;
    GtkWidget *gwHbox11;
      GtkWidget *gwOnOff;
      GtkWidget *gwStringsOnOff;
      GtkWidget *gwReread;

    GtkWidget *gwVbox2;
    GtkWidget *gwLabelSrc;
    GtkWidget *gwHbox21;
      GtkWidget *gwEntrySrcIp;
      GtkWidget *gwLabelSrcPort;
      GtkWidget *gwEntrySrcPort;
    GtkWidget *gwLabelDst;
    GtkWidget *gwHbox22;
      GtkWidget *gwEntryDstIp;
      GtkWidget *gwLabelDstPort;
      GtkWidget *gwEntryDstPort;
    GtkWidget *gwLabelProto;
    GtkWidget *gwHbox23;
      GtkWidget *gwEntryProto;
      GtkWidget *gwCheckProtocol;
      GtkWidget *gwCheckChecksum;
    GtkWidget *gwLabelBW;
    GtkWidget *gwEntryBW;
    GtkWidget *gwLabelDelay;
    GtkWidget *gwEntryDelay;
    GtkWidget *gwLabelDrop;
    GtkWidget *gwEntryDrop;
    GtkWidget *gwLabelDup;
    GtkWidget *gwEntryDup;
    GtkWidget *gwLabelChangePacket;
    GtkWidget *gwEntryChangePacket;
    GtkWidget *gwLabelChangeByte;
    GtkWidget *gwEntryChangeByte;
    GtkWidget *gwHbox24;
      GtkWidget *gwButtonUpdate;
      GtkWidget *gwButtonRemove;

    // nisnet engine
    classNistnetEngine *nist;

    // signal handlers - static! + special
    static void gsignalDestroy(GtkWidget *widget, classMainWindow *data);
    // Buttons
    static void gsignalOnOff(GtkWidget *widget, classMainWindow *data);
    static void gsignalStringsOnOff(GtkWidget *widget, classMainWindow *data);
    static void gsignalReread(GtkWidget *widget, classMainWindow *data);
    static void gsignalUpdate(GtkWidget *widget, classMainWindow *data);
    static void gsignalRemove(GtkWidget *widget, classMainWindow *data);
    // CList
    static void gsignalSelected(GtkWidget *widget,
                                gint row, gint col,
                                GdkEventButton *event,
                                classMainWindow *data
                               );
    static void gsignalUnSelected(GtkWidget *widget,
                                  gint row, gint col,
                                  GdkEventButton *event,
                                  classMainWindow *data
                                 );

    void makeProtocolString(char *string, int size, int protocol);
    int  makeProtocolNum(const char *string);
    void makePortString(char *string, int size, int port,const char* proto);
    int  makePortNum(const char *string, const char* proto);
    int  isNum(const char *string);


public:

    // constructor & destructor + special
    classMainWindow();
    ~classMainWindow();

    //data update calls.
    int updateList();
    int updateOnOff();
    int updateForm(int row);
    int clearForm();
    int removeRow();
    int updateRow();

    //standard GUI calls
    void enable();
    void disable();
    void show();
    void hide();
};

//--------------------------------------------------------------------------------------------
#endif
